/*
 * Decompiled with CFR 0.152.
 */
package de.isuewo.euphoria_patcher;

import de.isuewo.euphoria_patcher.ArchiveUtils;
import de.isuewo.euphoria_patcher.SodiumConsole;
import io.sigpipe.jbsdiff.InvalidHeaderException;
import io.sigpipe.jbsdiff.ui.FileUI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.io.FileUtils;

public class EuphoriaPatcher
implements ModInitializer {
    private static boolean isSodiumLoaded;

    private static void log(int messageLevel, String message) {
        if (isSodiumLoaded) {
            SodiumConsole.logMessage(messageLevel, message);
        }
        if (messageLevel == 2) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    public void onInitialize() {
        Path temp;
        boolean isAlreadyInstalled;
        boolean styleUnbound;
        boolean styleReimagined;
        Path baseFile;
        Path shaderpacks;
        block56: {
            try {
                Class.forName("me.jellysquid.mods.sodium.client.gui.console.Console");
                isSodiumLoaded = true;
            }
            catch (ClassNotFoundException e) {
                isSodiumLoaded = false;
            }
            boolean isDev = false;
            shaderpacks = FabricLoader.getInstance().getGameDir().resolve("shaderpacks");
            String downloadURL = "https://www.complementary.dev/";
            String brandName = "ComplementaryShaders";
            String version = "_r5.2.1";
            String patchName = "EuphoriaPatches";
            String patchVersion = "_1.3.1";
            String commonLocation = "shaders/lib/common.glsl";
            baseFile = null;
            styleReimagined = false;
            styleUnbound = false;
            isAlreadyInstalled = false;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, path -> {
                String name = path.getFileName().toString();
                return name.matches("Complementary.+?(?=_r5.2.1)_r5.2.1(?!\\.[0-9]).*") && name.endsWith(".zip") && !name.contains("EuphoriaPatches");
            });){
                for (Path path2 : stream) {
                    String name = path2.getFileName().toString();
                    if (!name.endsWith(".zip")) continue;
                    if (name.contains("Reimagined")) {
                        styleReimagined = true;
                        if (baseFile == null) {
                            baseFile = path2;
                        }
                    } else if (name.contains("Unbound")) {
                        styleUnbound = true;
                        if (baseFile == null) {
                            baseFile = path2;
                        }
                    }
                    if (baseFile != null && Files.exists(shaderpacks.resolve(baseFile.getFileName().toString().replace(".zip", "") + " + " + "EuphoriaPatches" + "_1.3.1"), new LinkOption[0])) {
                        baseFile = null;
                        isAlreadyInstalled = true;
                    }
                    if (!styleReimagined || !styleUnbound) continue;
                    break;
                }
                if (styleReimagined || styleUnbound) break block56;
                try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(shaderpacks, path -> {
                    String name = path.getFileName().toString();
                    return name.matches("Complementary.+?(?=_r5.2.1)_r5.2.1(?!\\.[0-9]).*") && Files.isDirectory(path, new LinkOption[0]);
                });){
                    for (Path potentialFile : stream2) {
                        String name = potentialFile.getFileName().toString();
                        if (name.contains("EuphoriaPatches")) {
                            if (!name.contains("EuphoriaPatches_1.3.1")) continue;
                            isAlreadyInstalled = true;
                            continue;
                        }
                        if (name.contains("Reimagined")) {
                            styleReimagined = true;
                            if (baseFile == null) {
                                baseFile = potentialFile;
                            }
                        } else if (name.contains("Unbound")) {
                            styleUnbound = true;
                            if (baseFile == null) {
                                baseFile = potentialFile;
                            }
                        }
                        if (!styleReimagined || !styleUnbound) continue;
                        break;
                    }
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(2, "Error reading shaderpacks directory" + e.getMessage());
                return;
            }
        }
        if (baseFile == null) {
            if (!isAlreadyInstalled) {
                EuphoriaPatcher.log(1, "You need to have ComplementaryShaders_r5.2.1 installed. Please download it from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft.");
            }
            return;
        }
        try {
            temp = Files.createTempDirectory("euphoria-patcher-", new FileAttribute[0]);
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error creating temporary directory" + e.getMessage());
            return;
        }
        String baseName = baseFile.getFileName().toString().replace(".zip", "");
        String string = baseName + " + " + "EuphoriaPatches" + "_1.3.1";
        Path baseExtracted = temp.resolve(baseName);
        if (!Files.isDirectory(baseFile, new LinkOption[0])) {
            ArchiveUtils.extract(baseFile, baseExtracted);
        } else {
            baseExtracted = baseFile;
        }
        try {
            Path commons = baseExtracted.resolve("shaders/lib/common.glsl");
            String config = FileUtils.readFileToString((File)commons.toFile(), (String)"UTF-8").replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 1");
            FileUtils.writeStringToFile((File)commons.toFile(), (String)config, (String)"UTF-8");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error extracting style information from " + baseName + e.getMessage());
            return;
        }
        String baseTarHash = "0385e8a5496263612aa1f27ec3418e39";
        int baseTarSize = 1270272;
        Path baseArchived = temp.resolve(baseName + ".tar");
        ArchiveUtils.archive(baseExtracted, baseArchived);
        Path patchedFile = shaderpacks.resolve(string);
        try {
            String hash = DigestUtils.md5Hex((byte[])Arrays.copyOf(Files.readAllBytes(baseArchived), 1270272));
            if (!hash.equals("0385e8a5496263612aa1f27ec3418e39")) {
                EuphoriaPatcher.log(1, "The version of ComplementaryShaders that was found in your shaderpacks can't be used as a base for EuphoriaPatches. Please download ComplementaryShaders_r5.2.1 from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft.");
                return;
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(1, "The version of ComplementaryShaders that was found in your shaderpacks can't be used as a base for EuphoriaPatches. Please download ComplementaryShaders_r5.2.1 from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft." + e.getMessage());
            return;
        }
        Path patchedArchive = temp.resolve(string + ".tar");
        Path patchFile = temp.resolve(string + ".patch");
        try (InputStream patchStream = this.getClass().getClassLoader().getResourceAsStream("EuphoriaPatches_1.3.1.patch");){
            FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(patchStream), (File)patchFile.toFile());
            FileUI.patch((File)baseArchived.toFile(), (File)patchedArchive.toFile(), (File)patchFile.toFile());
            ArchiveUtils.extract(patchedArchive, patchedFile);
        }
        catch (InvalidHeaderException | IOException | CompressorException e) {
            EuphoriaPatcher.log(2, "Error applying patch file." + e.getMessage());
            return;
        }
        if (styleUnbound) {
            try {
                File commons = new File(patchedFile.toFile(), "shaders/lib/common.glsl");
                String UnboundConfig = FileUtils.readFileToString((File)commons, (String)"UTF-8").replaceFirst("SHADER_STYLE 1", "SHADER_STYLE 4");
                if (!styleReimagined) {
                    FileUtils.writeStringToFile((File)commons, (String)UnboundConfig, (String)"UTF-8");
                } else if (baseName.contains("Reimagined")) {
                    File unbound = new File(shaderpacks.toFile(), string.replace("Reimagined", "Unbound"));
                    FileUtils.copyDirectory((File)patchedFile.toFile(), (File)unbound);
                    FileUtils.writeStringToFile((File)new File(unbound, "shaders/lib/common.glsl"), (String)UnboundConfig, (String)"UTF-8");
                } else {
                    File reimagined = new File(shaderpacks.toFile(), string.replace("Unbound", "Reimagined"));
                    FileUtils.copyDirectory((File)patchedFile.toFile(), (File)reimagined);
                    FileUtils.writeStringToFile((File)commons, (String)UnboundConfig, (String)"UTF-8");
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(2, "Error applying style settings." + e.getMessage());
                return;
            }
        }
        EuphoriaPatcher.log(0, "EuphoriaPatches was successfully installed. Enjoy! -SpacEagle17 & isuewo");
    }
}

