/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jeresources.config.Settings;
import jeresources.json.ProfilingAdapter;
import jeresources.profiling.ChunkGetter;
import jeresources.profiling.DummyWorld;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingBlacklist;
import jeresources.profiling.ProfilingExecutor;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.DimensionHelper;
import jeresources.util.LogHelper;
import net.minecraft.class_1132;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class Profiler
implements Runnable {
    private final ConcurrentMap<class_5321<class_1937>, ProfiledDimensionData> allDimensionData;
    private final ProfilingTimer timer;
    private final class_1297 sender;
    private final ProfilingBlacklist blacklist;
    private final int chunkCount;
    private final boolean allDimensions;
    private ProfilingExecutor currentExecutor;
    private static Profiler currentProfiler;

    private Profiler(class_1297 sender, int chunkCount, boolean allDimensions) {
        this.sender = sender;
        this.allDimensionData = new ConcurrentHashMap<class_5321<class_1937>, ProfiledDimensionData>();
        this.chunkCount = chunkCount;
        this.timer = new ProfilingTimer((class_2165)sender, chunkCount);
        this.allDimensions = allDimensions;
        this.blacklist = new ProfilingBlacklist();
    }

    @Override
    public void run() {
        if (!this.allDimensions) {
            class_5321 worldKey = this.sender.method_37908().method_27983();
            this.profileWorld((class_5321<class_1937>)worldKey);
        } else {
            for (class_5321 worldKey : this.sender.method_5682().method_29435()) {
                this.profileWorld((class_5321<class_1937>)worldKey);
            }
        }
        this.writeData();
        this.timer.complete();
    }

    private void profileWorld(class_5321<class_1937> dimensionKey) {
        ProfilingExecutor executor;
        class_1132 server = class_310.method_1551().method_1576();
        class_3218 world = server.method_3847(dimensionKey);
        if (world == null) {
            String msg = "Unable to profile dimension " + DimensionHelper.getDimensionName(dimensionKey) + ".  There is no world for it.";
            LogHelper.error(msg, new Object[0]);
            this.sender.method_43496((class_2561)class_2561.method_43470((String)msg));
            return;
        }
        class_3218 serverLevel = world;
        String msg = "Inspecting dimension " + DimensionHelper.getDimensionName(dimensionKey) + ". ";
        this.sender.method_43496((class_2561)class_2561.method_43470((String)msg));
        LogHelper.info(msg, new Object[0]);
        if (Settings.excludedDimensions.contains(dimensionKey.method_29177().toString())) {
            msg = "Skipped dimension " + DimensionHelper.getDimensionName(dimensionKey) + " during profiling";
            LogHelper.info(msg, new Object[0]);
            this.sender.method_43496((class_2561)class_2561.method_43470((String)msg));
            return;
        }
        this.currentExecutor = executor = new ProfilingExecutor(this);
        this.allDimensionData.put(dimensionKey, new ProfiledDimensionData());
        DummyWorld dummyWorld = new DummyWorld(serverLevel);
        ChunkGetter chunkGetter = new ChunkGetter(this.chunkCount, dummyWorld, executor);
        serverLevel.method_8503().method_3742((Runnable)chunkGetter);
        executor.awaitTermination();
        this.currentExecutor = null;
    }

    public ProfilingTimer getTimer() {
        return this.timer;
    }

    public ProfilingBlacklist getBlacklist() {
        return this.blacklist;
    }

    public ConcurrentMap<class_5321<class_1937>, ProfiledDimensionData> getAllDimensionData() {
        return this.allDimensionData;
    }

    private void writeData() {
        HashMap<class_5321<class_1937>, ProfilingAdapter.DimensionData> allData = new HashMap<class_5321<class_1937>, ProfilingAdapter.DimensionData>();
        for (class_5321 worldRegistryKey : this.allDimensionData.keySet()) {
            ProfiledDimensionData profiledData = (ProfiledDimensionData)this.allDimensionData.get(worldRegistryKey);
            ProfilingAdapter.DimensionData data = new ProfilingAdapter.DimensionData();
            data.dropsMap = profiledData.dropsMap;
            data.silkTouchMap = profiledData.silkTouchMap;
            for (Map.Entry entry : profiledData.distributionMap.entrySet()) {
                Float[] array = new Float[256];
                for (int i = 0; i < 256; ++i) {
                    array[i] = Float.valueOf((float)((Integer[])entry.getValue())[i].intValue() * 1.0f / (float)this.timer.getBlocksPerLayer((class_5321<class_1937>)worldRegistryKey));
                }
                data.distribution.put((String)entry.getKey(), array);
            }
            allData.put((class_5321<class_1937>)worldRegistryKey, data);
        }
        ProfilingAdapter.write(allData);
    }

    public static boolean init(class_1297 sender, int chunks, boolean allWorlds) {
        sender.method_43496((class_2561)class_2561.method_43470((String)"Command not yet re-implemented, profiling will be re-added in the future"));
        return true;
    }

    public static boolean stop(class_1297 sender) {
        sender.method_43496((class_2561)class_2561.method_43470((String)"Command not yet re-implemented, profiling will be re-added in the future"));
        return true;
    }
}

