/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.mightymail.mail;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.mightymail.Config;
import com.mrcrayfish.mightymail.Constants;
import com.mrcrayfish.mightymail.blockentity.MailboxBlockEntity;
import com.mrcrayfish.mightymail.mail.Mailbox;
import com.mrcrayfish.mightymail.network.Network;
import com.mrcrayfish.mightymail.network.message.MessageUpdateMailboxes;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class DeliveryService
extends class_18 {
    private static final String STORAGE_ID = "refurbished_furniture_delivery_service";
    private final MinecraftServer server;
    private final Map<Pair<class_2960, class_2338>, Mailbox> locator = new HashMap<Pair<class_2960, class_2338>, Mailbox>();
    private final Map<UUID, Mailbox> mailboxes = new ConcurrentHashMap<UUID, Mailbox>();
    private final Queue<Mailbox> removal = new ArrayDeque<Mailbox>();
    private final Map<UUID, Pair<class_2960, class_2338>> pendingNames = new HashMap<UUID, Pair<class_2960, class_2338>>();
    private final Set<UUID> playerRequests = new HashSet<UUID>();

    public static Optional<DeliveryService> get(MinecraftServer server) {
        class_3218 level = server.method_3847(class_1937.field_25179);
        if (level != null) {
            return Optional.of((DeliveryService)level.method_17983().method_17924(tag -> new DeliveryService(server, (class_2487)tag), () -> new DeliveryService(server), STORAGE_ID));
        }
        return Optional.empty();
    }

    public DeliveryService(MinecraftServer server) {
        this(server, new class_2487());
    }

    public DeliveryService(MinecraftServer server, class_2487 compound) {
        this.server = server;
        this.load(compound);
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void serverTick() {
        while (!this.removal.isEmpty()) {
            Mailbox mailbox2 = this.removal.poll();
            mailbox2.spawnQueueIntoLevel();
            this.mailboxes.remove(mailbox2.id());
            this.locator.remove(Pair.of((Object)mailbox2.levelKey().method_29177(), (Object)mailbox2.pos()));
            this.method_80();
        }
        this.mailboxes.forEach((uuid, mailbox) -> mailbox.tick());
    }

    public void playerLoggedOut(class_3222 player) {
        this.playerRequests.remove(player.method_5667());
    }

    public boolean sendMail(UUID id, class_1799 stack) {
        Mailbox mailbox = this.mailboxes.get(id);
        if (mailbox != null && mailbox.queue().size() < (Integer)Config.SERVER.mailQueueSize.get()) {
            mailbox.queue().offer(stack);
            return true;
        }
        return false;
    }

    void removeMailbox(Mailbox mailbox) {
        this.removal.offer(mailbox);
    }

    public Mailbox getOrCreateMailBox(MailboxBlockEntity blockEntity) {
        return this.mailboxes.computeIfAbsent(blockEntity.getId(), uuid -> {
            class_5321 levelKey = blockEntity.method_10997().method_27983();
            class_2338 pos = blockEntity.method_11016();
            Mailbox mailbox = new Mailbox((UUID)uuid, (class_5321<class_1937>)levelKey, pos, (MutableObject<UUID>)new MutableObject(), (MutableObject<String>)new MutableObject((Object)""), (Queue<class_1799>)new ArrayDeque<class_1799>(), new MutableBoolean(), this);
            this.locator.put((Pair<class_2960, class_2338>)Pair.of((Object)levelKey.method_29177(), (Object)pos), mailbox);
            this.method_80();
            return mailbox;
        });
    }

    public Optional<Mailbox> getMailboxAtPosition(class_1937 level, class_2338 pos) {
        return Optional.ofNullable(this.locator.get(Pair.of((Object)level.method_27983().method_29177(), (Object)pos)));
    }

    public void markMailboxAsPendingName(class_1657 player, class_1937 level, class_2338 pos) {
        this.pendingNames.put(player.method_5667(), (Pair<class_2960, class_2338>)Pair.of((Object)level.method_27983().method_29177(), (Object)pos));
    }

    public boolean renameMailbox(class_1657 player, class_1937 level, class_2338 pos, String customName) {
        Pair<class_2960, class_2338> pendingLocation = this.pendingNames.remove(player.method_5667());
        return this.getMailboxAtPosition(level, pos).map(mailbox -> {
            if (!Objects.equals(mailbox.owner().getValue(), player.method_5667())) {
                return false;
            }
            Pair location = Pair.of((Object)level.method_27983().method_29177(), (Object)pos);
            return Objects.equals(location, pendingLocation) && mailbox.rename(customName);
        }).orElse(false);
    }

    public void sendMailboxesToPlayer(class_3222 player) {
        if (!this.playerRequests.contains(player.method_5667())) {
            Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageUpdateMailboxes(this.mailboxes.values()));
            this.playerRequests.add(player.method_5667());
        }
    }

    public void method_80() {
        super.method_80();
        this.playerRequests.clear();
    }

    private void load(class_2487 compound) {
        if (compound.method_10573("Mailboxes", 9)) {
            class_2499 list = compound.method_10554("Mailboxes", 10);
            list.forEach(tag -> {
                try {
                    class_2487 mailboxTag = (class_2487)tag;
                    class_5321<class_1937> levelKey = DeliveryService.createLevelKey(mailboxTag.method_10558("Level"));
                    if (levelKey == null) {
                        Constants.LOG.error("Failed to load a mailbox due to invalid dimension");
                        return;
                    }
                    UUID id = mailboxTag.method_25926("UUID");
                    class_2338 pos = class_2338.method_10092((long)mailboxTag.method_10537("BlockPosition"));
                    MutableObject owner = new MutableObject();
                    if (mailboxTag.method_10573("Owner", 11)) {
                        owner.setValue((Object)mailboxTag.method_25926("Owner"));
                    }
                    String customName = mailboxTag.method_10558("CustomName");
                    customName = customName.substring(0, Math.min(customName.length(), 32));
                    Queue<class_1799> queue = Mailbox.readQueueListTag(mailboxTag);
                    Mailbox mailbox = new Mailbox(id, levelKey, pos, (MutableObject<UUID>)owner, (MutableObject<String>)new MutableObject((Object)customName), queue, new MutableBoolean(), this);
                    this.mailboxes.putIfAbsent(id, mailbox);
                    this.locator.put((Pair<class_2960, class_2338>)Pair.of((Object)levelKey.method_29177(), (Object)pos), mailbox);
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load a mailbox due to invalid data");
                }
            });
        }
    }

    public class_2487 method_75(class_2487 compound) {
        class_2499 list = new class_2499();
        this.mailboxes.forEach((uuid, mailbox) -> {
            if (!mailbox.removed().booleanValue()) {
                class_2487 mailboxTag = new class_2487();
                mailboxTag.method_25927("UUID", uuid);
                mailboxTag.method_10582("Level", mailbox.levelKey().method_29177().toString());
                mailboxTag.method_10544("BlockPosition", mailbox.pos().method_10063());
                Optional.ofNullable((UUID)mailbox.owner().getValue()).ifPresent(id -> mailboxTag.method_25927("Owner", id));
                Optional.ofNullable((String)mailbox.customName().getValue()).ifPresent(name -> mailboxTag.method_10582("CustomName", name));
                mailbox.writeQueue(mailboxTag);
                list.add((Object)mailboxTag);
            }
        });
        compound.method_10566("Mailboxes", (class_2520)list);
        return compound;
    }

    @Nullable
    private static class_5321<class_1937> createLevelKey(String levelKey) {
        class_5321 class_53212;
        if (levelKey.isBlank()) {
            class_53212 = null;
        } else {
            switch (levelKey) {
                case "minecraft:overworld": {
                    class_53212 = class_1937.field_25179;
                    break;
                }
                case "minecraft:the_nether": {
                    class_53212 = class_1937.field_25180;
                    break;
                }
                case "minecraft:the_end": {
                    class_53212 = class_1937.field_25181;
                    break;
                }
                default: {
                    class_53212 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(levelKey));
                }
            }
        }
        return class_53212;
    }
}

