/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.network;

import com.google.gson.Gson;
import java.util.List;
import net.bettercombat.config.ServerConfig;
import net.bettercombat.logic.AnimatedHand;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class Packets {

    public static class ConfigSync {
        public static class_2960 ID = new class_2960("bettercombat", "config_sync");

        public static class_2540 write(ServerConfig config) {
            Gson gson = new Gson();
            String json = gson.toJson((Object)config);
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10814(json);
            return buffer;
        }

        public static ServerConfig read(class_2540 buffer) {
            Gson gson = new Gson();
            String json = buffer.method_19772();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return config;
        }
    }

    public static class WeaponRegistrySync {
        public static class_2960 ID = new class_2960("bettercombat", "weapon_registry");
    }

    public record AttackSound(double x, double y, double z, String soundId, float volume, float pitch, long seed) {
        public static class_2960 ID = new class_2960("bettercombat", "attack_sound");

        public class_2540 write() {
            class_2540 buffer = PacketByteBufs.create();
            buffer.writeDouble(this.x);
            buffer.writeDouble(this.y);
            buffer.writeDouble(this.z);
            buffer.method_10814(this.soundId);
            buffer.writeFloat(this.volume);
            buffer.writeFloat(this.pitch);
            buffer.writeLong(this.seed);
            return buffer;
        }

        public static AttackSound read(class_2540 buffer) {
            double x = buffer.readDouble();
            double y = buffer.readDouble();
            double z = buffer.readDouble();
            String soundId = buffer.method_19772();
            float volume = buffer.readFloat();
            float pitch = buffer.readFloat();
            long seed = buffer.readLong();
            return new AttackSound(x, y, z, soundId, volume, pitch, seed);
        }
    }

    public record AttackAnimation(int playerId, AnimatedHand animatedHand, String animationName, float length, float upswing) {
        public static class_2960 ID = new class_2960("bettercombat", "attack_animation");
        public static String StopSymbol = "!STOP!";

        public static AttackAnimation stop(int playerId, int length) {
            return new AttackAnimation(playerId, AnimatedHand.MAIN_HAND, StopSymbol, length, 0.0f);
        }

        public class_2540 write() {
            class_2540 buffer = PacketByteBufs.create();
            buffer.writeInt(this.playerId);
            buffer.writeInt(this.animatedHand.ordinal());
            buffer.method_10814(this.animationName);
            buffer.writeFloat(this.length);
            buffer.writeFloat(this.upswing);
            return buffer;
        }

        public static AttackAnimation read(class_2540 buffer) {
            int playerId = buffer.readInt();
            AnimatedHand animatedHand = AnimatedHand.values()[buffer.readInt()];
            String animationName = buffer.method_19772();
            float length = buffer.readFloat();
            float upswing = buffer.readFloat();
            return new AttackAnimation(playerId, animatedHand, animationName, length, upswing);
        }
    }

    public record C2S_AttackRequest(int comboCount, boolean isSneaking, int selectedSlot, int[] entityIds) {
        public static class_2960 ID = new class_2960("bettercombat", "c2s_request_attack");
        public static boolean UseVanillaPacket = true;

        public C2S_AttackRequest(int comboCount, boolean isSneaking, int selectedSlot, List<class_1297> entities) {
            this(comboCount, isSneaking, selectedSlot, C2S_AttackRequest.convertEntityList(entities));
        }

        private static int[] convertEntityList(List<class_1297> entities) {
            int[] ids = new int[entities.size()];
            for (int i = 0; i < entities.size(); ++i) {
                ids[i] = entities.get(i).method_5628();
            }
            return ids;
        }

        public class_2540 write() {
            class_2540 buffer = PacketByteBufs.create();
            buffer.writeInt(this.comboCount);
            buffer.writeBoolean(this.isSneaking);
            buffer.writeInt(this.selectedSlot);
            buffer.method_10806(this.entityIds);
            return buffer;
        }

        public static C2S_AttackRequest read(class_2540 buffer) {
            int comboCount = buffer.readInt();
            boolean isSneaking = buffer.readBoolean();
            int selectedSlot = buffer.readInt();
            int[] ids = buffer.method_10787();
            return new C2S_AttackRequest(comboCount, isSneaking, selectedSlot, ids);
        }
    }
}

