/*
 * Decompiled with CFR 0.152.
 */
package net.architects.BigEndCitiesMod.config;

import com.mojang.datafixers.util.Pair;
import net.architects.BigEndCitiesMod.config.ModConfigProvider;
import net.architects.BigEndCitiesMod.config.SimpleConfig;

public class ModConfigs {
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    public static int MAX_DEPTH;
    public static int MAX_DEPTH_PRE;
    public static int MAX_SHIPS;
    public static int MAX_FAT_TOWERS;
    public static int Bridge_Length;
    public static boolean MoreBranches;
    public static boolean MoreLootRooms;

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        CONFIG = SimpleConfig.of("bigendcitiesmodconfig").provider(configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"MaximumDepth", (Object)8), "Higher means more Junctions");
        configs.addKeyValuePair(new Pair((Object)"MaximumShips", (Object)1), "Best value is 10 to allow for many ships");
        configs.addKeyValuePair(new Pair((Object)"MaximumMiddleTowers", (Object)2), "Best Value is 3-6");
        configs.addKeyValuePair(new Pair((Object)"BridgeLength", (Object)"short"), "Choose between: short, medium, long. Best for large cities is medium");
        configs.addKeyValuePair(new Pair((Object)"PrioritizeBranching", (Object)false), "Setting this to true will make more branches occur. Can cause more overlap. Best is true");
        configs.addKeyValuePair(new Pair((Object)"MoreLootRooms", (Object)false), "This will make more 3 layer buildings spawn. This will also make the cities much taller. Best is true");
    }

    private static void assignConfigs() {
        MAX_DEPTH_PRE = CONFIG.getOrDefault("MaximumDepth", 8);
        MAX_SHIPS = CONFIG.getOrDefault("MaximumShips", 8);
        MAX_FAT_TOWERS = CONFIG.getOrDefault("MaximumMiddleTowers", 8);
        String bridge_Length_String = CONFIG.getOrDefault("BridgeLength", "short");
        MoreBranches = CONFIG.getOrDefault("PrioritizeBranching", false);
        MoreLootRooms = CONFIG.getOrDefault("MoreLootRooms", false);
        MAX_DEPTH = MAX_DEPTH_PRE < 8 ? 8 : MAX_DEPTH_PRE;
        Bridge_Length = bridge_Length_String.equalsIgnoreCase("short") ? 4 : (bridge_Length_String.equalsIgnoreCase("medium") ? 8 : (bridge_Length_String.equalsIgnoreCase("long") ? 12 : 4));
        System.out.println("All " + configs.getConfigsList().size() + " have been set properly");
    }

    static {
        MAX_DEPTH = 8;
        MAX_DEPTH_PRE = 8;
        MAX_SHIPS = 3;
        MAX_FAT_TOWERS = 8;
        Bridge_Length = 6;
    }
}

