/*
 * Decompiled with CFR 0.152.
 */
package com.aqupd.caracal.entity;

import com.aqupd.caracal.CaracalMain;
import com.aqupd.caracal.ai.CaracalSitOnBlockGoal;
import com.aqupd.caracal.setup.CaracalSounds;
import com.aqupd.caracal.utils.AqConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1371;
import net.minecraft.class_1374;
import net.minecraft.class_1379;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1403;
import net.minecraft.class_1404;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1463;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.example.entity.BatEntity;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CaracalEntity
extends class_1321
implements GeoEntity {
    private static final class_1856 TAMING_INGREDIENT;
    private static final class_2940<Boolean> IN_SLEEPING_POSE;
    private static final class_2940<Integer> CARACAL_BIRTHDAY_COLOR;
    private static final class_2940<Integer> CURRENT_ANIMATION;
    private boolean songPlaying;
    @Nullable
    private class_2338 songSource;
    private CaracalTemptGoal temptGoal;
    private static double health;
    private static double speed;
    private static double follow;
    private static double damage;
    private static double knockback;
    private static final HashSet<UUID> peopleToAttack;
    private boolean commander;
    private final AnimatableInstanceCache aFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE;
    private static final RawAnimation IDLE2SIT;
    private static final RawAnimation IDLE2SLEEP;
    private static final RawAnimation WALK;
    private static final RawAnimation SNEAK;
    private static final RawAnimation RUN;
    private static final RawAnimation SIT;
    private static final RawAnimation SIT2IDLE;
    private static final RawAnimation SIT2SLEEP;
    private static final RawAnimation SLEEP;
    private static final RawAnimation SLEEP2IDLE;
    private static final RawAnimation SLEEP2SIT;
    private static final RawAnimation DANCE;

    public CaracalEntity(class_1299<? extends CaracalEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        this.temptGoal = new CaracalTemptGoal(this, 1.0, TAMING_INGREDIENT, true);
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new SleepWithOwnerGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 5.0f, true));
        this.field_6201.method_6277(3, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)this.temptGoal);
        this.field_6201.method_6277(5, (class_1352)new class_1359((class_1308)this, 0.3f));
        this.field_6201.method_6277(6, (class_1352)new class_1371((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new CaracalSitOnBlockGoal(this, 0.8));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.5));
        this.field_6185.method_6277(1, (class_1352)new class_1404((class_1321)this, class_1657.class, false, le -> {
            UUID uuid = le.method_5667();
            if (uuid == null) {
                return false;
            }
            return peopleToAttack.contains(uuid);
        }));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, class_1428.class, true, null));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, class_1463.class, true, null));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, BatEntity.class, true, null));
    }

    public void method_5958() {
        if (this.method_5962().method_6241()) {
            double d = this.method_5962().method_6242();
            if (d == 0.6) {
                this.method_18380(class_4050.field_18081);
                this.method_5728(false);
            } else if (d == 1.33) {
                this.method_18380(class_4050.field_18076);
                this.method_5728(true);
            } else {
                this.method_18380(class_4050.field_18076);
                this.method_5728(false);
            }
        } else {
            this.method_18380(class_4050.field_18076);
            this.method_5728(false);
        }
        if (this.temptGoal != null && this.temptGoal.method_6313() && !this.method_6181() && this.field_5950 % 100 == 0) {
            this.method_5783(CaracalSounds.ENTITY_CARACAL_BEG_FOR_FOOD, 1.0f, 1.0f);
        }
        this.updateAnimations();
    }

    private void updateAnimations() {
        if (this.isLying() && this.field_5950 % 5 == 0 && (double)this.field_5974.method_43057() > 0.7) {
            this.method_5783(CaracalSounds.ENTITY_CARACAL_PURR, 0.6f + 0.4f * (this.field_5974.method_43057() - this.field_5974.method_43057()), 1.0f);
        }
        if (this.songSource == null || !this.songSource.method_19769((class_2374)this.method_19538(), 5.0) || !this.method_37908().method_8320(this.songSource).method_27852(class_2246.field_10223)) {
            this.songPlaying = false;
            this.songSource = null;
        }
    }

    private PlayState predicate(AnimationState<CaracalEntity> state) {
        AnimationController contr = state.getController();
        String animName = "";
        if (contr.getCurrentAnimation() != null) {
            animName = contr.getCurrentAnimation().animation().name();
        }
        if (this.isSongPlaying()) {
            if (!animName.equals("animation.caracal.dance1") || !animName.equals("animation.caracal.dance2")) {
                this.setCurrentAnimation(6);
            }
        } else {
            if (this.getCurrentAnimation() == 4 && !this.method_6172()) {
                contr.setAnimation(SIT2IDLE);
                if (contr.getAnimationState() == AnimationController.State.PAUSED) {
                    this.setCurrentAnimation(0);
                }
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAnimation() == 5 && !this.isLying() && !this.method_6172()) {
                contr.setAnimation(SLEEP2IDLE);
                if (contr.getAnimationState() == AnimationController.State.PAUSED) {
                    this.setCurrentAnimation(0);
                }
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAnimation() != 4 && this.method_6172() && !this.isLying()) {
                if (this.getCurrentAnimation() <= 3) {
                    contr.setAnimation(IDLE2SIT);
                } else if (this.getCurrentAnimation() == 5) {
                    contr.setAnimation(SLEEP2SIT);
                }
                if (contr.getAnimationState() == AnimationController.State.PAUSED) {
                    this.setCurrentAnimation(4);
                }
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAnimation() != 5 && this.isLying()) {
                if (this.getCurrentAnimation() <= 3) {
                    contr.setAnimation(IDLE2SLEEP);
                } else if (this.getCurrentAnimation() == 4) {
                    contr.setAnimation(SIT2SLEEP);
                }
                if (contr.getAnimationState() == AnimationController.State.PAUSED) {
                    this.setCurrentAnimation(5);
                }
                return PlayState.CONTINUE;
            }
            if (this.isLying()) {
                this.setCurrentAnimation(5);
            } else if (this.method_6172()) {
                this.setCurrentAnimation(4);
            } else if (state.isMoving()) {
                this.setCurrentAnimation(1);
            } else {
                this.setCurrentAnimation(0);
            }
        }
        switch (this.getCurrentAnimation()) {
            case 0: {
                contr.setAnimation(IDLE);
                break;
            }
            case 1: {
                contr.setAnimation(WALK);
                break;
            }
            case 2: {
                contr.setAnimation(SNEAK);
                break;
            }
            case 3: {
                contr.setAnimation(RUN);
                break;
            }
            case 4: {
                contr.setAnimation(SIT);
                break;
            }
            case 5: {
                contr.setAnimation(SLEEP);
                break;
            }
            case 6: {
                contr.setAnimation(DANCE);
            }
        }
        return PlayState.CONTINUE;
    }

    protected PlayState idle(AnimationState<CaracalEntity> state) {
        if (this.getCurrentAnimation() <= 3 && this.getCurrentAnimation() > 0) {
            state.setAnimation(IDLE);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "animations", 0, this::predicate), new AnimationController((GeoAnimatable)this, "idle", 0, this::idle)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.aFactory;
    }

    public static class_5132.class_5133 createCaracalAttributes() {
        return class_1296.method_26827().method_26868(class_5134.field_23716, health).method_26868(class_5134.field_23719, speed).method_26868(class_5134.field_23717, follow).method_26868(class_5134.field_23721, damage).method_26868(class_5134.field_23722, knockback);
    }

    public int getCurrentAnimation() {
        return (Integer)this.field_6011.method_12789(CURRENT_ANIMATION);
    }

    public void setCurrentAnimation(int animation) {
        this.field_6011.method_12778(CURRENT_ANIMATION, (Object)animation);
    }

    public int getMaskColor() {
        return (Integer)this.field_6011.method_12789(CARACAL_BIRTHDAY_COLOR);
    }

    public void setMaskColor(int type) {
        if (type < 1 || type > 3) {
            type = this.field_5974.method_43048(3) + 1;
        }
        this.field_6011.method_12778(CARACAL_BIRTHDAY_COLOR, (Object)type);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("CaracalBirthdayColor", this.getMaskColor());
        if (this.commander) {
            tag.method_10556("Commander", true);
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setMaskColor(tag.method_10550("CaracalBirthdayColor"));
        if (tag.method_10573("Commander", 99)) {
            this.commander = tag.method_10577("Commander");
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        if (this.method_5797() != null) {
            String n = this.method_5797().getString().toLowerCase(Locale.ENGLISH);
            this.commander = (n.contains("\u043a\u043e\u043c\u0430\u043d\u0434\u0438\u0440") || n.contains("commander")) && !n.contains("\u043c\u0438\u0440\u043d\u044b\u0439") && !n.contains("peaceful");
        }
    }

    public void method_6006(class_2338 songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    public boolean isSongPlaying() {
        return this.songPlaying;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.method_6181()) {
            if (this.method_6479()) {
                return CaracalSounds.ENTITY_CARACAL_PURR;
            }
            return this.field_5974.method_43048(4) == 0 ? CaracalSounds.ENTITY_CARACAL_PURREOW : (this.method_5618() < 0 ? CaracalSounds.ENTITY_CARACAL_SMALL_SCREAM : CaracalSounds.ENTITY_CARACAL_SCREAM);
        }
        return this.method_5618() < 0 ? CaracalSounds.ENTITY_CARACAL_SMALL_SCREAM : CaracalSounds.ENTITY_CARACAL_SCREAM;
    }

    protected class_3414 method_6011(class_1282 source) {
        return CaracalSounds.ENTITY_CARACAL_HISS;
    }

    protected class_3414 method_6002() {
        return CaracalSounds.ENTITY_CARACAL_DEATH;
    }

    private float getAttackDamage() {
        return (float)this.method_26825(class_5134.field_23721);
    }

    public boolean method_6121(class_1297 target) {
        return target.method_5643(this.method_48923().method_48812((class_1309)this), this.getAttackDamage());
    }

    protected void method_6475(class_1657 player, class_1268 hand, class_1799 stack) {
        if (this.isBreedingItem(stack)) {
            this.method_5783(CaracalSounds.ENTITY_CARACAL_EAT, 1.0f, 1.0f);
        }
        super.method_6475(player, hand, stack);
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 entity) {
        CaracalEntity caracalEntity = (CaracalEntity)CaracalMain.CARACAL.method_5883((class_1937)level);
        if (entity instanceof CaracalEntity && this.method_6181()) {
            caracalEntity.method_6174(this.method_6139());
            caracalEntity.method_6173(true);
        }
        caracalEntity.setMaskColor(10);
        return caracalEntity;
    }

    public boolean method_6474(class_1429 other) {
        if (!this.method_6181()) {
            return false;
        }
        if (!(other instanceof CaracalEntity)) {
            return false;
        }
        CaracalEntity caracalEntity = (CaracalEntity)other;
        return caracalEntity.method_6181() && super.method_6474(other);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CARACAL_BIRTHDAY_COLOR, (Object)10);
        this.field_6011.method_12784(IN_SLEEPING_POSE, (Object)false);
        this.field_6011.method_12784(CURRENT_ANIMATION, (Object)0);
    }

    public void setLying(boolean sleeping) {
        this.field_6011.method_12778(IN_SLEEPING_POSE, (Object)sleeping);
    }

    public boolean isLying() {
        return (Boolean)this.field_6011.method_12789(IN_SLEEPING_POSE);
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.method_37908().method_8608()) {
            if (this.method_6181() && this.method_6171((class_1309)player)) {
                return class_1269.field_5812;
            }
            if (this.isBreedingItem(itemStack)) {
                return class_1269.field_5812;
            }
            if (this.method_6032() < this.method_6063() && this.method_6181()) {
                return class_1269.field_21466;
            }
        } else if (this.method_6181() && this.method_6171((class_1309)player)) {
            if (this.isBreedingItem(itemStack)) {
                if (this.method_6032() < this.method_6063()) {
                    this.method_6475(player, hand, itemStack);
                    this.method_6025(item.method_19264().method_19230());
                    return class_1269.field_21466;
                }
                if (this.method_5618() == 0 && this.method_6482()) {
                    this.method_6475(player, hand, itemStack);
                    this.method_6480(player);
                    return class_1269.field_5812;
                }
                if (this.method_6109()) {
                    this.method_6475(player, hand, itemStack);
                    this.method_5620(CaracalEntity.method_41321((int)(-this.method_5618())), true);
                    return class_1269.method_29236((boolean)this.method_37908().field_9236);
                }
            }
            this.method_24346(!this.method_24345());
        } else if (this.isBreedingItem(itemStack)) {
            this.method_6475(player, hand, itemStack);
            if (this.field_5974.method_43048(3) == 0) {
                this.method_6170(player);
                this.method_24346(true);
                this.method_5971();
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        spawnData = super.method_5943(level, difficulty, reason, spawnData, dataTag);
        this.setMaskColor(10);
        return spawnData;
    }

    public boolean isBreedingItem(class_1799 stack) {
        return TAMING_INGREDIENT.method_8093(stack);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.98f;
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_6181() && this.field_5950 > 2400;
    }

    static {
        health = AqConfig.INSTANCE.getDoubleProperty("entity.health");
        speed = AqConfig.INSTANCE.getDoubleProperty("entity.speed");
        follow = AqConfig.INSTANCE.getDoubleProperty("entity.follow");
        damage = AqConfig.INSTANCE.getDoubleProperty("entity.damage");
        knockback = AqConfig.INSTANCE.getDoubleProperty("entity.knockback");
        peopleToAttack = new HashSet<UUID>(){
            {
                this.add(UUID.fromString("06e02a3f-dc56-43b5-95b9-191387a59e01"));
            }
        };
        IDLE = RawAnimation.begin().thenLoop("animation.caracal.idle");
        IDLE2SIT = RawAnimation.begin().thenPlay("animation.caracal.idle2sit");
        IDLE2SLEEP = RawAnimation.begin().thenPlay("animation.caracal.idle2sleep");
        WALK = RawAnimation.begin().thenLoop("animation.caracal.walk");
        SNEAK = RawAnimation.begin().thenLoop("animation.caracal.sneak");
        RUN = RawAnimation.begin().thenLoop("animation.caracal.run");
        SIT = RawAnimation.begin().thenLoop("animation.caracal.sit");
        SIT2IDLE = RawAnimation.begin().thenPlay("animation.caracal.sit2idle");
        SIT2SLEEP = RawAnimation.begin().thenPlay("animation.caracal.sit2sleep");
        SLEEP = RawAnimation.begin().thenLoop("animation.caracal.sleep");
        SLEEP2IDLE = RawAnimation.begin().thenPlay("animation.caracal.sleep2idle");
        SLEEP2SIT = RawAnimation.begin().thenPlay("animation.caracal.sleep2sit");
        DANCE = RawAnimation.begin().thenPlayXTimes("animation.caracal.dance1", 9).thenLoop("animation.caracal.dance2");
        TAMING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8429, class_1802.field_8209, class_1802.field_8726, class_1802.field_8504});
        IN_SLEEPING_POSE = class_2945.method_12791(CaracalEntity.class, (class_2941)class_2943.field_13323);
        CARACAL_BIRTHDAY_COLOR = class_2945.method_12791(CaracalEntity.class, (class_2941)class_2943.field_13327);
        CURRENT_ANIMATION = class_2945.method_12791(CaracalEntity.class, (class_2941)class_2943.field_13327);
    }

    static class CaracalTemptGoal
    extends class_1391 {
        @Nullable
        private class_1657 selectedPlayer;
        private final CaracalEntity caracalEntity;

        public CaracalTemptGoal(CaracalEntity caracalEntity, double speed, class_1856 food, boolean canBeScared) {
            super((class_1314)caracalEntity, speed, food, canBeScared);
            this.caracalEntity = caracalEntity;
        }

        public void method_6268() {
            super.method_6268();
            if (this.selectedPlayer == null && this.field_6616.method_6051().method_43048(this.method_38847(600)) == 0) {
                this.selectedPlayer = this.field_6617;
            } else if (this.field_6616.method_6051().method_43048(this.method_38847(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean method_16081() {
            if (this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.field_6617)) {
                return false;
            }
            return super.method_16081();
        }

        public boolean method_6264() {
            return super.method_6264() && !this.caracalEntity.method_6181();
        }
    }

    static class SleepWithOwnerGoal
    extends class_1352 {
        private final CaracalEntity caracal;
        @Nullable
        private class_1657 ownerPlayer;
        @Nullable
        private class_2338 goalPos;
        private int onBedTicks;

        public SleepWithOwnerGoal(CaracalEntity caracalEntity) {
            this.caracal = caracalEntity;
        }

        public boolean method_6264() {
            if (!this.caracal.method_6181()) {
                return false;
            }
            if (this.caracal.method_24345()) {
                return false;
            }
            class_1309 livingEntity = this.caracal.method_35057();
            if (livingEntity instanceof class_1657) {
                this.ownerPlayer = (class_1657)livingEntity;
                if (!livingEntity.method_6113()) {
                    return false;
                }
                if (this.caracal.method_5858((class_1297)this.ownerPlayer) > 100.0) {
                    return false;
                }
                class_2338 blockPos = this.ownerPlayer.method_24515();
                class_2680 blockState = this.caracal.method_37908().method_8320(blockPos);
                if (blockState.method_26164(class_3481.field_16443)) {
                    this.goalPos = blockState.method_28500((class_2769)class_2244.field_11177).map(direction -> blockPos.method_10093(direction.method_10153())).orElseGet(() -> new class_2338((class_2382)blockPos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            List list = this.caracal.method_37908().method_18467(CaracalEntity.class, new class_238(this.goalPos).method_1014(2.0));
            for (CaracalEntity caracal : list) {
                if (caracal == this.caracal || !caracal.isLying()) continue;
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            return this.caracal.method_6181() && !this.caracal.method_24345() && this.ownerPlayer != null && this.ownerPlayer.method_6113() && this.goalPos != null && !this.spaceIsOccupied();
        }

        public void method_6269() {
            if (this.goalPos != null) {
                this.caracal.method_6179(false);
                this.caracal.method_5942().method_6337((double)this.goalPos.method_10263(), (double)this.goalPos.method_10264(), (double)this.goalPos.method_10260(), (double)1.1f);
            }
        }

        public void method_6270() {
            this.caracal.setLying(false);
            float f = this.caracal.method_37908().method_30274(1.0f);
            if (this.ownerPlayer.method_7297() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.caracal.method_37908().method_8409().method_43057() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.caracal.method_5942().method_6340();
        }

        private void giveMorningGift() {
            class_5819 randomSource = this.caracal.method_6051();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            mutableBlockPos.method_10101((class_2382)(this.caracal.method_5934() ? this.caracal.method_5933().method_24515() : this.caracal.method_24515()));
            this.caracal.method_6082(mutableBlockPos.method_10263() + randomSource.method_43048(11) - 5, mutableBlockPos.method_10264() + randomSource.method_43048(5) - 2, mutableBlockPos.method_10260() + randomSource.method_43048(11) - 5, false);
            mutableBlockPos.method_10101((class_2382)this.caracal.method_24515());
            class_52 lootTable = this.caracal.method_37908().method_8503().method_3857().getLootTable(class_39.field_16216);
            class_8567 lootParams = new class_8567.class_8568((class_3218)this.caracal.method_37908()).method_51874(class_181.field_24424, (Object)this.caracal.method_19538()).method_51874(class_181.field_1226, (Object)this.caracal).method_51875(class_173.field_16235);
            ObjectArrayList list = lootTable.method_51878(lootParams);
            for (class_1799 itemStack : list) {
                this.caracal.method_37908().method_8649((class_1297)new class_1542(this.caracal.method_37908(), (double)mutableBlockPos.method_10263() - (double)class_3532.method_15374((float)(this.caracal.field_6283 * ((float)Math.PI / 180))), (double)mutableBlockPos.method_10264(), (double)mutableBlockPos.method_10260() + (double)class_3532.method_15362((float)(this.caracal.field_6283 * ((float)Math.PI / 180))), itemStack));
            }
        }

        public void method_6268() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.caracal.method_6179(false);
                this.caracal.method_5942().method_6337((double)this.goalPos.method_10263(), (double)this.goalPos.method_10264(), (double)this.goalPos.method_10260(), (double)1.1f);
                if (this.caracal.method_5858((class_1297)this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.method_38847(16)) {
                        this.caracal.setLying(true);
                    } else {
                        this.caracal.method_5951((class_1297)this.ownerPlayer, 45.0f, 45.0f);
                    }
                } else {
                    this.caracal.setLying(false);
                }
            }
        }
    }
}

