/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.entity;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.spell_engine.api.effect.EntityImmunity;
import net.spell_engine.api.entity.SpellSpawnedEntity;
import net.spell_engine.api.entity.TwoWayCollisionChecker;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.utils.SoundPlayerWorld;
import net.spell_engine.utils.TargetHelper;
import org.jetbrains.annotations.Nullable;

public class BarrierEntity
extends class_1297
implements SpellSpawnedEntity {
    public static class_1299<BarrierEntity> TYPE;
    public static final class_2960 activateSoundId;
    public static final class_3414 activateSound;
    public static final class_2960 idleSoundId;
    public static final class_3414 idleSound;
    public static final class_2960 impactSoundId;
    public static final class_3414 impactSound;
    public static final class_2960 deactivateSoundId;
    public static final class_3414 deactivateSound;
    private class_2960 spellId;
    private int ownerId;
    private int timeToLive = 20;
    private static final class_2940<String> SPELL_ID_TRACKER;
    private static final class_2940<Integer> OWNER_ID_TRACKER;
    private static final class_2940<Integer> TIME_TO_LIVE_TRACKER;
    private boolean idleSoundFired = false;
    private static final int checkInterval = 4;
    private class_1309 cachedOwner = null;

    public BarrierEntity(class_1299<? extends BarrierEntity> entityType, class_1937 world) {
        super(entityType, world);
        ((TwoWayCollisionChecker)this).setReverseCollisionChecker(entity -> this.method_30949((class_1297)entity) ? TwoWayCollisionChecker.CollisionResult.COLLIDE : TwoWayCollisionChecker.CollisionResult.PASS);
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void onCreatedFromSpell(class_1309 owner, class_2960 spellId, Spell.Impact.Action.Spawn spawn) {
        this.spellId = spellId;
        this.method_5841().method_12778(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.ownerId = owner.method_5628();
        this.method_5841().method_12778(OWNER_ID_TRACKER, (Object)this.ownerId);
        this.timeToLive = spawn.time_to_live_seconds * 20;
        this.method_5841().method_12778(TIME_TO_LIVE_TRACKER, (Object)this.timeToLive);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_49108() {
        return this.method_5805();
    }

    public boolean method_30949(class_1297 other) {
        class_1309 owner = this.getOwner();
        if (owner == null) {
            return super.method_30949(other);
        }
        if (other instanceof class_1309) {
            class_1309 otherLiving = (class_1309)other;
            return !this.isProtected((class_1297)otherLiving);
        }
        return super.method_30949(other);
    }

    public boolean method_5643(class_1282 source, float amount) {
        this.method_37908().method_43129(null, (class_1297)this, impactSound, class_3419.field_15248, 1.0f, 1.0f);
        return super.method_5643(source, amount);
    }

    public class_4048 method_18377(class_4050 pose) {
        Spell spell = this.getSpell();
        if (spell != null) {
            float width = spell.range * 2.0f;
            float height = spell.range;
            return class_4048.method_18384((float)width, (float)height);
        }
        return super.method_18377(pose);
    }

    protected void method_5693() {
        this.method_5841().method_12784(SPELL_ID_TRACKER, (Object)"");
        this.method_5841().method_12784(OWNER_ID_TRACKER, (Object)0);
        this.method_5841().method_12784(TIME_TO_LIVE_TRACKER, (Object)0);
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        String rawSpellId = (String)this.method_5841().method_12789(SPELL_ID_TRACKER);
        if (rawSpellId != null && !rawSpellId.isEmpty()) {
            this.spellId = new class_2960(rawSpellId);
        }
        this.timeToLive = (Integer)this.method_5841().method_12789(TIME_TO_LIVE_TRACKER);
        this.method_18382();
    }

    protected void method_5749(class_2487 nbt) {
        this.spellId = new class_2960(nbt.method_10558(NBTKey.SPELL_ID.key));
        this.ownerId = nbt.method_10550(NBTKey.OWNER_ID.key);
        this.timeToLive = nbt.method_10550(NBTKey.TIME_TO_LIVE.key);
        this.method_5841().method_12778(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.method_5841().method_12778(OWNER_ID_TRACKER, (Object)this.ownerId);
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10582(NBTKey.SPELL_ID.key, this.spellId.toString());
        nbt.method_10569(NBTKey.OWNER_ID.key, this.ownerId);
        nbt.method_10569(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
    }

    public boolean method_5701() {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        Spell spell = this.getSpell();
        if (spell == null) {
            return;
        }
        class_1937 world = this.method_37908();
        if (world.method_8608()) {
            if (!this.idleSoundFired) {
                ((SoundPlayerWorld)world).playSoundFromEntity((class_1297)this, idleSound, class_3419.field_15248, 1.0f, 1.0f);
                this.idleSoundFired = true;
            }
        } else {
            if (this.field_6012 > this.timeToLive) {
                this.method_5768();
            }
            if (this.field_6012 % 4 == 0) {
                List entities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014((double)0.1f));
                for (class_1297 entity : entities) {
                    class_1309 livingEntity;
                    if (!(entity instanceof class_1309) || !this.isProtected((class_1297)(livingEntity = (class_1309)entity))) continue;
                    EntityImmunity.setImmune((class_1297)livingEntity, (EntityImmunity.Type)EntityImmunity.Type.AREA_EFFECT, (int)5);
                    EntityImmunity.setImmune((class_1297)livingEntity, (EntityImmunity.Type)EntityImmunity.Type.EXPLOSION, (int)5);
                }
            }
            if (this.field_6012 == this.timeToLive - this.expirationDuration()) {
                this.method_37908().method_43129(null, (class_1297)this, deactivateSound, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    public int expirationDuration() {
        return 20;
    }

    public boolean isExpiring() {
        return this.field_6012 >= this.timeToLive - this.expirationDuration();
    }

    public boolean isProtected(class_1297 other) {
        class_1309 owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        TargetHelper.Relation relation = TargetHelper.getRelation((class_1309)owner, (class_1297)other);
        switch (relation) {
            case FRIENDLY: 
            case SEMI_FRIENDLY: {
                return true;
            }
            case NEUTRAL: 
            case MIXED: 
            case HOSTILE: {
                return false;
            }
        }
        return false;
    }

    public Spell getSpell() {
        return SpellRegistry.getSpell((class_2960)this.spellId);
    }

    @Nullable
    public class_1309 getOwner() {
        if (this.cachedOwner != null) {
            return this.cachedOwner;
        }
        class_1297 owner = this.method_37908().method_8469(this.ownerId);
        if (owner instanceof class_1309) {
            class_1309 livingOwner;
            this.cachedOwner = livingOwner = (class_1309)owner;
            return livingOwner;
        }
        return null;
    }

    static {
        activateSoundId = new class_2960("paladins", "holy_barrier_activate");
        activateSound = class_3414.method_47908((class_2960)activateSoundId);
        idleSoundId = new class_2960("paladins", "holy_barrier_idle");
        idleSound = class_3414.method_47908((class_2960)idleSoundId);
        impactSoundId = new class_2960("paladins", "holy_barrier_impact");
        impactSound = class_3414.method_47908((class_2960)impactSoundId);
        deactivateSoundId = new class_2960("paladins", "holy_barrier_deactivate");
        deactivateSound = class_3414.method_47908((class_2960)deactivateSoundId);
        SPELL_ID_TRACKER = class_2945.method_12791(BarrierEntity.class, (class_2941)class_2943.field_13326);
        OWNER_ID_TRACKER = class_2945.method_12791(BarrierEntity.class, (class_2941)class_2943.field_13327);
        TIME_TO_LIVE_TRACKER = class_2945.method_12791(BarrierEntity.class, (class_2941)class_2943.field_13327);
    }

    private static enum NBTKey {
        OWNER_ID("OwnerId"),
        SPELL_ID("SpellId"),
        TIME_TO_LIVE("TTL");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

