/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.SortCases;
import net.kyrptonaught.inventorysorter.interfaces.SortableContainer;
import net.kyrptonaught.inventorysorter.mixin.ScreenHandlerTypeAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_7923;

public class InventoryHelper {
    public static class_2561 sortBlock(class_1937 world, class_2338 blockPos, class_3222 player, SortCases.SortType sortType) {
        class_1263 inventory = null;
        class_3908 namedScreenHandlerFactory = null;
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (blockState.method_31709()) {
            class_2586 blockEntity = world.method_8321(blockPos);
            inventory = class_2614.method_11250((class_1937)world, (class_2338)blockPos);
            namedScreenHandlerFactory = block.method_17454(blockState, world, blockPos);
            if (namedScreenHandlerFactory == null && blockEntity instanceof class_3908) {
                namedScreenHandlerFactory = (class_3908)blockEntity;
            }
        }
        if (inventory == null || namedScreenHandlerFactory == null) {
            return class_2561.method_43471((String)"key.inventorysorter.sorting.invalid");
        }
        OptionalInt syncId = player.method_17355(namedScreenHandlerFactory);
        if (syncId.isPresent()) {
            class_1703 screenHandler = namedScreenHandlerFactory.createMenu(syncId.getAsInt(), player.method_31548(), (class_1657)player);
            try {
                if (InventoryHelper.canSortInventory((class_1657)player, screenHandler)) {
                    InventoryHelper.sortInv(inventory, 0, inventory.method_5439(), sortType);
                    player.method_7346();
                    return class_2561.method_43471((String)"key.inventorysorter.sorting.sorted");
                }
                player.method_7346();
                return class_2561.method_43471((String)"key.inventorysorter.sorting.notsortable");
            }
            catch (Exception ex) {
                player.method_7346();
                return class_2561.method_43471((String)"key.inventorysorter.sorting.failed");
            }
        }
        return class_2561.method_43471((String)"key.inventorysorter.sorting.error");
    }

    public static boolean sortInv(class_1657 player, boolean sortPlayerInv, SortCases.SortType sortType) {
        class_1263 inv;
        if (sortPlayerInv) {
            InventoryHelper.sortInv((class_1263)player.method_31548(), 9, 27, sortType);
            return true;
        }
        if (InventoryHelper.canSortInventory(player) && (inv = ((SortableContainer)player.field_7512).getInventory()) != null) {
            InventoryHelper.sortInv(inv, 0, inv.method_5439(), sortType);
            return true;
        }
        return false;
    }

    static void sortInv(class_1263 inv, int startSlot, int invSize, SortCases.SortType sortType) {
        int i;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (i = 0; i < invSize; ++i) {
            InventoryHelper.addStackWithMerge(stacks, inv.method_5438(startSlot + i));
        }
        stacks.sort(Comparator.comparing(stack -> SortCases.getStringForSort(stack, sortType)));
        if (stacks.size() == 0) {
            return;
        }
        for (i = 0; i < invSize; ++i) {
            inv.method_5447(startSlot + i, i < stacks.size() ? (class_1799)stacks.get(i) : class_1799.field_8037);
        }
        inv.method_5431();
    }

    private static void addStackWithMerge(List<class_1799> stacks, class_1799 newStack) {
        if (newStack.method_7909() == class_1802.field_8162) {
            return;
        }
        if (newStack.method_7946() && newStack.method_7947() != newStack.method_7914()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                class_1799 oldStack = stacks.get(j);
                if (!InventoryHelper.canMergeItems(newStack, oldStack)) continue;
                InventoryHelper.combineStacks(newStack, oldStack);
                if (oldStack.method_7909() != class_1802.field_8162 && oldStack.method_7947() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(class_1799 stack, class_1799 stack2) {
        if (stack.method_7914() >= stack.method_7947() + stack2.method_7947()) {
            stack.method_7933(stack2.method_7947());
            stack2.method_7939(0);
        }
        int maxInsertAmount = Math.min(stack.method_7914() - stack.method_7947(), stack2.method_7947());
        stack.method_7933(maxInsertAmount);
        stack2.method_7934(maxInsertAmount);
    }

    private static boolean canMergeItems(class_1799 itemStack_1, class_1799 itemStack_2) {
        if (!itemStack_1.method_7946() || !itemStack_2.method_7946()) {
            return false;
        }
        if (itemStack_1.method_7947() == itemStack_1.method_7914() || itemStack_2.method_7947() == itemStack_2.method_7914()) {
            return false;
        }
        if (itemStack_1.method_7909() != itemStack_2.method_7909()) {
            return false;
        }
        if (itemStack_1.method_7919() != itemStack_2.method_7919()) {
            return false;
        }
        return class_1799.method_31577((class_1799)itemStack_1, (class_1799)itemStack_2);
    }

    public static boolean shouldDisplayBtns(class_1657 player) {
        if (player.field_7512 == null || !player.field_7512.method_7597(player) || player.field_7512 instanceof class_1723) {
            return true;
        }
        class_3917<?> type = ((ScreenHandlerTypeAccessor)player.field_7512).gettype();
        if (type == null) {
            return true;
        }
        class_2960 id = class_7923.field_41187.method_10221(type);
        if (id == null) {
            return true;
        }
        return !InventorySorterMod.getBlackList().isDisplayBlacklisted(id);
    }

    public static boolean canSortInventory(class_1657 player) {
        if (player.field_7512 instanceof class_1723) {
            return false;
        }
        return InventoryHelper.canSortInventory(player, player.field_7512);
    }

    public static boolean canSortInventory(class_1657 player, class_1703 screenHandler) {
        if (screenHandler == null || !screenHandler.method_7597(player)) {
            return false;
        }
        class_3917<?> type = ((ScreenHandlerTypeAccessor)screenHandler).gettype();
        if (type == null) {
            return false;
        }
        class_2960 id = class_7923.field_41187.method_10221(type);
        if (id == null) {
            return false;
        }
        return InventoryHelper.isSortableContainer(screenHandler, id);
    }

    private static boolean isSortableContainer(class_1703 screenHandler, class_2960 screenID) {
        if (InventorySorterMod.getBlackList().isSortBlackListed(screenID)) {
            return false;
        }
        if (!((SortableContainer)screenHandler).hasSlots()) {
            return false;
        }
        int numSlots = screenHandler.field_7761.size();
        if (numSlots <= 36) {
            return false;
        }
        return numSlots - 36 >= 9;
    }
}

