/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.mixins.entity.ice_skating;

import com.github.thedeathlycow.frostiful.entity.IceSkater;
import com.github.thedeathlycow.frostiful.entity.component.LivingEntityComponents;
import com.github.thedeathlycow.frostiful.entity.damage.FDamageSources;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.frostiful.sound.FSoundEvents;
import com.github.thedeathlycow.frostiful.tag.FItemTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3695;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={class_1309.class})
public abstract class LivingEntityMovementMixin
extends class_1297
implements IceSkater {
    @Unique
    private static final int FROSTIFUL_IS_SKATING_INDEX = 0;
    @Unique
    private static final int FROSTIFUL_IS_GLIDING_INDEX = 1;
    @Unique
    private boolean frostiful$wasSlowed = false;

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    protected abstract float method_23326();

    public LivingEntityMovementMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Unique
    private boolean frostiful$getSkateFlag(int index) {
        byte flags = ((LivingEntityComponents)FComponents.ENTITY_COMPONENTS.get((Object)this)).getSkateFlags();
        return (flags & 1 << index) != 0;
    }

    @Unique
    private void frostiful$setSkateFlag(int index, boolean value) {
        LivingEntityComponents component = (LivingEntityComponents)FComponents.ENTITY_COMPONENTS.get((Object)this);
        byte data = component.getSkateFlags();
        if (value) {
            component.setSkateFlags((byte)(data | 1 << index));
        } else {
            component.setSkateFlags((byte)(data & ~(1 << index)));
        }
    }

    @Override
    @Unique
    public boolean frostiful$isIceSkating() {
        return this.frostiful$getSkateFlag(0);
    }

    @Override
    @Unique
    public void frostiful$setSkating(boolean value) {
        this.frostiful$setSkateFlag(0, value);
    }

    @Override
    @Unique
    public boolean frostiful$isWearingSkates() {
        return this.method_6118(class_1304.field_6166).method_31573(FItemTags.ICE_SKATES);
    }

    @Override
    @Unique
    public boolean frostiful$isGliding() {
        return this.frostiful$getSkateFlag(1);
    }

    @Inject(method={"tickMovement"}, at={@At(value="TAIL")})
    private void updateIsIceSkating(CallbackInfo ci) {
        class_1937 world = this.method_37908();
        class_3695 profiler = world.method_16107();
        profiler.method_15396("frostiful.ice_skate_tick");
        class_2680 velocityAffectingBlock = world.method_8320(this.method_23314());
        this.frostiful$setSkating(velocityAffectingBlock.method_26164(class_3481.field_15467) && IceSkater.frostiful$isInSkatingPose(this) && this.frostiful$isWearingSkates());
        this.updateSlowness(velocityAffectingBlock);
        if (this.frostiful$isIceSkating() && IceSkater.frostiful$isMoving(this)) {
            this.method_5839();
            if (this.method_5715()) {
                this.applyStopEffects(velocityAffectingBlock);
            }
        }
        profiler.method_15407();
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/LivingEntity;isOnGround()Z"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/block/Block;getSlipperiness()F")))
    private float getSlipperinessForIceSkates(float slipperiness) {
        if (this.frostiful$isIceSkating()) {
            slipperiness = IceSkater.frostiful$getSlipperinessForEntity(this);
        }
        return slipperiness;
    }

    @Inject(method={"applyMovementInput"}, at={@At(value="HEAD")})
    private void updateGliding(class_243 movementInput, float slipperiness, CallbackInfoReturnable<class_243> cir) {
        this.frostiful$setSkateFlag(1, movementInput.method_37268() < 0.001);
    }

    @Inject(method={"pushAwayFrom"}, at={@At(value="HEAD")})
    private void damageOnLandingUponEntity(class_1297 entity, CallbackInfo ci) {
        if (!this.method_6118(class_1304.field_6166).method_31573(FItemTags.ICE_SKATES)) {
            return;
        }
        if (entity instanceof class_1309) {
            class_1309 target = (class_1309)entity;
            double attackerHeight = this.method_19538().field_1351;
            double targetEyeHeight = target.method_33571().field_1351;
            if (attackerHeight > targetEyeHeight) {
                FDamageSources damageSources = FDamageSources.getDamageSources(this.method_37908());
                target.method_5643(damageSources.frostiful$iceSkate(this), 1.0f);
            }
        }
    }

    private void updateSlowness(class_2680 velocityAffectingBlock) {
        boolean shouldBeSlowed;
        boolean bl = shouldBeSlowed = this.method_24828() && this.frostiful$isWearingSkates() && !velocityAffectingBlock.method_26164(class_3481.field_15467);
        if (shouldBeSlowed != this.frostiful$wasSlowed) {
            IceSkater.frostiful$updateSkateWalkPenalityModifier((class_1309)this, shouldBeSlowed);
        }
        this.frostiful$wasSlowed = shouldBeSlowed;
    }

    private void applyStopEffects(class_2680 velocityAffectingBlock) {
        float pitch = this.field_5974.method_43057() * 0.75f + 0.5f;
        this.method_5783(FSoundEvents.ENTITY_GENERIC_ICE_SKATE_STOP, 1.0f, pitch);
        class_1937 world = this.method_37908();
        if (!world.field_9236) {
            return;
        }
        class_2388 iceParticles = new class_2388(class_2398.field_11217, velocityAffectingBlock);
        class_243 velocity = this.method_18798();
        class_243 pos = this.method_19538();
        for (int i = 0; i < 25; ++i) {
            world.method_8406((class_2394)iceParticles, pos.field_1352 + (double)this.field_5974.method_43057() - 0.5, pos.field_1351 + (double)this.field_5974.method_43057() - 0.5, pos.field_1350 + (double)this.field_5974.method_43057() - 0.5, velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }
}

