/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.entity;

import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1668;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public abstract class SpellEntity
extends class_1668 {
    private static final String AMPLIFIER_NBT_KEY = "EffectAmplifier";
    private static final String MAX_DISTANCE_NBT_KEY = "MaxDistance";
    private double maxDistance = Double.POSITIVE_INFINITY;
    @Nullable
    private class_243 startPosition = null;

    public SpellEntity(class_1937 world, @Nullable class_1309 owner, double velocityX, double velocityY, double velocityZ) {
        this(world, owner, velocityX, velocityY, velocityZ, Double.POSITIVE_INFINITY);
    }

    public SpellEntity(class_1937 world, @Nullable class_1309 owner, double velocityX, double velocityY, double velocityZ, double maxDistance) {
        super(FEntityTypes.FROST_SPELL, owner, velocityX, velocityY, velocityZ, world);
        this.maxDistance = maxDistance;
    }

    protected SpellEntity(class_1299<? extends SpellEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected abstract void applyEffectCloud();

    protected abstract void applySingleTargetEffect(class_1297 var1);

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.method_5805()) {
            double distTravelledSqd;
            if (this.startPosition == null) {
                this.startPosition = this.method_19538();
            }
            if ((distTravelledSqd = this.startPosition.method_1025(this.method_19538())) > this.maxDistance * this.maxDistance) {
                this.applyEffectCloud();
            }
        }
    }

    public void method_7454(class_3966 hitResult) {
        super.method_7454(hitResult);
        if (!this.method_37908().field_9236 && this.method_5805()) {
            this.applySingleTargetEffect(hitResult.method_17782());
            this.applyEffectCloud();
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10549(MAX_DISTANCE_NBT_KEY, this.maxDistance);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573(MAX_DISTANCE_NBT_KEY, 6)) {
            this.maxDistance = nbt.method_10574(MAX_DISTANCE_NBT_KEY);
        }
    }

    protected void method_5693() {
        super.method_5693();
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (!this.method_37908().field_9236) {
            this.applyEffectCloud();
        }
    }

    protected class_2394 method_7467() {
        return class_2398.field_28013;
    }

    protected float method_7466() {
        return 1.0f;
    }

    protected boolean method_7468() {
        return false;
    }
}

