/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.enchantment;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.enchantment.target.FEnchantmentTargets;
import com.github.thedeathlycow.frostiful.particle.HeatDrainParticleEffect;
import com.github.thedeathlycow.frostiful.util.FMathHelper;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class EnervationEnchantment
extends class_1887 {
    public EnervationEnchantment(class_1887.class_1888 weight, class_1304[] slotTypes) {
        super(weight, FEnchantmentTargets.FROSTIFUL_FROST_WAND, slotTypes);
    }

    public boolean method_8193() {
        return false;
    }

    public int method_8182(int level) {
        return level * 10;
    }

    public int method_8183() {
        return 3;
    }

    public boolean method_8192(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item instanceof class_1829 || item instanceof class_1743 || super.method_8192(stack);
    }

    public void method_8189(class_1309 user, class_1297 target, int level) {
        int heatDrainedFromTarget = 0;
        FrostifulConfig config = Frostiful.getConfig();
        if (target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            if (!livingTarget.thermoo$canFreeze()) {
                return;
            }
            heatDrainedFromTarget = config.combatConfig.getHeatDrainPerLevel() * level;
            livingTarget.thermoo$addTemperature(-heatDrainedFromTarget, (HeatingMode)HeatingModes.ACTIVE);
        }
        int heatAddedToUser = class_3532.method_15357((double)((double)heatDrainedFromTarget * config.combatConfig.getHeatDrainEfficiency()));
        user.thermoo$addTemperature(heatAddedToUser, (HeatingMode)HeatingModes.ACTIVE);
        if (user.thermoo$isWarm()) {
            user.thermoo$setTemperature(0);
        }
        if (heatDrainedFromTarget != 0) {
            EnervationEnchantment.addHeatDrainParticles((class_1297)user, target, level);
        }
    }

    public static void addHeatDrainParticles(class_1297 destination, class_1297 source, int level) {
        class_1937 world = destination.method_5770();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            EnervationEnchantment.addHeatDrainParticles(serverWorld, destination, source, level, 0.5);
        }
    }

    public static void addHeatDrainParticles(class_3218 serverWorld, class_1297 destination, class_1297 source, int level, double delta) {
        class_243 from = FMathHelper.getMidPoint(source.method_33571(), source.method_19538());
        int numParticles = (level << 1) + 5;
        double fromX = from.method_10216();
        double fromY = from.method_10214();
        double fromZ = from.method_10215();
        HeatDrainParticleEffect effect = new HeatDrainParticleEffect(destination.method_33571());
        serverWorld.method_14199((class_2394)effect, fromX, fromY, fromZ, numParticles, delta, delta, delta, 0.3);
    }
}

