/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful;

import com.github.thedeathlycow.frostiful.compat.FrostifulIntegrations;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.entity.effect.FPotions;
import com.github.thedeathlycow.frostiful.entity.effect.FStatusEffects;
import com.github.thedeathlycow.frostiful.entity.loot.StrayLootTableModifier;
import com.github.thedeathlycow.frostiful.item.FSmithingTemplateItem;
import com.github.thedeathlycow.frostiful.item.FrostologyCloakItem;
import com.github.thedeathlycow.frostiful.item.attribute.FrostResistantArmorTagApplicator;
import com.github.thedeathlycow.frostiful.item.attribute.ItemAttributeLoader;
import com.github.thedeathlycow.frostiful.particle.FParticleTypes;
import com.github.thedeathlycow.frostiful.registry.FBlocks;
import com.github.thedeathlycow.frostiful.registry.FEnchantments;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import com.github.thedeathlycow.frostiful.registry.FGameRules;
import com.github.thedeathlycow.frostiful.registry.FItemGroups;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.frostiful.server.command.RootCommand;
import com.github.thedeathlycow.frostiful.server.command.WindCommand;
import com.github.thedeathlycow.frostiful.sound.FSoundEvents;
import com.github.thedeathlycow.frostiful.survival.AmbientTemperatureController;
import com.github.thedeathlycow.frostiful.survival.ControllerListeners;
import com.github.thedeathlycow.frostiful.survival.EntityTemperatureController;
import com.github.thedeathlycow.frostiful.survival.ModifyTemperatureController;
import com.github.thedeathlycow.frostiful.survival.SoakingController;
import com.github.thedeathlycow.frostiful.world.gen.feature.FFeatures;
import com.github.thedeathlycow.frostiful.world.gen.feature.FPlacedFeatures;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentControllerInitializeEvent;
import com.github.thedeathlycow.thermoo.api.temperature.event.PlayerEnvironmentEvents;
import com.mojang.brigadier.CommandDispatcher;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frostiful
implements ModInitializer {
    public static final String MODID = "frostiful";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"frostiful");
    public static final int CONFIG_VERSION = 2;

    public void onInitialize() {
        AutoConfig.register(FrostifulConfig.class, GsonConfigSerializer::new);
        FrostifulConfig.updateConfig((ConfigHolder<FrostifulConfig>)AutoConfig.getConfigHolder(FrostifulConfig.class));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            RootCommand.register((CommandDispatcher<class_2168>)dispatcher);
            WindCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        LootTableEvents.MODIFY.register(StrayLootTableModifier::addFrostTippedArrows);
        ResourceManagerHelper serverManager = ResourceManagerHelper.get((class_3264)class_3264.field_14190);
        serverManager.registerReloadListener((IdentifiableResourceReloadListener)ItemAttributeLoader.INSTANCE);
        ModifyItemAttributeModifiersCallback.EVENT.register((Object)ItemAttributeLoader.INSTANCE);
        ModifyItemAttributeModifiersCallback.EVENT.register((Object)new FrostResistantArmorTagApplicator());
        FBlocks.registerBlocks();
        FItems.registerItems();
        FEntityTypes.registerEntities();
        FGameRules.registerGamerules();
        FSoundEvents.registerSoundEvents();
        FStatusEffects.registerStatusEffects();
        FEnchantments.registerEnchantments();
        FParticleTypes.registerParticleTypes();
        FPotions.register();
        FItemGroups.registerAll();
        FFeatures.registerAll();
        FPlacedFeatures.placeFeatures();
        this.registerThermooEventListeners();
        FSmithingTemplateItem.addTemplatesToLoot();
        LOGGER.info("Initialized Frostiful!");
    }

    private void registerThermooEventListeners() {
        PlayerEnvironmentEvents.CAN_APPLY_PASSIVE_TEMPERATURE_CHANGE.register((change, player) -> {
            boolean doPassiveFreezing;
            if (change > 0) {
                return true;
            }
            FrostifulConfig config = Frostiful.getConfig();
            int tickInterval = config.freezingConfig.getPassiveFreezingTickInterval();
            if (tickInterval > 1 && player.field_6012 % tickInterval != 0) {
                return false;
            }
            if (player.thermoo$getTemperatureScale() < -config.freezingConfig.getMaxPassiveFreezingPercent()) {
                return false;
            }
            boolean bl = doPassiveFreezing = config.freezingConfig.doPassiveFreezing() && player.method_37908().method_8450().method_8355(FGameRules.DO_PASSIVE_FREEZING);
            if (doPassiveFreezing) {
                return true;
            }
            return FrostologyCloakItem.isWornBy(player);
        });
        EnvironmentControllerInitializeEvent.EVENT.register(AmbientTemperatureController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(EnvironmentControllerInitializeEvent.LISTENER_PHASE, ControllerListeners::new);
        EnvironmentControllerInitializeEvent.EVENT.register(EntityTemperatureController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(EnvironmentControllerInitializeEvent.MODIFY_PHASE, ModifyTemperatureController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(controller -> FrostifulIntegrations.isModLoaded("scorchful") ? controller : new SoakingController(controller));
    }

    public static FrostifulConfig getConfig() {
        return (FrostifulConfig)AutoConfig.getConfigHolder(FrostifulConfig.class).getConfig();
    }

    @Contract(value="_->new")
    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }
}

