/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.config;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import org.betterx.bclib.config.ConfigUI;
import org.betterx.bclib.config.NamedPathConfig;

public class CachedConfig
extends NamedPathConfig {
    @ConfigUI(hide=true)
    public static final NamedPathConfig.ConfigToken<String> LAST_CHECK_DATE = NamedPathConfig.ConfigToken.String("never", "last", "version");
    @ConfigUI(hide=true)
    public static final NamedPathConfig.ConfigToken<String> LAST_JSON = NamedPathConfig.ConfigToken.String("", "cached", "version");

    public CachedConfig() {
        super("bclib", "cache", false, false);
    }

    public String lastVersionJson() {
        byte[] decodedBytes = Base64.getUrlDecoder().decode(this.get(LAST_JSON));
        return new String(decodedBytes, StandardCharsets.UTF_8);
    }

    public void setLastVersionJson(String json) {
        this.set(LAST_JSON, Base64.getUrlEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8)));
    }

    public Instant lastCheckDate() {
        String d = this.get(LAST_CHECK_DATE);
        if (d.trim().toLowerCase().equals("never")) {
            return Instant.now().minus(6L, ChronoUnit.DAYS);
        }
        return Instant.parse(d);
    }

    public void setLastCheckDate() {
        this.set(LAST_CHECK_DATE, Instant.now().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveChanges() {
        CachedConfig cachedConfig = this;
        synchronized (cachedConfig) {
            super.saveChanges();
        }
    }
}

