/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3503;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7145;
import net.minecraft.class_7723;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.LifeCycleAPI;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.datafixer.DataFixerAPI;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v2.poi.PoiManager;
import org.betterx.bclib.registry.PresetsRegistry;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.WorldEvents;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;

public class LevelGenEvents {
    public static void setupWorld() {
        InternalBiomeAPI.prepareNewLevel();
        DataExchangeAPI.prepareServerside();
    }

    public static void register() {
        WorldEvents.BEFORE_WORLD_LOAD.on(LevelGenEvents::beforeWorldLoad);
        WorldEvents.ON_WORLD_LOAD.on(LevelGenEvents::onWorldLoad);
        WorldEvents.WORLD_REGISTRY_READY.on(LevelGenEvents::worldRegistryReady);
        WorldEvents.ON_FINALIZE_LEVEL_STEM.on(LevelGenEvents::finalizeStem);
        WorldEvents.ON_FINALIZED_WORLD_LOAD.on(LevelGenEvents::finalizedWorldLoad);
        WorldEvents.PATCH_WORLD.on(LevelGenEvents::patchExistingWorld);
        WorldEvents.ADAPT_WORLD_PRESET.on(LevelGenEvents::adaptWorldPreset);
        WorldEvents.BEFORE_ADDING_TAGS.on(LevelGenEvents::applyBiomeTags);
    }

    private static void applyBiomeTags(String directory, Map<class_2960, List<class_3503.class_5145>> tagsMap) {
        if (directory.equals(TagManager.BIOMES.directory)) {
            InternalBiomeAPI._runBiomeTagAdders();
        }
    }

    private static boolean patchExistingWorld(class_32.class_5143 storageAccess, Consumer<Boolean> allDone) {
        Path dataPath = storageAccess.method_27010(class_5218.field_24188).resolve("data");
        WorldConfig.setDataDir(dataPath.toFile());
        return DataFixerAPI.fixData(storageAccess, allDone != null && BCLib.isClient(), allDone);
    }

    private static class_6880<class_7145> adaptWorldPreset(class_6880<class_7145> currentPreset, class_7723 worldDims) {
        class_5363 endStem = (class_5363)worldDims.comp_1014().method_29107(class_5363.field_25414);
        if (!(endStem.comp_1013().method_12098() instanceof BCLibEndBiomeSource) && currentPreset != null && currentPreset instanceof TogetherWorldPreset) {
            TogetherWorldPreset worldPreset = (TogetherWorldPreset)currentPreset;
            class_5321 worldPresetKey = currentPreset.method_40230().orElse(null);
            if (PresetsRegistry.BCL_WORLD.equals((Object)worldPresetKey) || PresetsRegistry.BCL_WORLD_17.equals((Object)worldPresetKey)) {
                BCLib.LOGGER.info("Detected Datapack for END.");
                class_5363 configuredEndStem = worldPreset.getDimension((class_5321<class_5363>)class_5363.field_25414);
                class_1966 class_19662 = configuredEndStem.comp_1013().method_12098();
                if (class_19662 instanceof BCLibEndBiomeSource) {
                    BCLibEndBiomeSource endSource = (BCLibEndBiomeSource)class_19662;
                    BCLib.LOGGER.info("Changing Default WorldPreset Settings for Datapack use.");
                    BCLEndBiomeSourceConfig inputConfig = endSource.getTogetherConfig();
                    endSource.setTogetherConfig(new BCLEndBiomeSourceConfig(inputConfig.mapVersion, BCLEndBiomeSourceConfig.EndBiomeGeneratorType.VANILLA, false, inputConfig.innerVoidRadiusSquared, inputConfig.centerBiomesSize, inputConfig.voidBiomesSize, inputConfig.landBiomesSize, inputConfig.barrensBiomesSize));
                }
            }
        }
        return currentPreset;
    }

    private static void worldRegistryReady(class_5455 a) {
        InternalBiomeAPI.initRegistry(a);
    }

    private static void beforeWorldLoad(class_32.class_5143 storageAccess, Map<class_5321<class_5363>, class_2794> dimensions, boolean isNewWorld, boolean isServer) {
        LevelGenEvents.setupWorld();
        if (isNewWorld) {
            WorldConfig.saveFile("bclib");
            DataFixerAPI.initializePatchData();
        } else {
            LevelGenUtil.migrateGeneratorSettings();
        }
    }

    private static void onWorldLoad() {
        LifeCycleAPI._runBeforeLevelLoad();
    }

    private static void finalizeStem(class_2378<class_5363> dimensionRegistry, class_5321<class_5363> dimension, class_5363 levelStem) {
        InternalBiomeAPI.applyModifications(levelStem.comp_1013().method_12098(), dimension);
    }

    private static void finalizedWorldLoad(class_2378<class_5363> dimensionRegistry) {
        PoiManager.updateStates();
    }
}

