/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler.autosync;

import java.io.File;
import java.util.Objects;
import net.minecraft.class_2540;
import org.betterx.bclib.api.v2.dataexchange.DataHandler;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.FileContentWrapper;
import org.betterx.worlds.together.util.ModUtil;
import org.jetbrains.annotations.NotNull;

public class AutoSyncID {
    @NotNull
    public final String uniqueID;
    @NotNull
    public final String modID;

    public AutoSyncID(String modID, String uniqueID) {
        Objects.nonNull(modID);
        Objects.nonNull(uniqueID);
        this.modID = modID;
        this.uniqueID = uniqueID;
    }

    public String toString() {
        return this.modID + "." + this.uniqueID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoSyncID)) {
            return false;
        }
        AutoSyncID that = (AutoSyncID)o;
        return this.uniqueID.equals(that.uniqueID) && this.modID.equals(that.modID);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueID, this.modID);
    }

    void serializeData(class_2540 buf) {
        DataHandler.writeString(buf, this.modID);
        DataHandler.writeString(buf, this.uniqueID);
    }

    static AutoSyncID deserializeData(class_2540 buf) {
        String modID = DataHandler.readString(buf);
        String uID = DataHandler.readString(buf);
        if ("bclib::FILE".equals(modID)) {
            return ForDirectFileRequest.finishDeserialize(modID, uID, buf);
        }
        if ("bclib::MOD".equals(uID)) {
            return ForModFileRequest.finishDeserialize(modID, uID, buf);
        }
        return new AutoSyncID(modID, uID);
    }

    public boolean isConfigFile() {
        return this.uniqueID.startsWith("CONFIG_");
    }

    static class ForDirectFileRequest
    extends AutoSyncID {
        public static final String MOD_ID = "bclib::FILE";
        final File relFile;

        ForDirectFileRequest(String syncID, File relFile) {
            super(MOD_ID, syncID);
            this.relFile = relFile;
        }

        @Override
        void serializeData(class_2540 buf) {
            super.serializeData(buf);
            DataHandler.writeString(buf, this.relFile.toString());
        }

        static ForDirectFileRequest finishDeserialize(String modID, String uniqueID, class_2540 buf) {
            File fl = new File(DataHandler.readString(buf));
            return new ForDirectFileRequest(uniqueID, fl);
        }

        @Override
        public String toString() {
            return this.uniqueID + " (" + this.relFile + ")";
        }
    }

    static class ForModFileRequest
    extends AutoSyncID {
        public static final String UNIQUE_ID = "bclib::MOD";
        private final String version;

        ForModFileRequest(String modID, String version) {
            super(modID, UNIQUE_ID);
            this.version = version;
        }

        @Override
        void serializeData(class_2540 buf) {
            super.serializeData(buf);
            buf.writeInt(ModUtil.convertModVersion(this.version));
        }

        static ForModFileRequest finishDeserialize(String modID, String uniqueID, class_2540 buf) {
            String version = ModUtil.convertModVersion(buf.readInt());
            return new ForModFileRequest(modID, version);
        }

        @Override
        public String toString() {
            return this.modID + " (v" + this.version + ")";
        }
    }

    static class WithContentOverride
    extends AutoSyncID {
        final FileContentWrapper contentWrapper;
        final File localFile;

        WithContentOverride(String modID, String uniqueID, FileContentWrapper contentWrapper, File localFile) {
            super(modID, uniqueID);
            this.contentWrapper = contentWrapper;
            this.localFile = localFile;
        }

        @Override
        public String toString() {
            return super.toString() + " (Content override)";
        }
    }
}

