# TIS Advanced

TIS Advanced包含如下新内容：五个新的模块，还有执 行模块的十二条新指令。
在整篇文档中，有几处涉及16位二进制数的比特位。在这些地方比特位按照Msb0规则来编号，也就是最高有效位为第0位。
*译注：Msb即Most-Significant-Bit，最高有效位*

## 新模块

- [ASIC模块](modules/asic_module.md)
- [磁带存储模块](modules/tape_storage.md)
- [无线电模块](modules/radio_module.md)
- [七段数码管](modules/seven_segment_display.md)
- [雷达模块](modules/radar_module.md)

## 执行模块的新指令

### 浮点数算术运算指令

`ADDF`、`SUBF`、`MULF`、`DIVF`
作用与它们的整数版本`ADD`、`SUB`、`MUL`、`DIV`相同。但 是它们对`ACC`寄存器进行操作时，会认为里面的值是一个IEEE-754标准的半精度浮点数。

需要注意的是，在`ACC`寄存器中存储一个整数再对它进行浮点运算是可行的，反之亦然。但这种操作有可能会产生错误的值。用户应当确保只对正确的数据类型执行操作。

### 浮点数流程控制指令

`JEZF`、`JNZF`、`JGZF`、`JLZF`
作用与它们的整数版本`JEZ`、`JNZ`、`JGZ`和`JLZ`相同。然 而，就像上面的浮点算术运算一样，它们对`ACC`进行操作时也会将里面的值作为IEEE-754半精度浮点数对待。

在上述四条指令以外，`JIN`指令可以在`ACC`中的值为 IEEE-754半精度浮点数标准中的`NaN`（非数字）值时跳 转到给定的标签。`JNN`指令的作用与`JIN`相反，在`ACC`不是`NaN`值时才会跳转到给定的标签。

### 浮点数转换指令

`FLT`指令可将`ACC`寄存器中存储的整数值转换为用IEEE-754半精度浮点数表示。`INT`指令可将存储于`ACC`寄存器中的浮点数转换为标准TIS-3D算术运算操作使用的16位 有符号补码整数表示。转化为整数表示时会把浮点数向上取整到最接近的整数。

### MOV指令的变化

`MOV`指令已被扩展，以支持处理浮点数。
例如，`MOV 0.25 ACC`这条指令不再被认为是错误写法了，现在它可以如期把浮点数`0.25`装载到`ACC`寄存器 当中。
