# RAM模块
![不适合笨蛋](item:tis3d:random_access_memory_module)

随机存取存储器（RAM）模块可存储大量的值供后续检索，总共256个。里面存储的每个值都可以独立访问，恰如其名。请注意，由于存储密度较高，内存模块限定为8位值，不像TIS-3D计算机本体那样惊人地支持16位值。

读写独立单元时，RAM模块遵循一个简单的协议：它会先从自己的任意端口读取一个值。此值定义了读写操作的*地址*。提供超过8位宽度的值是未定义行为。此地址将会进行读还是写操作取决于哪种操作先发生。
- 当RAM模块的任意端口完成了一次读取操作（外部对 其写入），读取的值将被存储在该地址处。
- 当RAM模块的任意端口完成写出操作时（外部读取此 端口），存储在该地址中的值将被转移。
输入的地址被读/写之后，RAM模块将返回之前状态，等 待读取另一地址以进行下一次读写操作。

例如：从地址`8`读取值到累加器`ACC`中，假设RAM模块在[执行模块](execution_module.md)的`LEFT`端口处：
`MOV 8 LEFT`
`MOV LEFT ACC`

将值写入到地址`8`也是同样的方式：
`MOV 8 LEFT`
`MOV 0x42 LEFT`
