declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3_)
    constructor(arg0: Vec3i_)
    constructor(arg0: Internal.Position_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: number, arg1: number, arg2: number)
    south(): this;
    mutable(): Internal.BlockPos$MutableBlockPos;
    east(): this;
    static getX(arg0: number): number;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    static getY(arg0: number): number;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    north(arg0: number): this;
    atY(arg0: number): this;
    rotate(arg0: Internal.Rotation_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    asLong(): number;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    west(arg0: number): this;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    offset(arg0: number, arg1: number, arg2: number): this;
    east(arg0: number): this;
    subtract(arg0: Vec3i_): this;
    static readonly PACKED_Y_LENGTH: 12;
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: BlockPos;
}
type BlockPos_ = BlockPos;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    ruleTestOf(o: any): Internal.RuleTest;
    asRuleTest(): Internal.RuleTest;
    fromString(s: string): this;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: ResourceLocation;
}
type BlockStatePredicate_ = RegExp | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    /**
     * Get a map of all KubeJS materials
    */
    static getMaterial(): Internal.Map<string, Internal.MaterialJS>;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
    /**
     * Get a map of all KubeJS materials
    */
    get material(): Internal.Map<string, Internal.MaterialJS>
}
type Block_ = Block;
declare class Vec3 implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3f_)
    lerp(arg0: Vec3_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    horizontalDistance(): number;
    normalize(): this;
    distanceToSqr(arg0: Vec3_): number;
    lengthSqr(): number;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    static atCenterOf(arg0: Vec3i_): Vec3;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3;
    cross(arg0: Vec3_): this;
    add(arg0: Vec3_): this;
    yRot(arg0: number): this;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    z(): number;
    static atBottomCenterOf(arg0: Vec3i_): Vec3;
    horizontalDistanceSqr(): number;
    xRot(arg0: number): this;
    dot(arg0: Vec3_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    x(): number;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    vectorTo(arg0: Vec3_): this;
    static atLowerCornerOf(arg0: Vec3i_): Vec3;
    static fromRGB24(arg0: number): Vec3;
    subtract(arg0: Vec3_): this;
    multiply(arg0: Vec3_): this;
    distanceTo(arg0: Vec3_): number;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3;
    reverse(): this;
    scale(arg0: number): this;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    static directionFromRotation(arg0: number, arg1: number): Vec3;
    zRot(arg0: number): this;
    subtract(arg0: number, arg1: number, arg2: number): this;
    readonly z: number;
    static readonly ZERO: Vec3;
    static readonly CODEC: Internal.Codec<Vec3>;
    readonly x: number;
    readonly y: number;
}
type Vec3_ = Vec3;
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    handler$bea000$hashCodeHeadInjected(arg0: Internal.CallbackInfoReturnable_<any>): void;
    static isValidPath(arg0: string): boolean;
    toShortLanguageKey(): string;
    compareTo(arg0: any): number;
    setPath(arg0: string): void;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    static isAllowedInResourceLocation(arg0: string): boolean;
    static tryParse(arg0: string): ResourceLocation;
    static validPathChar(arg0: string): boolean;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    static of(arg0: string, arg1: string): ResourceLocation;
    compareNamespaced(arg0: ResourceLocation_): number;
    handler$bea000$hashCodeReturnInjected(arg0: Internal.CallbackInfoReturnable_<any>): void;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    setNamespace(arg0: string): void;
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: "realms";
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: ":";
    static readonly DEFAULT_NAMESPACE: "minecraft";
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class Items {
    constructor()
    static POWERED_RAIL: Internal.BlockItem;
    static GUARDIAN_SPAWN_EGG: Internal.SpawnEggItem;
    static QUARTZ: Internal.Item;
    static TUBE_CORAL: Internal.BlockItem;
    static TURTLE_EGG: Internal.BlockItem;
    static HANGING_ROOTS: Internal.BlockItem;
    static CYAN_DYE: Internal.DyeItem;
    static WAXED_WEATHERED_CUT_COPPER_SLAB: Internal.BlockItem;
    static CRACKED_DEEPSLATE_TILES: Internal.BlockItem;
    static OAK_PLANKS: Internal.BlockItem;
    static BLAZE_ROD: Internal.Item;
    static GRASS_BLOCK: Internal.BlockItem;
    static DRIED_KELP: Internal.Item;
    static TURTLE_SPAWN_EGG: Internal.SpawnEggItem;
    static GRAY_BANNER: Internal.BannerItem;
    static MAGENTA_CONCRETE: Internal.BlockItem;
    static WARPED_FUNGUS: Internal.BlockItem;
    static DEEPSLATE_BRICKS: Internal.BlockItem;
    static BEETROOT: Internal.Item;
    static LIGHT_GRAY_TERRACOTTA: Internal.BlockItem;
    static GRAY_BED: Internal.BedItem;
    static MUDDY_MANGROVE_ROOTS: Internal.BlockItem;
    static OAK_SIGN: Internal.SignItem;
    static ACACIA_LEAVES: Internal.BlockItem;
    static BIRCH_SLAB: Internal.BlockItem;
    static CHAIN: Internal.BlockItem;
    static LIGHT_GRAY_DYE: Internal.DyeItem;
    static STRIPPED_SPRUCE_LOG: Internal.BlockItem;
    static LIGHT_GRAY_CANDLE: Internal.BlockItem;
    static PURPUR_BLOCK: Internal.BlockItem;
    static NETHERITE_LEGGINGS: Internal.ArmorItem;
    static DEBUG_STICK: Internal.DebugStickItem;
    static MUSIC_DISC_CAT: Internal.RecordItem;
    static GOLDEN_SWORD: Internal.SwordItem;
    static VERDANT_FROGLIGHT: Internal.BlockItem;
    static WARPED_NYLIUM: Internal.BlockItem;
    static TIPPED_ARROW: Internal.TippedArrowItem;
    static MILK_BUCKET: Internal.MilkBucketItem;
    static LAPIS_ORE: Internal.BlockItem;
    static WEEPING_VINES: Internal.BlockItem;
    static BLAZE_SPAWN_EGG: Internal.SpawnEggItem;
    static LODESTONE: Internal.BlockItem;
    static IRON_HELMET: Internal.ArmorItem;
    static MANGROVE_DOOR: Internal.DoubleHighBlockItem;
    static INFESTED_STONE: Internal.BlockItem;
    static OAK_LOG: Internal.BlockItem;
    static SMOOTH_QUARTZ: Internal.BlockItem;
    static BIRCH_STAIRS: Internal.BlockItem;
    static END_PORTAL_FRAME: Internal.BlockItem;
    static AZURE_BLUET: Internal.BlockItem;
    static NETHER_QUARTZ_ORE: Internal.BlockItem;
    static COBBLESTONE: Internal.BlockItem;
    static PUMPKIN: Internal.BlockItem;
    static COBWEB: Internal.BlockItem;
    static YELLOW_STAINED_GLASS_PANE: Internal.BlockItem;
    static DARK_OAK_WOOD: Internal.BlockItem;
    static BLUE_CARPET: Internal.BlockItem;
    static CARROT: Internal.ItemNameBlockItem;
    static GOLDEN_BOOTS: Internal.ArmorItem;
    static BLACKSTONE_SLAB: Internal.BlockItem;
    static SUNFLOWER: Internal.DoubleHighBlockItem;
    static COPPER_ORE: Internal.BlockItem;
    static CHEST: Internal.BlockItem;
    static DEAD_HORN_CORAL: Internal.BlockItem;
    static POLISHED_GRANITE_SLAB: Internal.BlockItem;
    static PURPLE_CANDLE: Internal.BlockItem;
    static SKELETON_SKULL: Internal.StandingAndWallBlockItem;
    static RESPAWN_ANCHOR: Internal.BlockItem;
    static BUCKET: Internal.BucketItem;
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static GLASS: Internal.BlockItem;
    static BIRCH_CHEST_BOAT: Internal.BoatItem;
    static FIRE_CORAL: Internal.BlockItem;
    static LAVA_BUCKET: Internal.BucketItem;
    static ENDER_PEARL: Internal.EnderpearlItem;
    static DRIED_KELP_BLOCK: Internal.BlockItem;
    static POLISHED_BLACKSTONE_BRICKS: Internal.BlockItem;
    static JUNGLE_SLAB: Internal.BlockItem;
    static BOOKSHELF: Internal.BlockItem;
    static DIAMOND_LEGGINGS: Internal.ArmorItem;
    static COBBLESTONE_WALL: Internal.BlockItem;
    static TWISTING_VINES: Internal.BlockItem;
    static GRINDSTONE: Internal.BlockItem;
    static DARK_OAK_LEAVES: Internal.BlockItem;
    static PHANTOM_MEMBRANE: Internal.Item;
    static BRICK: Internal.Item;
    static JUNGLE_LEAVES: Internal.BlockItem;
    static TINTED_GLASS: Internal.BlockItem;
    static OAK_TRAPDOOR: Internal.BlockItem;
    static GOLD_ORE: Internal.BlockItem;
    static FLOWERING_AZALEA: Internal.BlockItem;
    static POPPED_CHORUS_FRUIT: Internal.Item;
    static PRISMARINE_CRYSTALS: Internal.Item;
    static LAPIS_LAZULI: Internal.Item;
    static SQUID_SPAWN_EGG: Internal.SpawnEggItem;
    static TERRACOTTA: Internal.BlockItem;
    static NETHERITE_INGOT: Internal.Item;
    static DEEPSLATE_EMERALD_ORE: Internal.BlockItem;
    static CHAINMAIL_BOOTS: Internal.ArmorItem;
    static NETHERITE_CHESTPLATE: Internal.ArmorItem;
    static CHICKEN_SPAWN_EGG: Internal.SpawnEggItem;
    static BEEHIVE: Internal.BlockItem;
    static SPYGLASS: Internal.SpyglassItem;
    static NETHERITE_AXE: Internal.AxeItem;
    static ELDER_GUARDIAN_SPAWN_EGG: Internal.SpawnEggItem;
    static DARK_OAK_SLAB: Internal.BlockItem;
    static BLUE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static MULE_SPAWN_EGG: Internal.SpawnEggItem;
    static ORANGE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static DARK_OAK_BUTTON: Internal.BlockItem;
    static FIREWORK_STAR: Internal.FireworkStarItem;
    static SPIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static DARK_OAK_LOG: Internal.BlockItem;
    static FROG_SPAWN_EGG: Internal.SpawnEggItem;
    static DEAD_BRAIN_CORAL_BLOCK: Internal.BlockItem;
    static DIRT: Internal.BlockItem;
    static DARK_OAK_CHEST_BOAT: Internal.BoatItem;
    static WOODEN_SHOVEL: Internal.ShovelItem;
    static GLOWSTONE_DUST: Internal.Item;
    static ITEM_FRAME: Internal.ItemFrameItem;
    static SANDSTONE: Internal.BlockItem;
    static BIRCH_FENCE: Internal.BlockItem;
    static MOSSY_COBBLESTONE_WALL: Internal.BlockItem;
    static REDSTONE: Internal.ItemNameBlockItem;
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: Internal.StandingAndWallBlockItem;
    static LIME_CARPET: Internal.BlockItem;
    static MANGROVE_PLANKS: Internal.BlockItem;
    static SUGAR_CANE: Internal.Item;
    static COMMAND_BLOCK_MINECART: Internal.MinecartItem;
    static SMOOTH_SANDSTONE_STAIRS: Internal.BlockItem;
    static CHEST_MINECART: Internal.MinecartItem;
    static DEAD_BUBBLE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static SCUTE: Internal.Item;
    static FEATHER: Internal.Item;
    static JUNGLE_TRAPDOOR: Internal.BlockItem;
    static CUT_SANDSTONE: Internal.BlockItem;
    static CHISELED_QUARTZ_BLOCK: Internal.BlockItem;
    static WHITE_TERRACOTTA: Internal.BlockItem;
    static COPPER_INGOT: Internal.Item;
    static SWEET_BERRIES: Internal.ItemNameBlockItem;
    static GREEN_TERRACOTTA: Internal.BlockItem;
    static BUBBLE_CORAL: Internal.BlockItem;
    static BELL: Internal.BlockItem;
    static WAXED_EXPOSED_COPPER: Internal.BlockItem;
    static WHITE_CONCRETE_POWDER: Internal.BlockItem;
    static BLACK_DYE: Internal.DyeItem;
    static WHITE_WOOL: Internal.BlockItem;
    static DETECTOR_RAIL: Internal.BlockItem;
    static LIME_CONCRETE: Internal.BlockItem;
    static CHORUS_FLOWER: Internal.BlockItem;
    static WARPED_HYPHAE: Internal.BlockItem;
    static WARDEN_SPAWN_EGG: Internal.SpawnEggItem;
    static CHISELED_NETHER_BRICKS: Internal.BlockItem;
    static SNOWBALL: Internal.SnowballItem;
    static LANTERN: Internal.BlockItem;
    static CYAN_CONCRETE_POWDER: Internal.BlockItem;
    static MAP: Internal.EmptyMapItem;
    static WHITE_SHULKER_BOX: Internal.BlockItem;
    static DEEPSLATE_COPPER_ORE: Internal.BlockItem;
    static CUT_STANDSTONE_SLAB: Internal.BlockItem;
    static BLACK_CANDLE: Internal.BlockItem;
    static BLAST_FURNACE: Internal.BlockItem;
    static BIRCH_PLANKS: Internal.BlockItem;
    static QUARTZ_BRICKS: Internal.BlockItem;
    static CYAN_STAINED_GLASS_PANE: Internal.BlockItem;
    static IRON_INGOT: Internal.Item;
    static PINK_BANNER: Internal.BannerItem;
    static MAGMA_CUBE_SPAWN_EGG: Internal.SpawnEggItem;
    static WHITE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static SMOOTH_RED_SANDSTONE: Internal.BlockItem;
    static TRADER_LLAMA_SPAWN_EGG: Internal.SpawnEggItem;
    static TNT: Internal.BlockItem;
    static OAK_DOOR: Internal.DoubleHighBlockItem;
    static GREEN_STAINED_GLASS_PANE: Internal.BlockItem;
    static YELLOW_BANNER: Internal.BannerItem;
    static ROTTEN_FLESH: Internal.Item;
    static CUT_COPPER_STAIRS: Internal.BlockItem;
    static WRITTEN_BOOK: Internal.WrittenBookItem;
    static DISC_FRAGMENT_5: Internal.DiscFragmentItem;
    static MAGENTA_DYE: Internal.DyeItem;
    static CLAY: Internal.BlockItem;
    static MAGENTA_CONCRETE_POWDER: Internal.BlockItem;
    static BRAIN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static SPAWNER: Internal.ApothSpawnerItem;
    static LIME_SHULKER_BOX: Internal.BlockItem;
    static CRIMSON_TRAPDOOR: Internal.BlockItem;
    static NETHERITE_SCRAP: Internal.Item;
    static NETHER_BRICK_SLAB: Internal.BlockItem;
    static STONE: Internal.BlockItem;
    static WITHER_SKELETON_SPAWN_EGG: Internal.SpawnEggItem;
    static AMETHYST_BLOCK: Internal.BlockItem;
    static BIRCH_SAPLING: Internal.BlockItem;
    static JUNGLE_BUTTON: Internal.BlockItem;
    static HOGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static ZOGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static LIME_DYE: Internal.DyeItem;
    static IRON_TRAPDOOR: Internal.BlockItem;
    static MAGENTA_CANDLE: Internal.BlockItem;
    static PETRIFIED_OAK_SLAB: Internal.BlockItem;
    static PRISMARINE_SHARD: Internal.Item;
    static NETHER_GOLD_ORE: Internal.BlockItem;
    static POLISHED_BASALT: Internal.BlockItem;
    static MANGROVE_STAIRS: Internal.BlockItem;
    static ORANGE_BANNER: Internal.BannerItem;
    static SANDSTONE_WALL: Internal.BlockItem;
    static ORANGE_CONCRETE_POWDER: Internal.BlockItem;
    static STRIPPED_OAK_LOG: Internal.BlockItem;
    static POLISHED_GRANITE_STAIRS: Internal.BlockItem;
    static DEEPSLATE_GOLD_ORE: Internal.BlockItem;
    static OBSERVER: Internal.BlockItem;
    static GRAY_CONCRETE_POWDER: Internal.BlockItem;
    static DIAMOND_SWORD: Internal.SwordItem;
    static FOX_SPAWN_EGG: Internal.SpawnEggItem;
    static MAGENTA_WOOL: Internal.BlockItem;
    static CALCITE: Internal.BlockItem;
    static PUMPKIN_SEEDS: Internal.ItemNameBlockItem;
    static FERMENTED_SPIDER_EYE: Internal.Item;
    static PURPLE_CONCRETE: Internal.BlockItem;
    static MUTTON: Internal.Item;
    static PURPLE_STAINED_GLASS: Internal.BlockItem;
    static GOLDEN_PICKAXE: Internal.PickaxeItem;
    static ZOMBIE_SPAWN_EGG: Internal.SpawnEggItem;
    static MUSIC_DISC_PIGSTEP: Internal.RecordItem;
    static REDSTONE_TORCH: Internal.StandingAndWallBlockItem;
    static LEATHER_LEGGINGS: Internal.DyeableArmorItem;
    static PIGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static RED_SHULKER_BOX: Internal.BlockItem;
    static COD: Internal.Item;
    static MUSIC_DISC_11: Internal.RecordItem;
    static AZALEA_LEAVES: Internal.BlockItem;
    static NETHER_WART: Internal.ItemNameBlockItem;
    static NAME_TAG: Internal.NameTagItem;
    static CYAN_CARPET: Internal.BlockItem;
    static MOSSY_COBBLESTONE: Internal.BlockItem;
    static NETHER_BRICK_WALL: Internal.BlockItem;
    static JACK_O_LANTERN: Internal.BlockItem;
    static JUNGLE_SAPLING: Internal.BlockItem;
    static WARPED_SLAB: Internal.BlockItem;
    static FURNACE: Internal.BlockItem;
    static ACACIA_SLAB: Internal.BlockItem;
    static RED_CONCRETE: Internal.BlockItem;
    static YELLOW_CARPET: Internal.BlockItem;
    static POWDER_SNOW_BUCKET: Internal.SolidBucketItem;
    static BUBBLE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static WHITE_STAINED_GLASS: Internal.BlockItem;
    static BRICK_WALL: Internal.BlockItem;
    static BOOK: Internal.BookItem;
    static RED_STAINED_GLASS: Internal.BlockItem;
    static DARK_PRISMARINE_STAIRS: Internal.BlockItem;
    static LIGHT_BLUE_BANNER: Internal.BannerItem;
    static CRIMSON_BUTTON: Internal.BlockItem;
    static PURPLE_WOOL: Internal.BlockItem;
    static PURPLE_BED: Internal.BedItem;
    static EMERALD_ORE: Internal.BlockItem;
    static BLUE_TERRACOTTA: Internal.BlockItem;
    static CRACKED_STONE_BRICKS: Internal.BlockItem;
    static COD_SPAWN_EGG: Internal.SpawnEggItem;
    static DIAMOND: Internal.Item;
    static AZALEA: Internal.BlockItem;
    static JUNGLE_BOAT: Internal.BoatItem;
    static SPRUCE_TRAPDOOR: Internal.BlockItem;
    static MELON_SEEDS: Internal.ItemNameBlockItem;
    static WEATHERED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static CANDLE: Internal.BlockItem;
    static PURPLE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static PILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static MUSIC_DISC_13: Internal.RecordItem;
    static LIGHT_GRAY_CARPET: Internal.BlockItem;
    static BIRCH_WOOD: Internal.BlockItem;
    static FLOWER_POT: Internal.BlockItem;
    static ACACIA_WOOD: Internal.BlockItem;
    static WARPED_FENCE: Internal.BlockItem;
    static CHISELED_POLISHED_BLACKSTONE: Internal.BlockItem;
    static SEA_PICKLE: Internal.BlockItem;
    static LARGE_FERN: Internal.DoubleHighBlockItem;
    static AMETHYST_SHARD: Internal.Item;
    static CHICKEN: Internal.Item;
    static GRAY_CONCRETE: Internal.BlockItem;
    static ACACIA_PRESSURE_PLATE: Internal.BlockItem;
    static TOTEM_OF_UNDYING: Internal.Item;
    static STONE_BRICKS: Internal.BlockItem;
    static GREEN_BED: Internal.BedItem;
    static DROPPER: Internal.BlockItem;
    static LIME_STAINED_GLASS: Internal.BlockItem;
    static KNOWLEDGE_BOOK: Internal.KnowledgeBookItem;
    static LOOM: Internal.BlockItem;
    static LIGHT_BLUE_WOOL: Internal.BlockItem;
    static NETHERITE_BLOCK: Internal.BlockItem;
    static ORANGE_CARPET: Internal.BlockItem;
    static FISHING_ROD: Internal.FishingRodItem;
    static BROWN_DYE: Internal.DyeItem;
    static MEDIUM_AMETHYST_BUD: Internal.BlockItem;
    static ROOTED_DIRT: Internal.BlockItem;
    static WARPED_STEM: Internal.BlockItem;
    static RED_SAND: Internal.BlockItem;
    static END_STONE_BRICK_STAIRS: Internal.BlockItem;
    static SHEARS: Internal.ShearsItem;
    static PANDA_SPAWN_EGG: Internal.SpawnEggItem;
    static POTATO: Internal.ItemNameBlockItem;
    static LAPIS_BLOCK: Internal.BlockItem;
    static COMPOSTER: Internal.BlockItem;
    static NETHERITE_HELMET: Internal.ArmorItem;
    static TROPICAL_FISH: Internal.Item;
    static POTION: Internal.PotionItem;
    static MANGROVE_ROOTS: Internal.BlockItem;
    static JIGSAW: Internal.GameMasterBlockItem;
    static PRISMARINE_BRICK_STAIRS: Internal.BlockItem;
    static TROPICAL_FISH_BUCKET: Internal.MobBucketItem;
    static WARPED_PRESSURE_PLATE: Internal.BlockItem;
    static RED_TERRACOTTA: Internal.BlockItem;
    static BROWN_CARPET: Internal.BlockItem;
    static LIGHT_BLUE_CANDLE: Internal.BlockItem;
    static LEATHER_CHESTPLATE: Internal.DyeableArmorItem;
    static RED_BED: Internal.BedItem;
    static STONE_HOE: Internal.HoeItem;
    static JUNGLE_LOG: Internal.BlockItem;
    static GLOW_SQUID_SPAWN_EGG: Internal.SpawnEggItem;
    static BROWN_WOOL: Internal.BlockItem;
    static PUFFERFISH_SPAWN_EGG: Internal.SpawnEggItem;
    static GLASS_PANE: Internal.BlockItem;
    static CHAINMAIL_LEGGINGS: Internal.ArmorItem;
    static GREEN_WOOL: Internal.BlockItem;
    static BREAD: Internal.Item;
    static COOKED_CHICKEN: Internal.Item;
    static BIRCH_FENCE_GATE: Internal.BlockItem;
    static MANGROVE_TRAPDOOR: Internal.BlockItem;
    static CRIMSON_SLAB: Internal.BlockItem;
    static GOLD_NUGGET: Internal.Item;
    static PHANTOM_SPAWN_EGG: Internal.SpawnEggItem;
    static QUARTZ_STAIRS: Internal.BlockItem;
    static WHITE_CONCRETE: Internal.BlockItem;
    static WAXED_WEATHERED_COPPER: Internal.BlockItem;
    static BLUE_CONCRETE_POWDER: Internal.BlockItem;
    static WHEAT_SEEDS: Internal.ItemNameBlockItem;
    static DEEPSLATE_TILES: Internal.BlockItem;
    static PORKCHOP: Internal.Item;
    static SCAFFOLDING: Internal.ScaffoldingBlockItem;
    static END_ROD: Internal.BlockItem;
    static ANDESITE: Internal.BlockItem;
    static PACKED_MUD: Internal.BlockItem;
    static STONE_BRICK_WALL: Internal.BlockItem;
    static ORANGE_WOOL: Internal.BlockItem;
    static REINFORCED_DEEPSLATE: Internal.BlockItem;
    static ACACIA_FENCE_GATE: Internal.BlockItem;
    static LIGHT_GRAY_GLAZED_TERRACOTTA: Internal.BlockItem;
    static LILY_OF_THE_VALLEY: Internal.BlockItem;
    static VILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static STONE_SHOVEL: Internal.ShovelItem;
    static PARROT_SPAWN_EGG: Internal.SpawnEggItem;
    static WHEAT: Internal.Item;
    static JUNGLE_PLANKS: Internal.BlockItem;
    static BROWN_CONCRETE_POWDER: Internal.BlockItem;
    static POLISHED_DEEPSLATE_SLAB: Internal.BlockItem;
    static DIAMOND_AXE: Internal.AxeItem;
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static WARPED_PLANKS: Internal.BlockItem;
    static NETHERRACK: Internal.BlockItem;
    static DIAMOND_CHESTPLATE: Internal.ArmorItem;
    static GRAY_WOOL: Internal.BlockItem;
    static COPPER_BLOCK: Internal.BlockItem;
    static WEATHERED_CUT_COPPER: Internal.BlockItem;
    static PURPUR_PILLAR: Internal.BlockItem;
    static STONE_PRESSURE_PLATE: Internal.BlockItem;
    static RED_NETHER_BRICK_STAIRS: Internal.BlockItem;
    static CAKE: Internal.BlockItem;
    static COBBLED_DEEPSLATE: Internal.BlockItem;
    static MANGROVE_FENCE: Internal.BlockItem;
    static FARMLAND: Internal.BlockItem;
    static LIGHT_GRAY_CONCRETE: Internal.BlockItem;
    static NETHERITE_SHOVEL: Internal.ShovelItem;
    static PUMPKIN_PIE: Internal.Item;
    static SHULKER_SHELL: Internal.ShulkerShellItem;
    static OAK_LEAVES: Internal.BlockItem;
    static RABBIT_SPAWN_EGG: Internal.SpawnEggItem;
    static LIGHT_WEIGHTED_PRESSURE_PLATE: Internal.BlockItem;
    static APPLE: Internal.Item;
    static DIAMOND_HORSE_ARMOR: Internal.HorseArmorItem;
    static POLISHED_BLACKSTONE_SLAB: Internal.BlockItem;
    static WARPED_ROOTS: Internal.BlockItem;
    static BIRCH_LOG: Internal.BlockItem;
    static ELYTRA: Internal.ElytraItem;
    static WARPED_SIGN: Internal.SignItem;
    static GREEN_CANDLE: Internal.BlockItem;
    static BIRCH_TRAPDOOR: Internal.BlockItem;
    static BEE_SPAWN_EGG: Internal.SpawnEggItem;
    static PINK_DYE: Internal.DyeItem;
    static PLAYER_HEAD: Internal.PlayerHeadItem;
    static GLOW_LICHEN: Internal.BlockItem;
    static STONE_STAIRS: Internal.BlockItem;
    static ROSE_BUSH: Internal.DoubleHighBlockItem;
    static GLOW_ITEM_FRAME: Internal.ItemFrameItem;
    static WHITE_TULIP: Internal.BlockItem;
    static OBSIDIAN: Internal.BlockItem;
    static BROWN_SHULKER_BOX: Internal.BlockItem;
    static EGG: Internal.EggItem;
    static WITCH_SPAWN_EGG: Internal.SpawnEggItem;
    static OXIDIZED_CUT_COPPER_SLAB: Internal.BlockItem;
    static WAXED_EXPOSED_CUT_COPPER_SLAB: Internal.BlockItem;
    static OCELOT_SPAWN_EGG: Internal.SpawnEggItem;
    static HORN_CORAL_BLOCK: Internal.BlockItem;
    static NETHER_SPROUTS: Internal.BlockItem;
    static MUD_BRICK_SLAB: Internal.BlockItem;
    static DEAD_BRAIN_CORAL: Internal.BlockItem;
    static TALL_GRASS: Internal.DoubleHighBlockItem;
    static BLACK_STAINED_GLASS: Internal.BlockItem;
    static SPIDER_EYE: Internal.Item;
    static FILLED_MAP: Internal.MapItem;
    static MUD_BRICK_STAIRS: Internal.BlockItem;
    static AXOLOTL_BUCKET: Internal.MobBucketItem;
    static ZOMBIE_HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static DARK_PRISMARINE_SLAB: Internal.BlockItem;
    static MANGROVE_SIGN: Internal.SignItem;
    static STRIPPED_JUNGLE_WOOD: Internal.BlockItem;
    static MUSHROOM_STEM: Internal.BlockItem;
    static LILAC: Internal.DoubleHighBlockItem;
    static SUSPICIOUS_STEW: Internal.SuspiciousStewItem;
    static GOLDEN_LEGGINGS: Internal.ArmorItem;
    static IRON_PICKAXE: Internal.PickaxeItem;
    static WAXED_OXIDIZED_CUT_COPPER: Internal.BlockItem;
    static CRACKED_DEEPSLATE_BRICKS: Internal.BlockItem;
    static SHULKER_SPAWN_EGG: Internal.SpawnEggItem;
    static LIGHT_GRAY_STAINED_GLASS: Internal.BlockItem;
    static MELON_SLICE: Internal.Item;
    static HONEYCOMB_BLOCK: Internal.BlockItem;
    static POLISHED_DIORITE_STAIRS: Internal.BlockItem;
    static PEARLESCENT_FROGLIGHT: Internal.BlockItem;
    static GOLDEN_CHESTPLATE: Internal.ArmorItem;
    static ANCIENT_DEBRIS: Internal.BlockItem;
    static HOPPER_MINECART: Internal.MinecartItem;
    static MAGMA_CREAM: Internal.Item;
    static ZOMBIE_HEAD: Internal.StandingAndWallBlockItem;
    static POLISHED_GRANITE: Internal.BlockItem;
    static PINK_CONCRETE: Internal.BlockItem;
    static HONEYCOMB: Internal.HoneycombItem;
    static NOTE_BLOCK: Internal.BlockItem;
    static RED_GLAZED_TERRACOTTA: Internal.BlockItem;
    static FURNACE_MINECART: Internal.MinecartItem;
    static DRAGON_BREATH: Internal.Item;
    static CYAN_CONCRETE: Internal.BlockItem;
    static CRIMSON_PLANKS: Internal.BlockItem;
    static CHORUS_PLANT: Internal.BlockItem;
    static WAXED_CUT_COPPER_SLAB: Internal.BlockItem;
    static YELLOW_CONCRETE_POWDER: Internal.BlockItem;
    static TURTLE_HELMET: Internal.ArmorItem;
    static DARK_OAK_FENCE_GATE: Internal.BlockItem;
    static COAL_ORE: Internal.BlockItem;
    static COAL: Internal.Item;
    static GRAY_CARPET: Internal.BlockItem;
    static OXIDIZED_CUT_COPPER: Internal.BlockItem;
    static LIGHT_BLUE_CONCRETE_POWDER: Internal.BlockItem;
    static SANDSTONE_SLAB: Internal.BlockItem;
    static GREEN_CONCRETE: Internal.BlockItem;
    static BARREL: Internal.BlockItem;
    static RED_SANDSTONE_SLAB: Internal.BlockItem;
    static WHITE_DYE: Internal.DyeItem;
    static ORANGE_DYE: Internal.DyeItem;
    static ENCHANTED_BOOK: Internal.EnchantedBookItem;
    static SOUL_SOIL: Internal.BlockItem;
    static IRON_NUGGET: Internal.Item;
    static ENDERMITE_SPAWN_EGG: Internal.SpawnEggItem;
    static NETHERITE_BOOTS: Internal.ArmorItem;
    static LEVER: Internal.BlockItem;
    static COOKED_SALMON: Internal.Item;
    static CAULDRON: Internal.Item;
    static ALLIUM: Internal.BlockItem;
    static JUNGLE_CHEST_BOAT: Internal.BoatItem;
    static POISONOUS_POTATO: Internal.Item;
    static FLOWER_BANNER_PATTERN: Internal.BannerPatternItem;
    static SMOOTH_STONE: Internal.BlockItem;
    static WHITE_STAINED_GLASS_PANE: Internal.BlockItem;
    static BROWN_MUSHROOM_BLOCK: Internal.BlockItem;
    static GHAST_SPAWN_EGG: Internal.SpawnEggItem;
    static NETHER_BRICK_STAIRS: Internal.BlockItem;
    static IRON_SHOVEL: Internal.ShovelItem;
    static AXOLOTL_SPAWN_EGG: Internal.SpawnEggItem;
    static ORANGE_STAINED_GLASS: Internal.BlockItem;
    static SEA_LANTERN: Internal.BlockItem;
    static SMOOTH_RED_SANDSTONE_STAIRS: Internal.BlockItem;
    static POLISHED_BLACKSTONE_WALL: Internal.BlockItem;
    static STONE_PICKAXE: Internal.PickaxeItem;
    static LIME_TERRACOTTA: Internal.BlockItem;
    static SHIELD: Internal.ShieldItem;
    static DIORITE_WALL: Internal.BlockItem;
    static STONE_SWORD: Internal.SwordItem;
    static GOLDEN_HOE: Internal.HoeItem;
    static BLACK_GLAZED_TERRACOTTA: Internal.BlockItem;
    static DIAMOND_ORE: Internal.BlockItem;
    static BLACK_STAINED_GLASS_PANE: Internal.BlockItem;
    static LIGHT_GRAY_CONCRETE_POWDER: Internal.BlockItem;
    static LIGHT_BLUE_DYE: Internal.DyeItem;
    static REPEATER: Internal.BlockItem;
    static SPECTRAL_ARROW: Internal.SpectralArrowItem;
    static LEAD: Internal.LeadItem;
    static WHITE_CANDLE: Internal.BlockItem;
    static CHISELED_STONE_BRICKS: Internal.BlockItem;
    static DEAD_TUBE_CORAL: Internal.BlockItem;
    static BROWN_BANNER: Internal.BannerItem;
    static WAXED_OXIDIZED_COPPER: Internal.BlockItem;
    static PINK_WOOL: Internal.BlockItem;
    static BIRCH_BOAT: Internal.BoatItem;
    static BLACK_CARPET: Internal.BlockItem;
    static SPRUCE_FENCE_GATE: Internal.BlockItem;
    static BREWING_STAND: Internal.BlockItem;
    static BIG_DRIPLEAF: Internal.BlockItem;
    static CARVED_PUMPKIN: Internal.BlockItem;
    static OAK_BUTTON: Internal.BlockItem;
    static PINK_GLAZED_TERRACOTTA: Internal.BlockItem;
    static DIORITE_SLAB: Internal.BlockItem;
    static ACACIA_BOAT: Internal.BoatItem;
    static POLISHED_BLACKSTONE_BRICK_SLAB: Internal.BlockItem;
    static SMOOTH_QUARTZ_STAIRS: Internal.BlockItem;
    static END_STONE: Internal.BlockItem;
    static BLUE_BED: Internal.BedItem;
    static LIGHT: Internal.BlockItem;
    static BONE_BLOCK: Internal.BlockItem;
    static DRIPSTONE_BLOCK: Internal.BlockItem;
    static WET_SPONGE: Internal.BlockItem;
    static FLINT: Internal.Item;
    static INFESTED_CHISELED_STONE_BRICKS: Internal.BlockItem;
    static GRAY_SHULKER_BOX: Internal.BlockItem;
    static YELLOW_CANDLE: Internal.BlockItem;
    static SPRUCE_LEAVES: Internal.BlockItem;
    static MOSSY_COBBLESTONE_SLAB: Internal.BlockItem;
    static HUSK_SPAWN_EGG: Internal.SpawnEggItem;
    static PINK_STAINED_GLASS: Internal.BlockItem;
    static MAGENTA_STAINED_GLASS_PANE: Internal.BlockItem;
    static BLUE_ICE: Internal.BlockItem;
    static JUKEBOX: Internal.BlockItem;
    static FIRE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static FIRE_CHARGE: Internal.FireChargeItem;
    static COOKED_MUTTON: Internal.Item;
    static BASALT: Internal.BlockItem;
    static ACACIA_PLANKS: Internal.BlockItem;
    static PIG_SPAWN_EGG: Internal.SpawnEggItem;
    static MUSHROOM_STEW: Internal.BowlFoodItem;
    static PURPLE_STAINED_GLASS_PANE: Internal.BlockItem;
    static MANGROVE_PRESSURE_PLATE: Internal.BlockItem;
    static SMALL_AMETHYST_BUD: Internal.BlockItem;
    static DEAD_HORN_CORAL_BLOCK: Internal.BlockItem;
    static POLISHED_BLACKSTONE_BRICK_WALL: Internal.BlockItem;
    static WEATHERED_COPPER: Internal.BlockItem;
    static RED_WOOL: Internal.BlockItem;
    static MANGROVE_PROPAGULE: Internal.BlockItem;
    static PURPUR_STAIRS: Internal.BlockItem;
    static PAPER: Internal.Item;
    static IRON_HOE: Internal.HoeItem;
    static MAGENTA_GLAZED_TERRACOTTA: Internal.BlockItem;
    static STICKY_PISTON: Internal.BlockItem;
    static COMPASS: Internal.CompassItem;
    static RED_SANDSTONE_WALL: Internal.BlockItem;
    static DARK_PRISMARINE: Internal.BlockItem;
    static DARK_OAK_FENCE: Internal.BlockItem;
    static CLAY_BALL: Internal.Item;
    static CYAN_WOOL: Internal.BlockItem;
    static STONECUTTER: Internal.BlockItem;
    static MINECART: Internal.MinecartItem;
    static POLISHED_BLACKSTONE_STAIRS: Internal.BlockItem;
    static RED_CANDLE: Internal.BlockItem;
    static GREEN_STAINED_GLASS: Internal.BlockItem;
    static AIR: Internal.AirItem;
    static SEAGRASS: Internal.BlockItem;
    static GLOWSTONE: Internal.BlockItem;
    static YELLOW_BED: Internal.BedItem;
    static ANVIL: Internal.ApothAnvilItem;
    static YELLOW_GLAZED_TERRACOTTA: Internal.BlockItem;
    static RAW_COPPER_BLOCK: Internal.BlockItem;
    static POLISHED_DIORITE: Internal.BlockItem;
    static DARK_OAK_SIGN: Internal.SignItem;
    static MAGENTA_STAINED_GLASS: Internal.BlockItem;
    static NETHER_BRICKS: Internal.BlockItem;
    static WITHER_SKELETON_SKULL: Internal.StandingAndWallBlockItem;
    static DONKEY_SPAWN_EGG: Internal.SpawnEggItem;
    static STONE_BRICK_STAIRS: Internal.BlockItem;
    static WARPED_DOOR: Internal.DoubleHighBlockItem;
    static WAXED_COPPER_BLOCK: Internal.BlockItem;
    static ENCHANTED_GOLDEN_APPLE: Internal.EnchantedGoldenAppleItem;
    static MANGROVE_CHEST_BOAT: Internal.BoatItem;
    static MUD: Internal.BlockItem;
    static OAK_FENCE: Internal.BlockItem;
    static GOAT_HORN: Internal.InstrumentItem;
    static CAVE_SPIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static QUARTZ_PILLAR: Internal.BlockItem;
    static DEAD_FIRE_CORAL: Internal.BlockItem;
    static SUGAR: Internal.Item;
    static WAXED_EXPOSED_CUT_COPPER: Internal.BlockItem;
    static BROWN_CONCRETE: Internal.BlockItem;
    static SCULK_VEIN: Internal.BlockItem;
    static FLETCHING_TABLE: Internal.Item;
    static INFESTED_MOSSY_STONE_BRICKS: Internal.BlockItem;
    static WARPED_STAIRS: Internal.BlockItem;
    static SPRUCE_PRESSURE_PLATE: Internal.BlockItem;
    static BROWN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static PINK_CANDLE: Internal.BlockItem;
    static STONE_BRICK_SLAB: Internal.BlockItem;
    static RED_CARPET: Internal.BlockItem;
    static CLOCK: Internal.Item;
    static GRAY_TERRACOTTA: Internal.BlockItem;
    static EMERALD: Internal.Item;
    static DEEPSLATE_DIAMOND_ORE: Internal.BlockItem;
    static BIRCH_PRESSURE_PLATE: Internal.BlockItem;
    static BIRCH_DOOR: Internal.DoubleHighBlockItem;
    static BROWN_CANDLE: Internal.BlockItem;
    static KELP: Internal.BlockItem;
    static WITHER_ROSE: Internal.BlockItem;
    static ACACIA_CHEST_BOAT: Internal.BoatItem;
    static TADPOLE_SPAWN_EGG: Internal.SpawnEggItem;
    static SPRUCE_FENCE: Internal.BlockItem;
    static ORANGE_CONCRETE: Internal.BlockItem;
    static CRAFTING_TABLE: Internal.BlockItem;
    static BAKED_POTATO: Internal.Item;
    static MANGROVE_SLAB: Internal.BlockItem;
    static CYAN_BED: Internal.BedItem;
    static NAUTILUS_SHELL: Internal.Item;
    static SHULKER_BOX: Internal.BlockItem;
    static STICK: Internal.Item;
    static HEAVY_WEIGHTED_PRESSURE_PLATE: Internal.BlockItem;
    static COARSE_DIRT: Internal.BlockItem;
    static QUARTZ_SLAB: Internal.BlockItem;
    static COBBLED_DEEPSLATE_SLAB: Internal.BlockItem;
    static LIGHTNING_ROD: Internal.BlockItem;
    static ACACIA_FENCE: Internal.BlockItem;
    static POLAR_BEAR_SPAWN_EGG: Internal.SpawnEggItem;
    static ACACIA_LOG: Internal.BlockItem;
    static MOJANG_BANNER_PATTERN: Internal.BannerPatternItem;
    static DEEPSLATE_REDSTONE_ORE: Internal.BlockItem;
    static INFESTED_STONE_BRICKS: Internal.BlockItem;
    static ENCHANTING_TABLE: Internal.Item;
    static POLISHED_ANDESITE_SLAB: Internal.BlockItem;
    static PURPLE_CONCRETE_POWDER: Internal.BlockItem;
    static PINK_CARPET: Internal.BlockItem;
    static DIORITE: Internal.BlockItem;
    static RED_CONCRETE_POWDER: Internal.BlockItem;
    static DARK_OAK_SAPLING: Internal.BlockItem;
    static GRAY_DYE: Internal.DyeItem;
    static LIGHT_GRAY_BED: Internal.BedItem;
    static IRON_ORE: Internal.BlockItem;
    static SCULK_SENSOR: Internal.BlockItem;
    static BUNDLE: Internal.BundleItem;
    static STRING: Internal.ItemNameBlockItem;
    static STRIPPED_JUNGLE_LOG: Internal.BlockItem;
    static END_CRYSTAL: Internal.EndCrystalItem;
    static LEATHER_BOOTS: Internal.DyeableArmorItem;
    static SLIME_BALL: Internal.Item;
    static ORANGE_TERRACOTTA: Internal.BlockItem;
    static DEEPSLATE_IRON_ORE: Internal.BlockItem;
    static BOW: Internal.BowItem;
    static ORANGE_CANDLE: Internal.BlockItem;
    static BLUE_ORCHID: Internal.BlockItem;
    static SPRUCE_BUTTON: Internal.BlockItem;
    static LLAMA_SPAWN_EGG: Internal.SpawnEggItem;
    static CAMPFIRE: Internal.BlockItem;
    static LIGHT_BLUE_STAINED_GLASS: Internal.BlockItem;
    static MAGENTA_TERRACOTTA: Internal.BlockItem;
    static DARK_OAK_STAIRS: Internal.BlockItem;
    static EXPOSED_CUT_COPPER_SLAB: Internal.BlockItem;
    static BUBBLE_CORAL_BLOCK: Internal.BlockItem;
    static RED_MUSHROOM: Internal.BlockItem;
    static ACACIA_STAIRS: Internal.BlockItem;
    static BLACK_CONCRETE: Internal.BlockItem;
    static SAND: Internal.BlockItem;
    static NETHERITE_HOE: Internal.HoeItem;
    static RED_MUSHROOM_BLOCK: Internal.BlockItem;
    static MYCELIUM: Internal.BlockItem;
    static PINK_TULIP: Internal.BlockItem;
    static PINK_TERRACOTTA: Internal.BlockItem;
    static GOAT_SPAWN_EGG: Internal.SpawnEggItem;
    static INFESTED_CRACKED_STONE_BRICKS: Internal.BlockItem;
    static RABBIT: Internal.Item;
    static PRISMARINE_SLAB: Internal.BlockItem;
    static REDSTONE_LAMP: Internal.BlockItem;
    static LIGHT_BLUE_CARPET: Internal.BlockItem;
    static TUBE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static MANGROVE_WOOD: Internal.BlockItem;
    static LIME_GLAZED_TERRACOTTA: Internal.BlockItem;
    static DARK_OAK_DOOR: Internal.DoubleHighBlockItem;
    static STRIPPED_ACACIA_WOOD: Internal.BlockItem;
    static LIGHT_BLUE_SHULKER_BOX: Internal.BlockItem;
    static ARMOR_STAND: Internal.ArmorStandItem;
    static BROWN_STAINED_GLASS_PANE: Internal.BlockItem;
    static STONE_SLAB: Internal.BlockItem;
    static MANGROVE_BOAT: Internal.BoatItem;
    static PRISMARINE_WALL: Internal.BlockItem;
    static LIGHT_GRAY_BANNER: Internal.BannerItem;
    static RED_NETHER_BRICK_SLAB: Internal.BlockItem;
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: Internal.BlockItem;
    static CRIMSON_NYLIUM: Internal.BlockItem;
    static FIRE_CORAL_BLOCK: Internal.BlockItem;
    static EXPERIENCE_BOTTLE: Internal.ExperienceBottleItem;
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: Internal.BlockItem;
    static RED_NETHER_BRICKS: Internal.BlockItem;
    static BLACK_CONCRETE_POWDER: Internal.BlockItem;
    static SMITHING_TABLE: Internal.BlockItem;
    static DARK_OAK_TRAPDOOR: Internal.BlockItem;
    static LIGHT_BLUE_STAINED_GLASS_PANE: Internal.BlockItem;
    static ACACIA_SIGN: Internal.SignItem;
    static YELLOW_STAINED_GLASS: Internal.BlockItem;
    static VEX_SPAWN_EGG: Internal.SpawnEggItem;
    static PIGLIN_BRUTE_SPAWN_EGG: Internal.SpawnEggItem;
    static GRAY_CANDLE: Internal.BlockItem;
    static COBBLESTONE_STAIRS: Internal.BlockItem;
    static BLAZE_POWDER: Internal.Item;
    static MUSIC_DISC_MALL: Internal.RecordItem;
    static LARGE_AMETHYST_BUD: Internal.BlockItem;
    static BRICKS: Internal.BlockItem;
    static BUDDING_AMETHYST: Internal.BlockItem;
    static RABBIT_FOOT: Internal.Item;
    static MOSSY_COBBLESTONE_STAIRS: Internal.BlockItem;
    static SKULL_BANNER_PATTERN: Internal.BannerPatternItem;
    static ACACIA_TRAPDOOR: Internal.BlockItem;
    static COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static BEACON: Internal.BlockItem;
    static STRIPPED_SPRUCE_WOOD: Internal.BlockItem;
    static OAK_SAPLING: Internal.BlockItem;
    static SMOOTH_SANDSTONE_SLAB: Internal.BlockItem;
    static BIRCH_BUTTON: Internal.BlockItem;
    static STRIPPED_CRIMSON_STEM: Internal.BlockItem;
    static GLOW_INK_SAC: Internal.Item;
    static CYAN_BANNER: Internal.BannerItem;
    static POLISHED_BLACKSTONE: Internal.BlockItem;
    static GRASS: Internal.BlockItem;
    static SMOOTH_RED_SANDSTONE_SLAB: Internal.BlockItem;
    static BROWN_STAINED_GLASS: Internal.BlockItem;
    static MUSIC_DISC_CHIRP: Internal.RecordItem;
    static MUSIC_DISC_FAR: Internal.RecordItem;
    static RED_SANDSTONE_STAIRS: Internal.BlockItem;
    static JUNGLE_STAIRS: Internal.BlockItem;
    static COBBLED_DEEPSLATE_WALL: Internal.BlockItem;
    static BLUE_SHULKER_BOX: Internal.BlockItem;
    static WOODEN_AXE: Internal.AxeItem;
    static SPORE_BLOSSOM: Internal.BlockItem;
    static DEAD_BRAIN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static DEEPSLATE_TILE_STAIRS: Internal.BlockItem;
    static CROSSBOW: Internal.CrossbowItem;
    static HORN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static ORANGE_TULIP: Internal.BlockItem;
    static DIAMOND_PICKAXE: Internal.PickaxeItem;
    static GREEN_CARPET: Internal.BlockItem;
    static OXIDIZED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static RABBIT_HIDE: Internal.Item;
    static COOKED_COD: Internal.Item;
    static BLACK_BED: Internal.BedItem;
    static PUFFERFISH: Internal.Item;
    static ENDER_EYE: Internal.EnderEyeItem;
    static INFESTED_COBBLESTONE: Internal.BlockItem;
    static GOLD_INGOT: Internal.Item;
    static STRIPPED_MANGROVE_LOG: Internal.BlockItem;
    static ICE: Internal.BlockItem;
    static BLACK_BANNER: Internal.BannerItem;
    static OAK_CHEST_BOAT: Internal.BoatItem;
    static LIME_BANNER: Internal.BannerItem;
    static PINK_SHULKER_BOX: Internal.BlockItem;
    static SMALL_DRIPLEAF: Internal.DoubleHighBlockItem;
    static LILY_PAD: Internal.PlaceOnWaterBlockItem;
    static CREEPER_BANNER_PATTERN: Internal.BannerPatternItem;
    static GLOW_BERRIES: Internal.ItemNameBlockItem;
    static HOPPER: Internal.BlockItem;
    static PUFFERFISH_BUCKET: Internal.MobBucketItem;
    static PURPLE_BANNER: Internal.BannerItem;
    static HAY_BLOCK: Internal.BlockItem;
    static HEART_OF_THE_SEA: Internal.Item;
    static MOSSY_STONE_BRICK_WALL: Internal.BlockItem;
    static EXPOSED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static WARPED_WART_BLOCK: Internal.BlockItem;
    static NETHERITE_SWORD: Internal.SwordItem;
    static SHEEP_SPAWN_EGG: Internal.SpawnEggItem;
    static PODZOL: Internal.BlockItem;
    static DIAMOND_HOE: Internal.HoeItem;
    static GRAY_STAINED_GLASS_PANE: Internal.BlockItem;
    static YELLOW_SHULKER_BOX: Internal.BlockItem;
    static STRIPPED_WARPED_STEM: Internal.BlockItem;
    static SPRUCE_SIGN: Internal.SignItem;
    static RABBIT_STEW: Internal.BowlFoodItem;
    static DEAD_TUBE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static OAK_PRESSURE_PLATE: Internal.BlockItem;
    static LIGHT_GRAY_SHULKER_BOX: Internal.BlockItem;
    static CHAINMAIL_HELMET: Internal.ArmorItem;
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: Internal.BlockItem;
    static LIME_BED: Internal.BedItem;
    static TUFF: Internal.BlockItem;
    static GRAVEL: Internal.BlockItem;
    static BARRIER: Internal.BlockItem;
    static DRAGON_HEAD: Internal.StandingAndWallBlockItem;
    static MUSIC_DISC_MELLOHI: Internal.RecordItem;
    static IRON_DOOR: Internal.DoubleHighBlockItem;
    static BAT_SPAWN_EGG: Internal.SpawnEggItem;
    static VINDICATOR_SPAWN_EGG: Internal.SpawnEggItem;
    static SMOOTH_BASALT: Internal.BlockItem;
    static LIGHT_GRAY_STAINED_GLASS_PANE: Internal.BlockItem;
    static DEAD_HORN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static DROWNED_SPAWN_EGG: Internal.SpawnEggItem;
    static NETHER_STAR: Internal.SimpleFoiledItem;
    static CRIMSON_PRESSURE_PLATE: Internal.BlockItem;
    static FLINT_AND_STEEL: Internal.FlintAndSteelItem;
    static MAGENTA_BED: Internal.BedItem;
    static BONE: Internal.Item;
    static BROWN_TERRACOTTA: Internal.BlockItem;
    static END_STONE_BRICK_SLAB: Internal.BlockItem;
    static COMPARATOR: Internal.BlockItem;
    static LEATHER_HORSE_ARMOR: Internal.DyeableHorseArmorItem;
    static POLISHED_DIORITE_SLAB: Internal.BlockItem;
    static MUD_BRICK_WALL: Internal.BlockItem;
    static MOSS_BLOCK: Internal.BlockItem;
    static CRIMSON_STAIRS: Internal.BlockItem;
    static CREEPER_HEAD: Internal.StandingAndWallBlockItem;
    static JUNGLE_DOOR: Internal.DoubleHighBlockItem;
    static BLACK_TERRACOTTA: Internal.BlockItem;
    static COOKIE: Internal.Item;
    static GRANITE: Internal.BlockItem;
    static LEATHER: Internal.Item;
    static SALMON_BUCKET: Internal.MobBucketItem;
    static DANDELION: Internal.BlockItem;
    static PRISMARINE_BRICK_SLAB: Internal.BlockItem;
    static RED_STAINED_GLASS_PANE: Internal.BlockItem;
    static IRON_HORSE_ARMOR: Internal.HorseArmorItem;
    static IRON_SWORD: Internal.SwordItem;
    static BONE_MEAL: Internal.BoneMealItem;
    static GRAY_STAINED_GLASS: Internal.BlockItem;
    static DEAD_FIRE_CORAL_BLOCK: Internal.BlockItem;
    static POINTED_DRIPSTONE: Internal.BlockItem;
    static PURPUR_SLAB: Internal.BlockItem;
    static BIRCH_LEAVES: Internal.BlockItem;
    static ORANGE_STAINED_GLASS_PANE: Internal.BlockItem;
    static ALLAY_SPAWN_EGG: Internal.SpawnEggItem;
    static COW_SPAWN_EGG: Internal.SpawnEggItem;
    static BLUE_WOOL: Internal.BlockItem;
    static LIGHT_BLUE_TERRACOTTA: Internal.BlockItem;
    static MUSIC_DISC_WARD: Internal.RecordItem;
    static PINK_CONCRETE_POWDER: Internal.BlockItem;
    static BLUE_STAINED_GLASS: Internal.BlockItem;
    static ANDESITE_STAIRS: Internal.BlockItem;
    static CHORUS_FRUIT: Internal.ChorusFruitItem;
    static VINE: Internal.BlockItem;
    static COAL_BLOCK: Internal.BlockItem;
    static POLISHED_DEEPSLATE_WALL: Internal.BlockItem;
    static MUSIC_DISC_OTHERSIDE: Internal.RecordItem;
    static MOSSY_STONE_BRICK_STAIRS: Internal.BlockItem;
    static SCULK: Internal.BlockItem;
    static POLISHED_ANDESITE: Internal.BlockItem;
    static JUNGLE_SIGN: Internal.SignItem;
    static COCOA_BEANS: Internal.ItemNameBlockItem;
    static CYAN_STAINED_GLASS: Internal.BlockItem;
    static PURPLE_DYE: Internal.DyeItem;
    static CYAN_TERRACOTTA: Internal.BlockItem;
    static BLACKSTONE_STAIRS: Internal.BlockItem;
    static GLOBE_BANNER_PATTERN: Internal.BannerPatternItem;
    static SPRUCE_LOG: Internal.BlockItem;
    static TUBE_CORAL_BLOCK: Internal.BlockItem;
    static EXPOSED_CUT_COPPER: Internal.BlockItem;
    static GREEN_SHULKER_BOX: Internal.BlockItem;
    static CONDUIT: Internal.BlockItem;
    static GLISTERING_MELON_SLICE: Internal.Item;
    static RAVAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static SKELETON_HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static BRAIN_CORAL_BLOCK: Internal.BlockItem;
    static BAMBOO: Internal.Item;
    static COOKED_PORKCHOP: Internal.Item;
    static GOLDEN_SHOVEL: Internal.ShovelItem;
    static CUT_RED_SANDSTONE_SLAB: Internal.BlockItem;
    static MOSSY_STONE_BRICKS: Internal.BlockItem;
    static DIAMOND_HELMET: Internal.ArmorItem;
    static POLISHED_BLACKSTONE_BRICK_STAIRS: Internal.BlockItem;
    static SMOOTH_STONE_SLAB: Internal.BlockItem;
    static IRON_LEGGINGS: Internal.ArmorItem;
    static SMOKER: Internal.BlockItem;
    static STRIPPED_BIRCH_WOOD: Internal.BlockItem;
    static SPRUCE_BOAT: Internal.BoatItem;
    static MOSS_CARPET: Internal.BlockItem;
    static FIREWORK_ROCKET: Internal.FireworkRocketItem;
    static OCHRE_FROGLIGHT: Internal.BlockItem;
    static CHISELED_DEEPSLATE: Internal.BlockItem;
    static NETHER_BRICK_FENCE: Internal.BlockItem;
    static CHISELED_RED_SANDSTONE: Internal.BlockItem;
    static TADPOLE_BUCKET: Internal.MobBucketItem;
    static DRAGON_EGG: Internal.BlockItem;
    static DARK_OAK_PLANKS: Internal.BlockItem;
    static COOKED_RABBIT: Internal.Item;
    static END_STONE_BRICK_WALL: Internal.BlockItem;
    static GREEN_DYE: Internal.DyeItem;
    static MUSIC_DISC_WAIT: Internal.RecordItem;
    static RED_NETHER_BRICK_WALL: Internal.BlockItem;
    static LIME_CONCRETE_POWDER: Internal.BlockItem;
    static PRISMARINE_STAIRS: Internal.BlockItem;
    static MANGROVE_BUTTON: Internal.BlockItem;
    static AMETHYST_CLUSTER: Internal.BlockItem;
    static CHISELED_SANDSTONE: Internal.BlockItem;
    static DEEPSLATE_COAL_ORE: Internal.BlockItem;
    static STRIPPED_MANGROVE_WOOD: Internal.BlockItem;
    static STONE_BUTTON: Internal.BlockItem;
    static RED_DYE: Internal.DyeItem;
    static SPLASH_POTION: Internal.SplashPotionItem;
    static PURPLE_TERRACOTTA: Internal.BlockItem;
    static STRIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static OXEYE_DAISY: Internal.BlockItem;
    static SPRUCE_SLAB: Internal.BlockItem;
    static PINK_STAINED_GLASS_PANE: Internal.BlockItem;
    static REPEATING_COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static CRYING_OBSIDIAN: Internal.BlockItem;
    static CREEPER_SPAWN_EGG: Internal.SpawnEggItem;
    static SCULK_SHRIEKER: Internal.BlockItem;
    static GOLDEN_HORSE_ARMOR: Internal.HorseArmorItem;
    static POLISHED_DEEPSLATE: Internal.BlockItem;
    static YELLOW_CONCRETE: Internal.BlockItem;
    static LIGHT_GRAY_WOOL: Internal.BlockItem;
    static YELLOW_DYE: Internal.DyeItem;
    static CRIMSON_DOOR: Internal.DoubleHighBlockItem;
    static PURPLE_CARPET: Internal.BlockItem;
    static BEETROOT_SOUP: Internal.BowlFoodItem;
    static CRIMSON_ROOTS: Internal.BlockItem;
    static BLACKSTONE: Internal.BlockItem;
    static FLOWERING_AZALEA_LEAVES: Internal.BlockItem;
    static OAK_BOAT: Internal.BoatItem;
    static POLISHED_ANDESITE_STAIRS: Internal.BlockItem;
    static BROWN_BED: Internal.BedItem;
    static BLUE_CANDLE: Internal.BlockItem;
    static STRIPPED_CRIMSON_HYPHAE: Internal.BlockItem;
    static POLISHED_DEEPSLATE_STAIRS: Internal.BlockItem;
    static SPRUCE_WOOD: Internal.BlockItem;
    static TARGET: Internal.BlockItem;
    static SOUL_SAND: Internal.BlockItem;
    static DAYLIGHT_DETECTOR: Internal.BlockItem;
    static MOOSHROOM_SPAWN_EGG: Internal.SpawnEggItem;
    static LIGHT_BLUE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static PRISMARINE_BRICKS: Internal.BlockItem;
    static DAMAGED_ANVIL: Internal.ApothAnvilItem;
    static YELLOW_TERRACOTTA: Internal.BlockItem;
    static RAW_IRON_BLOCK: Internal.BlockItem;
    static TROPICAL_FISH_SPAWN_EGG: Internal.SpawnEggItem;
    static INK_SAC: Internal.Item;
    static LINGERING_POTION: Internal.LingeringPotionItem;
    static BRAIN_CORAL: Internal.BlockItem;
    static SPRUCE_DOOR: Internal.DoubleHighBlockItem;
    static GILDED_BLACKSTONE: Internal.BlockItem;
    static PRISMARINE: Internal.BlockItem;
    static SOUL_CAMPFIRE: Internal.BlockItem;
    static LECTERN: Internal.BlockItem;
    static SHROOMLIGHT: Internal.BlockItem;
    static GOLD_BLOCK: Internal.BlockItem;
    static BRICK_SLAB: Internal.BlockItem;
    static MUD_BRICKS: Internal.BlockItem;
    static JUNGLE_FENCE: Internal.BlockItem;
    static MANGROVE_LEAVES: Internal.BlockItem;
    static PAINTING: Internal.HangingEntityItem;
    static IRON_BLOCK: Internal.BlockItem;
    static ARROW: Internal.ArrowItem;
    static DEAD_BUBBLE_CORAL_BLOCK: Internal.BlockItem;
    static STRIPPED_DARK_OAK_LOG: Internal.BlockItem;
    static WHITE_CARPET: Internal.BlockItem;
    static DIAMOND_BLOCK: Internal.BlockItem;
    static CRIMSON_STEM: Internal.BlockItem;
    static SOUL_LANTERN: Internal.BlockItem;
    static BLUE_BANNER: Internal.BannerItem;
    static WRITABLE_BOOK: Internal.WritableBookItem;
    static PURPLE_SHULKER_BOX: Internal.BlockItem;
    static CUT_RED_SANDSTONE: Internal.BlockItem;
    static LIME_CANDLE: Internal.BlockItem;
    static STRAY_SPAWN_EGG: Internal.SpawnEggItem;
    static STRIPPED_BIRCH_LOG: Internal.BlockItem;
    static DEEPSLATE_TILE_WALL: Internal.BlockItem;
    static SLIME_BLOCK: Internal.BlockItem;
    static NETHER_WART_BLOCK: Internal.BlockItem;
    static DEEPSLATE_TILE_SLAB: Internal.BlockItem;
    static END_STONE_BRICKS: Internal.BlockItem;
    static SKELETON_SPAWN_EGG: Internal.SpawnEggItem;
    static CRIMSON_FENCE: Internal.BlockItem;
    static CRACKED_NETHER_BRICKS: Internal.BlockItem;
    static STRUCTURE_BLOCK: Internal.GameMasterBlockItem;
    static CAT_SPAWN_EGG: Internal.SpawnEggItem;
    static IRON_BOOTS: Internal.ArmorItem;
    static STRIPPED_OAK_WOOD: Internal.BlockItem;
    static PISTON: Internal.BlockItem;
    static DEEPSLATE_BRICK_WALL: Internal.BlockItem;
    static COD_BUCKET: Internal.MobBucketItem;
    static HONEY_BOTTLE: Internal.HoneyBottleItem;
    static EXPOSED_COPPER: Internal.BlockItem;
    static MUSIC_DISC_STRAD: Internal.RecordItem;
    static GREEN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static PINK_BED: Internal.BedItem;
    static LADDER: Internal.BlockItem;
    static SCULK_CATALYST: Internal.BlockItem;
    static BLUE_CONCRETE: Internal.BlockItem;
    static BLUE_STAINED_GLASS_PANE: Internal.BlockItem;
    static SNOW_BLOCK: Internal.BlockItem;
    static SALMON: Internal.Item;
    static DISPENSER: Internal.BlockItem;
    static DIAMOND_BOOTS: Internal.ArmorItem;
    static OAK_STAIRS: Internal.BlockItem;
    static RED_BANNER: Internal.BannerItem;
    static IRON_AXE: Internal.AxeItem;
    static DEEPSLATE_LAPIS_ORE: Internal.BlockItem;
    static SILVERFISH_SPAWN_EGG: Internal.SpawnEggItem;
    static ENDERMAN_SPAWN_EGG: Internal.SpawnEggItem;
    static GOLDEN_AXE: Internal.AxeItem;
    static OAK_FENCE_GATE: Internal.BlockItem;
    static GRANITE_STAIRS: Internal.BlockItem;
    static CHARCOAL: Internal.Item;
    static WOODEN_PICKAXE: Internal.PickaxeItem;
    static MELON: Internal.BlockItem;
    static ECHO_SHARD: Internal.Item;
    static DIRT_PATH: Internal.BlockItem;
    static DEEPSLATE: Internal.BlockItem;
    static WHITE_BED: Internal.BedItem;
    static DIORITE_STAIRS: Internal.BlockItem;
    static MANGROVE_FENCE_GATE: Internal.BlockItem;
    static RECOVERY_COMPASS: Internal.Item;
    static SNOW: Internal.BlockItem;
    static GRAY_GLAZED_TERRACOTTA: Internal.BlockItem;
    static GHAST_TEAR: Internal.Item;
    static GOLDEN_CARROT: Internal.Item;
    static FERN: Internal.BlockItem;
    static CORNFLOWER: Internal.BlockItem;
    static CHAIN_COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static ZOMBIE_VILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static LIME_STAINED_GLASS_PANE: Internal.BlockItem;
    static JUNGLE_FENCE_GATE: Internal.BlockItem;
    static GREEN_BANNER: Internal.BannerItem;
    static TRIPWIRE_HOOK: Internal.BlockItem;
    static EVOKER_SPAWN_EGG: Internal.SpawnEggItem;
    static SALMON_SPAWN_EGG: Internal.SpawnEggItem;
    static DEEPSLATE_BRICK_SLAB: Internal.BlockItem;
    static RAW_GOLD: Internal.Item;
    static BIRCH_SIGN: Internal.SignItem;
    static FROGSPAWN: Internal.PlaceOnWaterBlockItem;
    static SADDLE: Internal.SaddleItem;
    static YELLOW_WOOL: Internal.BlockItem;
    static TRIDENT: Internal.TridentItem;
    static LIGHT_BLUE_CONCRETE: Internal.BlockItem;
    static WARPED_BUTTON: Internal.BlockItem;
    static POLISHED_BLACKSTONE_BUTTON: Internal.BlockItem;
    static SLIME_SPAWN_EGG: Internal.SpawnEggItem;
    static OAK_WOOD: Internal.BlockItem;
    static ENDER_CHEST: Internal.BlockItem;
    static REDSTONE_BLOCK: Internal.BlockItem;
    static ORANGE_BED: Internal.BedItem;
    static CUT_COPPER_SLAB: Internal.BlockItem;
    static WANDERING_TRADER_SPAWN_EGG: Internal.SpawnEggItem;
    static WAXED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static CRIMSON_FENCE_GATE: Internal.BlockItem;
    static WAXED_WEATHERED_CUT_COPPER: Internal.BlockItem;
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static QUARTZ_BLOCK: Internal.BlockItem;
    static RAIL: Internal.BlockItem;
    static EMERALD_BLOCK: Internal.BlockItem;
    static CUT_COPPER: Internal.BlockItem;
    static POPPY: Internal.BlockItem;
    static ACACIA_BUTTON: Internal.BlockItem;
    static ANDESITE_WALL: Internal.BlockItem;
    static LEATHER_HELMET: Internal.DyeableArmorItem;
    static ACACIA_SAPLING: Internal.BlockItem;
    static CARTOGRAPHY_TABLE: Internal.BlockItem;
    static RED_TULIP: Internal.BlockItem;
    static TRAPPED_CHEST: Internal.BlockItem;
    static MANGROVE_LOG: Internal.BlockItem;
    static DARK_OAK_PRESSURE_PLATE: Internal.BlockItem;
    static CHIPPED_ANVIL: Internal.ApothAnvilItem;
    static MAGMA_BLOCK: Internal.BlockItem;
    static GUNPOWDER: Internal.Item;
    static OXIDIZED_COPPER: Internal.BlockItem;
    static BLACK_SHULKER_BOX: Internal.BlockItem;
    static BLUE_DYE: Internal.DyeItem;
    static PACKED_ICE: Internal.BlockItem;
    static PEONY: Internal.DoubleHighBlockItem;
    static CRIMSON_FUNGUS: Internal.BlockItem;
    static JUNGLE_PRESSURE_PLATE: Internal.BlockItem;
    static JUNGLE_WOOD: Internal.BlockItem;
    static ORANGE_SHULKER_BOX: Internal.BlockItem;
    static BEETROOT_SEEDS: Internal.ItemNameBlockItem;
    static IRON_CHESTPLATE: Internal.ArmorItem;
    static GOLDEN_APPLE: Internal.Item;
    static LIGHT_BLUE_BED: Internal.BedItem;
    static WARPED_TRAPDOOR: Internal.BlockItem;
    static CACTUS: Internal.Item;
    static TORCH: Internal.StandingAndWallBlockItem;
    static GLASS_BOTTLE: Internal.BottleItem;
    static MAGENTA_SHULKER_BOX: Internal.BlockItem;
    static STRUCTURE_VOID: Internal.BlockItem;
    static DEAD_TUBE_CORAL_BLOCK: Internal.BlockItem;
    static GREEN_CONCRETE_POWDER: Internal.BlockItem;
    static MUSIC_DISC_BLOCKS: Internal.RecordItem;
    static COOKED_BEEF: Internal.Item;
    static DIAMOND_SHOVEL: Internal.ShovelItem;
    static WOODEN_SWORD: Internal.SwordItem;
    static CRIMSON_SIGN: Internal.SignItem;
    static NETHER_BRICK: Internal.Item;
    static STONE_AXE: Internal.AxeItem;
    static DEAD_BUSH: Internal.BlockItem;
    static CYAN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static SPRUCE_CHEST_BOAT: Internal.BoatItem;
    static DEEPSLATE_BRICK_STAIRS: Internal.BlockItem;
    static WHITE_BANNER: Internal.BannerItem;
    static GRANITE_SLAB: Internal.BlockItem;
    static MOSSY_STONE_BRICK_SLAB: Internal.BlockItem;
    static OAK_SLAB: Internal.BlockItem;
    static DEAD_BUBBLE_CORAL: Internal.BlockItem;
    static WARPED_FENCE_GATE: Internal.BlockItem;
    static BROWN_MUSHROOM: Internal.BlockItem;
    static SPRUCE_PLANKS: Internal.BlockItem;
    static WOLF_SPAWN_EGG: Internal.SpawnEggItem;
    static MAGENTA_BANNER: Internal.BannerItem;
    static CYAN_SHULKER_BOX: Internal.BlockItem;
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static RAW_IRON: Internal.Item;
    static WEATHERED_CUT_COPPER_SLAB: Internal.BlockItem;
    static RED_SANDSTONE: Internal.BlockItem;
    static STRIPPED_DARK_OAK_WOOD: Internal.BlockItem;
    static INFESTED_DEEPSLATE: Internal.BlockItem;
    static IRON_BARS: Internal.BlockItem;
    static SANDSTONE_STAIRS: Internal.BlockItem;
    static BEDROCK: Internal.BlockItem;
    static TNT_MINECART: Internal.MinecartItem;
    static BEE_NEST: Internal.BlockItem;
    static ACTIVATOR_RAIL: Internal.BlockItem;
    static MUSIC_DISC_5: Internal.RecordItem;
    static DEAD_FIRE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static GOLDEN_HELMET: Internal.ArmorItem;
    static STRIPPED_WARPED_HYPHAE: Internal.BlockItem;
    static MAGENTA_CARPET: Internal.BlockItem;
    static HONEY_BLOCK: Internal.BlockItem;
    static STRIPPED_ACACIA_LOG: Internal.BlockItem;
    static RAW_GOLD_BLOCK: Internal.BlockItem;
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: Internal.BlockItem;
    static SPRUCE_SAPLING: Internal.BlockItem;
    static DOLPHIN_SPAWN_EGG: Internal.SpawnEggItem;
    static NETHERITE_PICKAXE: Internal.PickaxeItem;
    static GRANITE_WALL: Internal.BlockItem;
    static BRICK_STAIRS: Internal.BlockItem;
    static LIME_WOOL: Internal.BlockItem;
    static CHAINMAIL_CHESTPLATE: Internal.ArmorItem;
    static WOODEN_HOE: Internal.HoeItem;
    static HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static WATER_BUCKET: Internal.BucketItem;
    static SMOOTH_QUARTZ_SLAB: Internal.BlockItem;
    static WAXED_CUT_COPPER: Internal.BlockItem;
    static HORN_CORAL: Internal.BlockItem;
    static BLACKSTONE_WALL: Internal.BlockItem;
    static MUSIC_DISC_STAL: Internal.RecordItem;
    static SPONGE: Internal.BlockItem;
    static PIGLIN_BANNER_PATTERN: Internal.BannerPatternItem;
    static RAW_COPPER: Internal.Item;
    static DARK_OAK_BOAT: Internal.BoatItem;
    static REDSTONE_ORE: Internal.BlockItem;
    static ANDESITE_SLAB: Internal.BlockItem;
    static BOWL: Internal.Item;
    static BLACK_WOOL: Internal.BlockItem;
    static COBBLED_DEEPSLATE_STAIRS: Internal.BlockItem;
    static BEEF: Internal.Item;
    static COBBLESTONE_SLAB: Internal.BlockItem;
    static CYAN_CANDLE: Internal.BlockItem;
    static ACACIA_DOOR: Internal.DoubleHighBlockItem;
    static SPRUCE_STAIRS: Internal.BlockItem;
    static CRIMSON_HYPHAE: Internal.BlockItem;
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class any {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
}
type any_ = any;
declare class Stats {
    constructor()
    static readonly SWIM_ONE_CM: ResourceLocation;
    static readonly FLY_ONE_CM: ResourceLocation;
    static readonly CLEAN_SHULKER_BOX: ResourceLocation;
    static readonly TOTAL_WORLD_TIME: ResourceLocation;
    static readonly TUNE_NOTEBLOCK: ResourceLocation;
    static readonly DAMAGE_RESISTED: ResourceLocation;
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: ResourceLocation;
    static readonly INTERACT_WITH_BREWINGSTAND: ResourceLocation;
    static readonly INTERACT_WITH_CAMPFIRE: ResourceLocation;
    static readonly INSPECT_DISPENSER: ResourceLocation;
    static readonly INTERACT_WITH_FURNACE: ResourceLocation;
    static readonly OPEN_ENDERCHEST: ResourceLocation;
    static readonly ANIMALS_BRED: ResourceLocation;
    static readonly POT_FLOWER: ResourceLocation;
    static readonly INTERACT_WITH_STONECUTTER: ResourceLocation;
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: ResourceLocation;
    static readonly DAMAGE_ABSORBED: ResourceLocation;
    static readonly FISH_CAUGHT: ResourceLocation;
    static readonly INTERACT_WITH_ANVIL: ResourceLocation;
    static readonly BOAT_ONE_CM: ResourceLocation;
    static readonly PLAY_RECORD: ResourceLocation;
    static readonly DAMAGE_DEALT_RESISTED: ResourceLocation;
    static readonly RAID_WIN: ResourceLocation;
    static readonly DAMAGE_DEALT: ResourceLocation;
    static readonly DEATHS: ResourceLocation;
    static readonly INTERACT_WITH_SMOKER: ResourceLocation;
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: ResourceLocation;
    static readonly INTERACT_WITH_SMITHING_TABLE: ResourceLocation;
    static readonly INSPECT_DROPPER: ResourceLocation;
    static readonly DROP: ResourceLocation;
    static readonly INTERACT_WITH_LECTERN: ResourceLocation;
    static readonly PLAY_TIME: ResourceLocation;
    static readonly WALK_ONE_CM: ResourceLocation;
    static readonly CLIMB_ONE_CM: ResourceLocation;
    static readonly TRADED_WITH_VILLAGER: ResourceLocation;
    static readonly RAID_TRIGGER: ResourceLocation;
    static readonly STRIDER_ONE_CM: ResourceLocation;
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: ResourceLocation;
    static readonly INTERACT_WITH_BEACON: ResourceLocation;
    static readonly INSPECT_HOPPER: ResourceLocation;
    static readonly PLAY_NOTEBLOCK: ResourceLocation;
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: ResourceLocation;
    static readonly JUMP: ResourceLocation;
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: ResourceLocation;
    static readonly MOB_KILLS: ResourceLocation;
    static readonly OPEN_CHEST: ResourceLocation;
    static readonly SLEEP_IN_BED: ResourceLocation;
    static readonly CLEAN_ARMOR: ResourceLocation;
    static readonly CROUCH_ONE_CM: ResourceLocation;
    static readonly TALKED_TO_VILLAGER: ResourceLocation;
    static readonly DAMAGE_DEALT_ABSORBED: ResourceLocation;
    static readonly INTERACT_WITH_LOOM: ResourceLocation;
    static readonly LEAVE_GAME: ResourceLocation;
    static readonly HORSE_ONE_CM: ResourceLocation;
    static readonly WALK_ON_WATER_ONE_CM: ResourceLocation;
    static readonly MINECART_ONE_CM: ResourceLocation;
    static readonly ENCHANT_ITEM: ResourceLocation;
    static readonly TIME_SINCE_DEATH: ResourceLocation;
    static readonly DAMAGE_TAKEN: ResourceLocation;
    static readonly INTERACT_WITH_BLAST_FURNACE: ResourceLocation;
    static readonly TRIGGER_TRAPPED_CHEST: ResourceLocation;
    static readonly INTERACT_WITH_GRINDSTONE: ResourceLocation;
    static readonly OPEN_BARREL: ResourceLocation;
    static readonly SPRINT_ONE_CM: ResourceLocation;
    static readonly DAMAGE_BLOCKED_BY_SHIELD: ResourceLocation;
    static readonly EAT_CAKE_SLICE: ResourceLocation;
    static readonly INTERACT_WITH_CRAFTING_TABLE: ResourceLocation;
    static readonly CLEAN_BANNER: ResourceLocation;
    static readonly TARGET_HIT: ResourceLocation;
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: ResourceLocation;
    static readonly PIG_ONE_CM: ResourceLocation;
    static readonly OPEN_SHULKER_BOX: ResourceLocation;
    static readonly USE_CAULDRON: ResourceLocation;
    static readonly AVIATE_ONE_CM: ResourceLocation;
    static readonly FILL_CAULDRON: ResourceLocation;
}
type Stats_ = Stats;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    static parse(arg0: Internal.CharSequence_): Duration;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    minus(arg0: Duration_): this;
    isNegative(): boolean;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    plusNanos(arg0: number): this;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    toDaysPart(): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    plusHours(arg0: number): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    minusMillis(arg0: number): this;
    dividedBy(arg0: Duration_): number;
    abs(): this;
    minusMinutes(arg0: number): this;
    static ofHours(arg0: number): Duration;
    withNanos(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: Duration;
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getNbt(): Internal.CompoundTag;
    getCount(): number;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    withRolls(rolls: Internal.IntProvider_): this;
    getChance(): number;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    withCount(count: number): this;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    withChance(chance: number): this;
    hasChance(): boolean;
    withRolls(min: number, max: number): this;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get nbt(): Internal.CompoundTag
    get count(): number
    get chance(): number
    get empty(): boolean
    static readonly EMPTY: OutputItem;
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    static water(): Internal.FluidStackJS;
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: ResourceLocation;
    static readonly WATER_ID: ResourceLocation;
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    static of(o: InputItem_): InputItem;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    validForMatching(): boolean;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    unwrap(): Internal.List<InputItem>;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    isEmpty(): boolean;
    toJson(): Internal.JsonElement;
    withCount(count: number): this;
    kjs$asIngredient(): Internal.Ingredient;
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: InputItem;
    static readonly PARSE_CACHE: {};
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare class DamageSource implements Internal.DamageSourceAccessor, Internal.DamageSourceUtil$DmgSrcCopy {
    constructor(arg0: string)
    isBypassArmor(): boolean;
    isNoAggro(): boolean;
    getSourcePosition(): Vec3;
    isBypassMagic(): boolean;
    scalesWithDifficulty(): boolean;
    static thrown(arg0: Internal.Entity_, arg1: Internal.Entity_): DamageSource;
    setExplosion(): this;
    isDamageHelmet(): boolean;
    static fireball(arg0: Internal.Fireball_, arg1: Internal.Entity_): DamageSource;
    setIsFall(): this;
    static sting(arg0: Internal.LivingEntity_): DamageSource;
    static playerAttack(arg0: Internal.Player_): DamageSource;
    bypassInvul(): this;
    getType(): string;
    getActual(): Internal.Entity;
    static create(arg0: string): DamageSource;
    callBypassInvul(): this;
    static indirectMagic(arg0: Internal.Entity_, arg1: Internal.Entity_): DamageSource;
    isMagic(): boolean;
    static explosion(arg0: Internal.LivingEntity_): DamageSource;
    static sonicBoom(arg0: Internal.Entity_): DamageSource;
    static thorns(arg0: Internal.Entity_): DamageSource;
    getImmediate(): Internal.Entity;
    static mobAttack(arg0: Internal.LivingEntity_): DamageSource;
    static witherSkull(arg0: Internal.WitherSkull_, arg1: Internal.Entity_): DamageSource;
    setMagic(): this;
    isProjectile(): boolean;
    setIsFire(): this;
    isBypassEnchantments(): boolean;
    setScalesWithDifficulty(): this;
    damageHelmet(): this;
    static badRespawnPointExplosion(): DamageSource;
    static indirectMobAttack(arg0: Internal.Entity_, arg1: Internal.LivingEntity_): DamageSource;
    static fireworks(arg0: Internal.FireworkRocketEntity_, arg1: Internal.Entity_): DamageSource;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): Internal.Component;
    isFire(): boolean;
    copyFrom(arg0: DamageSource_): void;
    callBypassMagic(): this;
    static create_$md$a21649$0(arg0: string): DamageSource;
    setProjectile(): this;
    getPlayer(): Internal.Player;
    static trident(arg0: Internal.Entity_, arg1: Internal.Entity_): DamageSource;
    bypassMagic(): this;
    setNoAggro(): this;
    isExplosion(): boolean;
    isBypassInvul(): boolean;
    static arrow(arg0: Internal.AbstractArrow_, arg1: Internal.Entity_): DamageSource;
    isFall(): boolean;
    getFoodExhaustion(): number;
    callBypassArmor(): this;
    static explosion(arg0: Internal.Explosion_): DamageSource;
    bypassEnchantments(): this;
    isCreativePlayer(): boolean;
    bypassArmor(): this;
    get bypassArmor(): boolean
    get noAggro(): boolean
    get sourcePosition(): Vec3
    get bypassMagic(): boolean
    get damageHelmet(): boolean
    get type(): string
    get actual(): Internal.Entity
    get magic(): boolean
    get immediate(): Internal.Entity
    get projectile(): boolean
    get bypassEnchantments(): boolean
    get fire(): boolean
    get player(): Internal.Player
    get explosion(): boolean
    get bypassInvul(): boolean
    get fall(): boolean
    get foodExhaustion(): number
    get creativePlayer(): boolean
    static readonly DROWN: DamageSource;
    static readonly ANVIL: DamageSource;
    static readonly DRY_OUT: DamageSource;
    static readonly MAGIC: DamageSource;
    static readonly CACTUS: DamageSource;
    static readonly FALL: DamageSource;
    static readonly STALAGMITE: DamageSource;
    static readonly IN_WALL: DamageSource;
    readonly msgId: string;
    static readonly FREEZE: DamageSource;
    static readonly SWEET_BERRY_BUSH: DamageSource;
    static readonly DRAGON_BREATH: DamageSource;
    static readonly LIGHTNING_BOLT: DamageSource;
    static readonly ON_FIRE: DamageSource;
    static readonly IN_FIRE: DamageSource;
    static readonly FLY_INTO_WALL: DamageSource;
    static readonly LAVA: DamageSource;
    static readonly OUT_OF_WORLD: DamageSource;
    static readonly CRAMMING: DamageSource;
    static readonly WITHER: DamageSource;
    static readonly FALLING_STALACTITE: DamageSource;
    static readonly GENERIC: DamageSource;
    static readonly FALLING_BLOCK: DamageSource;
    static readonly HOT_FLOOR: DamageSource;
    static readonly STARVE: DamageSource;
}
type DamageSource_ = "wither" | "lightningBolt" | "lava" | "outOfWorld" | "starve" | "dragonBreath" | "fallingBlock" | "inWall" | "cactus" | "onFire" | "stalagmite" | "flyIntoWall" | "dryout" | "freeze" | DamageSource | "anvil" | "fall" | "magic" | "inFire" | "sweetBerryBush" | "generic" | "fallingStalactite" | "cramming" | "hotFloor" | "drown";
declare interface Color {
    of(o: any): Internal.Color;
    rgba(r: number, g: number, b: number, a: number): Internal.Color;
    createMapped(o: any, ...names: string[]): Internal.Color;
    readonly DARK_PURPLE: Internal.ChatFormatting;
    readonly YELLOW: Internal.ChatFormatting;
    readonly CYAN_DYE: Internal.DyeColor;
    readonly GRAY: Internal.ChatFormatting;
    readonly BROWN_DYE: Internal.DyeColor;
    readonly LIGHT_PURPLE: Internal.ChatFormatting;
    readonly PURPLE_DYE: Internal.DyeColor;
    readonly DARK_AQUA: Internal.ChatFormatting;
    readonly GREEN: Internal.ChatFormatting;
    readonly LIGHT_GRAY_DYE: Internal.DyeColor;
    readonly WHITE: Internal.ChatFormatting;
    readonly MAGENTA_DYE: Internal.DyeColor;
    readonly RED: Internal.ChatFormatting;
    readonly BLACK_DYE: Internal.DyeColor;
    readonly TEXT: {"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting};
    readonly RED_DYE: Internal.DyeColor;
    readonly GRAY_DYE: Internal.DyeColor;
    readonly DARK_GRAY: Internal.ChatFormatting;
    readonly NONE: Internal.NoColor;
    readonly ORANGE_DYE: Internal.DyeColor;
    readonly WHITE_DYE: Internal.DyeColor;
    readonly DYE: {"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor};
    readonly BLACK: Internal.ChatFormatting;
    readonly BLUE: Internal.ChatFormatting;
    readonly DARK_GREEN: Internal.ChatFormatting;
    readonly DARK_RED: Internal.ChatFormatting;
    readonly GOLD: Internal.ChatFormatting;
    readonly MAP: {"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting};
    readonly GREEN_DYE: Internal.DyeColor;
    readonly LIGHT_BLUE_DYE: Internal.DyeColor;
    readonly AQUA: Internal.ChatFormatting;
    readonly DARK_BLUE: Internal.ChatFormatting;
    readonly PINK_DYE: Internal.DyeColor;
    readonly BLUE_DYE: Internal.DyeColor;
    readonly YELLOW_DYE: Internal.DyeColor;
    readonly LIME_DYE: Internal.DyeColor;
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    static toPrettyString(json: Internal.JsonElement_): string;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static parse(string: string): any;
    static toObject(json: Internal.JsonElement_): any;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static toPrimitive(element: Internal.JsonElement_): any;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    static toString(json: Internal.JsonElement_): string;
    static of(o: any): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
}
type JsonIO_ = JsonIO;
declare class Platform {
    constructor()
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getMcVersion(): string;
    static getList(): Internal.Set<string>;
    static isClientEnvironment(): boolean;
    static isForge(): boolean;
    static isFabric(): boolean;
    static getModVersion(): string;
    static isGeneratingData(): boolean;
    static getMinecraftVersionString(): string;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get mcVersion(): string
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get forge(): boolean
    get fabric(): boolean
    get modVersion(): string
    get generatingData(): boolean
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
    get name(): string
}
type Platform_ = Platform;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getVariants(item: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.NonNullList<Internal.ItemStack>>;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.NonNullList<Internal.ItemStack>>
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: Internal.UUID;
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: Internal.UUID;
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    longValue(): number;
    shortValue(): number;
    doubleValue(): number;
    intValue(): number;
    floatValue(): number;
    byteValue(): number;
}
type number_ = number;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    write(buf: Internal.FriendlyByteBuf_): void;
    setAtlasIcon(icon: string): void;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    setIcon(icon: string): void;
    static of(cx: Internal.Context_, object: any): Notification;
    show(): void;
    setItemIcon(stack: Internal.ItemStack_): void;
    set atlasIcon(icon: string)
    set icon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: Duration;
    backgroundColor: Internal.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: Internal.SimpleColor;
    static readonly DEFAULT_BORDER_COLOR: Internal.SimpleColor;
    borderColor: Internal.Color;
    text: Internal.Component;
    outlineColor: Internal.Color;
    textShadow: boolean;
    static readonly NO_TEXT: Internal.Component[];
}
type Notification_ = Notification;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
declare interface Facing {
    readonly south: Internal.Direction;
    readonly up: Internal.Direction;
    readonly UP: Internal.Direction;
    readonly NORTH: Internal.Direction;
    readonly east: Internal.Direction;
    readonly DOWN: Internal.Direction;
    readonly EAST: Internal.Direction;
    readonly west: Internal.Direction;
    readonly north: Internal.Direction;
    readonly down: Internal.Direction;
    readonly ALL: {"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction};
    readonly WEST: Internal.Direction;
    readonly SOUTH: Internal.Direction;
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class CarvingGenerationStep extends Internal.Enum<CarvingGenerationStep> implements Internal.StringRepresentable {
    static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
    static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
    getSerializedName(): string;
    getName(): string;
    static valueOf(arg0: string): CarvingGenerationStep;
    static values(): CarvingGenerationStep[];
    get serializedName(): string
    get name(): string
    static readonly AIR: CarvingGenerationStep;
    static readonly LIQUID: CarvingGenerationStep;
    static readonly CODEC: Internal.Codec<CarvingGenerationStep>;
}
type CarvingGenerationStep_ = "liquid" | CarvingGenerationStep | "air";
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: Internal.WildcardIngredient;
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: Internal.Ingredient;
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static asin(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static expm1(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static ceil(arg0: number): number;
    static atan(arg0: number): number;
    static exp(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static random(): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static abs(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static round(arg0: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static rint(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static absExact(arg0: number): number;
    static signum(arg0: number): number;
    static log10(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static cos(arg0: number): number;
    static tan(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static toRadians(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static sinh(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static toDegrees(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static tanh(arg0: number): number;
    static nextDown(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static pow(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static readonly PI: 3.141592653589793;
    static readonly E: 2.718281828459045;
}
type JavaMath_ = JavaMath;
declare class BlockProperties {
    constructor()
    static readonly MAX_ROTATIONS_16: 15;
    static readonly LEVEL_FLOWING: Internal.IntegerProperty;
    static readonly PERSISTENT: Internal.BooleanProperty;
    static readonly HORIZONTAL_FACING: Internal.DirectionProperty;
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly NOTE: Internal.IntegerProperty;
    static readonly AGE_5: Internal.IntegerProperty;
    static readonly EGGS: Internal.IntegerProperty;
    static readonly NORTH: Internal.BooleanProperty;
    static readonly HAS_RECORD: Internal.BooleanProperty;
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: Internal.IntegerProperty;
    static readonly HANGING: Internal.BooleanProperty;
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: Internal.IntegerProperty;
    static readonly HAS_BOTTLE_2: Internal.BooleanProperty;
    static readonly LAYERS: Internal.IntegerProperty;
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CONDITIONAL: Internal.BooleanProperty;
    static readonly LOCKED: Internal.BooleanProperty;
    static readonly POWER: Internal.IntegerProperty;
    static readonly EYE: Internal.BooleanProperty;
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: 1;
    static readonly ATTACHED: Internal.BooleanProperty;
    static readonly MAX_LEVEL_15: 15;
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: 7;
    static readonly EXTENDED: Internal.BooleanProperty;
    static readonly INVERTED: Internal.BooleanProperty;
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: Internal.IntegerProperty;
    static readonly LIT: Internal.BooleanProperty;
    static readonly DISTANCE: Internal.IntegerProperty;
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: Internal.IntegerProperty;
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: 8;
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: 0;
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: Internal.BooleanProperty;
    static readonly ENABLED: Internal.BooleanProperty;
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: Internal.BooleanProperty;
    static readonly UNSTABLE: Internal.BooleanProperty;
    static readonly VINE_END: Internal.BooleanProperty;
    static readonly AGE_4: Internal.IntegerProperty;
    static readonly EAST: Internal.BooleanProperty;
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: 4;
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: 7;
    static readonly DOWN: Internal.BooleanProperty;
    static readonly AGE_15: Internal.IntegerProperty;
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: Internal.BooleanProperty;
    static readonly BLOOM: Internal.BooleanProperty;
    static readonly SHRIEKING: Internal.BooleanProperty;
    static readonly AGE_1: Internal.IntegerProperty;
    static readonly FACING_HOPPER: Internal.DirectionProperty;
    static readonly VERTICAL_DIRECTION: Internal.DirectionProperty;
    static readonly PICKLES: Internal.IntegerProperty;
    static readonly MAX_AGE_25: 25;
    static readonly LEVEL_HONEY: Internal.IntegerProperty;
    static readonly MAX_AGE_4: 4;
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: Internal.IntegerProperty;
    static readonly SNOWY: Internal.BooleanProperty;
    static readonly TRIGGERED: Internal.BooleanProperty;
    static readonly SIGNAL_FIRE: Internal.BooleanProperty;
    static readonly LEVEL_CAULDRON: Internal.IntegerProperty;
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: Internal.IntegerProperty;
    static readonly DRAG: Internal.BooleanProperty;
    static readonly CAN_SUMMON: Internal.BooleanProperty;
    static readonly LEVEL: Internal.IntegerProperty;
    static readonly STAGE: Internal.IntegerProperty;
    static readonly MAX_AGE_5: 5;
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: Internal.BooleanProperty;
    static readonly BITES: Internal.IntegerProperty;
    static readonly IN_WALL: Internal.BooleanProperty;
    static readonly AGE_25: Internal.IntegerProperty;
    static readonly STABILITY_MAX_DISTANCE: 7;
    static readonly HAS_BOTTLE_1: Internal.BooleanProperty;
    static readonly AGE_7: Internal.IntegerProperty;
    static readonly SOUTH: Internal.BooleanProperty;
    static readonly MAX_AGE_15: 15;
    static readonly DISARMED: Internal.BooleanProperty;
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: Internal.IntegerProperty;
    static readonly DELAY: Internal.IntegerProperty;
    static readonly MIN_LEVEL: 0;
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: 1;
    static readonly BOTTOM: Internal.BooleanProperty;
    static readonly HAS_BOOK: Internal.BooleanProperty;
    static readonly CANDLES: Internal.IntegerProperty;
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: Internal.BooleanProperty;
    static readonly SHORT: Internal.BooleanProperty;
    static readonly BERRIES: Internal.BooleanProperty;
    static readonly MAX_AGE_2: 2;
    static readonly HAS_BOTTLE_0: Internal.BooleanProperty;
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: Internal.IntegerProperty;
    static readonly MAX_LEVEL_3: 3;
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: Internal.BooleanProperty;
    static readonly MAX_AGE_3: 3;
    static readonly OCCUPIED: Internal.BooleanProperty;
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: Internal.DirectionProperty;
}
type BlockProperties_ = BlockProperties;
declare class DecorationGenerationStep extends Internal.Enum<DecorationGenerationStep> implements Internal.StringRepresentable {
    static valueOf(arg0: string): DecorationGenerationStep;
    static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
    static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
    getSerializedName(): string;
    getName(): string;
    static values(): DecorationGenerationStep[];
    get serializedName(): string
    get name(): string
    static readonly UNDERGROUND_STRUCTURES: DecorationGenerationStep;
    static readonly RAW_GENERATION: DecorationGenerationStep;
    static readonly UNDERGROUND_ORES: DecorationGenerationStep;
    static readonly STRONGHOLDS: DecorationGenerationStep;
    static readonly SURFACE_STRUCTURES: DecorationGenerationStep;
    static readonly LOCAL_MODIFICATIONS: DecorationGenerationStep;
    static readonly CODEC: Internal.Codec<DecorationGenerationStep>;
    static readonly VEGETAL_DECORATION: DecorationGenerationStep;
    static readonly TOP_LAYER_MODIFICATION: DecorationGenerationStep;
    static readonly LAKES: DecorationGenerationStep;
    static readonly FLUID_SPRINGS: DecorationGenerationStep;
    static readonly UNDERGROUND_DECORATION: DecorationGenerationStep;
}
type DecorationGenerationStep_ = "underground_ores" | "top_layer_modification" | "fluid_springs" | "strongholds" | "lakes" | "local_modifications" | DecorationGenerationStep | "surface_structures" | "underground_structures" | "underground_decoration" | "raw_generation" | "vegetal_decoration";
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    l(v: number): Internal.Tag;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    listTag(): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    s(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    longTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    intTag(v: number): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    la(v: number[]): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    f(v: number): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTag(v: any): Internal.Tag;
    toTagList(list: any): Internal.ListTag;
    toTagCompound(v: any): Internal.CompoundTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    i(v: number): Internal.Tag;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: number, arg1: number, arg2: number)
    north(): this;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    south(arg0: number): this;
    toShortString(): string;
    above(arg0: number): this;
    west(arg0: number): this;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    getZ(): number;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    above(): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    east(): this;
    north(arg0: number): this;
    below(): this;
    west(): this;
    distManhattan(arg0: Vec3i_): number;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    compareTo(arg0: Vec3i_): number;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: Vec3i;
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare interface FluidAmounts {
    readonly MILLIBUCKET: 1;
    readonly MB: 1;
    readonly INGOT: 90;
    readonly BOTTLE: 250;
    readonly B: 1000;
    readonly NUGGET: 10;
    readonly METAL_BLOCK: 810;
    readonly BUCKET: 1000;
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Blocks {
    constructor()
    static lambda$static$4(arg0: Internal.BlockState_): number;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static m_187432_(arg0: Internal.BlockState_): number;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static rebuildCache(): void;
    static lambda$static$2(): Internal.Holder<any>;
    static lambda$static$14(arg0: Internal.BlockState_): number;
    static lambda$static$37(arg0: Internal.BlockState_): number;
    static m_50855_(arg0: Internal.BlockState_): number;
    static m_152681_(arg0: Internal.BlockState_): number;
    static pistonBase(arg0: boolean): Internal.PistonBaseBlock;
    static m_50859_(arg0: Internal.BlockState_): number;
    static lambda$litBlockEmission$53(arg0: number, arg1: Internal.BlockState_): number;
    static stainedGlass(arg0: Internal.DyeColor_): Internal.StainedGlassBlock;
    static lambda$static$0(arg0: Internal.BlockState_): number;
    static m_152691_(arg0: Internal.BlockState_): number;
    static lambda$static$16(): Internal.Item;
    static m_50846_(arg0: Internal.BlockState_): number;
    static lambda$static$18(): Internal.Item;
    static lambda$static$38(): Internal.Holder<any>;
    static m_152670_(arg0: Internal.BlockState_): number;
    static lambda$static$22(arg0: Internal.BlockState_): number;
    static m_50754_(arg0: Internal.BlockState_): number;
    static m_152631_(arg0: Internal.BlockState_): number;
    static lambda$static$45(arg0: Internal.BlockState_): number;
    static lambda$static$24(arg0: Internal.BlockState_): number;
    static m_152604_(arg0: Internal.BlockState_): number;
    static netherStem(arg0: Internal.MaterialColor_): Internal.Block;
    static litBlockEmission(arg0: number): Internal.ToIntFunction<Internal.BlockState>;
    static m_187434_(arg0: Internal.BlockState_): number;
    static m_152673_(arg0: Internal.BlockState_): number;
    static ocelotOrParrot(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static lambda$pistonBase$58(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static lambda$netherStem$56(arg0: Internal.MaterialColor_, arg1: Internal.BlockState_): Internal.MaterialColor;
    static lambda$static$5(arg0: Internal.BlockState_): number;
    static log(arg0: Internal.MaterialColor_, arg1: Internal.MaterialColor_): Internal.RotatedPillarBlock;
    static m_187430_(arg0: Internal.BlockState_): number;
    static m_152638_(arg0: Internal.BlockState_): number;
    static m_152650_(arg0: Internal.BlockState_): number;
    static lambda$static$33(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static lambda$static$10(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static lambda$static$31(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static m_50885_(arg0: Internal.BlockState_): number;
    static lambda$static$3(): Internal.Holder<any>;
    static lambda$static$15(arg0: Internal.BlockState_): number;
    static m_50857_(arg0: Internal.BlockState_): number;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    static lambda$log$55(arg0: Internal.MaterialColor_, arg1: Internal.MaterialColor_, arg2: Internal.BlockState_): Internal.MaterialColor;
    static m_181167_(arg0: Internal.BlockState_): number;
    static m_152683_(arg0: Internal.BlockState_): number;
    static lambda$static$48(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static lambda$static$1(arg0: Internal.BlockState_): number;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static m_50871_(arg0: Internal.BlockState_): number;
    static lambda$static$17(): Internal.Item;
    static bed(arg0: Internal.DyeColor_): Internal.BedBlock;
    static lambda$static$19(): Internal.Item;
    static lambda$static$39(): Internal.Holder<any>;
    static m_187408_(arg0: Internal.BlockState_): number;
    static m_152685_(arg0: Internal.BlockState_): number;
    static m_50827_(arg0: Internal.BlockState_): number;
    static shulkerBox(arg0: Internal.DyeColor_, arg1: Internal.BlockBehaviour$Properties_): Internal.ShulkerBoxBlock;
    static lambda$static$44(arg0: Internal.BlockState_): number;
    static m_152689_(arg0: Internal.BlockState_): number;
    static lambda$static$25(arg0: Internal.BlockState_): number;
    static m_152606_(arg0: Internal.BlockState_): number;
    static lambda$static$23(arg0: Internal.BlockState_): number;
    static leaves(arg0: Internal.SoundType_): Internal.LeavesBlock;
    static lambda$shulkerBox$57(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static lambda$static$9(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static m_187436_(arg0: Internal.BlockState_): number;
    static lambda$static$8(): Internal.BlockEntityType<any>;
    static lambda$bed$54(arg0: Internal.DyeColor_, arg1: Internal.BlockState_): Internal.MaterialColor;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static MANGROVE_PROPAGULE: Internal.MangrovePropaguleBlock;
    static STONE_SLAB: Internal.SlabBlock;
    static POTTED_CRIMSON_FUNGUS: Internal.FlowerPotBlock;
    static DEEPSLATE_BRICK_STAIRS: Internal.StairBlock;
    static POLISHED_ANDESITE: Internal.Block;
    static RED_NETHER_BRICKS: Internal.Block;
    static TORCH: Internal.TorchBlock;
    static COAL_BLOCK: Internal.Block;
    static STRIPPED_CRIMSON_STEM: Internal.RotatedPillarBlock;
    static FIRE_CORAL_BLOCK: Internal.CoralBlock;
    static WEEPING_VINES_PLANT: Internal.WeepingVinesPlantBlock;
    static PEONY: Internal.TallFlowerBlock;
    static CARROTS: Internal.CarrotBlock;
    static YELLOW_CANDLE: Internal.CandleBlock;
    static CYAN_STAINED_GLASS: Internal.StainedGlassBlock;
    static BLUE_STAINED_GLASS: Internal.StainedGlassBlock;
    static TUBE_CORAL_BLOCK: Internal.CoralBlock;
    static SMITHING_TABLE: Internal.SmithingTableBlock;
    static ACACIA_TRAPDOOR: Internal.TrapDoorBlock;
    static MAGENTA_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static PLAYER_WALL_HEAD: Internal.PlayerWallHeadBlock;
    static DEAD_HORN_CORAL_FAN: Internal.BaseCoralFanBlock;
    static MANGROVE_LOG: Internal.RotatedPillarBlock;
    static SPRUCE_BUTTON: Internal.WoodButtonBlock;
    static IRON_ORE: Internal.DropExperienceBlock;
    static TRIPWIRE: Internal.TripWireBlock;
    static BLACK_CANDLE_CAKE: Internal.CandleCakeBlock;
    static LIGHT_BLUE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static ACACIA_STAIRS: Internal.StairBlock;
    static CRIMSON_FUNGUS: Internal.FungusBlock;
    static BUBBLE_CORAL_BLOCK: Internal.CoralBlock;
    static LIGHT_BLUE_STAINED_GLASS: Internal.StainedGlassBlock;
    static PRISMARINE_SLAB: Internal.SlabBlock;
    static DEAD_TUBE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static PURPLE_BANNER: Internal.BannerBlock;
    static RED_NETHER_BRICK_SLAB: Internal.SlabBlock;
    static SCULK_SENSOR: Internal.SculkSensorBlock;
    static YELLOW_WOOL: Internal.Block;
    static MAGENTA_CANDLE_CAKE: Internal.CandleCakeBlock;
    static SAND: Internal.SandBlock;
    static MYCELIUM: Internal.MyceliumBlock;
    static LIGHT_GRAY_BANNER: Internal.BannerBlock;
    static ORANGE_CANDLE: Internal.CandleBlock;
    static CORNFLOWER: Internal.FlowerBlock;
    static DARK_OAK_DOOR: Internal.DoorBlock;
    static GRANITE_SLAB: Internal.SlabBlock;
    static REDSTONE_LAMP: Internal.RedstoneLampBlock;
    static LIGHT: Internal.LightBlock;
    static TUBE_CORAL_FAN: Internal.CoralFanBlock;
    static WARPED_FENCE_GATE: Internal.FenceGateBlock;
    static DANDELION: Internal.FlowerBlock;
    static PINK_TERRACOTTA: Internal.Block;
    static WARPED_BUTTON: Internal.WoodButtonBlock;
    static RED_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static SOUL_SOIL: Internal.Block;
    static ACACIA_FENCE: Internal.FenceBlock;
    static CRIMSON_SIGN: Internal.StandingSignBlock;
    static HEAVY_WEIGHTED_PRESSURE_PLATE: Internal.WeightedPressurePlateBlock;
    static PRISMARINE_STAIRS: Internal.StairBlock;
    static TWISTING_VINES_PLANT: Internal.TwistingVinesPlantBlock;
    static DEEPSLATE_BRICK_SLAB: Internal.SlabBlock;
    static OAK_WOOD: Internal.RotatedPillarBlock;
    static PINK_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static RED_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static WARPED_WART_BLOCK: Internal.Block;
    static EXPOSED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static COARSE_DIRT: Internal.Block;
    static DEEPSLATE_REDSTONE_ORE: Internal.RedStoneOreBlock;
    static TUFF: Internal.Block;
    static ACACIA_LOG: Internal.RotatedPillarBlock;
    static DEEPSLATE_IRON_ORE: Internal.DropExperienceBlock;
    static PURPLE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static LIGHTNING_ROD: Internal.LightningRodBlock;
    static COBBLED_DEEPSLATE_SLAB: Internal.SlabBlock;
    static RED_CARPET: Internal.WoolCarpetBlock;
    static LILY_PAD: Internal.WaterlilyBlock;
    static GREEN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static BARRIER: Internal.BarrierBlock;
    static PINK_CARPET: Internal.WoolCarpetBlock;
    static DRAGON_HEAD: Internal.SkullBlock;
    static YELLOW_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static DEAD_BUBBLE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static STRIPPED_BIRCH_WOOD: Internal.RotatedPillarBlock;
    static SEAGRASS: Internal.SeagrassBlock;
    static HORN_CORAL: Internal.CoralPlantBlock;
    static MOSSY_STONE_BRICKS: Internal.Block;
    static SPRUCE_SIGN: Internal.StandingSignBlock;
    static WAXED_COPPER_BLOCK: Internal.Block;
    static STONE_BRICK_STAIRS: Internal.StairBlock;
    static GRANITE_WALL: Internal.WallBlock;
    static NETHER_BRICK_FENCE: Internal.FenceBlock;
    static MOSS_CARPET: Internal.CarpetBlock;
    static DARK_OAK_PLANKS: Internal.Block;
    static MAGENTA_WALL_BANNER: Internal.WallBannerBlock;
    static ANDESITE_SLAB: Internal.SlabBlock;
    static RED_NETHER_BRICK_WALL: Internal.WallBlock;
    static BIRCH_DOOR: Internal.DoorBlock;
    static BROWN_CONCRETE: Internal.Block;
    static DEEPSLATE_DIAMOND_ORE: Internal.DropExperienceBlock;
    static BEETROOTS: Internal.BeetrootBlock;
    static POTTED_BAMBOO: Internal.FlowerPotBlock;
    static FERN: Internal.TallGrassBlock;
    static CRIMSON_HYPHAE: Internal.RotatedPillarBlock;
    static WAXED_CUT_COPPER: Internal.Block;
    static ACACIA_DOOR: Internal.DoorBlock;
    static BLACK_WOOL: Internal.Block;
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static BRAIN_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static VINE: Internal.VineBlock;
    static ANDESITE_STAIRS: Internal.StairBlock;
    static INFESTED_DEEPSLATE: Internal.InfestedRotatedPillarBlock;
    static ACACIA_WALL_SIGN: Internal.WallSignBlock;
    static SPONGE: Internal.SpongeBlock;
    static REDSTONE_ORE: Internal.RedStoneOreBlock;
    static STRIPPED_ACACIA_WOOD: Internal.RotatedPillarBlock;
    static REDSTONE_WALL_TORCH: Internal.RedstoneWallTorchBlock;
    static CYAN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static BLACK_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static CAMPFIRE: Internal.CampfireBlock;
    static OCHRE_FROGLIGHT: Internal.RotatedPillarBlock;
    static COBBLESTONE_STAIRS: Internal.StairBlock;
    static DRAGON_WALL_HEAD: Internal.WallSkullBlock;
    static POTTED_WITHER_ROSE: Internal.FlowerPotBlock;
    static BLACKSTONE_STAIRS: Internal.StairBlock;
    static GRAY_CANDLE: Internal.CandleBlock;
    static CYAN_TERRACOTTA: Internal.Block;
    static BIRCH_WALL_SIGN: Internal.WallSignBlock;
    static POTTED_CORNFLOWER: Internal.FlowerPotBlock;
    static STICKY_PISTON: Internal.PistonBaseBlock;
    static LIGHT_BLUE_TERRACOTTA: Internal.Block;
    static WEATHERED_COPPER: Internal.WeatheringCopperFullBlock;
    static CYAN_WALL_BANNER: Internal.WallBannerBlock;
    static RAW_GOLD_BLOCK: Internal.Block;
    static STRIPPED_BIRCH_LOG: Internal.RotatedPillarBlock;
    static LARGE_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static POLISHED_ANDESITE_SLAB: Internal.SlabBlock;
    static NETHER_PORTAL: Internal.NetherPortalBlock;
    static JUNGLE_PLANKS: Internal.Block;
    static PINK_TULIP: Internal.FlowerBlock;
    static OAK_SLAB: Internal.SlabBlock;
    static STRIPPED_WARPED_HYPHAE: Internal.RotatedPillarBlock;
    static POTTED_OAK_SAPLING: Internal.FlowerPotBlock;
    static MANGROVE_SLAB: Internal.SlabBlock;
    static EXPOSED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static ORANGE_CONCRETE: Internal.Block;
    static BLUE_ORCHID: Internal.FlowerBlock;
    static BIRCH_LOG: Internal.RotatedPillarBlock;
    static GRAY_STAINED_GLASS: Internal.StainedGlassBlock;
    static DEEPSLATE_TILES: Internal.Block;
    static CRIMSON_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static WHITE_BANNER: Internal.BannerBlock;
    static KELP: Internal.KelpBlock;
    static BROWN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static INFESTED_CRACKED_STONE_BRICKS: Internal.InfestedBlock;
    static JUNGLE_FENCE: Internal.FenceBlock;
    static LIGHT_GRAY_CONCRETE: Internal.Block;
    static RED_MUSHROOM_BLOCK: Internal.HugeMushroomBlock;
    static GRAY_TERRACOTTA: Internal.Block;
    static MOSS_BLOCK: Internal.MossBlock;
    static LIME_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static CRIMSON_STAIRS: Internal.StairBlock;
    static CARVED_PUMPKIN: Internal.CarvedPumpkinBlock;
    static POTATOES: Internal.PotatoBlock;
    static PURPUR_PILLAR: Internal.RotatedPillarBlock;
    static MUD_BRICKS: Internal.Block;
    static DEAD_FIRE_CORAL_BLOCK: Internal.Block;
    static MANGROVE_WOOD: Internal.RotatedPillarBlock;
    static NOTE_BLOCK: Internal.NoteBlock;
    static ENDER_CHEST: Internal.EnderChestBlock;
    static CYAN_BED: Internal.BedBlock;
    static DEAD_TUBE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static BIRCH_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static YELLOW_CONCRETE: Internal.Block;
    static DEAD_TUBE_CORAL_BLOCK: Internal.Block;
    static STRIPPED_WARPED_STEM: Internal.RotatedPillarBlock;
    static LEVER: Internal.LeverBlock;
    static POLISHED_BLACKSTONE: Internal.Block;
    static LIGHT_BLUE_CONCRETE: Internal.Block;
    static POTTED_MANGROVE_PROPAGULE: Internal.FlowerPotBlock;
    static DROPPER: Internal.DropperBlock;
    static SPRUCE_FENCE: Internal.FenceBlock;
    static RED_SANDSTONE_STAIRS: Internal.StairBlock;
    static CRAFTING_TABLE: Internal.CraftingTableBlock;
    static SHULKER_BOX: Internal.ShulkerBoxBlock;
    static GRASS: Internal.TallGrassBlock;
    static MEDIUM_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static CRIMSON_ROOTS: Internal.RootsBlock;
    static WITHER_ROSE: Internal.WitherRoseBlock;
    static OXEYE_DAISY: Internal.FlowerBlock;
    static OAK_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static EMERALD_BLOCK: Internal.Block;
    static BUDDING_AMETHYST: Internal.BuddingAmethystBlock;
    static RAIL: Internal.RailBlock;
    static JUNGLE_WALL_SIGN: Internal.WallSignBlock;
    static BROWN_MUSHROOM_BLOCK: Internal.HugeMushroomBlock;
    static DARK_OAK_SAPLING: Internal.SaplingBlock;
    static DIAMOND_ORE: Internal.DropExperienceBlock;
    static LADDER: Internal.LadderBlock;
    static OAK_SAPLING: Internal.SaplingBlock;
    static MELON: Internal.MelonBlock;
    static CRIMSON_PLANKS: Internal.Block;
    static GLOW_LICHEN: Internal.GlowLichenBlock;
    static REDSTONE_WIRE: Internal.RedStoneWireBlock;
    static HORN_CORAL_FAN: Internal.CoralFanBlock;
    static DARK_PRISMARINE_SLAB: Internal.SlabBlock;
    static CAVE_VINES_PLANT: Internal.CaveVinesPlantBlock;
    static YELLOW_STAINED_GLASS: Internal.StainedGlassBlock;
    static SMOOTH_SANDSTONE_SLAB: Internal.SlabBlock;
    static COBBLED_DEEPSLATE_WALL: Internal.WallBlock;
    static CRIMSON_NYLIUM: Internal.NyliumBlock;
    static POTTED_BLUE_ORCHID: Internal.FlowerPotBlock;
    static CYAN_BANNER: Internal.BannerBlock;
    static SCULK_CATALYST: Internal.SculkCatalystBlock;
    static STRIPPED_MANGROVE_LOG: Internal.RotatedPillarBlock;
    static DISPENSER: Internal.DispenserBlock;
    static PRISMARINE_WALL: Internal.WallBlock;
    static ORANGE_TULIP: Internal.FlowerBlock;
    static COMMAND_BLOCK: Internal.CommandBlock;
    static BLACK_WALL_BANNER: Internal.WallBannerBlock;
    static SPORE_BLOSSOM: Internal.SporeBlossomBlock;
    static OXIDIZED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static DEEPSLATE_TILE_STAIRS: Internal.StairBlock;
    static JUNGLE_STAIRS: Internal.StairBlock;
    static DIRT_PATH: Internal.DirtPathBlock;
    static BLUE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static GREEN_CARPET: Internal.WoolCarpetBlock;
    static HONEYCOMB_BLOCK: Internal.Block;
    static ICE: Internal.IceBlock;
    static POTTED_BIRCH_SAPLING: Internal.FlowerPotBlock;
    static WHITE_CARPET: Internal.WoolCarpetBlock;
    static WATER: Internal.LiquidBlock;
    static CRACKED_NETHER_BRICKS: Internal.Block;
    static WATER_CAULDRON: Internal.LayeredCauldronBlock;
    static MUD_BRICK_SLAB: Internal.SlabBlock;
    static WAXED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static POLISHED_DEEPSLATE_WALL: Internal.WallBlock;
    static OAK_FENCE_GATE: Internal.FenceGateBlock;
    static OAK_LEAVES: Internal.LeavesBlock;
    static POTTED_BROWN_MUSHROOM: Internal.FlowerPotBlock;
    static WARPED_DOOR: Internal.DoorBlock;
    static JUKEBOX: Internal.JukeboxBlock;
    static MANGROVE_FENCE: Internal.FenceBlock;
    static NETHER_BRICKS: Internal.Block;
    static PLAYER_HEAD: Internal.PlayerHeadBlock;
    static PURPLE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static DEAD_TUBE_CORAL: Internal.BaseCoralPlantBlock;
    static POWDER_SNOW_CAULDRON: Internal.PowderSnowCauldronBlock;
    static BROWN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static BREWING_STAND: Internal.BrewingStandBlock;
    static POLISHED_BLACKSTONE_BRICK_STAIRS: Internal.StairBlock;
    static REDSTONE_TORCH: Internal.RedstoneTorchBlock;
    static BLACK_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static POLISHED_GRANITE_STAIRS: Internal.StairBlock;
    static MAGENTA_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static DEAD_BRAIN_CORAL: Internal.BaseCoralPlantBlock;
    static BLACK_STAINED_GLASS: Internal.StainedGlassBlock;
    static NETHER_SPROUTS: Internal.NetherSproutsBlock;
    static GREEN_CANDLE: Internal.CandleBlock;
    static SPRUCE_LOG: Internal.RotatedPillarBlock;
    static PURPLE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static CONDUIT: Internal.ConduitBlock;
    static ORANGE_WOOL: Internal.Block;
    static POTTED_WHITE_TULIP: Internal.FlowerPotBlock;
    static PRISMARINE_BRICKS: Internal.Block;
    static POLISHED_BLACKSTONE_WALL: Internal.WallBlock;
    static SEA_LANTERN: Internal.Block;
    static MAGENTA_BED: Internal.BedBlock;
    static POLISHED_DEEPSLATE_SLAB: Internal.SlabBlock;
    static STONE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static SCAFFOLDING: Internal.ScaffoldingBlock;
    static NETHER_BRICK_STAIRS: Internal.StairBlock;
    static DIORITE_SLAB: Internal.SlabBlock;
    static PISTON_HEAD: Internal.PistonHeadBlock;
    static BLACK_TERRACOTTA: Internal.Block;
    static PURPLE_WALL_BANNER: Internal.WallBannerBlock;
    static LIME_CANDLE: Internal.CandleBlock;
    static OAK_WALL_SIGN: Internal.WallSignBlock;
    static CUT_RED_SANDSTONE: Internal.Block;
    static DEAD_FIRE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static LIME_BED: Internal.BedBlock;
    static SPAWNER: Internal.ApothSpawnerBlock;
    static FROSTED_ICE: Internal.FrostedIceBlock;
    static IRON_TRAPDOOR: Internal.TrapDoorBlock;
    static WARPED_ROOTS: Internal.RootsBlock;
    static STONE: Internal.Block;
    static MUD_BRICK_WALL: Internal.WallBlock;
    static SOUL_LANTERN: Internal.LanternBlock;
    static COPPER_BLOCK: Internal.WeatheringCopperFullBlock;
    static WAXED_OXIDIZED_COPPER: Internal.Block;
    static POLISHED_BASALT: Internal.RotatedPillarBlock;
    static DAYLIGHT_DETECTOR: Internal.DaylightDetectorBlock;
    static CRIMSON_SLAB: Internal.SlabBlock;
    static GOLD_BLOCK: Internal.Block;
    static POTTED_LILY_OF_THE_VALLEY: Internal.FlowerPotBlock;
    static LIGHT_BLUE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static LIGHT_GRAY_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static DRIPSTONE_BLOCK: Internal.Block;
    static COBBLED_DEEPSLATE: Internal.Block;
    static BIG_DRIPLEAF: Internal.BigDripleafBlock;
    static MANGROVE_LEAVES: Internal.MangroveLeavesBlock;
    static GRAY_WOOL: Internal.Block;
    static INFESTED_CHISELED_STONE_BRICKS: Internal.InfestedBlock;
    static GRAY_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static REPEATING_COMMAND_BLOCK: Internal.CommandBlock;
    static WARPED_FENCE: Internal.FenceBlock;
    static RED_BED: Internal.BedBlock;
    static POTTED_DANDELION: Internal.FlowerPotBlock;
    static POTTED_CACTUS: Internal.FlowerPotBlock;
    static DIORITE_WALL: Internal.WallBlock;
    static HOPPER: Internal.HopperBlock;
    static BARREL: Internal.BarrelBlock;
    static MELON_STEM: Internal.StemBlock;
    static ROOTED_DIRT: Internal.RootedDirtBlock;
    static LIGHT_BLUE_WOOL: Internal.Block;
    static SOUL_WALL_TORCH: Internal.WallTorchBlock;
    static LAPIS_BLOCK: Internal.Block;
    static ANDESITE: Internal.Block;
    static YELLOW_BED: Internal.BedBlock;
    static END_STONE_BRICK_STAIRS: Internal.StairBlock;
    static BLAST_FURNACE: Internal.BlastFurnaceBlock;
    static SMALL_DRIPLEAF: Internal.SmallDripleafBlock;
    static KELP_PLANT: Internal.KelpPlantBlock;
    static RED_SAND: Internal.SandBlock;
    static JUNGLE_LOG: Internal.RotatedPillarBlock;
    static QUARTZ_BRICKS: Internal.Block;
    static ZOMBIE_WALL_HEAD: Internal.WallSkullBlock;
    static LIME_TERRACOTTA: Internal.Block;
    static RAW_COPPER_BLOCK: Internal.Block;
    static ORANGE_CARPET: Internal.WoolCarpetBlock;
    static LOOM: Internal.LoomBlock;
    static GREEN_WOOL: Internal.Block;
    static BROWN_WOOL: Internal.Block;
    static LIGHT_GRAY_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static BLUE_CANDLE: Internal.CandleBlock;
    static PINK_CANDLE: Internal.CandleBlock;
    static SMOKER: Internal.SmokerBlock;
    static ANVIL: Internal.ApothAnvilBlock;
    static BROWN_CARPET: Internal.WoolCarpetBlock;
    static FLOWER_POT: Internal.FlowerPotBlock;
    static LIGHT_BLUE_BANNER: Internal.BannerBlock;
    static POLISHED_BLACKSTONE_STAIRS: Internal.StairBlock;
    static STONECUTTER: Internal.StonecutterBlock;
    static CUT_RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static RED_CONCRETE: Internal.Block;
    static DARK_OAK_FENCE: Internal.FenceBlock;
    static GREEN_STAINED_GLASS: Internal.StainedGlassBlock;
    static BAMBOO: Internal.ApothBambooBlock;
    static DEAD_HORN_CORAL_BLOCK: Internal.Block;
    static DARK_OAK_WALL_SIGN: Internal.WallSignBlock;
    static MAGENTA_STAINED_GLASS: Internal.StainedGlassBlock;
    static DARK_OAK_SIGN: Internal.StandingSignBlock;
    static CHISELED_RED_SANDSTONE: Internal.Block;
    static CRIMSON_BUTTON: Internal.WoodButtonBlock;
    static RED_STAINED_GLASS: Internal.StainedGlassBlock;
    static QUARTZ_PILLAR: Internal.RotatedPillarBlock;
    static CHISELED_POLISHED_BLACKSTONE: Internal.Block;
    static DEAD_FIRE_CORAL: Internal.BaseCoralPlantBlock;
    static PURPLE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static RED_CANDLE: Internal.CandleBlock;
    static AMETHYST_CLUSTER: Internal.AmethystClusterBlock;
    static DARK_PRISMARINE: Internal.Block;
    static MANGROVE_WALL_SIGN: Internal.WallSignBlock;
    static SCULK_VEIN: Internal.SculkVeinBlock;
    static JUNGLE_SAPLING: Internal.SaplingBlock;
    static YELLOW_CARPET: Internal.WoolCarpetBlock;
    static OBSERVER: Internal.ObserverBlock;
    static END_STONE_BRICK_WALL: Internal.WallBlock;
    static SPRUCE_LEAVES: Internal.LeavesBlock;
    static MANGROVE_BUTTON: Internal.WoodButtonBlock;
    static WAXED_EXPOSED_CUT_COPPER: Internal.Block;
    static STONE_BRICK_SLAB: Internal.SlabBlock;
    static STONE_BRICKS: Internal.Block;
    static SPRUCE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static NETHER_WART: Internal.NetherWartBlock;
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static RED_WALL_BANNER: Internal.WallBannerBlock;
    static OBSIDIAN: Internal.Block;
    static PURPLE_CONCRETE: Internal.Block;
    static BLACK_CONCRETE: Internal.Block;
    static WARPED_SIGN: Internal.StandingSignBlock;
    static REINFORCED_DEEPSLATE: Internal.Block;
    static DRAGON_EGG: Internal.DragonEggBlock;
    static PACKED_MUD: Internal.Block;
    static ACACIA_PLANKS: Internal.Block;
    static RED_CANDLE_CAKE: Internal.CandleCakeBlock;
    static DARK_OAK_STAIRS: Internal.StairBlock;
    static MOSSY_STONE_BRICK_STAIRS: Internal.StairBlock;
    static LIGHT_WEIGHTED_PRESSURE_PLATE: Internal.WeightedPressurePlateBlock;
    static FIRE_CORAL_FAN: Internal.CoralFanBlock;
    static QUARTZ_STAIRS: Internal.StairBlock;
    static PURPUR_STAIRS: Internal.StairBlock;
    static STONE_STAIRS: Internal.StairBlock;
    static STRIPPED_JUNGLE_LOG: Internal.RotatedPillarBlock;
    static RED_WOOL: Internal.Block;
    static FARMLAND: Internal.FarmBlock;
    static DARK_OAK_TRAPDOOR: Internal.TrapDoorBlock;
    static ORANGE_TERRACOTTA: Internal.Block;
    static DEEPSLATE_GOLD_ORE: Internal.DropExperienceBlock;
    static LIGHT_BLUE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static POLISHED_BLACKSTONE_BRICK_WALL: Internal.WallBlock;
    static BRICKS: Internal.Block;
    static WAXED_EXPOSED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static MOSSY_COBBLESTONE_STAIRS: Internal.StairBlock;
    static CAKE: Internal.CakeBlock;
    static GREEN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static BLUE_BED: Internal.BedBlock;
    static OAK_BUTTON: Internal.WoodButtonBlock;
    static MANGROVE_DOOR: Internal.DoorBlock;
    static DEEPSLATE_BRICKS: Internal.Block;
    static BASALT: Internal.RotatedPillarBlock;
    static REPEATER: Internal.RepeaterBlock;
    static PURPLE_STAINED_GLASS: Internal.StainedGlassBlock;
    static AZURE_BLUET: Internal.FlowerBlock;
    static LILY_OF_THE_VALLEY: Internal.FlowerBlock;
    static STONE_BRICK_WALL: Internal.WallBlock;
    static BIRCH_SAPLING: Internal.SaplingBlock;
    static BIRCH_STAIRS: Internal.StairBlock;
    static LIGHT_BLUE_CARPET: Internal.WoolCarpetBlock;
    static BROWN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static FIRE_CORAL: Internal.CoralPlantBlock;
    static SANDSTONE_WALL: Internal.WallBlock;
    static RESPAWN_ANCHOR: Internal.RespawnAnchorBlock;
    static PRISMARINE_BRICK_SLAB: Internal.SlabBlock;
    static NETHER_BRICK_SLAB: Internal.SlabBlock;
    static NETHERRACK: Internal.NetherrackBlock;
    static CAVE_VINES: Internal.CaveVinesBlock;
    static WARPED_NYLIUM: Internal.NyliumBlock;
    static POTTED_POPPY: Internal.FlowerPotBlock;
    static POINTED_DRIPSTONE: Internal.PointedDripstoneBlock;
    static ORANGE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static LIGHT_GRAY_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static POLISHED_BLACKSTONE_BRICKS: Internal.Block;
    static GLASS: Internal.GlassBlock;
    static WARPED_PLANKS: Internal.Block;
    static WET_SPONGE: Internal.WetSpongeBlock;
    static GRASS_BLOCK: Internal.GrassBlock;
    static COAL_ORE: Internal.DropExperienceBlock;
    static PURPUR_SLAB: Internal.SlabBlock;
    static WARPED_STEM: Internal.RotatedPillarBlock;
    static DEEPSLATE_COPPER_ORE: Internal.DropExperienceBlock;
    static POLISHED_DIORITE_STAIRS: Internal.StairBlock;
    static ANCIENT_DEBRIS: Internal.Block;
    static GRAY_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static DEAD_BRAIN_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static WHITE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static END_STONE_BRICK_SLAB: Internal.SlabBlock;
    static PODZOL: Internal.SnowyDirtBlock;
    static COMPARATOR: Internal.ComparatorBlock;
    static ACACIA_FENCE_GATE: Internal.FenceGateBlock;
    static CHISELED_STONE_BRICKS: Internal.Block;
    static WAXED_WEATHERED_COPPER: Internal.Block;
    static SUGAR_CANE: Internal.ApothSugarcaneBlock;
    static DEAD_BRAIN_CORAL_BLOCK: Internal.Block;
    static NETHERITE_BLOCK: Internal.Block;
    static WHITE_CONCRETE: Internal.Block;
    static POTTED_AZURE_BLUET: Internal.FlowerPotBlock;
    static SANDSTONE_SLAB: Internal.SlabBlock;
    static ORANGE_STAINED_GLASS: Internal.StainedGlassBlock;
    static ORANGE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static BRAIN_CORAL_FAN: Internal.CoralFanBlock;
    static PINK_CANDLE_CAKE: Internal.CandleCakeBlock;
    static OXIDIZED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static GRAY_BED: Internal.BedBlock;
    static GLASS_PANE: Internal.IronBarsBlock;
    static GRAVEL: Internal.GravelBlock;
    static ENCHANTING_TABLE: Internal.ApothEnchantBlock;
    static LILAC: Internal.TallFlowerBlock;
    static STRIPPED_SPRUCE_WOOD: Internal.RotatedPillarBlock;
    static MANGROVE_SIGN: Internal.StandingSignBlock;
    static RED_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static STRIPPED_JUNGLE_WOOD: Internal.RotatedPillarBlock;
    static ALLIUM: Internal.FlowerBlock;
    static MUD_BRICK_STAIRS: Internal.StairBlock;
    static DEAD_BRAIN_CORAL_FAN: Internal.BaseCoralFanBlock;
    static LIGHT_GRAY_STAINED_GLASS: Internal.StainedGlassBlock;
    static ZOMBIE_HEAD: Internal.SkullBlock;
    static WHITE_TULIP: Internal.FlowerBlock;
    static PINK_WALL_BANNER: Internal.WallBannerBlock;
    static MOSSY_COBBLESTONE_WALL: Internal.WallBlock;
    static CRACKED_DEEPSLATE_BRICKS: Internal.Block;
    static WHITE_WOOL: Internal.Block;
    static GREEN_WALL_BANNER: Internal.WallBannerBlock;
    static GRAY_CARPET: Internal.WoolCarpetBlock;
    static BLACK_BANNER: Internal.BannerBlock;
    static TUBE_CORAL: Internal.CoralPlantBlock;
    static CUT_SANDSTONE: Internal.Block;
    static POLISHED_GRANITE: Internal.Block;
    static DARK_OAK_LOG: Internal.RotatedPillarBlock;
    static SKELETON_WALL_SKULL: Internal.WallSkullBlock;
    static TALL_GRASS: Internal.DoublePlantBlock;
    static POTTED_JUNGLE_SAPLING: Internal.FlowerPotBlock;
    static YELLOW_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static PEARLESCENT_FROGLIGHT: Internal.RotatedPillarBlock;
    static DARK_OAK_FENCE_GATE: Internal.FenceGateBlock;
    static MAGENTA_WOOL: Internal.Block;
    static PUMPKIN_STEM: Internal.StemBlock;
    static MUD: Internal.MudBlock;
    static GRINDSTONE: Internal.GrindstoneBlock;
    static LIGHT_BLUE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static BLUE_ICE: Internal.HalfTransparentBlock;
    static BROWN_BANNER: Internal.BannerBlock;
    static FLOWERING_AZALEA: Internal.AzaleaBlock;
    static PACKED_ICE: Internal.Block;
    static ACACIA_SLAB: Internal.SlabBlock;
    static GRAY_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static DARK_OAK_SLAB: Internal.SlabBlock;
    static BLUE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static ORANGE_BANNER: Internal.BannerBlock;
    static BEEHIVE: Internal.BeehiveBlock;
    static PURPLE_CANDLE: Internal.CandleBlock;
    static BLUE_WALL_BANNER: Internal.WallBannerBlock;
    static BLACK_CARPET: Internal.WoolCarpetBlock;
    static WHITE_CANDLE: Internal.CandleBlock;
    static NETHER_GOLD_ORE: Internal.DropExperienceBlock;
    static LODESTONE: Internal.Block;
    static WEEPING_VINES: Internal.WeepingVinesBlock;
    static MAGENTA_CANDLE: Internal.CandleBlock;
    static END_PORTAL: Internal.EndPortalBlock;
    static TINTED_GLASS: Internal.TintedGlassBlock;
    static LIME_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static SKELETON_SKULL: Internal.SkullBlock;
    static LIME_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static END_STONE: Internal.Block;
    static JUNGLE_FENCE_GATE: Internal.FenceGateBlock;
    static TWISTING_VINES: Internal.TwistingVinesBlock;
    static END_PORTAL_FRAME: Internal.EndPortalFrameBlock;
    static CRIMSON_WALL_SIGN: Internal.WallSignBlock;
    static SPRUCE_PLANKS: Internal.Block;
    static POLISHED_GRANITE_SLAB: Internal.SlabBlock;
    static YELLOW_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static MOSSY_COBBLESTONE_SLAB: Internal.SlabBlock;
    static ORANGE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static LIGHT_BLUE_WALL_BANNER: Internal.WallBannerBlock;
    static ACACIA_LEAVES: Internal.LeavesBlock;
    static GRAY_CANDLE_CAKE: Internal.CandleCakeBlock;
    static GRAY_BANNER: Internal.BannerBlock;
    static BIRCH_SLAB: Internal.SlabBlock;
    static CRACKED_DEEPSLATE_TILES: Internal.Block;
    static HANGING_ROOTS: Internal.HangingRootsBlock;
    static TURTLE_EGG: Internal.TurtleEggBlock;
    static BLACKSTONE_WALL: Internal.WallBlock;
    static SMOOTH_RED_SANDSTONE: Internal.Block;
    static BAMBOO_SAPLING: Internal.BambooSaplingBlock;
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static WHITE_BED: Internal.BedBlock;
    static CANDLE_CAKE: Internal.CandleCakeBlock;
    static DETECTOR_RAIL: Internal.DetectorRailBlock;
    static COPPER_ORE: Internal.DropExperienceBlock;
    static CAULDRON: Internal.CauldronBlock;
    static LANTERN: Internal.LanternBlock;
    static GLOWSTONE: Internal.Block;
    static YELLOW_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static VOID_AIR: Internal.AirBlock;
    static PURPUR_BLOCK: Internal.Block;
    static INFESTED_STONE: Internal.InfestedBlock;
    static CHAIN: Internal.ChainBlock;
    static STRIPPED_SPRUCE_LOG: Internal.RotatedPillarBlock;
    static OAK_SIGN: Internal.StandingSignBlock;
    static OAK_DOOR: Internal.DoorBlock;
    static MAGMA_BLOCK: Internal.MagmaBlock;
    static DIORITE_STAIRS: Internal.StairBlock;
    static RED_SANDSTONE_WALL: Internal.WallBlock;
    static LAPIS_ORE: Internal.DropExperienceBlock;
    static SPRUCE_SAPLING: Internal.SaplingBlock;
    static SMOOTH_STONE: Internal.Block;
    static BUBBLE_COLUMN: Internal.BubbleColumnBlock;
    static CANDLE: Internal.CandleBlock;
    static POLISHED_DIORITE: Internal.Block;
    static BIRCH_WOOD: Internal.RotatedPillarBlock;
    static AIR: Internal.AirBlock;
    static AZALEA_LEAVES: Internal.LeavesBlock;
    static WHITE_STAINED_GLASS: Internal.StainedGlassBlock;
    static CAVE_AIR: Internal.AirBlock;
    static MOSSY_COBBLESTONE: Internal.Block;
    static OAK_FENCE: Internal.FenceBlock;
    static EMERALD_ORE: Internal.DropExperienceBlock;
    static CYAN_WOOL: Internal.Block;
    static BIRCH_PLANKS: Internal.Block;
    static POTTED_ORANGE_TULIP: Internal.FlowerPotBlock;
    static POTTED_WARPED_ROOTS: Internal.FlowerPotBlock;
    static SPRUCE_TRAPDOOR: Internal.TrapDoorBlock;
    static DARK_PRISMARINE_STAIRS: Internal.StairBlock;
    static SMALL_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static SPRUCE_STAIRS: Internal.StairBlock;
    static WITHER_SKELETON_SKULL: Internal.WitherSkullBlock;
    static BUBBLE_CORAL_FAN: Internal.CoralFanBlock;
    static CREEPER_WALL_HEAD: Internal.WallSkullBlock;
    static STRIPPED_OAK_LOG: Internal.RotatedPillarBlock;
    static ACACIA_WOOD: Internal.RotatedPillarBlock;
    static CHAIN_COMMAND_BLOCK: Internal.CommandBlock;
    static INFESTED_MOSSY_STONE_BRICKS: Internal.InfestedBlock;
    static BROWN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static BLUE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static ACACIA_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static CYAN_CANDLE: Internal.CandleBlock;
    static FLETCHING_TABLE: Internal.ApothFletchingBlock;
    static GRAY_CONCRETE: Internal.Block;
    static WARPED_STAIRS: Internal.StairBlock;
    static HORN_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static BROWN_WALL_BANNER: Internal.WallBannerBlock;
    static END_GATEWAY: Internal.EndGatewayBlock;
    static DEEPSLATE_TILE_WALL: Internal.WallBlock;
    static POTTED_ALLIUM: Internal.FlowerPotBlock;
    static COBBLESTONE: Internal.Block;
    static OAK_TRAPDOOR: Internal.TrapDoorBlock;
    static CALCITE: Internal.Block;
    static MANGROVE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static POTTED_OXEYE_DAISY: Internal.FlowerPotBlock;
    static FIRE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static OAK_LOG: Internal.RotatedPillarBlock;
    static STRIPPED_CRIMSON_HYPHAE: Internal.RotatedPillarBlock;
    static BIRCH_TRAPDOOR: Internal.TrapDoorBlock;
    static TERRACOTTA: Internal.Block;
    static JUNGLE_SLAB: Internal.SlabBlock;
    static NETHER_BRICK_WALL: Internal.WallBlock;
    static CYAN_CARPET: Internal.WoolCarpetBlock;
    static END_ROD: Internal.EndRodBlock;
    static LIGHT_BLUE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static SMOOTH_QUARTZ: Internal.Block;
    static PRISMARINE: Internal.Block;
    static SMOOTH_QUARTZ_STAIRS: Internal.StairBlock;
    static NETHER_QUARTZ_ORE: Internal.DropExperienceBlock;
    static MUDDY_MANGROVE_ROOTS: Internal.RotatedPillarBlock;
    static LIGHT_GRAY_CANDLE: Internal.CandleBlock;
    static MANGROVE_TRAPDOOR: Internal.TrapDoorBlock;
    static DEEPSLATE_TILE_SLAB: Internal.SlabBlock;
    static ATTACHED_PUMPKIN_STEM: Internal.AttachedStemBlock;
    static CYAN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static OXIDIZED_COPPER: Internal.WeatheringCopperFullBlock;
    static POLISHED_DEEPSLATE_STAIRS: Internal.StairBlock;
    static POLISHED_BLACKSTONE_BRICK_SLAB: Internal.SlabBlock;
    static POLISHED_DEEPSLATE: Internal.Block;
    static COCOA: Internal.CocoaBlock;
    static JUNGLE_BUTTON: Internal.WoodButtonBlock;
    static BIRCH_FENCE_GATE: Internal.FenceGateBlock;
    static POTTED_RED_MUSHROOM: Internal.FlowerPotBlock;
    static MAGENTA_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static JUNGLE_WOOD: Internal.RotatedPillarBlock;
    static WARPED_TRAPDOOR: Internal.TrapDoorBlock;
    static CRIMSON_TRAPDOOR: Internal.TrapDoorBlock;
    static CHEST: Internal.ChestBlock;
    static SPRUCE_WOOD: Internal.RotatedPillarBlock;
    static PINK_STAINED_GLASS: Internal.StainedGlassBlock;
    static BLACKSTONE_SLAB: Internal.SlabBlock;
    static LIME_STAINED_GLASS: Internal.StainedGlassBlock;
    static GILDED_BLACKSTONE: Internal.Block;
    static SUNFLOWER: Internal.TallFlowerBlock;
    static ORANGE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static VERDANT_FROGLIGHT: Internal.RotatedPillarBlock;
    static PETRIFIED_OAK_SLAB: Internal.SlabBlock;
    static RED_NETHER_BRICK_STAIRS: Internal.StairBlock;
    static DRIED_KELP_BLOCK: Internal.Block;
    static BONE_BLOCK: Internal.RotatedPillarBlock;
    static WHITE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static POTTED_SPRUCE_SAPLING: Internal.FlowerPotBlock;
    static DEAD_HORN_CORAL: Internal.BaseCoralPlantBlock;
    static BUBBLE_CORAL: Internal.CoralPlantBlock;
    static GREEN_CONCRETE: Internal.Block;
    static CHORUS_FLOWER: Internal.ChorusFlowerBlock;
    static GRAY_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static SMOOTH_SANDSTONE_STAIRS: Internal.StairBlock;
    static RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static YELLOW_BANNER: Internal.BannerBlock;
    static LIGHT_GRAY_TERRACOTTA: Internal.Block;
    static PINK_WOOL: Internal.Block;
    static PINK_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static CYAN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static POWERED_RAIL: Internal.PoweredRailBlock;
    static LIGHT_BLUE_CANDLE: Internal.CandleBlock;
    static POWDER_SNOW: Internal.PowderSnowBlock;
    static ORANGE_WALL_BANNER: Internal.WallBannerBlock;
    static PINK_BANNER: Internal.BannerBlock;
    static BLACK_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static SPRUCE_FENCE_GATE: Internal.FenceGateBlock;
    static GRAY_WALL_BANNER: Internal.WallBannerBlock;
    static WARPED_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static JIGSAW: Internal.JigsawBlock;
    static WHITE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static SPRUCE_SLAB: Internal.SlabBlock;
    static LIGHT_GRAY_WOOL: Internal.Block;
    static PISTON: Internal.PistonBaseBlock;
    static SMOOTH_RED_SANDSTONE_STAIRS: Internal.StairBlock;
    static CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static DIRT: Internal.Block;
    static BLUE_CONCRETE: Internal.Block;
    static RED_TERRACOTTA: Internal.Block;
    static DEAD_BUBBLE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static OXIDIZED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static TALL_SEAGRASS: Internal.TallSeagrassBlock;
    static CHORUS_PLANT: Internal.ChorusPlantBlock;
    static PINK_CONCRETE: Internal.Block;
    static WHITE_TERRACOTTA: Internal.Block;
    static MOVING_PISTON: Internal.MovingPistonBlock;
    static MANGROVE_ROOTS: Internal.MangroveRootsBlock;
    static POTTED_ACACIA_SAPLING: Internal.FlowerPotBlock;
    static MANGROVE_PLANKS: Internal.Block;
    static ACACIA_BUTTON: Internal.WoodButtonBlock;
    static WAXED_OXIDIZED_CUT_COPPER: Internal.Block;
    static RED_BANNER: Internal.BannerBlock;
    static BLUE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static BELL: Internal.BellBlock;
    static MUSHROOM_STEM: Internal.HugeMushroomBlock;
    static EXPOSED_COPPER: Internal.WeatheringCopperFullBlock;
    static CYAN_CONCRETE: Internal.Block;
    static POTTED_CRIMSON_ROOTS: Internal.FlowerPotBlock;
    static GREEN_TERRACOTTA: Internal.Block;
    static CHISELED_QUARTZ_BLOCK: Internal.Block;
    static JUNGLE_LEAVES: Internal.LeavesBlock;
    static FROGSPAWN: Internal.FrogspawnBlock;
    static SOUL_TORCH: Internal.TorchBlock;
    static BOOKSHELF: Internal.Block;
    static WAXED_EXPOSED_COPPER: Internal.Block;
    static CRIMSON_FENCE: Internal.FenceBlock;
    static DIAMOND_BLOCK: Internal.Block;
    static RED_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static SANDSTONE_STAIRS: Internal.StairBlock;
    static MAGENTA_CARPET: Internal.WoolCarpetBlock;
    static STRIPPED_DARK_OAK_WOOD: Internal.RotatedPillarBlock;
    static DEAD_BUBBLE_CORAL_BLOCK: Internal.Block;
    static SPRUCE_WALL_SIGN: Internal.WallSignBlock;
    static BLUE_BANNER: Internal.BannerBlock;
    static POLISHED_BLACKSTONE_SLAB: Internal.SlabBlock;
    static AMETHYST_BLOCK: Internal.AmethystBlock;
    static STRUCTURE_BLOCK: Internal.StructureBlock;
    static BRAIN_CORAL_BLOCK: Internal.CoralBlock;
    static STRIPPED_DARK_OAK_LOG: Internal.RotatedPillarBlock;
    static SMOOTH_SANDSTONE: Internal.Block;
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static BLUE_WOOL: Internal.Block;
    static IRON_BARS: Internal.IronBarsBlock;
    static IRON_BLOCK: Internal.Block;
    static HORN_CORAL_BLOCK: Internal.CoralBlock;
    static MAGENTA_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static HONEY_BLOCK: Internal.HoneyBlock;
    static END_STONE_BRICKS: Internal.Block;
    static JACK_O_LANTERN: Internal.CarvedPumpkinBlock;
    static TARGET: Internal.TargetBlock;
    static BRAIN_CORAL: Internal.CoralPlantBlock;
    static DEAD_FIRE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static MOSSY_STONE_BRICK_SLAB: Internal.SlabBlock;
    static BLUE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static WITHER_SKELETON_WALL_SKULL: Internal.WitherWallSkullBlock;
    static CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static ROSE_BUSH: Internal.TallFlowerBlock;
    static YELLOW_TERRACOTTA: Internal.Block;
    static LECTERN: Internal.LecternBlock;
    static CRIMSON_FENCE_GATE: Internal.FenceGateBlock;
    static DAMAGED_ANVIL: Internal.ApothAnvilBlock;
    static POLISHED_BLACKSTONE_BUTTON: Internal.StoneButtonBlock;
    static POLISHED_DIORITE_SLAB: Internal.SlabBlock;
    static HAY_BLOCK: Internal.HayBlock;
    static WARPED_HYPHAE: Internal.RotatedPillarBlock;
    static MANGROVE_STAIRS: Internal.StairBlock;
    static WEATHERED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static LIME_BANNER: Internal.BannerBlock;
    static TRIPWIRE_HOOK: Internal.TripWireHookBlock;
    static CLAY: Internal.Block;
    static SNOW: Internal.SnowLayerBlock;
    static WHEAT: Internal.CropBlock;
    static CYAN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static WEATHERED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static BROWN_MUSHROOM: Internal.MushroomBlock;
    static SHROOMLIGHT: Internal.Block;
    static CRIMSON_DOOR: Internal.DoorBlock;
    static PRISMARINE_BRICK_STAIRS: Internal.StairBlock;
    static POPPY: Internal.FlowerBlock;
    static STRUCTURE_VOID: Internal.StructureVoidBlock;
    static ORANGE_BED: Internal.BedBlock;
    static DEEPSLATE_COAL_ORE: Internal.DropExperienceBlock;
    static PURPLE_TERRACOTTA: Internal.Block;
    static CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static REDSTONE_BLOCK: Internal.PoweredBlock;
    static BLACK_CANDLE: Internal.CandleBlock;
    static WAXED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static GREEN_BANNER: Internal.BannerBlock;
    static POTTED_AZALEA: Internal.FlowerPotBlock;
    static LIME_CONCRETE: Internal.Block;
    static PURPLE_WOOL: Internal.Block;
    static SOUL_FIRE: Internal.SoulFireBlock;
    static CHISELED_NETHER_BRICKS: Internal.Block;
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: Internal.Block;
    static PINK_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static CARTOGRAPHY_TABLE: Internal.CartographyTableBlock;
    static BLACK_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static GREEN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static CYAN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static QUARTZ_BLOCK: Internal.Block;
    static WHITE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static WAXED_WEATHERED_CUT_COPPER: Internal.Block;
    static WARPED_WALL_SIGN: Internal.WallSignBlock;
    static COMPOSTER: Internal.ComposterBlock;
    static DARK_OAK_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static ACACIA_SAPLING: Internal.SaplingBlock;
    static CHISELED_SANDSTONE: Internal.Block;
    static POTTED_PINK_TULIP: Internal.FlowerPotBlock;
    static LARGE_FERN: Internal.DoublePlantBlock;
    static TNT: Internal.TntBlock;
    static COBBLED_DEEPSLATE_STAIRS: Internal.StairBlock;
    static BRICK_STAIRS: Internal.StairBlock;
    static WARPED_SLAB: Internal.SlabBlock;
    static SMOOTH_QUARTZ_SLAB: Internal.SlabBlock;
    static LAVA_CAULDRON: Internal.LavaCauldronBlock;
    static SCULK_SHRIEKER: Internal.SculkShriekerBlock;
    static BRICK_WALL: Internal.WallBlock;
    static CHISELED_DEEPSLATE: Internal.Block;
    static AZALEA: Internal.AzaleaBlock;
    static SMOOTH_STONE_SLAB: Internal.SlabBlock;
    static JUNGLE_SIGN: Internal.StandingSignBlock;
    static LIME_WOOL: Internal.Block;
    static LIME_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static GREEN_BED: Internal.BedBlock;
    static ACTIVATOR_RAIL: Internal.PoweredRailBlock;
    static SEA_PICKLE: Internal.SeaPickleBlock;
    static PINK_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static BLUE_TERRACOTTA: Internal.Block;
    static WEATHERED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static CRACKED_STONE_BRICKS: Internal.Block;
    static FURNACE: Internal.FurnaceBlock;
    static COBBLESTONE_SLAB: Internal.SlabBlock;
    static MANGROVE_FENCE_GATE: Internal.FenceGateBlock;
    static LIGHT_GRAY_CARPET: Internal.WoolCarpetBlock;
    static COBBLESTONE_WALL: Internal.WallBlock;
    static BEDROCK: Internal.Block;
    static BIRCH_LEAVES: Internal.LeavesBlock;
    static PURPLE_BED: Internal.BedBlock;
    static LIME_WALL_BANNER: Internal.WallBannerBlock;
    static RED_SANDSTONE: Internal.Block;
    static GOLD_ORE: Internal.DropExperienceBlock;
    static SCULK: Internal.SculkBlock;
    static ACACIA_SIGN: Internal.StandingSignBlock;
    static COBWEB: Internal.WebBlock;
    static CRIMSON_STEM: Internal.RotatedPillarBlock;
    static PINK_BED: Internal.BedBlock;
    static STRIPPED_ACACIA_LOG: Internal.RotatedPillarBlock;
    static BEE_NEST: Internal.BeehiveBlock;
    static LAVA: Internal.LiquidBlock;
    static POTTED_WARPED_FUNGUS: Internal.FlowerPotBlock;
    static NETHER_WART_BLOCK: Internal.Block;
    static ATTACHED_MELON_STEM: Internal.AttachedStemBlock;
    static DEEPSLATE_EMERALD_ORE: Internal.DropExperienceBlock;
    static BROWN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static POTTED_DARK_OAK_SAPLING: Internal.FlowerPotBlock;
    static POTTED_FERN: Internal.FlowerPotBlock;
    static PUMPKIN: Internal.PumpkinBlock;
    static EXPOSED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static RED_MUSHROOM: Internal.MushroomBlock;
    static BROWN_TERRACOTTA: Internal.Block;
    static PURPLE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static ORANGE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static RAW_IRON_BLOCK: Internal.Block;
    static WALL_TORCH: Internal.WallTorchBlock;
    static CACTUS: Internal.ApothCactusBlock;
    static FIRE: Internal.FireBlock;
    static SLIME_BLOCK: Internal.SlimeBlock;
    static CHIPPED_ANVIL: Internal.ApothAnvilBlock;
    static QUARTZ_SLAB: Internal.SlabBlock;
    static LIGHT_BLUE_BED: Internal.BedBlock;
    static GREEN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static JUNGLE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static SOUL_SAND: Internal.SoulSandBlock;
    static CUT_SANDSTONE_SLAB: Internal.SlabBlock;
    static MAGENTA_CONCRETE: Internal.Block;
    static GRANITE: Internal.Block;
    static LIGHT_GRAY_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static SMOOTH_BASALT: Internal.Block;
    static DEAD_BUSH: Internal.DeadBushBlock;
    static DARK_OAK_LEAVES: Internal.LeavesBlock;
    static SOUL_CAMPFIRE: Internal.CampfireBlock;
    static MAGENTA_BANNER: Internal.BannerBlock;
    static SPRUCE_DOOR: Internal.DoorBlock;
    static CREEPER_HEAD: Internal.SkullBlock;
    static BROWN_CANDLE: Internal.CandleBlock;
    static YELLOW_WALL_BANNER: Internal.WallBannerBlock;
    static DEAD_BUBBLE_CORAL: Internal.BaseCoralPlantBlock;
    static BLUE_CARPET: Internal.WoolCarpetBlock;
    static BRICK_SLAB: Internal.SlabBlock;
    static JUNGLE_DOOR: Internal.DoorBlock;
    static LIME_CANDLE_CAKE: Internal.CandleCakeBlock;
    static MOSSY_STONE_BRICK_WALL: Internal.WallBlock;
    static TUBE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static BROWN_BED: Internal.BedBlock;
    static PURPLE_CARPET: Internal.WoolCarpetBlock;
    static LIGHT_GRAY_WALL_BANNER: Internal.WallBannerBlock;
    static BIG_DRIPLEAF_STEM: Internal.BigDripleafStemBlock;
    static LIME_CARPET: Internal.WoolCarpetBlock;
    static WARPED_FUNGUS: Internal.FungusBlock;
    static WHITE_WALL_BANNER: Internal.WallBannerBlock;
    static DARK_OAK_WOOD: Internal.RotatedPillarBlock;
    static STRIPPED_MANGROVE_WOOD: Internal.RotatedPillarBlock;
    static CRYING_OBSIDIAN: Internal.CryingObsidianBlock;
    static WAXED_WEATHERED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static MAGENTA_TERRACOTTA: Internal.Block;
    static STONE_BUTTON: Internal.StoneButtonBlock;
    static IRON_DOOR: Internal.DoorBlock;
    static TRAPPED_CHEST: Internal.TrappedChestBlock;
    static LIGHT_GRAY_CANDLE_CAKE: Internal.CandleCakeBlock;
    static OAK_PLANKS: Internal.Block;
    static FLOWERING_AZALEA_LEAVES: Internal.LeavesBlock;
    static POTTED_FLOWERING_AZALEA: Internal.FlowerPotBlock;
    static POLISHED_ANDESITE_STAIRS: Internal.StairBlock;
    static BUBBLE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static ANDESITE_WALL: Internal.WallBlock;
    static YELLOW_CANDLE_CAKE: Internal.CandleCakeBlock;
    static BIRCH_SIGN: Internal.StandingSignBlock;
    static DEEPSLATE_BRICK_WALL: Internal.WallBlock;
    static SMOOTH_RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static BLACKSTONE: Internal.Block;
    static LIGHT_GRAY_BED: Internal.BedBlock;
    static STRIPPED_OAK_WOOD: Internal.RotatedPillarBlock;
    static DIORITE: Internal.Block;
    static SWEET_BERRY_BUSH: Internal.SweetBerryBushBlock;
    static INFESTED_STONE_BRICKS: Internal.InfestedBlock;
    static POTTED_RED_TULIP: Internal.FlowerPotBlock;
    static RED_TULIP: Internal.FlowerBlock;
    static BIRCH_BUTTON: Internal.WoodButtonBlock;
    static JUNGLE_TRAPDOOR: Internal.TrapDoorBlock;
    static GREEN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static BEACON: Internal.BeaconBlock;
    static DEEPSLATE_LAPIS_ORE: Internal.DropExperienceBlock;
    static OAK_STAIRS: Internal.StairBlock;
    static BIRCH_FENCE: Internal.FenceBlock;
    static SANDSTONE: Internal.Block;
    static SNOW_BLOCK: Internal.Block;
    static BLACK_BED: Internal.BedBlock;
    static BROWN_STAINED_GLASS: Internal.StainedGlassBlock;
    static POTTED_DEAD_BUSH: Internal.FlowerPotBlock;
    static GRANITE_STAIRS: Internal.StairBlock;
    static DEEPSLATE: Internal.RotatedPillarBlock;
    static DARK_OAK_BUTTON: Internal.WoodButtonBlock;
    static WHITE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static DEAD_HORN_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static INFESTED_COBBLESTONE: Internal.InfestedBlock;
}
type Blocks_ = Blocks;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): Internal.Component;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: Internal.Component_): boolean;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: Internal.Component_[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<Internal.Component>): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.Registrar<any>;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Returns the KubeJSRegistries class
    */
    getRegistries(): typeof Internal.KubeJSRegistries;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.Collection<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: string): Internal.CreativeModeTab;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Returns the KubeJSRegistries class
    */
    get registries(): typeof Internal.KubeJSRegistries
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: Internal.AABB;
    readonly EMPTY: Internal.AABB;
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace org.apache.logging.log4j.core {
    class LoggerContext extends Internal.AbstractLifeCycle implements Internal.ConfigurationListener, Internal.LoggerContextShutdownEnabled, Internal.LoggerContext, Internal.AutoCloseable, Internal.Terminable {
        constructor(name: string, externalContext: any, configLocn: Internal.URI_)
        constructor(name: string, externalContext: any)
        constructor(name: string, externalContext: any, configLocn: string)
        constructor(name: string)
        removeFilter(filter: Internal.Filter_): void;
        hasLogger(name: string): boolean;
        getConfiguration(): org.apache.logging.log4j.core.config.Configuration;
        putObject(key: string, value: any): any;
        terminate(): void;
        getLogger(cls: typeof any, messageFactory: Internal.MessageFactory_): Internal.ExtendedLogger;
        removeObject(key: string, value: any): boolean;
        getLogger(name: string): Internal.ExtendedLogger;
        static getContext(currentContext: boolean): org.apache.logging.log4j.core.LoggerContext;
        setName(name: string): void;
        getName(): string;
        setConfigLocation(configLocation: Internal.URI_): void;
        setExternalContext(context: any): void;
        addFilter(filter: Internal.Filter_): void;
        getRootLogger(): Internal.Logger;
        getLoggers(): Internal.Collection<Internal.Logger>;
        getLogger(name: string, messageFactory: Internal.MessageFactory_): Internal.ExtendedLogger;
        static getContext(): org.apache.logging.log4j.core.LoggerContext;
        reconfigure(): void;
        getLogger(cls: typeof any): Internal.ExtendedLogger;
        static getContext(loader: Internal.ClassLoader_, currentContext: boolean, configLocation: Internal.URI_): org.apache.logging.log4j.core.LoggerContext;
        setConfiguration(config: org.apache.logging.log4j.core.config.Configuration_): org.apache.logging.log4j.core.config.Configuration;
        getConfigLocation(): Internal.URI;
        putObjectIfAbsent(key: string, value: any): any;
        reconfigure(configuration: org.apache.logging.log4j.core.config.Configuration_): void;
        hasLogger(name: string, messageFactoryClass: typeof Internal.MessageFactory): boolean;
        getExternalContext(): any;
        addShutdownListener(listener: Internal.LoggerContextShutdownAware_): void;
        hasLogger(name: string, messageFactory: Internal.MessageFactory_): boolean;
        getListeners(): Internal.List<Internal.LoggerContextShutdownAware>;
        updateLoggers(config: org.apache.logging.log4j.core.config.Configuration_): void;
        removePropertyChangeListener(listener: Internal.PropertyChangeListener_): void;
        getObject(key: string): any;
        updateLoggers(): void;
        start(config: org.apache.logging.log4j.core.config.Configuration_): void;
        close(): void;
        onChange(reconfigurable: Internal.Reconfigurable_): void;
        addPropertyChangeListener(listener: Internal.PropertyChangeListener_): void;
        removeObject(key: string): any;
        get configuration(): org.apache.logging.log4j.core.config.Configuration
        set name(name: string)
        get name(): string
        set configLocation(configLocation: Internal.URI_)
        set externalContext(context: any)
        get rootLogger(): Internal.Logger
        get loggers(): Internal.Collection<Internal.Logger>
        get context(): org.apache.logging.log4j.core.LoggerContext
        set configuration(config: org.apache.logging.log4j.core.config.Configuration_)
        get configLocation(): Internal.URI
        get externalContext(): any
        get listeners(): Internal.List<Internal.LoggerContextShutdownAware>
        static readonly PROPERTY_CONFIG: "config";
    }
    type LoggerContext_ = LoggerContext;
}
declare namespace Internal {
    interface BaseMapCodec <K, V> {
        keyCodec(): Internal.Codec<K>;
        elementCodec(): Internal.Codec<V>;
        encode<T>(arg0: Internal.Map_<K, V>, arg1: Internal.DynamicOps_<T>, arg2: Internal.RecordBuilder_<T>): Internal.RecordBuilder<T>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.MapLike_<T>): Internal.DataResult<Internal.Map<K, V>>;
    }
    type BaseMapCodec_<K, V> = BaseMapCodec<K, V>;
    class ClientChatPreview$Preview extends Internal.Record {
        constructor(arg0: number, arg1: string, arg2: Internal.Component_)
        query(): string;
        response(): Internal.Component;
        receivedTimeStamp(): number;
    }
    type ClientChatPreview$Preview_ = ClientChatPreview$Preview;
    class ServerStatus$Players {
        constructor(arg0: number, arg1: number)
        setSample(arg0: Internal.GameProfile_[]): void;
        getSample(): Internal.GameProfile[];
        getMaxPlayers(): number;
        getNumPlayers(): number;
        set sample(arg0: Internal.GameProfile_[])
        get sample(): Internal.GameProfile[]
        get maxPlayers(): number
        get numPlayers(): number
    }
    type ServerStatus$Players_ = ServerStatus$Players;
    class SurfaceRules$Context implements Internal.ModdednessSliceGetter {
        cannotGetSlices(): boolean;
        getSliceName(): ResourceLocation;
        get sliceName(): ResourceLocation
    }
    type SurfaceRules$Context_ = SurfaceRules$Context;
    abstract class ImmutableCollections$AbstractImmutableMap <K, V> extends Internal.AbstractMap<K, V> implements Internal.Serializable {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        putIfAbsent(arg0: K, arg1: V): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
    }
    type ImmutableCollections$AbstractImmutableMap_<K, V> = ImmutableCollections$AbstractImmutableMap<K, V>;
    interface BoundingBoxAccessor {
        setMinZ(arg0: number): void;
        setMaxX(arg0: number): void;
        setMaxY(arg0: number): void;
        setMaxZ(arg0: number): void;
        setMinX(arg0: number): void;
        setMinY(arg0: number): void;
        set minZ(arg0: number)
        set maxX(arg0: number)
        set maxY(arg0: number)
        set maxZ(arg0: number)
        set minX(arg0: number)
        set minY(arg0: number)
    }
    type BoundingBoxAccessor_ = BoundingBoxAccessor;
    interface SinglePoolElementAccessor {
        callGetTemplate(arg0: Internal.StructureTemplateManager_): Internal.StructureTemplate;
        repurposedstructures_getTemplate(): Internal.Either<ResourceLocation, Internal.StructureTemplate>;
        repurposedstructures_getProcessors(): Internal.Holder<Internal.StructureProcessorList>;
    }
    type SinglePoolElementAccessor_ = SinglePoolElementAccessor;
    class ULocale$Category extends Internal.Enum<Internal.ULocale$Category> {
        static values(): Internal.ULocale$Category[];
        static valueOf(arg0: string): Internal.ULocale$Category;
        static readonly DISPLAY: Internal.ULocale$Category;
        static readonly FORMAT: Internal.ULocale$Category;
    }
    type ULocale$Category_ = "display" | ULocale$Category | "format";
    class PalettedContainerRO$PackedData <T> extends Internal.Record {
        constructor(arg0: Internal.List_<T>, arg1: Internal.Optional_<Internal.LongStream>)
        storage(): Internal.Optional<Internal.LongStream>;
        paletteEntries(): Internal.List<T>;
    }
    type PalettedContainerRO$PackedData_<T> = PalettedContainerRO$PackedData<T>;
    interface FriendlyByteBuf$Reader <T> extends Internal.Function<Internal.FriendlyByteBuf, T> {
        compose<V>(arg0: Internal.Function_<V, Internal.FriendlyByteBuf>): Internal.Function<V, T>;
        asOptional(): Internal.FriendlyByteBuf$Reader<Internal.Optional<T>>;
        andThen<V>(arg0: Internal.Function_<T, V>): Internal.Function<Internal.FriendlyByteBuf, V>;
        apply(arg0: Internal.FriendlyByteBuf_): T;
        identity<T>(): Internal.Function<T, T>;
        (arg0: Internal.FriendlyByteBuf_): T;
    }
    type FriendlyByteBuf$Reader_<T> = FriendlyByteBuf$Reader<T>;
    class SculkPatchFeature extends Internal.Feature<Internal.SculkPatchConfiguration> {
        constructor(arg0: Internal.Codec_<Internal.SculkPatchConfiguration>)
    }
    type SculkPatchFeature_ = SculkPatchFeature;
    class Zombie extends Internal.Monster implements Internal.ZombieInvoker {
        constructor(arg0: Internal.EntityType_<Internal.Zombie>, arg1: Internal.Level_)
        constructor(arg0: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        setCanBreakDoors(arg0: boolean): void;
        equipped(arg0: Internal.ItemEntity_): boolean;
        swing(): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static getSpawnAsBabyOdds(arg0: Internal.RandomSource_): boolean;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        isUnderWaterConverting(): boolean;
        callStartUnderWaterConversion(arg0: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        static isBlocked(entity: Internal.Entity_): boolean;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        canBreakDoors(): boolean;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        set canBreakDoors(arg0: boolean)
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        get underWaterConverting(): boolean
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly ZOMBIE_LEADER_CHANCE: 0.05;
        static readonly REINFORCEMENT_RANGE_MIN: 7;
        static readonly REINFORCEMENT_RANGE_MAX: 40;
        static readonly REINFORCEMENT_ATTEMPTS: 50;
    }
    type Zombie_ = Zombie;
    class CurioAttributeModifierEvent extends Internal.Event {
        constructor()
        constructor(arg0: Internal.ItemStack_, arg1: Internal.SlotContext_, arg2: Internal.UUID_, arg3: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>)
        getOriginalModifiers(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        removeAttribute(arg0: Internal.Attribute_): Internal.Collection<Internal.AttributeModifier>;
        removeModifier(arg0: Internal.Attribute_, arg1: Internal.AttributeModifier_): boolean;
        clearModifiers(): void;
        getUuid(): Internal.UUID;
        getSlotContext(): Internal.SlotContext;
        getModifiers(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        addModifier(arg0: Internal.Attribute_, arg1: Internal.AttributeModifier_): boolean;
        getItemStack(): Internal.ItemStack;
        get originalModifiers(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>
        get uuid(): Internal.UUID
        get slotContext(): Internal.SlotContext
        get modifiers(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>
        get itemStack(): Internal.ItemStack
    }
    type CurioAttributeModifierEvent_ = CurioAttributeModifierEvent;
    class RemoveOresProperties {
        constructor()
        worldgenLayer: DecorationGenerationStep;
        biomes: Internal.BiomeFilter;
        blocks: BlockStatePredicate;
    }
    type RemoveOresProperties_ = RemoveOresProperties;
    class LadderBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type LadderBlock_ = LadderBlock;
    interface Int2BooleanFunction extends Internal.IntPredicate, it.unimi.dsi.fastutil.Function<number, boolean> {
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2BooleanFunction<T>;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2BooleanFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        negate(): Internal.IntPredicate;
        or(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2BooleanFunction;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2BooleanFunction;
        containsKey(arg0: number): boolean;
        andThenInt(arg0: Internal.Boolean2IntFunction_): Internal.Int2IntFunction;
        andThenChar(arg0: Internal.Boolean2CharFunction_): Internal.Int2CharFunction;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2BooleanFunction;
        put(arg0: number, arg1: boolean): boolean;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, boolean>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        apply(arg0: number): boolean;
        /**
         * @deprecated
        */
        get(arg0: any): boolean;
        andThenObject<T>(arg0: Internal.Boolean2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        get(arg0: number): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        defaultReturnValue(): boolean;
        and(arg0: Internal.IntPredicate_): Internal.IntPredicate;
        remove(arg0: number): boolean;
        andThenShort(arg0: Internal.Boolean2ShortFunction_): Internal.Int2ShortFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: boolean): boolean;
        test(arg0: number): boolean;
        andThenDouble(arg0: Internal.Boolean2DoubleFunction_): Internal.Int2DoubleFunction;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2BooleanFunction;
        andThenLong(arg0: Internal.Boolean2LongFunction_): Internal.Int2LongFunction;
        size(): number;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2BooleanFunction<T>;
        andThenFloat(arg0: Internal.Boolean2FloatFunction_): Internal.Int2FloatFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<boolean, T>): Internal.Function<number, T>;
        andThenByte(arg0: Internal.Boolean2ByteFunction_): Internal.Int2ByteFunction;
        andThenReference<T>(arg0: Internal.Boolean2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        clear(): void;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: boolean): boolean;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2BooleanFunction;
        getOrDefault(arg0: number, arg1: boolean): boolean;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: boolean): void;
        (arg0: number): boolean;
    }
    type Int2BooleanFunction_ = Int2BooleanFunction;
    class CrossCollisionBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly NORTH: Internal.BooleanProperty;
        static readonly PROPERTY_BY_DIRECTION: {[key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty};
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type CrossCollisionBlock_ = CrossCollisionBlock;
    interface ConstProperties {
        isConst(arg0: string): boolean;
        putConst(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_, arg3: any): void;
        defineConst(arg0: Internal.Context_, arg1: string, arg2: Internal.Scriptable_): void;
    }
    type ConstProperties_ = ConstProperties;
    interface PreviewedArgument <T> extends Internal.ArgumentType<T> {
        parse(arg0: Internal.StringReader_): T;
        getExamples(): Internal.Collection<string>;
        getValueType(): T;
        resolvePreview(arg0: Internal.CommandSourceStack_, arg1: Internal.ParsedArgument_<Internal.CommandSourceStack, any>): Internal.CompletableFuture<Internal.Component>;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        resolvePreview(arg0: Internal.CommandSourceStack_, arg1: T): Internal.CompletableFuture<Internal.Component>;
        get examples(): Internal.Collection<string>
        get valueType(): T
    }
    type PreviewedArgument_<T> = PreviewedArgument<T>;
    interface CharSequence {
        compare(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_): number;
        subSequence(arg0: number, arg1: number): this;
        toString(): string;
        chars(): Internal.IntStream;
        charAt(arg0: number): string;
        isEmpty(): boolean;
        length(): number;
        codePoints(): Internal.IntStream;
        get empty(): boolean
    }
    type CharSequence_ = CharSequence;
    class ChainBlock extends Internal.RotatedPillarBlock implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type ChainBlock_ = ChainBlock;
    interface IForgePoseStack {
        pushTransformation(arg0: Internal.Transformation_): void;
    }
    type IForgePoseStack_ = IForgePoseStack;
    class Enchantment$Rarity extends Internal.Enum<Internal.Enchantment$Rarity> {
        static values(): Internal.Enchantment$Rarity[];
        getWeight(): number;
        static valueOf(arg0: string): Internal.Enchantment$Rarity;
        get weight(): number
        static readonly VERY_RARE: Internal.Enchantment$Rarity;
        static readonly RARE: Internal.Enchantment$Rarity;
        static readonly UNCOMMON: Internal.Enchantment$Rarity;
        static readonly COMMON: Internal.Enchantment$Rarity;
    }
    type Enchantment$Rarity_ = "uncommon" | "rare" | "common" | "very_rare" | Enchantment$Rarity;
    class FileConfigBuilder extends Internal.GenericBuilder<Internal.Config, Internal.FileConfig> {
    }
    type FileConfigBuilder_ = FileConfigBuilder;
    class ShipwreckStructure extends Internal.Structure {
        constructor(arg0: Internal.Structure$StructureSettings_, arg1: boolean)
        readonly isBeached: boolean;
        static readonly CODEC: Internal.Codec<Internal.ShipwreckStructure>;
    }
    type ShipwreckStructure_ = ShipwreckStructure;
    class VerticalAnchor$BelowTop extends Internal.Record implements Internal.VerticalAnchor {
        constructor(arg0: number)
        static aboveBottom(arg0: number): Internal.VerticalAnchor;
        static absolute(arg0: number): Internal.VerticalAnchor;
        static belowTop(arg0: number): Internal.VerticalAnchor;
        static bottom(): Internal.VerticalAnchor;
        static top(): Internal.VerticalAnchor;
        resolveY(arg0: Internal.WorldGenerationContext_): number;
        offset(): number;
        static readonly CODEC: Internal.Codec<Internal.VerticalAnchor$BelowTop>;
    }
    type VerticalAnchor$BelowTop_ = VerticalAnchor$BelowTop;
    interface InfoDisplayOnCompile <T> {
        onCompile(arg0: Internal.InfoDisplay_<T>, arg1: Internal.InfoDisplayCompiler_, arg2: Internal.XaeroMinimapSession_, arg3: Internal.MinimapProcessor_, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: BlockPos_): void;
        (arg0: Internal.InfoDisplay_<T>, arg1: Internal.InfoDisplayCompiler_, arg2: Internal.XaeroMinimapSession_, arg3: Internal.MinimapProcessor_, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: BlockPos_): void;
    }
    type InfoDisplayOnCompile_<T> = InfoDisplayOnCompile<T>;
    class Excluder implements Internal.TypeAdapterFactory, Internal.Cloneable {
        constructor()
        withVersion(arg0: number): this;
        excludeClass(arg0: typeof any, arg1: boolean): boolean;
        excludeField(arg0: Internal.Field_, arg1: boolean): boolean;
        withExclusionStrategy(arg0: Internal.ExclusionStrategy_, arg1: boolean, arg2: boolean): this;
        withModifiers(...arg0: number[]): this;
        excludeFieldsWithoutExposeAnnotation(): this;
        disableInnerClassSerialization(): this;
        create<T>(arg0: Internal.Gson_, arg1: com.google.gson.reflect.TypeToken_<T>): Internal.TypeAdapter<T>;
        static readonly DEFAULT: Internal.Excluder;
    }
    type Excluder_ = Excluder;
    abstract class BaseSpawner {
        constructor()
        broadcastEvent(arg0: Internal.Level_, arg1: BlockPos_, arg2: number): void;
        onEventTriggered(arg0: Internal.Level_, arg1: number): boolean;
        getOrCreateDisplayEntity(arg0: Internal.Level_): Internal.Entity;
        setEntityId(arg0: Internal.EntityType_<any>): void;
        load(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.CompoundTag_): void;
        save(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        getSpin(): number;
        serverTick(arg0: Internal.ServerLevel_, arg1: BlockPos_): void;
        getoSpin(): number;
        getSpawnerBlockEntity(): Internal.BlockEntity;
        setNextSpawnData(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.SpawnData_): void;
        getSpawnerEntity(): Internal.Entity;
        clientTick(arg0: Internal.Level_, arg1: BlockPos_): void;
        set entityId(arg0: Internal.EntityType_<any>)
        get spin(): number
        get oSpin(): number
        get spawnerBlockEntity(): Internal.BlockEntity
        get spawnerEntity(): Internal.Entity
        nextSpawnData: Internal.SpawnData;
        spawnRange: number;
        spawnDelay: number;
        spawnPotentials: Internal.SimpleWeightedRandomList<Internal.SpawnData>;
        spawnCount: number;
        displayEntity: Internal.Entity;
        maxSpawnDelay: number;
        oSpin: number;
        minSpawnDelay: number;
        requiredPlayerRange: number;
        maxNearbyEntities: number;
        spin: number;
    }
    type BaseSpawner_ = BaseSpawner;
    class CarriageSyncData {
        constructor()
        read(arg0: Internal.FriendlyByteBuf_): void;
        approach(arg0: Internal.CarriageContraptionEntity_, arg1: Internal.Carriage_, arg2: number): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        getDistanceTo(arg0: Internal.TrackGraph_, arg1: Internal.TravellingPoint_, arg2: Internal.TravellingPoint_, arg3: number, arg4: boolean): number;
        update(arg0: Internal.CarriageContraptionEntity_, arg1: Internal.Carriage_): void;
        copy(): this;
        isDirty(): boolean;
        setDirty(arg0: boolean): void;
        apply(arg0: Internal.CarriageContraptionEntity_, arg1: Internal.Carriage_): void;
        get dirty(): boolean
        set dirty(arg0: boolean)
        wheelLocations: Internal.Vector<com.simibubi.create.foundation.utility.Pair<Internal.Couple<number>, number>>;
        leadingCarriage: boolean;
        fallbackLocations: com.simibubi.create.foundation.utility.Pair<Vec3, Internal.Couple<Vec3>>;
        distanceToDestination: number;
    }
    type CarriageSyncData_ = CarriageSyncData;
    interface HttpTextureAccessor {
        chatheads$setTextureLocation(arg0: ResourceLocation_): void;
    }
    type HttpTextureAccessor_ = HttpTextureAccessor;
    interface InjectedEntityTypeExtension extends Internal.InjectedRegistryEntryExtension<Internal.EntityType<any>> {
        arch$holder(): Internal.Holder<Internal.EntityType<any>>;
        arch$registryName(): ResourceLocation;
    }
    type InjectedEntityTypeExtension_ = InjectedEntityTypeExtension;
    interface StructType <S> {
        getLayout(): Internal.BufferLayout;
        create(): S;
        get layout(): Internal.BufferLayout
    }
    type StructType_<S> = StructType<S>;
    class FrostedIceBlock extends Internal.IceBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 3;
    }
    type FrostedIceBlock_ = FrostedIceBlock;
    class EventPosePlayerHand extends Internal.Event {
        constructor()
        constructor(arg0: Internal.LivingEntity_, arg1: Internal.HumanoidModel_<any>, arg2: boolean)
        isLeftHand(): boolean;
        getEntityIn(): Internal.Entity;
        getModel(): Internal.HumanoidModel<any>;
        get leftHand(): boolean
        get entityIn(): Internal.Entity
        get model(): Internal.HumanoidModel<any>
    }
    type EventPosePlayerHand_ = EventPosePlayerHand;
    interface ShortListIterator extends Internal.ListIterator<number>, Internal.ShortBidirectionalIterator {
        /**
         * @deprecated
        */
        add(arg0: any): void;
        /**
         * @deprecated
        */
        set(arg0: number): void;
        previousShort(): number;
        nextIndex(): number;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        forEachRemaining(arg0: any): void;
        /**
         * @deprecated
        */
        next(): any;
        /**
         * @deprecated
        */
        set(arg0: any): void;
        skip(arg0: number): number;
        forEachRemaining(arg0: Internal.IntConsumer_): void;
        nextShort(): number;
        forEachRemaining(arg0: Internal.ShortConsumer_): void;
        add(arg0: number): void;
        remove(): void;
        hasPrevious(): boolean;
        back(arg0: number): number;
        hasNext(): boolean;
        set(arg0: number): void;
        /**
         * @deprecated
        */
        previous(): any;
        /**
         * @deprecated
        */
        add(arg0: number): void;
        previousIndex(): number;
    }
    type ShortListIterator_ = ShortListIterator;
    class Markings extends Internal.Enum<Internal.Markings> {
        static byId(arg0: number): Internal.Markings;
        static values(): Internal.Markings[];
        getId(): number;
        static valueOf(arg0: string): Internal.Markings;
        get id(): number
        static readonly BLACK_DOTS: Internal.Markings;
        static readonly WHITE_FIELD: Internal.Markings;
        static readonly NONE: Internal.Markings;
        static readonly WHITE: Internal.Markings;
        static readonly WHITE_DOTS: Internal.Markings;
    }
    type Markings_ = "white_field" | "white" | "black_dots" | Markings | "white_dots" | "none";
    class ClientboundPlayerLookAtPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: number, arg2: number, arg3: number)
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Internal.Entity_, arg2: Internal.EntityAnchorArgument$Anchor_)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getPosition(arg0: Internal.Level_): Vec3;
        isSkippable(): boolean;
        getFromAnchor(): Internal.EntityAnchorArgument$Anchor;
        get skippable(): boolean
        get fromAnchor(): Internal.EntityAnchorArgument$Anchor
    }
    type ClientboundPlayerLookAtPacket_ = ClientboundPlayerLookAtPacket;
    interface ResourceLocationAccess {
        setNamespace(arg0: string): void;
        setPath(arg0: string): void;
        set namespace(arg0: string)
        set path(arg0: string)
    }
    type ResourceLocationAccess_ = ResourceLocationAccess;
    class EventRenderSplashText extends Internal.Event {
        constructor()
        constructor(arg0: string, arg1: Internal.PoseStack_, arg2: Internal.TitleScreen_, arg3: number)
        getPoseStack(): Internal.PoseStack;
        getSplashText(): string;
        getPartialTicks(): number;
        setSplashText(arg0: string): void;
        getTitleScreen(): Internal.TitleScreen;
        get poseStack(): Internal.PoseStack
        get splashText(): string
        get partialTicks(): number
        set splashText(arg0: string)
        get titleScreen(): Internal.TitleScreen
    }
    type EventRenderSplashText_ = EventRenderSplashText;
    interface Shader {
        getFragmentProgram(): Internal.Program;
        markDirty(): void;
        attachToProgram(): void;
        getVertexProgram(): Internal.Program;
        getId(): number;
        get fragmentProgram(): Internal.Program
        get vertexProgram(): Internal.Program
        get id(): number
    }
    type Shader_ = Shader;
    class NormalNoise$NoiseParameters extends Internal.Record {
        constructor(arg0: number, arg1: Internal.DoubleList_)
        constructor(arg0: number, arg1: number, ...arg2: number[])
        constructor(arg0: number, arg1: Internal.List_<number>)
        amplitudes(): Internal.DoubleList;
        firstOctave(): number;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.NormalNoise$NoiseParameters>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.NormalNoise$NoiseParameters>>;
    }
    type NormalNoise$NoiseParameters_ = Special.Noise | NormalNoise$NoiseParameters;
    class ModConfigEvent$Loading extends Internal.ModConfigEvent {
        constructor()
        constructor(arg0: Internal.ModConfig_)
        static loading(arg0: Internal.ModConfig_): Internal.IConfigEvent;
        self<T extends Internal.Event & Internal.IConfigEvent>(): T;
        static reloading(arg0: Internal.ModConfig_): Internal.IConfigEvent;
    }
    type ModConfigEvent$Loading_ = ModConfigEvent$Loading;
    interface IGuiOverlay {
        render(arg0: Internal.ForgeGui_, arg1: Internal.PoseStack_, arg2: number, arg3: number, arg4: number): void;
        (arg0: Internal.ForgeGui_, arg1: Internal.PoseStack_, arg2: number, arg3: number, arg4: number): void;
    }
    type IGuiOverlay_ = IGuiOverlay;
    class GridAlignedBB implements Internal.ImmutableBox {
        constructor()
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number)
        sizeY(): number;
        unionAssign(arg0: Internal.ImmutableBox_): void;
        intersect(arg0: Internal.ImmutableBox_): this;
        static from(arg0: BlockPos_, arg1: BlockPos_): Internal.GridAlignedBB;
        sameAs(arg0: Internal.ImmutableBox_): boolean;
        intersectAssign(arg0: Internal.ImmutableBox_): void;
        forEachContained(arg0: Internal.CoordinateConsumer_): void;
        getMinY(): number;
        setMinY(arg0: number): this;
        getMaxY(): number;
        intersects(arg0: Internal.ImmutableBox_): boolean;
        setMaxX(arg0: number): this;
        static from(arg0: BlockPos_): Internal.GridAlignedBB;
        setMaxZ(arg0: number): this;
        union(arg0: Internal.ImmutableBox_): Internal.ImmutableBox;
        volume(): number;
        intersects(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
        sameAs(arg0: Internal.ImmutableBox_, arg1: number): boolean;
        nextPowerOf2(): void;
        setMax(arg0: Vec3i_): this;
        translate(arg0: Vec3i_): void;
        setMax(arg0: number, arg1: number, arg2: number): this;
        static from(arg0: Internal.AABB_): Internal.GridAlignedBB;
        nextPowerOf2Centered(): void;
        translate(arg0: number, arg1: number, arg2: number): void;
        grow(arg0: number): void;
        empty(): boolean;
        setMin(arg0: Vec3i_): this;
        setMin(arg0: number, arg1: number, arg2: number): this;
        sizeX(): number;
        sizeZ(): number;
        grow(arg0: number, arg1: number, arg2: number): void;
        fixMinMax(): void;
        sameAs(arg0: Internal.AABB_): boolean;
        toAABB(): Internal.AABB;
        assign(arg0: BlockPos_, arg1: BlockPos_): this;
        getMaxZ(): number;
        mirrorAbout(arg0: Internal.Direction$Axis_): void;
        contains(arg0: number, arg1: number, arg2: number): boolean;
        setMinZ(arg0: number): this;
        getMinX(): number;
        setMinX(arg0: number): this;
        getMaxX(): number;
        getMinZ(): number;
        unionAssign(arg0: Internal.AABB_): void;
        static containingAll(arg0: Internal.Collection_<BlockPos>): Internal.ImmutableBox;
        setMaxY(arg0: number): this;
        contains(arg0: Internal.ImmutableBox_): boolean;
        isContainedBy(arg0: Internal.GridAlignedBB_): boolean;
        static from(arg0: Internal.SectionPos_): Internal.GridAlignedBB;
        assign(arg0: Internal.AABB_): void;
        hasPowerOf2Sides(): boolean;
        static ofRadius(arg0: number): Internal.GridAlignedBB;
        static from(arg0: number, arg1: number): Internal.GridAlignedBB;
        assign(arg0: Internal.ImmutableBox_): void;
        copy(): this;
        get minY(): number
        set minY(arg0: number)
        get maxY(): number
        set maxX(arg0: number)
        set maxZ(arg0: number)
        set max(arg0: Vec3i_)
        set min(arg0: Vec3i_)
        get maxZ(): number
        set minZ(arg0: number)
        get minX(): number
        set minX(arg0: number)
        get maxX(): number
        get minZ(): number
        set maxY(arg0: number)
    }
    type GridAlignedBB_ = GridAlignedBB;
    class Currency implements Internal.Serializable {
        static getInstance(arg0: string): Internal.Currency;
        getSymbol(arg0: Internal.Locale_): string;
        getNumericCode(): number;
        static getAvailableCurrencies(): Internal.Set<Internal.Currency>;
        getNumericCodeAsString(): string;
        getDisplayName(): string;
        getDisplayName(arg0: Internal.Locale_): string;
        getSymbol(): string;
        getDefaultFractionDigits(): number;
        getCurrencyCode(): string;
        static getInstance(arg0: Internal.Locale_): Internal.Currency;
        get numericCode(): number
        get availableCurrencies(): Internal.Set<Internal.Currency>
        get numericCodeAsString(): string
        get displayName(): string
        get symbol(): string
        get defaultFractionDigits(): number
        get currencyCode(): string
    }
    type Currency_ = Currency;
    class ClientboundSetActionBarTextPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.Component_)
        constructor(arg0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getText(): Internal.Component;
        isSkippable(): boolean;
        get text(): Internal.Component
        get skippable(): boolean
    }
    type ClientboundSetActionBarTextPacket_ = ClientboundSetActionBarTextPacket;
    class LinkedHashMap <K, V> extends Internal.HashMap<K, V> implements Internal.Map<K, V> {
        constructor()
        constructor(arg0: Internal.Map_<K, V>)
        constructor(arg0: number)
        constructor(arg0: number, arg1: number, arg2: boolean)
        constructor(arg0: number, arg1: number)
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        putIfAbsent(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type LinkedHashMap_<K, V> = LinkedHashMap<K, V>;
    interface InterruptibleChannel extends Internal.Channel {
        isOpen(): boolean;
        close(): void;
        get open(): boolean
    }
    type InterruptibleChannel_ = InterruptibleChannel;
    interface IXaeroClickableWidget extends xaero.common.gui.ICanTooltip {
        getXaero_tooltip(): Internal.Supplier<Internal.CursorBox>;
        setXaero_tooltip(arg0: Internal.Supplier_<Internal.CursorBox>): void;
        get xaero_tooltip(): Internal.Supplier<Internal.CursorBox>
        set xaero_tooltip(arg0: Internal.Supplier_<Internal.CursorBox>)
    }
    type IXaeroClickableWidget_ = IXaeroClickableWidget;
    class DummySensor extends Internal.Sensor<Internal.LivingEntity> {
        constructor()
    }
    type DummySensor_ = DummySensor;
    abstract class DrawOp extends Internal.Op {
        constructor()
        usesStencil(): boolean;
    }
    type DrawOp_ = DrawOp;
    class ServerData {
        constructor(arg0: string, arg1: string, arg2: boolean)
        static parseFavicon(arg0: string): string;
        setResourcePackStatus(arg0: Internal.ServerData$ServerPackStatus_): void;
        write(): Internal.CompoundTag;
        getIconB64(): string;
        getChatPreview(): Internal.ServerData$ChatPreview;
        setChatPreviewEnabled(arg0: boolean): void;
        setEnforcesSecureChat(arg0: boolean): void;
        isLan(): boolean;
        enforcesSecureChat(): boolean;
        previewsChat(): boolean;
        static read(arg0: Internal.CompoundTag_): Internal.ServerData;
        copyNameIconFrom(arg0: Internal.ServerData_): void;
        setIconB64(arg0: string): void;
        setPreviewsChat(arg0: boolean): void;
        getResourcePackStatus(): Internal.ServerData$ServerPackStatus;
        copyFrom(arg0: Internal.ServerData_): void;
        set resourcePackStatus(arg0: Internal.ServerData$ServerPackStatus_)
        get iconB64(): string
        get chatPreview(): Internal.ServerData$ChatPreview
        set chatPreviewEnabled(arg0: boolean)
        set enforcesSecureChat(arg0: boolean)
        get lan(): boolean
        set iconB64(arg0: string)
        set previewsChat(arg0: boolean)
        get resourcePackStatus(): Internal.ServerData$ServerPackStatus
        name: string;
        playerList: Internal.List<Internal.Component>;
        ip: string;
        ping: number;
        motd: Internal.Component;
        pinged: boolean;
        forgeData: Internal.ExtendedServerListData;
        version: Internal.Component;
        status: Internal.Component;
        protocol: number;
    }
    type ServerData_ = ServerData;
    class FoodProperties {
        getSaturationModifier(): number;
        getEffects(): Internal.List<com.mojang.datafixers.util.Pair<Internal.MobEffectInstance, number>>;
        isMeat(): boolean;
        getNutrition(): number;
        isFastFood(): boolean;
        canAlwaysEat(): boolean;
        get saturationModifier(): number
        get effects(): Internal.List<com.mojang.datafixers.util.Pair<Internal.MobEffectInstance, number>>
        get meat(): boolean
        get nutrition(): number
        get fastFood(): boolean
    }
    type FoodProperties_ = FoodProperties;
    class CauldronBlock extends Internal.AbstractCauldronBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type CauldronBlock_ = CauldronBlock;
    class ChatType$Bound extends Internal.Record {
        constructor(arg0: Internal.ChatType_, arg1: Internal.Component_, arg2: Internal.Component_)
        toNetwork(arg0: Internal.RegistryAccess_): Internal.ChatType$BoundNetwork;
        decorateNarration(arg0: Internal.Component_): Internal.Component;
        decorate(arg0: Internal.Component_): Internal.Component;
        name(): Internal.Component;
        targetName(): Internal.Component;
        withTargetName(arg0: Internal.Component_): this;
        chatType(): Internal.ChatType;
    }
    type ChatType$Bound_ = ChatType$Bound;
    interface ToIntFunction <T> {
        applyAsInt(arg0: T): number;
        (arg0: T): number;
    }
    type ToIntFunction_<T> = ToIntFunction<T>;
    class OpFlushState implements Internal.MeshDrawTarget {
        constructor(server: Internal.Server_, resourceProvider: icyllis.arc3d.engine.ResourceProvider_)
        findOrCreatePipelineState(pipelineInfo: Internal.PipelineInfo_): Internal.PipelineState;
        makeIndexSpace(mesh: Internal.Mesh_): number;
        makeVertexWriter(mesh: Internal.Mesh_): Internal.ByteBuffer;
        getOpsRenderPass(): Internal.OpsRenderPass;
        beginOpsRenderPass(writeView: Internal.SurfaceProxyView_, contentBounds: icyllis.arc3d.core.Rect2i_, colorOps: number, stencilOps: number, clearColor: number[], sampledTextures: Internal.Set_<Internal.TextureProxy>, pipelineFlags: number): Internal.OpsRenderPass;
        makeInstanceSpace(mesh: Internal.Mesh_): number;
        makeIndexWriter(mesh: Internal.Mesh_): Internal.ByteBuffer;
        reset(): void;
        getServer(): Internal.Server;
        makeInstanceWriter(mesh: Internal.Mesh_): Internal.ByteBuffer;
        makeVertexSpace(mesh: Internal.Mesh_): number;
        get opsRenderPass(): Internal.OpsRenderPass
        get server(): Internal.Server
    }
    type OpFlushState_ = OpFlushState;
    class Holder$Kind extends Internal.Enum<Internal.Holder$Kind> {
        static values(): Internal.Holder$Kind[];
        static valueOf(arg0: string): Internal.Holder$Kind;
        static readonly DIRECT: Internal.Holder$Kind;
        static readonly REFERENCE: Internal.Holder$Kind;
    }
    type Holder$Kind_ = "reference" | Holder$Kind | "direct";
    class Tuple <A, B> {
        constructor(arg0: A, arg1: B)
        getA(): A;
        getB(): B;
        setA(arg0: A): void;
        setB(arg0: B): void;
        get a(): A
        get b(): B
        set a(arg0: A)
        set b(arg0: B)
    }
    type Tuple_<A, B> = Tuple<A, B>;
    class ParticleRenderingPhase extends Internal.Enum<Internal.ParticleRenderingPhase> {
        static values(): Internal.ParticleRenderingPhase[];
        static valueOf(name: string): Internal.ParticleRenderingPhase;
        static readonly EVERYTHING: Internal.ParticleRenderingPhase;
        static readonly TRANSLUCENT: Internal.ParticleRenderingPhase;
        static readonly OPAQUE: Internal.ParticleRenderingPhase;
    }
    type ParticleRenderingPhase_ = ParticleRenderingPhase | "translucent" | "opaque" | "everything";
    class BlendMode {
        constructor()
        constructor(arg0: number, arg1: number, arg2: number)
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number)
        isOpaque(): boolean;
        static stringToBlendFactor(arg0: string): number;
        static stringToBlendFunc(arg0: string): number;
        apply(): void;
        get opaque(): boolean
    }
    type BlendMode_ = BlendMode;
    class TextTrieMap$Output {
        constructor()
        matchLength: number;
        partialMatch: boolean;
    }
    type TextTrieMap$Output_ = TextTrieMap$Output;
    class SpellContext$CasterType {
        constructor(arg0: string)
        static readonly ENTITY: Internal.SpellContext$CasterType;
        static readonly LIVING_ENTITY: Internal.SpellContext$CasterType;
        id: string;
        static readonly RUNE: Internal.SpellContext$CasterType;
        static readonly TURRET: Internal.SpellContext$CasterType;
        static readonly PLAYER: Internal.SpellContext$CasterType;
        static readonly OTHER: Internal.SpellContext$CasterType;
    }
    type SpellContext$CasterType_ = SpellContext$CasterType;
    class PNGExportResultType extends Internal.Enum<Internal.PNGExportResultType> {
        isSuccess(): boolean;
        getMessage(): Internal.Component;
        static values(): Internal.PNGExportResultType[];
        static valueOf(arg0: string): Internal.PNGExportResultType;
        get success(): boolean
        get message(): Internal.Component
        static readonly BAD_FBO: Internal.PNGExportResultType;
        static readonly NOT_PREPARED: Internal.PNGExportResultType;
        static readonly IMAGE_TOO_BIG: Internal.PNGExportResultType;
        static readonly IO_EXCEPTION: Internal.PNGExportResultType;
        static readonly TOO_BIG: Internal.PNGExportResultType;
        static readonly OUT_OF_MEMORY: Internal.PNGExportResultType;
        static readonly EMPTY: Internal.PNGExportResultType;
        static readonly SUCCESS: Internal.PNGExportResultType;
    }
    type PNGExportResultType_ = "out_of_memory" | "image_too_big" | "empty" | "not_prepared" | "success" | "too_big" | "io_exception" | PNGExportResultType | "bad_fbo";
    class LerpingBossEvent extends Internal.BossEvent {
        constructor(arg0: Internal.UUID_, arg1: Internal.Component_, arg2: number, arg3: Internal.BossEvent$BossBarColor_, arg4: Internal.BossEvent$BossBarOverlay_, arg5: boolean, arg6: boolean, arg7: boolean)
    }
    type LerpingBossEvent_ = LerpingBossEvent;
    class MovingPistonBlock extends Internal.BaseEntityBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        static newMovingBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.BlockState_, arg3: Internal.Direction_, arg4: boolean, arg5: boolean): Internal.BlockEntity;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly TYPE: Internal.EnumProperty<Internal.PistonType>;
        static readonly FACING: Internal.DirectionProperty;
    }
    type MovingPistonBlock_ = MovingPistonBlock;
    class Module implements Internal.AnnotatedElement {
        getAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getDeclaredAnnotation<T extends Internal.Annotation>(arg0: T): T;
        addOpens(arg0: string, arg1: Internal.Module_): this;
        isNamed(): boolean;
        getDeclaredAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        isExported(arg0: string, arg1: Internal.Module_): boolean;
        getLayer(): Internal.ModuleLayer;
        isOpen(arg0: string): boolean;
        isOpen(arg0: string, arg1: Internal.Module_): boolean;
        addReads(arg0: Internal.Module_): this;
        isExported(arg0: string): boolean;
        addExports(arg0: string, arg1: Internal.Module_): this;
        getPackages(): Internal.Set<string>;
        getName(): string;
        addUses(arg0: typeof any): this;
        getClassLoader(): Internal.ClassLoader;
        canRead(arg0: Internal.Module_): boolean;
        getAnnotations(): Internal.Annotation[];
        getDescriptor(): Internal.ModuleDescriptor;
        canUse(arg0: typeof any): boolean;
        getResourceAsStream(arg0: string): Internal.InputStream;
        getDeclaredAnnotations(): Internal.Annotation[];
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        get named(): boolean
        get layer(): Internal.ModuleLayer
        get packages(): Internal.Set<string>
        get name(): string
        get classLoader(): Internal.ClassLoader
        get annotations(): Internal.Annotation[]
        get descriptor(): Internal.ModuleDescriptor
        get declaredAnnotations(): Internal.Annotation[]
    }
    type Module_ = Module;
    class NamespacedHolderHelper <T> {
    }
    type NamespacedHolderHelper_<T> = NamespacedHolderHelper<T>;
    class LakeFeature$Configuration extends Internal.Record implements Internal.FeatureConfiguration {
        constructor(arg0: Internal.BlockStateProvider_, arg1: Internal.BlockStateProvider_)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        barrier(): Internal.BlockStateProvider;
        fluid(): Internal.BlockStateProvider;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.LakeFeature$Configuration>;
    }
    type LakeFeature$Configuration_ = LakeFeature$Configuration;
    class WallSkullBlock extends Internal.AbstractSkullBlock {
        constructor(arg0: Internal.SkullBlock$Type_, arg1: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type WallSkullBlock_ = WallSkullBlock;
    class ConduitBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type ConduitBlock_ = ConduitBlock;
    interface ModelCuboidAccessor {
        getQuads(): any[];
        get quads(): any[]
    }
    type ModelCuboidAccessor_ = ModelCuboidAccessor;
    abstract class MapBlockMarker <D extends Internal.CustomMapDecoration> {
        getPos(): BlockPos;
        saveToNBT(compound: Internal.CompoundTag_): Internal.CompoundTag;
        getRotation(): number;
        loadFromNBT(compound: Internal.CompoundTag_): void;
        shouldUpdate(other: Internal.MapBlockMarker_<any>): boolean;
        setPos(pos: BlockPos_): void;
        getMarkerId(): string;
        updateDecoration(old: Internal.CustomMapDecoration_): void;
        getType(): Internal.MapDecorationType<D, any>;
        createDecorationFromMarker(scale: number, x: number, z: number, dimension: Internal.ResourceKey_<Internal.Level>, locked: boolean): D;
        getTypeId(): string;
        get pos(): BlockPos
        get rotation(): number
        set pos(pos: BlockPos_)
        get markerId(): string
        get type(): Internal.MapDecorationType<D, any>
        get typeId(): string
        pos: BlockPos;
    }
    type MapBlockMarker_<D extends Internal.CustomMapDecoration> = MapBlockMarker<D>;
    class ShapedRecipeSchema$ShapedRecipeJS extends Internal.RecipeJS {
        constructor()
        noShrink(): Internal.RecipeJS;
        getMod(): string;
        noMirror(): Internal.RecipeJS;
        get mod(): string
    }
    type ShapedRecipeSchema$ShapedRecipeJS_ = ShapedRecipeSchema$ShapedRecipeJS;
    class BlockEvent$BlockToolModificationEvent extends Internal.BlockEvent {
        constructor()
        constructor(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean)
        getHeldItemStack(): Internal.ItemStack;
        setFinalState(arg0: Internal.BlockState_): void;
        getFinalState(): Internal.BlockState;
        getContext(): Internal.UseOnContext;
        isSimulated(): boolean;
        getPlayer(): Internal.Player;
        getToolAction(): Internal.ToolAction;
        get heldItemStack(): Internal.ItemStack
        set finalState(arg0: Internal.BlockState_)
        get finalState(): Internal.BlockState
        get context(): Internal.UseOnContext
        get simulated(): boolean
        get player(): Internal.Player
        get toolAction(): Internal.ToolAction
    }
    type BlockEvent$BlockToolModificationEvent_ = BlockEvent$BlockToolModificationEvent;
    abstract class RandomizableContainerBlockEntity extends Internal.BaseContainerBlockEntity {
        stopOpen(arg0: Internal.Player_): void;
        static tryClear(arg0: any): void;
        getItems(): Internal.NonNullList<Internal.ItemStack>;
        requestModelDataUpdate(): void;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf(arg0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        setChanged(): void;
        onLoad(): void;
        hasAnyMatching(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        kjs$self(): Internal.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        static setLootTable(arg0: Internal.BlockGetter_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: ResourceLocation_): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        hasCustomName(): boolean;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        forEach(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        getRenderBoundingBox(): Internal.AABB;
        setLootTable(arg0: ResourceLocation_, arg1: number): void;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        countItem(arg0: Internal.Item_): number;
        isEmpty(): boolean;
        startOpen(arg0: Internal.Player_): void;
        canPlaceItem(arg0: number, arg1: Internal.ItemStack_): boolean;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        countNonEmpty(): number;
        deserializeNBT(arg0: Internal.Tag_): void;
        getAllItems(): Internal.List<Internal.ItemStack>;
        iterator(): Internal.Iterator<Internal.ItemStack>;
        serializeNBT(): Internal.CompoundTag;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        unpackLootTable(arg0: Internal.Player_): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getModelData(): Internal.ModelData;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get items(): Internal.NonNullList<Internal.ItemStack>
        get slots(): number
        get width(): number
        get maxStackSize(): number
        get renderBoundingBox(): Internal.AABB
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get modelData(): Internal.ModelData
        get mutable(): boolean
        lootTableSeed: number;
        static readonly LOOT_TABLE_SEED_TAG: "LootTableSeed";
        static readonly LOOT_TABLE_TAG: "LootTable";
        lootTable: ResourceLocation;
    }
    type RandomizableContainerBlockEntity_ = RandomizableContainerBlockEntity;
    class BellBlockEntity extends Internal.BlockEntity implements Internal.IBellConnections {
        constructor(arg0: BlockPos_, arg1: Internal.BlockState_)
        static serverTick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BellBlockEntity_): void;
        deserializeNBT(arg0: Internal.Tag_): void;
        requestModelDataUpdate(): void;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        serializeNBT(): Internal.CompoundTag;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getConnected(): Internal.IBellConnections$BellConnection;
        getUpdatePacket(): Internal.Packet<any>;
        getModelData(): Internal.ModelData;
        onLoad(): void;
        static clientTick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BellBlockEntity_): void;
        m_183515_(compound: Internal.CompoundTag_): void;
        setConnected(con: Internal.IBellConnections$BellConnection_): void;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        onHit(arg0: Internal.Direction_): void;
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get connected(): Internal.IBellConnections$BellConnection
        get updatePacket(): Internal.Packet<any>
        get modelData(): Internal.ModelData
        set connected(con: Internal.IBellConnections$BellConnection_)
        shaking: boolean;
        clickDirection: Internal.Direction;
        ticks: number;
        connection: Internal.IBellConnections$BellConnection;
    }
    type BellBlockEntity_ = BellBlockEntity;
    interface ByteBufAllocator {
        compositeDirectBuffer(arg0: number): Internal.CompositeByteBuf;
        directBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        buffer(): Internal.ByteBuf;
        compositeHeapBuffer(arg0: number): Internal.CompositeByteBuf;
        compositeDirectBuffer(): Internal.CompositeByteBuf;
        compositeBuffer(): Internal.CompositeByteBuf;
        heapBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        ioBuffer(): Internal.ByteBuf;
        heapBuffer(): Internal.ByteBuf;
        heapBuffer(arg0: number): Internal.ByteBuf;
        ioBuffer(arg0: number): Internal.ByteBuf;
        compositeBuffer(arg0: number): Internal.CompositeByteBuf;
        directBuffer(): Internal.ByteBuf;
        isDirectBufferPooled(): boolean;
        calculateNewCapacity(arg0: number, arg1: number): number;
        directBuffer(arg0: number): Internal.ByteBuf;
        ioBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        buffer(arg0: number, arg1: number): Internal.ByteBuf;
        compositeHeapBuffer(): Internal.CompositeByteBuf;
        buffer(arg0: number): Internal.ByteBuf;
        get directBufferPooled(): boolean
        readonly DEFAULT: Internal.PooledByteBufAllocator;
    }
    type ByteBufAllocator_ = ByteBufAllocator;
    class Item$Properties {
        constructor()
        rarity(arg0: Internal.Rarity_): this;
        durability(arg0: number): this;
        setNoRepair(): this;
        fireResistant(): this;
        food(arg0: Internal.FoodProperties_): this;
        craftRemainder(arg0: Internal.Item_): this;
        defaultDurability(arg0: number): this;
        tab(arg0: Internal.CreativeModeTab_): this;
        stacksTo(arg0: number): this;
    }
    type Item$Properties_ = Item$Properties;
    class ContextOptions {
        constructor()
        mGlyphCacheTextureMaximumBytes: number;
        mSupportBilerpFromGlyphAtlas: boolean;
        mErrorWriter: Internal.PrintWriter;
        mSkipGLErrorChecks: boolean;
        mInternalMultisampleCount: number;
        mMaxVkSecondaryCommandBufferCacheSize: number;
        mMaxTextureSizeOverride: number;
        mReducedShaderVariations: boolean;
        mMaxRuntimeProgramCacheSize: number;
        mAllowMultipleGlyphCacheTextures: boolean;
        mGlyphsAsPathsFontSize: number;
        mSharpenMipmappedTextures: boolean;
        mMinDistanceFieldFontSize: number;
    }
    type ContextOptions_ = ContextOptions;
    class MapRunner implements Internal.Runnable {
        constructor()
        doTasks(arg0: Internal.MapProcessor_): void;
        stop(): void;
        run(): void;
        addTask(arg0: Internal.MapRunnerTask_): void;
    }
    type MapRunner_ = MapRunner;
    interface IFocusGroup {
        getAllFocuses(): Internal.List<Internal.IFocus<any>>;
        getFocuses<T>(arg0: Internal.IIngredientType_<T>, arg1: Internal.RecipeIngredientRole_): Internal.Stream<Internal.IFocus<T>>;
        getItemStackFocuses(): Internal.Stream<Internal.IFocus<Internal.ItemStack>>;
        getItemStackFocuses(arg0: Internal.RecipeIngredientRole_): Internal.Stream<Internal.IFocus<Internal.ItemStack>>;
        getFocuses<T>(arg0: Internal.IIngredientType_<T>): Internal.Stream<Internal.IFocus<T>>;
        isEmpty(): boolean;
        getFocuses(arg0: Internal.RecipeIngredientRole_): Internal.Stream<Internal.IFocus<any>>;
        get allFocuses(): Internal.List<Internal.IFocus<any>>
        get itemStackFocuses(): Internal.Stream<Internal.IFocus<Internal.ItemStack>>
        get empty(): boolean
    }
    type IFocusGroup_ = IFocusGroup;
    interface AsynchronousChannel extends Internal.Channel {
        isOpen(): boolean;
        close(): void;
        get open(): boolean
    }
    type AsynchronousChannel_ = AsynchronousChannel;
    interface SelectionSpace {
        forEach(arg0: Internal.Consumer_<ResourceLocation>): void;
        (arg0: Internal.Consumer_<ResourceLocation>): void;
    }
    type SelectionSpace_ = SelectionSpace;
    class Villager extends Internal.AbstractVillager implements Internal.VillagerDataHolder, Internal.ReputationEventHandler {
        constructor(arg0: Internal.EntityType_<Internal.Villager>, arg1: Internal.Level_)
        constructor(arg0: Internal.EntityType_<Internal.Villager>, arg1: Internal.Level_, arg2: Internal.VillagerType_)
        isAlwaysBaby(): boolean;
        getDistance(pos: BlockPos_): number;
        getVillagerData(): Internal.VillagerData;
        restock(): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        getGossips(): Internal.GossipContainer;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getPlayerReputation(arg0: Internal.Player_): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        wantsMoreFood(): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        equipped(arg0: Internal.ItemEntity_): boolean;
        swing(): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        getBrain(): Internal.Brain<Internal.Villager>;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        static setStunted(entity: Internal.AgeableMob_, stunted: boolean): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        shouldRestock(): boolean;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        wantsToSpawnGolem(arg0: number): boolean;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        isChasing(): boolean;
        static isBlocked(entity: Internal.Entity_): boolean;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        static pickUpItem(arg0: Internal.Mob_, arg1: Internal.InventoryCarrier_, arg2: Internal.ItemEntity_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        playWorkSound(): void;
        spawnGolemIfNeeded(arg0: Internal.ServerLevel_, arg1: number, arg2: number): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        assignProfessionWhenSpawned(): boolean;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        releasePoi(arg0: Internal.MemoryModuleType_<Internal.GlobalPos>): void;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        mobInteract(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        gossip(arg0: Internal.ServerLevel_, arg1: Internal.Villager_, arg2: number): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        setGossips(arg0: Internal.Tag_): void;
        hasExcessFood(): boolean;
        refreshBrain(arg0: Internal.ServerLevel_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        getBreedOffspring(arg0: Internal.ServerLevel_, arg1: Internal.AgeableMob_): this;
        isDynamicLightEnabled(): boolean;
        hasFarmSeeds(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setChasing(arg0: boolean): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        openTradingScreen(arg0: Internal.Player_, arg1: Internal.Component_, arg2: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        setOffers(arg0: Internal.MerchantOffers_): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setVillagerData(arg0: Internal.VillagerData_): void;
        eatAndDigestFood(): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        setVillagerXp(arg0: number): void;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        increaseMerchantCareer(): void;
        setAnimationTick(arg0: number): void;
        onReputationEventFrom(arg0: Internal.ReputationEventType_, arg1: Internal.Entity_): void;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        get alwaysBaby(): boolean
        get villagerData(): Internal.VillagerData
        get gossips(): Internal.GossipContainer
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get brain(): Internal.Brain<Internal.Villager>
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get chasing(): boolean
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        set gossips(arg0: Internal.Tag_)
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set chasing(arg0: boolean)
        set totalMovementSpeedMultiplier(speed: number)
        set offers(arg0: Internal.MerchantOffers_)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set villagerData(arg0: Internal.VillagerData_)
        set motionX(x: number)
        set villagerXp(arg0: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly FOOD_POINTS: {[key: Internal.Item]: 4, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.ItemNameBlockItem]: 1, [key: Internal.Item]: 1};
        static readonly SPEED_MODIFIER: 0.5;
        static readonly BREEDING_FOOD_THRESHOLD: 12;
        static MEMORY_TYPES: [Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>, Internal.MemoryModuleType<any>];
        increaseProfessionLevelOnUpdate: boolean;
        updateMerchantTimer: number;
        static readonly POI_MEMORIES: {[key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any, [key: Internal.MemoryModuleType<any>]: any};
    }
    type Villager_ = Villager;
    interface Float2IntFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToIntFunction {
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Float2ShortFunction;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        defaultReturnValue(): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2IntFunction;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2IntFunction;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Float2ByteFunction;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2IntFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Float2LongFunction;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Float2FloatFunction;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Float2ObjectFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        getOrDefault(arg0: number, arg1: number): number;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Float2CharFunction;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2IntFunction;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Float2DoubleFunction;
        apply(arg0: number): number;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2IntFunction<T>;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2IntFunction<T>;
        size(): number;
        defaultReturnValue(arg0: number): void;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2IntFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2IntFunction;
        clear(): void;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Float2ReferenceFunction<T>;
        get(arg0: number): number;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type Float2IntFunction_ = Float2IntFunction;
    class TemptingSensor extends Internal.Sensor<Internal.PathfinderMob> {
        constructor(arg0: Internal.Ingredient_)
        static readonly TEMPTATION_RANGE: 10;
    }
    type TemptingSensor_ = TemptingSensor;
    class ScaleModifier implements Internal.Comparable<Internal.ScaleModifier> {
        constructor()
        constructor(priority: number)
        modifyPrevScale(scaleData: Internal.ScaleData_, modifiedScale: number): number;
        getPriority(): number;
        compareTo(o: Internal.ScaleModifier_): number;
        modifyScale(scaleData: Internal.ScaleData_, modifiedScale: number, delta: number): number;
        compareTo(arg0: any): number;
        get priority(): number
    }
    type ScaleModifier_ = ScaleModifier;
    class ICurio$DropRule extends Internal.Enum<Internal.ICurio$DropRule> {
        static values(): Internal.ICurio$DropRule[];
        static valueOf(arg0: string): Internal.ICurio$DropRule;
        static readonly ALWAYS_KEEP: Internal.ICurio$DropRule;
        static readonly DEFAULT: Internal.ICurio$DropRule;
        static readonly DESTROY: Internal.ICurio$DropRule;
        static readonly ALWAYS_DROP: Internal.ICurio$DropRule;
    }
    type ICurio$DropRule_ = "always_keep" | ICurio$DropRule | "always_drop" | "destroy" | "default";
    class GunFireEvent$Post extends Internal.GunFireEvent {
        constructor(arg0: Internal.Player_, arg1: Internal.ItemStack_)
        constructor()
        getEntity(): Internal.LivingEntity;
        get entity(): Internal.LivingEntity
    }
    type GunFireEvent$Post_ = GunFireEvent$Post;
    abstract class AbstractSimiWidget extends Internal.AbstractWidget implements Internal.TickableGuiEventListener {
        charTyped(arg0: string, arg1: number): boolean;
        atZLevel<T extends Internal.AbstractSimiWidget>(arg0: number): T;
        getToolTip(): Internal.List<Internal.Component>;
        withCallback<T extends Internal.AbstractSimiWidget>(arg0: Internal.BiConsumer_<number, number>): T;
        withCallback<T extends Internal.AbstractSimiWidget>(arg0: Internal.Runnable_): T;
        keyReleased(arg0: number, arg1: number, arg2: number): boolean;
        mouseScrolled(arg0: number, arg1: number, arg2: number): boolean;
        mouseMoved(arg0: number, arg1: number): void;
        tick(): void;
        keyPressed(arg0: number, arg1: number, arg2: number): boolean;
        runCallback(arg0: number, arg1: number): void;
        get toolTip(): Internal.List<Internal.Component>
        lockedTooltipY: number;
        lockedTooltipX: number;
        static readonly HINT_RGB: 9877472;
        static readonly HEADER_RGB: 5476833;
    }
    type AbstractSimiWidget_ = AbstractSimiWidget;
    interface StructurePoolAccessor {
        integrated_api_getTemplates(): Internal.ObjectArrayList<Internal.StructurePoolElement>;
        integrated_api_getRawTemplates(): Internal.List<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>;
        integrated_api_setRawTemplates(arg0: Internal.List_<com.mojang.datafixers.util.Pair<Internal.StructurePoolElement, number>>): void;
        integrated_api_setTemplates(arg0: Internal.ObjectArrayList_<Internal.StructurePoolElement>): void;
    }
    type StructurePoolAccessor_ = StructurePoolAccessor;
    class CandleCakeBlock extends Internal.AbstractCandleBlock {
        constructor(arg0: Internal.Block_, arg1: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        static byCandle(arg0: Internal.Block_): Internal.BlockState;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static canLight(arg0: Internal.BlockState_): boolean;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly LIT: Internal.BooleanProperty;
    }
    type CandleCakeBlock_ = CandleCakeBlock;
    interface DSL$TypeReference {
        "in"(arg0: Internal.Schema_): Internal.TypeTemplate;
        typeName(): string;
    }
    type DSL$TypeReference_ = DSL$TypeReference;
    interface CoordinateConsumer {
        consume(arg0: number, arg1: number, arg2: number): void;
        (arg0: number, arg1: number, arg2: number): void;
    }
    type CoordinateConsumer_ = CoordinateConsumer;
    interface DescriptionContext {
        typeName(type: typeof any): string;
        javaType(type: typeof any): Internal.TypeDescJS;
        readonly DEFAULT: Internal.DescriptionContext;
        readonly DISPLAY: Internal.DescriptionContext;
    }
    type DescriptionContext_ = DescriptionContext;
    class RenderGuiListBackgroundEvent$Pre extends Internal.RenderGuiListBackgroundEvent {
        constructor()
        constructor(arg0: Internal.PoseStack_, arg1: Internal.AbstractSelectionList_<any>)
    }
    type RenderGuiListBackgroundEvent$Pre_ = RenderGuiListBackgroundEvent$Pre;
    class PlayerSocialManager {
        constructor(arg0: Internal.Minecraft_, arg1: Internal.UserApiService_)
        isBlocked(arg0: Internal.UUID_): boolean;
        isHidden(arg0: Internal.UUID_): boolean;
        shouldHideMessageFrom(arg0: Internal.UUID_): boolean;
        getDiscoveredUUID(arg0: string): Internal.UUID;
        getHiddenPlayers(): Internal.Set<Internal.UUID>;
        hidePlayer(arg0: Internal.UUID_): void;
        addPlayer(arg0: Internal.PlayerInfo_): void;
        handler$zpj000$addPlayer(info: Internal.PlayerInfo_, ci: Internal.CallbackInfo_): void;
        startOnlineMode(): void;
        removePlayer(arg0: Internal.UUID_): void;
        stopOnlineMode(): void;
        handler$zpj000$removePlayer(id: Internal.UUID_, ci: Internal.CallbackInfo_): void;
        showPlayer(arg0: Internal.UUID_): void;
        get hiddenPlayers(): Internal.Set<Internal.UUID>
    }
    type PlayerSocialManager_ = PlayerSocialManager;
    /**
     * Invoked when a network packet is received.
     * 
     * Note that the behaviour of this event is depending on the **script type**.
     * 
     * In `server_scripts`, this event is invoked on the server side when a packet is received from a client.
     * 
     * In `client_scripts`, this event is invoked on the client side when a packet is received from the server.
    */
    class NetworkEventJS extends Internal.PlayerEventJS {
        constructor(p: Internal.Player_, c: string, d: Internal.CompoundTag_)
        /**
         * The channel of the packet.
        */
        getChannel(): string;
        /**
         * The player that sent the packet. Always `Minecraft.player` in `client_scripts`.
        */
        getEntity(): Internal.LivingEntity;
        /**
         * The data of the packet.
        */
        getData(): Internal.CompoundTag;
        /**
         * The channel of the packet.
        */
        get channel(): string
        /**
         * The player that sent the packet. Always `Minecraft.player` in `client_scripts`.
        */
        get entity(): Internal.LivingEntity
        /**
         * The data of the packet.
        */
        get data(): Internal.CompoundTag
    }
    type NetworkEventJS_ = NetworkEventJS;
    class RegistryEvent <T> extends Internal.GenericEvent<T> implements Internal.IModBusEvent {
        constructor()
    }
    type RegistryEvent_<T> = RegistryEvent<T>;
    class CommandBuildContext$MissingTagAccessPolicy extends Internal.Enum<Internal.CommandBuildContext$MissingTagAccessPolicy> {
        static valueOf(arg0: string): Internal.CommandBuildContext$MissingTagAccessPolicy;
        static values(): Internal.CommandBuildContext$MissingTagAccessPolicy[];
        static readonly CREATE_NEW: Internal.CommandBuildContext$MissingTagAccessPolicy;
        static readonly FAIL: Internal.CommandBuildContext$MissingTagAccessPolicy;
        static readonly RETURN_EMPTY: Internal.CommandBuildContext$MissingTagAccessPolicy;
    }
    type CommandBuildContext$MissingTagAccessPolicy_ = CommandBuildContext$MissingTagAccessPolicy | "create_new" | "return_empty" | "fail";
    class MapCodec$MapCodecCodec <A> implements Internal.Codec<A> {
        constructor(arg0: Internal.MapCodec_<A>)
        optionalFieldOf(arg0: string, arg1: A): Internal.MapCodec<A>;
        static empty<A>(): Internal.MapEncoder<A>;
        fieldOf(arg0: string): Internal.MapCodec<A>;
        static error<A>(arg0: string): Internal.Encoder<A>;
        static unit<A>(arg0: Internal.Supplier_<A>): Internal.Codec<A>;
        parse<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<A>;
        promotePartial(arg0: Internal.Consumer_<string>): Internal.Codec<A>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<A>>): Internal.Encoder<B>;
        simple(): Internal.Decoder$Simple<A>;
        stable(): Internal.Codec<A>;
        static floatRange(arg0: number, arg1: number): Internal.Codec<number>;
        static ofBoxed<A>(arg0: Internal.Decoder$Boxed_<A>): Internal.Decoder<A>;
        partialDispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.DataResult<A>>, arg2: Internal.Function_<A, Internal.DataResult<Internal.Codec<E>>>): Internal.Codec<E>;
        dispatch<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        withLifecycle(arg0: Internal.Lifecycle_): Internal.Encoder<any>;
        comap<B>(arg0: Internal.Function_<B, A>): Internal.Encoder<B>;
        dispatchMap<E>(arg0: string, arg1: Internal.Function_<E, A>, arg2: Internal.Function_<A, Internal.Codec<E>>): Internal.MapCodec<E>;
        static intRange(arg0: number, arg1: number): Internal.Codec<number>;
        static unit<A>(arg0: A): Internal.Codec<A>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<A>): Internal.Codec<A>;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: A): Internal.Codec<A>;
        static pair<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<com.mojang.datafixers.util.Pair<F, S>>;
        static either<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<Internal.Either<F, S>>;
        static checkRange<N extends number & Internal.Comparable<N>>(arg0: N, arg1: N): Internal.Function<N, Internal.DataResult<N>>;
        optionalFieldOf(arg0: string): Internal.MapCodec<Internal.Optional<A>>;
        static unboundedMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.UnboundedMapCodec<K, V>;
        dispatchStable<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        optionalFieldOf(arg0: string, arg1: Internal.Lifecycle_, arg2: A, arg3: Internal.Lifecycle_): Internal.MapCodec<A>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>, arg2: string): Internal.Codec<A>;
        parse<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<A>;
        static ofSimple<A>(arg0: Internal.Decoder$Simple_<A>): Internal.Decoder<A>;
        static mapEither<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<Internal.Either<F, S>>;
        static doubleRange(arg0: number, arg1: number): Internal.Codec<number>;
        static optionalField<F>(arg0: string, arg1: Internal.Codec_<F>): Internal.MapCodec<Internal.Optional<F>>;
        static simpleMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>, arg2: Internal.Keyable_): Internal.SimpleMapCodec<K, V>;
        orElseGet(arg0: Internal.Supplier_<A>): Internal.Codec<A>;
        static ofTerminal<A>(arg0: Internal.Decoder$Terminal_<A>): Internal.Decoder<A>;
        map<B>(arg0: Internal.Function_<A, B>): Internal.Decoder<B>;
        deprecated(arg0: number): Internal.Codec<A>;
        orElse(arg0: A): Internal.Codec<A>;
        codec(): Internal.MapCodec<A>;
        static list<E>(arg0: Internal.Codec_<E>): Internal.Codec<Internal.List<E>>;
        dispatchMap<E>(arg0: Internal.Function_<E, A>, arg1: Internal.Function_<A, Internal.Codec<E>>): Internal.MapCodec<E>;
        flatMap<B>(arg0: Internal.Function_<A, Internal.DataResult<B>>): Internal.Decoder<B>;
        boxed(): Internal.Decoder$Boxed<A>;
        xmap<S>(arg0: Internal.Function_<A, S>, arg1: Internal.Function_<S, A>): Internal.Codec<S>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>): Internal.MapCodec<A>;
        dispatch<E>(arg0: string, arg1: Internal.Function_<E, A>, arg2: Internal.Function_<A, Internal.Codec<E>>): Internal.Codec<E>;
        comapFlatMap<S>(arg0: Internal.Function_<A, Internal.DataResult<S>>, arg1: Internal.Function_<S, A>): Internal.Codec<S>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>): Internal.Codec<A>;
        optionalFieldOf(arg0: string, arg1: A, arg2: Internal.Lifecycle_): Internal.MapCodec<A>;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<A>): Internal.Codec<A>;
        terminal(): Internal.Decoder$Terminal<A>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        static compoundList<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.Codec<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>, arg2: Internal.Supplier_<string>): Internal.MapCodec<A>;
        orElse(arg0: Internal.Consumer_<string>, arg1: A): Internal.Codec<A>;
        listOf(): Internal.Codec<Internal.List<A>>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: A): Internal.DataResult<T>;
        flatXmap<S>(arg0: Internal.Function_<A, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.DataResult<A>>): Internal.Codec<S>;
        decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        flatComapMap<S>(arg0: Internal.Function_<A, S>, arg1: Internal.Function_<S, Internal.DataResult<A>>): Internal.Codec<S>;
        mapResult(arg0: Internal.Codec$ResultFunction_<A>): Internal.Codec<A>;
        static mapPair<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<com.mojang.datafixers.util.Pair<F, S>>;
        encode<T>(arg0: A, arg1: Internal.DynamicOps_<T>, arg2: T): Internal.DataResult<T>;
    }
    type MapCodec$MapCodecCodec_<A> = Special.BiomeSource | Special.ChunkGenerator | Special.GlobalLootModifierSerializers | Special.MaterialCondition | Special.MaterialRule | MapCodec$MapCodecCodec<A> | Special.DensityFunctionType;
    interface StateDefinition$Factory <O, S> {
        create(arg0: O, arg1: Internal.ImmutableMap_<Internal.Property<any>, Internal.Comparable<any>>, arg2: Internal.MapCodec_<S>): S;
    }
    type StateDefinition$Factory_<O, S> = StateDefinition$Factory<O, S>;
    interface Matrix3fc {
        lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Internal.Matrix3f_): Internal.Matrix3f;
        rotateY(arg0: number, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        m00(): number;
        getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        getNormalizedRotation(arg0: Internal.Quaternionf_): Internal.Quaternionf;
        get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
        scale(arg0: Internal.Vector3fc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        rotate(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        reflect(arg0: Internal.Vector3fc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        m21(): number;
        transform(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        m02(): number;
        rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix3f_): Internal.Matrix3f;
        get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        isFinite(): boolean;
        transformTranspose(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix3f_): Internal.Matrix3f;
        mul(arg0: Internal.Matrix3fc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        reflect(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix3f_): Internal.Matrix3f;
        m12(): number;
        get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        m10(): number;
        get(arg0: number[]): number[];
        normalizedPositiveZ(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        positiveX(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        quadraticFormProduct(arg0: Internal.Vector3fc_): number;
        normalizedPositiveX(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        positiveZ(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        invert(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        getColumn(arg0: number, arg1: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        get(arg0: number[], arg1: number): number[];
        get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        scale(arg0: number, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        getRowColumn(arg0: number, arg1: number): number;
        get(arg0: number, arg1: number): number;
        get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        rotateLocalX(arg0: number, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        determinant(): number;
        rotateLocalZ(arg0: number, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        scale(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix3f_): Internal.Matrix3f;
        obliqueZ(arg0: number, arg1: number, arg2: Internal.Matrix3f_): Internal.Matrix3f;
        scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix3f_): Internal.Matrix3f;
        m01(): number;
        rotateX(arg0: number, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix3f_): Internal.Matrix3f;
        getUnnormalizedRotation(arg0: Internal.Quaternionf_): Internal.Quaternionf;
        mulLocal(arg0: Internal.Matrix3fc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        add(arg0: Internal.Matrix3fc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix3f_): Internal.Matrix3f;
        m20(): number;
        m22(): number;
        get(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        rotateZ(arg0: number, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
        rotate(arg0: Internal.AxisAngle4f_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        getEulerAnglesZYX(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        transpose(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        rotateLocal(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        transform(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        m11(): number;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix3f_): Internal.Matrix3f;
        normal(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        getRow(arg0: number, arg1: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        sub(arg0: Internal.Matrix3fc_, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        positiveY(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        normalizedPositiveY(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        get(arg0: Internal.Matrix4f_): Internal.Matrix4f;
        rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Internal.Matrix3f_): Internal.Matrix3f;
        cofactor(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        transform(arg0: Internal.Vector3fc_, arg1: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix3f_): Internal.Matrix3f;
        transformTranspose(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        getScale(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        rotateLocalY(arg0: number, arg1: Internal.Matrix3f_): Internal.Matrix3f;
        transformTranspose(arg0: Internal.Vector3fc_, arg1: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix3f_): Internal.Matrix3f;
        lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix3f_): Internal.Matrix3f;
        rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix3f_): Internal.Matrix3f;
        get finite(): boolean
    }
    type Matrix3fc_ = Matrix3fc;
    class SnowballItem extends Internal.Item {
        constructor(arg0: Internal.Item$Properties_)
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        setDigSpeed(speed: number): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onUsingTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Internal.Vector3f;
        setAttackSpeed(attackSpeed: number): void;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        getCreativeTabs(): Internal.Collection<Internal.CreativeModeTab>;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: Internal.Component_): Internal.Component;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        getDamage(arg0: Internal.ItemStack_): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        setArmorToughness(armorToughness: number): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasPlacementBehavior(): boolean;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTabs(): Internal.Collection<Internal.CreativeModeTab>
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type SnowballItem_ = SnowballItem;
    class ServerScoreboard$Method extends Internal.Enum<Internal.ServerScoreboard$Method> {
        static valueOf(arg0: string): Internal.ServerScoreboard$Method;
        static values(): Internal.ServerScoreboard$Method[];
        static readonly REMOVE: Internal.ServerScoreboard$Method;
        static readonly CHANGE: Internal.ServerScoreboard$Method;
    }
    type ServerScoreboard$Method_ = "remove" | "change" | ServerScoreboard$Method;
    interface CriterionTriggerInstance {
        serializeToJson(arg0: Internal.SerializationContext_): Internal.JsonObject;
        getCriterion(): ResourceLocation;
        get criterion(): ResourceLocation
    }
    type CriterionTriggerInstance_ = CriterionTriggerInstance;
    class Fox$Type extends Internal.Enum<Internal.Fox$Type> {
        static byId(arg0: number): Internal.Fox$Type;
        static byName(arg0: string): Internal.Fox$Type;
        static byBiome(arg0: Internal.Holder_<Internal.Biome>): Internal.Fox$Type;
        static values(): Internal.Fox$Type[];
        getName(): string;
        static valueOf(arg0: string): Internal.Fox$Type;
        getId(): number;
        get name(): string
        get id(): number
        static readonly RED: Internal.Fox$Type;
        static readonly SNOW: Internal.Fox$Type;
    }
    type Fox$Type_ = "snow" | Fox$Type | "red";
    interface AccessorBlockColors {
        quark$getBlockColors(): Internal.Map<Internal.Holder$Reference<Internal.Block>, Internal.BlockColor>;
    }
    type AccessorBlockColors_ = AccessorBlockColors;
    interface FloatPredicate extends Internal.DoublePredicate, Internal.Predicate<number> {
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        /**
         * @deprecated
        */
        or(arg0: Internal.Predicate_<number>): Internal.Predicate<number>;
        /**
         * @deprecated
        */
        test(arg0: number): boolean;
        negate(): Internal.Predicate<any>;
        /**
         * @deprecated
        */
        and(arg0: Internal.Predicate_<number>): Internal.Predicate<number>;
        and(arg0: Internal.FloatPredicate_): this;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
        and(arg0: Internal.DoublePredicate_): this;
        /**
         * @deprecated
        */
        test(arg0: any): boolean;
        or(arg0: Internal.DoublePredicate_): this;
        test(arg0: number): boolean;
        or(arg0: Internal.FloatPredicate_): this;
        (arg0: number): boolean;
    }
    type FloatPredicate_ = FloatPredicate;
    interface RecipeManager$CachedCheck <C extends Internal.Container, T extends Internal.Recipe<C>> {
        getRecipeFor(arg0: C, arg1: Internal.Level_): Internal.Optional<T>;
    }
    type RecipeManager$CachedCheck_<C extends Internal.Container, T extends Internal.Recipe<C>> = RecipeManager$CachedCheck<C, T>;
    class CompostableRecipesEventJS extends Internal.EventJS {
        constructor()
        removeAll(): void;
        add(ingredient: Internal.Ingredient_, f: number): void;
        remove(ingredient: Internal.Ingredient_): void;
        static originalMap: Internal.Object2FloatMap<Internal.ItemLike>;
    }
    type CompostableRecipesEventJS_ = CompostableRecipesEventJS;
    class ModuleDescriptor$Exports implements Internal.Comparable<Internal.ModuleDescriptor$Exports> {
        isQualified(): boolean;
        targets(): Internal.Set<string>;
        source(): string;
        compareTo(arg0: Internal.ModuleDescriptor$Exports_): number;
        modifiers(): Internal.Set<Internal.ModuleDescriptor$Exports$Modifier>;
        compareTo(arg0: any): number;
        get qualified(): boolean
    }
    type ModuleDescriptor$Exports_ = ModuleDescriptor$Exports;
    class BowItem extends Internal.ProjectileWeaponItem implements Internal.Vanishable {
        constructor(arg0: Internal.Item$Properties_)
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        setDigSpeed(speed: number): void;
        static getPowerForTime(arg0: number): number;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onUsingTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        handler$dhe000$dd(arg0: Internal.Item$Properties_, arg1: Internal.CallbackInfo_): void;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Internal.Vector3f;
        setAttackSpeed(attackSpeed: number): void;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        getCreativeTabs(): Internal.Collection<Internal.CreativeModeTab>;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: Internal.Component_): Internal.Component;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        getDamage(arg0: Internal.ItemStack_): number;
        redirect$dhe000$releaseUsing_redirect1(arg0: number, arg1: Internal.ItemStack_, arg2: Internal.Level_, arg3: Internal.LivingEntity_, arg4: number): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        setArmorToughness(armorToughness: number): void;
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<any, any>;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        handler$eco000$onStoppedUsing(stack: Internal.ItemStack_, level: Internal.Level_, livingEntity: Internal.LivingEntity_, remainingUseTicks: number, cbi: Internal.CallbackInfo_, player: Internal.Player_, bl: boolean, itemStack2: Internal.ItemStack_, j: number, f: number, bl2: boolean, arrowItem: Internal.ArrowItem_, abstractArrow: Internal.AbstractArrow_): void;
        hasPlacementBehavior(): boolean;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        handler$zmm000$getAllSupportedProjectiles(cir: Internal.CallbackInfoReturnable_<any>): void;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        redirect$dhe000$releaseUsing_redirect2(arg0: Internal.AbstractArrow_, arg1: Internal.Entity_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        customArrow(arg0: Internal.AbstractArrow_): Internal.AbstractArrow;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTabs(): Internal.Collection<Internal.CreativeModeTab>
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        static readonly MAX_DRAW_DURATION: 20;
        static readonly DEFAULT_RANGE: 15;
    }
    type BowItem_ = BowItem;
    class UnitContext {
        constructor()
        pushDebug(): void;
        debugInfo(s: string, values: Internal.Collection_<any>): void;
        sub(): this;
        popDebug(): void;
        addConstant(s: string, u: Internal.Unit_): void;
        parse(input: string): Internal.Unit;
        getFunctionFactory(name: string): Internal.FunctionFactory;
        debugInfo(s: string): void;
        createStream(input: string): Internal.UnitTokenStream;
        addFunction(factory: Internal.FunctionFactory_): void;
        isDebug(): boolean;
        get debug(): boolean
        static readonly DEFAULT: Internal.UnitContext;
        readonly constants: Internal.Map<string, Internal.Unit>;
    }
    type UnitContext_ = UnitContext;
    class Llama extends Internal.AbstractChestedHorse implements Internal.RangedAttackMob {
        constructor(arg0: Internal.EntityType_<Internal.Llama>, arg1: Internal.Level_)
        isAlwaysBaby(): boolean;
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setVariant(arg0: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        equipped(arg0: Internal.ItemEntity_): boolean;
        swing(): void;
        isTraderLlama(): boolean;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        static setStunted(entity: Internal.AgeableMob_, stunted: boolean): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getControllingPassenger(): Internal.Entity;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        static isBlocked(entity: Internal.Entity_): boolean;
        getCaravanHead(): this;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        getStrength(): number;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        getVariant(): number;
        leaveCaravan(): void;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        inCaravan(): boolean;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        getSwag(): Internal.DyeColor;
        performRangedAttack(arg0: Internal.LivingEntity_, arg1: number): void;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        joinCaravan(arg0: Internal.Llama_): void;
        hasCaravanTail(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        get alwaysBaby(): boolean
        set variant(arg0: number)
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get traderLlama(): boolean
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get controllingPassenger(): Internal.Entity
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get caravanHead(): Internal.Llama
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get strength(): number
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get variant(): number
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get swag(): Internal.DyeColor
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Llama_ = Llama;
    class IndexedMessageCodec$MessageHandler <MSG> {
        constructor(arg0: any_, arg1: number, arg2: typeof any, arg3: Internal.BiConsumer_<any, any>, arg4: Internal.Function_<any, any>, arg5: Internal.BiConsumer_<any, any>, arg6: Internal.Optional_<any>)
        getLoginIndexGetter(): Internal.Optional<Internal.Function<MSG, number>>;
        get loginIndexGetter(): Internal.Optional<Internal.Function<MSG, number>>
    }
    type IndexedMessageCodec$MessageHandler_<MSG> = IndexedMessageCodec$MessageHandler<MSG>;
    class JigsawBlock extends Internal.Block implements Internal.GameMasterBlock, Internal.EntityBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getTopFacing(arg0: Internal.BlockState_): Internal.Direction;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static canAttach(arg0: Internal.StructureTemplate$StructureBlockInfo_, arg1: Internal.StructureTemplate$StructureBlockInfo_): boolean;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        static getFrontFacing(arg0: Internal.BlockState_): Internal.Direction;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    }
    type JigsawBlock_ = JigsawBlock;
    interface TransformStack extends Internal.TStack<Internal.TransformStack>, Internal.Transform<Internal.TransformStack> {
        translateBack(arg0: Vec3i_): this;
        cast(arg0: Internal.PoseStack_): this;
        multiply(arg0: Internal.Quaternion_): this;
        translate(arg0: Vec3i_): this;
        rotateZRadians(arg0: number): this;
        mulNormal(arg0: com.mojang.math.Matrix3f_): this;
        translateAll(arg0: number): this;
        popPose(): this;
        translateBack(arg0: Vec3_): this;
        nudge(arg0: number): this;
        translate(arg0: number, arg1: number, arg2: number): this;
        scale(arg0: number): this;
        transform(arg0: Internal.PoseStack_): this;
        rotate(arg0: Internal.Direction_, arg1: number): this;
        multiplyRadians(arg0: Internal.Vector3f_, arg1: number): this;
        multiply(arg0: Internal.Vector3f_, arg1: number): this;
        scale(arg0: number, arg1: number, arg2: number): this;
        pushPose(): this;
        rotateCentered(arg0: Internal.Quaternion_): this;
        unCentre(): this;
        rotateYRadians(arg0: number): this;
        rotateX(arg0: number): this;
        rotateY(arg0: number): this;
        translateX(arg0: number): this;
        translateZ(arg0: number): this;
        translateY(arg0: number): this;
        rotateCentered(arg0: Internal.Direction_, arg1: number): this;
        rotateZ(arg0: number): this;
        centre(): this;
        rotateToFace(arg0: Internal.Direction_): this;
        mulPose(arg0: com.mojang.math.Matrix4f_): this;
        rotate(arg0: number, arg1: Internal.Direction$Axis_): this;
        transform(arg0: com.mojang.math.Matrix4f_, arg1: com.mojang.math.Matrix3f_): this;
        rotateXRadians(arg0: number): this;
        translate(arg0: Vec3_): this;
        translate(arg0: Internal.Vector3f_): this;
        translateBack(arg0: number, arg1: number, arg2: number): this;
    }
    type TransformStack_ = TransformStack;
    interface TickingBlockEntity {
        getPos(): BlockPos;
        isRemoved(): boolean;
        getType(): string;
        tick(): void;
        get pos(): BlockPos
        get removed(): boolean
        get type(): string
    }
    type TickingBlockEntity_ = TickingBlockEntity;
    interface TemplateAccessor {
        integrated_api_getPalettes(): Internal.List<Internal.StructureTemplate$Palette>;
    }
    type TemplateAccessor_ = TemplateAccessor;
    abstract class RenderTooltipEvent extends Internal.Event {
        constructor()
        getFont(): Internal.Font;
        getPoseStack(): Internal.PoseStack;
        getX(): number;
        getY(): number;
        getComponents(): Internal.List<Internal.ClientTooltipComponent>;
        getItemStack(): Internal.ItemStack;
        get font(): Internal.Font
        get poseStack(): Internal.PoseStack
        get x(): number
        get y(): number
        get components(): Internal.List<Internal.ClientTooltipComponent>
        get itemStack(): Internal.ItemStack
    }
    type RenderTooltipEvent_ = RenderTooltipEvent;
    interface PseudoAccessorItemStack {
        quark$getCapturedAttributes(): Internal.Map<Internal.AttributeSlot, Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>>;
        quark$capturePotionAttributes(arg0: Internal.List_<com.mojang.datafixers.util.Pair<Internal.Attribute, Internal.AttributeModifier>>): void;
    }
    type PseudoAccessorItemStack_ = PseudoAccessorItemStack;
    interface SurfaceRules$ConditionSource extends Internal.Function<Internal.SurfaceRules$Context, Internal.SurfaceRules$Condition> {
        andThen<V>(arg0: Internal.Function_<Internal.SurfaceRules$Condition, V>): Internal.Function<Internal.SurfaceRules$Context, V>;
        bootstrap(arg0: Internal.Registry_<Internal.Codec<Internal.SurfaceRules$ConditionSource>>): Internal.Codec<Internal.SurfaceRules$ConditionSource>;
        identity<T>(): Internal.Function<T, T>;
        codec(): Internal.KeyDispatchDataCodec<Internal.SurfaceRules$ConditionSource>;
        apply(arg0: Internal.SurfaceRules$Context_): Internal.SurfaceRules$Condition;
        compose<V>(arg0: Internal.Function_<V, Internal.SurfaceRules$Context>): Internal.Function<V, Internal.SurfaceRules$Condition>;
        readonly CODEC: Internal.Codec<Internal.SurfaceRules$ConditionSource>;
    }
    type SurfaceRules$ConditionSource_ = SurfaceRules$ConditionSource;
    abstract class GuiSettings extends Internal.ScreenBase {
        constructor(arg0: Internal.Component_, arg1: Internal.Screen_, arg2: Internal.Screen_)
        getEntriesCopy(): any[];
        getIndex(arg0: Internal.GuiEventListener_): number;
        magicalSpecialHackyFocus(arg0: Internal.GuiEventListener_): void;
        setInitialFocus(arg0: Internal.GuiEventListener_): void;
        m_7856_(): void;
        mouseDragged(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): boolean;
        changeFocus(arg0: boolean): boolean;
        getChildAt(arg0: number, arg1: number): Internal.Optional<Internal.GuiEventListener>;
        keyReleased(arg0: number, arg1: number, arg2: number): boolean;
        mouseMoved(arg0: number, arg1: number): void;
        restoreFocus(arg0: number): void;
        get entriesCopy(): any[]
        set initialFocus(arg0: Internal.GuiEventListener_)
    }
    type GuiSettings_ = GuiSettings;
    class DisplayInfo implements Internal.DisplayInfoFTBL {
        constructor(arg0: Internal.ItemStack_, arg1: Internal.Component_, arg2: Internal.Component_, arg3: ResourceLocation_, arg4: Internal.FrameType_, arg5: boolean, arg6: boolean, arg7: boolean)
        setLocation(arg0: number, arg1: number): void;
        serializeToJson(): Internal.JsonElement;
        getX(): number;
        getY(): number;
        static fromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.DisplayInfo;
        isHidden(): boolean;
        getIcon(): Internal.ItemStack;
        getIconStackFTBL(): Internal.ItemStack;
        shouldShowToast(): boolean;
        getBackground(): ResourceLocation;
        getTitle(): Internal.Component;
        getFrame(): Internal.FrameType;
        shouldAnnounceChat(): boolean;
        static fromJson(arg0: Internal.JsonObject_): Internal.DisplayInfo;
        getDescription(): Internal.Component;
        serializeToNetwork(arg0: Internal.FriendlyByteBuf_): void;
        get x(): number
        get y(): number
        get hidden(): boolean
        get icon(): Internal.ItemStack
        get iconStackFTBL(): Internal.ItemStack
        get background(): ResourceLocation
        get title(): Internal.Component
        get frame(): Internal.FrameType
        get description(): Internal.Component
    }
    type DisplayInfo_ = DisplayInfo;
    interface Pointer {
        address(): number;
        readonly CLONG_SIZE: 4;
        readonly POINTER_SHIFT: 3;
        readonly CLONG_SHIFT: 2;
        readonly BITS64: true;
        readonly BITS32: false;
        readonly POINTER_SIZE: 8;
    }
    type Pointer_ = Pointer;
    class GunFireEvent extends Internal.PlayerEvent {
        constructor(arg0: Internal.Player_, arg1: Internal.ItemStack_)
        constructor()
        isClient(): boolean;
        getStack(): Internal.ItemStack;
        getEntity(): Internal.LivingEntity;
        get client(): boolean
        get stack(): Internal.ItemStack
        get entity(): Internal.LivingEntity
    }
    type GunFireEvent_ = GunFireEvent;
    class OctahedralGroup extends Internal.Enum<Internal.OctahedralGroup> implements Internal.StringRepresentable {
        rotate(arg0: Internal.Direction_): Internal.Direction;
        inverse(): this;
        static valueOf(arg0: string): Internal.OctahedralGroup;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        inverts(arg0: Internal.Direction$Axis_): boolean;
        getSerializedName(): string;
        static values(): Internal.OctahedralGroup[];
        rotate(arg0: Internal.FrontAndTop_): Internal.FrontAndTop;
        transformation(): com.mojang.math.Matrix3f;
        compose(arg0: Internal.OctahedralGroup_): this;
        get serializedName(): string
        static readonly ROT_180_EDGE_XY_NEG: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_YZ_POS: Internal.OctahedralGroup;
        static readonly SWAP_XZ: Internal.OctahedralGroup;
        static readonly ROT_90_REF_Y_NEG: Internal.OctahedralGroup;
        static readonly INVERT_Z: Internal.OctahedralGroup;
        static readonly SWAP_YZ: Internal.OctahedralGroup;
        static readonly INVERT_X: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_XY_POS: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_YZ_NEG: Internal.OctahedralGroup;
        static readonly ROT_90_Z_POS: Internal.OctahedralGroup;
        static readonly SWAP_NEG_YZ: Internal.OctahedralGroup;
        static readonly ROT_180_FACE_XY: Internal.OctahedralGroup;
        static readonly SWAP_NEG_XZ: Internal.OctahedralGroup;
        static readonly ROT_90_Z_NEG: Internal.OctahedralGroup;
        static readonly ROT_60_REF_PNN: Internal.OctahedralGroup;
        static readonly ROT_60_REF_PPP: Internal.OctahedralGroup;
        static readonly ROT_60_REF_PNP: Internal.OctahedralGroup;
        static readonly ROT_60_REF_NNP: Internal.OctahedralGroup;
        static readonly ROT_60_REF_NNN: Internal.OctahedralGroup;
        static readonly ROT_60_REF_NPP: Internal.OctahedralGroup;
        static readonly ROT_60_REF_PPN: Internal.OctahedralGroup;
        static readonly ROT_90_REF_Y_POS: Internal.OctahedralGroup;
        static readonly ROT_60_REF_NPN: Internal.OctahedralGroup;
        static readonly ROT_90_X_NEG: Internal.OctahedralGroup;
        static readonly ROT_120_PNP: Internal.OctahedralGroup;
        static readonly INVERT_Y: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_XZ_POS: Internal.OctahedralGroup;
        static readonly SWAP_XY: Internal.OctahedralGroup;
        static readonly ROT_120_NPN: Internal.OctahedralGroup;
        static readonly ROT_90_REF_Z_POS: Internal.OctahedralGroup;
        static readonly ROT_120_NNP: Internal.OctahedralGroup;
        static readonly ROT_90_REF_X_POS: Internal.OctahedralGroup;
        static readonly ROT_120_PPN: Internal.OctahedralGroup;
        static readonly ROT_120_NNN: Internal.OctahedralGroup;
        static readonly ROT_120_NPP: Internal.OctahedralGroup;
        static readonly ROT_90_X_POS: Internal.OctahedralGroup;
        static readonly ROT_120_PNN: Internal.OctahedralGroup;
        static readonly ROT_120_PPP: Internal.OctahedralGroup;
        static readonly ROT_90_REF_X_NEG: Internal.OctahedralGroup;
        static readonly IDENTITY: Internal.OctahedralGroup;
        static readonly SWAP_NEG_XY: Internal.OctahedralGroup;
        static readonly ROT_180_FACE_YZ: Internal.OctahedralGroup;
        static readonly ROT_180_FACE_XZ: Internal.OctahedralGroup;
        static readonly ROT_180_EDGE_XZ_NEG: Internal.OctahedralGroup;
        static readonly ROT_90_REF_Z_NEG: Internal.OctahedralGroup;
        static readonly ROT_90_Y_NEG: Internal.OctahedralGroup;
        static readonly ROT_90_Y_POS: Internal.OctahedralGroup;
        static readonly INVERSION: Internal.OctahedralGroup;
    }
    type OctahedralGroup_ = "inversion" | "rot_180_face_xz" | "invert_z" | "rot_180_edge_xy_pos" | "rot_120_pnp" | "rot_120_ppp" | "rot_120_nnn" | "rot_120_npn" | "rot_90_ref_z_neg" | "rot_180_edge_xz_pos" | "swap_xy" | "rot_90_x_neg" | "swap_neg_yz" | "identity" | "rot_90_z_neg" | "rot_90_ref_z_pos" | "rot_60_ref_ppn" | "rot_60_ref_npp" | "rot_60_ref_pnn" | "rot_60_ref_nnp" | "rot_180_edge_yz_pos" | "swap_yz" | "rot_90_y_pos" | "rot_90_ref_y_neg" | "rot_90_ref_y_pos" | "rot_90_x_pos" | "rot_180_face_yz" | "rot_180_edge_xy_neg" | "rot_120_nnp" | "rot_120_pnn" | "rot_120_npp" | "rot_120_ppn" | "swap_neg_xz" | "rot_90_ref_x_pos" | "invert_x" | OctahedralGroup | "rot_180_edge_xz_neg" | "rot_90_ref_x_neg" | "rot_180_face_xy" | "rot_90_z_pos" | "rot_60_ref_nnn" | "rot_60_ref_ppp" | "rot_90_y_neg" | "rot_180_edge_yz_neg" | "swap_xz" | "rot_60_ref_npn" | "invert_y" | "rot_60_ref_pnp" | "swap_neg_xy";
    class FloatTag extends Internal.NumericTag {
        getAsString(): string;
        acceptAsRoot(arg0: Internal.StreamTagVisitor_): void;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        getType(): Internal.TagType<Internal.FloatTag>;
        static valueOf(arg0: number): Internal.FloatTag;
        get asString(): string
        get type(): Internal.TagType<Internal.FloatTag>
        static readonly TYPE: Internal.TagType<Internal.FloatTag>;
        static readonly ZERO: Internal.FloatTag;
    }
    type FloatTag_ = FloatTag;
    class Program {
        constructor(arg0: Internal.Program$Type_, arg1: number, arg2: string)
        attachToShader(arg0: Internal.Shader_): void;
        static compileShader(arg0: Internal.Program$Type_, arg1: string, arg2: Internal.InputStream_, arg3: string, arg4: Internal.GlslPreprocessor_): Internal.Program;
        getName(): string;
        close(): void;
        getId(): number;
        get name(): string
        get id(): number
    }
    type Program_ = Program;
    abstract class AbstractStringBuilder implements Internal.CharSequence, Internal.Appendable {
        reverse(): this;
        append(arg0: string): this;
        codePointAt(arg0: number): number;
        insert(arg0: number, arg1: string): this;
        append(arg0: number): this;
        append(arg0: boolean): this;
        append(arg0: number): this;
        lastIndexOf(arg0: string): number;
        insert(arg0: number, arg1: number): this;
        getChars(arg0: number, arg1: number, arg2: string[], arg3: number): void;
        indexOf(arg0: string): number;
        append(arg0: number): this;
        lastIndexOf(arg0: string, arg1: number): number;
        insert(arg0: number, arg1: boolean): this;
        charAt(arg0: number): string;
        length(): number;
        replace(arg0: number, arg1: number, arg2: string): this;
        trimToSize(): void;
        insert(arg0: number, arg1: number): this;
        append(arg0: string): this;
        "delete"(arg0: number, arg1: number): this;
        static compare(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_): number;
        indexOf(arg0: string, arg1: number): number;
        chars(): Internal.IntStream;
        ensureCapacity(arg0: number): void;
        insert(arg0: number, arg1: Internal.CharSequence_): this;
        insert(arg0: number, arg1: string): this;
        insert(arg0: number, arg1: any): this;
        append(arg0: number): this;
        capacity(): number;
        append(arg0: string[]): this;
        codePointCount(arg0: number, arg1: number): number;
        substring(arg0: number): string;
        setCharAt(arg0: number, arg1: string): void;
        setLength(arg0: number): void;
        isEmpty(): boolean;
        codePointBefore(arg0: number): number;
        append(arg0: string[], arg1: number, arg2: number): this;
        deleteCharAt(arg0: number): this;
        append(arg0: Internal.StringBuffer_): this;
        subSequence(arg0: number, arg1: number): Internal.CharSequence;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): this;
        appendCodePoint(arg0: number): this;
        substring(arg0: number, arg1: number): string;
        insert(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: Internal.CharSequence_, arg2: number, arg3: number): this;
        insert(arg0: number, arg1: number): this;
        insert(arg0: number, arg1: string[], arg2: number, arg3: number): this;
        offsetByCodePoints(arg0: number, arg1: number): number;
        append(arg0: any): this;
        insert(arg0: number, arg1: string[]): this;
        append(arg0: Internal.CharSequence_): this;
        codePoints(): Internal.IntStream;
        set length(arg0: number)
        get empty(): boolean
    }
    type AbstractStringBuilder_ = AbstractStringBuilder;
    class StageChangeEvent {
        getPlayerStages(): Internal.Stages;
        getPlayer(): Internal.Player;
        getStage(): string;
        get playerStages(): Internal.Stages
        get player(): Internal.Player
        get stage(): string
    }
    type StageChangeEvent_ = StageChangeEvent;
    class WeakReference <T> extends Internal.Reference<T> {
        constructor(arg0: T)
        constructor(arg0: T, arg1: any_<T>)
    }
    type WeakReference_<T> = WeakReference<T>;
    class PlayerEvent$ItemSmeltedEvent extends Internal.PlayerEvent {
        constructor()
        constructor(arg0: Internal.Player_, arg1: Internal.ItemStack_)
        getSmelting(): Internal.ItemStack;
        getEntity(): Internal.LivingEntity;
        get smelting(): Internal.ItemStack
        get entity(): Internal.LivingEntity
    }
    type PlayerEvent$ItemSmeltedEvent_ = PlayerEvent$ItemSmeltedEvent;
    class BlockTintProvider implements Internal.BlockAndTintGetter {
        constructor(arg0: Internal.Registry_<Internal.Biome>, arg1: Internal.BiomeColorCalculator_, arg2: Internal.MapProcessor_, arg3: any_)
        getBlockTint(arg0: BlockPos_, arg1: Internal.ColorResolver_): number;
        getMinSection(): number;
        getShade(arg0: Internal.Direction_, arg1: boolean): number;
        getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride(arg0: Vec3_, arg1: Vec3_, arg2: BlockPos_, arg3: Internal.VoxelShape_, arg4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex(arg0: number): number;
        getMaxSection(): number;
        getBrightness(arg0: Internal.LightLayer_, arg1: BlockPos_): number;
        getMaxBuildHeight(): number;
        getBlockFloorHeight(arg0: BlockPos_): number;
        getLightEmission(arg0: BlockPos_): number;
        getShade(arg0: number, arg1: number, arg2: number, arg3: boolean): number;
        getSectionYFromSectionIndex(arg0: number): number;
        static create(arg0: number, arg1: number): Internal.LevelHeightAccessor;
        clip(arg0: Internal.ClipContext_): Internal.BlockHitResult;
        getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight(arg0: Internal.VoxelShape_, arg1: Internal.Supplier_<Internal.VoxelShape>): number;
        getHeight(): number;
        getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getRawBrightness(arg0: BlockPos_, arg1: number): number;
        getBlockEntity<T extends Internal.BlockEntity>(arg0: BlockPos_, arg1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight(arg0: BlockPos_): boolean;
        getModelDataManager(): Internal.ModelDataManager;
        canSeeSky(arg0: BlockPos_): boolean;
        isOutsideBuildHeight(arg0: number): boolean;
        isBlockInLine(arg0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getFluidState(arg0: BlockPos_): Internal.FluidState;
        getBlockStates(arg0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getExistingBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getMinBuildHeight(): number;
        getSectionsCount(): number;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY(arg0: number): number;
        getBiomeColor(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: boolean, arg3: Internal.MapTile_, arg4: number, arg5: number): number;
        static traverseBlocks<T, C>(arg0: Vec3_, arg1: Vec3_, arg2: C, arg3: Internal.BiFunction_<C, BlockPos, T>, arg4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get lightEngine(): Internal.LevelLightEngine
        get height(): number
        get modelDataManager(): Internal.ModelDataManager
        get minBuildHeight(): number
        get sectionsCount(): number
        get maxLightLevel(): number
    }
    type BlockTintProvider_ = BlockTintProvider;
    interface IMixinEditBox {
        getHightlightPosKonkrete(): number;
        onValueChangeKonkrete(arg0: string): void;
        getIsEditableKonkrete(): boolean;
        getMaxLengthKonkrete(): number;
        get hightlightPosKonkrete(): number
        get isEditableKonkrete(): boolean
        get maxLengthKonkrete(): number
    }
    type IMixinEditBox_ = IMixinEditBox;
    interface ArgumentTypeInfo$Template <A extends Internal.ArgumentType<any>> {
        type(): Internal.ArgumentTypeInfo<A, any>;
        instantiate(arg0: Internal.CommandBuildContext_): A;
    }
    type ArgumentTypeInfo$Template_<A extends Internal.ArgumentType<any>> = ArgumentTypeInfo$Template<A>;
    class SwordItem extends Internal.TieredItem implements Internal.Vanishable, Internal.ModifiableItemKJS {
        constructor(arg0: Internal.Tier_, arg1: number, arg2: number, arg3: Internal.Item$Properties_)
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        setDigSpeed(speed: number): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onUsingTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Internal.Vector3f;
        setAttackSpeed(attackSpeed: number): void;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        getCreativeTabs(): Internal.Collection<Internal.CreativeModeTab>;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: Internal.Component_): Internal.Component;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        getDamage(arg0: Internal.ItemStack_): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        setArmorToughness(armorToughness: number): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasPlacementBehavior(): boolean;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDamage(): number;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        handler$dmk000$hurtItem(stack: Internal.ItemStack_, entity: Internal.LivingEntity_, player: Internal.LivingEntity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTabs(): Internal.Collection<Internal.CreativeModeTab>
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get damage(): number
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        defaultModifiers: Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
    }
    type SwordItem_ = SwordItem;
    class UpgradeData {
        constructor(arg0: Internal.CompoundTag_, arg1: Internal.LevelHeightAccessor_)
        upgrade(arg0: Internal.LevelChunk_): void;
        write(): Internal.CompoundTag;
        isEmpty(): boolean;
        get empty(): boolean
        static readonly EMPTY: Internal.UpgradeData;
    }
    type UpgradeData_ = UpgradeData;
    class EntityLeaveLevelEvent extends Internal.EntityEvent {
        constructor()
        constructor(arg0: Internal.Entity_, arg1: Internal.Level_)
        getLevel(): Internal.Level;
        get level(): Internal.Level
    }
    type EntityLeaveLevelEvent_ = EntityLeaveLevelEvent;
    interface BasicFileAttributes {
        isRegularFile(): boolean;
        creationTime(): Internal.FileTime;
        isSymbolicLink(): boolean;
        isOther(): boolean;
        fileKey(): any;
        isDirectory(): boolean;
        size(): number;
        lastModifiedTime(): Internal.FileTime;
        lastAccessTime(): Internal.FileTime;
        get regularFile(): boolean
        get symbolicLink(): boolean
        get other(): boolean
        get directory(): boolean
    }
    type BasicFileAttributes_ = BasicFileAttributes;
    class StructureMode extends Internal.Enum<Internal.StructureMode> implements Internal.StringRepresentable {
        getDisplayName(): Internal.Component;
        static values(): Internal.StructureMode[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        getSerializedName(): string;
        static valueOf(arg0: string): Internal.StructureMode;
        get displayName(): Internal.Component
        get serializedName(): string
        static readonly SAVE: Internal.StructureMode;
        static readonly CORNER: Internal.StructureMode;
        static readonly LOAD: Internal.StructureMode;
        static readonly DATA: Internal.StructureMode;
    }
    type StructureMode_ = "load" | StructureMode | "save" | "data" | "corner";
    interface Channel$Unsafe {
        localAddress(): Internal.SocketAddress;
        deregister(arg0: Internal.ChannelPromise_): void;
        recvBufAllocHandle(): Internal.RecvByteBufAllocator$Handle;
        closeForcibly(): void;
        close(arg0: Internal.ChannelPromise_): void;
        beginRead(): void;
        outboundBuffer(): Internal.ChannelOutboundBuffer;
        connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): void;
        flush(): void;
        bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): void;
        disconnect(arg0: Internal.ChannelPromise_): void;
        register(arg0: Internal.EventLoop_, arg1: Internal.ChannelPromise_): void;
        write(arg0: any, arg1: Internal.ChannelPromise_): void;
        remoteAddress(): Internal.SocketAddress;
        voidPromise(): Internal.ChannelPromise;
    }
    type Channel$Unsafe_ = Channel$Unsafe;
    interface IPlantable {
        getPlant(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.BlockState;
        getPlantType(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.PlantType;
    }
    type IPlantable_ = IPlantable;
    class RemoveWorldgenEventJS extends Internal.StartupEventJS {
        constructor()
        printFiltered(): void;
        removeSpawns(p: Internal.Consumer_<Internal.RemoveSpawnsProperties>): void;
        removeAllFeatures(filter: Internal.BiomeFilter_): void;
        printSpawns(category: Internal.MobCategory_): void;
        removeAllFeatures(): void;
        removeOres(p: Internal.Consumer_<Internal.RemoveOresProperties>): void;
        printFeatures(type: DecorationGenerationStep_): void;
        removeAllSpawns(): void;
        printSpawns(): void;
        removeFeatureById(filter: Internal.BiomeFilter_, decoration: DecorationGenerationStep_, ids: ResourceLocation_[]): void;
        printFeatures(type: DecorationGenerationStep_, filter: Internal.BiomeFilter_): void;
        printFiltered(type: DecorationGenerationStep_): void;
        printFeaturesForType(type: DecorationGenerationStep_, filter: Internal.BiomeFilter_, afterRemoval: boolean): void;
        removeAllFeatures(filter: Internal.BiomeFilter_, type: DecorationGenerationStep_): void;
        removeFeatureById(type: DecorationGenerationStep_, ids: ResourceLocation_[]): void;
        printFiltered(type: DecorationGenerationStep_, filter: Internal.BiomeFilter_): void;
        printFeatures(): void;
    }
    type RemoveWorldgenEventJS_ = RemoveWorldgenEventJS;
    interface Matrix3dc {
        reflect(arg0: Internal.Vector3dc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        rotateZ(arg0: number, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotate(arg0: Internal.Quaterniondc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotateX(arg0: number, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getRowColumn(arg0: number, arg1: number): number;
        getNormalizedRotation(arg0: Internal.Quaternionf_): Internal.Quaternionf;
        get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        scale(arg0: Internal.Vector3dc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        get(arg0: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        m01(): number;
        isFinite(): boolean;
        m22(): number;
        rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        m20(): number;
        rotate(arg0: Internal.AxisAngle4f_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        mul(arg0: Internal.Matrix3dc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getEulerAnglesZYX(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        rotate(arg0: Internal.AxisAngle4d_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotateLocalY(arg0: number, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        transpose(arg0: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotateLocal(arg0: Internal.Quaternionfc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        get(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        transform(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        normal(arg0: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getRow(arg0: number, arg1: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        positiveY(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        get(arg0: number[]): number[];
        normalizedPositiveY(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        scaleLocal(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        quadraticFormProduct(arg0: Internal.Vector3fc_): number;
        quadraticFormProduct(arg0: Internal.Vector3dc_): number;
        cofactor(arg0: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        m12(): number;
        rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        m10(): number;
        transformTranspose(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        get(arg0: number[], arg1: number): number[];
        rotateTowards(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        getScale(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        reflect(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getUnnormalizedRotation(arg0: Internal.Quaternionf_): Internal.Quaternionf;
        rotateY(arg0: number, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        mulLocal(arg0: Internal.Matrix3dc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        add(arg0: Internal.Matrix3dc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        scale(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        rotateZYX(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        get(arg0: number[], arg1: number): number[];
        rotate(arg0: Internal.Quaternionfc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        m02(): number;
        m00(): number;
        m21(): number;
        scale(arg0: number, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotateLocalZ(arg0: number, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        mul(arg0: Internal.Matrix3fc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotateLocal(arg0: Internal.Quaterniondc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        rotateLocalX(arg0: number, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
        lerp(arg0: Internal.Matrix3dc_, arg1: number, arg2: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        lookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        get(arg0: number[]): number[];
        determinant(): number;
        equals(arg0: Internal.Matrix3dc_, arg1: number): boolean;
        transform(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        reflect(arg0: Internal.Quaterniondc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        obliqueZ(arg0: number, arg1: number, arg2: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        get(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        get(arg0: number, arg1: number): number;
        sub(arg0: Internal.Matrix3dc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        normalizedPositiveZ(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        transformTranspose(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        positiveX(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        normalizedPositiveX(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        positiveZ(arg0: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        mulComponentWise(arg0: Internal.Matrix3dc_, arg1: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        invert(arg0: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        transform(arg0: Internal.Vector3fc_, arg1: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        rotate(arg0: number, arg1: Internal.Vector3dc_, arg2: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        getColumn(arg0: number, arg1: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        transform(arg0: Internal.Vector3dc_, arg1: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        m11(): number;
        transformTranspose(arg0: Internal.Vector3dc_, arg1: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: net.coderbot.iris.vendored.joml.Matrix3d_): net.coderbot.iris.vendored.joml.Matrix3d;
        transform(arg0: number, arg1: number, arg2: number, arg3: net.coderbot.iris.vendored.joml.Vector3d_): net.coderbot.iris.vendored.joml.Vector3d;
        get finite(): boolean
    }
    type Matrix3dc_ = Matrix3dc;
    class HashBiMap <K, V> extends Internal.Maps$IteratorBasedAbstractMap<K, V> implements Internal.BiMap<K, V>, Internal.Serializable {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static create<K, V>(arg0: number): Internal.HashBiMap<K, V>;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        inverse(): Internal.BiMap<V, K>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        putIfAbsent(arg0: K, arg1: V): V;
        entrySet(): Internal.Set<any>;
        static create<K, V>(arg0: Internal.Map_<K, V>): Internal.HashBiMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static create<K, V>(): Internal.HashBiMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        forcePut(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type HashBiMap_<K, V> = HashBiMap<K, V>;
    interface LootItemFunction extends Internal.LootContextUser, Internal.BiFunction<Internal.ItemStack, Internal.LootContext, Internal.ItemStack> {
        decorate(arg0: Internal.BiFunction_<Internal.ItemStack, Internal.LootContext, Internal.ItemStack>, arg1: Internal.Consumer_<Internal.ItemStack>, arg2: Internal.LootContext_): Internal.Consumer<Internal.ItemStack>;
        andThen<V>(arg0: Internal.Function_<Internal.ItemStack, V>): Internal.BiFunction<Internal.ItemStack, Internal.LootContext, V>;
        apply(arg0: Internal.ItemStack_, arg1: Internal.LootContext_): Internal.ItemStack;
        getReferencedContextParams(): Internal.Set<Internal.LootContextParam<any>>;
        validate(arg0: Internal.ValidationContext_): void;
        getType(): Internal.LootItemFunctionType;
        get referencedContextParams(): Internal.Set<Internal.LootContextParam<any>>
        get type(): Internal.LootItemFunctionType
    }
    type LootItemFunction_ = LootItemFunction;
    interface SignedMessageValidator {
        validateHeader(arg0: Internal.SignedMessageHeader_, arg1: Internal.MessageSignature_, arg2: number[]): Internal.SignedMessageValidator$State;
        create(arg0: Internal.ProfilePublicKey_, arg1: boolean): this;
        validateMessage(arg0: Internal.PlayerChatMessage_): Internal.SignedMessageValidator$State;
    }
    type SignedMessageValidator_ = SignedMessageValidator;
    class CommandBlock extends Internal.BaseEntityBlock implements Internal.GameMasterBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_, arg1: boolean)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly CONDITIONAL: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type CommandBlock_ = CommandBlock;
    class ClientboundContainerSetDataPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: number, arg1: number, arg2: number)
        constructor(arg0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getValue(): number;
        getContainerId(): number;
        isSkippable(): boolean;
        getId(): number;
        get value(): number
        get containerId(): number
        get skippable(): boolean
        get id(): number
    }
    type ClientboundContainerSetDataPacket_ = ClientboundContainerSetDataPacket;
    interface LootContextAccessor {
        repurposedstructures_setQueriedLootTableId(arg0: ResourceLocation_): void;
    }
    type LootContextAccessor_ = LootContextAccessor;
    class Block extends Internal.BlockBehaviour implements Internal.BlockColorSettings<any>, Internal.ItemLike, Internal.IForgeBlock, Internal.InjectedBlockExtension, Internal.IEnchantingBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): Internal.SoundType;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getSpeedFactor(): number;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        setMaterial(v: Internal.MaterialJS_): void;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getRenderPropertiesInternal(): any;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        fillItemCategory(arg0: Internal.CreativeModeTab_, arg1: Internal.NonNullList_<Internal.ItemStack>): void;
        useSmoothColorBlending(arg0: Internal.BlockAndTintGetter_, arg1: any, arg2: BlockPos_): boolean;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        getFriction(): number;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        useSmoothColorBlending(view: Internal.BlockAndTintGetter_, state: Internal.BlockState_, pos: BlockPos_): boolean;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LootContext$Builder_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(arg0: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<Internal.Component>, arg3: Internal.TooltipFlag_): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        isPossibleToRespawnInThis(): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        static stateById(arg0: number): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static getId(arg0: Internal.BlockState_): number;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        get descriptionId(): string
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get jumpFactor(): number
        get speedFactor(): number
        set material(v: Internal.MaterialJS_)
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get friction(): number
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get possibleToRespawnInThis(): boolean
        get mod(): string
        static readonly UPDATE_ALL_IMMEDIATE: 11;
        static readonly INDESTRUCTIBLE: -1.0;
        static readonly UPDATE_KNOWN_SHAPE: 16;
        static readonly UPDATE_IMMEDIATE: 8;
        static readonly UPDATE_SUPPRESS_DROPS: 32;
        static readonly UPDATE_ALL: 3;
        static readonly UPDATE_CLIENTS: 2;
        descriptionId: string;
        static readonly UPDATE_INVISIBLE: 4;
        static readonly UPDATE_LIMIT: 512;
        static readonly UPDATE_SUPPRESS_LIGHT: 128;
        static readonly UPDATE_NONE: 4;
        static readonly INSTANT: 0.0;
        /**
         * @deprecated
        */
        static readonly BLOCK_STATE_REGISTRY: Internal.IdMapper<Internal.BlockState>;
        static readonly UPDATE_NEIGHBORS: 1;
        static readonly UPDATE_MOVE_BY_PISTON: 64;
    }
    type Block_ = Special.Block | Block;
    class BitSet implements Internal.Cloneable, Internal.Serializable {
        constructor()
        constructor(arg0: number)
        clone(): any;
        set(arg0: number): void;
        cardinality(): number;
        xor(arg0: Internal.BitSet_): void;
        isEmpty(): boolean;
        set(arg0: number, arg1: number, arg2: boolean): void;
        intersects(arg0: Internal.BitSet_): boolean;
        get(arg0: number, arg1: number): this;
        set(arg0: number, arg1: boolean): void;
        static valueOf(arg0: number[]): Internal.BitSet;
        previousSetBit(arg0: number): number;
        or(arg0: Internal.BitSet_): void;
        get(arg0: number): boolean;
        set(arg0: number, arg1: number): void;
        andNot(arg0: Internal.BitSet_): void;
        and(arg0: Internal.BitSet_): void;
        stream(): Internal.IntStream;
        length(): number;
        static valueOf(arg0: Internal.LongBuffer_): Internal.BitSet;
        clear(arg0: number): void;
        clear(arg0: number, arg1: number): void;
        flip(arg0: number, arg1: number): void;
        flip(arg0: number): void;
        nextClearBit(arg0: number): number;
        static valueOf(arg0: number[]): Internal.BitSet;
        static valueOf(arg0: Internal.ByteBuffer_): Internal.BitSet;
        previousClearBit(arg0: number): number;
        nextSetBit(arg0: number): number;
        toByteArray(): number[];
        toLongArray(): number[];
        size(): number;
        clear(): void;
        get empty(): boolean
    }
    type BitSet_ = BitSet;
    interface RuleTestType <P extends Internal.RuleTest> {
        codec(): Internal.Codec<P>;
        register<P extends Internal.RuleTest>(arg0: string, arg1: Internal.Codec_<P>): this;
        readonly TAG_TEST: Internal.RuleTestType<Internal.TagMatchTest>;
        readonly RANDOM_BLOCKSTATE_TEST: Internal.RuleTestType<Internal.RandomBlockStateMatchTest>;
        readonly BLOCKSTATE_TEST: Internal.RuleTestType<Internal.BlockStateMatchTest>;
        readonly ALWAYS_TRUE_TEST: Internal.RuleTestType<Internal.AlwaysTrueTest>;
        readonly RANDOM_BLOCK_TEST: Internal.RuleTestType<Internal.RandomBlockMatchTest>;
        readonly BLOCK_TEST: Internal.RuleTestType<Internal.BlockMatchTest>;
    }
    type RuleTestType_<P extends Internal.RuleTest> = RuleTestType<P> | Special.RuleTest;
    class ChunkRenderDispatcher implements Internal.ChunkBuilderAccess {
        constructor(arg0: Internal.ClientLevel_, arg1: Internal.LevelRenderer_, arg2: Internal.Executor_, arg3: boolean, arg4: Internal.ChunkBufferBuilderPack_)
        constructor(arg0: Internal.ClientLevel_, arg1: Internal.LevelRenderer_, arg2: Internal.Executor_, arg3: boolean, arg4: Internal.ChunkBufferBuilderPack_, arg5: number)
        getFreeBufferCount(): number;
        setCamera(arg0: Vec3_): void;
        rebuildChunkSync(arg0: Internal.ChunkRenderDispatcher$RenderChunk_, arg1: Internal.RenderRegionCache_): void;
        getQueuedTaskCount(): number;
        getCameraPosition(): Vec3;
        schedule(arg0: Internal.ChunkRenderDispatcher$RenderChunk$ChunkCompileTask_): void;
        uploadAllPendingUploads(): void;
        getToBatchCount(): number;
        getToUpload(): number;
        getBufferCount(): number;
        dispose(): void;
        blockUntilClear(): void;
        isQueueEmpty(): boolean;
        getStats(): string;
        setLevel(arg0: Internal.ClientLevel_): void;
        uploadChunkLayer(arg0: Internal.BufferBuilder$RenderedBuffer_, arg1: Internal.VertexBuffer_): Internal.CompletableFuture<void>;
        getUploadQueue(): Internal.Queue<any>;
        get freeBufferCount(): number
        set camera(arg0: Vec3_)
        get queuedTaskCount(): number
        get cameraPosition(): Vec3
        get toBatchCount(): number
        get toUpload(): number
        get bufferCount(): number
        get queueEmpty(): boolean
        get stats(): string
        set level(arg0: Internal.ClientLevel_)
        get uploadQueue(): Internal.Queue<any>
    }
    type ChunkRenderDispatcher_ = ChunkRenderDispatcher;
    class WitchQuest {
        constructor(random: Internal.RandomSource_, items: Internal.List_<any>)
        constructor(tag: Internal.CompoundTag_)
        constructor(buffer: Internal.FriendlyByteBuf_)
        getPoints(): number;
        toPacket(buffer: Internal.FriendlyByteBuf_): void;
        consumeItems(inventory: Internal.Inventory_): void;
        getRequiredItems(): Internal.ItemStack[];
        toTag(): Internal.CompoundTag;
        hasItems(inventory: Internal.Container_): boolean;
        get points(): number
        get requiredItems(): Internal.ItemStack[]
    }
    type WitchQuest_ = WitchQuest;
    interface Blaze3dRenderTargetExt {
        iris$getDepthBufferVersion(): number;
        iris$getColorBufferVersion(): number;
    }
    type Blaze3dRenderTargetExt_ = Blaze3dRenderTargetExt;
    class UsageTickerEvent$GetCount extends Internal.UsageTickerEvent {
        constructor()
        constructor(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: number, arg4: boolean, arg5: Internal.Player_)
        setResultCount(arg0: number): void;
        getResultCount(): number;
        set resultCount(arg0: number)
        get resultCount(): number
    }
    type UsageTickerEvent$GetCount_ = UsageTickerEvent$GetCount;
    abstract class ThrowableItemProjectile extends Internal.ThrowableProjectile implements Internal.ItemSupplier {
        constructor(arg0: Internal.EntityType_<Internal.ThrowableItemProjectile>, arg1: Internal.LivingEntity_, arg2: Internal.Level_)
        constructor(arg0: Internal.EntityType_<Internal.ThrowableItemProjectile>, arg1: Internal.Level_)
        constructor(arg0: Internal.EntityType_<Internal.ThrowableItemProjectile>, arg1: number, arg2: number, arg3: number, arg4: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        isOnScoreboardTeam(teamId: string): boolean;
        setItem(arg0: Internal.ItemStack_): void;
        static getArrowFromDirectEntity(arg0: DamageSource_): Internal.ItemStack;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        readAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        alwaysAccepts(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        shouldRiderSit(): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        isFrame(): boolean;
        playSound(id: Internal.SoundEvent_): void;
        resetEndimation(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        addAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        static getWeaponFromDirectEntity(arg0: DamageSource_): Internal.ItemStack;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(arg0: boolean): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        set item(arg0: Internal.ItemStack_)
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        get facing(): Internal.Direction
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get frame(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        get multipartEntity(): boolean
        set dynamicLightEnabled(arg0: boolean)
        get parts(): Internal.PartEntity<any>[]
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
    }
    type ThrowableItemProjectile_ = ThrowableItemProjectile;
    interface FlowMessage extends org.apache.logging.log4j.message.Message {
        getFormattedMessage(): string;
        getParameters(): any[];
        getFormat(): string;
        getMessage(): org.apache.logging.log4j.message.Message;
        getText(): string;
        getThrowable(): Internal.Throwable;
        get formattedMessage(): string
        get parameters(): any[]
        get format(): string
        get message(): org.apache.logging.log4j.message.Message
        get text(): string
        get throwable(): Internal.Throwable
    }
    type FlowMessage_ = FlowMessage;
    class SeagrassBlock extends Internal.BushBlock implements Internal.IForgeShearable, Internal.LiquidBlockContainer, Internal.BonemealableBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isShearable(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: BlockPos_): boolean;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        isBonemealSuccess(arg0: Internal.Level_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        performBonemeal(arg0: Internal.ServerLevel_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        onSheared(arg0: Internal.Player_, arg1: Internal.ItemStack_, arg2: Internal.Level_, arg3: BlockPos_, arg4: number): Internal.List<Internal.ItemStack>;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getPlantType(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.PlantType;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        isValidBonemealTarget(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: boolean): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type SeagrassBlock_ = SeagrassBlock;
    interface IPartialSafeNBT {
        writeSafe(arg0: Internal.CompoundTag_): void;
    }
    type IPartialSafeNBT_ = IPartialSafeNBT;
    class FileTime implements Internal.Comparable<Internal.FileTime> {
        static from(arg0: number, arg1: Internal.TimeUnit_): Internal.FileTime;
        toMillis(): number;
        compareTo(arg0: Internal.FileTime_): number;
        toInstant(): Internal.Instant;
        to(arg0: Internal.TimeUnit_): number;
        static fromMillis(arg0: number): Internal.FileTime;
        compareTo(arg0: any): number;
        static from(arg0: Internal.Instant_): Internal.FileTime;
    }
    type FileTime_ = FileTime;
    class ClientboundSetChunkCacheRadiusPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: number)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        getRadius(): number;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get radius(): number
        get skippable(): boolean
    }
    type ClientboundSetChunkCacheRadiusPacket_ = ClientboundSetChunkCacheRadiusPacket;
    class UnicodeSet extends Internal.UnicodeFilter implements Internal.Iterable<string>, Internal.Freezable<Internal.UnicodeSet>, Internal.Comparable<Internal.UnicodeSet> {
        constructor()
        constructor(arg0: string, arg1: number)
        constructor(arg0: string, arg1: Internal.ParsePosition_, arg2: Internal.SymbolTable_, arg3: number)
        constructor(arg0: string, arg1: Internal.ParsePosition_, arg2: Internal.SymbolTable_)
        constructor(arg0: number, arg1: number)
        constructor(arg0: string, arg1: boolean)
        constructor(...arg0: number[])
        constructor(arg0: string)
        constructor(arg0: Internal.UnicodeSet_)
        /**
         * @deprecated
        */
        addBridges(arg0: Internal.UnicodeSet_): this;
        /**
         * @deprecated
        */
        static compare<T extends Internal.Comparable<T>>(arg0: Internal.Iterator_<T>, arg1: Internal.Iterator_<T>): number;
        addAllTo<T extends Internal.Collection<string>>(arg0: T): T;
        compareTo(arg0: Internal.UnicodeSet_): number;
        getRangeStart(arg0: number): number;
        compareTo(arg0: Internal.UnicodeSet_, arg1: Internal.UnicodeSet$ComparisonStyle_): number;
        containsSome(arg0: Internal.UnicodeSet_): boolean;
        static compare<T extends Internal.Comparable<T>>(arg0: Internal.Collection_<T>, arg1: Internal.Collection_<T>, arg2: Internal.UnicodeSet$ComparisonStyle_): number;
        complement(arg0: number, arg1: number): this;
        static fromAll(arg0: Internal.CharSequence_): Internal.UnicodeSet;
        add(arg0: number, arg1: number): this;
        addAll(arg0: Internal.CharSequence_): this;
        containsSome(arg0: Internal.CharSequence_): boolean;
        static from(arg0: Internal.CharSequence_): Internal.UnicodeSet;
        static resemblesPattern(arg0: string, arg1: number): boolean;
        cloneAsThawed(): this;
        addAll(arg0: Internal.UnicodeSet_): this;
        ranges(): Internal.Iterable<Internal.UnicodeSet$EntryRange>;
        /**
         * @deprecated
        */
        static setDefaultXSymbolTable(arg0: Internal.UnicodeSet$XSymbolTable_): void;
        applyIntPropertyValue(arg0: number, arg1: number): this;
        charAt(arg0: number): number;
        static addAllTo<T, U extends Internal.Collection<T>>(arg0: Internal.Iterable_<T>, arg1: U): U;
        containsSome<T extends Internal.CharSequence>(arg0: Internal.Iterable_<T>): boolean;
        spanBack(arg0: Internal.CharSequence_, arg1: Internal.UnicodeSet$SpanCondition_): number;
        _generatePattern(arg0: Internal.StringBuffer_, arg1: boolean, arg2: boolean): Internal.StringBuffer;
        clone(): any;
        strings(): Internal.Collection<string>;
        spliterator(): Internal.Spliterator<string>;
        containsNone(arg0: Internal.UnicodeSet_): boolean;
        removeAllStrings(): this;
        spanBack(arg0: Internal.CharSequence_, arg1: number, arg2: Internal.UnicodeSet$SpanCondition_): number;
        span(arg0: Internal.CharSequence_, arg1: number, arg2: Internal.UnicodeSet$SpanCondition_): number;
        retain(arg0: number): this;
        addAll<T extends Internal.CharSequence>(...arg0: T[]): this;
        _generatePattern(arg0: Internal.StringBuffer_, arg1: boolean): Internal.StringBuffer;
        set(arg0: Internal.UnicodeSet_): this;
        /**
         * @deprecated
        */
        static getSingleCodePoint(arg0: Internal.CharSequence_): number;
        addAll(arg0: Internal.Iterable_<any>): this;
        applyPattern(arg0: string): this;
        containsNone<T extends Internal.CharSequence>(arg0: Internal.Iterable_<T>): boolean;
        closeOver(arg0: number): this;
        remove(arg0: number, arg1: number): this;
        /**
         * @deprecated
        */
        spanAndCount(arg0: Internal.CharSequence_, arg1: number, arg2: Internal.UnicodeSet$SpanCondition_, arg3: Internal.OutputInt_): number;
        addAll(arg0: number, arg1: number): this;
        size(): number;
        static addAllTo<T>(arg0: Internal.Iterable_<T>, arg1: T[]): T[];
        contains(arg0: number, arg1: number): boolean;
        /**
         * @deprecated
        */
        getRegexEquivalent(): string;
        addAllTo(arg0: string[]): string[];
        containsAll(arg0: string): boolean;
        applyPropertyAlias(arg0: string, arg1: string, arg2: Internal.SymbolTable_): this;
        static compare<T extends Internal.Comparable<T>>(arg0: Internal.Iterable_<T>, arg1: Internal.Iterable_<T>): number;
        /**
         * @deprecated
        */
        applyPattern(arg0: string, arg1: Internal.ParsePosition_, arg2: Internal.SymbolTable_, arg3: number): this;
        complement(arg0: number): this;
        retainAll<T extends Internal.CharSequence>(arg0: Internal.Iterable_<T>): this;
        forEach(arg0: Internal.Consumer_<string>): void;
        complementAll(arg0: Internal.UnicodeSet_): this;
        containsAll<T extends Internal.CharSequence>(arg0: Internal.Iterable_<T>): boolean;
        containsNone(arg0: number, arg1: number): boolean;
        isFrozen(): boolean;
        compareTo(arg0: any): number;
        remove(arg0: Internal.CharSequence_): this;
        set(arg0: number, arg1: number): this;
        /**
         * @deprecated
        */
        findLastIn(arg0: Internal.CharSequence_, arg1: number, arg2: boolean): number;
        /**
         * @deprecated
        */
        findIn(arg0: Internal.CharSequence_, arg1: number, arg2: boolean): number;
        removeAll<T extends Internal.CharSequence>(arg0: Internal.Iterable_<T>): this;
        retainAll(arg0: Internal.UnicodeSet_): this;
        containsAll(arg0: Internal.UnicodeSet_): boolean;
        complementAll(arg0: Internal.CharSequence_): this;
        hasStrings(): boolean;
        add(arg0: Internal.Iterable_<any>): this;
        static toArray(arg0: Internal.UnicodeSet_): string[];
        add(arg0: number): this;
        getRangeCount(): number;
        /**
         * @deprecated
        */
        stripFrom(arg0: Internal.CharSequence_, arg1: boolean): string;
        indexOf(arg0: number): number;
        getRangeEnd(arg0: number): number;
        retainAll(arg0: Internal.CharSequence_): this;
        /**
         * @deprecated
        */
        matchesAt(arg0: Internal.CharSequence_, arg1: number): number;
        applyPropertyAlias(arg0: string, arg1: string): this;
        removeAll(arg0: Internal.UnicodeSet_): this;
        clear(): this;
        span(arg0: Internal.CharSequence_, arg1: Internal.UnicodeSet$SpanCondition_): number;
        retain(arg0: Internal.CharSequence_): this;
        complement(arg0: Internal.CharSequence_): this;
        static compare(arg0: Internal.CharSequence_, arg1: number): number;
        static compare(arg0: number, arg1: Internal.CharSequence_): number;
        removeAll(arg0: Internal.CharSequence_): this;
        containsSome(arg0: number, arg1: number): boolean;
        compact(): this;
        retain(arg0: number, arg1: number): this;
        applyPattern(arg0: string, arg1: boolean): this;
        /**
         * @deprecated
        */
        static getDefaultXSymbolTable(): Internal.UnicodeSet$XSymbolTable;
        isEmpty(): boolean;
        applyPattern(arg0: string, arg1: number): this;
        add(arg0: Internal.CharSequence_): this;
        freeze(): any;
        compareTo(arg0: Internal.Iterable_<string>): number;
        containsNone(arg0: Internal.CharSequence_): boolean;
        iterator(): Internal.Iterator<string>;
        contains(arg0: Internal.CharSequence_): boolean;
        remove(arg0: number): this;
        complement(): this;
        /**
         * @deprecated
        */
        set defaultXSymbolTable(arg0: Internal.UnicodeSet$XSymbolTable_)
        /**
         * @deprecated
        */
        get regexEquivalent(): string
        get frozen(): boolean
        get rangeCount(): number
        /**
         * @deprecated
        */
        get defaultXSymbolTable(): Internal.UnicodeSet$XSymbolTable
        get empty(): boolean
        static readonly MAX_VALUE: 1114111;
        static readonly IGNORE_SPACE: 1;
        static readonly EMPTY: Internal.UnicodeSet;
        static readonly CASE_INSENSITIVE: 2;
        static readonly MIN_VALUE: 0;
        static readonly ADD_CASE_MAPPINGS: 4;
        static readonly ALL_CODE_POINTS: Internal.UnicodeSet;
        static readonly CASE: 2;
    }
    type UnicodeSet_ = UnicodeSet;
    interface PlayerEntityAccessor {
        getInventory(): Internal.Inventory;
        get inventory(): Internal.Inventory
    }
    type PlayerEntityAccessor_ = PlayerEntityAccessor;
    class PacketFlow extends Internal.Enum<Internal.PacketFlow> {
        getOpposite(): this;
        static values(): Internal.PacketFlow[];
        static valueOf(arg0: string): Internal.PacketFlow;
        get opposite(): Internal.PacketFlow
        static readonly CLIENTBOUND: Internal.PacketFlow;
        static readonly SERVERBOUND: Internal.PacketFlow;
    }
    type PacketFlow_ = "serverbound" | "clientbound" | PacketFlow;
    interface IJeiKeyMapping {
        isUnbound(): boolean;
        getTranslatedKeyMessage(): Internal.Component;
        isActiveAndMatches(arg0: Internal.InputConstants$Key_): boolean;
        get unbound(): boolean
        get translatedKeyMessage(): Internal.Component
    }
    type IJeiKeyMapping_ = IJeiKeyMapping;
    class ServerboundResourcePackPacket$Action extends Internal.Enum<Internal.ServerboundResourcePackPacket$Action> {
        static valueOf(arg0: string): Internal.ServerboundResourcePackPacket$Action;
        static values(): Internal.ServerboundResourcePackPacket$Action[];
        static readonly SUCCESSFULLY_LOADED: Internal.ServerboundResourcePackPacket$Action;
        static readonly FAILED_DOWNLOAD: Internal.ServerboundResourcePackPacket$Action;
        static readonly ACCEPTED: Internal.ServerboundResourcePackPacket$Action;
        static readonly DECLINED: Internal.ServerboundResourcePackPacket$Action;
    }
    type ServerboundResourcePackPacket$Action_ = "declined" | "failed_download" | "successfully_loaded" | ServerboundResourcePackPacket$Action | "accepted";
    interface Matrix4x3fc {
        transformDirection(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        m00(): number;
        getRow(arg0: number, arg1: net.coderbot.iris.vendored.joml.Vector4f_): net.coderbot.iris.vendored.joml.Vector4f;
        get4x4(arg0: number[]): number[];
        obliqueZ(arg0: number, arg1: number, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getNormalizedRotation(arg0: Internal.Quaternionf_): Internal.Quaternionf;
        translateLocal(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        normal(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        cofactor3x3(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        transpose3x3(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        invert(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        mulTranslation(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        m12(): number;
        get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        sub(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotateX(arg0: number, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        scale(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get(arg0: number[]): number[];
        normalizedPositiveX(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        positiveZ(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        m31(): number;
        transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: net.coderbot.iris.vendored.joml.Vector3f_, arg3: net.coderbot.iris.vendored.joml.Vector3f_): Internal.Matrix4x3f;
        fma(arg0: Internal.Matrix4x3fc_, arg1: number, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get4x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getColumn(arg0: number, arg1: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotate(arg0: Internal.AxisAngle4f_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get(arg0: number[], arg1: number): number[];
        translate(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        transformPosition(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        add(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        invertOrtho(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        m01(): number;
        transform(arg0: Internal.Vector4fc_, arg1: net.coderbot.iris.vendored.joml.Vector4f_): net.coderbot.iris.vendored.joml.Vector4f;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getTranslation(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        m20(): number;
        rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        get4x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        frustumPlane(arg0: number, arg1: net.coderbot.iris.vendored.joml.Vector4f_): net.coderbot.iris.vendored.joml.Vector4f;
        normalize3x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get4x4(arg0: number[], arg1: number): number[];
        scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        properties(): number;
        arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        shadow(arg0: Internal.Vector4fc_, arg1: Internal.Matrix4x3fc_, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotateY(arg0: number, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        equals(arg0: Internal.Matrix4x3fc_, arg1: number): boolean;
        positiveY(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        m32(): number;
        rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        cofactor3x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getTransposed(arg0: number[]): number[];
        scaleXY(arg0: number, arg1: number, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        transform(arg0: net.coderbot.iris.vendored.joml.Vector4f_): net.coderbot.iris.vendored.joml.Vector4f;
        getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        withLookAtUp(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        translateLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        origin(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        translate(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        m21(): number;
        m02(): number;
        invert(arg0: Internal.Matrix4f_): Internal.Matrix4f;
        rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        scale(arg0: number, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: net.coderbot.iris.vendored.joml.Vector3f_, arg7: net.coderbot.iris.vendored.joml.Vector3f_): Internal.Matrix4x3f;
        isFinite(): boolean;
        lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get4x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        scale(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        m10(): number;
        getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
        rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        normalizedPositiveZ(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        positiveX(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        rotateZ(arg0: number, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        lerp(arg0: Internal.Matrix4x3fc_, arg1: number, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
        reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotate(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        transformPosition(arg0: Internal.Vector3fc_, arg1: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        determinant(): number;
        get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        shadow(arg0: Internal.Vector4fc_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getUnnormalizedRotation(arg0: Internal.Quaternionf_): Internal.Quaternionf;
        pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3fc_, arg5: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        m22(): number;
        transformDirection(arg0: Internal.Vector3fc_, arg1: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        mulOrtho(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getEulerAnglesZYX(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        mul(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        mulComponentWise(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        m11(): number;
        normal(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        get4x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        normalizedPositiveY(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        m30(): number;
        getTransposed(arg0: number[], arg1: number): number[];
        get(arg0: Internal.Matrix4f_): Internal.Matrix4f;
        arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        transpose3x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        getScale(arg0: net.coderbot.iris.vendored.joml.Vector3f_): net.coderbot.iris.vendored.joml.Vector3f;
        rotateLocal(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        normalize3x3(arg0: Internal.Matrix3f_): Internal.Matrix3f;
        get finite(): boolean
        readonly PLANE_PX: 1;
        readonly PLANE_NY: 2;
        readonly PLANE_NZ: 4;
        readonly PLANE_PY: 3;
        readonly PLANE_NX: 0;
        readonly PLANE_PZ: 5;
        readonly PROPERTY_TRANSLATION: 8;
        readonly PROPERTY_IDENTITY: 4;
        readonly PROPERTY_ORTHONORMAL: 16;
    }
    type Matrix4x3fc_ = Matrix4x3fc;
    class SearchRegistry$Key <T> {
        constructor()
    }
    type SearchRegistry$Key_<T> = SearchRegistry$Key<T>;
    interface IForgeMinecraft {
        popGuiLayer(): void;
        getLocale(): Internal.Locale;
        pushGuiLayer(arg0: Internal.Screen_): void;
        get locale(): Internal.Locale
    }
    type IForgeMinecraft_ = IForgeMinecraft;
    class ClientboundRecipePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.ClientboundRecipePacket$State_, arg1: Internal.Collection_<ResourceLocation>, arg2: Internal.Collection_<ResourceLocation>, arg3: Internal.RecipeBookSettings_)
        constructor(arg0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getRecipes(): Internal.List<ResourceLocation>;
        write(arg0: Internal.FriendlyByteBuf_): void;
        getHighlights(): Internal.List<ResourceLocation>;
        getState(): Internal.ClientboundRecipePacket$State;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getBookSettings(): Internal.RecipeBookSettings;
        isSkippable(): boolean;
        get recipes(): Internal.List<ResourceLocation>
        get highlights(): Internal.List<ResourceLocation>
        get state(): Internal.ClientboundRecipePacket$State
        get bookSettings(): Internal.RecipeBookSettings
        get skippable(): boolean
    }
    type ClientboundRecipePacket_ = ClientboundRecipePacket;
    abstract class PathNavigation {
        constructor(arg0: Internal.Mob_, arg1: Internal.Level_)
        createPath(arg0: Internal.Stream_<BlockPos>, arg1: number): net.minecraft.world.level.pathfinder.Path;
        moveTo(arg0: Internal.Entity_, arg1: number): boolean;
        canFloat(): boolean;
        createPath(arg0: Internal.Entity_, arg1: number): net.minecraft.world.level.pathfinder.Path;
        recomputePath(): void;
        createPath(arg0: number, arg1: number, arg2: number, arg3: number): net.minecraft.world.level.pathfinder.Path;
        setCanFloat(arg0: boolean): void;
        createPath(arg0: BlockPos_, arg1: number, arg2: number): net.minecraft.world.level.pathfinder.Path;
        isInProgress(): boolean;
        getTargetPos(): BlockPos;
        isStuck(): boolean;
        getPath(): net.minecraft.world.level.pathfinder.Path;
        resetMaxVisitedNodesMultiplier(): void;
        moveTo(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        getNodeEvaluator(): Internal.NodeEvaluator;
        moveTo(arg0: net.minecraft.world.level.pathfinder.Path_, arg1: number): boolean;
        setSpeedModifier(arg0: number): void;
        shouldRecomputePath(arg0: BlockPos_): boolean;
        isDone(): boolean;
        tick(): void;
        getMaxDistanceToWaypoint(): number;
        setMaxVisitedNodesMultiplier(arg0: number): void;
        createPath(arg0: BlockPos_, arg1: number): net.minecraft.world.level.pathfinder.Path;
        stop(): void;
        createPath(arg0: Internal.Set_<BlockPos>, arg1: number): net.minecraft.world.level.pathfinder.Path;
        isStableDestination(arg0: BlockPos_): boolean;
        set canFloat(arg0: boolean)
        get inProgress(): boolean
        get targetPos(): BlockPos
        get stuck(): boolean
        get path(): net.minecraft.world.level.pathfinder.Path
        get nodeEvaluator(): Internal.NodeEvaluator
        set speedModifier(arg0: number)
        get done(): boolean
        get maxDistanceToWaypoint(): number
        set maxVisitedNodesMultiplier(arg0: number)
    }
    type PathNavigation_ = PathNavigation;
    class EventPriority extends Internal.Enum<Internal.EventPriority> implements Internal.IEventListener {
        invoke(arg0: Internal.Event_): void;
        static values(): Internal.EventPriority[];
        static valueOf(arg0: string): Internal.EventPriority;
        listenerName(): string;
        static readonly NORMAL: Internal.EventPriority;
        static readonly LOWEST: Internal.EventPriority;
        static readonly LOW: Internal.EventPriority;
        static readonly HIGH: Internal.EventPriority;
        static readonly HIGHEST: Internal.EventPriority;
    }
    type EventPriority_ = "normal" | "high" | "low" | "lowest" | "highest" | EventPriority;
    class Agent {
        constructor(arg0: string, arg1: number)
        getName(): string;
        getVersion(): number;
        get name(): string
        get version(): number
        static readonly SCROLLS: Internal.Agent;
        static readonly MINECRAFT: Internal.Agent;
    }
    type Agent_ = Agent;
    class LightLayer extends Internal.Enum<Internal.LightLayer> {
        static valueOf(arg0: string): Internal.LightLayer;
        static values(): Internal.LightLayer[];
        static readonly BLOCK: Internal.LightLayer;
        static readonly SKY: Internal.LightLayer;
        readonly surrounding: number;
    }
    type LightLayer_ = "block" | LightLayer | "sky";
    class SpectralArrowItem extends Internal.ArrowItem {
        constructor(arg0: Internal.Item$Properties_)
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        setDigSpeed(speed: number): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onUsingTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Internal.Vector3f;
        setAttackSpeed(attackSpeed: number): void;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        getCreativeTabs(): Internal.Collection<Internal.CreativeModeTab>;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: Internal.Component_): Internal.Component;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        getDamage(arg0: Internal.ItemStack_): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        setArmorToughness(armorToughness: number): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasPlacementBehavior(): boolean;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTabs(): Internal.Collection<Internal.CreativeModeTab>
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type SpectralArrowItem_ = SpectralArrowItem;
    interface ServerGamePacketListener extends Internal.ServerPacketListener {
        handleChatCommand(arg0: Internal.ServerboundChatCommandPacket_): void;
        handlePlayerAbilities(arg0: Internal.ServerboundPlayerAbilitiesPacket_): void;
        handlePlayerInput(arg0: Internal.ServerboundPlayerInputPacket_): void;
        handleClientCommand(arg0: Internal.ServerboundClientCommandPacket_): void;
        handleResourcePackResponse(arg0: Internal.ServerboundResourcePackPacket_): void;
        handleChatPreview(arg0: Internal.ServerboundChatPreviewPacket_): void;
        handleSetCarriedItem(arg0: Internal.ServerboundSetCarriedItemPacket_): void;
        handlePickItem(arg0: Internal.ServerboundPickItemPacket_): void;
        handleSetCreativeModeSlot(arg0: Internal.ServerboundSetCreativeModeSlotPacket_): void;
        handleSeenAdvancements(arg0: Internal.ServerboundSeenAdvancementsPacket_): void;
        handleKeepAlive(arg0: Internal.ServerboundKeepAlivePacket_): void;
        handleUseItem(arg0: Internal.ServerboundUseItemPacket_): void;
        handlePaddleBoat(arg0: Internal.ServerboundPaddleBoatPacket_): void;
        handleSetStructureBlock(arg0: Internal.ServerboundSetStructureBlockPacket_): void;
        handleCustomPayload(arg0: Internal.ServerboundCustomPayloadPacket_): void;
        handleSelectTrade(arg0: Internal.ServerboundSelectTradePacket_): void;
        handleJigsawGenerate(arg0: Internal.ServerboundJigsawGeneratePacket_): void;
        getConnection(): Internal.Connection;
        onDisconnect(arg0: Internal.Component_): void;
        handleSetJigsawBlock(arg0: Internal.ServerboundSetJigsawBlockPacket_): void;
        handleSetCommandMinecart(arg0: Internal.ServerboundSetCommandMinecartPacket_): void;
        handleSetCommandBlock(arg0: Internal.ServerboundSetCommandBlockPacket_): void;
        handleRecipeBookSeenRecipePacket(arg0: Internal.ServerboundRecipeBookSeenRecipePacket_): void;
        handleBlockEntityTagQuery(arg0: Internal.ServerboundBlockEntityTagQuery_): void;
        handleContainerButtonClick(arg0: Internal.ServerboundContainerButtonClickPacket_): void;
        handlePong(arg0: Internal.ServerboundPongPacket_): void;
        handlePlaceRecipe(arg0: Internal.ServerboundPlaceRecipePacket_): void;
        handlePlayerCommand(arg0: Internal.ServerboundPlayerCommandPacket_): void;
        handleEditBook(arg0: Internal.ServerboundEditBookPacket_): void;
        handleInteract(arg0: Internal.ServerboundInteractPacket_): void;
        handleTeleportToEntityPacket(arg0: Internal.ServerboundTeleportToEntityPacket_): void;
        handleContainerClose(arg0: Internal.ServerboundContainerClosePacket_): void;
        handleChangeDifficulty(arg0: Internal.ServerboundChangeDifficultyPacket_): void;
        handleClientInformation(arg0: Internal.ServerboundClientInformationPacket_): void;
        handleRecipeBookChangeSettingsPacket(arg0: Internal.ServerboundRecipeBookChangeSettingsPacket_): void;
        handleContainerClick(arg0: Internal.ServerboundContainerClickPacket_): void;
        handleCustomCommandSuggestions(arg0: Internal.ServerboundCommandSuggestionPacket_): void;
        handleAcceptTeleportPacket(arg0: Internal.ServerboundAcceptTeleportationPacket_): void;
        handleMovePlayer(arg0: Internal.ServerboundMovePlayerPacket_): void;
        handleChatAck(arg0: Internal.ServerboundChatAckPacket_): void;
        handlePlayerAction(arg0: Internal.ServerboundPlayerActionPacket_): void;
        handleLockDifficulty(arg0: Internal.ServerboundLockDifficultyPacket_): void;
        handleAnimate(arg0: Internal.ServerboundSwingPacket_): void;
        handleRenameItem(arg0: Internal.ServerboundRenameItemPacket_): void;
        shouldPropagateHandlingExceptions(): boolean;
        handleEntityTagQuery(arg0: Internal.ServerboundEntityTagQuery_): void;
        handleSignUpdate(arg0: Internal.ServerboundSignUpdatePacket_): void;
        handleChat(arg0: Internal.ServerboundChatPacket_): void;
        handleSetBeaconPacket(arg0: Internal.ServerboundSetBeaconPacket_): void;
        handleUseItemOn(arg0: Internal.ServerboundUseItemOnPacket_): void;
        handleMoveVehicle(arg0: Internal.ServerboundMoveVehiclePacket_): void;
        get connection(): Internal.Connection
    }
    type ServerGamePacketListener_ = ServerGamePacketListener;
    class FireworkRocketRecipe extends Internal.CustomRecipe {
        constructor(arg0: ResourceLocation_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        matches(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems(arg0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        assemble(arg0: Internal.CraftingContainer_): Internal.ItemStack;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type FireworkRocketRecipe_ = FireworkRocketRecipe;
    class TickTask implements Internal.Runnable {
        constructor(arg0: number, arg1: Internal.Runnable_)
        run(): void;
        getTick(): number;
        get tick(): number
    }
    type TickTask_ = TickTask;
    class RandomSpreadStructurePlacement extends Internal.StructurePlacement {
        constructor(arg0: number, arg1: number, arg2: Internal.RandomSpreadType_, arg3: number)
        constructor(arg0: Vec3i_, arg1: any_, arg2: number, arg3: number, arg4: Internal.Optional_<any>, arg5: number, arg6: number, arg7: Internal.RandomSpreadType_)
        spacing(): number;
        getPotentialStructureChunk(arg0: number, arg1: number, arg2: number): Internal.ChunkPos;
        separation(): number;
        spreadType(): Internal.RandomSpreadType;
        static readonly CODEC: Internal.Codec<Internal.RandomSpreadStructurePlacement>;
    }
    type RandomSpreadStructurePlacement_ = RandomSpreadStructurePlacement;
    class FeaturePlaceContext <FC extends Internal.FeatureConfiguration> {
        constructor(arg0: Internal.Optional_<Internal.ConfiguredFeature<any, any>>, arg1: Internal.WorldGenLevel_, arg2: Internal.ChunkGenerator_, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: FC)
        config(): FC;
        topFeature(): Internal.Optional<Internal.ConfiguredFeature<any, any>>;
        origin(): BlockPos;
        random(): Internal.RandomSource;
        level(): Internal.WorldGenLevel;
        chunkGenerator(): Internal.ChunkGenerator;
    }
    type FeaturePlaceContext_<FC extends Internal.FeatureConfiguration> = FeaturePlaceContext<FC>;
    class IpBanList extends Internal.StoredUserList<string, Internal.IpBanListEntry> {
        constructor(arg0: Internal.File_)
        isBanned(arg0: string): boolean;
        isBanned(arg0: Internal.SocketAddress_): boolean;
        get(arg0: Internal.SocketAddress_): Internal.IpBanListEntry;
    }
    type IpBanList_ = IpBanList;
    class Horse extends Internal.AbstractHorse implements Internal.HorseHat {
        constructor(arg0: Internal.EntityType_<Internal.Horse>, arg1: Internal.Level_)
        isAlwaysBaby(): boolean;
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        equipped(arg0: Internal.ItemEntity_): boolean;
        swing(): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        getVariant(): Internal.Variant;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        static setStunted(entity: Internal.AgeableMob_, stunted: boolean): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getControllingPassenger(): Internal.Entity;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        getArmor(): Internal.ItemStack;
        static isBlocked(entity: Internal.Entity_): boolean;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setHat(): void;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        getMarkings(): Internal.Markings;
        setCowboySpawned(): void;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        hasHat(): boolean;
        setAnimationTick(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        get alwaysBaby(): boolean
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get variant(): Internal.Variant
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get controllingPassenger(): Internal.Entity
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get armor(): Internal.ItemStack
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get markings(): Internal.Markings
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Horse_ = Horse;
    class SurfaceProxyView implements Internal.AutoCloseable {
        constructor(proxy: Internal.SurfaceProxy_)
        constructor(proxy: Internal.SurfaceProxy_, origin: number, swizzle: number)
        getWidth(): number;
        getSwizzle(): number;
        getOrigin(): number;
        getProxy(): Internal.SurfaceProxy;
        isMipmapped(): boolean;
        close(): void;
        refProxy(): Internal.SurfaceProxy;
        reset(): void;
        getHeight(): number;
        concat(swizzle: number): void;
        detachProxy(): Internal.SurfaceProxy;
        get width(): number
        get swizzle(): number
        get origin(): number
        get proxy(): Internal.SurfaceProxy
        get mipmapped(): boolean
        get height(): number
    }
    type SurfaceProxyView_ = SurfaceProxyView;
    interface SimpleWaterloggedBlock extends Internal.BucketPickup, Internal.LiquidBlockContainer {
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
    }
    type SimpleWaterloggedBlock_ = SimpleWaterloggedBlock;
    interface CustomJavaToJsWrapper {
        convertJavaToJs(arg0: Internal.Context_, arg1: Internal.Scriptable_, arg2: typeof any): Internal.Scriptable;
        (arg0: Internal.Context_, arg1: Internal.Scriptable_, arg2: typeof any): Internal.Scriptable_;
    }
    type CustomJavaToJsWrapper_ = CustomJavaToJsWrapper;
    class LegacyRandomSource implements Internal.BitRandomSource {
        constructor(arg0: number)
        static create(arg0: number): Internal.RandomSource;
        next(arg0: number): number;
        fork(): Internal.RandomSource;
        static create(): Internal.RandomSource;
        nextBoolean(): boolean;
        nextLong(): number;
        setSeed(arg0: number): void;
        nextDouble(): number;
        nextInt(arg0: number, arg1: number): number;
        nextGaussian(): number;
        static createNewThreadLocalInstance(): Internal.RandomSource;
        forkPositional(): Internal.PositionalRandomFactory;
        consumeCount(arg0: number): void;
        triangle(arg0: number, arg1: number): number;
        nextInt(arg0: number): number;
        nextFloat(): number;
        /**
         * @deprecated
        */
        static createThreadSafe(): Internal.RandomSource;
        nextInt(): number;
        nextIntBetweenInclusive(arg0: number, arg1: number): number;
        set seed(arg0: number)
    }
    type LegacyRandomSource_ = LegacyRandomSource;
    interface ChannelPipeline extends Internal.Iterable<Internal.Map$Entry<string, Internal.ChannelHandler>>, Internal.ChannelOutboundInvoker, Internal.ChannelInboundInvoker {
        fireExceptionCaught(arg0: Internal.Throwable_): this;
        addBefore(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: string, arg3: Internal.ChannelHandler_): this;
        firstContext(): Internal.ChannelHandlerContext;
        addFirst(arg0: Internal.EventExecutorGroup_, ...arg1: Internal.ChannelHandler_[]): this;
        addAfter(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): this;
        remove<T extends Internal.ChannelHandler>(arg0: T): T;
        removeFirst(): Internal.ChannelHandler;
        write(arg0: any): Internal.ChannelFuture;
        replace<T extends Internal.ChannelHandler>(arg0: T, arg1: string, arg2: Internal.ChannelHandler_): T;
        fireChannelWritabilityChanged(): this;
        close(): Internal.ChannelFuture;
        write(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        toMap(): Internal.Map<string, Internal.ChannelHandler>;
        addFirst(arg0: string, arg1: Internal.ChannelHandler_): this;
        spliterator(): Internal.Spliterator<Internal.Map$Entry<string, Internal.ChannelHandler>>;
        addBefore(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): this;
        replace(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): Internal.ChannelHandler;
        first(): Internal.ChannelHandler;
        bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        remove(arg0: Internal.ChannelHandler_): this;
        forEach(arg0: Internal.Consumer_<Internal.Map$Entry<string, Internal.ChannelHandler>>): void;
        get(arg0: string): Internal.ChannelHandler;
        addLast(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: Internal.ChannelHandler_): this;
        lastContext(): Internal.ChannelHandlerContext;
        read(): Internal.ChannelOutboundInvoker;
        fireChannelUnregistered(): this;
        voidPromise(): Internal.ChannelPromise;
        context(arg0: Internal.ChannelHandler_): Internal.ChannelHandlerContext;
        addLast(...arg0: Internal.ChannelHandler_[]): this;
        fireChannelInactive(): this;
        addFirst(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: Internal.ChannelHandler_): this;
        connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): Internal.ChannelFuture;
        deregister(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        fireChannelRegistered(): this;
        replace(arg0: Internal.ChannelHandler_, arg1: string, arg2: Internal.ChannelHandler_): this;
        writeAndFlush(arg0: any): Internal.ChannelFuture;
        disconnect(): Internal.ChannelFuture;
        fireChannelRead(arg0: any): this;
        context(arg0: string): Internal.ChannelHandlerContext;
        fireUserEventTriggered(arg0: any): this;
        addAfter(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: string, arg3: Internal.ChannelHandler_): this;
        connect(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_): Internal.ChannelFuture;
        names(): Internal.List<string>;
        deregister(): Internal.ChannelFuture;
        disconnect(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        addLast(arg0: Internal.EventExecutorGroup_, ...arg1: Internal.ChannelHandler_[]): this;
        newFailedFuture(arg0: Internal.Throwable_): Internal.ChannelFuture;
        fireChannelReadComplete(): this;
        close(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        newSucceededFuture(): Internal.ChannelFuture;
        newProgressivePromise(): Internal.ChannelProgressivePromise;
        iterator(): Internal.Iterator<Internal.Map$Entry<string, Internal.ChannelHandler>>;
        fireChannelActive(): this;
        last(): Internal.ChannelHandler;
        get<T extends Internal.ChannelHandler>(arg0: T): T;
        channel(): io.netty.channel.Channel;
        remove(arg0: string): Internal.ChannelHandler;
        writeAndFlush(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        bind(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        context(arg0: typeof Internal.ChannelHandler): Internal.ChannelHandlerContext;
        connect(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        addFirst(...arg0: Internal.ChannelHandler_[]): this;
        flush(): this;
        removeLast(): Internal.ChannelHandler;
        addLast(arg0: string, arg1: Internal.ChannelHandler_): this;
        newPromise(): Internal.ChannelPromise;
    }
    type ChannelPipeline_ = ChannelPipeline;
    class ServerStartedEvent extends Internal.ServerLifecycleEvent {
        constructor()
        constructor(arg0: Internal.MinecraftServer_)
    }
    type ServerStartedEvent_ = ServerStartedEvent;
    interface ExtendingBufferBuilder {
        iris$beginWithoutExtending(arg0: Internal.VertexFormat$Mode_, arg1: Internal.VertexFormat_): void;
    }
    type ExtendingBufferBuilder_ = ExtendingBufferBuilder;
    interface ObjectCollection <K> extends Internal.Collection<K>, Internal.ObjectIterable<K> {
        addAll(arg0: Internal.Collection_<K>): boolean;
        iterator(): Internal.Iterator<any>;
        toArray<T>(arg0: T[]): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        spliterator(): Internal.ObjectSpliterator<K>;
        remove(arg0: any): boolean;
        isEmpty(): boolean;
        toArray(): any[];
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        parallelStream(): Internal.Stream<K>;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        hashCode(): number;
        size(): number;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        removeAll(arg0: Internal.Collection_<any>): boolean;
        clear(): void;
        equals(arg0: any): boolean;
        add(arg0: K): boolean;
        stream(): Internal.Stream<K>;
        contains(arg0: any): boolean;
        get empty(): boolean
    }
    type ObjectCollection_<K> = ObjectCollection<K>;
    class NbtAccounter implements Internal.NbtAccounterAccessor {
        constructor(arg0: number)
        create$getUsage(): number;
        accountBits(arg0: number): void;
        readUTF(arg0: string): string;
        static readonly UNLIMITED: Internal.NbtAccounter;
    }
    type NbtAccounter_ = NbtAccounter;
    class KelpPlantBlock extends Internal.GrowingPlantBodyBlock implements Internal.LiquidBlockContainer {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type KelpPlantBlock_ = KelpPlantBlock;
    interface IJeiHelpers {
        getStackHelper(): Internal.IStackHelper;
        getColorHelper(): Internal.IColorHelper;
        getModIdHelper(): Internal.IModIdHelper;
        getFocusFactory(): Internal.IFocusFactory;
        getGuiHelper(): Internal.IGuiHelper;
        getRecipeType(arg0: ResourceLocation_): Internal.Optional<mezz.jei.api.recipe.RecipeType<any>>;
        getPlatformFluidHelper(): Internal.IPlatformFluidHelper<any>;
        getIngredientManager(): Internal.IIngredientManager;
        get stackHelper(): Internal.IStackHelper
        get colorHelper(): Internal.IColorHelper
        get modIdHelper(): Internal.IModIdHelper
        get focusFactory(): Internal.IFocusFactory
        get guiHelper(): Internal.IGuiHelper
        get platformFluidHelper(): Internal.IPlatformFluidHelper<any>
        get ingredientManager(): Internal.IIngredientManager
    }
    type IJeiHelpers_ = IJeiHelpers;
    interface ModifiableTickRateServer {
        setGlobalTickLengthMs(arg0: number): void;
        getMasterMs(): number;
        resetGlobalTickLengthMs(): void;
        set globalTickLengthMs(arg0: number)
        get masterMs(): number
    }
    type ModifiableTickRateServer_ = ModifiableTickRateServer;
    class Couple <T> extends com.simibubi.create.foundation.utility.Pair<T, T> implements Internal.Iterable<T> {
        static createWithContext<T>(arg0: Internal.Function_<boolean, T>): Internal.Couple<T>;
        forEachWithContext(arg0: Internal.BiConsumer_<T, boolean>): void;
        replaceWithContext(arg0: Internal.BiFunction_<T, boolean, T>): void;
        stream(): Internal.Stream<T>;
        static create<T>(arg0: Internal.Supplier_<T>): Internal.Couple<T>;
        set(arg0: boolean, arg1: T): void;
        mapWithParams<S, R>(arg0: Internal.BiFunction_<T, R, S>, arg1: Internal.Couple_<R>): Internal.Couple<S>;
        spliterator(): Internal.Spliterator<T>;
        forEachWithParams<S>(arg0: Internal.BiConsumer_<T, S>, arg1: Internal.Couple_<S>): void;
        replace(arg0: Internal.Function_<T, T>): void;
        swap(): com.simibubi.create.foundation.utility.Pair<any, any>;
        both(arg0: Internal.Predicate_<T>): boolean;
        mapNotNullWithParam<S, R>(arg0: Internal.BiFunction_<T, R, S>, arg1: R): Internal.Couple<S>;
        get(arg0: boolean): T;
        iterator(): Internal.Iterator<T>;
        static deserializeEach<S>(arg0: Internal.ListTag_, arg1: Internal.Function_<Internal.CompoundTag, S>): Internal.Couple<S>;
        forEach(arg0: Internal.Consumer_<T>): void;
        static create<T>(arg0: T, arg1: T): Internal.Couple<T>;
        map<S>(arg0: Internal.Function_<T, S>): Internal.Couple<S>;
        either(arg0: Internal.Predicate_<T>): boolean;
        serializeEach(arg0: Internal.Function_<T, Internal.CompoundTag>): Internal.ListTag;
        mapWithContext<S>(arg0: Internal.BiFunction_<T, boolean, S>): Internal.Couple<S>;
        replaceWithParams<S>(arg0: Internal.BiFunction_<T, S, T>, arg1: Internal.Couple_<S>): void;
        copy(): com.simibubi.create.foundation.utility.Pair<any, any>;
    }
    type Couple_<T> = Couple<T>;
    class FoodBuilder {
        constructor()
        constructor(properties: Internal.FoodProperties_)
        /**
         * Sets whether the food is fast to eat (having half of the eating time).
        */
        fastToEat(flag: boolean): this;
        /**
         * Sets the hunger restored.
        */
        hunger(h: number): this;
        /**
         * Sets whether the food is always edible.
        */
        alwaysEdible(flag: boolean): this;
        /**
         * Sets the saturation modifier. Note that the saturation restored is hunger * saturation.
        */
        saturation(s: number): this;
        build(): Internal.FoodProperties;
        /**
         * Sets the food is always edible.
        */
        alwaysEdible(): this;
        effect(mobEffectId: Special.MobEffect, duration: number, amplifier: number, probability: number): this;
        /**
         * Sets whether the food is meat.
        */
        meat(flag: boolean): this;
        /**
         * Sets the food is meat.
        */
        meat(): this;
        /**
         * Sets a callback that is called when the food is eaten.
         * 
         * Note: This is currently not having effect in `ItemEvents.modification`,
         * as firing this callback requires an `ItemBuilder` instance in the `Item`.
        */
        eaten(e: Internal.Consumer_<Internal.FoodEatenEventJS>): this;
        /**
         * Removes an effect from the food.
        */
        removeEffect(mobEffect: Internal.MobEffect_): this;
        /**
         * Sets the food is fast to eat (having half of the eating time).
        */
        fastToEat(): this;
        eaten: Internal.Consumer<Internal.FoodEatenEventJS>;
    }
    type FoodBuilder_ = FoodBuilder;
    class VariantBlockStateGenerator$Model {
        constructor()
        uvlock(): this;
        x(_x: number): this;
        y(_y: number): this;
        model(s: string): this;
        toJson(): Internal.JsonObject;
    }
    type VariantBlockStateGenerator$Model_ = VariantBlockStateGenerator$Model;
    class BlockPlaceContext extends Internal.UseOnContext {
        constructor(arg0: Internal.Player_, arg1: Internal.InteractionHand_, arg2: Internal.ItemStack_, arg3: Internal.BlockHitResult_)
        constructor(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_, arg3: Internal.ItemStack_, arg4: Internal.BlockHitResult_)
        constructor(arg0: Internal.UseOnContext_)
        getNearestLookingDirection(): Internal.Direction;
        getNearestLookingVerticalDirection(): Internal.Direction;
        getNearestLookingDirections(): Internal.Direction[];
        replacingClickedOnBlock(): boolean;
        static at(arg0: Internal.BlockPlaceContext_, arg1: BlockPos_, arg2: Internal.Direction_): Internal.BlockPlaceContext;
        canPlace(): boolean;
        handler$ehl000$fixNotAccountingForNullPlayer3(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$ehl000$fixNotAccountingForNullPlayer2(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$ehl000$fixNotAccountingForNullPlayer1(cir: Internal.CallbackInfoReturnable_<any>): void;
        get nearestLookingDirection(): Internal.Direction
        get nearestLookingVerticalDirection(): Internal.Direction
        get nearestLookingDirections(): Internal.Direction[]
    }
    type BlockPlaceContext_ = BlockPlaceContext;
    interface Object2ShortFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToIntFunction<K> {
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Object2FloatFunction<K>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ShortFunction<T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ShortFunction;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ShortFunction;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ShortFunction;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Object2IntFunction<K>;
        containsKey(arg0: any): boolean;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Object2LongFunction<K>;
        defaultReturnValue(): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ShortFunction;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        getOrDefault(arg0: any, arg1: number): number;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        apply(arg0: K): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        getShort(arg0: any): number;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        removeShort(arg0: any): number;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Object2CharFunction<K>;
        put(arg0: K, arg1: number): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ShortFunction<T>;
        applyAsInt(arg0: K): number;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Object2ByteFunction<K>;
        size(): number;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ShortFunction;
        defaultReturnValue(arg0: number): void;
        clear(): void;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ShortFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        (arg0: any): number;
    }
    type Object2ShortFunction_<K> = Object2ShortFunction<K>;
    class ScreenEvent$MouseDragged$Pre extends Internal.ScreenEvent$MouseDragged {
        constructor()
        constructor(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number)
    }
    type ScreenEvent$MouseDragged$Pre_ = ScreenEvent$MouseDragged$Pre;
    class RegistryManager {
        constructor(arg0: string)
        static postNewRegistryEvent(): void;
        getRegistry<V>(arg0: Internal.ResourceKey_<Internal.Registry<V>>): Internal.ForgeRegistry<V>;
        updateLegacyName<V>(arg0: ResourceLocation_): ResourceLocation;
        clean(): void;
        getRegistry<V>(arg0: ResourceLocation_, arg1: Internal.RegistryManager_): Internal.ForgeRegistry<V>;
        getName(): string;
        static getRegistryNamesForSyncToClient(): Internal.List<ResourceLocation>;
        getRegistry<V>(arg0: ResourceLocation_): Internal.ForgeRegistry<V>;
        static getVanillaRegistryKeys(): Internal.Set<ResourceLocation>;
        static generateRegistryPackets(arg0: boolean): Internal.List<org.apache.commons.lang3.tuple.Pair<string, Internal.HandshakeMessages$S2CRegistry>>;
        getName<V>(arg0: Internal.IForgeRegistry_<V>): ResourceLocation;
        takeSnapshot(arg0: boolean): Internal.Map<ResourceLocation, Internal.ForgeRegistry$Snapshot>;
        get name(): string
        get registryNamesForSyncToClient(): Internal.List<ResourceLocation>
        get vanillaRegistryKeys(): Internal.Set<ResourceLocation>
        static readonly FROZEN: Internal.RegistryManager;
        static readonly ACTIVE: Internal.RegistryManager;
        static readonly VANILLA: Internal.RegistryManager;
    }
    type RegistryManager_ = RegistryManager;
    class Rarity extends Internal.Enum<Internal.Rarity> implements Internal.IExtensibleEnum {
        getStyleModifier(): Internal.UnaryOperator<Internal.Style>;
        static createCodecForExtensibleEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, E>): Internal.Codec<E>;
        static create(arg0: string, arg1: Internal.UnaryOperator_<Internal.Style>): Internal.Rarity;
        /**
         * @deprecated
        */
        init(): void;
        static valueOf(arg0: string): Internal.Rarity;
        static create(arg0: string, arg1: Internal.ChatFormatting_): Internal.Rarity;
        static values(): Internal.Rarity[];
        get styleModifier(): Internal.UnaryOperator<Internal.Style>
        static readonly COMMON: Internal.Rarity;
        /**
         * @deprecated
        */
        readonly color: Internal.ChatFormatting;
        static readonly UNCOMMON: Internal.Rarity;
        static readonly EPIC: Internal.Rarity;
        static readonly RARE: Internal.Rarity;
    }
    type Rarity_ = "twisted" | "legendary" | "celestial" | "rare" | "nanocube" | "mblock" | "twilight" | Rarity | "epic" | "blackhead" | "uncommon" | "twstone" | "common" | "asdas";
    interface ConfigSpec$CorrectionListener {
        onCorrect(arg0: Internal.ConfigSpec$CorrectionAction_, arg1: Internal.List_<string>, arg2: any, arg3: any): void;
        (arg0: Internal.ConfigSpec$CorrectionAction_, arg1: Internal.List_<string>, arg2: any, arg3: any): void;
    }
    type ConfigSpec$CorrectionListener_ = ConfigSpec$CorrectionListener;
    interface ChatEvent$ChatComponent {
        get(): Internal.Component;
        set(arg0: Internal.Component_): void;
    }
    type ChatEvent$ChatComponent_ = ChatEvent$ChatComponent;
    interface ProfileResults {
        saveResults(arg0: Internal.Path_): boolean;
        getTimes(arg0: string): Internal.List<Internal.ResultField>;
        getNanoDuration(): number;
        getStartTimeTicks(): number;
        getTickDuration(): number;
        getEndTimeNano(): number;
        getEndTimeTicks(): number;
        getStartTimeNano(): number;
        getProfilerResults(): string;
        demanglePath(arg0: string): string;
        get nanoDuration(): number
        get startTimeTicks(): number
        get tickDuration(): number
        get endTimeNano(): number
        get endTimeTicks(): number
        get startTimeNano(): number
        get profilerResults(): string
        readonly PATH_SEPARATOR: "\u001e";
    }
    type ProfileResults_ = ProfileResults;
    abstract class SignatureSpi {
        constructor()
        clone(): any;
    }
    type SignatureSpi_ = SignatureSpi;
    class ServerboundPlaceRecipePacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: number, arg1: Internal.Recipe_<any>, arg2: boolean)
        handle(arg0: Internal.PacketListener_): void;
        getRecipe(): ResourceLocation;
        write(arg0: Internal.FriendlyByteBuf_): void;
        isShiftDown(): boolean;
        handle(arg0: Internal.ServerGamePacketListener_): void;
        getContainerId(): number;
        isSkippable(): boolean;
        get recipe(): ResourceLocation
        get shiftDown(): boolean
        get containerId(): number
        get skippable(): boolean
    }
    type ServerboundPlaceRecipePacket_ = ServerboundPlaceRecipePacket;
    class CarvingContext extends Internal.WorldGenerationContext {
        constructor(arg0: any_, arg1: Internal.RegistryAccess_, arg2: Internal.LevelHeightAccessor_, arg3: Internal.NoiseChunk_, arg4: Internal.RandomState_, arg5: Internal.SurfaceRules$RuleSource_)
        /**
         * @deprecated
        */
        topMaterial(arg0: Internal.Function_<BlockPos, Internal.Holder<Internal.Biome>>, arg1: Internal.ChunkAccess_, arg2: BlockPos_, arg3: boolean): Internal.Optional<Internal.BlockState>;
        /**
         * @deprecated
        */
        registryAccess(): Internal.RegistryAccess;
        randomState(): Internal.RandomState;
    }
    type CarvingContext_ = CarvingContext;
    class CandleBlock extends Internal.AbstractCandleBlock implements Internal.SimpleWaterloggedBlock, Internal.IEnchantingBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static canLight(arg0: Internal.BlockState_): boolean;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly MAX_CANDLES: 4;
        static readonly CANDLES: Internal.IntegerProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly MIN_CANDLES: 1;
        static readonly LIT: Internal.BooleanProperty;
        static readonly LIGHT_EMISSION: Internal.ToIntFunction<Internal.BlockState>;
    }
    type CandleBlock_ = CandleBlock;
    interface ListBuilder <T> {
        build(arg0: Internal.DataResult_<T>): Internal.DataResult<T>;
        withErrorsFrom(arg0: Internal.DataResult_<any>): this;
        add(arg0: T): this;
        ops(): Internal.DynamicOps<T>;
        add<E>(arg0: E, arg1: Internal.Encoder_<E>): this;
        add(arg0: Internal.DataResult_<T>): this;
        addAll<E>(arg0: Internal.Iterable_<E>, arg1: Internal.Encoder_<E>): this;
        build(arg0: T): Internal.DataResult<T>;
        mapError(arg0: Internal.UnaryOperator_<string>): this;
    }
    type ListBuilder_<T> = ListBuilder<T>;
    class FormatStyle extends Internal.Enum<Internal.FormatStyle> {
        static values(): Internal.FormatStyle[];
        static valueOf(arg0: string): Internal.FormatStyle;
        static readonly SHORT: Internal.FormatStyle;
        static readonly FULL: Internal.FormatStyle;
        static readonly LONG: Internal.FormatStyle;
        static readonly MEDIUM: Internal.FormatStyle;
    }
    type FormatStyle_ = "medium" | "short" | "full" | FormatStyle | "long";
    class EntityRadarCategory extends Internal.FilterObjectCategory<Internal.Entity, Internal.Player, any, Internal.EntityRadarCategory> {
    }
    type EntityRadarCategory_ = EntityRadarCategory;
    class ObjectCategoryExcludeList <E, P, S> extends Internal.ObjectCategoryListRule<E, P, S> {
        spliterator(): Internal.Spliterator<string>;
        getExcludeMode(): Internal.ExcludeListMode;
        forEach(arg0: Internal.Consumer_<string>): void;
        get excludeMode(): Internal.ExcludeListMode
    }
    type ObjectCategoryExcludeList_<E, P, S> = ObjectCategoryExcludeList<E, P, S>;
    class TrackMaterial$TrackType {
        constructor(arg0: ResourceLocation_, arg1: any_)
        static readonly STANDARD: Internal.TrackMaterial$TrackType;
        readonly id: ResourceLocation;
    }
    type TrackMaterial$TrackType_ = TrackMaterial$TrackType;
    class LightBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly MAX_LEVEL: 15;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly LIGHT_EMISSION: Internal.ToIntFunction<Internal.BlockState>;
        static readonly LEVEL: Internal.IntegerProperty;
    }
    type LightBlock_ = LightBlock;
    interface Float2ByteFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToIntFunction {
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Float2IntFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Float2CharFunction;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Float2ShortFunction;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2ByteFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2ByteFunction<T>;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2ByteFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        defaultReturnValue(arg0: number): void;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Float2FloatFunction;
        apply(arg0: number): number;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Float2ObjectFunction<T>;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2ByteFunction;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        getOrDefault(arg0: number, arg1: number): number;
        containsKey(arg0: number): boolean;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Float2ReferenceFunction<T>;
        remove(arg0: number): number;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2ByteFunction<T>;
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2ByteFunction;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2ByteFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        size(): number;
        clear(): void;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2ByteFunction;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Float2LongFunction;
        get(arg0: number): number;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Float2DoubleFunction;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type Float2ByteFunction_ = Float2ByteFunction;
    class Vector3d {
        constructor(arg0: number, arg1: number, arg2: number)
        set(arg0: Internal.Vector3d_): void;
        scale(arg0: number): void;
        add(arg0: Internal.Vector3d_): void;
        set(arg0: number, arg1: number, arg2: number): void;
        z: number;
        x: number;
        y: number;
    }
    type Vector3d_ = Vector3d;
    abstract class SupportType extends Internal.Enum<Internal.SupportType> {
        static values(): Internal.SupportType[];
        static valueOf(arg0: string): Internal.SupportType;
        isSupporting(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        static readonly CENTER: Internal.SupportType;
        static readonly RIGID: Internal.SupportType;
        static readonly FULL: Internal.SupportType;
    }
    type SupportType_ = "center" | SupportType | "full" | "rigid";
    class ArgumentCommandNode <S, T> extends Internal.CommandNode<S> {
        constructor(arg0: string, arg1: Internal.ArgumentType_<T>, arg2: Internal.Command_<S>, arg3: Internal.Predicate_<S>, arg4: Internal.CommandNode_<S>, arg5: Internal.RedirectModifier_<S>, arg6: boolean, arg7: Internal.SuggestionProvider_<S>)
        isValidInput(arg0: string): boolean;
        getType(): Internal.ArgumentType<T>;
        createBuilder(): Internal.ArgumentBuilder<any, any>;
        getCustomSuggestions(): Internal.SuggestionProvider<S>;
        get type(): Internal.ArgumentType<T>
        get customSuggestions(): Internal.SuggestionProvider<S>
    }
    type ArgumentCommandNode_<S, T> = ArgumentCommandNode<S, T>;
    class GameNarrator {
        constructor(arg0: Internal.Minecraft_)
        sayChatNow(arg0: Internal.Supplier_<Internal.Component>): void;
        sayNow(arg0: string): void;
        clear(): void;
        updateNarratorStatus(arg0: Internal.NarratorStatus_): void;
        destroy(): void;
        sayNow(arg0: Internal.Component_): void;
        isActive(): boolean;
        get active(): boolean
        static readonly NO_TITLE: Internal.MutableComponent;
        readonly narrator: Internal.Narrator;
    }
    type GameNarrator_ = GameNarrator;
    interface DispenserBlockAccessor {
        getDispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>;
        get dispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>
    }
    type DispenserBlockAccessor_ = DispenserBlockAccessor;
    class ImmutableSetMultimap$Builder <K, V> extends Internal.ImmutableMultimap$Builder<K, V> {
        constructor()
        orderKeysBy(arg0: Internal.Comparator_<any>): Internal.ImmutableMultimap$Builder<any, any>;
        build(): Internal.ImmutableSetMultimap<K, V>;
        put(arg0: any, arg1: any): Internal.ImmutableMultimap$Builder<any, any>;
        orderValuesBy(arg0: Internal.Comparator_<V>): this;
        putAll(arg0: Internal.Iterable_<any>): Internal.ImmutableMultimap$Builder<any, any>;
        putAll(arg0: any, arg1: Internal.Iterable_<any>): Internal.ImmutableMultimap$Builder<any, any>;
        putAll(arg0: Internal.Multimap_<any, any>): Internal.ImmutableMultimap$Builder<any, any>;
        put(arg0: Internal.Map$Entry_<any, any>): Internal.ImmutableMultimap$Builder<any, any>;
        putAll(arg0: any, arg1: any[]): Internal.ImmutableMultimap$Builder<any, any>;
    }
    type ImmutableSetMultimap$Builder_<K, V> = ImmutableSetMultimap$Builder<K, V>;
    interface Object2LongFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToLongFunction<K> {
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Object2FloatFunction<K>;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Object2ByteFunction<K>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        removeLong(arg0: any): number;
        put(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2LongFunction;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        containsKey(arg0: any): boolean;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2LongFunction;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2LongFunction;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        getLong(arg0: any): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2LongFunction<T>;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2LongFunction;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2LongFunction;
        applyAsLong(arg0: K): number;
        defaultReturnValue(): number;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Object2IntFunction<K>;
        apply(arg0: K): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2LongFunction;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        getOrDefault(arg0: any, arg1: number): number;
        size(): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2LongFunction<T>;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Object2ShortFunction<K>;
        clear(): void;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: number): void;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2LongFunction;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        (arg0: any): number;
    }
    type Object2LongFunction_<K> = Object2LongFunction<K>;
    class Vector3f {
        constructor()
        constructor(arg0: Vec3_)
        constructor(arg0: number[])
        constructor(arg0: Internal.Vector4f_)
        constructor(arg0: number, arg1: number, arg2: number)
        setX(arg0: number): void;
        rotation(arg0: number): Internal.Quaternion;
        transform(arg0: Internal.Quaternion_): void;
        normalize(): boolean;
        lerp(arg0: Internal.Vector3f_, arg1: number): void;
        cross(arg0: Internal.Vector3f_): void;
        add(arg0: Internal.Vector3f_): void;
        mul(arg0: number, arg1: number, arg2: number): void;
        map(arg0: Internal.Float2FloatFunction_): void;
        load(arg0: Internal.Vector3f_): void;
        copy(): this;
        setY(arg0: number): void;
        mul(arg0: number): void;
        setZ(arg0: number): void;
        y(): number;
        z(): number;
        set(arg0: number, arg1: number, arg2: number): void;
        x(): number;
        sub(arg0: Internal.Vector3f_): void;
        transform(arg0: com.mojang.math.Matrix3f_): void;
        add(arg0: number, arg1: number, arg2: number): void;
        rotationDegrees(arg0: number): Internal.Quaternion;
        set(arg0: number[]): void;
        clamp(arg0: number, arg1: number): void;
        dot(arg0: Internal.Vector3f_): number;
        clamp(arg0: Internal.Vector3f_, arg1: Internal.Vector3f_): void;
        set x(arg0: number)
        set y(arg0: number)
        set z(arg0: number)
        static ZERO: Internal.Vector3f;
        static XN: Internal.Vector3f;
        static ZP: Internal.Vector3f;
        static YP: Internal.Vector3f;
        static XP: Internal.Vector3f;
        static readonly CODEC: Internal.Codec<Internal.Vector3f>;
        static ZN: Internal.Vector3f;
        static YN: Internal.Vector3f;
    }
    type Vector3f_ = Vector3f;
    interface DoubleStream$Builder extends Internal.DoubleConsumer {
        add(arg0: number): this;
        accept(arg0: number): void;
        andThen(arg0: Internal.DoubleConsumer_): Internal.DoubleConsumer;
        build(): Internal.DoubleStream;
    }
    type DoubleStream$Builder_ = DoubleStream$Builder;
    class AnimatedHand extends Internal.Enum<Internal.AnimatedHand> {
        static valueOf(name: string): Internal.AnimatedHand;
        static values(): Internal.AnimatedHand[];
        static from(isOffHand: boolean, isTwoHanded: boolean): Internal.AnimatedHand;
        isOffHand(): boolean;
        get offHand(): boolean
        static readonly OFF_HAND: Internal.AnimatedHand;
        static readonly TWO_HANDED: Internal.AnimatedHand;
        static readonly MAIN_HAND: Internal.AnimatedHand;
    }
    type AnimatedHand_ = "main_hand" | "off_hand" | AnimatedHand | "two_handed";
    abstract class ResourceBundle {
        constructor()
        static getBundle(arg0: string, arg1: Internal.Locale_, arg2: Internal.ResourceBundle$Control_): Internal.ResourceBundle;
        containsKey(arg0: string): boolean;
        keySet(): Internal.Set<string>;
        static getBundle(arg0: string, arg1: Internal.Locale_, arg2: Internal.ClassLoader_): Internal.ResourceBundle;
        static getBundle(arg0: string, arg1: Internal.Locale_): Internal.ResourceBundle;
        getKeys(): Internal.Enumeration<string>;
        getBaseBundleName(): string;
        static getBundle(arg0: string, arg1: Internal.Locale_, arg2: Internal.Module_): Internal.ResourceBundle;
        static getBundle(arg0: string, arg1: Internal.Module_): Internal.ResourceBundle;
        static getBundle(arg0: string, arg1: Internal.Locale_, arg2: Internal.ClassLoader_, arg3: Internal.ResourceBundle$Control_): Internal.ResourceBundle;
        getLocale(): Internal.Locale;
        getObject(arg0: string): any;
        getString(arg0: string): string;
        static clearCache(arg0: Internal.ClassLoader_): void;
        static getBundle(arg0: string): Internal.ResourceBundle;
        getStringArray(arg0: string): string[];
        static clearCache(): void;
        static getBundle(arg0: string, arg1: Internal.ResourceBundle$Control_): Internal.ResourceBundle;
        get keys(): Internal.Enumeration<string>
        get baseBundleName(): string
        get locale(): Internal.Locale
    }
    type ResourceBundle_ = ResourceBundle;
    class Stray extends Internal.AbstractSkeleton implements Internal.IQuiverEntity {
        constructor(arg0: Internal.EntityType_<Internal.Stray>, arg1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        hasQuiver(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        equipped(arg0: Internal.ItemEntity_): boolean;
        getQuiver(): Internal.ItemStack;
        swing(): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        static isBlocked(entity: Internal.Entity_): boolean;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        static checkStraySpawnRules(arg0: Internal.EntityType_<Internal.Stray>, arg1: Internal.ServerLevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        setQuiver(quiver: Internal.ItemStack_): void;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get quiver(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set quiver(quiver: Internal.ItemStack_)
    }
    type Stray_ = Stray;
    class FossilFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor(arg0: Internal.List_<ResourceLocation>, arg1: Internal.List_<ResourceLocation>, arg2: Internal.Holder_<Internal.StructureProcessorList>, arg3: Internal.Holder_<Internal.StructureProcessorList>, arg4: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly overlayStructures: Internal.List<ResourceLocation>;
        readonly fossilStructures: Internal.List<ResourceLocation>;
        readonly maxEmptyCornersAllowed: number;
        readonly fossilProcessors: Internal.Holder<Internal.StructureProcessorList>;
        readonly overlayProcessors: Internal.Holder<Internal.StructureProcessorList>;
        static readonly CODEC: Internal.Codec<Internal.FossilFeatureConfiguration>;
    }
    type FossilFeatureConfiguration_ = FossilFeatureConfiguration;
    interface ByteList extends Internal.Comparable<Internal.List<number>>, Internal.List<number>, Internal.ByteCollection {
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        retainAll(arg0: Internal.ByteCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        addElements(arg0: number, arg1: number[]): void;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: any): void;
        addAll(arg0: Internal.ByteList_): boolean;
        of<E>(arg0: E): Internal.List<E>;
        addAll(arg0: number, arg1: Internal.ByteList_): boolean;
        getElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        replaceAll(arg0: Internal.ByteUnaryOperator_): void;
        intStream(): Internal.IntStream;
        removeIf(arg0: Internal.BytePredicate_): boolean;
        rem(arg0: number): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        intParallelStream(): Internal.IntStream;
        addElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        intIterator(): Internal.IntIterator;
        listIterator(): Internal.ListIterator<any>;
        removeByte(arg0: number): number;
        size(arg0: number): void;
        removeIf(arg0: Internal.IntPredicate_): boolean;
        removeAll(arg0: Internal.ByteCollection_): boolean;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<number>): void;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        /**
         * @deprecated
        */
        indexOf(arg0: any): number;
        toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        get(arg0: number): number;
        getByte(arg0: number): number;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        forEach(arg0: Internal.ByteConsumer_): void;
        listIterator(arg0: number): Internal.ByteListIterator;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        addAll(arg0: Internal.Collection_<number>): boolean;
        toByteArray(): number[];
        of<E>(arg0: E, arg1: E): Internal.List<E>;
        spliterator(): Internal.Spliterator<any>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: number): number;
        of(...arg0: number[]): this;
        of(): this;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<number>): void;
        lastIndexOf(arg0: number): number;
        add(arg0: number): boolean;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: any): any;
        addAll(arg0: number, arg1: Internal.Collection_<number>): boolean;
        /**
         * @deprecated
        */
        toByteArray(arg0: number[]): number[];
        /**
         * @deprecated
        */
        lastIndexOf(arg0: any): number;
        removeElements(arg0: number, arg1: number): void;
        containsAll(arg0: Internal.ByteCollection_): boolean;
        /**
         * @deprecated
        */
        remove(arg0: number): any;
        /**
         * @deprecated
        */
        unstableSort(arg0: Internal.Comparator_<number>): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        setElements(arg0: number[]): void;
        indexOf(arg0: number): number;
        isEmpty(): boolean;
        of(arg0: number, arg1: number, arg2: number): this;
        forEach(arg0: Internal.IntConsumer_): void;
        of<E>(...arg0: E[]): Internal.List<E>;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        setElements(arg0: number, arg1: number[]): void;
        unstableSort(arg0: Internal.ByteComparator_): void;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        compareTo(arg0: Internal.List_<number>): number;
        toArray(arg0: number[]): number[];
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        add(arg0: number, arg1: number): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        contains(arg0: number): boolean;
        set(arg0: number, arg1: number): number;
        iterator(): Internal.Iterator<any>;
        sort(arg0: Internal.ByteComparator_): void;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        setElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        replaceAll(arg0: Internal.IntUnaryOperator_): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        toArray(): any[];
        addAll(arg0: number, arg1: Internal.ByteCollection_): boolean;
        intSpliterator(): Internal.IntSpliterator;
        subList(arg0: number, arg1: number): Internal.List<any>;
        of(arg0: number, arg1: number): this;
        hashCode(): number;
        size(): number;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: number): void;
        addAll(arg0: Internal.ByteCollection_): boolean;
        clear(): void;
        of(arg0: number): this;
        equals(arg0: any): boolean;
        set elements(arg0: number[])
        get empty(): boolean
    }
    type ByteList_ = ByteList;
    interface FloatStack extends it.unimi.dsi.fastutil.Stack<number> {
        topFloat(): number;
        push(arg0: number): void;
        /**
         * @deprecated
        */
        top(): any;
        /**
         * @deprecated
        */
        peek(arg0: number): any;
        isEmpty(): boolean;
        /**
         * @deprecated
        */
        push(arg0: number): void;
        /**
         * @deprecated
        */
        push(arg0: any): void;
        /**
         * @deprecated
        */
        pop(): number;
        popFloat(): number;
        peekFloat(arg0: number): number;
        get empty(): boolean
    }
    type FloatStack_ = FloatStack;
    class AtlasSpriteRegistryEventJS extends Internal.EventJS {
        constructor(registry: Internal.Consumer_<ResourceLocation>)
        register(id: ResourceLocation_): void;
    }
    type AtlasSpriteRegistryEventJS_ = AtlasSpriteRegistryEventJS;
    abstract class AmbientCreature extends Internal.Mob {
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        equipped(arg0: Internal.ItemEntity_): boolean;
        swing(): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        static isBlocked(entity: Internal.Entity_): boolean;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type AmbientCreature_ = AmbientCreature;
    class EndIslandFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(arg0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type EndIslandFeature_ = EndIslandFeature;
    class IngredientActionFilter {
        constructor()
        static filterOf(o: any): Internal.IngredientActionFilter;
        copyFrom(filter: Internal.IngredientActionFilter_): void;
        checkFilter(index: number, stack: Internal.ItemStack_): boolean;
        filterIngredient: Internal.Ingredient;
        filterIndex: number;
    }
    type IngredientActionFilter_ = number | Internal.Ingredient_ | IngredientActionFilter | {item: Internal.Ingredient_, index?: number};
    interface ObjectList <K> extends Internal.ObjectCollection<K>, Internal.List<K>, Internal.Comparable<Internal.List<K>> {
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        addAll(arg0: Internal.Collection_<K>): boolean;
        setElements(arg0: number, arg1: K[]): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        set(arg0: number, arg1: K): K;
        iterator(): Internal.ObjectIterator<any>;
        parallelStream(): Internal.Stream<K>;
        addAll(arg0: number, arg1: Internal.Collection_<K>): boolean;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        addElements(arg0: number, arg1: K[], arg2: number, arg3: number): void;
        of<K>(): this;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        setElements(arg0: K[]): void;
        of<K>(...arg0: K[]): this;
        listIterator(): Internal.ListIterator<any>;
        size(arg0: number): void;
        remove(arg0: number): K;
        of<K>(arg0: K, arg1: K, arg2: K): this;
        indexOf(arg0: any): number;
        toArray<T>(arg0: T[]): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        remove(arg0: any): boolean;
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        spliterator(): Internal.Spliterator<any>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        add(arg0: K): boolean;
        lastIndexOf(arg0: any): number;
        setElements(arg0: number, arg1: K[], arg2: number, arg3: number): void;
        removeElements(arg0: number, arg1: number): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        isEmpty(): boolean;
        listIterator(arg0: number): Internal.ListIterator<any>;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        addElements(arg0: number, arg1: K[]): void;
        of<K>(arg0: K): this;
        get(arg0: number): K;
        contains(arg0: any): boolean;
        addAll(arg0: number, arg1: Internal.ObjectList_<K>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        add(arg0: number, arg1: K): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        toArray(): any[];
        replaceAll(arg0: Internal.UnaryOperator_<K>): void;
        of<K>(arg0: K, arg1: K): this;
        subList(arg0: number, arg1: number): Internal.List<any>;
        unstableSort(arg0: Internal.Comparator_<K>): void;
        addAll(arg0: Internal.ObjectList_<K>): boolean;
        hashCode(): number;
        size(): number;
        compareTo(arg0: Internal.List_<K>): number;
        sort(arg0: Internal.Comparator_<K>): void;
        clear(): void;
        equals(arg0: any): boolean;
        stream(): Internal.Stream<K>;
        getElements(arg0: number, arg1: any[], arg2: number, arg3: number): void;
        set elements(arg0: K[])
        get empty(): boolean
    }
    type ObjectList_<K> = ObjectList<K>;
    interface IDataManager {
        clean(): void;
        getEntries(arg0: boolean): Internal.Set<Internal.IDataManager$DataEntry<any>>;
        getDataMap(): Internal.Map<Internal.TrackedData<any>, Internal.IDataManager$DataEntry<any>>;
        getValue<T>(arg0: Internal.TrackedData_<T>): T;
        setDataMap(arg0: Internal.Map_<Internal.TrackedData<any>, Internal.IDataManager$DataEntry<any>>): void;
        isDirty(): boolean;
        getDirtyEntries(): Internal.Set<Internal.IDataManager$DataEntry<any>>;
        setValue<T>(arg0: Internal.TrackedData_<T>, arg1: T): void;
        get dataMap(): Internal.Map<Internal.TrackedData<any>, Internal.IDataManager$DataEntry<any>>
        set dataMap(arg0: Internal.Map_<Internal.TrackedData<any>, Internal.IDataManager$DataEntry<any>>)
        get dirty(): boolean
        get dirtyEntries(): Internal.Set<Internal.IDataManager$DataEntry<any>>
    }
    type IDataManager_ = IDataManager;
    interface ArtifactRepositoryLayout {
        pathOfRemoteRepositoryMetadata(arg0: org.apache.maven.artifact.metadata.ArtifactMetadata_): string;
        pathOfLocalRepositoryMetadata(arg0: org.apache.maven.artifact.metadata.ArtifactMetadata_, arg1: Internal.ArtifactRepository_): string;
        pathOf(arg0: Internal.Artifact_): string;
        getId(): string;
        get id(): string
        readonly ROLE: "org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout";
    }
    type ArtifactRepositoryLayout_ = ArtifactRepositoryLayout;
    interface LongStream extends Internal.BaseStream<number, Internal.LongStream> {
        parallel(): this;
        allMatch(arg0: Internal.LongPredicate_): boolean;
        isParallel(): boolean;
        sum(): number;
        toArray(): number[];
        forEach(arg0: Internal.LongConsumer_): void;
        max(): Internal.OptionalLong;
        count(): number;
        iterate(arg0: number, arg1: Internal.LongUnaryOperator_): this;
        of(arg0: number): this;
        empty(): this;
        distinct(): this;
        flatMap(arg0: Internal.LongFunction_<Internal.LongStream>): this;
        min(): Internal.OptionalLong;
        mapToDouble(arg0: Internal.LongToDoubleFunction_): Internal.DoubleStream;
        findFirst(): Internal.OptionalLong;
        reduce(arg0: Internal.LongBinaryOperator_): Internal.OptionalLong;
        boxed(): Internal.Stream<number>;
        reduce(arg0: number, arg1: Internal.LongBinaryOperator_): number;
        generate(arg0: Internal.LongSupplier_): this;
        builder(): Internal.LongStream$Builder;
        limit(arg0: number): this;
        mapMulti(arg0: Internal.LongStream$LongMapMultiConsumer_): this;
        mapToObj<U>(arg0: Internal.LongFunction_<U>): Internal.Stream<U>;
        range(arg0: number, arg1: number): this;
        rangeClosed(arg0: number, arg1: number): this;
        onClose(arg0: Internal.Runnable_): this;
        sequential(): Internal.BaseStream<any, any>;
        peek(arg0: Internal.LongConsumer_): this;
        sorted(): this;
        summaryStatistics(): Internal.LongSummaryStatistics;
        of(...arg0: number[]): this;
        anyMatch(arg0: Internal.LongPredicate_): boolean;
        iterator(): Internal.Iterator<any>;
        findAny(): Internal.OptionalLong;
        skip(arg0: number): this;
        map(arg0: Internal.LongUnaryOperator_): this;
        spliterator(): Internal.Spliterator$OfLong;
        takeWhile(arg0: Internal.LongPredicate_): this;
        asDoubleStream(): Internal.DoubleStream;
        iterate(arg0: number, arg1: Internal.LongPredicate_, arg2: Internal.LongUnaryOperator_): this;
        filter(arg0: Internal.LongPredicate_): this;
        unordered(): this;
        forEachOrdered(arg0: Internal.LongConsumer_): void;
        close(): void;
        dropWhile(arg0: Internal.LongPredicate_): this;
        noneMatch(arg0: Internal.LongPredicate_): boolean;
        mapToInt(arg0: Internal.LongToIntFunction_): Internal.IntStream;
        concat(arg0: Internal.LongStream_, arg1: Internal.LongStream_): this;
        average(): Internal.OptionalDouble;
        collect<R>(arg0: Internal.Supplier_<R>, arg1: Internal.ObjLongConsumer_<R>, arg2: Internal.BiConsumer_<R, R>): R;
        get parallel(): boolean
    }
    type LongStream_ = LongStream;
    class Properties extends Internal.Hashtable<any, any> {
        constructor()
        constructor(arg0: number)
        constructor(arg0: Internal.Properties_)
        store(arg0: Internal.OutputStream_, arg1: string): void;
        storeToXML(arg0: Internal.OutputStream_, arg1: string, arg2: Internal.Charset_): void;
        /**
         * @deprecated
        */
        save(arg0: Internal.OutputStream_, arg1: string): void;
        stringPropertyNames(): Internal.Set<string>;
        storeToXML(arg0: Internal.OutputStream_, arg1: string): void;
        getOrDefault(arg0: any, arg1: any): any;
        static of<K, V>(): Internal.Map<K, V>;
        list(arg0: Internal.PrintWriter_): void;
        getProperty(arg0: string, arg1: string): string;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        keys(): Internal.Enumeration<any>;
        keySet(): Internal.Set<any>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        setProperty(arg0: string, arg1: string): any;
        store(arg0: Internal.Writer_, arg1: string): void;
        put(arg0: any, arg1: any): any;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        load(arg0: Internal.Reader_): void;
        load(arg0: Internal.InputStream_): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        loadFromXML(arg0: Internal.InputStream_): void;
        computeIfAbsent(arg0: any, arg1: Internal.Function_<any, any>): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        propertyNames(): Internal.Enumeration<any>;
        list(arg0: Internal.PrintStream_): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        elements(): Internal.Enumeration<any>;
        entrySet(): Internal.Set<Internal.Map$Entry<any, any>>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        getProperty(arg0: string): string;
        replace(arg0: any, arg1: any): any;
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        remove(arg0: any): any;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        get(arg0: any): any;
        compute(arg0: any, arg1: Internal.BiFunction_<any, any, any>): any;
        storeToXML(arg0: Internal.OutputStream_, arg1: string, arg2: string): void;
        computeIfPresent(arg0: any, arg1: Internal.BiFunction_<any, any, any>): any;
        putIfAbsent(arg0: any, arg1: any): any;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type Properties_ = Properties;
    interface Executor {
        execute(arg0: Internal.Runnable_): void;
    }
    type Executor_ = Executor;
    abstract class AbstractDragonSittingPhase extends Internal.AbstractDragonPhaseInstance {
        constructor(arg0: Internal.EnderDragon_)
        handler$bpf000$sittingPhaseMixin(arg0: DamageSource_, arg1: number, arg2: Internal.CallbackInfoReturnable_<any>): void;
    }
    type AbstractDragonSittingPhase_ = AbstractDragonSittingPhase;
    interface ByteProcessor {
        process(arg0: number): boolean;
        readonly FIND_NUL: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_LINEAR_WHITESPACE: Internal.ByteProcessor;
        readonly FIND_CRLF: Internal.ByteProcessor;
        readonly FIND_SEMI_COLON: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_NON_CR: Internal.ByteProcessor$IndexNotOfProcessor;
        readonly FIND_LF: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_CR: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_NON_LF: Internal.ByteProcessor$IndexNotOfProcessor;
        readonly FIND_NON_NUL: Internal.ByteProcessor$IndexNotOfProcessor;
        readonly FIND_ASCII_SPACE: Internal.ByteProcessor$IndexOfProcessor;
        readonly FIND_NON_LINEAR_WHITESPACE: Internal.ByteProcessor;
        readonly FIND_NON_CRLF: Internal.ByteProcessor;
        readonly FIND_COMMA: Internal.ByteProcessor$IndexOfProcessor;
    }
    type ByteProcessor_ = ByteProcessor;
    class SculkCatalystBlock extends Internal.BaseEntityBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        static bloom(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.RandomSource_): void;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly PULSE_TICKS: 8;
        static readonly PULSE: Internal.BooleanProperty;
    }
    type SculkCatalystBlock_ = SculkCatalystBlock;
    class MapRegion extends Internal.LeveledRegion<Internal.LeafRegionTexture> implements Internal.MapRegionInfo {
        constructor(arg0: string, arg1: string, arg2: string, arg3: Internal.MapDimension_, arg4: number, arg5: number, arg6: number, arg7: number, arg8: boolean, arg9: Internal.Registry_<Internal.Biome>)
        setOutdatedWithOtherLayers(arg0: boolean): void;
        cancelRefresh(arg0: Internal.MapProcessor_): void;
        getDimId(): string;
        isResting(): boolean;
        destroyBufferUpdateObjects(): void;
        caveStartOutdated(arg0: number, arg1: number): boolean;
        requestRefresh(arg0: Internal.MapProcessor_, arg1: boolean): void;
        shouldConvertCacheToOutdatedOnFinishDim(): boolean;
        getInitialVersion(): number;
        getTargetHighlightsHash(): number;
        setVersion(arg0: number): void;
        getMwId(): string;
        setHighlightsHash(arg0: number): void;
        getLoadState(): number;
        setBeingWritten(arg0: boolean): void;
        setChunk(arg0: number, arg1: number, arg2: Internal.MapTileChunk_): void;
        getHighlightsHash(): number;
        getLastVisited(): number;
        updateTargetHighlightsHash(): void;
        convertCacheToOutdated(arg0: Internal.MapSaveLoad_, arg1: string): void;
        isBeingWritten(): boolean;
        isWritingPaused(): boolean;
        getLastSaveTime(): number;
        createTexture(arg0: number, arg1: number): Internal.LeafRegionTexture;
        popWriterPause(): void;
        isRefreshing(): boolean;
        setLastSaveTime(arg0: number): void;
        hasHadTerrain(): boolean;
        isOutdatedWithOtherLayers(): boolean;
        getVersion(): number;
        pushWriterPause(): void;
        getSaveExists(): boolean;
        getReloadVersion(): number;
        countChunks(): number;
        getCaveStart(): number;
        setSaveExists(arg0: boolean): void;
        getWorldId(): string;
        getChunk(arg0: number, arg1: number): Internal.MapTileChunk;
        requestRefresh(arg0: Internal.MapProcessor_): void;
        registerVisit(): void;
        setReloadVersion(arg0: number): void;
        getMutableGlobalPos(): Internal.BlockPos$MutableBlockPos;
        setRefreshing(arg0: boolean): void;
        getUpToDateCaveStart(): number;
        setLookedForCache(arg0: boolean): void;
        getRegionFile(): Internal.File;
        hasVersion(): boolean;
        restoreMetaData(arg0: number[][], arg1: number, arg2: number, arg3: number, arg4: number, arg5: boolean, arg6: Internal.MapProcessor_): void;
        getPixelResultBuffer(): number[];
        clearRegion(arg0: Internal.MapProcessor_): void;
        clean(arg0: Internal.MapProcessor_): void;
        setParent(arg0: Internal.BranchLeveledRegion_): void;
        getCaveDepth(): number;
        getCacheHashCode(): number;
        putTexture(arg0: number, arg1: number, arg2: Internal.LeafRegionTexture_): void;
        hasLookedForCache(): boolean;
        updateCaveMode(): void;
        getTexture(arg0: number, arg1: number): Internal.LeafRegionTexture;
        getBiomeRegistry(): Internal.Registry<Internal.Biome>;
        setRegionFile(arg0: Internal.File_): void;
        setCaveStart(arg0: number): void;
        restoreBufferUpdateObjects(): void;
        isMultiplayer(): boolean;
        setInitialVersion(arg0: number): void;
        setCacheHashCode(arg0: number): void;
        setLoadState(arg0: number): void;
        unsetHasHadTerrain(): void;
        setHasHadTerrain(): void;
        getTimeSinceVisit(): number;
        set outdatedWithOtherLayers(arg0: boolean)
        get dimId(): string
        get resting(): boolean
        get initialVersion(): number
        get targetHighlightsHash(): number
        set version(arg0: number)
        get mwId(): string
        set highlightsHash(arg0: number)
        get loadState(): number
        set beingWritten(arg0: boolean)
        get highlightsHash(): number
        get lastVisited(): number
        get beingWritten(): boolean
        get writingPaused(): boolean
        get lastSaveTime(): number
        get refreshing(): boolean
        set lastSaveTime(arg0: number)
        get outdatedWithOtherLayers(): boolean
        get version(): number
        get saveExists(): boolean
        get reloadVersion(): number
        get caveStart(): number
        set saveExists(arg0: boolean)
        get worldId(): string
        set reloadVersion(arg0: number)
        get mutableGlobalPos(): Internal.BlockPos$MutableBlockPos
        set refreshing(arg0: boolean)
        get upToDateCaveStart(): number
        set lookedForCache(arg0: boolean)
        get regionFile(): Internal.File
        get pixelResultBuffer(): number[]
        set parent(arg0: Internal.BranchLeveledRegion_)
        get caveDepth(): number
        get cacheHashCode(): number
        get biomeRegistry(): Internal.Registry<Internal.Biome>
        set regionFile(arg0: Internal.File_)
        set caveStart(arg0: number)
        get multiplayer(): boolean
        set initialVersion(arg0: number)
        set cacheHashCode(arg0: number)
        set loadState(arg0: number)
        get timeSinceVisit(): number
        readonly writerThreadPauseSync: any;
        static readonly SIDE_LENGTH: 8;
        loadingPrioritized: boolean;
        loadingNeededForBranchLevel: number;
    }
    type MapRegion_ = MapRegion;
    class Vector4f {
        constructor()
        constructor(arg0: Internal.Vector3f_)
        constructor(arg0: number, arg1: number, arg2: number, arg3: number)
        y(): number;
        setW(arg0: number): void;
        z(): number;
        setX(arg0: number): void;
        w(): number;
        x(): number;
        transform(arg0: com.mojang.math.Matrix4f_): void;
        transform(arg0: Internal.Quaternion_): void;
        normalize(): boolean;
        lerp(arg0: Internal.Vector4f_, arg1: number): void;
        set(arg0: number[]): void;
        dot(arg0: Internal.Vector4f_): number;
        set(arg0: number, arg1: number, arg2: number, arg3: number): void;
        perspectiveDivide(): void;
        mul(arg0: Internal.Vector3f_): void;
        setY(arg0: number): void;
        add(arg0: number, arg1: number, arg2: number, arg3: number): void;
        setZ(arg0: number): void;
        mul(arg0: number): void;
        set w(arg0: number)
        set x(arg0: number)
        set y(arg0: number)
        set z(arg0: number)
    }
    type Vector4f_ = Vector4f;
    class LifeCycle$State extends Internal.Enum<Internal.LifeCycle$State> {
        static valueOf(name: string): Internal.LifeCycle$State;
        static values(): Internal.LifeCycle$State[];
        static readonly STARTED: Internal.LifeCycle$State;
        static readonly STOPPED: Internal.LifeCycle$State;
        static readonly STARTING: Internal.LifeCycle$State;
        static readonly STOPPING: Internal.LifeCycle$State;
        static readonly INITIALIZED: Internal.LifeCycle$State;
        static readonly INITIALIZING: Internal.LifeCycle$State;
    }
    type LifeCycle$State_ = "started" | "starting" | "initializing" | "stopping" | "stopped" | "initialized" | LifeCycle$State;
    class SynchedEntityData {
        constructor(arg0: Internal.Entity_)
        clearDirty(): void;
        get<T>(arg0: Internal.EntityDataAccessor_<T>): T;
        set<T>(arg0: Internal.EntityDataAccessor_<T>, arg1: T): void;
        packDirty(): Internal.List<Internal.SynchedEntityData$DataItem<any>>;
        static defineId<T>(arg0: typeof Internal.Entity, arg1: Internal.EntityDataSerializer_<T>): Internal.EntityDataAccessor<T>;
        isDirty(): boolean;
        getAll(): Internal.List<Internal.SynchedEntityData$DataItem<any>>;
        isEmpty(): boolean;
        assignValues(arg0: Internal.List_<Internal.SynchedEntityData$DataItem<any>>): void;
        static unpack(arg0: Internal.FriendlyByteBuf_): Internal.List<Internal.SynchedEntityData$DataItem<any>>;
        define<T>(arg0: Internal.EntityDataAccessor_<T>, arg1: T): void;
        static pack(arg0: Internal.List_<Internal.SynchedEntityData$DataItem<any>>, arg1: Internal.FriendlyByteBuf_): void;
        get dirty(): boolean
        get all(): Internal.List<Internal.SynchedEntityData$DataItem<any>>
        get empty(): boolean
        readonly lock: Internal.ReadWriteLock;
        static readonly ENTITY_ID_POOL: {[key: typeof any]: 20, [key: typeof any]: 22, [key: typeof any]: 23, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 25, [key: typeof any]: 19, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 23, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 25, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 22, [key: typeof any]: 25, [key: typeof any]: 29, [key: typeof any]: 20, [key: typeof any]: 8, [key: typeof any]: 22, [key: typeof any]: 27, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 23, [key: typeof any]: 23, [key: typeof any]: 23, [key: typeof any]: 20, [key: typeof any]: 30, [key: typeof any]: 23, [key: typeof any]: 25, [key: typeof any]: 26, [key: typeof any]: 22, [key: typeof any]: 25, [key: typeof any]: 27, [key: typeof any]: 19, [key: typeof any]: 20, [key: typeof any]: 26, [key: typeof any]: 25, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 24, [key: typeof any]: 26, [key: typeof any]: 22, [key: typeof any]: 11, [key: typeof any]: 21, [key: typeof any]: 25, [key: typeof any]: 23, [key: typeof any]: 25, [key: typeof any]: 24, [key: typeof any]: 26, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 27, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 22, [key: typeof any]: 8, [key: typeof any]: 25, [key: typeof any]: 22, [key: typeof any]: 24, [key: typeof any]: 24, [key: typeof any]: 22, [key: typeof any]: 8, [key: typeof any]: 21, [key: typeof any]: 26, [key: typeof any]: 20, [key: typeof any]: 23, [key: typeof any]: 8, [key: typeof any]: 26, [key: typeof any]: 20, [key: typeof any]: 23, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 8, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 22, [key: typeof any]: 27, [key: typeof any]: 20, [key: typeof any]: 22, [key: typeof any]: 14, [key: typeof any]: 20, [key: typeof any]: 11, [key: typeof any]: 22, [key: typeof any]: 20, [key: typeof any]: 24, [key: typeof any]: 20, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 24, [key: typeof any]: 8, [key: typeof any]: 24, [key: typeof any]: 14, [key: typeof any]: 28, [key: typeof any]: 26, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 23, [key: typeof any]: 21, [key: typeof any]: 26, [key: typeof any]: 23, [key: typeof any]: 24, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 29, [key: typeof any]: 28, [key: typeof any]: 35, [key: typeof any]: 22, [key: typeof any]: 23, [key: typeof any]: 28, [key: typeof any]: 28, [key: typeof any]: 30, [key: typeof any]: 24, [key: typeof any]: 23, [key: typeof any]: 22, [key: typeof any]: 25, [key: typeof any]: 20, [key: typeof any]: 20, [key: typeof any]: 29, [key: typeof any]: 22, [key: typeof any]: 23, [key: typeof any]: 26, [key: typeof any]: 25, [key: typeof any]: 32, [key: typeof any]: 22, [key: typeof any]: 20, [key: typeof any]: 24, [key: typeof any]: 20, [key: typeof any]: 24, [key: typeof any]: 26, [key: typeof any]: 21, [key: typeof any]: 18, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 20, [key: typeof any]: 24, [key: typeof any]: 21, [key: typeof any]: 9, [key: typeof any]: 23, [key: typeof any]: 20, [key: typeof any]: 11, [key: typeof any]: 14, [key: typeof any]: 10, [key: typeof any]: 22, [key: typeof any]: 20, [key: typeof any]: 20, [key: typeof any]: 22, [key: typeof any]: 10, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 26, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 30, [key: typeof any]: 31, [key: typeof any]: 28, [key: typeof any]: 22, [key: typeof any]: 24, [key: typeof any]: 31, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 28, [key: typeof any]: 24, [key: typeof any]: 20, [key: typeof any]: 25, [key: typeof any]: 24, [key: typeof any]: 25, [key: typeof any]: 25, [key: typeof any]: 27, [key: typeof any]: 24, [key: typeof any]: 22, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 22, [key: typeof any]: 24, [key: typeof any]: 21, [key: typeof any]: 9, [key: typeof any]: 40, [key: typeof any]: 23, [key: typeof any]: 34, [key: typeof any]: 24, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 24, [key: typeof any]: 24, [key: typeof any]: 23, [key: typeof any]: 28, [key: typeof any]: 22, [key: typeof any]: 25, [key: typeof any]: 23, [key: typeof any]: 27, [key: typeof any]: 8, [key: typeof any]: 21, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 22, [key: typeof any]: 20, [key: typeof any]: 20, [key: typeof any]: 8, [key: typeof any]: 25, [key: typeof any]: 23, [key: typeof any]: 21, [key: typeof any]: 25, [key: typeof any]: 22, [key: typeof any]: 26, [key: typeof any]: 26, [key: typeof any]: 7, [key: typeof any]: 22, [key: typeof any]: 27, [key: typeof any]: 22, [key: typeof any]: 29, [key: typeof any]: 24, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 29, [key: typeof any]: 21, [key: typeof any]: 25, [key: typeof any]: 20, [key: typeof any]: 20, [key: typeof any]: 24, [key: typeof any]: 9, [key: typeof any]: 11, [key: typeof any]: 22, [key: typeof any]: 23, [key: typeof any]: 21, [key: typeof any]: 25, [key: typeof any]: 21, [key: typeof any]: 22, [key: typeof any]: 9, [key: typeof any]: 27, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 24, [key: typeof any]: 21, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 8, [key: typeof any]: 28, [key: typeof any]: 20, [key: typeof any]: 24, [key: typeof any]: 15, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 13, [key: typeof any]: 20, [key: typeof any]: 20, [key: typeof any]: 24, [key: typeof any]: 20, [key: typeof any]: 27, [key: typeof any]: 26, [key: typeof any]: 9, [key: typeof any]: 23, [key: typeof any]: 26, [key: typeof any]: 20, [key: typeof any]: 20, [key: typeof any]: 22, [key: typeof any]: 23, [key: typeof any]: 22, [key: typeof any]: 23, [key: typeof any]: 21, [key: typeof any]: 24, [key: typeof any]: 24, [key: typeof any]: 21, [key: typeof any]: 20, [key: typeof any]: 26, [key: typeof any]: 21, [key: typeof any]: 22, [key: typeof any]: 20, [key: typeof any]: 27, [key: typeof any]: 22, [key: typeof any]: 21, [key: typeof any]: 23, [key: typeof any]: 25, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 27, [key: typeof any]: 20, [key: typeof any]: 23, [key: typeof any]: 22, [key: typeof any]: 23, [key: typeof any]: 21, [key: typeof any]: 26, [key: typeof any]: 22, [key: typeof any]: 27, [key: typeof any]: 20, [key: typeof any]: 21, [key: typeof any]: 22, [key: typeof any]: 28, [key: typeof any]: 20, [key: typeof any]: 22, [key: typeof any]: 26, [key: typeof any]: 25, [key: typeof any]: 20};
        readonly itemsById: Internal.Int2ObjectMap<Internal.SynchedEntityData$DataItem<any>>;
    }
    type SynchedEntityData_ = SynchedEntityData;
    class ColorSpace$RenderIntent extends Internal.Enum<Internal.ColorSpace$RenderIntent> {
        static values(): Internal.ColorSpace$RenderIntent[];
        static valueOf(name: string): Internal.ColorSpace$RenderIntent;
        static readonly SATURATION: Internal.ColorSpace$RenderIntent;
        static readonly PERCEPTUAL: Internal.ColorSpace$RenderIntent;
        static readonly ABSOLUTE: Internal.ColorSpace$RenderIntent;
        static readonly RELATIVE: Internal.ColorSpace$RenderIntent;
    }
    type ColorSpace$RenderIntent_ = ColorSpace$RenderIntent | "absolute" | "perceptual" | "relative" | "saturation";
    class MultifaceSpreader {
        constructor(arg0: Internal.MultifaceBlock_)
        constructor(arg0: any_)
        canSpreadInAnyDirection(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        spreadAll(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: boolean): number;
        spreadFromFaceTowardDirection(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.Direction_, arg5: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        getSpreadFromFaceTowardDirection(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.Direction_, arg5: Internal.MultifaceSpreader$SpreadPredicate_): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadFromRandomFaceTowardRandomDirection(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.RandomSource_): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadFromFaceTowardRandomDirection(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.RandomSource_, arg5: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadToFace(arg0: Internal.LevelAccessor_, arg1: Internal.MultifaceSpreader$SpreadPos_, arg2: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        static readonly DEFAULT_SPREAD_ORDER: any[];
    }
    type MultifaceSpreader_ = MultifaceSpreader;
    class ChronoUnit extends Internal.Enum<Internal.ChronoUnit> implements Internal.TemporalUnit {
        between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): number;
        isTimeBased(): boolean;
        static valueOf(arg0: string): Internal.ChronoUnit;
        addTo<R extends Internal.Temporal>(arg0: R, arg1: number): R;
        getDuration(): Duration;
        isDateBased(): boolean;
        isSupportedBy(arg0: Internal.Temporal_): boolean;
        isDurationEstimated(): boolean;
        static values(): Internal.ChronoUnit[];
        get timeBased(): boolean
        get duration(): Duration
        get dateBased(): boolean
        get durationEstimated(): boolean
        static readonly NANOS: Internal.ChronoUnit;
        static readonly ERAS: Internal.ChronoUnit;
        static readonly MINUTES: Internal.ChronoUnit;
        static readonly HOURS: Internal.ChronoUnit;
        static readonly MONTHS: Internal.ChronoUnit;
        static readonly HALF_DAYS: Internal.ChronoUnit;
        static readonly MILLIS: Internal.ChronoUnit;
        static readonly DAYS: Internal.ChronoUnit;
        static readonly SECONDS: Internal.ChronoUnit;
        static readonly WEEKS: Internal.ChronoUnit;
        static readonly MILLENNIA: Internal.ChronoUnit;
        static readonly DECADES: Internal.ChronoUnit;
        static readonly MICROS: Internal.ChronoUnit;
        static readonly FOREVER: Internal.ChronoUnit;
        static readonly CENTURIES: Internal.ChronoUnit;
        static readonly YEARS: Internal.ChronoUnit;
    }
    type ChronoUnit_ = "minutes" | "years" | "weeks" | "decades" | "eras" | "half_days" | "centuries" | "hours" | "forever" | "months" | "millennia" | "micros" | "nanos" | "seconds" | "days" | "millis" | ChronoUnit;
    class TickEvent$RenderTickEvent extends Internal.TickEvent {
        constructor()
        constructor(arg0: Internal.TickEvent$Phase_, arg1: number)
        readonly renderTickTime: number;
    }
    type TickEvent$RenderTickEvent_ = TickEvent$RenderTickEvent;
    interface ChunkScanAccess {
        scanChunk(arg0: Internal.ChunkPos_, arg1: Internal.StreamTagVisitor_): Internal.CompletableFuture<void>;
    }
    type ChunkScanAccess_ = ChunkScanAccess;
    interface FragmentManager$OnBackStackChangedListener {
        onBackStackChanged(): void;
        (): void;
    }
    type FragmentManager$OnBackStackChangedListener_ = FragmentManager$OnBackStackChangedListener;
    class EventJS {
        constructor()
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(value: any): any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(): any;
        /**
         * Cancels the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(value: any): any;
        /**
         * Cancels the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(): any;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(value: any): any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(): any;
    }
    type EventJS_ = EventJS;
    class Frustum$Visibility extends Internal.Enum<Internal.Frustum$Visibility> {
        static values(): Internal.Frustum$Visibility[];
        static valueOf(name: string): Internal.Frustum$Visibility;
        static readonly OUTSIDE: Internal.Frustum$Visibility;
        static readonly INSIDE: Internal.Frustum$Visibility;
        static readonly INTERSECT: Internal.Frustum$Visibility;
    }
    type Frustum$Visibility_ = "intersect" | "outside" | "inside" | Frustum$Visibility;
    abstract class LongBuffer extends Internal.Buffer implements Internal.Comparable<Internal.LongBuffer> {
        limit(arg0: number): this;
        compareTo(arg0: any): number;
        get(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        duplicate(): this;
        order(): Internal.ByteOrder;
        mismatch(arg0: Internal.LongBuffer_): number;
        compareTo(arg0: Internal.LongBuffer_): number;
        static wrap(arg0: number[], arg1: number, arg2: number): Internal.LongBuffer;
        put(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        put(arg0: number, arg1: number): this;
        static allocate(arg0: number): Internal.LongBuffer;
        put(arg0: number, arg1: number[]): this;
        get(arg0: number, arg1: number[]): this;
        get(): number;
        get(arg0: number[]): this;
        position(arg0: number): this;
        put(arg0: number[]): this;
        put(arg0: number): this;
        asReadOnlyBuffer(): this;
        put(arg0: number[], arg1: number, arg2: number): this;
        static wrap(arg0: number[]): Internal.LongBuffer;
        put(arg0: Internal.LongBuffer_): this;
        put(arg0: number, arg1: Internal.LongBuffer_, arg2: number, arg3: number): this;
        get(arg0: number): number;
        array(): number[];
        get(arg0: number[], arg1: number, arg2: number): this;
        compact(): this;
    }
    type LongBuffer_ = LongBuffer;
    class ModFileScanData {
        constructor()
        static interestingAnnotations(): Internal.Predicate<org.objectweb.asm.Type>;
        getAnnotations(): Internal.Set<Internal.ModFileScanData$AnnotationData>;
        getClasses(): Internal.Set<Internal.ModFileScanData$ClassData>;
        getTargets(): Internal.Map<string, Internal.IModLanguageProvider$IModLanguageLoader>;
        addLanguageLoader(arg0: Internal.Map_<string, Internal.IModLanguageProvider$IModLanguageLoader>): void;
        getIModInfoData(): Internal.List<Internal.IModFileInfo>;
        addModFileInfo(arg0: Internal.IModFileInfo_): void;
        get annotations(): Internal.Set<Internal.ModFileScanData$AnnotationData>
        get classes(): Internal.Set<Internal.ModFileScanData$ClassData>
        get targets(): Internal.Map<string, Internal.IModLanguageProvider$IModLanguageLoader>
        get IModInfoData(): Internal.List<Internal.IModFileInfo>
    }
    type ModFileScanData_ = ModFileScanData;
    interface BrewingStandContainerAccess {
        getBrewingStand(): Internal.Container;
        get brewingStand(): Internal.Container
    }
    type BrewingStandContainerAccess_ = BrewingStandContainerAccess;
    class ChunkEvent$Unload extends Internal.ChunkEvent {
        constructor()
        constructor(arg0: Internal.ChunkAccess_)
    }
    type ChunkEvent$Unload_ = ChunkEvent$Unload;
    abstract class AbstractSpellPart implements Internal.Comparable<Internal.AbstractSpellPart> {
        constructor(arg0: ResourceLocation_, arg1: string)
        constructor(arg0: string, arg1: string)
        getTypeIndex(): number;
        getBookDescLang(): Internal.Component;
        getConfigTier(): Internal.SpellTier;
        defaultedStarterGlyph(): boolean;
        getLocaleName(): string;
        getBookDescription(): string;
        compareTo(arg0: any): number;
        isEnabled(): boolean;
        getGlyph(): Internal.Glyph;
        compareTo(arg0: Internal.AbstractSpellPart_): number;
        buildConfig(arg0: Internal.ForgeConfigSpec$Builder_): void;
        defaultTier(): Internal.SpellTier;
        getRegistryName(): ResourceLocation;
        getAugmentLimit(arg0: ResourceLocation_): number;
        getName(): string;
        getLocalizationKey(): string;
        shouldShowInSpellBook(): boolean;
        getDefaultManaCost(): number;
        getCastingCost(): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getTier(): Internal.SpellTier;
        shouldShowInUnlock(): boolean;
        get typeIndex(): number
        get bookDescLang(): Internal.Component
        get configTier(): Internal.SpellTier
        get localeName(): string
        get bookDescription(): string
        get enabled(): boolean
        get glyph(): Internal.Glyph
        get registryName(): ResourceLocation
        get name(): string
        get localizationKey(): string
        get defaultManaCost(): number
        get castingCost(): number
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        get tier(): Internal.SpellTier
        name: string;
        glyphItem: Internal.Glyph;
        COST: Internal.ForgeConfigSpec$IntValue;
        PER_SPELL_LIMIT: Internal.ForgeConfigSpec$IntValue;
        STARTER_SPELL: Internal.ForgeConfigSpec$BooleanValue;
        invalidCombinations: Internal.Set<ResourceLocation>;
        spellSchools: Internal.List<Internal.SpellSchool>;
        CONFIG: Internal.ForgeConfigSpec;
        compatibleAugments: Internal.Set<Internal.AbstractAugment>;
        ENABLED: Internal.ForgeConfigSpec$BooleanValue;
        GLYPH_TIER: Internal.ForgeConfigSpec$IntValue;
        augmentLimits: Internal.SpellPartConfigUtil$AugmentLimits;
    }
    type AbstractSpellPart_ = AbstractSpellPart;
    interface IColor {
        getName(): string;
        getValue(): number;
        isAnimated(): boolean;
        get name(): string
        get value(): number
        get animated(): boolean
    }
    type IColor_ = IColor;
    class PlayerWakeUpEvent extends Internal.PlayerEvent {
        constructor()
        constructor(arg0: Internal.Player_, arg1: boolean, arg2: boolean)
        wakeImmediately(): boolean;
        getEntity(): Internal.LivingEntity;
        updateLevel(): boolean;
        get entity(): Internal.LivingEntity
    }
    type PlayerWakeUpEvent_ = PlayerWakeUpEvent;
    class ElderGuardian extends Internal.Guardian {
        constructor(arg0: Internal.EntityType_<Internal.ElderGuardian>, arg1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        equipped(arg0: Internal.ItemEntity_): boolean;
        swing(): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        static isBlocked(entity: Internal.Entity_): boolean;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly ELDER_SIZE_SCALE: 2.35;
    }
    type ElderGuardian_ = ElderGuardian;
    class SoftMenuReloadEvent extends Internal.Event {
        constructor()
        constructor(arg0: Internal.Screen_)
        screen: Internal.Screen;
    }
    type SoftMenuReloadEvent_ = SoftMenuReloadEvent;
    interface SpecialEquality {
        checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        specialEquals(o: any, shallow: boolean): boolean;
    }
    type SpecialEquality_ = SpecialEquality;
    class SpawnData extends Internal.Record {
        constructor()
        constructor(arg0: Internal.CompoundTag_, arg1: Internal.Optional_<Internal.SpawnData$CustomSpawnRules>)
        customSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>;
        getEntityToSpawn(): Internal.CompoundTag;
        getCustomSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>;
        entityToSpawn(): Internal.CompoundTag;
        get entityToSpawn(): Internal.CompoundTag
        get customSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>
        static readonly LIST_CODEC: Internal.Codec<Internal.SimpleWeightedRandomList<Internal.SpawnData>>;
        static readonly DEFAULT_TYPE: "minecraft:pig";
        static readonly CODEC: Internal.Codec<Internal.SpawnData>;
    }
    type SpawnData_ = SpawnData;
    class Direction extends Internal.Enum<Internal.Direction> implements Internal.StringRepresentable {
        static fromYRot(arg0: number): Internal.Direction;
        static valueOf(arg0: string): Internal.Direction;
        getX(): number;
        getY(): number;
        getSerializedName(): string;
        getNormal(): Vec3i;
        getHorizontalIndex(): number;
        static fromNormal(arg0: number, arg1: number, arg2: number): Internal.Direction;
        getIndex(): number;
        static getNearest(arg0: number, arg1: number, arg2: number): Internal.Direction;
        getAxis(): Internal.Direction$Axis;
        getClockWise(): this;
        static getRandom(arg0: Internal.RandomSource_): Internal.Direction;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static orderedByNearest(arg0: Internal.Entity_): Internal.Direction[];
        getClockWise(arg0: Internal.Direction$Axis_): this;
        static getFacingAxis(arg0: Internal.Entity_, arg1: Internal.Direction$Axis_): Internal.Direction;
        getPitch(): number;
        getName(): string;
        static values(): Internal.Direction[];
        getZ(): number;
        static fromAxisAndDirection(arg0: Internal.Direction$Axis_, arg1: Internal.Direction$AxisDirection_): Internal.Direction;
        getOpposite(): this;
        static from2DDataValue(arg0: number): Internal.Direction;
        static stream(): Internal.Stream<Internal.Direction>;
        getAxisDirection(): Internal.Direction$AxisDirection;
        step(): Internal.Vector3f;
        getCounterClockWise(arg0: Internal.Direction$Axis_): this;
        static from3DDataValue(arg0: number): Internal.Direction;
        getRotation(): Internal.Quaternion;
        isFacingAngle(arg0: number): boolean;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        static byName(arg0: string): Internal.Direction;
        static getNearest(x: number, y: number, z: number): Internal.Direction;
        getYaw(): number;
        static fromNormal(arg0: BlockPos_): Internal.Direction;
        static allShuffled(arg0: Internal.RandomSource_): Internal.Collection<Internal.Direction>;
        static get(arg0: Internal.Direction$AxisDirection_, arg1: Internal.Direction$Axis_): Internal.Direction;
        static rotate(arg0: com.mojang.math.Matrix4f_, arg1: Internal.Direction_): Internal.Direction;
        getCounterClockWise(): this;
        get x(): number
        get y(): number
        get serializedName(): string
        get normal(): Vec3i
        get horizontalIndex(): number
        get index(): number
        get axis(): Internal.Direction$Axis
        get clockWise(): Internal.Direction
        get pitch(): number
        get name(): string
        get z(): number
        get opposite(): Internal.Direction
        get axisDirection(): Internal.Direction$AxisDirection
        get rotation(): Internal.Quaternion
        get yaw(): number
        get counterClockWise(): Internal.Direction
        static readonly UP: Internal.Direction;
        static readonly NORTH: Internal.Direction;
        static readonly BY_3D_DATA: Internal.Direction[];
        static readonly DOWN: Internal.Direction;
        static readonly EAST: Internal.Direction;
        static readonly WEST: Internal.Direction;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.Direction>;
        static readonly SOUTH: Internal.Direction;
        static readonly VERTICAL_CODEC: Internal.Codec<Internal.Direction>;
    }
    type Direction_ = "west" | "east" | "south" | "up" | "down" | "north" | Direction;
    class SignedMessageHeader extends Internal.Record {
        constructor(arg0: Internal.MessageSignature_, arg1: Internal.UUID_)
        constructor(arg0: Internal.FriendlyByteBuf_)
        write(arg0: Internal.FriendlyByteBuf_): void;
        updateSignature(arg0: Internal.SignatureUpdater$Output_, arg1: number[]): void;
        previousSignature(): Internal.MessageSignature;
        sender(): Internal.UUID;
    }
    type SignedMessageHeader_ = SignedMessageHeader;
    interface ItemBuilder$ReleaseUsingCallback {
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        (arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
    }
    type ItemBuilder$ReleaseUsingCallback_ = ItemBuilder$ReleaseUsingCallback;
    interface WatchKey {
        isValid(): boolean;
        pollEvents(): Internal.List<Internal.WatchEvent<any>>;
        watchable(): Internal.Watchable;
        cancel(): void;
        reset(): boolean;
        get valid(): boolean
    }
    type WatchKey_ = WatchKey;
    class StarLightInterface {
        constructor(arg0: Internal.LightChunkGetter_, arg1: boolean, arg2: boolean, arg3: Internal.LevelLightEngine_)
        getLightAccess(): Internal.LightChunkGetter;
        propagateChanges(): void;
        getWorld(): Internal.Level;
        isClientSide(): boolean;
        checkSkyEdges(arg0: number, arg1: number, arg2: Internal.ShortCollection_): void;
        hasUpdates(): boolean;
        getSkyReader(): Internal.LayerLightEventListener;
        scheduleChunkLight(arg0: Internal.ChunkPos_, arg1: Internal.Runnable_): void;
        forceLoadInChunk(arg0: Internal.ChunkAccess_, arg1: boolean[]): void;
        sectionChange(arg0: Internal.SectionPos_, arg1: boolean): Internal.CompletableFuture<void>;
        blockChange(arg0: BlockPos_): Internal.CompletableFuture<void>;
        lightChunk(arg0: Internal.ChunkAccess_, arg1: boolean[]): void;
        removeChunkTasks(arg0: Internal.ChunkPos_): void;
        loadInChunk(arg0: number, arg1: number, arg2: boolean[]): void;
        getBlockReader(): Internal.LayerLightEventListener;
        checkSkyEdges(arg0: number, arg1: number): void;
        checkBlockEdges(arg0: number, arg1: number): void;
        relightChunks(arg0: Internal.Set_<Internal.ChunkPos>, arg1: Internal.Consumer_<Internal.ChunkPos>, arg2: Internal.IntConsumer_): void;
        checkBlockEdges(arg0: number, arg1: number, arg2: Internal.ShortCollection_): void;
        getRawBrightness(arg0: BlockPos_, arg1: number): number;
        getAnyChunkNow(arg0: number, arg1: number): Internal.ChunkAccess;
        checkChunkEdges(arg0: number, arg1: number): void;
        get lightAccess(): Internal.LightChunkGetter
        get world(): Internal.Level
        get clientSide(): boolean
        get skyReader(): Internal.LayerLightEventListener
        get blockReader(): Internal.LayerLightEventListener
        static readonly CHUNK_WORK_TICKET: Internal.TicketType<Internal.ChunkPos>;
        readonly lightEngine: Internal.LevelLightEngine;
    }
    type StarLightInterface_ = StarLightInterface;
    interface ServerPlayerKJS extends Internal.PlayerKJS {
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getSpawnLocation(): Internal.BlockContainerJS;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        setSpawnLocation(c: Internal.BlockContainerJS_): void;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getXpLevel(): number;
        setSelectedSlot(index: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isOp(): boolean;
        kick(): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        paint(renderer: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): Internal.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        getFoodLevel(): number;
        notify(title: Internal.Component_, text: Internal.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        setXpLevel(l: number): void;
        getCraftingGrid(): Internal.InventoryKJS;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        setXp(xp: number): void;
        setCreativeMode(mode: boolean): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        notify(builder: Notification_): void;
        getInventoryChangeListener(): Internal.KubeJSInventoryListener;
        isMonster(): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getStages(): Internal.Stages;
        getName(): Internal.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        ban(banner: string, reason: string, expiresInMillis: number): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getInventory(): Internal.InventoryKJS;
        give(item: Internal.ItemStack_): void;
        revokeAdvancement(id: ResourceLocation_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        kick(reason: Internal.Component_): void;
        isAdvancementDone(id: ResourceLocation_): boolean;
        sendInventoryUpdate(): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        unlockAdvancement(id: ResourceLocation_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getData(): Internal.AttachedData<Internal.Player>;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get spawnLocation(): Internal.BlockContainerJS
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        set spawnLocation(c: Internal.BlockContainerJS_)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get op(): boolean
        get totalMovementSpeed(): number
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set xpLevel(l: number)
        get craftingGrid(): Internal.InventoryKJS
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        set creativeMode(mode: boolean)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get ambientCreature(): boolean
        get inventoryChangeListener(): Internal.KubeJSInventoryListener
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get stages(): Internal.Stages
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get inventory(): Internal.InventoryKJS
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get data(): Internal.AttachedData<Internal.Player>
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
    }
    type ServerPlayerKJS_ = ServerPlayerKJS;
    interface IIngredientManager {
        removeIngredientsAtRuntime<V>(arg0: Internal.IIngredientType_<V>, arg1: Internal.Collection_<V>): void;
        registerIngredientListener(arg0: Internal.IIngredientManager$IIngredientListener_): void;
        getIngredientRenderer<V>(arg0: Internal.IIngredientType_<V>): Internal.IIngredientRenderer<V>;
        getIngredientTypeChecked<V>(arg0: V): Internal.Optional<Internal.IIngredientType<V>>;
        createTypedIngredient<V>(arg0: Internal.IIngredientType_<V>, arg1: V): Internal.Optional<Internal.ITypedIngredient<V>>;
        getIngredientHelper<V>(arg0: Internal.IIngredientType_<V>): Internal.IIngredientHelper<V>;
        getIngredientHelper<V>(arg0: V): Internal.IIngredientHelper<V>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getIngredientType<V>(arg0: V): Internal.IIngredientType<V>;
        getAllItemStacks(): Internal.Collection<Internal.ItemStack>;
        getIngredientTypeChecked<V>(arg0: V): Internal.Optional<Internal.IIngredientType<V>>;
        addIngredientsAtRuntime<V>(arg0: Internal.IIngredientType_<V>, arg1: Internal.Collection_<V>): void;
        getIngredientByUid<V>(arg0: Internal.IIngredientType_<V>, arg1: string): Internal.Optional<V>;
        getRegisteredIngredientTypes(): Internal.Collection<Internal.IIngredientType<any>>;
        getIngredientRenderer<V>(arg0: V): Internal.IIngredientRenderer<V>;
        getAllIngredients<V>(arg0: Internal.IIngredientType_<V>): Internal.Collection<V>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getIngredientType<V>(arg0: V): Internal.IIngredientType<V>;
        get allItemStacks(): Internal.Collection<Internal.ItemStack>
        get registeredIngredientTypes(): Internal.Collection<Internal.IIngredientType<any>>
    }
    type IIngredientManager_ = IIngredientManager;
    class Rotation extends Internal.Enum<Internal.Rotation> implements Internal.StringRepresentable {
        static getRandom(arg0: Internal.RandomSource_): Internal.Rotation;
        rotate(arg0: Internal.Direction_): Internal.Direction;
        static valueOf(arg0: string): Internal.Rotation;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        getSerializedName(): string;
        rotation(): Internal.OctahedralGroup;
        static values(): Internal.Rotation[];
        rotate(arg0: number, arg1: number): number;
        getRotated(arg0: Internal.Rotation_): this;
        static getShuffled(arg0: Internal.RandomSource_): Internal.List<Internal.Rotation>;
        get serializedName(): string
        static readonly CODEC: Internal.Codec<Internal.Rotation>;
        static readonly NONE: Internal.Rotation;
        static readonly CLOCKWISE_90: Internal.Rotation;
        static readonly CLOCKWISE_180: Internal.Rotation;
        static readonly COUNTERCLOCKWISE_90: Internal.Rotation;
    }
    type Rotation_ = "clockwise_90" | "clockwise_180" | "counterclockwise_90" | Rotation | "none";
    class TrackTargetingBehaviour$RenderedTrackOverlayType extends Internal.Enum<Internal.TrackTargetingBehaviour$RenderedTrackOverlayType> {
        static valueOf(arg0: string): Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static values(): Internal.TrackTargetingBehaviour$RenderedTrackOverlayType[];
        static readonly STATION: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly SIGNAL: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly DUAL_SIGNAL: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly OBSERVER: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
    }
    type TrackTargetingBehaviour$RenderedTrackOverlayType_ = "dual_signal" | TrackTargetingBehaviour$RenderedTrackOverlayType | "signal" | "station" | "observer";
    class PlayerContainerEvent$Open extends Internal.PlayerContainerEvent {
        constructor(arg0: Internal.Player_, arg1: Internal.AbstractContainerMenu_)
        constructor()
        getEntity(): Internal.LivingEntity;
        get entity(): Internal.LivingEntity
    }
    type PlayerContainerEvent$Open_ = PlayerContainerEvent$Open;
    class ServerStatus {
        constructor()
        getJson(): string;
        setForgeData(arg0: Internal.ServerStatusPing_): void;
        getPlayers(): Internal.ServerStatus$Players;
        getForgeData(): Internal.ServerStatusPing;
        getVersion(): Internal.ServerStatus$Version;
        setFavicon(arg0: string): void;
        invalidateJson(): void;
        setEnforcesSecureChat(arg0: boolean): void;
        setPlayers(arg0: Internal.ServerStatus$Players_): void;
        enforcesSecureChat(): boolean;
        getFavicon(): string;
        setVersion(arg0: Internal.ServerStatus$Version_): void;
        previewsChat(): boolean;
        setDescription(arg0: Internal.Component_): void;
        getDescription(): Internal.Component;
        setPreviewsChat(arg0: boolean): void;
        get json(): string
        set forgeData(arg0: Internal.ServerStatusPing_)
        get players(): Internal.ServerStatus$Players
        get forgeData(): Internal.ServerStatusPing
        get version(): Internal.ServerStatus$Version
        set favicon(arg0: string)
        set enforcesSecureChat(arg0: boolean)
        set players(arg0: Internal.ServerStatus$Players_)
        get favicon(): string
        set version(arg0: Internal.ServerStatus$Version_)
        set description(arg0: Internal.Component_)
        get description(): Internal.Component
        set previewsChat(arg0: boolean)
        static readonly FAVICON_WIDTH: 64;
        static readonly FAVICON_HEIGHT: 64;
    }
    type ServerStatus_ = ServerStatus;
    class LivingAttackEvent extends Internal.LivingEvent {
        constructor()
        constructor(arg0: Internal.LivingEntity_, arg1: DamageSource_, arg2: number)
        getEntity(): Internal.Entity;
        getAmount(): number;
        getSource(): DamageSource;
        get entity(): Internal.Entity
        get amount(): number
        get source(): DamageSource
    }
    type LivingAttackEvent_ = LivingAttackEvent;
    interface IBossHealthPushBox {
        setLastBossHealthHeight(arg0: number): void;
        setActive(arg0: boolean): void;
        set lastBossHealthHeight(arg0: number)
        set active(arg0: boolean)
    }
    type IBossHealthPushBox_ = IBossHealthPushBox;
    interface MinecraftClientAccessor {
        setAttackCooldown(arg0: number): void;
        getEntityRenderDispatcher(): Internal.EntityRenderDispatcher;
        getAttackCooldown(): number;
        set attackCooldown(arg0: number)
        get entityRenderDispatcher(): Internal.EntityRenderDispatcher
        get attackCooldown(): number
    }
    type MinecraftClientAccessor_ = MinecraftClientAccessor;
    class GLTextureInfo {
        constructor()
        set(info: Internal.GLTextureInfo_): void;
        memoryObject: number;
        memoryHandle: number;
        format: number;
        texture: number;
        levels: number;
    }
    type GLTextureInfo_ = GLTextureInfo;
    class PlayMessages$SpawnEntity {
        static encode(arg0: Internal.PlayMessages$SpawnEntity_, arg1: Internal.FriendlyByteBuf_): void;
        getVelY(): number;
        getVelZ(): number;
        getHeadYaw(): number;
        getVelX(): number;
        static decode(arg0: Internal.FriendlyByteBuf_): Internal.PlayMessages$SpawnEntity;
        getTypeId(): number;
        getEntity(): Internal.Entity;
        getPosZ(): number;
        getPosY(): number;
        getPosX(): number;
        static handle(arg0: Internal.PlayMessages$SpawnEntity_, arg1: Internal.Supplier_<Internal.NetworkEvent$Context>): void;
        getEntityId(): number;
        getAdditionalData(): Internal.FriendlyByteBuf;
        getUuid(): Internal.UUID;
        getPitch(): number;
        getYaw(): number;
        get velY(): number
        get velZ(): number
        get headYaw(): number
        get velX(): number
        get typeId(): number
        get entity(): Internal.Entity
        get posZ(): number
        get posY(): number
        get posX(): number
        get entityId(): number
        get additionalData(): Internal.FriendlyByteBuf
        get uuid(): Internal.UUID
        get pitch(): number
        get yaw(): number
    }
    type PlayMessages$SpawnEntity_ = PlayMessages$SpawnEntity;
    interface IRecipeCategoriesLookup {
        includeHidden(): this;
        limitTypes(arg0: Internal.Collection_<mezz.jei.api.recipe.RecipeType<any>>): this;
        limitFocus(arg0: Internal.Collection_<Internal.IFocus<any>>): this;
        get(): Internal.Stream<Internal.IRecipeCategory<any>>;
    }
    type IRecipeCategoriesLookup_ = IRecipeCategoriesLookup;
    interface FlushInfo$FinishedCallback {
        onFinished(): void;
        (): void;
    }
    type FlushInfo$FinishedCallback_ = FlushInfo$FinishedCallback;
    class FeaturePoolElement extends Internal.StructurePoolElement implements Internal.FeaturePoolElementAccessor {
        getFeature(): Internal.Holder<any>;
        get feature(): Internal.Holder<any>
        feature: Internal.Holder<Internal.PlacedFeature>;
        static readonly CODEC: Internal.Codec<Internal.FeaturePoolElement>;
    }
    type FeaturePoolElement_ = FeaturePoolElement;
    interface Color extends Internal.SpecialEquality {
        getSerializeJS(): string;
        checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        getArgbJS(): number;
        specialEquals(o: any, shallow: boolean): boolean;
        createTextColorJS(): Internal.TextColor;
        getHexJS(): string;
        getRgbJS(): number;
        getFireworkColorJS(): number;
        get serializeJS(): string
        get argbJS(): number
        get hexJS(): string
        get rgbJS(): number
        get fireworkColorJS(): number
    }
    type Color_ = Color;
    class AttributeMap {
        constructor(arg0: Internal.AttributeSupplier_)
        load(arg0: Internal.ListTag_): void;
        getDirtyAttributes(): Internal.Set<Internal.AttributeInstance>;
        removeAttributeModifiers(arg0: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>): void;
        hasModifier(arg0: Internal.Attribute_, arg1: Internal.UUID_): boolean;
        getInstance(arg0: Internal.Attribute_): Internal.AttributeInstance;
        assignValues(arg0: Internal.AttributeMap_): void;
        hasAttribute(arg0: Internal.Attribute_): boolean;
        getBaseValue(arg0: Internal.Attribute_): number;
        getSyncableAttributes(): Internal.Collection<Internal.AttributeInstance>;
        save(): Internal.ListTag;
        getValue(arg0: Internal.Attribute_): number;
        addTransientAttributeModifiers(arg0: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>): void;
        getModifierValue(arg0: Internal.Attribute_, arg1: Internal.UUID_): number;
        get dirtyAttributes(): Internal.Set<Internal.AttributeInstance>
        get syncableAttributes(): Internal.Collection<Internal.AttributeInstance>
    }
    type AttributeMap_ = AttributeMap;
    class ClientboundSetHealthPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: number, arg1: number, arg2: number)
        constructor(arg0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        getHealth(): number;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getFood(): number;
        getSaturation(): number;
        isSkippable(): boolean;
        get health(): number
        get food(): number
        get saturation(): number
        get skippable(): boolean
    }
    type ClientboundSetHealthPacket_ = ClientboundSetHealthPacket;
    class PlayerMap {
        constructor()
        addPlayer(arg0: number, arg1: Internal.ServerPlayer_, arg2: boolean): void;
        updatePlayer(arg0: number, arg1: number, arg2: Internal.ServerPlayer_): void;
        getPlayers(arg0: number): Internal.Set<Internal.ServerPlayer>;
        ignored(arg0: Internal.ServerPlayer_): boolean;
        unIgnorePlayer(arg0: Internal.ServerPlayer_): void;
        ignoredOrUnknown(arg0: Internal.ServerPlayer_): boolean;
        ignorePlayer(arg0: Internal.ServerPlayer_): void;
        removePlayer(arg0: number, arg1: Internal.ServerPlayer_): void;
    }
    type PlayerMap_ = PlayerMap;
    interface Predicate <T> {
        negate(): this;
        not<T>(arg0: Internal.Predicate_<T>): this;
        or(arg0: Internal.Predicate_<T>): this;
        test(arg0: T): boolean;
        and(arg0: Internal.Predicate_<T>): this;
        isEqual<T>(arg0: any): this;
        (arg0: T): boolean;
    }
    type Predicate_<T> = Predicate<T>;
    abstract class ColorSpace {
        static connect(source: Internal.ColorSpace_, destination: Internal.ColorSpace_, intent: Internal.ColorSpace$RenderIntent_): Internal.ColorSpace$Connector;
        getMinValue(arg0: number): number;
        fromXyz(arg0: number[]): number[];
        toXyz(r: number, g: number, b: number): number[];
        static match(toXYZD50: number[], function_: Internal.ColorSpace$Rgb$TransferParameters_): Internal.ColorSpace;
        static connect(source: Internal.ColorSpace_, intent: Internal.ColorSpace$RenderIntent_): Internal.ColorSpace$Connector;
        static adapt(colorSpace: Internal.ColorSpace_, whitePoint: number[], adaptation: Internal.ColorSpace$Adaptation_): Internal.ColorSpace;
        toXyz(arg0: number[]): number[];
        static get(name: Internal.ColorSpace$Named_): Internal.ColorSpace;
        static connect(source: Internal.ColorSpace_): Internal.ColorSpace$Connector;
        fromXyz(x: number, y: number, z: number): number[];
        static chromaticAdaptation(adaptation: Internal.ColorSpace$Adaptation_, srcWhitePoint: number[], dstWhitePoint: number[]): number[];
        isWideGamut(): boolean;
        isSrgb(): boolean;
        getName(): string;
        getMaxValue(arg0: number): number;
        getComponentCount(): number;
        static cctToXyz(cct: number): number[];
        getModel(): Internal.ColorSpace$Model;
        static connect(source: Internal.ColorSpace_, destination: Internal.ColorSpace_): Internal.ColorSpace$Connector;
        getId(): number;
        static adapt(colorSpace: Internal.ColorSpace_, whitePoint: number[]): Internal.ColorSpace;
        get wideGamut(): boolean
        get srgb(): boolean
        get name(): string
        get componentCount(): number
        get model(): Internal.ColorSpace$Model
        get id(): number
        static readonly ILLUMINANT_D75: number[];
        static readonly ILLUMINANT_E: number[];
        static readonly ILLUMINANT_D65: number[];
        static readonly ILLUMINANT_C: number[];
        static readonly ILLUMINANT_D55: number[];
        static readonly ILLUMINANT_B: number[];
        static readonly ILLUMINANT_A: number[];
        static readonly ILLUMINANT_D60: number[];
        static readonly ILLUMINANT_D50: number[];
        static readonly MAX_ID: 63;
        static readonly MIN_ID: -1;
    }
    type ColorSpace_ = ColorSpace;
    class ContraptionWorld extends Internal.WrappedWorld {
        constructor(arg0: Internal.Level_, arg1: Internal.Contraption_)
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_): Internal.Player;
        dayTime(): number;
        isUnobstructed(arg0: Internal.Entity_, arg1: Internal.VoxelShape_): boolean;
        getBrightness(arg0: Internal.LightLayer_, arg1: BlockPos_): number;
        createEntityList(entities: Internal.Collection_<Internal.Entity>): Internal.EntityArrayList;
        getEntitiesWithin(aabb: Internal.AABB_): Internal.EntityArrayList;
        isEmptyBlock(arg0: BlockPos_): boolean;
        getMaxLocalRawBrightness(arg0: BlockPos_, arg1: number): number;
        getBlockCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getTimeOfDay(arg0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        getHeightmapPos(arg0: Internal.Heightmap$Types_, arg1: BlockPos_): BlockPos;
        blockUpdated(arg0: BlockPos_, arg1: Internal.Block_): void;
        getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.List<Internal.Entity>;
        getEntitiesOfClass<T extends Internal.Entity>(arg0: T, arg1: Internal.AABB_): Internal.List<T>;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        getBlockStates(arg0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels(arg0: BlockPos_): number;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Fluid_, arg2: number): void;
        getBlock(blockEntity: Internal.BlockEntity_): Internal.BlockContainerJS;
        getNearestPlayer(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): Internal.Player;
        /**
         * @deprecated
        */
        hasChunkAt(arg0: number, arg1: number): boolean;
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: number, arg2: number, arg3: number): Internal.Player;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: BlockPos_, arg1: BlockPos_): boolean;
        destroyBlock(arg0: BlockPos_, arg1: boolean): boolean;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Block_, arg2: number): void;
        getChunk(arg0: number, arg1: number): Internal.ChunkAccess;
        getCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_): boolean;
        getBlock(x: number, y: number, z: number): Internal.BlockContainerJS;
        getChunk(arg0: BlockPos_): Internal.ChunkAccess;
        isUnobstructed(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: Internal.CollisionContext_): boolean;
        /**
         * @deprecated
        */
        hasChunkAt(arg0: BlockPos_): boolean;
        getBiome(arg0: BlockPos_): Internal.Holder<Internal.Biome>;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(arg0: BlockPos_): number;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Block_, arg2: number, arg3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        getEntitiesOfClass<T extends Internal.Entity>(arg0: T, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_, arg2: number, arg3: number, arg4: number): Internal.Player;
        getBlockTint(arg0: BlockPos_, arg1: Internal.ColorResolver_): number;
        findFreePosition(arg0: Internal.Entity_, arg1: Internal.VoxelShape_, arg2: Vec3_, arg3: number, arg4: number, arg5: number): Internal.Optional<Vec3>;
        clipWithInteractionOverride(arg0: Vec3_, arg1: Vec3_, arg2: BlockPos_, arg3: Internal.VoxelShape_, arg4: Internal.BlockState_): Internal.BlockHitResult;
        createExplosion(x: number, y: number, z: number): Internal.ExplosionJS;
        getNearestPlayer(arg0: Internal.Entity_, arg1: number): Internal.Player;
        getBlockFloorHeight(arg0: BlockPos_): number;
        getLightEmission(arg0: BlockPos_): number;
        getBlockStatesIfLoaded(arg0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getShade(arg0: number, arg1: number, arg2: number, arg3: boolean): number;
        static create(arg0: number, arg1: number): Internal.LevelHeightAccessor;
        getPartEntities(): Internal.Collection<Internal.PartEntity<any>>;
        clip(arg0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>(arg0: BlockPos_, arg1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness(arg0: BlockPos_, arg1: number): number;
        getDimension(): ResourceLocation;
        getDifficulty(): Internal.Difficulty;
        canSeeSky(arg0: BlockPos_): boolean;
        getMoonPhase(): number;
        isUnobstructed(arg0: Internal.Entity_): boolean;
        getNearestEntity<T extends Internal.LivingEntity>(arg0: Internal.List_<T>, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number): T;
        createEntity(id: ResourceLocation_): Internal.Entity;
        spawnFireworks(x: number, y: number, z: number, f: Internal.FireworksJS_): void;
        getPlayerByUUID(arg0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater(arg0: BlockPos_): boolean;
        getNearbyPlayers(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_, arg2: Internal.AABB_): Internal.List<Internal.Player>;
        getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_): Internal.ChunkAccess;
        noCollision(arg0: Internal.Entity_): boolean;
        self(): Internal.Level;
        hasChunk(arg0: number, arg1: number): boolean;
        getNearbyEntities<T extends Internal.LivingEntity>(arg0: T, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: Internal.AABB_): Internal.List<T>;
        getMoonBrightness(): number;
        noCollision(arg0: Internal.AABB_): boolean;
        isWaterAt(arg0: BlockPos_): boolean;
        getDirectSignal(arg0: BlockPos_, arg1: Internal.Direction_): number;
        getSide(): Internal.ScriptType;
        getEntityCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getBlockFloorHeight(arg0: Internal.VoxelShape_, arg1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock(arg0: Internal.Entity_, arg1: Internal.AABB_): boolean;
        getNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        gameEvent(arg0: Internal.GameEvent_, arg1: BlockPos_, arg2: Internal.GameEvent$Context_): void;
        getModelDataManager(): Internal.ModelDataManager;
        noCollision(arg0: Internal.Entity_, arg1: Internal.AABB_): boolean;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Fluid_, arg2: number, arg3: Internal.TickPriority_): void;
        getEntities(): Internal.EntityArrayList;
        getNearestPlayer(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine(arg0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        gameEvent(arg0: Internal.Entity_, arg1: Internal.GameEvent_, arg2: Vec3_): void;
        levelEvent(arg0: number, arg1: BlockPos_, arg2: number): void;
        getExistingBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getPlayers(): Internal.EntityArrayList;
        containsAnyLiquid(arg0: Internal.AABB_): boolean;
        getMaxLightLevel(): number;
        getBlock(pos: BlockPos_): Internal.BlockContainerJS;
        isOverworld(): boolean;
        getNearestEntity<T extends Internal.LivingEntity>(arg0: T, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number, arg6: Internal.AABB_): T;
        isAreaLoaded(arg0: BlockPos_, arg1: number): boolean;
        static traverseBlocks<T, C>(arg0: Vec3_, arg1: Vec3_, arg2: C, arg3: Internal.BiFunction_<C, BlockPos, T>, arg4: Internal.Function_<C, T>): T;
        get partEntities(): Internal.Collection<Internal.PartEntity<any>>
        get dimension(): ResourceLocation
        get difficulty(): Internal.Difficulty
        get moonPhase(): number
        get moonBrightness(): number
        get side(): Internal.ScriptType
        get modelDataManager(): Internal.ModelDataManager
        get entities(): Internal.EntityArrayList
        get players(): Internal.EntityArrayList
        get maxLightLevel(): number
        get overworld(): boolean
    }
    type ContraptionWorld_ = ContraptionWorld;
    interface FileAttributeView extends Internal.AttributeView {
        name(): string;
    }
    type FileAttributeView_ = FileAttributeView;
    interface NbtAccounterAccessor {
        create$getUsage(): number;
    }
    type NbtAccounterAccessor_ = NbtAccounterAccessor;
    interface DensityFunction$FunctionContext {
        blockX(): number;
        getBlender(): Internal.Blender;
        blockZ(): number;
        blockY(): number;
        get blender(): Internal.Blender
    }
    type DensityFunction$FunctionContext_ = DensityFunction$FunctionContext;
    interface FragmentOnAttachListener {
        onAttachFragment(arg0: Internal.FragmentManager_, arg1: Internal.Fragment_): void;
        (arg0: Internal.FragmentManager_, arg1: Internal.Fragment_): void;
    }
    type FragmentOnAttachListener_ = FragmentOnAttachListener;
    class NopProcessor extends Internal.StructureProcessor {
        static readonly CODEC: Internal.Codec<Internal.NopProcessor>;
        static readonly INSTANCE: Internal.NopProcessor;
    }
    type NopProcessor_ = NopProcessor;
    class Object2IntFunctions$UnmodifiableFunction <K> extends Internal.AbstractObject2IntFunction<K> implements Internal.Serializable {
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2IntFunction<T>;
        andThenInt(arg0: Internal.Int2IntFunction_): Internal.Object2IntFunction<K>;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Object2FloatFunction<K>;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Object2LongFunction<K>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2IntFunction;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2IntFunction<T>;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2IntFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2IntFunction;
        applyAsInt(arg0: K): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2IntFunction;
        apply(arg0: K): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Object2ShortFunction<K>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2IntFunction;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2IntFunction;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Object2ByteFunction<K>;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Object2CharFunction<K>;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2IntFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        static identity<T>(): Internal.Function<T, T>;
    }
    type Object2IntFunctions$UnmodifiableFunction_<K> = Object2IntFunctions$UnmodifiableFunction<K>;
    class RandomTickCallbackJS {
        constructor(containerJS: Internal.BlockContainerJS_, random: Internal.RandomSource_)
        getLevel(): Internal.Level;
        getServer(): Internal.MinecraftServer;
        get level(): Internal.Level
        get server(): Internal.MinecraftServer
        block: Internal.BlockContainerJS;
        random: Internal.RandomSource;
    }
    type RandomTickCallbackJS_ = RandomTickCallbackJS;
    /**
     * Invoked after all items are registered to modify them.
    */
    class ItemModificationEventJS extends Internal.EventJS {
        constructor()
        /**
         * Modifies items matching the given ingredient.
         * 
         * **NOTE**: tag ingredients are not supported at this time.
        */
        modify(in_: Internal.Ingredient_, c: Internal.Consumer_<Internal.Item>): void;
    }
    type ItemModificationEventJS_ = ItemModificationEventJS;
    abstract class Certificate implements Internal.Serializable {
        verify(arg0: Internal.PublicKey_, arg1: string): void;
        getPublicKey(): Internal.PublicKey;
        getType(): string;
        verify(arg0: Internal.PublicKey_, arg1: Internal.Provider_): void;
        getEncoded(): number[];
        verify(arg0: Internal.PublicKey_): void;
        get publicKey(): Internal.PublicKey
        get type(): string
        get encoded(): number[]
    }
    type Certificate_ = Certificate;
    class TrackEdge {
        constructor(arg0: Internal.TrackNode_, arg1: Internal.TrackNode_, arg2: Internal.BezierConnection_, arg3: Internal.TrackMaterial_)
        incrementT(arg0: number, arg1: number): number;
        getPositionSmoothed(arg0: Internal.TrackGraph_, arg1: number): Vec3;
        getIntersection(arg0: Internal.TrackNode_, arg1: Internal.TrackNode_, arg2: Internal.TrackEdge_, arg3: Internal.TrackNode_, arg4: Internal.TrackNode_): Internal.Collection<number[]>;
        getDirectionAt(arg0: number): Vec3;
        getPosition(arg0: Internal.TrackGraph_, arg1: number): Vec3;
        getTurn(): Internal.BezierConnection;
        canTravelTo(arg0: Internal.TrackEdge_): boolean;
        isTurn(): boolean;
        getNormalSmoothed(arg0: Internal.TrackGraph_, arg1: number): Vec3;
        write(arg0: Internal.DimensionPalette_): Internal.CompoundTag;
        getDirection(arg0: boolean): Vec3;
        getNormal(arg0: Internal.TrackGraph_, arg1: number): Vec3;
        isInterDimensional(): boolean;
        getTrackMaterial(): Internal.TrackMaterial;
        getLength(): number;
        getEdgeData(): Internal.EdgeData;
        static read(arg0: Internal.TrackNode_, arg1: Internal.TrackNode_, arg2: Internal.CompoundTag_, arg3: Internal.TrackGraph_, arg4: Internal.DimensionPalette_): Internal.TrackEdge;
        get turn(): Internal.BezierConnection
        get turn(): boolean
        get interDimensional(): boolean
        get trackMaterial(): Internal.TrackMaterial
        get length(): number
        get edgeData(): Internal.EdgeData
        node1: Internal.TrackNode;
        node2: Internal.TrackNode;
    }
    type TrackEdge_ = TrackEdge;
    class MinimapInterface extends Internal.Interface {
        constructor(arg0: Internal.IXaeroMinimap_, arg1: number, arg2: Internal.InterfaceManager_)
        setCrashedWith(arg0: Internal.Throwable_): void;
        getOverMapRendererHandler(): Internal.MinimapElementOverMapRendererHandler;
        usingFBO(): boolean;
        getMinimapSafeModeRenderer(): Internal.MinimapSafeModeRenderer;
        getWaypointsGuiRenderer(): Internal.WaypointsGuiRenderer;
        getCompassRenderer(): Internal.CompassRenderer;
        getInfoDisplayManager(): Internal.InfoDisplayManager;
        getInfoDisplayRenderer(): Internal.InfoDisplayRenderer;
        getInfoDisplayIO(): Internal.InfoDisplayIO;
        getMinimapFBORenderer(): Internal.MinimapFBORenderer;
        checkCrashes(): void;
        getWaypointsIngameRenderer(): Internal.WaypointsIngameRenderer;
        getCrashedWith(): Internal.Throwable;
        set crashedWith(arg0: Internal.Throwable_)
        get overMapRendererHandler(): Internal.MinimapElementOverMapRendererHandler
        get minimapSafeModeRenderer(): Internal.MinimapSafeModeRenderer
        get waypointsGuiRenderer(): Internal.WaypointsGuiRenderer
        get compassRenderer(): Internal.CompassRenderer
        get infoDisplayManager(): Internal.InfoDisplayManager
        get infoDisplayRenderer(): Internal.InfoDisplayRenderer
        get infoDisplayIO(): Internal.InfoDisplayIO
        get minimapFBORenderer(): Internal.MinimapFBORenderer
        get waypointsIngameRenderer(): Internal.WaypointsIngameRenderer
        get crashedWith(): Internal.Throwable
    }
    type MinimapInterface_ = MinimapInterface;
    class AccessorySlot$Group extends Internal.Enum<Internal.AccessorySlot$Group> {
        static values(): Internal.AccessorySlot$Group[];
        static byName(arg0: string): Internal.AccessorySlot$Group;
        getName(): string;
        static valueOf(arg0: string): Internal.AccessorySlot$Group;
        get name(): string
        static readonly FINGER: Internal.AccessorySlot$Group;
        static readonly NECK: Internal.AccessorySlot$Group;
        static readonly BACK: Internal.AccessorySlot$Group;
    }
    type AccessorySlot$Group_ = "neck" | "finger" | AccessorySlot$Group | "back";
    interface ExtendedWorld {
        getChunkAtImmediately(arg0: number, arg1: number): Internal.LevelChunk;
        getAnyChunkImmediately(arg0: number, arg1: number): Internal.ChunkAccess;
    }
    type ExtendedWorld_ = ExtendedWorld;
    interface IMixinMinecraft {
        openChatScreenFancyMenu(arg0: string): void;
    }
    type IMixinMinecraft_ = IMixinMinecraft;
    class RegistryEvent$RegistryWrapper <T> {
        constructor(arg0: Internal.IForgeRegistry_<T>)
        register(arg0: T, arg1: ResourceLocation_): void;
        registerAll(...arg0: any[]): void;
        register(arg0: T, arg1: string): void;
    }
    type RegistryEvent$RegistryWrapper_<T> = RegistryEvent$RegistryWrapper<T>;
    interface SortedMap <K, V> extends Internal.Map<K, V> {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        containsValue(arg0: any): boolean;
        of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        tailMap(arg0: K): this;
        isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        containsKey(arg0: any): boolean;
        comparator(): Internal.Comparator<K>;
        put(arg0: K, arg1: V): V;
        headMap(arg0: K): this;
        get(arg0: any): V;
        remove(arg0: any): V;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        subMap(arg0: K, arg1: K): this;
        putIfAbsent(arg0: K, arg1: V): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        putAll(arg0: Internal.Map_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        lastKey(): K;
        hashCode(): number;
        size(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        equals(arg0: any): boolean;
        firstKey(): K;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        get empty(): boolean
    }
    type SortedMap_<K, V> = SortedMap<K, V>;
    class FireConsumeBlockEvent extends Internal.BlockEvent implements Internal.IFireConsumeBlockEvent {
        constructor()
        constructor(world: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, chance: number, age: number, face: Internal.Direction_)
        setFinalState(state: Internal.BlockState_): void;
        static create(pos: BlockPos_, level: Internal.Level_, state: Internal.BlockState_, chance: number, age: number, face: Internal.Direction_): Internal.IFireConsumeBlockEvent;
        getAge(): number;
        getFinalState(): Internal.BlockState;
        getFace(): Internal.Direction;
        getChance(): number;
        set finalState(state: Internal.BlockState_)
        get age(): number
        get finalState(): Internal.BlockState
        get face(): Internal.Direction
        get chance(): number
    }
    type FireConsumeBlockEvent_ = FireConsumeBlockEvent;
    class StainedGlassPaneBlock extends Internal.IronBarsBlock implements Internal.BeaconBeamBlock {
        constructor(arg0: Internal.DyeColor_, arg1: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getColor(): Internal.DyeColor;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type StainedGlassPaneBlock_ = StainedGlassPaneBlock;
    class TransformType extends Internal.Enum<Internal.TransformType> {
        static valueOf(name: string): Internal.TransformType;
        static values(): Internal.TransformType[];
        static readonly POSITION: Internal.TransformType;
        static readonly ROTATION: Internal.TransformType;
        static readonly BEND: Internal.TransformType;
    }
    type TransformType_ = "position" | "rotation" | TransformType | "bend";
    class ServerChunkCache extends Internal.ChunkSource {
        constructor(arg0: Internal.ServerLevel_, arg1: Internal.LevelStorageSource$LevelStorageAccess_, arg2: Internal.DataFixer_, arg3: Internal.StructureTemplateManager_, arg4: Internal.Executor_, arg5: Internal.ChunkGenerator_, arg6: number, arg7: number, arg8: boolean, arg9: Internal.ChunkProgressListener_, arg10: Internal.ChunkStatusUpdateListener_, arg11: Internal.Supplier_<Internal.DimensionDataStorage>)
        broadcast(arg0: Internal.Entity_, arg1: Internal.Packet_<any>): void;
        pollTask(): boolean;
        getDataStorage(): Internal.DimensionDataStorage;
        setSimulationDistance(arg0: number): void;
        removeRegionTicket<T>(arg0: Internal.TicketType_<T>, arg1: Internal.ChunkPos_, arg2: number, arg3: T, arg4: boolean): void;
        removeEntity(arg0: Internal.Entity_): void;
        getLastSpawnState(): Internal.NaturalSpawner$SpawnState;
        removeRegionTicket<T>(arg0: Internal.TicketType_<T>, arg1: Internal.ChunkPos_, arg2: number, arg3: T): void;
        getChunkDebugData(arg0: Internal.ChunkPos_): string;
        chunkScanner(): Internal.ChunkScanAccess;
        addRegionTicket<T>(arg0: Internal.TicketType_<T>, arg1: Internal.ChunkPos_, arg2: number, arg3: T): void;
        setViewDistance(arg0: number): void;
        getTickingGenerated(): number;
        getPendingTasksCount(): number;
        randomState(): Internal.RandomState;
        getPoiManager(): Internal.PoiManager;
        broadcastAndSend(arg0: Internal.Entity_, arg1: Internal.Packet_<any>): void;
        move(arg0: Internal.ServerPlayer_): void;
        addRegionTicket<T>(arg0: Internal.TicketType_<T>, arg1: Internal.ChunkPos_, arg2: number, arg3: T, arg4: boolean): void;
        addEntity(arg0: Internal.Entity_): void;
        isPositionTicking(arg0: number): boolean;
        blockChanged(arg0: BlockPos_): void;
        getChunkFuture(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        getGenerator(): Internal.ChunkGenerator;
        removeTicketsOnClosing(): void;
        save(arg0: boolean): void;
        get dataStorage(): Internal.DimensionDataStorage
        set simulationDistance(arg0: number)
        get lastSpawnState(): Internal.NaturalSpawner$SpawnState
        set viewDistance(arg0: number)
        get tickingGenerated(): number
        get pendingTasksCount(): number
        get poiManager(): Internal.PoiManager
        get generator(): Internal.ChunkGenerator
        readonly chunkMap: Internal.ChunkMap;
        readonly level: Internal.ServerLevel;
    }
    type ServerChunkCache_ = ServerChunkCache;
    class CocoaBlock extends Internal.HorizontalDirectionalBlock implements Internal.BonemealableBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        isBonemealSuccess(arg0: Internal.Level_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        performBonemeal(arg0: Internal.ServerLevel_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        isValidBonemealTarget(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: boolean): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 2;
    }
    type CocoaBlock_ = CocoaBlock;
    class TransitionValues {
        constructor(view: Internal.View_)
        readonly view: Internal.View;
        readonly values: Internal.Map<string, any>;
    }
    type TransitionValues_ = TransitionValues;
    class WidgetLoadingHandler {
        constructor(arg0: Internal.WidgetScreenHandler_)
        loadWidget(arg0: string): void;
    }
    type WidgetLoadingHandler_ = WidgetLoadingHandler;
    class WidgetScreenHandler {
        constructor()
        handleClick(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        initialize(arg0: Internal.WidgetScreen_, arg1: number, arg2: number): void;
        renderTooltips(arg0: Internal.PoseStack_, arg1: Internal.Screen_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): boolean;
        render(arg0: Internal.PoseStack_, arg1: Internal.WidgetScreen_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
    }
    type WidgetScreenHandler_ = WidgetScreenHandler;
    interface Double2ObjectFunction <V> extends it.unimi.dsi.fastutil.Function<number, V>, Internal.DoubleFunction<V> {
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Double2ObjectFunction<T>;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2ObjectFunction<V>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Double2LongFunction;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Double2DoubleFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        remove(arg0: number): V;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Double2CharFunction;
        put(arg0: number, arg1: V): V;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2ObjectFunction<V>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Double2ByteFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Double2ShortFunction;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2ObjectFunction<V>;
        apply(arg0: number): V;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2ObjectFunction<V>;
        apply(arg0: number): V;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        get(arg0: number): V;
        containsKey(arg0: number): boolean;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Double2FloatFunction;
        getOrDefault(arg0: number, arg1: V): V;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2ObjectFunction<V>;
        size(): number;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Double2ReferenceFunction<T>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Double2IntFunction;
        clear(): void;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        defaultReturnValue(): V;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2ObjectFunction<V>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: number): V;
    }
    type Double2ObjectFunction_<V> = Double2ObjectFunction<V>;
    class GuiInitCompletedEvent extends Internal.Event {
        constructor()
        constructor(arg0: Internal.Screen_)
        getScreen(): Internal.Screen;
        get screen(): Internal.Screen
    }
    type GuiInitCompletedEvent_ = GuiInitCompletedEvent;
    class AtomicReference <V> implements Internal.Serializable {
        constructor()
        constructor(arg0: V)
        weakCompareAndSetPlain(arg0: V, arg1: V): boolean;
        updateAndGet(arg0: Internal.UnaryOperator_<V>): V;
        getAndSet(arg0: V): V;
        weakCompareAndSetRelease(arg0: V, arg1: V): boolean;
        setPlain(arg0: V): void;
        weakCompareAndSetAcquire(arg0: V, arg1: V): boolean;
        getAndUpdate(arg0: Internal.UnaryOperator_<V>): V;
        getOpaque(): V;
        getAcquire(): V;
        compareAndExchangeAcquire(arg0: V, arg1: V): V;
        weakCompareAndSetVolatile(arg0: V, arg1: V): boolean;
        lazySet(arg0: V): void;
        get(): V;
        setRelease(arg0: V): void;
        compareAndSet(arg0: V, arg1: V): boolean;
        compareAndExchangeRelease(arg0: V, arg1: V): V;
        /**
         * @deprecated
        */
        weakCompareAndSet(arg0: V, arg1: V): boolean;
        setOpaque(arg0: V): void;
        compareAndExchange(arg0: V, arg1: V): V;
        accumulateAndGet(arg0: V, arg1: Internal.BinaryOperator_<V>): V;
        getPlain(): V;
        set(arg0: V): void;
        getAndAccumulate(arg0: V, arg1: Internal.BinaryOperator_<V>): V;
        set plain(arg0: V)
        get opaque(): V
        get acquire(): V
        set release(arg0: V)
        set opaque(arg0: V)
        get plain(): V
    }
    type AtomicReference_<V> = AtomicReference<V>;
    interface ITrackedPlayerReader <P> {
        getX(arg0: P): number;
        getDimension(arg0: P): ResourceLocation;
        getY(arg0: P): number;
        getZ(arg0: P): number;
        getId(arg0: P): Internal.UUID;
    }
    type ITrackedPlayerReader_<P> = ITrackedPlayerReader<P>;
    class SerializerType <T> {
        constructor(arg0: Internal.Serializer_<T>)
        getSerializer(): Internal.Serializer<T>;
        get serializer(): Internal.Serializer<T>
    }
    type SerializerType_<T> = SerializerType<T>;
    interface WitchQuestEntity {
        getQuests(): Internal.WitchQuestList;
        getWitchLevel(): Internal.Level;
        setQuestsFromServer(arg0: Internal.WitchQuestList_): void;
        sendQuests(player: Internal.Player_, text: Internal.Component_): void;
        completeQuest(arg0: Internal.WitchQuest_): void;
        hasCustomer(): boolean;
        getYesSound(): Internal.SoundEvent;
        canInteract(arg0: Internal.Player_): boolean;
        setCurrentCustomer(arg0: Internal.Player_): void;
        getCurrentCustomer(): Internal.Player;
        get quests(): Internal.WitchQuestList
        get witchLevel(): Internal.Level
        set questsFromServer(arg0: Internal.WitchQuestList_)
        get yesSound(): Internal.SoundEvent
        set currentCustomer(arg0: Internal.Player_)
        get currentCustomer(): Internal.Player
    }
    type WitchQuestEntity_ = WitchQuestEntity;
    class BlockRenderDispatcher implements Internal.ResourceManagerReloadListener {
        constructor(arg0: Internal.BlockModelShaper_, arg1: Internal.BlockEntityWithoutLevelRenderer_, arg2: Internal.BlockColors_)
        /**
         * @deprecated
        */
        renderSingleBlock(arg0: Internal.BlockState_, arg1: Internal.PoseStack_, arg2: Internal.MultiBufferSource_, arg3: number, arg4: number): void;
        renderBreakingTexture(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: Internal.BlockAndTintGetter_, arg3: Internal.PoseStack_, arg4: Internal.VertexConsumer_, arg5: Internal.ModelData_): void;
        onResourceManagerReload(arg0: Internal.ResourceManager_): void;
        getBlockModelShaper(): Internal.BlockModelShaper;
        getModelRenderer(): Internal.ModelBlockRenderer;
        getBlockModel(arg0: Internal.BlockState_): Internal.BakedModel;
        renderSingleBlock(arg0: Internal.BlockState_, arg1: Internal.PoseStack_, arg2: Internal.MultiBufferSource_, arg3: number, arg4: number, arg5: Internal.ModelData_, arg6: Internal.RenderType_): void;
        getName(): string;
        /**
         * @deprecated
        */
        renderBreakingTexture(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: Internal.BlockAndTintGetter_, arg3: Internal.PoseStack_, arg4: Internal.VertexConsumer_): void;
        renderBatched(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: Internal.BlockAndTintGetter_, arg3: Internal.PoseStack_, arg4: Internal.VertexConsumer_, arg5: boolean, arg6: Internal.RandomSource_, arg7: Internal.ModelData_, arg8: Internal.RenderType_, arg9: boolean): void;
        /**
         * @deprecated
        */
        renderBatched(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: Internal.BlockAndTintGetter_, arg3: Internal.PoseStack_, arg4: Internal.VertexConsumer_, arg5: boolean, arg6: Internal.RandomSource_): void;
        renderBatched(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: Internal.BlockAndTintGetter_, arg3: Internal.PoseStack_, arg4: Internal.VertexConsumer_, arg5: boolean, arg6: Internal.RandomSource_, arg7: Internal.ModelData_, arg8: Internal.RenderType_): void;
        renderLiquid(arg0: BlockPos_, arg1: Internal.BlockAndTintGetter_, arg2: Internal.VertexConsumer_, arg3: Internal.BlockState_, arg4: Internal.FluidState_): void;
        reload(arg0: Internal.PreparableReloadListener$PreparationBarrier_, arg1: Internal.ResourceManager_, arg2: Internal.ProfilerFiller_, arg3: Internal.ProfilerFiller_, arg4: Internal.Executor_, arg5: Internal.Executor_): Internal.CompletableFuture<void>;
        get blockModelShaper(): Internal.BlockModelShaper
        get modelRenderer(): Internal.ModelBlockRenderer
        get name(): string
        modelRenderer: Internal.ModelBlockRenderer;
        liquidBlockRenderer: Internal.LiquidBlockRenderer;
        readonly blockEntityRenderer: Internal.BlockEntityWithoutLevelRenderer;
    }
    type BlockRenderDispatcher_ = BlockRenderDispatcher;
    class PickaxeItemBuilder extends Internal.HandheldItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): Internal.Item;
    }
    type PickaxeItemBuilder_ = PickaxeItemBuilder;
    class BlueIceFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(arg0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type BlueIceFeature_ = BlueIceFeature;
    class JEISubtypesEventJS extends Internal.EventJS {
        constructor(r: any_)
        useNBTKey(items: Internal.Ingredient_, key: string): void;
        registerInterpreter(item: Internal.Item_, interpreter: Internal.JEISubtypesEventJS$Interpreter_): void;
        useNBT(items: Internal.Ingredient_): void;
    }
    type JEISubtypesEventJS_ = JEISubtypesEventJS;
    class TickEvent$Type extends Internal.Enum<Internal.TickEvent$Type> {
        static valueOf(arg0: string): Internal.TickEvent$Type;
        static values(): Internal.TickEvent$Type[];
        static readonly RENDER: Internal.TickEvent$Type;
        static readonly LEVEL: Internal.TickEvent$Type;
        static readonly CLIENT: Internal.TickEvent$Type;
        static readonly SERVER: Internal.TickEvent$Type;
        static readonly PLAYER: Internal.TickEvent$Type;
    }
    type TickEvent$Type_ = "player" | "level" | "server" | "client" | TickEvent$Type | "render";
    interface WorldGenLevel extends Internal.ServerLevelAccessor {
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_): Internal.Player;
        getSeed(): number;
        dayTime(): number;
        getShade(arg0: Internal.Direction_, arg1: boolean): number;
        isUnobstructed(arg0: Internal.Entity_, arg1: Internal.VoxelShape_): boolean;
        getMaxSection(): number;
        getLevelData(): Internal.LevelData;
        getBrightness(arg0: Internal.LightLayer_, arg1: BlockPos_): number;
        getSectionYFromSectionIndex(arg0: number): number;
        players(): Internal.List<Internal.Player>;
        getBiomeManager(): Internal.BiomeManager;
        getRandom(): Internal.RandomSource;
        isEmptyBlock(arg0: BlockPos_): boolean;
        getMaxLocalRawBrightness(arg0: BlockPos_, arg1: number): number;
        removeBlock(arg0: BlockPos_, arg1: boolean): boolean;
        getBlockCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        isOutsideBuildHeight(arg0: BlockPos_): boolean;
        getTimeOfDay(arg0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        getHeightmapPos(arg0: Internal.Heightmap$Types_, arg1: BlockPos_): BlockPos;
        blockUpdated(arg0: BlockPos_, arg1: Internal.Block_): void;
        setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number, arg3: number): boolean;
        isClientSide(): boolean;
        getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.List<Internal.Entity>;
        getEntitiesOfClass<T extends Internal.Entity>(arg0: T, arg1: Internal.AABB_): Internal.List<T>;
        getBlockTicks(): Internal.LevelTickAccess<Internal.Block>;
        getBlockStates(arg0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels(arg0: BlockPos_): number;
        dimensionType(): Internal.DimensionType;
        getSkyDarken(): number;
        getMinBuildHeight(): number;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Fluid_, arg2: number): void;
        getNearestPlayer(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): Internal.Player;
        destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_, arg3: number): boolean;
        /**
         * @deprecated
        */
        getSeaLevel(): number;
        /**
         * @deprecated
        */
        hasChunkAt(arg0: number, arg1: number): boolean;
        getFluidTicks(): Internal.LevelTickAccess<Internal.Fluid>;
        getSectionIndex(arg0: number): number;
        ensureCanWrite(arg0: BlockPos_): boolean;
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: number, arg2: number, arg3: number): Internal.Player;
        getMaxBuildHeight(): number;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: BlockPos_, arg1: BlockPos_): boolean;
        destroyBlock(arg0: BlockPos_, arg1: boolean): boolean;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Block_, arg2: number): void;
        getChunk(arg0: number, arg1: number): Internal.ChunkAccess;
        addFreshEntity(arg0: Internal.Entity_): boolean;
        getCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_): boolean;
        getHeight(): number;
        getChunk(arg0: BlockPos_): Internal.ChunkAccess;
        isFluidAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.FluidState>): boolean;
        getWorldBorder(): Internal.WorldBorder;
        getMaxLocalRawBrightness(arg0: BlockPos_): number;
        isUnobstructed(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: Internal.CollisionContext_): boolean;
        /**
         * @deprecated
        */
        hasChunkAt(arg0: BlockPos_): boolean;
        getBiome(arg0: BlockPos_): Internal.Holder<Internal.Biome>;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(arg0: BlockPos_): number;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Block_, arg2: number, arg3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        gameEvent(arg0: Internal.GameEvent_, arg1: Vec3_, arg2: Internal.GameEvent$Context_): void;
        getEntitiesOfClass<T extends Internal.Entity>(arg0: T, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_, arg2: number, arg3: number, arg4: number): Internal.Player;
        neighborShapeChanged(arg0: Internal.Direction_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: BlockPos_, arg4: number, arg5: number): void;
        getBlockTint(arg0: BlockPos_, arg1: Internal.ColorResolver_): number;
        getMinSection(): number;
        findFreePosition(arg0: Internal.Entity_, arg1: Internal.VoxelShape_, arg2: Vec3_, arg3: number, arg4: number, arg5: number): Internal.Optional<Vec3>;
        getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride(arg0: Vec3_, arg1: Vec3_, arg2: BlockPos_, arg3: Internal.VoxelShape_, arg4: Internal.BlockState_): Internal.BlockHitResult;
        playSound(arg0: Internal.Player_, arg1: BlockPos_, arg2: Internal.SoundEvent_, arg3: Internal.SoundSource_, arg4: number, arg5: number): void;
        getNearestPlayer(arg0: Internal.Entity_, arg1: number): Internal.Player;
        getBlockFloorHeight(arg0: BlockPos_): number;
        getLightEmission(arg0: BlockPos_): number;
        getBlockStatesIfLoaded(arg0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getShade(arg0: number, arg1: number, arg2: number, arg3: boolean): number;
        create(arg0: number, arg1: number): Internal.LevelHeightAccessor;
        clip(arg0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>(arg0: BlockPos_, arg1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness(arg0: BlockPos_, arg1: number): number;
        addParticle(arg0: Internal.ParticleOptions_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
        getCurrentDifficultyAt(arg0: BlockPos_): Internal.DifficultyInstance;
        getDifficulty(): Internal.Difficulty;
        canSeeSky(arg0: BlockPos_): boolean;
        getMoonPhase(): number;
        isUnobstructed(arg0: Internal.Entity_): boolean;
        getNearestEntity<T extends Internal.LivingEntity>(arg0: Internal.List_<T>, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number): T;
        getUncachedNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        addFreshEntityWithPassengers(arg0: Internal.Entity_): void;
        getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_, arg2: Internal.Predicate_<Internal.Entity>): Internal.List<Internal.Entity>;
        getPlayerByUUID(arg0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater(arg0: BlockPos_): boolean;
        getHeight(arg0: Internal.Heightmap$Types_, arg1: number, arg2: number): number;
        getSectionsCount(): number;
        isStateAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.BlockState>): boolean;
        getNearbyPlayers(arg0: Internal.TargetingConditions_, arg1: Internal.LivingEntity_, arg2: Internal.AABB_): Internal.List<Internal.Player>;
        getSectionIndexFromSectionY(arg0: number): number;
        getServer(): Internal.MinecraftServer;
        levelEvent(arg0: Internal.Player_, arg1: number, arg2: BlockPos_, arg3: number): void;
        setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number): boolean;
        getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_): Internal.ChunkAccess;
        noCollision(arg0: Internal.Entity_): boolean;
        getLevel(): Internal.ServerLevel;
        getEntities<T extends Internal.Entity>(arg0: Internal.EntityTypeTest_<Internal.Entity, T>, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        hasChunk(arg0: number, arg1: number): boolean;
        getNearbyEntities<T extends Internal.LivingEntity>(arg0: T, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: Internal.AABB_): Internal.List<T>;
        getMoonBrightness(): number;
        noCollision(arg0: Internal.AABB_): boolean;
        isWaterAt(arg0: BlockPos_): boolean;
        getDirectSignal(arg0: BlockPos_, arg1: Internal.Direction_): number;
        getEntityCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight(arg0: Internal.VoxelShape_, arg1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock(arg0: Internal.Entity_, arg1: Internal.AABB_): boolean;
        getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        setCurrentlyGenerating(arg0: Internal.Supplier_<string>): void;
        gameEvent(arg0: Internal.GameEvent_, arg1: BlockPos_, arg2: Internal.GameEvent$Context_): void;
        getModelDataManager(): Internal.ModelDataManager;
        noCollision(arg0: Internal.Entity_, arg1: Internal.AABB_): boolean;
        scheduleTick(arg0: BlockPos_, arg1: Internal.Fluid_, arg2: number, arg3: Internal.TickPriority_): void;
        isOutsideBuildHeight(arg0: number): boolean;
        getNearestPlayer(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine(arg0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        gameEvent(arg0: Internal.Entity_, arg1: Internal.GameEvent_, arg2: Vec3_): void;
        getFluidState(arg0: BlockPos_): Internal.FluidState;
        getChunkSource(): Internal.ChunkSource;
        getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        registryAccess(): Internal.RegistryAccess;
        levelEvent(arg0: number, arg1: BlockPos_, arg2: number): void;
        getExistingBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        nextSubTickCount(): number;
        gameEvent(arg0: Internal.Entity_, arg1: Internal.GameEvent_, arg2: BlockPos_): void;
        getChunkForCollisions(arg0: number, arg1: number): Internal.BlockGetter;
        containsAnyLiquid(arg0: Internal.AABB_): boolean;
        getMaxLightLevel(): number;
        getNearestEntity<T extends Internal.LivingEntity>(arg0: T, arg1: Internal.TargetingConditions_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number, arg6: Internal.AABB_): T;
        isAreaLoaded(arg0: BlockPos_, arg1: number): boolean;
        traverseBlocks<T, C>(arg0: Vec3_, arg1: Vec3_, arg2: C, arg3: Internal.BiFunction_<C, BlockPos, T>, arg4: Internal.Function_<C, T>): T;
        get seed(): number
        get maxSection(): number
        get levelData(): Internal.LevelData
        get biomeManager(): Internal.BiomeManager
        get random(): Internal.RandomSource
        get clientSide(): boolean
        get blockTicks(): Internal.LevelTickAccess<Internal.Block>
        get skyDarken(): number
        get minBuildHeight(): number
        /**
         * @deprecated
        */
        get seaLevel(): number
        get fluidTicks(): Internal.LevelTickAccess<Internal.Fluid>
        get maxBuildHeight(): number
        get height(): number
        get worldBorder(): Internal.WorldBorder
        get minSection(): number
        get difficulty(): Internal.Difficulty
        get moonPhase(): number
        get sectionsCount(): number
        get server(): Internal.MinecraftServer
        get level(): Internal.ServerLevel
        get moonBrightness(): number
        get lightEngine(): Internal.LevelLightEngine
        set currentlyGenerating(arg0: Internal.Supplier_<string>)
        get modelDataManager(): Internal.ModelDataManager
        get chunkSource(): Internal.ChunkSource
        get maxLightLevel(): number
    }
    type WorldGenLevel_ = WorldGenLevel;
    abstract class ByteBuf implements Internal.ByteBufConvertible, Internal.Comparable<Internal.ByteBuf>, Internal.ReferenceCounted {
        constructor()
        indexOf(arg0: number, arg1: number, arg2: number): number;
        getBytes(arg0: number, arg1: Internal.OutputStream_, arg2: number): this;
        readShortLE(): number;
        readableBytes(): number;
        writeInt(arg0: number): this;
        readDouble(): number;
        maxFastWritableBytes(): number;
        skipBytes(arg0: number): this;
        forEachByteDesc(arg0: Internal.ByteProcessor_): number;
        markReaderIndex(): this;
        nioBufferCount(): number;
        markWriterIndex(): this;
        nioBuffers(): Internal.ByteBuffer[];
        getShortLE(arg0: number): number;
        writeBytes(arg0: number[], arg1: number, arg2: number): this;
        setBytes(arg0: number, arg1: Internal.FileChannel_, arg2: number, arg3: number): number;
        getFloat(arg0: number): number;
        writeFloat(arg0: number): this;
        memoryAddress(): number;
        setFloat(arg0: number, arg1: number): this;
        ensureWritable(arg0: number): this;
        forEachByte(arg0: number, arg1: number, arg2: Internal.ByteProcessor_): number;
        resetWriterIndex(): this;
        isReadable(arg0: number): boolean;
        getMediumLE(arg0: number): number;
        maxWritableBytes(): number;
        getBytes(arg0: number, arg1: Internal.GatheringByteChannel_, arg2: number): number;
        readUnsignedMedium(): number;
        isReadable(): boolean;
        readIntLE(): number;
        getByte(arg0: number): number;
        writeShort(arg0: number): this;
        getMedium(arg0: number): number;
        bytesBefore(arg0: number, arg1: number): number;
        writeBytes(arg0: Internal.InputStream_, arg1: number): number;
        retain(arg0: number): Internal.ReferenceCounted;
        compareTo(arg0: Internal.ByteBuf_): number;
        touch(arg0: any): Internal.ReferenceCounted;
        readUnsignedMediumLE(): number;
        writeIntLE(arg0: number): this;
        readBoolean(): boolean;
        setMediumLE(arg0: number, arg1: number): this;
        slice(): this;
        writeMedium(arg0: number): this;
        copy(arg0: number, arg1: number): this;
        setCharSequence(arg0: number, arg1: Internal.CharSequence_, arg2: Internal.Charset_): number;
        isReadOnly(): boolean;
        resetReaderIndex(): this;
        writeLongLE(arg0: number): this;
        setDoubleLE(arg0: number, arg1: number): this;
        writeCharSequence(arg0: Internal.CharSequence_, arg1: Internal.Charset_): number;
        release(): boolean;
        getBytes(arg0: number, arg1: Internal.ByteBuf_): this;
        readBytes(arg0: number[]): this;
        readByte(): number;
        writerIndex(arg0: number): this;
        readUnsignedShort(): number;
        forEachByteDesc(arg0: number, arg1: number, arg2: Internal.ByteProcessor_): number;
        writeMediumLE(arg0: number): this;
        release(arg0: number): boolean;
        setBytes(arg0: number, arg1: Internal.ByteBuf_): this;
        forEachByte(arg0: Internal.ByteProcessor_): number;
        writeBytes(arg0: Internal.FileChannel_, arg1: number, arg2: number): number;
        isContiguous(): boolean;
        setLongLE(arg0: number, arg1: number): this;
        arrayOffset(): number;
        retainedSlice(arg0: number, arg1: number): this;
        readBytes(arg0: Internal.ByteBuffer_): this;
        getUnsignedByte(arg0: number): number;
        writeBytes(arg0: Internal.ByteBuf_, arg1: number, arg2: number): this;
        readBytes(arg0: Internal.ByteBuf_, arg1: number): this;
        readBytes(arg0: number[], arg1: number, arg2: number): this;
        retainedSlice(): this;
        nioBuffer(arg0: number, arg1: number): Internal.ByteBuffer;
        setShort(arg0: number, arg1: number): this;
        getUnsignedInt(arg0: number): number;
        getUnsignedMedium(arg0: number): number;
        getUnsignedMediumLE(arg0: number): number;
        readDoubleLE(): number;
        getBoolean(arg0: number): boolean;
        writeZero(arg0: number): this;
        maxCapacity(): number;
        getCharSequence(arg0: number, arg1: number, arg2: Internal.Charset_): Internal.CharSequence;
        nioBuffer(): Internal.ByteBuffer;
        clear(): this;
        readMedium(): number;
        readBytes(arg0: Internal.FileChannel_, arg1: number, arg2: number): number;
        unwrap(): this;
        retain(): Internal.ReferenceCounted;
        readUnsignedShortLE(): number;
        internalNioBuffer(arg0: number, arg1: number): Internal.ByteBuffer;
        writeBytes(arg0: number[]): this;
        discardReadBytes(): this;
        writeChar(arg0: number): this;
        setBytes(arg0: number, arg1: Internal.InputStream_, arg2: number): number;
        getFloatLE(arg0: number): number;
        duplicate(): this;
        readerIndex(): number;
        isWritable(): boolean;
        getDouble(arg0: number): number;
        setByte(arg0: number, arg1: number): this;
        readBytes(arg0: Internal.GatheringByteChannel_, arg1: number): number;
        capacity(arg0: number): this;
        readUnsignedInt(): number;
        isDirect(): boolean;
        writeDouble(arg0: number): this;
        writerIndex(): number;
        retainedDuplicate(): this;
        getBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number, arg3: number): this;
        setBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number, arg3: number): this;
        setShortLE(arg0: number, arg1: number): this;
        setFloatLE(arg0: number, arg1: number): this;
        compareTo(arg0: any): number;
        setLong(arg0: number, arg1: number): this;
        readMediumLE(): number;
        writableBytes(): number;
        writeFloatLE(arg0: number): this;
        /**
         * @deprecated
        */
        order(): Internal.ByteOrder;
        getUnsignedIntLE(arg0: number): number;
        getChar(arg0: number): string;
        writeBytes(arg0: Internal.ByteBuf_, arg1: number): this;
        readChar(): string;
        discardSomeReadBytes(): this;
        setInt(arg0: number, arg1: number): this;
        bytesBefore(arg0: number, arg1: number, arg2: number): number;
        asByteBuf(): this;
        isWritable(arg0: number): boolean;
        alloc(): Internal.ByteBufAllocator;
        bytesBefore(arg0: number): number;
        readInt(): number;
        nioBuffers(arg0: number, arg1: number): Internal.ByteBuffer[];
        readRetainedSlice(arg0: number): this;
        setBytes(arg0: number, arg1: number[]): this;
        setChar(arg0: number, arg1: number): this;
        readFloatLE(): number;
        writeBytes(arg0: Internal.ByteBuffer_): this;
        writeShortLE(arg0: number): this;
        array(): number[];
        getLong(arg0: number): number;
        readShort(): number;
        getIntLE(arg0: number): number;
        readBytes(arg0: Internal.OutputStream_, arg1: number): this;
        slice(arg0: number, arg1: number): this;
        readerIndex(arg0: number): this;
        setBytes(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        capacity(): number;
        readCharSequence(arg0: number, arg1: Internal.Charset_): Internal.CharSequence;
        writeDoubleLE(arg0: number): this;
        getBytes(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        asReadOnly(): this;
        hasMemoryAddress(): boolean;
        getBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number): this;
        getLongLE(arg0: number): number;
        setZero(arg0: number, arg1: number): this;
        readLongLE(): number;
        readSlice(arg0: number): this;
        getShort(arg0: number): number;
        setBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number): this;
        writeLong(arg0: number): this;
        readFloat(): number;
        readBytes(arg0: Internal.ByteBuf_): this;
        getDoubleLE(arg0: number): number;
        readUnsignedIntLE(): number;
        getBytes(arg0: number, arg1: Internal.ByteBuffer_): this;
        getInt(arg0: number): number;
        getBytes(arg0: number, arg1: number[]): this;
        writeBytes(arg0: Internal.ScatteringByteChannel_, arg1: number): number;
        writeBoolean(arg0: boolean): this;
        setIndex(arg0: number, arg1: number): this;
        setMedium(arg0: number, arg1: number): this;
        hasArray(): boolean;
        setBoolean(arg0: number, arg1: boolean): this;
        writeBytes(arg0: Internal.ByteBuf_): this;
        setBytes(arg0: number, arg1: Internal.ScatteringByteChannel_, arg2: number): number;
        writeByte(arg0: number): this;
        readLong(): number;
        touch(): Internal.ReferenceCounted;
        copy(): this;
        readBytes(arg0: Internal.ByteBuf_, arg1: number, arg2: number): this;
        ensureWritable(arg0: number, arg1: boolean): number;
        getUnsignedShort(arg0: number): number;
        getBytes(arg0: number, arg1: Internal.FileChannel_, arg2: number, arg3: number): number;
        setDouble(arg0: number, arg1: number): this;
        readBytes(arg0: number): this;
        readUnsignedByte(): number;
        refCnt(): number;
        getUnsignedShortLE(arg0: number): number;
        setIntLE(arg0: number, arg1: number): this;
        toString(arg0: Internal.Charset_): string;
        /**
         * @deprecated
        */
        order(arg0: Internal.ByteOrder_): this;
        setBytes(arg0: number, arg1: Internal.ByteBuffer_): this;
        toString(arg0: number, arg1: number, arg2: Internal.Charset_): string;
        get readable(): boolean
        get readOnly(): boolean
        get contiguous(): boolean
        get writable(): boolean
        get direct(): boolean
    }
    type ByteBuf_ = ByteBuf;
    class ClipContext {
        constructor(arg0: Vec3_, arg1: Vec3_, arg2: any_, arg3: Internal.ClipContext$Fluid_, arg4: Internal.Entity_)
        getFluidShape(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        getFrom(): Vec3;
        getTo(): Vec3;
        getBlockShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        get from(): Vec3
        get to(): Vec3
    }
    type ClipContext_ = ClipContext;
    class CarverDebugSettings {
        getAirState(): Internal.BlockState;
        static of(arg0: boolean, arg1: Internal.BlockState_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.BlockState_): Internal.CarverDebugSettings;
        getBarrierState(): Internal.BlockState;
        getWaterState(): Internal.BlockState;
        getLavaState(): Internal.BlockState;
        static of(arg0: boolean, arg1: Internal.BlockState_): Internal.CarverDebugSettings;
        static of(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): Internal.CarverDebugSettings;
        isDebugMode(): boolean;
        get airState(): Internal.BlockState
        get barrierState(): Internal.BlockState
        get waterState(): Internal.BlockState
        get lavaState(): Internal.BlockState
        get debugMode(): boolean
        static readonly DEFAULT: Internal.CarverDebugSettings;
        static readonly CODEC: Internal.Codec<Internal.CarverDebugSettings>;
    }
    type CarverDebugSettings_ = CarverDebugSettings;
    interface MenuItem$OnActionExpandListener {
        onMenuItemActionExpand(arg0: Internal.MenuItem_): boolean;
        onMenuItemActionCollapse(arg0: Internal.MenuItem_): boolean;
    }
    type MenuItem$OnActionExpandListener_ = MenuItem$OnActionExpandListener;
    class PaintingVariant {
        constructor(arg0: number, arg1: number)
        getWidth(): number;
        getHeight(): number;
        get width(): number
        get height(): number
    }
    type PaintingVariant_ = PaintingVariant | Special.PaintingVariant;
    class WorldBorder {
        constructor()
        getDamagePerBlock(): number;
        getLerpRemainingTime(): number;
        clampToBounds(arg0: number, arg1: number, arg2: number): BlockPos;
        getMaxZ(): number;
        removeListener(arg0: Internal.BorderChangeListener_): void;
        getMaxX(): number;
        getAbsoluteMaxSize(): number;
        getLerpSpeed(): number;
        getCenterZ(): number;
        isWithinBounds(arg0: number, arg1: number, arg2: number): boolean;
        getCenterX(): number;
        setWarningTime(arg0: number): void;
        getCollisionShape(): Internal.VoxelShape;
        setCenter(arg0: number, arg1: number): void;
        getStatus(): Internal.BorderStatus;
        setDamageSafeZone(arg0: number): void;
        getWarningTime(): number;
        setSize(arg0: number): void;
        applySettings(arg0: Internal.WorldBorder$Settings_): void;
        getMinX(): number;
        getWarningBlocks(): number;
        createSettings(): Internal.WorldBorder$Settings;
        getMinZ(): number;
        addListener(arg0: Internal.BorderChangeListener_): void;
        isWithinBounds(arg0: Internal.AABB_): boolean;
        getDistanceToBorder(arg0: Internal.Entity_): number;
        getSize(): number;
        getDamageSafeZone(): number;
        lerpSizeBetween(arg0: number, arg1: number, arg2: number): void;
        tick(): void;
        setDamagePerBlock(arg0: number): void;
        getLerpTarget(): number;
        getDistanceToBorder(arg0: number, arg1: number): number;
        setAbsoluteMaxSize(arg0: number): void;
        isWithinBounds(arg0: BlockPos_): boolean;
        isInsideCloseToBorder(arg0: Internal.Entity_, arg1: Internal.AABB_): boolean;
        isWithinBounds(arg0: number, arg1: number): boolean;
        isWithinBounds(arg0: Internal.ChunkPos_): boolean;
        setWarningBlocks(arg0: number): void;
        get damagePerBlock(): number
        get lerpRemainingTime(): number
        get maxZ(): number
        get maxX(): number
        get absoluteMaxSize(): number
        get lerpSpeed(): number
        get centerZ(): number
        get centerX(): number
        set warningTime(arg0: number)
        get collisionShape(): Internal.VoxelShape
        get status(): Internal.BorderStatus
        set damageSafeZone(arg0: number)
        get warningTime(): number
        set size(arg0: number)
        get minX(): number
        get warningBlocks(): number
        get minZ(): number
        get size(): number
        get damageSafeZone(): number
        set damagePerBlock(arg0: number)
        get lerpTarget(): number
        set absoluteMaxSize(arg0: number)
        set warningBlocks(arg0: number)
        static readonly MAX_CENTER_COORDINATE: 2.9999984E7;
        static readonly MAX_SIZE: 5.9999968E7;
        static readonly DEFAULT_SETTINGS: Internal.WorldBorder$Settings;
    }
    type WorldBorder_ = WorldBorder;
    class TrapezoidHeight extends Internal.HeightProvider {
        static of(arg0: Internal.VerticalAnchor_, arg1: Internal.VerticalAnchor_): Internal.TrapezoidHeight;
        static of(arg0: Internal.VerticalAnchor_, arg1: Internal.VerticalAnchor_, arg2: number): Internal.TrapezoidHeight;
        static readonly CODEC: Internal.Codec<Internal.TrapezoidHeight>;
    }
    type TrapezoidHeight_ = TrapezoidHeight;
    interface ArtifactRepository {
        setLayout(arg0: Internal.ArtifactRepositoryLayout_): void;
        getBasedir(): string;
        getKey(): string;
        setBlocked(arg0: boolean): void;
        isBlocked(): boolean;
        getLayout(): Internal.ArtifactRepositoryLayout;
        setReleaseUpdatePolicy(arg0: Internal.ArtifactRepositoryPolicy_): void;
        setProxy(arg0: org.apache.maven.repository.Proxy_): void;
        setAuthentication(arg0: Internal.Authentication_): void;
        setMirroredRepositories(arg0: Internal.List_<Internal.ArtifactRepository>): void;
        pathOfLocalRepositoryMetadata(arg0: org.apache.maven.artifact.metadata.ArtifactMetadata_, arg1: Internal.ArtifactRepository_): string;
        /**
         * @deprecated
        */
        setBlacklisted(arg0: boolean): void;
        getMirroredRepositories(): Internal.List<Internal.ArtifactRepository>;
        getProxy(): org.apache.maven.repository.Proxy;
        setSnapshotUpdatePolicy(arg0: Internal.ArtifactRepositoryPolicy_): void;
        setId(arg0: string): void;
        getAuthentication(): Internal.Authentication;
        find(arg0: Internal.Artifact_): Internal.Artifact;
        findVersions(arg0: Internal.Artifact_): Internal.List<string>;
        getId(): string;
        /**
         * @deprecated
        */
        isBlacklisted(): boolean;
        /**
         * @deprecated
        */
        isUniqueVersion(): boolean;
        getSnapshots(): Internal.ArtifactRepositoryPolicy;
        setUrl(arg0: string): void;
        getProtocol(): string;
        pathOfRemoteRepositoryMetadata(arg0: org.apache.maven.artifact.metadata.ArtifactMetadata_): string;
        isProjectAware(): boolean;
        getUrl(): string;
        pathOf(arg0: Internal.Artifact_): string;
        getReleases(): Internal.ArtifactRepositoryPolicy;
        set layout(arg0: Internal.ArtifactRepositoryLayout_)
        get basedir(): string
        get key(): string
        set blocked(arg0: boolean)
        get blocked(): boolean
        get layout(): Internal.ArtifactRepositoryLayout
        set releaseUpdatePolicy(arg0: Internal.ArtifactRepositoryPolicy_)
        set proxy(arg0: org.apache.maven.repository.Proxy_)
        set authentication(arg0: Internal.Authentication_)
        set mirroredRepositories(arg0: Internal.List_<Internal.ArtifactRepository>)
        /**
         * @deprecated
        */
        set blacklisted(arg0: boolean)
        get mirroredRepositories(): Internal.List<Internal.ArtifactRepository>
        get proxy(): org.apache.maven.repository.Proxy
        set snapshotUpdatePolicy(arg0: Internal.ArtifactRepositoryPolicy_)
        set id(arg0: string)
        get authentication(): Internal.Authentication
        get id(): string
        /**
         * @deprecated
        */
        get blacklisted(): boolean
        /**
         * @deprecated
        */
        get uniqueVersion(): boolean
        get snapshots(): Internal.ArtifactRepositoryPolicy
        set url(arg0: string)
        get protocol(): string
        get projectAware(): boolean
        get url(): string
        get releases(): Internal.ArtifactRepositoryPolicy
    }
    type ArtifactRepository_ = ArtifactRepository;
    class ResourceAllocator$Register {
        constructor(proxy: Internal.TextureProxy_, provider: icyllis.arc3d.engine.ResourceProvider_, scratch: boolean)
        instantiateTexture(proxy: Internal.TextureProxy_, resourceProvider: icyllis.arc3d.engine.ResourceProvider_): boolean;
        isRecyclable(proxy: Internal.SurfaceProxy_, knownUseCount: number): boolean;
        refCntGreaterThan(proxy: Internal.SurfaceProxy_, threadIsolatedTestCnt: number): boolean;
        reset(): boolean;
        init(proxy: Internal.TextureProxy_, provider: icyllis.arc3d.engine.ResourceProvider_, scratch: boolean): this;
    }
    type ResourceAllocator$Register_ = ResourceAllocator$Register;
    abstract class PatrollingMonster extends Internal.Monster {
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        canBeLeader(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        setPatrolTarget(arg0: BlockPos_): void;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        equipped(arg0: Internal.ItemEntity_): boolean;
        swing(): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        static checkPatrollingMonsterSpawnRules(arg0: Internal.EntityType_<Internal.PatrollingMonster>, arg1: Internal.LevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        getPatrolTarget(): BlockPos;
        canJoinPatrol(): boolean;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        static isBlocked(entity: Internal.Entity_): boolean;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        hasPatrolTarget(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        setPatrolLeader(arg0: boolean): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        isPatrolLeader(): boolean;
        findPatrolTarget(): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        set patrolTarget(arg0: BlockPos_)
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get patrolTarget(): BlockPos
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        set patrolLeader(arg0: boolean)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get patrolLeader(): boolean
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type PatrollingMonster_ = PatrollingMonster;
    abstract class CustomizeGuiOverlayEvent extends Internal.Event {
        constructor()
        getPartialTick(): number;
        getPoseStack(): Internal.PoseStack;
        getWindow(): Internal.Window;
        get partialTick(): number
        get poseStack(): Internal.PoseStack
        get window(): Internal.Window
    }
    type CustomizeGuiOverlayEvent_ = CustomizeGuiOverlayEvent;
    class RecipeCollection {
        constructor(arg0: Internal.List_<Internal.Recipe<any>>)
        hasKnownRecipes(): boolean;
        hasSingleResultItem(): boolean;
        hasFitting(): boolean;
        canCraft(arg0: Internal.StackedContents_, arg1: number, arg2: number, arg3: Internal.RecipeBook_): void;
        hasCraftable(): boolean;
        getRecipes(arg0: boolean): Internal.List<Internal.Recipe<any>>;
        isCraftable(arg0: Internal.Recipe_<any>): boolean;
        getDisplayRecipes(arg0: boolean): Internal.List<Internal.Recipe<any>>;
        getRecipes(): Internal.List<Internal.Recipe<any>>;
        updateKnownRecipes(arg0: Internal.RecipeBook_): void;
        get recipes(): Internal.List<Internal.Recipe<any>>
    }
    type RecipeCollection_ = RecipeCollection;
    class MobEffectEvent$Expired extends Internal.MobEffectEvent {
        constructor()
        constructor(arg0: Internal.LivingEntity_, arg1: Internal.MobEffectInstance_)
        getEntity(): Internal.Entity;
        get entity(): Internal.Entity
    }
    type MobEffectEvent$Expired_ = MobEffectEvent$Expired;
    class ChestType extends Internal.Enum<Internal.ChestType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        static valueOf(arg0: string): Internal.ChestType;
        getSerializedName(): string;
        getOpposite(): this;
        static values(): Internal.ChestType[];
        get serializedName(): string
        get opposite(): Internal.ChestType
        static readonly SINGLE: Internal.ChestType;
        static readonly LEFT: Internal.ChestType;
        static readonly RIGHT: Internal.ChestType;
        static readonly BY_ID: Internal.ChestType[];
    }
    type ChestType_ = "single" | ChestType | "right" | "left";
    abstract class OutputStream implements Internal.Closeable, Internal.Flushable {
        constructor()
        flush(): void;
        write(arg0: number): void;
        static nullOutputStream(): Internal.OutputStream;
        close(): void;
        write(arg0: number[], arg1: number, arg2: number): void;
        write(arg0: number[]): void;
    }
    type OutputStream_ = OutputStream;
    class Wolf extends Internal.TamableAnimal implements Internal.NeutralMob {
        constructor(arg0: Internal.EntityType_<Internal.Wolf>, arg1: Internal.Level_)
        isAlwaysBaby(): boolean;
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        equipped(arg0: Internal.ItemEntity_): boolean;
        swing(): void;
        isWet(): boolean;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        readPersistentAngerSaveData(arg0: Internal.Level_, arg1: Internal.CompoundTag_): void;
        stopBeingAngry(): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        getOwner(): Internal.Entity;
        damageHeldItem(): void;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        setCollarColor(arg0: Internal.DyeColor_): void;
        static setStunted(entity: Internal.AgeableMob_, stunted: boolean): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        forgetCurrentTargetAndRefreshUniversalAnger(): void;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        getTailAngle(): number;
        addPersistentAngerSaveData(arg0: Internal.CompoundTag_): void;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        static isBlocked(entity: Internal.Entity_): boolean;
        shouldRiderSit(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        getPersistentAngerTarget(): Internal.UUID;
        static checkWolfSpawnRules(arg0: Internal.EntityType_<Internal.Wolf>, arg1: Internal.LevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        isAngryAtAllPlayers(arg0: Internal.Level_): boolean;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        getCollarColor(): Internal.DyeColor;
        getDefaultMovementSpeed(): number;
        resetEndimation(): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        playerDied(arg0: Internal.Player_): void;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        isAngry(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        startPersistentAngerTimer(): void;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        getBodyRollAngle(arg0: number, arg1: number): number;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        setRemainingPersistentAngerTime(arg0: number): void;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        setPersistentAngerTarget(arg0: Internal.UUID_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        setOffHandItem(item: Internal.ItemStack_): void;
        setDefaultMovementSpeed(speed: number): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        setIsInterested(arg0: boolean): void;
        getWetShade(arg0: number): number;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        isInterested(): boolean;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        isAngryAt(arg0: Internal.LivingEntity_): boolean;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(arg0: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getRemainingPersistentAngerTime(): number;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        getHeadRollAngle(arg0: number): number;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        updatePersistentAnger(arg0: Internal.ServerLevel_, arg1: boolean): void;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        get alwaysBaby(): boolean
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get wet(): boolean
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get owner(): Internal.Entity
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set collarColor(arg0: Internal.DyeColor_)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get tailAngle(): number
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get persistentAngerTarget(): Internal.UUID
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get collarColor(): Internal.DyeColor
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get angry(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        set remainingPersistentAngerTime(arg0: number)
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        set persistentAngerTarget(arg0: Internal.UUID_)
        get feetArmorItem(): Internal.ItemStack
        set offHandItem(item: Internal.ItemStack_)
        set defaultMovementSpeed(speed: number)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set isInterested(arg0: boolean)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        get interested(): boolean
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(arg0: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get remainingPersistentAngerTime(): number
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly PREY_SELECTOR: Internal.Predicate<Internal.LivingEntity>;
    }
    type Wolf_ = Wolf;
    class AttachedData <T> extends Internal.HashMap<string, any> {
        constructor(p: T)
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        static of<K, V>(): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        add(key: string, data: any): void;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        getParent(): T;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        get parent(): T
    }
    type AttachedData_<T> = AttachedData<T>;
    class EndCrystal extends Internal.Entity {
        constructor(arg0: Internal.EntityType_<Internal.EndCrystal>, arg1: Internal.Level_)
        constructor(arg0: Internal.Level_, arg1: number, arg2: number, arg3: number)
        getDistance(pos: BlockPos_): number;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        setFullNBT(nbt: Internal.CompoundTag_): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        isNoEndimationPlaying(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isLiving(): boolean;
        alwaysAccepts(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        showsBottom(): boolean;
        getEffectHandler(): Internal.EndimationEffectHandler;
        getDisplayName(): Internal.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getAnimationTick(): number;
        /**
         * @deprecated
        */
        getFullNBT(): Internal.CompoundTag;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        getPlayingEndimation(): Internal.PlayableEndimation;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        onEndimationStart(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        shouldRiderSit(): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        setBeamTarget(arg0: BlockPos_): void;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        isFrame(): boolean;
        playSound(id: Internal.SoundEvent_): void;
        resetEndimation(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        updateListeners(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        isPeacefulCreature(): boolean;
        onEndimationEnd(arg0: Internal.PlayableEndimation_, arg1: Internal.PlayableEndimation_): void;
        setRotation(yaw: number, pitch: number): void;
        isDynamicLightEnabled(): boolean;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getMotionY(): number;
        setPlayingEndimation(arg0: Internal.PlayableEndimation_): void;
        getName(): Internal.Component;
        getPassengers(): Internal.EntityArrayList;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        static addGlowTicks(arg0: Internal.Entity_, arg1: number): void;
        setMotionX(x: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        /**
         * @deprecated
        */
        mergeFullNBT(tag: Internal.CompoundTag_): Internal.Entity;
        isEndimationPlaying(arg0: Internal.PlayableEndimation_): boolean;
        setNbt(nbt: Internal.CompoundTag_): void;
        getScriptType(): Internal.ScriptType;
        setAnimationTick(arg0: number): void;
        isMultipartEntity(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(arg0: boolean): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        getMotionZ(): number;
        tell(message: Internal.Component_): void;
        getBeamTarget(): BlockPos;
        setZ(z: number): void;
        setStatusMessage(message: Internal.Component_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getDistanceSq(pos: BlockPos_): number;
        endimateTick(): void;
        getProfile(): Internal.GameProfile;
        getClassification(arg0: boolean): Internal.MobCategory;
        setShowBottom(arg0: boolean): void;
        runCommand(command: string): number;
        /**
         * @deprecated
        */
        set fullNBT(nbt: Internal.CompoundTag_)
        get player(): boolean
        get animal(): boolean
        get noEndimationPlaying(): boolean
        set y(y: number)
        get living(): boolean
        get effectHandler(): Internal.EndimationEffectHandler
        get displayName(): Internal.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get animationTick(): number
        /**
         * @deprecated
        */
        get fullNBT(): Internal.CompoundTag
        get teamId(): string
        get playingEndimation(): Internal.PlayableEndimation
        get facing(): Internal.Direction
        set beamTarget(arg0: BlockPos_)
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get frame(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set playingEndimation(arg0: Internal.PlayableEndimation_)
        get name(): Internal.Component
        get passengers(): Internal.EntityArrayList
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        set animationTick(arg0: number)
        get multipartEntity(): boolean
        set dynamicLightEnabled(arg0: boolean)
        get parts(): Internal.PartEntity<any>[]
        get motionZ(): number
        get beamTarget(): BlockPos
        set z(z: number)
        set statusMessage(message: Internal.Component_)
        get profile(): Internal.GameProfile
        set showBottom(arg0: boolean)
        time: number;
    }
    type EndCrystal_ = EndCrystal;
    interface ExternalArrayData {
        getArrayElement(arg0: number): any;
        getArrayLength(): number;
        setArrayElement(arg0: number, arg1: any): void;
        get arrayLength(): number
    }
    type ExternalArrayData_ = ExternalArrayData;
    class ParticleStatus extends Internal.Enum<Internal.ParticleStatus> implements Internal.OptionEnum {
        getKey(): string;
        static values(): Internal.ParticleStatus[];
        static byId(arg0: number): Internal.ParticleStatus;
        getCaption(): Internal.Component;
        getId(): number;
        static valueOf(arg0: string): Internal.ParticleStatus;
        get key(): string
        get caption(): Internal.Component
        get id(): number
        static readonly ALL: Internal.ParticleStatus;
        static readonly DECREASED: Internal.ParticleStatus;
        static readonly MINIMAL: Internal.ParticleStatus;
    }
    type ParticleStatus_ = ParticleStatus | "minimal" | "decreased" | "all";
    interface UnicodeMatcher {
        addMatchSetTo(arg0: Internal.UnicodeSet_): void;
        toPattern(arg0: boolean): string;
        matchesIndexValue(arg0: number): boolean;
        matches(arg0: Internal.Replaceable_, arg1: number[], arg2: number, arg3: boolean): number;
        readonly U_MATCH: 2;
        readonly U_MISMATCH: 0;
        readonly ETHER: "￿";
        readonly U_PARTIAL_MATCH: 1;
    }
    type UnicodeMatcher_ = UnicodeMatcher;
    class ClientboundSetBorderWarningDistancePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.WorldBorder_)
        constructor(arg0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        getWarningBlocks(): number;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get warningBlocks(): number
        get skippable(): boolean
    }
    type ClientboundSetBorderWarningDistancePacket_ = ClientboundSetBorderWarningDistancePacket;
    interface IGeometryLoader <T extends Internal.IUnbakedGeometry<T>> {
        read(arg0: Internal.JsonObject_, arg1: Internal.JsonDeserializationContext_): T;
    }
    type IGeometryLoader_<T extends Internal.IUnbakedGeometry<T>> = IGeometryLoader<T>;
    interface EntityInstancingController <T extends Internal.Entity> {
        shouldSkipRender(arg0: T): boolean;
        createInstance(arg0: Internal.MaterialManager_, arg1: T): Internal.EntityInstance<T>;
    }
    type EntityInstancingController_<T extends Internal.Entity> = EntityInstancingController<T>;
    class RailShape extends Internal.Enum<Internal.RailShape> implements Internal.StringRepresentable {
        static values(): Internal.RailShape[];
        isAscending(): boolean;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        getSerializedName(): string;
        getName(): string;
        static valueOf(arg0: string): Internal.RailShape;
        get ascending(): boolean
        get serializedName(): string
        get name(): string
        static readonly NORTH_EAST: Internal.RailShape;
        static readonly NORTH_WEST: Internal.RailShape;
        static readonly SOUTH_EAST: Internal.RailShape;
        static readonly ASCENDING_WEST: Internal.RailShape;
        static readonly ASCENDING_EAST: Internal.RailShape;
        static readonly ASCENDING_NORTH: Internal.RailShape;
        static readonly ASCENDING_SOUTH: Internal.RailShape;
        static readonly NORTH_SOUTH: Internal.RailShape;
        static readonly EAST_WEST: Internal.RailShape;
        static readonly SOUTH_WEST: Internal.RailShape;
    }
    type RailShape_ = "north_west" | "north_east" | "ascending_west" | "south_west" | "ascending_east" | RailShape | "north_south" | "east_west" | "ascending_south" | "ascending_north" | "south_east";
    class RenderHighlightEvent$Block extends Internal.RenderHighlightEvent {
        constructor()
        constructor(arg0: Internal.LevelRenderer_, arg1: Internal.Camera_, arg2: Internal.BlockHitResult_, arg3: number, arg4: Internal.PoseStack_, arg5: Internal.MultiBufferSource_)
    }
    type RenderHighlightEvent$Block_ = RenderHighlightEvent$Block;
    class Canvas$VertexMode extends Internal.Enum<Internal.Canvas$VertexMode> {
        static values(): Internal.Canvas$VertexMode[];
        static valueOf(name: string): Internal.Canvas$VertexMode;
        static readonly LINE_STRIP: Internal.Canvas$VertexMode;
        static readonly TRIANGLE_STRIP: Internal.Canvas$VertexMode;
        static readonly POINTS: Internal.Canvas$VertexMode;
        static readonly LINES: Internal.Canvas$VertexMode;
        static readonly TRIANGLES: Internal.Canvas$VertexMode;
    }
    type Canvas$VertexMode_ = "triangles" | Canvas$VertexMode | "line_strip" | "triangle_strip" | "points" | "lines";
    abstract class LeveledRegion <T extends Internal.RegionTexture<T>> implements Internal.Comparable<Internal.LeveledRegion<T>> {
        constructor(arg0: string, arg1: string, arg2: string, arg3: Internal.MapDimension_, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Internal.BranchLeveledRegion_)
        preCache(): void;
        ensureBiomePalette(): void;
        isMetaLoaded(): boolean;
        setShouldCache(arg0: boolean, arg1: string): void;
        recacheHasBeenRequested(): boolean;
        calculateSortingChunkDistance(): void;
        compareTo(arg0: any): number;
        hasTextures(): boolean;
        loadCacheTextures(arg0: Internal.MapProcessor_, arg1: Internal.Registry_<Internal.Biome>, arg2: boolean, arg3: boolean[][], arg4: number, arg5: boolean[], arg6: boolean[], arg7: number, arg8: Internal.OldFormatSupport_): boolean;
        cleanAndCacheRequestsBlocked(): boolean;
        getBiomePaletteSize(): number;
        setReloadHasBeenRequested(arg0: boolean, arg1: string): void;
        getBiomePalette(): Internal.FastPalette<Internal.ResourceKey<Internal.Biome>>;
        setAllCachePrepared(arg0: boolean): void;
        getLevel(): number;
        uncountTextureBiomes(arg0: Internal.RegionTexture_<any>): void;
        getCaveLayer(): number;
        shouldEndProcessingAfterUpload(): boolean;
        onBiomeAddedToTexture(arg0: Internal.ResourceKey_<Internal.Biome>): number;
        findCacheFile(arg0: Internal.MapSaveLoad_): Internal.File;
        deleteBuffers(): void;
        getExtraInfo(): string;
        confirmMetaLoaded(): void;
        onLimiterRemoval(arg0: Internal.MapProcessor_): void;
        getBiomeKey(arg0: number): Internal.ResourceKey<Internal.Biome>;
        shouldCache(): boolean;
        isAllCachePrepared(): boolean;
        isLoaded(): boolean;
        deleteGLBuffers(): void;
        calculateSortingDistance(): void;
        shouldBeProcessed(): boolean;
        shouldAffectLoadingRequestFrequency(): boolean;
        getTexture(arg0: number, arg1: number): T;
        putTexture(arg0: number, arg1: number, arg2: T): void;
        updateLeafTextureVersion(arg0: number, arg1: number, arg2: number): void;
        checkForUpdates(arg0: Internal.MapProcessor_, arg1: boolean, arg2: boolean[], arg3: Internal.ArrayList_<Internal.BranchLeveledRegion>, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): void;
        setRecacheHasBeenRequested(arg0: boolean, arg1: string): void;
        getRootRegion(): Internal.LeveledRegion<any>;
        reloadHasBeenRequested(): boolean;
        setCacheFile(arg0: Internal.File_): void;
        resetBiomePalette(): void;
        getCacheFile(): Internal.File;
        deleteTexturesAndBuffers(): void;
        processWhenLoadedChunksExist(arg0: number): void;
        getBiomePaletteIndex(arg0: Internal.ResourceKey_<Internal.Biome>): number;
        getRegionZ(): number;
        getParent(): Internal.BranchLeveledRegion;
        onDimensionClear(arg0: Internal.MapProcessor_): void;
        createTexture(arg0: number, arg1: number): T;
        getDim(): Internal.MapDimension;
        getRegionX(): number;
        saveCacheTextures(arg0: Internal.File_, arg1: number): boolean;
        saveBiomePalette(arg0: Internal.DataOutputStream_): void;
        getAndResetCachedTextureVersion(arg0: number, arg1: number): number;
        loadingAnimation(): boolean;
        compareTo(arg0: Internal.LeveledRegion_<T>): number;
        afterLimiterRemoval(arg0: Internal.MapProcessor_): void;
        addDebugLines(arg0: Internal.List_<string>, arg1: Internal.MapProcessor_, arg2: number, arg3: number): void;
        postCache(arg0: Internal.File_, arg1: Internal.MapSaveLoad_, arg2: boolean): void;
        skipCaching(arg0: Internal.MapProcessor_): boolean;
        hasRemovableSourceData(): boolean;
        static setComparison(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        onCurrentDimFinish(arg0: Internal.MapSaveLoad_, arg1: Internal.MapProcessor_): void;
        onProcessingEnd(): void;
        onBiomeRemovedFromTexture(arg0: number): void;
        get metaLoaded(): boolean
        get biomePaletteSize(): number
        get biomePalette(): Internal.FastPalette<Internal.ResourceKey<Internal.Biome>>
        set allCachePrepared(arg0: boolean)
        get level(): number
        get caveLayer(): number
        get extraInfo(): string
        get allCachePrepared(): boolean
        get loaded(): boolean
        get rootRegion(): Internal.LeveledRegion<any>
        set cacheFile(arg0: Internal.File_)
        get cacheFile(): Internal.File
        get regionZ(): number
        get parent(): Internal.BranchLeveledRegion
        get dim(): Internal.MapDimension
        get regionX(): number
        static readonly SIDE_LENGTH: 8;
        leafTextureVersionSum: number[][];
        activeBranchUpdateReferences: number;
    }
    type LeveledRegion_<T extends Internal.RegionTexture<T>> = LeveledRegion<T>;
    interface PackSource {
        passThrough(): this;
        decorating(arg0: string): this;
        decorate(arg0: Internal.Component_): Internal.Component;
        readonly DEFAULT: Internal.PackSource;
        readonly SERVER: Internal.PackSource;
        readonly BUILT_IN: Internal.PackSource;
        readonly WORLD: Internal.PackSource;
    }
    type PackSource_ = PackSource;
    class TrackNode {
        constructor(arg0: Internal.TrackNodeLocation_, arg1: number, arg2: Vec3_)
        getNetId(): number;
        getNormal(): Vec3;
        getLocation(): Internal.TrackNodeLocation;
        get netId(): number
        get normal(): Vec3
        get location(): Internal.TrackNodeLocation
    }
    type TrackNode_ = TrackNode;
    interface PehkuiBlockStateExtensions {
        pehkui_getOutlineShape(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.VoxelShape;
        pehkui_getBlock(): Internal.Block;
    }
    type PehkuiBlockStateExtensions_ = PehkuiBlockStateExtensions;
    interface GameVersion {
        isStable(): boolean;
        getWorldVersion(): number;
        getName(): string;
        getPackVersion(arg0: com.mojang.bridge.game.PackType_): number;
        getSeriesId(): string;
        getProtocolVersion(): number;
        getId(): string;
        getBuildTime(): Internal.Date;
        /**
         * @deprecated
        */
        getPackVersion(): number;
        getReleaseTarget(): string;
        get stable(): boolean
        get worldVersion(): number
        get name(): string
        get seriesId(): string
        get protocolVersion(): number
        get id(): string
        get buildTime(): Internal.Date
        /**
         * @deprecated
        */
        get packVersion(): number
        get releaseTarget(): string
    }
    type GameVersion_ = GameVersion;
    abstract class ObjectCategoryRule <E, P> {
        isFollowedBy(arg0: E, arg1: P): boolean;
        getName(): string;
        get name(): string
    }
    type ObjectCategoryRule_<E, P> = ObjectCategoryRule<E, P>;
    interface TextureProxyVisitor {
        visit(arg0: Internal.TextureProxy_, arg1: number): void;
        (arg0: Internal.TextureProxy_, arg1: number): void;
    }
    type TextureProxyVisitor_ = TextureProxyVisitor;
    abstract class EntityInstance <E extends Internal.Entity> extends Internal.AbstractInstance implements Internal.TickingLightListener, Internal.LightListener {
        constructor(arg0: Internal.MaterialManager_, arg1: E)
        onLightPacket(arg0: number, arg1: number): void;
        getInstancePosition(): Internal.Vector3f;
        getInstancePosition(arg0: number): Internal.Vector3f;
        tickLightListener(): boolean;
        get instancePosition(): Internal.Vector3f
    }
    type EntityInstance_<E extends Internal.Entity> = EntityInstance<E>;
    interface FireworkRocketEntityKJS {
        setLifetimeKJS(arg0: number): void;
        set lifetimeKJS(arg0: number)
    }
    type FireworkRocketEntityKJS_ = FireworkRocketEntityKJS;
    class Monitor {
        constructor(arg0: number)
        getModeCount(): number;
        getX(): number;
        getY(): number;
        getPreferredVidMode(arg0: Internal.Optional_<Internal.VideoMode>): Internal.VideoMode;
        getMonitor(): number;
        getCurrentMode(): Internal.VideoMode;
        getMode(arg0: number): Internal.VideoMode;
        refreshVideoModes(): void;
        getVideoModeIndex(arg0: Internal.VideoMode_): number;
        get modeCount(): number
        get x(): number
        get y(): number
        get monitor(): number
        get currentMode(): Internal.VideoMode
    }
    type Monitor_ = Monitor;
    class ServerStatsCounter extends Internal.StatsCounter {
        constructor(arg0: Internal.MinecraftServer_, arg1: Internal.File_)
        parseLocal(arg0: Internal.DataFixer_, arg1: string): void;
        sendStats(arg0: Internal.ServerPlayer_): void;
        markAllDirty(): void;
        save(): void;
    }
    type ServerStatsCounter_ = ServerStatsCounter;
    interface StackedContentsCompatible {
        fillStackedContents(arg0: Internal.StackedContents_): void;
    }
    type StackedContentsCompatible_ = StackedContentsCompatible;
    class NetherPortalBlock extends Internal.Block {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    }
    type NetherPortalBlock_ = NetherPortalBlock;
    class GameProfileCache$GameProfileInfo {
        getLastAccess(): number;
        getProfile(): Internal.GameProfile;
        setLastAccess(arg0: number): void;
        getExpirationDate(): Internal.Date;
        get lastAccess(): number
        get profile(): Internal.GameProfile
        set lastAccess(arg0: number)
        get expirationDate(): Internal.Date
    }
    type GameProfileCache$GameProfileInfo_ = GameProfileCache$GameProfileInfo;
    class AcaciaFoliagePlacer extends Internal.FoliagePlacer {
        constructor(arg0: Internal.IntProvider_, arg1: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.AcaciaFoliagePlacer>;
    }
    type AcaciaFoliagePlacer_ = AcaciaFoliagePlacer;
    class PlaceOnWaterBlockItem extends Internal.BlockItem {
        constructor(arg0: Internal.Block_, arg1: Internal.Item$Properties_)
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        setDigSpeed(speed: number): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onUsingTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Internal.Vector3f;
        setAttackSpeed(attackSpeed: number): void;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        getCreativeTabs(): Internal.Collection<Internal.CreativeModeTab>;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: Internal.Component_): Internal.Component;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        getDamage(arg0: Internal.ItemStack_): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        setArmorToughness(armorToughness: number): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasPlacementBehavior(): boolean;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTabs(): Internal.Collection<Internal.CreativeModeTab>
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type PlaceOnWaterBlockItem_ = PlaceOnWaterBlockItem;
    abstract class GlslPreprocessor {
        constructor()
        process(arg0: string): Internal.List<string>;
        applyImport(arg0: boolean, arg1: string): string;
    }
    type GlslPreprocessor_ = GlslPreprocessor;
    abstract class FastMapKey <T extends Internal.Comparable<T>> {
        getProperty(): Internal.Property<T>;
        getValue(arg0: number): T;
        numValues(): number;
        get property(): Internal.Property<T>
    }
    type FastMapKey_<T extends Internal.Comparable<T>> = FastMapKey<T>;
    class HoverEvent$ItemStackInfo {
        constructor(arg0: Internal.ItemStack_)
        getItemStack(): Internal.ItemStack;
        get itemStack(): Internal.ItemStack
    }
    type HoverEvent$ItemStackInfo_ = HoverEvent$ItemStackInfo;
    interface Reference2IntFunction <K> extends Internal.ToIntFunction<K>, it.unimi.dsi.fastutil.Function<K, number> {
        put(arg0: K, arg1: number): number;
        removeInt(arg0: any): number;
        defaultReturnValue(): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeDouble(arg0: Internal.Double2ReferenceFunction_<K>): Internal.Double2IntFunction;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Reference2ByteFunction<K>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeReference<T>(arg0: Internal.Reference2ReferenceFunction_<T, K>): Internal.Reference2IntFunction<T>;
        apply(arg0: K): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Reference2ShortFunction<K>;
        containsKey(arg0: any): boolean;
        composeChar(arg0: Internal.Char2ReferenceFunction_<K>): Internal.Char2IntFunction;
        getInt(arg0: any): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Reference2LongFunction<K>;
        composeInt(arg0: Internal.Int2ReferenceFunction_<K>): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeShort(arg0: Internal.Short2ReferenceFunction_<K>): Internal.Short2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        composeFloat(arg0: Internal.Float2ReferenceFunction_<K>): Internal.Float2IntFunction;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Reference2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeByte(arg0: Internal.Byte2ReferenceFunction_<K>): Internal.Byte2IntFunction;
        composeLong(arg0: Internal.Long2ReferenceFunction_<K>): Internal.Long2IntFunction;
        applyAsInt(arg0: K): number;
        size(): number;
        defaultReturnValue(arg0: number): void;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Reference2ReferenceFunction<K, T>;
        clear(): void;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Reference2DoubleFunction<K>;
        composeObject<T>(arg0: Internal.Object2ReferenceFunction_<T, K>): Internal.Object2IntFunction<T>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        getOrDefault(arg0: any, arg1: number): number;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Reference2CharFunction<K>;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Reference2FloatFunction<K>;
        (arg0: any): number;
    }
    type Reference2IntFunction_<K> = Reference2IntFunction<K>;
    class SaplingGrowTreeEvent extends Internal.LevelEvent {
        constructor()
        constructor(arg0: Internal.LevelAccessor_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.Holder_<Internal.ConfiguredFeature<any, any>>)
        constructor(arg0: Internal.LevelAccessor_, arg1: Internal.RandomSource_, arg2: BlockPos_)
        getPos(): BlockPos;
        getRandomSource(): Internal.RandomSource;
        setFeature(arg0: Internal.Holder_<Internal.ConfiguredFeature<any, any>>): void;
        getFeature(): Internal.Holder<Internal.ConfiguredFeature<any, any>>;
        get pos(): BlockPos
        get randomSource(): Internal.RandomSource
        set feature(arg0: Internal.Holder_<Internal.ConfiguredFeature<any, any>>)
        get feature(): Internal.Holder<Internal.ConfiguredFeature<any, any>>
    }
    type SaplingGrowTreeEvent_ = SaplingGrowTreeEvent;
    class ClientboundSetCameraPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: Internal.Entity_)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getEntity(arg0: Internal.Level_): Internal.Entity;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundSetCameraPacket_ = ClientboundSetCameraPacket;
    interface UnmodifiableConfig$Entry {
        getShortOrElse(arg0: number): number;
        getChar(): string;
        getByte(): number;
        getKey(): string;
        getRawValue<T>(): T;
        getIntOrElse(arg0: number): number;
        getLongOrElse(arg0: number): number;
        getOptionalLong(): Internal.OptionalLong;
        getLong(): number;
        getByteOrElse(arg0: number): number;
        getShort(): number;
        getValue<T>(): T;
        isNull(): boolean;
        getOrElse<T>(arg0: T): T;
        getOptionalInt(): Internal.OptionalInt;
        getOptional<T>(): Internal.Optional<T>;
        getCharOrElse(arg0: string): string;
        getInt(): number;
        get "char"(): string
        get "byte"(): number
        get key(): string
        get rawValue(): T
        get optionalLong(): Internal.OptionalLong
        get "long"(): number
        get "short"(): number
        get value(): T
        get "null"(): boolean
        get optionalInt(): Internal.OptionalInt
        get optional(): Internal.Optional<T>
        get "int"(): number
    }
    type UnmodifiableConfig$Entry_ = UnmodifiableConfig$Entry;
    /**
     * Invoked when a player sends a chat message.
     * 
     * If cancelled (`PlayerEvents.chat`), the message will not be sent.
    */
    class PlayerChatDecorateEventJS extends Internal.PlayerEventJS {
        constructor(player: Internal.ServerPlayer_, chatComponent: Internal.ChatEvent$ChatComponent_)
        /**
         * Gets the username of the player that sent the message.
        */
        getUsername(): string;
        /**
         * Gets the message that the player sent.
        */
        getMessage(): string;
        /**
         * Sets the message that the player sent.
        */
        setMessage(text: Internal.Component_): void;
        /**
         * Gets the message that the player sent.
        */
        getComponent(): Internal.Component;
        /**
         * Sets the message that the player sent.
        */
        setComponent(text: Internal.Component_): void;
        /**
         * Gets the username of the player that sent the message.
        */
        get username(): string
        /**
         * Gets the message that the player sent.
        */
        get message(): string
        /**
         * Sets the message that the player sent.
        */
        set message(text: Internal.Component_)
        /**
         * Gets the message that the player sent.
        */
        get component(): Internal.Component
        /**
         * Sets the message that the player sent.
        */
        set component(text: Internal.Component_)
        chatComponent: Internal.ChatEvent$ChatComponent;
    }
    type PlayerChatDecorateEventJS_ = PlayerChatDecorateEventJS;
    abstract class EnumSet <E extends Internal.Enum<E>> extends Internal.AbstractSet<E> implements Internal.Cloneable, Internal.Serializable {
        clone(): any;
        static of<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        parallelStream(): Internal.Stream<E>;
        static copyOf<E extends Internal.Enum<E>>(arg0: Internal.Collection_<E>): Internal.EnumSet<E>;
        static allOf<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        static noneOf<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, ...arg1: E[]): Internal.EnumSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E): Internal.EnumSet<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.EnumSet<E>;
        toArray<T>(arg0: T[]): T[];
        static complementOf<E extends Internal.Enum<E>>(arg0: Internal.EnumSet_<E>): Internal.EnumSet<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.EnumSet<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E): Internal.EnumSet<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        static copyOf<E extends Internal.Enum<E>>(arg0: Internal.EnumSet_<E>): Internal.EnumSet<E>;
        static range<E extends Internal.Enum<E>>(arg0: E, arg1: E): Internal.EnumSet<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
    }
    type EnumSet_<E extends Internal.Enum<E>> = EnumSet<E>;
    class BeehiveBlockEntity extends Internal.BlockEntity {
        constructor(arg0: BlockPos_, arg1: Internal.BlockState_)
        getOccupantCount(): number;
        static getHoneyLevel(arg0: Internal.BlockState_): number;
        isFull(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        emptyAllLivingFromHive(arg0: Internal.Player_, arg1: Internal.BlockState_, arg2: Internal.BeehiveBlockEntity$BeeReleaseStatus_): void;
        requestModelDataUpdate(): void;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        isEmpty(): boolean;
        isSedated(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        serializeNBT(): Internal.CompoundTag;
        static serverTick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BeehiveBlockEntity_): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        isFireNearby(): boolean;
        addOccupantWithPresetTicks(arg0: Internal.Entity_, arg1: boolean, arg2: number): void;
        getModelData(): Internal.ModelData;
        addOccupant(arg0: Internal.Entity_, arg1: boolean): void;
        onLoad(): void;
        storeBee(arg0: Internal.CompoundTag_, arg1: number, arg2: boolean): void;
        writeBees(): Internal.ListTag;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        getRenderBoundingBox(): Internal.AABB;
        get occupantCount(): number
        get full(): boolean
        get empty(): boolean
        get sedated(): boolean
        get fireNearby(): boolean
        get modelData(): Internal.ModelData
        get renderBoundingBox(): Internal.AABB
        static readonly TICKS_IN_HIVE: "TicksInHive";
        static readonly BEES: "Bees";
        static readonly HAS_NECTAR: "HasNectar";
        static readonly TAG_FLOWER_POS: "FlowerPos";
        static readonly MIN_OCCUPATION_TICKS_NECTARLESS: 600;
        static readonly MIN_OCCUPATION_TICKS: "MinOccupationTicks";
        static readonly ENTITY_DATA: "EntityData";
        static readonly MAX_OCCUPANTS: 3;
    }
    type BeehiveBlockEntity_ = BeehiveBlockEntity;
    class ArmorItemBuilder$Boots extends Internal.ArmorItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): any;
    }
    type ArmorItemBuilder$Boots_ = ArmorItemBuilder$Boots;
    class Type$FieldNotFoundException extends Internal.Type$TypeError {
        constructor(arg0: string)
    }
    type Type$FieldNotFoundException_ = Type$FieldNotFoundException;
    class LivingHealEvent extends Internal.LivingEvent {
        constructor()
        constructor(arg0: Internal.LivingEntity_, arg1: number)
        getEntity(): Internal.Entity;
        setAmount(arg0: number): void;
        getAmount(): number;
        get entity(): Internal.Entity
        set amount(arg0: number)
        get amount(): number
    }
    type LivingHealEvent_ = LivingHealEvent;
    abstract class SimpleConfigEvent extends Internal.Event implements Internal.IModBusEvent {
        constructor()
        constructor(arg0: any)
        getSource(): any;
        get source(): any
    }
    type SimpleConfigEvent_ = SimpleConfigEvent;
    interface ProfilerFiller {
        markForCharting(arg0: Internal.MetricCategory_): void;
        push(arg0: Internal.Supplier_<string>): void;
        tee(arg0: Internal.ProfilerFiller_, arg1: Internal.ProfilerFiller_): this;
        incrementCounter(arg0: string, arg1: number): void;
        popPush(arg0: string): void;
        push(arg0: string): void;
        incrementCounter(arg0: Internal.Supplier_<string>): void;
        pop(): void;
        incrementCounter(arg0: Internal.Supplier_<string>, arg1: number): void;
        incrementCounter(arg0: string): void;
        endTick(): void;
        popPush(arg0: Internal.Supplier_<string>): void;
        startTick(): void;
        readonly ROOT: "root";
    }
    type ProfilerFiller_ = ProfilerFiller;
    interface DoubleList extends Internal.DoubleCollection, Internal.List<number>, Internal.Comparable<Internal.List<number>> {
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        getDouble(arg0: number): number;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        addAll(arg0: Internal.DoubleCollection_): boolean;
        addAll(arg0: number, arg1: Internal.DoubleList_): boolean;
        containsAll(arg0: Internal.DoubleCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        spliterator(): Internal.DoubleSpliterator;
        removeIf(arg0: Internal.DoublePredicate_): boolean;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: any): void;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        of<E>(arg0: E): Internal.List<E>;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<number>): void;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        subList(arg0: number, arg1: number): this;
        addElements(arg0: number, arg1: number[]): void;
        replaceAll(arg0: it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator_): void;
        of(...arg0: number[]): this;
        rem(arg0: number): boolean;
        removeDouble(arg0: number): number;
        size(arg0: number): void;
        add(arg0: number, arg1: number): void;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        forEach(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        addElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        /**
         * @deprecated
        */
        indexOf(arg0: any): number;
        toArray<T>(arg0: T[]): T[];
        removeAll(arg0: Internal.DoubleCollection_): boolean;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        toDoubleArray(arg0: number[]): number[];
        addAll(arg0: number, arg1: Internal.DoubleCollection_): boolean;
        of(): this;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        of<E>(arg0: E, arg1: E): Internal.List<E>;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        unstableSort(arg0: Internal.DoubleComparator_): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        sort(arg0: Internal.DoubleComparator_): void;
        iterator(): Internal.DoubleIterator;
        set(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: any): any;
        /**
         * @deprecated
        */
        lastIndexOf(arg0: any): number;
        addAll(arg0: Internal.DoubleList_): boolean;
        add(arg0: number): boolean;
        /**
         * @deprecated
        */
        get(arg0: number): number;
        removeElements(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        remove(arg0: number): any;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: number): number;
        getElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        retainAll(arg0: Internal.DoubleCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        isEmpty(): boolean;
        addAll(arg0: Internal.Collection_<number>): boolean;
        setElements(arg0: number, arg1: number[]): void;
        of(arg0: number, arg1: number): this;
        /**
         * @deprecated
        */
        unstableSort(arg0: Internal.Comparator_<number>): void;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        of<E>(...arg0: E[]): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<any>;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        listIterator(): Internal.DoubleListIterator;
        doubleParallelStream(): Internal.DoubleStream;
        setElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: number): void;
        of(arg0: number): this;
        doubleStream(): Internal.DoubleStream;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<number>): void;
        toArray(arg0: number[]): number[];
        addAll(arg0: number, arg1: Internal.Collection_<number>): boolean;
        of(arg0: number, arg1: number, arg2: number): this;
        indexOf(arg0: number): number;
        replaceAll(arg0: Internal.DoubleUnaryOperator_): void;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        removeIf(arg0: it.unimi.dsi.fastutil.doubles.DoublePredicate_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        contains(arg0: number): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        doubleIterator(): Internal.DoubleIterator;
        toArray(): any[];
        lastIndexOf(arg0: number): number;
        hashCode(): number;
        size(): number;
        doubleSpliterator(): Internal.DoubleSpliterator;
        compareTo(arg0: Internal.List_<number>): number;
        setElements(arg0: number[]): void;
        clear(): void;
        toDoubleArray(): number[];
        forEach(arg0: Internal.DoubleConsumer_): void;
        equals(arg0: any): boolean;
        get empty(): boolean
        set elements(arg0: number[])
    }
    type DoubleList_ = DoubleList;
    interface View$OnDragListener {
        onDrag(arg0: Internal.View_, arg1: Internal.DragEvent_): boolean;
        (arg0: Internal.View_, arg1: Internal.DragEvent_): boolean;
    }
    type View$OnDragListener_ = View$OnDragListener;
    class FragmentManager implements Internal.FragmentResultOwner {
        setFragmentResult(requestKey: string, result: Internal.DataSet_): void;
        removeFragmentOnAttachListener(listener: Internal.FragmentOnAttachListener_): void;
        popBackStack(): void;
        popBackStackImmediate(id: number, flags: number): boolean;
        setFragmentFactory(fragmentFactory: Internal.FragmentFactory_): void;
        popBackStack(id: number, flags: number): void;
        setFragmentResultListener(requestKey: string, lifecycleOwner: Internal.LifecycleOwner_, listener: Internal.FragmentResultListener_): void;
        addOnBackStackChangedListener(listener: Internal.FragmentManager$OnBackStackChangedListener_): void;
        popBackStack(name: string, flags: number): void;
        findFragmentById(id: number): Internal.Fragment;
        static findFragment<F extends Internal.Fragment>(view: Internal.View_): F;
        clearFragmentResultListener(requestKey: string): void;
        getFragments(): Internal.List<Internal.Fragment>;
        beginTransaction(): Internal.FragmentTransaction;
        removeOnBackStackChangedListener(listener: Internal.FragmentManager$OnBackStackChangedListener_): void;
        findFragmentByTag(tag: string): Internal.Fragment;
        isStateSaved(): boolean;
        registerFragmentLifecycleCallbacks(cb: Internal.FragmentLifecycleCallbacks_, recursive: boolean): void;
        popBackStackImmediate(name: string, flags: number): boolean;
        unregisterFragmentLifecycleCallbacks(cb: Internal.FragmentLifecycleCallbacks_): void;
        getFragment(bundle: Internal.DataSet_, key: string): Internal.Fragment;
        executePendingTransactions(): boolean;
        popBackStackImmediate(): boolean;
        getBackStackEntryAt(index: number): Internal.FragmentManager$BackStackEntry;
        dump(prefix: string, fd: Internal.FileDescriptor_, writer: Internal.PrintWriter_, ...args: string[]): void;
        addFragmentOnAttachListener(listener: Internal.FragmentOnAttachListener_): void;
        clearFragmentResult(requestKey: string): void;
        putFragment(bundle: Internal.DataSet_, key: string, fragment: Internal.Fragment_): void;
        isDestroyed(): boolean;
        getBackStackEntryCount(): number;
        getPrimaryNavigationFragment(): Internal.Fragment;
        getFragmentFactory(): Internal.FragmentFactory;
        set fragmentFactory(fragmentFactory: Internal.FragmentFactory_)
        get fragments(): Internal.List<Internal.Fragment>
        get stateSaved(): boolean
        get destroyed(): boolean
        get backStackEntryCount(): number
        get primaryNavigationFragment(): Internal.Fragment
        get fragmentFactory(): Internal.FragmentFactory
        static readonly POP_BACK_STACK_INCLUSIVE: 1;
    }
    type FragmentManager_ = FragmentManager;
    class LootTable$Builder implements Internal.FunctionUserBuilder<Internal.LootTable$Builder> {
        constructor()
        unwrap(): Internal.FunctionUserBuilder<any>;
        build(): Internal.LootTable;
        apply(arg0: Internal.LootItemFunction$Builder_): Internal.FunctionUserBuilder<any>;
        setParamSet(arg0: Internal.LootContextParamSet_): this;
        withPool(arg0: Internal.LootPool$Builder_): this;
        apply<E>(arg0: Internal.Iterable_<E>, arg1: Internal.Function_<E, Internal.LootItemFunction$Builder>): this;
        apply<E>(arg0: E[], arg1: Internal.Function_<E, Internal.LootItemFunction$Builder>): this;
        set paramSet(arg0: Internal.LootContextParamSet_)
    }
    type LootTable$Builder_ = LootTable$Builder;
    class GpuWarnlistManager extends Internal.SimplePreparableReloadListener<any> {
        constructor()
        showWarning(): void;
        getRendererWarnings(): string;
        hasWarnings(): boolean;
        resetWarnings(): void;
        getVersionWarnings(): string;
        getAllWarnings(): string;
        getVendorWarnings(): string;
        willShowWarning(): boolean;
        getName(): string;
        dismissWarning(): void;
        dismissWarningAndSkipFabulous(): void;
        isSkippingFabulous(): boolean;
        isShowingWarning(): boolean;
        get rendererWarnings(): string
        get versionWarnings(): string
        get allWarnings(): string
        get vendorWarnings(): string
        get name(): string
        get skippingFabulous(): boolean
        get showingWarning(): boolean
    }
    type GpuWarnlistManager_ = GpuWarnlistManager;
    class Style {
        applyFormats(...arg0: Internal.ChatFormatting_[]): this;
        getInsertion(): string;
        withHoverEvent(arg0: Internal.HoverEvent_): this;
        isBold(): boolean;
        isEmpty(): boolean;
        isStrikethrough(): boolean;
        isObfuscated(): boolean;
        withBold(arg0: boolean): this;
        getFont(): ResourceLocation;
        getHoverEvent(): Internal.HoverEvent;
        isItalic(): boolean;
        isUnderlined(): boolean;
        withStrikethrough(arg0: boolean): this;
        withObfuscated(arg0: boolean): this;
        withColor(arg0: Internal.ChatFormatting_): this;
        applyTo(arg0: Internal.Style_): this;
        withInsertion(arg0: string): this;
        withColor(arg0: number): this;
        getColor(): Internal.TextColor;
        getClickEvent(): Internal.ClickEvent;
        withUnderlined(arg0: boolean): this;
        withFont(arg0: ResourceLocation_): this;
        withColor(arg0: Internal.TextColor_): this;
        withClickEvent(arg0: Internal.ClickEvent_): this;
        withItalic(arg0: boolean): this;
        applyLegacyFormat(arg0: Internal.ChatFormatting_): this;
        applyFormat(arg0: Internal.ChatFormatting_): this;
        get insertion(): string
        get bold(): boolean
        get empty(): boolean
        get strikethrough(): boolean
        get obfuscated(): boolean
        get font(): ResourceLocation
        get hoverEvent(): Internal.HoverEvent
        get italic(): boolean
        get underlined(): boolean
        get color(): Internal.TextColor
        get clickEvent(): Internal.ClickEvent
        static readonly EMPTY: Internal.Style;
        static readonly DEFAULT_FONT: ResourceLocation;
        static readonly FORMATTING_CODEC: Internal.Codec<Internal.Style>;
    }
    type Style_ = Style;
    class BlastingRecipe extends Internal.AbstractCookingRecipe {
        constructor(arg0: ResourceLocation_, arg1: string, arg2: Internal.Ingredient_, arg3: Internal.ItemStack_, arg4: number, arg5: number)
        isSpecial(): boolean;
        getGroup(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems(arg0: Internal.Container_): Internal.NonNullList<Internal.ItemStack>;
        get special(): boolean
        get group(): string
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type BlastingRecipe_ = BlastingRecipe;
    interface TypeTemplate {
        toSimpleType(): com.mojang.datafixers.types.Type<any>;
        size(): number;
        findFieldOrType<A, B>(arg0: number, arg1: string, arg2: com.mojang.datafixers.types.Type_<A>, arg3: com.mojang.datafixers.types.Type_<B>): Internal.Either<Internal.TypeTemplate, Internal.Type$FieldNotFoundException>;
        apply(arg0: Internal.TypeFamily_): Internal.TypeFamily;
        applyO<A, B>(arg0: Internal.FamilyOptic_<A, B>, arg1: com.mojang.datafixers.types.Type_<A>, arg2: com.mojang.datafixers.types.Type_<B>): Internal.FamilyOptic<A, B>;
        hmap(arg0: Internal.TypeFamily_, arg1: Internal.IntFunction_<Internal.RewriteResult<any, any>>): Internal.IntFunction<Internal.RewriteResult<any, any>>;
    }
    type TypeTemplate_ = TypeTemplate;
    class BlockStateMatchTest extends Internal.RuleTest {
        constructor(arg0: Internal.BlockState_)
        static readonly CODEC: Internal.Codec<Internal.BlockStateMatchTest>;
    }
    type BlockStateMatchTest_ = BlockStateMatchTest;
    interface EventListener {
    }
    type EventListener_ = EventListener;
    class TagsUpdatedEvent extends Internal.Event {
        constructor()
        constructor(arg0: Internal.RegistryAccess_, arg1: boolean, arg2: boolean)
        shouldUpdateStaticData(): boolean;
        getUpdateCause(): Internal.TagsUpdatedEvent$UpdateCause;
        getRegistryAccess(): Internal.RegistryAccess;
        get updateCause(): Internal.TagsUpdatedEvent$UpdateCause
        get registryAccess(): Internal.RegistryAccess
    }
    type TagsUpdatedEvent_ = TagsUpdatedEvent;
    class TrackedData <T> {
        getSyncType(): Internal.SyncType;
        shouldSave(): boolean;
        isPersistent(): boolean;
        getDefaultValue(): T;
        getProcessor(): Internal.IDataProcessor<T>;
        get syncType(): Internal.SyncType
        get persistent(): boolean
        get defaultValue(): T
        get processor(): Internal.IDataProcessor<T>
    }
    type TrackedData_<T> = TrackedData<T>;
    class TargetBlock extends Internal.Block {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type TargetBlock_ = TargetBlock;
    class TextureProxy extends Internal.SurfaceProxy {
        constructor(format: Internal.BackendFormat_, width: number, height: number, surfaceFlags: number)
        constructor(format: Internal.BackendFormat_, width: number, height: number, surfaceFlags: number, callback: Internal.SurfaceProxy$LazyInstantiateCallback_)
        constructor(texture: Internal.Texture_, surfaceFlags: number)
        setLazyDimension(width: number, height: number): void;
        setMSAADirty(left: number, top: number, right: number, bottom: number): void;
        getUniqueKey(): any;
        setMipmapsDirty(dirty: boolean): void;
        getMSAADirtyRect(): icyllis.arc3d.core.Rect2i;
        isProxyMipmapped(): boolean;
        isPromiseProxy(): boolean;
        makeProxyExact(allocatedCaseOnly: boolean): void;
        setIsPromiseProxy(): void;
        isMipmapped(): boolean;
        hasRestrictedSampling(): boolean;
        isMSAADirty(): boolean;
        isMipmapsDirty(): boolean;
        get uniqueKey(): any
        set mipmapsDirty(dirty: boolean)
        get MSAADirtyRect(): icyllis.arc3d.core.Rect2i
        get proxyMipmapped(): boolean
        get promiseProxy(): boolean
        get mipmapped(): boolean
        get MSAADirty(): boolean
        get mipmapsDirty(): boolean
    }
    type TextureProxy_ = TextureProxy;
    class NamespacedDefaultedWrapper <T> extends Internal.DefaultedRegistry<T> implements Internal.ILockableRegistry, Internal.IHolderHelperHolder<T> {
        registerOrOverride(arg0: Internal.OptionalInt_, arg1: Internal.ResourceKey_<T>, arg2: T, arg3: Internal.Lifecycle_): Internal.Holder<T>;
        getResourceKey(arg0: T): Internal.Optional<Internal.ResourceKey<T>>;
        get(arg0: Internal.ResourceKey_<T>): T;
        registryKeySet(): Internal.Set<Internal.ResourceKey<T>>;
        getTagNames(): Internal.Stream<Internal.TagKey<T>>;
        spliterator(): Internal.Spliterator<T>;
        get(arg0: ResourceLocation_): T;
        getHolder(arg0: Internal.ResourceKey_<T>): Internal.Optional<Internal.Holder<T>>;
        byIdOrThrow(arg0: number): T;
        iterator(): Internal.Iterator<T>;
        getTags(): Internal.Stream<com.mojang.datafixers.util.Pair<Internal.TagKey<T>, Internal.HolderSet$Named<T>>>;
        forEach(arg0: Internal.Consumer_<T>): void;
        /**
         * @deprecated
        */
        lock(): void;
        getHolder(arg0: number): Internal.Optional<Internal.Holder<T>>;
        freeze(): Internal.Registry<T>;
        getOrCreateHolderOrThrow(arg0: Internal.ResourceKey_<T>): Internal.Holder<T>;
        registerMapping(arg0: number, arg1: Internal.ResourceKey_<T>, arg2: T, arg3: Internal.Lifecycle_): Internal.Holder<T>;
        byId(arg0: number): T;
        createIntrusiveHolder(arg0: T): Internal.Holder$Reference<T>;
        getOrCreateTag(arg0: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        getTag(arg0: Internal.TagKey_<T>): Internal.Optional<Internal.HolderSet$Named<T>>;
        getOptional(arg0: ResourceLocation_): Internal.Optional<T>;
        static forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): Internal.Keyable;
        getOrCreateHolder(arg0: Internal.ResourceKey_<T>): Internal.DataResult<Internal.Holder<T>>;
        getRandom(arg0: Internal.RandomSource_): Internal.Optional<Internal.Holder<T>>;
        register(arg0: Internal.ResourceKey_<T>, arg1: T, arg2: Internal.Lifecycle_): Internal.Holder<T>;
        entrySet(): Internal.Set<Internal.Map$Entry<Internal.ResourceKey<T>, T>>;
        getHolderHelper(): Internal.NamespacedHolderHelper<T>;
        holders(): Internal.Stream<Internal.Holder$Reference<T>>;
        get tagNames(): Internal.Stream<Internal.TagKey<T>>
        get tags(): Internal.Stream<com.mojang.datafixers.util.Pair<Internal.TagKey<T>, Internal.HolderSet$Named<T>>>
        get holderHelper(): Internal.NamespacedHolderHelper<T>
    }
    type NamespacedDefaultedWrapper_<T> = NamespacedDefaultedWrapper<T>;
    class ClientboundHorseScreenOpenPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: number, arg1: number, arg2: number)
        constructor(arg0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        getSize(): number;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getEntityId(): number;
        getContainerId(): number;
        isSkippable(): boolean;
        get size(): number
        get entityId(): number
        get containerId(): number
        get skippable(): boolean
    }
    type ClientboundHorseScreenOpenPacket_ = ClientboundHorseScreenOpenPacket;
    abstract class ArgumentBuilder <S, T extends Internal.ArgumentBuilder<S, T>> {
        constructor()
        redirect(arg0: Internal.CommandNode_<S>): T;
        build(): Internal.CommandNode<S>;
        then(arg0: Internal.CommandNode_<S>): T;
        getArguments(): Internal.Collection<Internal.CommandNode<S>>;
        then(arg0: Internal.ArgumentBuilder_<S, any>): T;
        redirect(arg0: Internal.CommandNode_<S>, arg1: Internal.SingleRedirectModifier_<S>): T;
        fork(arg0: Internal.CommandNode_<S>, arg1: Internal.RedirectModifier_<S>): T;
        getRedirectModifier(): Internal.RedirectModifier<S>;
        getRequirement(): Internal.Predicate<S>;
        forward(arg0: Internal.CommandNode_<S>, arg1: Internal.RedirectModifier_<S>, arg2: boolean): T;
        executes(arg0: Internal.Command_<S>): T;
        requires(arg0: Internal.Predicate_<S>): T;
        getRedirect(): Internal.CommandNode<S>;
        isFork(): boolean;
        getCommand(): Internal.Command<S>;
        get "arguments"(): Internal.Collection<Internal.CommandNode<S>>
        get redirectModifier(): Internal.RedirectModifier<S>
        get requirement(): Internal.Predicate<S>
        get redirect(): Internal.CommandNode<S>
        get fork(): boolean
        get command(): Internal.Command<S>
    }
    type ArgumentBuilder_<S, T extends Internal.ArgumentBuilder<S, T>> = ArgumentBuilder<S, T>;
    class PacketDistributor$PacketTarget {
        getDirection(): Internal.NetworkDirection;
        send(arg0: Internal.Packet_<any>): void;
        get direction(): Internal.NetworkDirection
    }
    type PacketDistributor$PacketTarget_ = PacketDistributor$PacketTarget;
    interface FilenameFilter {
        accept(arg0: Internal.File_, arg1: string): boolean;
        (arg0: Internal.File_, arg1: string): boolean;
    }
    type FilenameFilter_ = FilenameFilter;
    class WaypointsManager {
        constructor(arg0: Internal.IXaeroMinimap_, arg1: Internal.XaeroMinimapSession_)
        isMultiplayer(arg0: string): boolean;
        getDimensionKeyForDirectoryName(arg0: string): Internal.ResourceKey<Internal.Level>;
        createDeathpoint(arg0: Internal.Player_): void;
        containerExists(arg0: string): boolean;
        getAutoWorldID(): string;
        getWaypoints(): Internal.WaypointSet;
        getWorldContainerNullable(arg0: string): Internal.WaypointWorldContainer;
        onLoad(): void;
        getNewAutoWorldID(arg0: Internal.ResourceKey_<Internal.Level>, arg1: boolean): string;
        setCustomWorldID(arg0: string): void;
        getAutoRootContainerID(): string;
        getWorldContainer(arg0: string): Internal.WaypointWorldContainer;
        getCurrentContainerID(): string;
        findDimensionKey(arg0: string): Internal.ResourceKey<Internal.Level>;
        onServerLevelId(arg0: number): void;
        getCurrentWorldID(arg0: string): string;
        teleportToWaypoint(arg0: Internal.Waypoint_, arg1: Internal.WaypointWorld_, arg2: Internal.Screen_): void;
        setCustomContainerID(arg0: string): void;
        getServerWaypoints(): Internal.List<Internal.Waypoint>;
        static getCustomWaypoints(arg0: string): Internal.Hashtable<number, Internal.Waypoint>;
        getCustomWorldID(): string;
        getCurrentWorldID(): string;
        teleportAnyway(): void;
        updateWaypoints(): void;
        isWorldTeleportable(arg0: Internal.WaypointWorld_): boolean;
        getCurrentOriginContainerID(): string;
        getWaypointMap(): Internal.HashMap<string, Internal.WaypointWorldContainer>;
        addWorld(arg0: string, arg1: string): Internal.WaypointWorld;
        getCurrentOriginContainerID(arg0: string): string;
        getCurrentContainerAndWorldID(arg0: string, arg1: string): string;
        getDimensionDirectoryName(arg0: Internal.ResourceKey_<Internal.Level>): string;
        /**
         * @deprecated
        */
        divideBy8(arg0: string): boolean;
        canTeleport(arg0: boolean, arg1: Internal.WaypointWorld_): boolean;
        createTemporaryWaypoints(arg0: Internal.WaypointWorld_, arg1: number, arg2: number, arg3: number, arg4: boolean): void;
        createTemporaryWaypoints(arg0: Internal.WaypointWorld_, arg1: number, arg2: number, arg3: number): void;
        isTeleportationSafe(arg0: Internal.WaypointWorld_): boolean;
        getAutoContainerID(): string;
        removeContainer(arg0: string): void;
        setCurrentSpawn(arg0: BlockPos_, arg1: Internal.ClientLevel_): void;
        addWorldContainer(arg0: string): Internal.WaypointWorldContainer;
        updateWorldIds(): void;
        ignoreContainerCase(arg0: string, arg1: string): string;
        getDimensionDivision(arg0: string): number;
        getCurrentWorld(arg0: string, arg1: string): Internal.WaypointWorld;
        getWorld(arg0: string, arg1: string): Internal.WaypointWorld;
        teleportToWaypoint(arg0: Internal.Waypoint_, arg1: Internal.WaypointWorld_, arg2: Internal.Screen_, arg3: boolean): void;
        getCurrentWorld(): Internal.WaypointWorld;
        setWaypoints(arg0: Internal.WaypointSet_): void;
        getCurrentContainerID(arg0: string): string;
        getAutoWorld(): Internal.WaypointWorld;
        getCustomContainerID(): string;
        getCurrentContainerAndWorldID(): string;
        get autoWorldID(): string
        get waypoints(): Internal.WaypointSet
        set customWorldID(arg0: string)
        get autoRootContainerID(): string
        get currentContainerID(): string
        set customContainerID(arg0: string)
        get serverWaypoints(): Internal.List<Internal.Waypoint>
        get customWorldID(): string
        get currentWorldID(): string
        get currentOriginContainerID(): string
        get waypointMap(): Internal.HashMap<string, Internal.WaypointWorldContainer>
        get autoContainerID(): string
        get currentWorld(): Internal.WaypointWorld
        set waypoints(arg0: Internal.WaypointSet_)
        get autoWorld(): Internal.WaypointWorld
        get customContainerID(): string
        get currentContainerAndWorldID(): string
        static readonly customWaypoints: {};
        setChanged: number;
        static readonly TELEPORT_ANYWAY_COMMAND: "xaero_tp_anyway";
    }
    type WaypointsManager_ = WaypointsManager;
    interface ICoordinate {
        get(arg0: BlockPos_): number;
        (arg0: BlockPos_): number;
    }
    type ICoordinate_ = ICoordinate;
    interface TextureAccess {
        darkness_enableUploadHook(): void;
    }
    type TextureAccess_ = TextureAccess;
    class ClientboundSetExperiencePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: number, arg1: number, arg2: number)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getExperienceLevel(): number;
        isSkippable(): boolean;
        getExperienceProgress(): number;
        getTotalExperience(): number;
        get experienceLevel(): number
        get skippable(): boolean
        get experienceProgress(): number
        get totalExperience(): number
    }
    type ClientboundSetExperiencePacket_ = ClientboundSetExperiencePacket;
    class LeverBlock extends Internal.FaceAttachedHorizontalDirectionalBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        setMaterial(v: Internal.MaterialJS_): void;
        getEternaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        pull(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.BlockState;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): Internal.SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MaterialColor_): Internal.MaterialColor;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        set material(v: Internal.MaterialJS_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly POWERED: Internal.BooleanProperty;
    }
    type LeverBlock_ = LeverBlock;
    interface DungeonFeatureAccessor {
        getMOBS(): Internal.EntityType<any>[];
        get MOBS(): Internal.EntityType<any>[]
    }
    type DungeonFeatureAccessor_ = DungeonFeatureAccessor;
    class LecternBlockEntity extends Internal.BlockEntity implements Internal.MenuProvider, Internal.Clearable {
        constructor(arg0: BlockPos_, arg1: Internal.BlockState_)
        getDisplayName(): Internal.Component;
        static tryClear(arg0: any): void;
        deserializeNBT(arg0: Internal.Tag_): void;
        requestModelDataUpdate(): void;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        setBook(arg0: Internal.ItemStack_, arg1: Internal.Player_): void;
        getPage(): number;
        serializeNBT(): Internal.CompoundTag;
        createMenu(arg0: number, arg1: Internal.Inventory_, arg2: Internal.Player_): Internal.AbstractContainerMenu;
        getBook(): Internal.ItemStack;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getModelData(): Internal.ModelData;
        onLoad(): void;
        setBook(arg0: Internal.ItemStack_): void;
        getRedstoneSignal(): number;
        clearContent(): void;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        hasBook(): boolean;
        getRenderBoundingBox(): Internal.AABB;
        get displayName(): Internal.Component
        get page(): number
        get book(): Internal.ItemStack
        get modelData(): Internal.ModelData
        set book(arg0: Internal.ItemStack_)
        get redstoneSignal(): number
        get renderBoundingBox(): Internal.AABB
        static readonly NUM_DATA: 1;
        static readonly DATA_PAGE: 0;
        static readonly NUM_SLOTS: 1;
        static readonly SLOT_BOOK: 0;
    }
    type LecternBlockEntity_ = LecternBlockEntity;
    class UserBanList extends Internal.StoredUserList<Internal.GameProfile, any> {
        constructor(arg0: Internal.File_)
        isBanned(arg0: Internal.GameProfile_): boolean;
    }
    type UserBanList_ = UserBanList;
    class NetherSproutsBlock extends Internal.BushBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        static isSmoothBlendingEnabled<T>(world: Internal.BlockAndTintGetter_, state: Internal.StateHolder_<T, any>, pos: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockS