/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.betterburning;

import net.darkhax.betterburning.config.ConfigForge;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod(value="betterburning")
public class BetterBurningForge {
    public static final String MODID = "betterburning";
    private final ConfigForge configuration = new ConfigForge();

    public BetterBurningForge() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.configuration.getSpec());
        MinecraftForge.EVENT_BUS.addListener(this::onLivingDeath);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingTick);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingAttack);
        MinecraftForge.EVENT_BUS.addListener(this::onBlockBreak);
        MinecraftForge.EVENT_BUS.addListener(this::rightClickBlockWithItem);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(this::onBlockOverlay);
        }
    }

    private void rightClickBlockWithItem(PlayerInteractEvent.RightClickBlock event) {
        if (this.configuration.canExtinguishWithBottledWater() && event.getEntity() != null && !(event.getEntity() instanceof FakePlayer)) {
            BlockState state = event.getLevel().m_8055_(event.getPos());
            Block block = state.m_60734_();
            ItemStack stack = event.getItemStack();
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            if (!(block != Blocks.f_50083_ && block != Blocks.f_50084_ || stack.m_41720_() != Items.f_42589_ || Potions.f_43599_ != potion || event.getLevel().f_46443_)) {
                event.getLevel().m_46597_(event.getPos(), Blocks.f_50016_.m_49966_());
                event.getLevel().m_5898_(null, 1009, event.getPos(), 0);
                ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)new ItemStack((ItemLike)Items.f_42590_));
                stack.m_41774_(1);
            }
        }
    }

    private void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && !(event.getPlayer() instanceof FakePlayer)) {
            int burnTime;
            Block block = event.getState().m_60734_();
            int n = block == Blocks.f_50083_ ? this.configuration.getFirePunchBurnTime() : (burnTime = block == Blocks.f_50084_ ? this.configuration.getSoulFirePunchBurnTime() : 0);
            if (burnTime > 0) {
                event.getPlayer().m_20254_(burnTime);
            }
            if (block instanceof BaseFireBlock && !this.configuration.canPunchOutFlames()) {
                event.setCanceled(true);
            }
        }
    }

    private void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource().m_19384_() && this.configuration.shouldDamageSourceCauseFire() && !event.getEntity().m_6060_() && !event.getEntity().f_19853_.f_46443_) {
            event.getEntity().m_20254_(1);
        }
    }

    private void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (this.configuration.shouldSkeletonsShootFireArrows() && (entity = event.getEntity()) instanceof Arrow) {
            Entity shooter;
            Arrow arrow = (Arrow)entity;
            if (!event.getEntity().f_19853_.f_46443_ && (shooter = arrow.m_37282_()) instanceof AbstractSkeleton && shooter.m_6060_() && shooter.m_6084_() && this.tryPercentage(this.configuration.getSkeletonFlameArrowChance())) {
                arrow.m_7311_(shooter.m_20094_());
            }
        }
    }

    private void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (this.configuration.shouldFireResExtinguish() && !event.getEntity().f_19853_.f_46443_ && event.getEntity().m_6060_() && event.getEntity().m_21023_(MobEffects.f_19607_)) {
            event.getEntity().m_20095_();
        }
    }

    private void onLivingAttack(LivingAttackEvent event) {
        Entity sourceEntity;
        if (this.configuration.shouldFireDamageSpread() && !event.getEntity().f_19853_.f_46443_ && (sourceEntity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity sourceLiving = (LivingEntity)sourceEntity;
            ItemStack heldItem = sourceLiving.m_21205_();
            if (!(sourceLiving instanceof Zombie) && heldItem.m_41619_() && sourceLiving.m_6060_() && this.tryPercentage(this.configuration.getFireDamageSpreadChance())) {
                float damage = Math.max(1.0f, event.getEntity().f_19853_.m_6436_(event.getEntity().m_20183_()).m_19056_());
                event.getEntity().m_20254_(2 * (int)damage);
            }
            if (heldItem.m_41720_() == Items.f_42409_ && this.configuration.shouldFlintAndSteelDoFireDamage()) {
                event.getEntity().m_20254_(this.configuration.getFlintAndSteelFireDamage());
            }
        }
    }

    private void onBlockOverlay(RenderBlockScreenEffectEvent event) {
        if (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.FIRE && this.configuration.hideFireOverlay() && (event.getPlayer().m_5825_() || event.getPlayer().m_21023_(MobEffects.f_19607_))) {
            event.setCanceled(true);
        }
    }

    private boolean tryPercentage(double chance) {
        return Math.random() < chance;
    }
}

