/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import shadows.apotheosis.adventure.affix.socket.AddSocketsRecipe;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.affix.socket.gem.GemManager;
import shadows.apotheosis.adventure.compat.ApothSmithingCategory;
import shadows.apotheosis.adventure.compat.GemCuttingCategory;
import shadows.apotheosis.adventure.compat.SalvagingCategory;
import shadows.apotheosis.adventure.loot.LootRarity;

@JeiPlugin
public class AdventureJEIPlugin
implements IModPlugin {
    public static final RecipeType<UpgradeRecipe> APO_SMITHING = RecipeType.create((String)"apotheosis", (String)"smithing", AdventureModule.ApothUpgradeRecipe.class);
    public static final RecipeType<SalvagingRecipe> SALVAGING = RecipeType.create((String)"apotheosis", (String)"salvaging", SalvagingRecipe.class);
    public static final RecipeType<GemCuttingCategory.GemCuttingRecipe> GEM_CUTTING = RecipeType.create((String)"apotheosis", (String)"gem_cutting", GemCuttingCategory.GemCuttingRecipe.class);
    private static final List<ItemStack> DUMMY_INPUTS = Arrays.asList(Items.f_42430_, Items.f_42390_, Items.f_42428_, Items.f_42469_, Items.f_42713_).stream().map(ItemStack::new).toList();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", "adventure_module");
    }

    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        ItemStack gem = new ItemStack((ItemLike)Apoth.Items.GEM.get());
        Gem gemObj = (Gem)GemManager.INSTANCE.getRandomItem((RandomSource)new LegacyRandomSource(1854L));
        GemItem.setGem(gem, gemObj);
        GemItem.setLootRarity(gem, gemObj.getMaxRarity());
        reg.addIngredientInfo((Object)gem, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.socketing")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Apoth.Items.GEM_DUST.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.gem_crushing")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Apoth.Items.VIAL_OF_EXTRACTION.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.gem_extraction")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Apoth.Items.VIAL_OF_EXPULSION.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.gem_expulsion")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Apoth.Items.VIAL_OF_UNNAMING.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.unnaming")});
        ApothSmithingCategory.registerExtension(AddSocketsRecipe.class, new AddSocketsExtension());
        reg.addRecipes(APO_SMITHING, Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44113_).stream().filter(r -> r instanceof AdventureModule.ApothUpgradeRecipe).toList());
        ArrayList<SalvagingRecipe> salvagingRecipes = new ArrayList<SalvagingRecipe>(Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(Apoth.RecipeTypes.SALVAGING));
        salvagingRecipes.sort(Comparator.comparingInt(recipe -> recipe.getOutputs().stream().mapToInt(SalvagingRecipe.OutputData::getMax).max().orElse(0)));
        reg.addRecipes(SALVAGING, salvagingRecipes);
        ArrayList<GemCuttingCategory.GemCuttingRecipe> gemCutRecipes = new ArrayList<GemCuttingCategory.GemCuttingRecipe>();
        for (Gem g : GemManager.INSTANCE.getValues()) {
            LootRarity max = LootRarity.ANCIENT;
            for (LootRarity r2 = LootRarity.COMMON; r2 != max; r2 = r2.next()) {
                if (g.clamp(r2) != r2) continue;
                gemCutRecipes.add(new GemCuttingCategory.GemCuttingRecipe(g, r2));
            }
        }
        reg.addRecipes(GEM_CUTTING, gemCutRecipes);
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        reg.addRecipeCategories(new IRecipeCategory[]{new ApothSmithingCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new SalvagingCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new GemCuttingCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50625_), new RecipeType[]{APO_SMITHING});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Apoth.Blocks.SALVAGING_TABLE.get()), new RecipeType[]{SALVAGING});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Apoth.Blocks.GEM_CUTTING_TABLE.get()), new RecipeType[]{GEM_CUTTING});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        reg.registerSubtypeInterpreter((Item)Apoth.Items.GEM.get(), (IIngredientSubtypeInterpreter)new GemSubtypes());
    }

    static class AddSocketsExtension
    implements ApothSmithingCategory.Extension<AddSocketsRecipe> {
        private static final List<ItemStack> DUMMY_OUTPUTS = DUMMY_INPUTS.stream().map(ItemStack::m_41777_).map(s -> {
            SocketHelper.setSockets(s, 1);
            return s;
        }).toList();

        AddSocketsExtension() {
        }

        @Override
        public void setRecipe(IRecipeLayoutBuilder builder, AddSocketsRecipe recipe, IFocusGroup focuses) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DUMMY_INPUTS);
            builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients(recipe.getInput());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStacks(DUMMY_OUTPUTS);
        }

        @Override
        public void draw(AddSocketsRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            MutableComponent text = Component.m_237110_((String)"text.apotheosis.socket_limit", (Object[])new Object[]{recipe.getMaxSockets()});
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92889_(stack, (Component)text, (float)(62 - font.m_92852_((FormattedText)text) / 2), 23.0f, 0);
        }
    }

    static class GemSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        GemSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            Gem gem = GemItem.getGem(stack);
            LootRarity rarity = GemItem.getLootRarity(stack);
            if (gem == null) {
                return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
            }
            return gem.getId() + "@" + rarity.id();
        }
    }
}

