/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;

public record GemInstance(Gem gem, LootCategory cat, ItemStack gemStack, LootRarity rarity) {
    public GemInstance(ItemStack socketed, ItemStack gemStack) {
        this(GemItem.getGem(gemStack), LootCategory.forItem(socketed), gemStack, GemItem.getLootRarity(gemStack));
    }

    public static GemInstance unsocketed(ItemStack gemStack) {
        return new GemInstance(GemItem.getGem(gemStack), LootCategory.NONE, gemStack, GemItem.getLootRarity(gemStack));
    }

    public boolean isValidUnsocketed() {
        return this.gem != null && this.rarity != null;
    }

    public boolean isValid() {
        return this.isValidUnsocketed() && this.gem.getBonus(this.cat).isPresent();
    }

    public void addModifiers(EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> map) {
        for (EquipmentSlot itemSlot : this.cat.getSlots()) {
            if (itemSlot != slot) continue;
            this.ifPresent(b -> b.addModifiers(this.gemStack, this.rarity, map));
        }
    }

    public Component getSocketBonusTooltip() {
        return this.map(b -> b.getSocketBonusTooltip(this.gemStack, this.rarity)).orElse((Component)Component.m_237113_((String)"Invalid Gem Category"));
    }

    public int getDamageProtection(DamageSource source) {
        return this.map(b -> b.getDamageProtection(this.gemStack, this.rarity, source)).orElse(0);
    }

    public float getDamageBonus(MobType creatureType) {
        return this.map(b -> Float.valueOf(b.getDamageBonus(this.gemStack, this.rarity, creatureType))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void doPostAttack(LivingEntity user, @Nullable Entity target) {
        this.ifPresent(b -> b.doPostAttack(this.gemStack, this.rarity, user, target));
    }

    public void doPostHurt(LivingEntity user, @Nullable Entity attacker) {
        this.ifPresent(b -> b.doPostHurt(this.gemStack, this.rarity, user, attacker));
    }

    public void onArrowFired(LivingEntity user, AbstractArrow arrow) {
        this.ifPresent(b -> b.onArrowFired(this.gemStack, this.rarity, user, arrow));
    }

    @Nullable
    public InteractionResult onItemUse(UseOnContext ctx) {
        return this.map(b -> b.onItemUse(this.gemStack, this.rarity, ctx)).orElse(null);
    }

    public void onArrowImpact(AbstractArrow arrow, ItemStack gem, LootRarity rarity, HitResult res, HitResult.Type type) {
    }

    public float onShieldBlock(LivingEntity entity, DamageSource source, float amount) {
        return this.map(b -> Float.valueOf(b.onShieldBlock(this.gemStack, this.rarity, entity, source, amount))).orElse(Float.valueOf(amount)).floatValue();
    }

    public void onBlockBreak(Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        this.ifPresent(b -> b.onBlockBreak(this.gemStack, this.rarity, player, world, pos, state));
    }

    public float getDurabilityBonusPercentage(ServerPlayer user) {
        return this.map(b -> Float.valueOf(b.getDurabilityBonusPercentage(this.gemStack, this.rarity, user))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float onHurt(DamageSource src, LivingEntity ent, float amount) {
        return this.map(b -> Float.valueOf(b.onHurt(this.gemStack, this.rarity, src, ent, amount))).orElse(Float.valueOf(amount)).floatValue();
    }

    public void getEnchantmentLevels(Map<Enchantment, Integer> enchantments) {
        this.ifPresent(b -> b.getEnchantmentLevels(this.gemStack, this.rarity, enchantments));
    }

    public void modifyLoot(ObjectArrayList<ItemStack> loot, LootContext ctx) {
        this.ifPresent(b -> b.modifyLoot(this.gemStack, this.rarity, loot, ctx));
    }

    private <T> Optional<T> map(Function<GemBonus, T> function) {
        return this.gem.getBonus(this.cat).map(function);
    }

    private void ifPresent(Consumer<GemBonus> function) {
        this.gem.getBonus(this.cat).ifPresent(function);
    }
}

