/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.salvaging;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingMenu;
import shadows.placebo.cap.InternalItemHandler;

public class SalvagingTableTile
extends BlockEntity {
    protected final InternalItemHandler output = new InternalItemHandler(6);
    protected final LazyOptional<SalvagingItemHandler> itemHandler = LazyOptional.of(() -> new SalvagingItemHandler());

    public SalvagingTableTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Apoth.Tiles.SALVAGING_TABLE.get(), pPos, pBlockState);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("output", (Tag)this.output.serializeNBT());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("output")) {
            this.output.deserializeNBT(tag.m_128469_("output"));
        }
        super.m_142466_(tag);
    }

    protected class SalvagingItemHandler
    implements IItemHandler {
        protected SalvagingItemHandler() {
        }

        public int getSlots() {
            return 1 + SalvagingTableTile.this.output.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return ItemStack.f_41583_;
            }
            return SalvagingTableTile.this.output.getStackInSlot(slot - 1);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int i;
            if (slot != 0) {
                return stack;
            }
            List<ItemStack> outputs = SalvagingMenu.getBestPossibleSalvageResults(SalvagingTableTile.this.f_58857_, stack);
            if (outputs.isEmpty()) {
                return stack;
            }
            IntOpenHashSet skipSlots = new IntOpenHashSet();
            for (ItemStack out : outputs) {
                for (i = 0; i < 6; ++i) {
                    if (skipSlots.contains(i)) continue;
                    int size = out.m_41613_();
                    if (size != (out = SalvagingTableTile.this.output.insertItem(i, out, true)).m_41613_()) {
                        skipSlots.add(i);
                    }
                    if (out.m_41619_()) break;
                }
                if (out.m_41619_()) continue;
                return stack;
            }
            if (!simulate) {
                for (ItemStack out : outputs) {
                    for (i = 0; i < 6 && !(out = SalvagingTableTile.this.output.insertItem(i, out, false)).m_41619_(); ++i) {
                    }
                    if (out.m_41619_()) continue;
                    return stack;
                }
            }
            return ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.f_41583_;
            }
            return SalvagingTableTile.this.output.extractItem(slot - 1, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 1;
            }
            return SalvagingTableTile.this.output.getSlotLimit(slot - 1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return SalvagingMenu.findMatch(SalvagingTableTile.this.f_58857_, stack) != null;
            }
            return false;
        }
    }
}

