/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.loot.LootRarity;

public class ExtendedInvTrigger
extends InventoryChangeTrigger {
    public InventoryChangeTrigger.TriggerInstance m_7214_(JsonObject json, EntityPredicate.Composite andPred, DeserializationContext conditionsParser) {
        JsonObject slots = GsonHelper.m_13841_((JsonObject)json, (String)"slots", (JsonObject)new JsonObject());
        MinMaxBounds.Ints occupied = MinMaxBounds.Ints.m_55373_((JsonElement)slots.get("occupied"));
        MinMaxBounds.Ints full = MinMaxBounds.Ints.m_55373_((JsonElement)slots.get("full"));
        MinMaxBounds.Ints empty = MinMaxBounds.Ints.m_55373_((JsonElement)slots.get("empty"));
        ItemPredicate[] predicate = ItemPredicate.m_45055_((JsonElement)json.get("items"));
        if (json.has("apoth")) {
            predicate = this.deserializeApoth(json.getAsJsonObject("apoth"));
        }
        return new InventoryChangeTrigger.TriggerInstance(andPred, occupied, full, empty, predicate);
    }

    ItemPredicate[] deserializeApoth(JsonObject json) {
        String type = json.get("type").getAsString();
        if ("spawn_egg".equals(type)) {
            return new ItemPredicate[]{new TrueItemPredicate(s -> s.m_41720_() instanceof SpawnEggItem)};
        }
        if ("enchanted".equals(type)) {
            Enchantment ench = json.has("enchantment") ? (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(json.get("enchantment").getAsString())) : null;
            MinMaxBounds.Ints bound = MinMaxBounds.Ints.m_55373_((JsonElement)json.get("level"));
            return new ItemPredicate[]{new TrueItemPredicate(s -> {
                Map enchMap = EnchantmentHelper.m_44831_((ItemStack)s);
                if (ench != null) {
                    return bound.m_55390_(enchMap.getOrDefault(ench, 0).intValue());
                }
                return enchMap.values().stream().anyMatch(arg_0 -> ((MinMaxBounds.Ints)bound).m_55390_(arg_0));
            })};
        }
        if ("affix".equals(type)) {
            return new ItemPredicate[]{new TrueItemPredicate(s -> !AffixHelper.getAffixes(s).isEmpty())};
        }
        if ("rarity".equals(type)) {
            LootRarity rarity = LootRarity.byId(json.get("rarity").getAsString().toLowerCase(Locale.ROOT));
            return new ItemPredicate[]{new TrueItemPredicate(s -> AffixHelper.getRarity(s) == rarity)};
        }
        if ("gem_rarity".equals(type)) {
            LootRarity rarity = LootRarity.byId(json.get("rarity").getAsString().toLowerCase(Locale.ROOT));
            return new ItemPredicate[]{new TrueItemPredicate(s -> GemItem.getLootRarity(s) == rarity)};
        }
        if ("socket".equals(type)) {
            return new ItemPredicate[]{new TrueItemPredicate(s -> SocketHelper.getGems(s).stream().anyMatch(gem -> !gem.m_41619_()))};
        }
        if ("nbt".equals(type)) {
            CompoundTag tag;
            try {
                tag = TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)json.get("nbt"), (String)"nbt"));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            return new ItemPredicate[]{new TrueItemPredicate(s -> {
                if (!s.m_41782_()) {
                    return false;
                }
                for (String key : tag.m_128431_()) {
                    if (tag.m_128423_(key).equals(s.m_41783_().m_128423_(key))) continue;
                    return false;
                }
                return true;
            })};
        }
        return new ItemPredicate[0];
    }

    private static class TrueItemPredicate
    extends ItemPredicate {
        Predicate<ItemStack> predicate;

        TrueItemPredicate(Predicate<ItemStack> predicate) {
            this.predicate = predicate;
        }

        public boolean m_45049_(ItemStack item) {
            return this.predicate.test(item);
        }
    }
}

