/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import net.minecraft.class_151;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7066;

public class BiomeTitleCommand {
    public static final DynamicCommandExceptionType BIOME_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(formatArgs -> new class_2588("travelerstitles.commands.biometitle.notfound", new Object[]{formatArgs}));
    public static final DynamicCommandExceptionType INVALID_BIOME_EXCEPTION = new DynamicCommandExceptionType(formatArgs -> new class_2588("travelerstitles.commands.biometitle.invalid", new Object[]{formatArgs}));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"biometitle").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"biome", (ArgumentType)class_7066.method_41170((class_5321)class_2378.field_25114)).executes(context -> BiomeTitleCommand.displayTitle((class_2168)context.getSource(), (class_7066.class_7068<class_1959>)class_7066.method_41165((CommandContext)context, (String)"biome")))));
    }

    public static int displayTitle(class_2168 commandSource, class_7066.class_7068<class_1959> biomeResult) throws CommandSyntaxException {
        class_2588 biomeTitle;
        class_2960 biomeBaseKey;
        try {
            biomeBaseKey = new class_2960(biomeResult.method_41176());
        }
        catch (class_151 e) {
            throw INVALID_BIOME_EXCEPTION.create((Object)biomeResult.method_41176());
        }
        String overrideBiomeNameKey = class_156.method_646((String)"travelerstitles.biome", (class_2960)biomeBaseKey);
        String normalBiomeNameKey = class_156.method_646((String)"biome", (class_2960)biomeBaseKey);
        if (TravelersTitlesCommon.CONFIG.biomes.biomeBlacklist.contains(biomeBaseKey.toString())) {
            commandSource.method_9226((class_2561)new class_2585("That biome is blacklisted, so its title won't normally show!"), false);
        }
        if (class_2477.method_10517().method_4678(overrideBiomeNameKey)) {
            biomeTitle = new class_2588(overrideBiomeNameKey);
        } else if (class_2477.method_10517().method_4678(normalBiomeNameKey)) {
            biomeTitle = new class_2588(normalBiomeNameKey);
        } else {
            throw BIOME_NOT_FOUND_EXCEPTION.create((Object)biomeResult.method_41176());
        }
        String overrideBiomeColorKey = overrideBiomeNameKey + ".color";
        String normalBiomeColorKey = normalBiomeNameKey + ".color";
        String biomeColorStr = class_2477.method_10517().method_4678(overrideBiomeColorKey) ? class_2477.method_10517().method_4679(overrideBiomeColorKey) : (class_2477.method_10517().method_4678(normalBiomeColorKey) ? class_2477.method_10517().method_4679(normalBiomeColorKey) : TravelersTitlesCommon.titleManager.biomeTitleRenderer.titleDefaultTextColor);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.setColor(biomeColorStr);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.displayTitle((class_2561)biomeTitle, null);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.cooldownTimer = TravelersTitlesCommon.CONFIG.biomes.textCooldownTime;
        return 1;
    }
}

