onEvent('player.logged_in', event => {
    if (!event.player.stages.has('difficulty_normal') && !event.player.stages.has('difficulty_easy') && !event.player.stages.has('difficulty_hard') && !event.player.stages.has('difficulty_impossible') && !event.player.stages.has('difficulty_impossibleplus')) {
        event.player.stages.add('difficulty_easy')
    }
})

onEvent('entity.hurt', event => {
    let target = event.getEntity()
    let source = event.getSource().getActual()
    let damage = event.getDamage()
    let entity = event.getSource().getImmediate()

    //event.server.runCommand(`say ${event.getSource().getType()}`)

    if (target.player) {
        let offItem = target.getHeldItem(OFF_HAND).getId()
        let armor_result = event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor get`)
        let armor_toughness_result = event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor_toughness get`)
        //event.server.runCommand(`say ${armor_result}`)
        if (target.stages.has('difficulty_easy')) {
            if (source != null && (source.type == "minecraft:ender_dragon" || source.type == "minecraft:wither")) {
                if (entity != null && !entity.living) {

                    entity.kill()
                    damage_new = damage
                    if (offItem.indexOf("shield") >= 0) damage_new = damage_new / 2
                    target.attack(damage_new * (1 - Math.min(20, Math.max(armor_result / 5, armor_result - damage_new / (2 + armor_toughness_result / 4))) / 25))
                }
            }
        }
        else if (target.stages.has('difficulty_normal')) {
            if (source != null && (source.type == "minecraft:ender_dragon" || source.type == "minecraft:wither")) {
                //玩家受到的生物伤害额外增加10%
                //event.cancel()
                //target.attack(damage*1.1)
                if (entity != null && !entity.living) {

                    //event.cancel()
                    entity.kill()
                    damage_new = damage * 1.1
                    if (offItem.indexOf("shield") >= 0) damage_new = damage_new / 2
                    target.attack(damage_new * (1 - Math.min(20, Math.max(armor_result / 5, armor_result - damage_new / (2 + armor_toughness_result / 4))) / 25))
                }
            }
        }
        else if (target.stages.has('difficulty_hard')) {
            if (source != null && (source.type == "minecraft:ender_dragon" || source.type == "minecraft:wither")) {
                //玩家受到的生物伤害额外增加15%
                //event.cancel()
                //target.attack(damage*1.2)
                if (entity != null && !entity.living) {

                    //event.cancel()
                    entity.kill()
                    damage_new = damage * 1.15
                    if (offItem.indexOf("shield") >= 0) damage_new = damage_new / 2
                    target.attack(damage_new * (1 - Math.min(20, Math.max(armor_result / 5, armor_result - damage_new / (2 + armor_toughness_result / 4))) / 25))
                }
            }
        }
        else if (target.stages.has('difficulty_impossible')) {
            if (source != null && (source.type == "minecraft:ender_dragon" || source.type == "minecraft:wither")) {
                //玩家受到的生物伤害额外增加50%
                if (entity != null && !entity.living) {
                    //event.cancel()
                    entity.kill()
                    damage_new = damage * 1.5
                    if (offItem.indexOf("shield") >= 0) damage_new = damage_new / 2
                    target.attack(damage_new * (1 - Math.min(20, Math.max(armor_result / 5, armor_result - damage_new / (2 + armor_toughness_result / 4))) / 25))
                }
            }
        }
        else if (target.stages.has('difficulty_impossibleplus')) {
            if (source != null && (source.type == "minecraft:ender_dragon" || source.type == "minecraft:wither")) {
                //玩家受到的生物伤害额外增加150%
                if (entity != null && !entity.living) {
                    //event.cancel()
                    entity.kill()
                    damage_new = damage * 2.5
                    if (offItem.indexOf("shield") >= 0) damage_new = damage_new / 2
                    target.attack(damage_new * (1 - Math.min(20, Math.max(armor_result / 5, armor_result - damage_new / (2 + armor_toughness_result / 4))) / 25))
                }
            }
        }
    }

})

onEvent('entity.hurt', event => {
    let target = event.getEntity()
    let play = event.getSource().getPlayer()
    let damage = event.getDamage()
    if (play != null) {
        let result = event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor get`)
        if(play.stages.has('dag') && play.stages.has('difficulty_normal')){
            if(damage - damage * 0.1 <= result){
                event.cancel()
                target.attack(0)
            }else{
                target.heal(damage * 0.1)
            }
        }
        else if(play.stages.has('dag') && play.stages.has('difficulty_hard')){
            if(damage - damage * 0.2 <= result){
                event.cancel()
                target.attack(0)
            }else{
                target.heal(damage * 0.2)
            }
        }
        else if(play.stages.has('dag') && play.stages.has('difficulty_impossible')){
            if(damage - damage * 0.4 <= result){
                event.cancel()
                target.attack(0)
            }else{
                target.heal(damage * 0.4)
            }
        }
        else if(play.stages.has('dag') && play.stages.has('difficulty_impossibleplus')){
            if(damage - damage * 0.6 <= result){
                event.cancel()
                target.attack(0)
            }else{
                target.heal(damage * 0.6)
            }
        }
        else if (play.stages.has('difficulty_normal')) {
            //生物在未满血的状态下受到的玩家伤害减少10%
            //target.heal(damage * 0.1)
            target.heal(damage * 0.1)
        }
        else if (play.stages.has('difficulty_hard')) {
            //生物在未满血的状态下受到的玩家伤害减少20%
            target.heal(damage * 0.2)
        }
        else if (play.stages.has('difficulty_impossible')) {
            //生物在未满血的状态下受到的玩家伤害减少40%
                target.heal(damage * 0.4)
        }
        else if (play.stages.has('difficulty_impossibleplus')) {
            //生物在未满血的状态下受到的玩家伤害减少60%
                target.heal(damage * 0.6)
        }
    }
})

onEvent('recipes', event => {
    event.shapeless('kubejs:difficulty_changer', ['minecraft:clock'])
})

onEvent('item.right_click', event => {
    let player = event.getPlayer()
    if (event.player.getHeldItem(MAIN_HAND) == 'kubejs:difficulty_changer') {
        if (event.player.getHeldItem(OFF_HAND) != null) {
            event.server.runCommandSilent(`title ${event.player.profile.name} actionbar {"text":"你无法在副手持有物品时使用该物品","color":"red","bold":true}`)
        }
        else {
            if (event.player.stages.has('difficulty_easy')) {
                event.player.stages.remove('difficulty_easy')
                event.player.stages.remove('difficulty_normal')
                event.player.stages.remove('difficulty_hard')
                event.player.stages.remove('difficulty_impossible')
                event.player.stages.add('difficulty_normal')
                event.player.playSound('minecraft:entity.arrow.hit_player')
                event.server.runCommandSilent(`title ${event.player.profile.name} actionbar {"text":"当前难度：经典","color":"yellow","bold":true}`)
            }
            else if (event.player.stages.has('difficulty_normal')) {
                event.player.stages.remove('difficulty_easy')
                event.player.stages.remove('difficulty_normal')
                event.player.stages.remove('difficulty_hard')
                event.player.stages.remove('difficulty_impossible')
                event.player.stages.add('difficulty_hard')
                event.player.playSound('minecraft:entity.arrow.hit_player')
                event.server.runCommandSilent(`title ${event.player.profile.name} actionbar {"text":"当前难度：专家","color":"red","bold":true}`)
            }
            else if (event.player.stages.has('difficulty_hard')) {
                event.player.stages.remove('difficulty_easy')
                event.player.stages.remove('difficulty_normal')
                event.player.stages.remove('difficulty_hard')
                event.player.stages.remove('difficulty_impossible')
                event.player.stages.add('difficulty_impossible')
                event.player.playSound('minecraft:entity.arrow.hit_player')
                event.server.runCommandSilent(`title ${event.player.profile.name} actionbar {"text":"当前难度：大师","color":"dark_red","bold":true}`)
            }
            else if (event.player.stages.has('difficulty_impossible')) {
                event.player.stages.remove('difficulty_easy')
                event.player.stages.remove('difficulty_normal')
                event.player.stages.remove('difficulty_hard')
                event.player.stages.remove('difficulty_impossible')
                event.player.stages.remove('difficulty_impossibleplus')
                event.player.stages.add('difficulty_impossibleplus')
                event.player.playSound('minecraft:entity.arrow.hit_player')
                event.server.runCommandSilent(`title ${event.player.profile.name} actionbar {"text":"当前难度：死亡","color":"dark_red","bold":true}`)
            }
            else if (event.player.stages.has('difficulty_impossibleplus')) {
                event.player.stages.remove('difficulty_easy')
                event.player.stages.remove('difficulty_normal')
                event.player.stages.remove('difficulty_hard')
                event.player.stages.remove('difficulty_impossible')
                event.player.stages.remove('difficulty_impossibleplus')
                event.player.stages.add('difficulty_easy')
                event.player.playSound('minecraft:entity.arrow.hit_player')
                event.server.runCommandSilent(`title ${event.player.profile.name} actionbar {"text":"当前难度：旅途","color":"green","bold":true}`)
            }
            else {
                event.player.stages.remove('difficulty_easy')
                event.player.stages.remove('difficulty_normal')
                event.player.stages.remove('difficulty_hard')
                event.player.stages.remove('difficulty_impossible')
                event.player.stages.remove('difficulty_impossibleplus')
                event.player.stages.add('difficulty_easy')
                event.player.playSound('minecraft:entity.arrow.hit_player')
                event.server.runCommandSilent(`title ${event.player.profile.name} actionbar {"text":"当前难度：旅途","color":"green","bold":true}`)
            }
        }
    }
})

//概率事件

function randomNum(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

onEvent('entity.hurt', event => {
    let target = event.getEntity()
    let player = event.getSource().getPlayer()
    let source = event.getSource().getActual()
    let targetTypes = [
        "minecraft:wither",
        "soulsweapons:chaos_monarch",
        "minecraft:ender_dragon",
        "twilightforest:naga",
        "twilightforest:lich",
        "twilightforest:alpha_yeti",
        "twilightforest:minoshroom",
        "twilightforest:snow_queen",
        "twilightforest:hydra",
        "twilightforest:ur_ghast",
        "soulsweapons:moonknight",
        "soulsweapons:accursed_lord_boss",
        "soulsweapons:draugr_boss",
        "adventurez:stone_golem",
        "adventurez:void_shadow",
        "adventurez:the_eye",
        "whisperwoods:hirschgeist",
        "soulsweapons:night_shade",
        "terrarianslimes:king_slime",
        "bosses_of_mass_destruction:lich",
        "bosses_of_mass_destruction:void_blossom",
        "bosses_of_mass_destruction:gauntlet",
        "bosses_of_mass_destruction:obsidilith"
    ]
    if (player != null) {
        if (target.monster) {
            //event.server.runCommand(`say ${result}`)
            let result = event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor get`)
            let result1 = event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor base get`)
            if (player.stages.has('difficulty_impossible')) {
                if (result <= 11 && targetTypes.includes(target.type)) {
                    event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor base set ${result + (10 - result)}`)
                }
                else if (result <= 6) {
                    event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor base set ${5 - result + result1}`)
                }
            } else if (player.stages.has('difficulty_impossibleplus')) {
                if (result >= 21 && targetTypes.includes(target.type) && result < 30) {
                    event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor base set ${result - result * 0.1}`)
                }
                else if (result <= 21 && targetTypes.includes(target.type)) {
                    event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor base set ${result + (20 - result)}`)
                }
                else if (result >= 16 && !targetTypes.includes(target.type)) {
                    event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor base set ${15 - result}`)
                }
                else if (result < 15) {
                    event.server.runCommandSilent(`attribute ${target.id} minecraft:generic.armor base set ${15 - result + result1}`)

                }

            }
        }
    }

})