/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import net.minecraft.class_1657;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public abstract class SimpleBarOverlay
extends BaseOverlay {
    protected int tick = 0;

    protected void drawDecorations(class_4587 poseStack, int left, int top, int right, int bottom, Parameters parameters, boolean flip) {
    }

    private void draw(class_4587 poseStack, int left, int top, int right, int bottom, Parameters parameters, boolean flip) {
        if (parameters == null) {
            return;
        }
        if (parameters.boundColor2 == 0) {
            this.drawBound(poseStack, left, top, right, bottom, parameters.boundColor);
        } else {
            this.drawBound(poseStack, left, top, right, bottom, parameters.boundColor, parameters.boundColor2);
        }
        this.drawEmptyFill(poseStack, left + 1, top + 1, right - 1, bottom - 1, parameters.emptyColor);
        int innerWidth = right - left - 2;
        int fillWidth = (int)((double)innerWidth * parameters.value / parameters.capacity);
        if (parameters.fillColor2 != 0) {
            this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, fillWidth, parameters.fillColor, parameters.fillColor2, flip);
        } else {
            this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, fillWidth, parameters.fillColor, flip);
        }
        if (parameters.boundFillColor != 0) {
            int boundFillWidth = (int)((double)innerWidth * parameters.boundValue / parameters.boundCapacity);
            this.drawBoundFlip(poseStack, left, top, right, bottom, boundFillWidth, parameters.boundFillColor, flip);
        }
        if (parameters.centerText != null) {
            Overlays.addStringRender((left + right) / 2, top - 2, parameters.centerColor, parameters.centerText, 1, true);
        }
        if (parameters.leftText != null) {
            if (flip) {
                Overlays.addStringRender(right - 2, top - 2, parameters.leftColor, parameters.leftText, 2, true);
            } else {
                Overlays.addStringRender(left + 2, top - 2, parameters.leftColor, parameters.leftText, 0, true);
            }
        }
        if (parameters.rightText != null) {
            if (flip) {
                Overlays.addStringRender(left + 2, top - 2, parameters.rightColor, parameters.rightText, 0, true);
            } else {
                Overlays.addStringRender(right - 2, top - 2, parameters.rightColor, parameters.rightText, 2, true);
            }
        }
        this.drawDecorations(poseStack, left, top, right, bottom, parameters, flip);
    }

    protected abstract Parameters getParameters(class_1657 var1);

    protected abstract boolean shouldRender(class_1657 var1);

    protected boolean isLeftSide() {
        return false;
    }

    protected boolean alwaysLow() {
        return false;
    }

    @Override
    public void renderOverlay(RenderGui gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        boolean flip;
        int right;
        int top;
        int left;
        class_746 player = gui.mc().field_1724;
        if (player == null) {
            return;
        }
        this.tick = gui.gui().method_1738();
        if (!this.shouldRender((class_1657)player)) {
            return;
        }
        Parameters parameters = this.getParameters((class_1657)player);
        if (parameters == null) {
            return;
        }
        int style = Overlays.style;
        if (this.alwaysLow()) {
            style = 2;
        }
        switch (style) {
            default: {
                return;
            }
            case 1: 
            case 2: {
                if (this.isLeftSide()) {
                    left = screenWidth / 2 - 91;
                    top = screenHeight - gui.leftHeight() + 4;
                    right = left + 81;
                    flip = false;
                    gui.leftHeight(6);
                    break;
                }
                left = screenWidth / 2 + 10;
                top = screenHeight - gui.rightHeight() + 4;
                right = left + 81;
                flip = true;
                gui.rightHeight(6);
                this.draw(poseStack, left, top, left + 81, top + 5, parameters, true);
                break;
            }
            case 3: {
                top = Overlays.vertical;
                left = Overlays.horizontal;
                right = left + Overlays.length;
                flip = false;
                Overlays.vertical += 6;
                break;
            }
            case 4: {
                top = Overlays.vertical;
                left = screenWidth - Overlays.length - Overlays.horizontal;
                right = left + Overlays.length;
                flip = true;
                Overlays.vertical += 6;
                break;
            }
            case 5: {
                top = screenHeight - Overlays.vertical;
                left = Overlays.horizontal;
                right = left + Overlays.length;
                flip = false;
                Overlays.vertical += 6;
                break;
            }
            case 6: {
                top = screenHeight - Overlays.vertical;
                left = screenWidth - Overlays.length - Overlays.horizontal;
                right = left + Overlays.length;
                flip = true;
                Overlays.vertical += 6;
            }
        }
        this.draw(poseStack, left, top, right, top + 5, parameters, flip);
    }

    public static class Parameters {
        public int fillColor = 0;
        public int fillColor2 = 0;
        public int boundColor = 0;
        public int boundColor2 = 0;
        public int emptyColor = 0;
        public double value = 0.0;
        public double capacity = 1.0;
        public int boundFillColor = 0;
        public double boundValue = 0.0;
        public double boundCapacity = 1.0;
        public String centerText = null;
        public String leftText = null;
        public String rightText = null;
        public int centerColor = 0;
        public int leftColor = 0;
        public int rightColor = 0;
    }
}

