/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.afoxxvi.asteorbar.utils.PlatformAdapter;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class PlayerHealthOverlay
extends BaseOverlay {
    public static final int ABSORPTION_MODE_TOGETHER = 0;
    public static final int ABSORPTION_MODE_STACK = 1;
    public static final int ABSORPTION_MODE_BOUND = 2;
    public static final int ABSORPTION_MODES = 3;
    public static final int ABSORPTION_TEXT_MODE_TOGETHER = 0;
    public static final int ABSORPTION_TEXT_MODE_SEPARATE = 1;
    public static final int ABSORPTION_TEXT_MODES = 2;
    private long healthBlinkTime = 0L;
    private long lastHealthTime;
    private float lastHealth;

    private int[] getStackColor(int low, int num) {
        String[] colors = AsteorBar.config.stackHealthBarColors().split(",");
        String color1 = low == 0 ? "#00000000" : colors[(low - 1) % colors.length];
        String color2 = colors[low % colors.length];
        if (num == 2) {
            return new int[]{Utils.parseHexColor(color1), Utils.parseHexColor(color2)};
        }
        return new int[]{Utils.parseHexColor(color1), Utils.parseHexColor(color2), Utils.parseHexColor(colors[(low + 1) % colors.length])};
    }

    private void draw(class_4587 poseStack, int left, int top, int right, int bottom, boolean highlight, int healthColor, float health, float absorb, float maxHealth, float flashAlpha, int regenerationOffset, double healthIncrement, long tick, boolean flip) {
        this.drawBound(poseStack, left, top, right, bottom, AsteorBar.config.healthBoundColor());
        this.drawEmptyFill(poseStack, left + 1, top + 1, right - 1, bottom - 1, AsteorBar.config.healthEmptyColor());
        int outerLength = right - left;
        int innerLength = outerLength - 2;
        int i = AsteorBar.config.displayAbsorptionMethod();
        if (AsteorBar.config.enableStackHealthBar()) {
            i = 2;
        }
        float alpha = (float)Math.cos((double)(tick % 40L) / 40.0 * Math.PI * 2.0) * 0.5f + 0.5f;
        if (i == 0) {
            healthLength = (int)((float)innerLength * health / (maxHealth + absorb));
            int emptyLength = (int)((float)innerLength * (maxHealth - health) / (maxHealth + absorb));
            int absorbLength = innerLength - healthLength - emptyLength;
            if (absorb <= 0.0f) {
                healthLength += absorbLength;
                absorbLength = 0;
            }
            healthLength += innerLength - emptyLength - absorbLength - healthLength;
            this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, healthLength, healthColor, flip);
            if (healthIncrement > 0.0 && health < maxHealth) {
                int incrementLength = (double)health + healthIncrement >= (double)maxHealth ? emptyLength : (int)((double)innerLength * healthIncrement / (double)(maxHealth + absorb));
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                this.drawFillFlipConcat(poseStack, left + 1, top + 1, right - 1, bottom - 1, healthLength, incrementLength, healthColor, flip);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (absorbLength > 0) {
                if (flip) {
                    this.drawFillFlip(poseStack, left + 1, top + 1, right - 1 - healthLength, bottom - 1, absorbLength, AsteorBar.config.absorptionColor(), true);
                } else {
                    this.drawFillFlip(poseStack, left + 1 + healthLength, top + 1, right - 1, bottom - 1, absorbLength, AsteorBar.config.absorptionColor(), false);
                }
            }
        } else {
            healthLength = (int)((float)innerLength * health / maxHealth);
            if (AsteorBar.config.enableStackHealthBar()) {
                int[] colors;
                int unit = AsteorBar.config.fullHealthValue();
                healthLength = (int)((float)innerLength * (health % (float)unit) / (float)unit);
                int incrementLengthA = 0;
                int incrementLengthB = 0;
                if (healthIncrement > 0.0 && health < maxHealth) {
                    if ((double)(health % (float)unit) + healthIncrement >= (double)unit) {
                        incrementLengthA = innerLength - healthLength;
                        incrementLengthB = (int)((double)innerLength * (healthIncrement - (double)((float)unit - health % (float)unit)) / (double)unit);
                    } else {
                        healthIncrement = Math.min(healthIncrement, (double)(maxHealth - health));
                        incrementLengthA = (int)((double)innerLength * healthIncrement / (double)unit);
                    }
                }
                if ((colors = this.getStackColor((int)(health / (float)unit), incrementLengthB > 0 ? 3 : 2))[0] != 0) {
                    this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, innerLength, colors[0], flip);
                }
                if (colors[1] != 0) {
                    this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, healthLength, colors[1], flip);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                if (incrementLengthA > 0) {
                    this.drawFillFlipConcat(poseStack, left + 1, top + 1, right - 1, bottom - 1, healthLength, incrementLengthA, colors[1], flip);
                }
                if (incrementLengthB > 0) {
                    this.drawFillFlipConcat(poseStack, left + 1, top + 1, right - 1, bottom - 1, 0, incrementLengthB, colors[2], flip);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (healthColor != AsteorBar.config.healthColorNormal()) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.66f);
                    this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, innerLength, healthColor, flip);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            } else {
                this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, healthLength, healthColor, flip);
                if (healthIncrement > 0.0 && health < maxHealth) {
                    int incrementLength = (double)health + healthIncrement >= (double)maxHealth ? innerLength - healthLength : (int)((double)innerLength * healthIncrement / (double)maxHealth);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    this.drawFillFlipConcat(poseStack, left + 1, top + 1, right - 1, bottom - 1, healthLength, incrementLength, healthColor, flip);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            float fullAbsorb = AsteorBar.config.enableStackHealthBar() ? (float)AsteorBar.config.fullHealthValue() : maxHealth;
            float displayAbsorb = absorb % fullAbsorb;
            if (displayAbsorb == 0.0f && absorb > 0.0f) {
                displayAbsorb = fullAbsorb;
            }
            if (i == 1) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.66f);
                absorbLength = (int)((float)innerLength * displayAbsorb / maxHealth);
                this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, absorbLength, AsteorBar.config.absorptionColor(), flip);
            } else if (i == 2) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                absorbLength = (int)((float)outerLength * displayAbsorb / maxHealth);
                this.drawBoundFlip(poseStack, left, top, right, bottom, absorbLength, AsteorBar.config.absorptionColor(), flip);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (absorb > fullAbsorb && (AsteorBar.config.enableStackHealthBar() || AsteorBar.config.displayAbsorptionDivMaxHealth())) {
                int absorbTimes = (int)(absorb / fullAbsorb);
                if (absorb % fullAbsorb == 0.0f) {
                    --absorbTimes;
                }
                if (flip) {
                    Overlays.addStringRender(right, top - 2, 0xFFFF00, "\u00d7" + absorbTimes, 0, true);
                } else {
                    Overlays.addStringRender(left, top - 2, 0xFFFF00, absorbTimes + "\u00d7", 2, true);
                }
            }
        }
        if (regenerationOffset >= 0) {
            int textureLeft = flip ? regenerationOffset - 180 : -regenerationOffset;
            int textureRight = textureLeft + right - left - 2;
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            if (textureRight > 0) {
                this.drawTextureFill(poseStack, left + 1, top, -textureLeft, 5, 190 + textureLeft, 0);
                this.drawTextureFill(poseStack, left + 1 - textureLeft, top, textureRight, 5, 10, 0);
            } else {
                this.drawTextureFill(poseStack, left + 1, top, right - left - 2, 5, 190 + textureLeft, 0);
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        }
        if (AsteorBar.config.displayHealthText()) {
            String hp = AsteorBar.config.displayAbsorptionTextMethod() == 0 && absorb > 0.0f ? Utils.formatNumber(health) + "(+" + Utils.formatNumber(absorb) + ")/" + Utils.formatNumber(maxHealth) : Utils.formatNumber(health) + "/" + Utils.formatNumber(maxHealth);
            Overlays.addStringRender((left + right) / 2, top - 2, 0xFFFFFF, hp, 1, true);
            if (AsteorBar.config.displayAbsorptionTextMethod() == 1 && absorb > 0.0f) {
                if (flip) {
                    Overlays.addStringRender(right - 2, top - 2, 0xFFFF00, Utils.formatNumber(absorb), 2, true);
                } else {
                    Overlays.addStringRender(left + 2, top - 2, 0xFFFF00, Utils.formatNumber(absorb), 0, true);
                }
            }
        }
        if (highlight) {
            this.drawBound(poseStack, left, top, right, bottom, AsteorBar.config.healthBoundColorBlink());
        } else if (flashAlpha > 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)flashAlpha);
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            this.drawBound(poseStack, left, top, right, bottom, AsteorBar.config.healthBoundColorLow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void renderOverlay(RenderGui gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        int right;
        int left;
        int top;
        RenderSystem.enableBlend();
        class_310 mc = gui.mc();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        float health = player.method_6032();
        boolean highlight = false;
        long tickCount = gui.gui().method_1738();
        if (AsteorBar.config.enableHealthBlink()) {
            boolean bl = highlight = this.healthBlinkTime > tickCount && (this.healthBlinkTime - tickCount) / 3L % 2L == 1L;
            if (health < this.lastHealth && player.field_6008 > 0) {
                this.lastHealthTime = class_156.method_658();
                this.healthBlinkTime = tickCount + 20L;
            } else if (health > this.lastHealth && player.field_6008 > 0) {
                this.lastHealthTime = class_156.method_658();
                this.healthBlinkTime = tickCount + 10L;
            }
            if (class_156.method_658() - this.lastHealthTime > 1000L) {
                this.lastHealth = health;
                this.lastHealthTime = class_156.method_658();
            }
            this.lastHealth = health;
        }
        float maxHealth = player.method_6063();
        float absorb = player.method_6067();
        int healthType = AsteorBar.config.healthColorNormal();
        if (player.method_6059(class_1294.field_5899)) {
            healthType = AsteorBar.config.healthColorPoison();
        } else if (player.method_6059(class_1294.field_5920)) {
            healthType = AsteorBar.config.healthColorWither();
        } else if (player.method_32314()) {
            healthType = AsteorBar.config.healthColorFrozen();
        }
        float flashAlpha = -1.0f;
        if ((double)health < (double)maxHealth * AsteorBar.config.lowHealthRate() && !highlight) {
            int margin = Math.abs((int)tickCount % 20 - 10);
            flashAlpha = 0.08f * (float)margin;
        }
        int regenerationOffset = -1;
        if (player.method_6059(class_1294.field_5924)) {
            regenerationOffset = (int)(tickCount % 30L * 6L);
        }
        double healthIncrement = 0.0;
        if (Overlays.appleskin) {
            PlatformAdapter.AppleSkinFoodValues foodValues = AsteorBar.platformAdapter.getAppleSkinFoodValues((class_1657)player);
            if (foodValues != null) {
                healthIncrement = foodValues.healthIncrement();
            }
            healthIncrement = Math.min(healthIncrement, (double)(maxHealth - health));
        }
        boolean flip = false;
        switch (Overlays.style) {
            default: {
                return;
            }
            case 1: {
                top = screenHeight - gui.leftHeight() - 2;
                left = screenWidth / 2 - 91;
                right = left + 182;
                gui.leftHeight(12);
                break;
            }
            case 2: {
                top = screenHeight - gui.leftHeight() + 4;
                left = screenWidth / 2 - 91;
                right = left + 81;
                gui.leftHeight(6);
                break;
            }
            case 3: {
                top = Overlays.vertical;
                left = Overlays.horizontal;
                right = left + Overlays.length;
                Overlays.vertical += 6;
                break;
            }
            case 4: {
                top = Overlays.vertical;
                left = screenWidth - Overlays.length - Overlays.horizontal;
                right = left + Overlays.length;
                flip = true;
                Overlays.vertical += 6;
                break;
            }
            case 5: {
                top = screenHeight - Overlays.vertical;
                left = Overlays.horizontal;
                right = left + Overlays.length;
                Overlays.vertical += 6;
                break;
            }
            case 6: {
                top = screenHeight - Overlays.vertical;
                left = screenWidth - Overlays.length - Overlays.horizontal;
                right = left + Overlays.length;
                flip = true;
                Overlays.vertical += 6;
            }
        }
        this.draw(poseStack, left, top, right, top + 5, highlight, healthType, health, absorb, maxHealth, flashAlpha, regenerationOffset, healthIncrement, tickCount, flip);
        RenderSystem.disableBlend();
    }
}

