/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.dehydration.access.ThirstManagerAccess;
import net.dehydration.init.EffectInit;
import net.dehydration.thirst.ThirstManager;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class DehydrationOverlay
extends BaseOverlay {
    private int blinkTime = 0;

    private void draw(class_4587 poseStack, int left, int top, int right, int bottom, boolean highlight, int thirstColor, int foodLevel, float exhaustion, boolean flip) {
        int boundColor = Utils.mixColor(-16777216, thirstColor, 0.5);
        if (highlight) {
            boundColor = Utils.mixColor(-1, thirstColor, 0.08);
        }
        this.drawBound(poseStack, left, top, right, bottom, boundColor);
        this.drawEmptyFill(poseStack, left + 1, top + 1, right - 1, bottom - 1, AsteorBar.config.foodEmptyColor());
        int innerWidth = right - left - 2;
        int foodWidth = (int)((float)(innerWidth * foodLevel) / 20.0f);
        this.drawFillFlip(poseStack, left + 1, top + 1, right - 1, bottom - 1, foodWidth, thirstColor, flip);
        if (AsteorBar.config.displayExhaustion()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int exhaustionWidth = (int)((float)innerWidth * (Math.min(4.0f, exhaustion) / 4.0f));
            this.drawTextureFillFlip(poseStack, left + 1, top, right - 1, exhaustionWidth, 5, 10, 9, 180, flip);
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        }
    }

    @Override
    public void renderOverlay(RenderGui gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (!Overlays.dehydration || !AsteorBar.config.hookDehydration()) {
            return;
        }
        class_746 player = gui.mc().field_1724;
        if (player == null) {
            return;
        }
        ThirstManager thirstManager = ((ThirstManagerAccess)player).getThirstManager((class_1657)player);
        if (!thirstManager.hasThirst()) {
            return;
        }
        int thirst = thirstManager.getThirstLevel();
        float dehydration = thirstManager.dehydration;
        int thirstColor = -15028249;
        if (player.method_6059(EffectInit.THIRST)) {
            thirstColor = -3938534;
        }
        if (player.method_32312() > 0) {
            thirstColor = -8467969;
        }
        if (AsteorBar.config.enableFoodBlink()) {
            if (thirstManager.dehydration >= 4.0f && gui.gui().method_1738() % (thirst * 3 + 1) == 0) {
                this.blinkTime = 2;
            }
            if (this.blinkTime > 0) {
                --this.blinkTime;
            }
        }
        switch (Overlays.style) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                int left = screenWidth / 2 + 10;
                int top = screenHeight - gui.rightHeight() + 4;
                gui.rightHeight(6);
                this.draw(poseStack, left, top, left + 81, top + 5, this.blinkTime > 0, thirstColor, thirst, dehydration, true);
                break;
            }
            case 3: {
                int top = Overlays.vertical;
                int left = Overlays.horizontal;
                this.draw(poseStack, left, top, left + Overlays.length, top + 5, this.blinkTime > 0, thirstColor, thirst, dehydration, false);
                Overlays.vertical += 6;
                break;
            }
            case 4: {
                int top = Overlays.vertical;
                int left = screenWidth - Overlays.length - Overlays.horizontal;
                this.draw(poseStack, left, top, left + Overlays.length, top + 5, this.blinkTime > 0, thirstColor, thirst, dehydration, true);
                Overlays.vertical += 6;
                break;
            }
            case 5: {
                int top = screenHeight - Overlays.vertical;
                int left = Overlays.horizontal;
                this.draw(poseStack, left, top, left + Overlays.length, top + 5, this.blinkTime > 0, thirstColor, thirst, dehydration, false);
                Overlays.vertical += 6;
                break;
            }
            case 6: {
                int top = screenHeight - Overlays.vertical;
                int left = screenWidth - Overlays.length - Overlays.horizontal;
                this.draw(poseStack, left, top, left + Overlays.length, top + 5, this.blinkTime > 0, thirstColor, thirst, dehydration, true);
                Overlays.vertical += 6;
            }
        }
    }
}

