/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.utils.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public abstract class BaseOverlay {
    public static final class_2960 TEXTURE = new class_2960("asteorbar", "textures/gui/overlay.png");
    public static final class_2960 LIGHTMAP_TEXTURE = new class_2960("asteorbar", "textures/ui/lightmap.png");
    public static final int FILL_FULL_WIDTH_LONG = 180;
    public static final int BOUND_FULL_WIDTH_LONG = 182;
    public static final int BOUND_FULL_WIDTH_SHORT = 81;
    public static final int Y_REGENERATION_FILL = 0;
    public static final int Y_FOOD_EXHAUSTION_FILL = 9;
    public static final int Y_EXPERIENCE_DECORATION = 18;
    public static final int Y_RIGHT_DECORATION = 27;
    public static final int Y_LEFT_DECORATION = 36;
    public BaseOverlay overrideOverlay = null;

    public boolean shouldOverride() {
        return false;
    }

    protected void drawTextureFill(class_4587 poseStack, int left, int top, int width, int height, int textureX, int textureY) {
        GuiHelper.drawTexturedRect(poseStack, left, top, textureX, textureY, width, height);
    }

    protected void drawTextureFillColor(class_4587 poseStack, int left, int top, int width, int height, int textureX, int textureY, int textureWidth, int textureHeight, int color) {
        GuiHelper.drawTexturedRectColor(poseStack, left, top, left + width, top + height, textureX, textureY, textureX + textureWidth, textureY + textureHeight, 256, 256, color);
    }

    protected void drawTextureFillFlip(class_4587 poseStack, int left, int top, int right, int width, int height, int textureX, int textureY, int textureFullWidth, boolean flip) {
        if (flip) {
            GuiHelper.drawTexturedRect(poseStack, right - width, top, textureX + textureFullWidth - width, textureY, width, height);
        } else {
            GuiHelper.drawTexturedRect(poseStack, left, top, textureX, textureY, width, height);
        }
    }

    protected void drawEmptyFill(class_4587 poseStack, int left, int top, int right, int bottom, int color) {
        GuiHelper.drawSolidGradient(poseStack, left, top, right, bottom, color);
    }

    protected void drawFillFlipConcat(class_4587 poseStack, int left, int top, int right, int bottom, int has, int width, int color, boolean flip) {
        if (has == 0) {
            this.drawFillFlip(poseStack, left, top, right, bottom, width, color, flip);
            return;
        }
        width = Math.max(0, Math.min(right - left - has, width));
        if (flip) {
            GuiHelper.drawSolidGradientUpDown(poseStack, right - has - width, top, right - has, bottom, color);
        } else {
            GuiHelper.drawSolidGradientUpDown(poseStack, left + has, top, left + has + width, bottom, color);
        }
    }

    protected void drawFillFlip(class_4587 poseStack, int left, int top, int right, int bottom, int width, int color, boolean flip) {
        width = Math.max(0, Math.min(right - left, width));
        if (flip) {
            GuiHelper.drawSolidGradientUpDown(poseStack, right - width, top, right, bottom, color);
        } else {
            GuiHelper.drawSolidGradientUpDown(poseStack, left, top, left + width, bottom, color);
        }
    }

    protected void drawFillFlip(class_4587 poseStack, int left, int top, int right, int bottom, int width, int color, int color2, boolean flip) {
        width = Math.max(0, Math.min(right - left, width));
        this.drawFillFlip(poseStack, left, top, right, bottom, width, color, flip);
        if (flip) {
            GuiHelper.drawSolidColor(poseStack, right - width, bottom - 1, right, bottom, color2);
        } else {
            GuiHelper.drawSolidColor(poseStack, left, bottom - 1, left + width, bottom, color2);
        }
    }

    protected void drawBoundFlipConcat(class_4587 poseStack, int left, int top, int right, int bottom, int has, int width, int color, boolean flip) {
        if (has == 0) {
            this.drawBoundFlip(poseStack, left, top, right, bottom, width, color, flip);
            return;
        }
        if ((width = Math.max(0, Math.min(right - left - has, width))) == 0) {
            return;
        }
        if (flip) {
            if (has + width >= right - left) {
                GuiHelper.drawSolidColor(poseStack, left, top + 1, left + 1, bottom - 1, color);
                --width;
            }
            GuiHelper.drawSolidColor(poseStack, right - has - width, top, right - has, top + 1, color);
            GuiHelper.drawSolidColor(poseStack, right - has - width, bottom - 1, right - has, bottom, color);
        } else {
            if (has + width >= right - left) {
                GuiHelper.drawSolidColor(poseStack, right - 1, top + 1, right, bottom - 1, color);
                --width;
            }
            GuiHelper.drawSolidColor(poseStack, left + has, top, left + has + width, top + 1, color);
            GuiHelper.drawSolidColor(poseStack, left + has, bottom - 1, left + has + width, bottom, color);
        }
    }

    protected void drawBoundFlip(class_4587 poseStack, int left, int top, int right, int bottom, int width, int color, boolean flip) {
        if ((width = Math.max(0, Math.min(right - left, width))) == 0) {
            return;
        }
        if (width == right - left) {
            this.drawBound(poseStack, left, top, right, bottom, color);
            return;
        }
        if (flip) {
            GuiHelper.drawSolidColor(poseStack, right - 1, top + 1, right, bottom - 1, color);
            if (width > 1) {
                GuiHelper.drawSolidColor(poseStack, right - 1 - width + 1, top, right - 1, top + 1, color);
                GuiHelper.drawSolidColor(poseStack, right - 1 - width + 1, bottom - 1, right - 1, bottom, color);
            }
        } else {
            GuiHelper.drawSolidColor(poseStack, left, top + 1, left + 1, bottom - 1, color);
            if (width > 1) {
                GuiHelper.drawSolidColor(poseStack, left + 1, top, left + 1 + width - 1, top + 1, color);
                GuiHelper.drawSolidColor(poseStack, left + 1, bottom - 1, left + 1 + width - 1, bottom, color);
            }
        }
    }

    protected void drawBound(class_4587 poseStack, int left, int top, int right, int bottom, int color) {
        GuiHelper.drawSolidColor(poseStack, left, top + 1, left + 1, bottom - 1, color);
        GuiHelper.drawSolidColor(poseStack, right - 1, top + 1, right, bottom - 1, color);
        GuiHelper.drawSolidColor(poseStack, left + 1, top, right - 1, top + 1, color);
        GuiHelper.drawSolidColor(poseStack, left + 1, bottom - 1, right - 1, bottom, color);
    }

    protected void drawBound(class_4587 poseStack, int left, int top, int right, int bottom, int color, int color2) {
        GuiHelper.drawSolidColor(poseStack, left, top + 1, left + 1, bottom - 2, color);
        GuiHelper.drawSolidColor(poseStack, right - 1, top + 1, right, bottom - 2, color);
        GuiHelper.drawSolidColor(poseStack, left + 1, top, right - 1, top + 1, color);
        GuiHelper.drawSolidColor(poseStack, left, bottom - 2, left + 1, bottom - 1, color2);
        GuiHelper.drawSolidColor(poseStack, right - 1, bottom - 2, right, bottom - 1, color2);
        GuiHelper.drawSolidColor(poseStack, left + 1, bottom - 1, right - 1, bottom, color2);
    }

    public void render(RenderGui gui, class_4587 poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (AsteorBar.config.enableOverlay()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
            if (this.overrideOverlay != null && this.overrideOverlay.shouldOverride()) {
                this.overrideOverlay.render(gui, poseStack, partialTick, screenWidth, screenHeight);
            } else {
                this.renderOverlay(gui, poseStack, partialTick, screenWidth, screenHeight);
            }
        }
    }

    public abstract void renderOverlay(RenderGui var1, class_4587 var2, float var3, int var4, int var5);
}

