/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.AirLevelOverlay;
import com.afoxxvi.asteorbar.overlay.parts.ArmorLevelOverlay;
import com.afoxxvi.asteorbar.overlay.parts.ExperienceBarOverlay;
import com.afoxxvi.asteorbar.overlay.parts.FoodLevelOverlay;
import com.afoxxvi.asteorbar.overlay.parts.MountHealthOverlay;
import com.afoxxvi.asteorbar.overlay.parts.PlayerHealthOverlay;
import com.afoxxvi.asteorbar.overlay.parts.StringOverlay;
import com.afoxxvi.asteorbar.utils.GuiHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class Overlays {
    public static final int STYLE_NONE = 0;
    public static final int STYLE_ABOVE_HOT_BAR_LONG = 1;
    public static final int STYLE_ABOVE_HOT_BAR_SHORT = 2;
    public static final int STYLE_TOP_LEFT = 3;
    public static final int STYLE_TOP_RIGHT = 4;
    public static final int STYLE_BOTTOM_LEFT = 5;
    public static final int STYLE_BOTTOM_RIGHT = 6;
    public static final int NUM_STYLES = 7;
    public static final PlayerHealthOverlay PLAYER_HEALTH = new PlayerHealthOverlay();
    public static final FoodLevelOverlay FOOD_LEVEL = new FoodLevelOverlay();
    public static final AirLevelOverlay AIR_LEVEL = new AirLevelOverlay();
    public static final ExperienceBarOverlay EXPERIENCE_BAR = new ExperienceBarOverlay();
    public static final MountHealthOverlay MOUNT_HEALTH = new MountHealthOverlay();
    public static final ArmorLevelOverlay ARMOR_LEVEL = new ArmorLevelOverlay();
    public static final StringOverlay STRING = new StringOverlay();
    public static int style = 0;
    public static int vertical = 0;
    public static int horizontal = 0;
    public static int length = 10;
    public static int leftHeight = 39;
    public static int rightHeight = 39;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private static List<Render> stringRenders = new ArrayList<Render>();
    private static boolean initialized = false;
    public static boolean toughAsNails = false;
    public static boolean thirst = false;
    public static boolean mekanism = false;
    public static boolean dehydration = false;
    public static boolean parcool = false;
    public static boolean ironsSpellbooks = false;
    public static boolean feathers = false;
    public static boolean appleskin = false;
    public static boolean superiorshields = false;
    public static boolean vampirism = false;

    public static void init() {
        initialized = true;
        toughAsNails = AsteorBar.platformAdapter.isModLoaded("toughasnails");
        thirst = AsteorBar.platformAdapter.isModLoaded("thirst");
        mekanism = AsteorBar.platformAdapter.isModLoaded("mekanism");
        dehydration = AsteorBar.platformAdapter.isModLoaded("dehydration");
        parcool = AsteorBar.platformAdapter.isModLoaded("parcool");
        ironsSpellbooks = AsteorBar.platformAdapter.isModLoaded("irons_spellbooks");
        feathers = AsteorBar.platformAdapter.isModLoaded("feathers");
        appleskin = AsteorBar.platformAdapter.isModLoaded("appleskin");
        superiorshields = AsteorBar.platformAdapter.isModLoaded("superiorshields");
        vampirism = AsteorBar.platformAdapter.isModLoaded("vampirism");
    }

    public static void reset() {
        if (!initialized) {
            Overlays.init();
        }
        vertical = AsteorBar.config.cornerVerticalPadding();
        horizontal = AsteorBar.config.cornerHorizontalPadding();
        length = AsteorBar.config.cornerBarLength();
        style = AsteorBar.config.overlayLayoutStyle();
        stringRenders.clear();
        leftHeight = 39;
        rightHeight = 39;
    }

    public static void renderString(class_4587 poseStack) {
        if (stringRenders == null) {
            return;
        }
        poseStack.method_22903();
        float scale = (float)AsteorBar.config.overlayTextScale();
        poseStack.method_22905(scale, scale, 1.0f);
        class_327 font = class_310.method_1551().field_1772;
        for (Render render : stringRenders) {
            int width = font.method_1727(render.text);
            float x = (float)render.x / scale + (float)width / 2.0f * (1.0f / scale - 1.0f);
            float f = (float)render.y / scale;
            Objects.requireNonNull(font);
            float y = f + 9.0f / 2.0f * (1.0f / scale - 1.0f);
            if (render.bound) {
                GuiHelper.drawString(poseStack, render.text, (int)x + 1, (int)y, render.boundColor, render.shadow);
                GuiHelper.drawString(poseStack, render.text, (int)x - 1, (int)y, render.boundColor, render.shadow);
                GuiHelper.drawString(poseStack, render.text, (int)x, (int)y + 1, render.boundColor, render.shadow);
                GuiHelper.drawString(poseStack, render.text, (int)x, (int)y - 1, render.boundColor, render.shadow);
            }
            GuiHelper.drawString(poseStack, render.text, (int)x, (int)y, render.color, render.shadow);
        }
        poseStack.method_22909();
        stringRenders.clear();
    }

    public static void addStringRender(int x, int y, int color, String text, int align, boolean shadow) {
        Overlays.addStringRender(x, y, color, text, align, shadow, false, 0);
    }

    public static void addStringRender(int x, int y, int color, String text, int align, boolean shadow, boolean bound, int boundColor) {
        if (stringRenders == null) {
            stringRenders = new ArrayList<Render>();
        }
        Render render = new Render();
        render.x = x;
        render.y = y;
        render.color = color;
        render.text = text;
        render.align = align;
        render.shadow = shadow;
        switch (render.align) {
            case 1: {
                render.x -= class_310.method_1551().field_1772.method_1727(text) / 2;
                break;
            }
            case 2: {
                render.x -= class_310.method_1551().field_1772.method_1727(text);
            }
        }
        render.bound = bound;
        render.boundColor = boundColor;
        stringRenders.add(render);
    }

    private static class Render {
        int x;
        int y;
        int color;
        String text;
        int align;
        boolean shadow;
        boolean bound;
        int boundColor;

        private Render() {
        }
    }
}

