/*
 * Decompiled with CFR 0.152.
 */
package ninjaphenix.container_library.api.client.gui;

import ellemes.container_library.CommonClient;
import ellemes.container_library.Utils;
import ellemes.container_library.client.gui.PickScreen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_768;
import ninjaphenix.container_library.api.client.ScreenConstructor;
import ninjaphenix.container_library.api.client.function.ScreenSize;
import ninjaphenix.container_library.api.client.function.ScreenSizeRetriever;
import ninjaphenix.container_library.api.inventory.AbstractHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends class_465<AbstractHandler> {
    private static final Map<class_2960, ScreenConstructor<?>> SCREEN_CONSTRUCTORS = new HashMap();
    private static final Map<class_2960, ScreenSizeRetriever> SIZE_RETRIEVERS = new HashMap<class_2960, ScreenSizeRetriever>();
    private static final Set<class_2960> PREFERS_SINGLE_SCREEN = new HashSet<class_2960>();
    protected final int inventoryWidth;
    protected final int inventoryHeight;
    protected final int totalSlots;

    protected AbstractScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title, ScreenSize screenSize) {
        super((class_1703)handler, playerInventory, title);
        this.totalSlots = handler.getInventory().method_5439();
        this.inventoryWidth = screenSize.getWidth();
        this.inventoryHeight = screenSize.getHeight();
    }

    @ApiStatus.Internal
    public static AbstractScreen createScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title) {
        ScreenSize screenSize;
        class_2960 forcedScreenType = handler.getForcedScreenType();
        class_2960 preference = forcedScreenType != null ? forcedScreenType : CommonClient.getConfigWrapper().getPreferredScreenType();
        int scaledWidth = class_310.method_1551().method_22683().method_4486();
        int scaledHeight = class_310.method_1551().method_22683().method_4502();
        int slots = handler.getInventory().method_5439();
        if (forcedScreenType == null && AbstractScreen.canSingleScreenDisplay(slots, scaledWidth, scaledHeight) && AbstractScreen.shouldPreferSingleScreen(preference)) {
            preference = Utils.SINGLE_SCREEN_TYPE;
        }
        if ((screenSize = SIZE_RETRIEVERS.get(preference).get(slots, scaledWidth, scaledHeight)) == null) {
            throw new IllegalStateException("screenSize should never be null...");
        }
        return SCREEN_CONSTRUCTORS.get(preference).createScreen(handler, playerInventory, title, screenSize);
    }

    private static boolean shouldPreferSingleScreen(class_2960 type) {
        return PREFERS_SINGLE_SCREEN.contains(type);
    }

    private static boolean canSingleScreenDisplay(int slots, int scaledWidth, int scaledHeight) {
        if (slots <= 54) {
            return true;
        }
        if (scaledHeight >= 276) {
            if (slots <= 81) {
                return true;
            }
            if (scaledWidth >= 230 && slots <= 108) {
                return true;
            }
            if (scaledWidth >= 284 && slots <= 135) {
                return true;
            }
            if (scaledWidth >= 338 && slots <= 162) {
                return true;
            }
        }
        if (scaledWidth >= 338) {
            if (scaledHeight >= 330 && slots <= 216) {
                return true;
            }
            return scaledHeight >= 384 && slots <= 270;
        }
        return false;
    }

    @ApiStatus.Internal
    public static void declareScreenType(class_2960 type, ScreenConstructor<?> screenConstructor) {
        SCREEN_CONSTRUCTORS.putIfAbsent(type, screenConstructor);
    }

    @ApiStatus.Internal
    public static void declareScreenSizeRetriever(class_2960 type, ScreenSizeRetriever retriever) {
        SIZE_RETRIEVERS.putIfAbsent(type, retriever);
    }

    @ApiStatus.Internal
    public static boolean isScreenTypeDeclared(class_2960 type) {
        return SCREEN_CONSTRUCTORS.containsKey(type);
    }

    @ApiStatus.Internal
    public static void setPrefersSingleScreen(class_2960 type) {
        PREFERS_SINGLE_SCREEN.add(type);
    }

    @Nullable
    @ApiStatus.Internal
    public static ScreenSize getScreenSize(class_2960 type, int slots, int scaledWidth, int scaledHeight) {
        return SIZE_RETRIEVERS.get(type).get(slots, scaledWidth, scaledHeight);
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float delta) {
        this.method_25420(stack);
        super.method_25394(stack, mouseX, mouseY, delta);
        this.method_2380(stack, mouseX, mouseY);
    }

    public final boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (CommonClient.isConfigKeyPressed(keyCode, scanCode, modifiers) && ((AbstractHandler)this.field_2797).getForcedScreenType() == null) {
            this.field_22787.method_1507((class_437)new PickScreen(this));
            return true;
        }
        if (keyCode == 256 || this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public abstract List<class_768> getExclusionZones();

    @ApiStatus.Internal
    public int getInventoryWidth() {
        return this.inventoryWidth;
    }
}

