/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.wrappers;

import ellemes.container_library.Utils;
import ellemes.container_library.api.v3.OpenableInventory;
import ellemes.container_library.api.v3.OpenableInventoryProvider;
import ellemes.container_library.api.v3.context.BaseContext;
import ellemes.container_library.api.v3.context.BlockContext;
import ellemes.container_library.inventory.ServerScreenHandlerFactory;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import ninjaphenix.container_library.api.inventory.AbstractHandler;
import ninjaphenix.container_library.api.v2.OpenableBlockEntityV2;

public abstract class NetworkWrapper {
    protected abstract void openScreenHandler(class_3222 var1, class_1263 var2, ServerScreenHandlerFactory var3, class_2561 var4, class_2960 var5);

    public abstract void c_openBlockInventory(class_2338 var1);

    public final void writeBlockData(class_2540 buffer, class_2338 pos) {
        buffer.method_10812(Utils.id("block"));
        buffer.method_10807(pos);
    }

    public abstract void c_openEntityInventory(class_1297 var1);

    public final void writeEntityData(class_2540 buffer, class_1297 entity) {
        buffer.method_10812(Utils.id("entity"));
        buffer.method_10797(entity.method_5667());
    }

    public void s_handleOpenInventory(class_3222 sender, class_2540 buffer) {
        OpenableInventory inventory;
        class_2960 context = buffer.method_10810();
        class_3218 level = sender.method_14220();
        BaseContext inventoryContext = null;
        OpenableInventoryProvider inventoryProvider = null;
        switch (context.method_12832()) {
            case "block": {
                class_2248 class_22482;
                class_2338 pos = buffer.method_10811();
                if (!this.canOpenInventory(sender, pos) || !((class_22482 = level.method_8320(pos).method_26204()) instanceof OpenableInventoryProvider)) break;
                OpenableInventoryProvider provider = (OpenableInventoryProvider)class_22482;
                inventoryContext = new BlockContext(level, sender, pos);
                inventoryProvider = provider;
                break;
            }
            case "entity": {
                class_1297 entity = level.method_14190(buffer.method_10790());
                if (!(entity instanceof OpenableInventoryProvider)) break;
                OpenableInventoryProvider provider = (OpenableInventoryProvider)entity;
                inventoryContext = new BaseContext(level, sender);
                inventoryProvider = provider;
            }
        }
        if (inventoryProvider != null && (inventory = inventoryProvider.getOpenableInventory(inventoryContext)) != null) {
            this.s_openInventory(sender, inventory, inventoryProvider::onInitialOpen, inventoryProvider.getForcedScreenType());
        }
        buffer.release();
    }

    private void s_openInventory(class_3222 player, OpenableInventory inventory, Consumer<class_3222> onInitialOpen, class_2960 forcedScreenType) {
        class_2561 title = inventory.getInventoryTitle();
        if (!inventory.canBeUsedBy(player)) {
            player.method_7353((class_2561)Utils.translation("container.isLocked", title), true);
            player.method_17356(class_3417.field_14731, class_3419.field_15245, 1.0f, 1.0f);
            return;
        }
        if (!player.method_7325()) {
            onInitialOpen.accept(player);
        }
        this.openScreenHandler(player, inventory.getInventory(), (syncId, inv, playerInv) -> new AbstractHandler(syncId, inv, playerInv, null), title, forcedScreenType);
    }

    public final void s_openInventory(class_3222 player, OpenableBlockEntityV2 inventory, Consumer<class_3222> onInitialOpen, class_2338 pos, class_2960 forcedScreenType) {
        if (inventory == null) {
            return;
        }
        if (this.canOpenInventory(player, pos)) {
            class_2561 title = inventory.getInventoryTitle();
            if (!inventory.canBeUsedBy(player)) {
                player.method_7353((class_2561)Utils.translation("container.isLocked", title), true);
                player.method_17356(class_3417.field_14731, class_3419.field_15245, 1.0f, 1.0f);
                return;
            }
            if (!player.method_7325()) {
                onInitialOpen.accept(player);
            }
            this.openScreenHandler(player, inventory.getInventory(), (syncId, inv, playerInv) -> new AbstractHandler(syncId, inv, playerInv, null), title, forcedScreenType);
        }
    }

    public abstract boolean canOpenInventory(class_3222 var1, class_2338 var2);
}

