/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import ellemes.container_library.CommonClient;
import ellemes.container_library.Utils;
import ellemes.container_library.client.PickButton;
import ellemes.container_library.client.gui.widget.ScreenPickButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import ninjaphenix.container_library.api.client.function.ScreenSizePredicate;
import ninjaphenix.container_library.api.client.gui.AbstractScreen;
import ninjaphenix.container_library.api.inventory.AbstractHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PickScreen
extends class_437 {
    private static final Map<class_2960, PickButton> BUTTON_SETTINGS = new HashMap<class_2960, PickButton>();
    private final Set<class_2960> options = ImmutableSortedSet.copyOf(BUTTON_SETTINGS.keySet());
    private final Supplier<class_437> returnToScreen;
    private final List<ScreenPickButton> optionButtons = new ArrayList<ScreenPickButton>(this.options.size());
    @NotNull
    private final Runnable onOptionPicked;
    private final AbstractHandler handler;
    private int topPadding;

    public PickScreen(AbstractScreen currentScreen) {
        this((AbstractHandler)currentScreen.method_17577(), () -> AbstractScreen.createScreen((AbstractHandler)currentScreen.method_17577(), class_310.method_1551().field_1724.method_31548(), currentScreen.method_25440()), () -> {});
    }

    public PickScreen(Supplier<class_437> returnToScreen) {
        this(null, returnToScreen, () -> {});
    }

    public PickScreen(@NotNull Runnable onOptionPicked) {
        this(null, () -> null, onOptionPicked);
    }

    private PickScreen(@Nullable AbstractHandler handler, Supplier<class_437> returnToScreen, Runnable onOptionPicked) {
        super((class_2561)Utils.translation("screen.ellemes_container_lib.screen_picker_title", new Object[0]));
        this.handler = handler;
        this.returnToScreen = returnToScreen;
        this.onOptionPicked = onOptionPicked;
    }

    @Deprecated
    @ApiStatus.Internal
    public static void declareButtonSettings(class_2960 type, class_2960 texture, class_2561 title, ScreenSizePredicate warningTest, List<class_2561> warningText) {
        BUTTON_SETTINGS.putIfAbsent(type, new PickButton(texture, title, warningTest, warningText));
    }

    public void method_25419() {
        if (this.handler != null) {
            int invSize;
            class_2960 preference = CommonClient.getConfigWrapper().getPreferredScreenType();
            if (AbstractScreen.getScreenSize(preference, invSize = this.handler.getInventory().method_5439(), this.field_22787.method_22683().method_4486(), this.field_22787.method_22683().method_4502()) == null) {
                this.field_22787.field_1724.method_7353((class_2561)Utils.translation("generic.ellemes_container_lib.label", new Object[0]).method_27692(class_124.field_1065).method_10852((class_2561)Utils.translation("chat.ellemes_container_lib.cannot_display_screen", Utils.translation("screen." + preference.method_12836() + "." + preference.method_12832() + "_screen", new Object[0])).method_27692(class_124.field_1068)), false);
                this.field_22787.field_1724.method_7346();
                return;
            }
            this.handler.clearSlots();
        }
        this.field_22787.method_1507(this.returnToScreen.get());
    }

    public boolean method_25421() {
        return this.field_22787.field_1687 == null;
    }

    protected void method_25426() {
        int topPadding;
        super.method_25426();
        class_2960 preference = CommonClient.getConfigWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(class_3532.method_15346((int)this.field_22789, (int)96), choices);
        int innerPadding = Math.min((this.field_22789 - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.field_22789 - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.field_22790 - 96) / 2;
        this.optionButtons.clear();
        for (class_2960 option : this.options) {
            final PickButton settings = BUTTON_SETTINGS.get(option);
            final boolean isWarn = settings.getWarningTest().test(this.field_22789, this.field_22790);
            final boolean isCurrent = option.equals((Object)preference);
            class_4185.class_5316 tooltip = new class_4185.class_5316(){
                private static final class_2561 CURRENT_OPTION_TEXT = Utils.translation("screen.ellemes_container_lib.current_option_notice", new Object[0]).method_27692(class_124.field_1065);

                public void onTooltip(class_4185 button, class_4587 stack, int x, int y) {
                    ArrayList<class_2561> tooltip = new ArrayList<class_2561>(4);
                    tooltip.add(button.method_25369());
                    if (isCurrent) {
                        tooltip.add(CURRENT_OPTION_TEXT);
                    }
                    if (isWarn) {
                        tooltip.addAll(settings.getWarningText());
                    }
                    PickScreen.this.method_32634(stack, tooltip, Optional.empty(), x, y);
                }

                public void method_37023(Consumer<class_2561> consumer) {
                    if (isCurrent) {
                        consumer.accept(CURRENT_OPTION_TEXT);
                    }
                    if (isWarn) {
                        class_2585 text = new class_2585("");
                        for (class_2561 component : settings.getWarningText()) {
                            text.method_10852(component);
                        }
                        consumer.accept((class_2561)text);
                    }
                }
            };
            this.optionButtons.add((ScreenPickButton)this.method_37063((class_364)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, button -> this.updatePlayerPreference(option), tooltip)));
            ++x;
        }
    }

    private void updatePlayerPreference(class_2960 selection) {
        CommonClient.getConfigWrapper().setPreferredScreenType(selection);
        this.onOptionPicked.run();
        this.method_25419();
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float delta) {
        this.method_25420(stack);
        super.method_25394(stack, mouseX, mouseY, delta);
        this.optionButtons.forEach(button -> button.renderButtonTooltip(stack, mouseX, mouseY));
        class_332.method_27534((class_4587)stack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)Math.max(this.topPadding / 2, 0), (int)-1);
    }
}

