/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import ellemes.container_library.CommonClient;
import ellemes.container_library.Utils;
import ellemes.container_library.client.gui.widget.PageButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import ninjaphenix.container_library.api.client.function.ScreenSize;
import ninjaphenix.container_library.api.client.gui.AbstractScreen;
import ninjaphenix.container_library.api.client.gui.TexturedRect;
import ninjaphenix.container_library.api.inventory.AbstractHandler;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.jetbrains.annotations.NotNull;

@IPNGuiHint(button=IPNButton.MOVE_TO_CONTAINER, horizontalOffset=58)
public final class PageScreen
extends AbstractScreen {
    private final class_2960 textureLocation;
    private final int textureWidth;
    private final int textureHeight;
    private final Set<TexturedRect> blankArea = new LinkedHashSet<TexturedRect>();
    private final int blankSlots;
    private final int pages;
    private PageButton leftPageButton;
    private PageButton rightPageButton;
    private int page;
    private class_5250 currentPageText;
    private float pageTextX;

    public PageScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        this.textureLocation = Utils.id("textures/gui/container/shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png");
        this.textureWidth = switch (this.inventoryWidth) {
            case 9 -> {
                if (this.inventoryHeight == 3) {
                    yield 176;
                }
                yield 208;
            }
            case 12 -> 256;
            case 15 -> 320;
            case 18 -> 368;
            default -> throw new IllegalStateException("Unexpected value: " + this.inventoryWidth);
        };
        this.textureHeight = switch (this.inventoryHeight) {
            case 3 -> 192;
            case 6 -> 240;
            case 9 -> 304;
            default -> throw new IllegalStateException("Unexpected value: " + this.inventoryHeight);
        };
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        this.pages = class_3532.method_15384((double)((double)this.totalSlots / (double)slotsPerPage));
        int lastPageSlots = this.totalSlots - (this.pages - 1) * slotsPerPage;
        this.blankSlots = slotsPerPage - lastPageSlots;
        this.field_2792 = 7 + 18 * this.inventoryWidth + 7;
        this.field_2779 = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
    }

    private static boolean regionIntersects(class_339 widget, int x, int y, int width, int height) {
        return widget.field_22760 <= x + width && y <= widget.field_22761 + widget.method_25364() || x <= widget.field_22760 + widget.method_25368() && widget.field_22761 <= y + height;
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        ArrayList<Pair<ScreenSize, ScreenSize>> options = new ArrayList<Pair<ScreenSize, ScreenSize>>();
        PageScreen.addEntry(options, slots, 9, 3);
        PageScreen.addEntry(options, slots, 9, 6);
        if (scaledHeight >= 276 && slots > 54) {
            PageScreen.addEntry(options, slots, 9, 9);
        }
        Pair<ScreenSize, ScreenSize> picked = null;
        for (Pair<ScreenSize, ScreenSize> option : options) {
            if (picked == null) {
                picked = option;
                continue;
            }
            ScreenSize pickedMeta = (ScreenSize)picked.getSecond();
            ScreenSize iterMeta = (ScreenSize)option.getSecond();
            ScreenSize iterDim = (ScreenSize)option.getFirst();
            if (pickedMeta.getHeight() == iterMeta.getHeight() && iterMeta.getWidth() < pickedMeta.getWidth()) {
                picked = option;
                continue;
            }
            if (CommonClient.getConfigWrapper().preferSmallerScreens() && pickedMeta.getWidth() == iterMeta.getWidth() + 1 && (double)iterMeta.getHeight() <= (double)(iterDim.getWidth() * iterDim.getHeight()) / 2.0 || iterMeta.getWidth() >= pickedMeta.getWidth() || !((double)iterMeta.getHeight() <= (double)(iterDim.getWidth() * iterDim.getHeight()) / 2.0)) continue;
            picked = option;
        }
        return (ScreenSize)picked.getFirst();
    }

    private static void addEntry(ArrayList<Pair<ScreenSize, ScreenSize>> options, int slots, int width, int height) {
        int pages = class_3532.method_15384((double)((double)slots / (double)(width * height)));
        int blanked = slots - pages * width * height;
        options.add((Pair<ScreenSize, ScreenSize>)new Pair((Object)ScreenSize.of(width, height), (Object)ScreenSize.of(pages, blanked)));
    }

    protected void method_2389(class_4587 stack, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.textureLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_332.method_25290((class_4587)stack, (int)this.field_2776, (int)this.field_2800, (float)0.0f, (float)0.0f, (int)this.field_2792, (int)this.field_2779, (int)this.textureWidth, (int)this.textureHeight);
        this.blankArea.forEach(image -> image.render(stack));
    }

    private void initializeSlots(class_1661 playerInventory) {
        ((AbstractHandler)this.field_2797).resetSlotPositions(true, this.inventoryWidth, this.inventoryHeight);
        int playerInvLeft = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int playerInvTop = 32 + this.inventoryHeight * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.field_2797).addClientSlot(new class_1735((class_1263)playerInventory, y * 9 + x + 9, playerInvLeft + 18 * x, playerInvTop + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.field_2797).addClientSlot(new class_1735((class_1263)playerInventory, x, playerInvLeft + 18 * x, playerInvTop + 58));
        }
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.field_2792 - 176) / 2)) || mouseX > (double)(left + this.field_2792 - outsideRegion))) {
            return true;
        }
        return super.method_2381(mouseX, mouseY, left, top, button);
    }

    private void setPage(int oldPage, int newPage) {
        if (newPage == 0 || newPage > this.pages) {
            return;
        }
        this.page = newPage;
        if (newPage > oldPage) {
            if (this.page == this.pages) {
                this.rightPageButton.setActive(false);
                if (this.blankSlots > 0) {
                    int rows = class_3532.method_15346((int)this.blankSlots, (int)this.inventoryWidth);
                    int remainder = this.blankSlots - this.inventoryWidth * rows;
                    int yTop = this.field_2800 + 17 + (this.inventoryHeight - 1) * 18;
                    int xLeft = this.field_2776 + 7;
                    for (int i = 0; i < rows; ++i) {
                        this.blankArea.add(new TexturedRect(xLeft, yTop, this.inventoryWidth * 18, 18, 7, this.field_2779, this.textureWidth, this.textureHeight));
                        yTop -= 18;
                    }
                    if (remainder > 0) {
                        int xRight = this.field_2776 + 7 + this.inventoryWidth * 18;
                        int width = remainder * 18;
                        this.blankArea.add(new TexturedRect(xRight - width, yTop, width, 18, 7, this.field_2779, this.textureWidth, this.textureHeight));
                    }
                }
            }
            if (!this.leftPageButton.field_22763) {
                this.leftPageButton.setActive(true);
            }
        } else if (newPage < oldPage) {
            if (this.page == 1) {
                this.leftPageButton.setActive(false);
            }
            this.blankArea.clear();
            if (!this.rightPageButton.field_22763) {
                this.rightPageButton.setActive(true);
            }
        }
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        int oldMin = slotsPerPage * (oldPage - 1);
        int oldMax = Math.min(oldMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.field_2797).moveSlotRange(oldMin, oldMax, -2000);
        int newMin = slotsPerPage * (newPage - 1);
        int newMax = Math.min(newMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.field_2797).moveSlotRange(newMin, newMax, 2000);
        this.setPageText();
    }

    private void setPageText() {
        this.currentPageText = Utils.translation("screen.ellemes_container_lib.page_x_y", this.page, this.pages);
        this.pageTextX = (float)((this.leftPageButton.field_22760 + this.leftPageButton.method_25368() + this.rightPageButton.field_22760) / 2 - this.field_22793.method_27525((class_5348)this.currentPageText) / 2) + 0.5f;
    }

    protected void method_2380(class_4587 stack, int mouseX, int mouseY) {
        super.method_2380(stack, mouseX, mouseY);
        this.leftPageButton.renderButtonTooltip(stack, mouseX, mouseY);
        this.rightPageButton.renderButtonTooltip(stack, mouseX, mouseY);
    }

    public void method_25410(class_310 client, int width, int height) {
        int currentPage = this.page;
        if (currentPage != 1) {
            ((AbstractHandler)this.field_2797).resetSlotPositions(false, this.inventoryWidth, this.inventoryHeight);
            super.method_25410(client, width, height);
            this.blankArea.clear();
            this.setPage(1, currentPage);
            return;
        }
        super.method_25410(client, width, height);
    }

    protected void method_2388(class_4587 stack, int mouseX, int mouseY) {
        this.field_22793.method_30883(stack, this.field_22785, 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(stack, this.field_29347, 8.0f, (float)(this.field_2779 - 96 + 2), 0x404040);
        if (this.currentPageText != null) {
            this.field_22793.method_27528(stack, this.currentPageText.method_30937(), this.pageTextX - (float)this.field_2776, (float)(this.field_2779 - 94), 0x404040);
        }
    }

    @Override
    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 262 || keyCode == 267) {
            this.setPage(this.page, class_437.method_25442() ? this.pages : this.page + 1);
            return true;
        }
        if (keyCode == 263 || keyCode == 266) {
            this.setPage(this.page, class_437.method_25442() ? 1 : this.page - 1);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<class_768> getExclusionZones() {
        return Collections.emptyList();
    }

    public void addPageButtons() {
        int x;
        int width = 54;
        int originalX = x = this.field_2776 + this.field_2792 - 61;
        int y = this.field_2800 + this.field_2779 - 96;
        ArrayList<class_339> renderableChildren = new ArrayList<class_339>();
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof class_339)) continue;
            class_339 widget = (class_339)child;
            renderableChildren.add(widget);
        }
        renderableChildren.sort(Comparator.comparingInt(a -> -a.field_22760));
        for (class_339 widget : renderableChildren) {
            if (!PageScreen.regionIntersects(widget, x, y, width, 12)) continue;
            x = widget.field_22760 - width - 2;
        }
        this.page = 1;
        if (x == originalX && CommonClient.isModLoaded("inventoryprofiles")) {
            x -= 14;
        }
        this.leftPageButton = new PageButton(x, y, 0, (class_2561)Utils.translation("screen.ellemes_container_lib.prev_page", new Object[0]), button -> this.setPage(this.page, this.page - 1), this::renderButtonTooltip);
        this.leftPageButton.field_22763 = false;
        this.method_37063((class_364)this.leftPageButton);
        this.rightPageButton = new PageButton(x + 42, y, 1, (class_2561)Utils.translation("screen.ellemes_container_lib.next_page", new Object[0]), button -> this.setPage(this.page, this.page + 1), this::renderButtonTooltip);
        this.method_37063((class_364)this.rightPageButton);
        this.setPageText();
    }

    private void renderButtonTooltip(class_4264 button, class_4587 stack, int x, int y) {
        this.method_25424(stack, button.method_25369(), x, y);
    }
}

