/*
 * Decompiled with CFR 0.152.
 */
package ellemes.container_library;

import ellemes.container_library.Utils;
import ellemes.container_library.api.v3.OpenableInventoryProvider;
import ellemes.container_library.api.v3.client.ScreenOpeningApi;
import ellemes.container_library.api.v3.client.ScreenTypeApi;
import ellemes.container_library.client.KeyHandler;
import ellemes.container_library.client.gui.PageScreen;
import ellemes.container_library.client.gui.ScrollScreen;
import ellemes.container_library.client.gui.SingleScreen;
import ellemes.container_library.wrappers.ConfigWrapper;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2885;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import ninjaphenix.container_library.api.v2.OpenableBlockEntityProviderV2;

public class CommonClient {
    private static ConfigWrapper configWrapper;
    private static KeyHandler keyHandler;
    private static Function<String, Boolean> modLoadedFunction;

    public static void initialize(BiFunction<Path, Path, ConfigWrapper> configWrapperMaker, Path configPath, Path oldConfigPath, KeyHandler keyHandler, Function<String, Boolean> modLoadedFunction) {
        configWrapper = configWrapperMaker.apply(configPath, oldConfigPath);
        CommonClient.keyHandler = keyHandler;
        CommonClient.modLoadedFunction = modLoadedFunction;
        ScreenTypeApi.registerScreenButton(Utils.PAGE_SCREEN_TYPE, Utils.id("textures/gui/page_button.png"), (class_2561)Utils.translation("screen.ellemes_container_lib.page_screen", new Object[0]));
        ScreenTypeApi.registerScreenButton(Utils.SCROLL_SCREEN_TYPE, Utils.id("textures/gui/scroll_button.png"), (class_2561)Utils.translation("screen.ellemes_container_lib.scroll_screen", new Object[0]));
        ScreenTypeApi.registerScreenButton(Utils.SINGLE_SCREEN_TYPE, Utils.id("textures/gui/single_button.png"), (class_2561)Utils.translation("screen.ellemes_container_lib.single_screen", new Object[0]), (scaledWidth, scaledHeight) -> scaledWidth < 370 || scaledHeight < 386, List.of(Utils.translation("screen.ellemes_container_lib.off_screen_warning_1", new Object[0]).method_27692(class_124.field_1080), Utils.translation("screen.ellemes_container_lib.off_screen_warning_2", new Object[0]).method_27692(class_124.field_1080)));
        ScreenTypeApi.registerScreenType(Utils.PAGE_SCREEN_TYPE, PageScreen::new);
        ScreenTypeApi.registerScreenType(Utils.SCROLL_SCREEN_TYPE, ScrollScreen::new);
        ScreenTypeApi.registerScreenType(Utils.SINGLE_SCREEN_TYPE, SingleScreen::new);
        ScreenTypeApi.registerDefaultScreenSize(Utils.PAGE_SCREEN_TYPE, PageScreen::retrieveScreenSize);
        ScreenTypeApi.registerDefaultScreenSize(Utils.SCROLL_SCREEN_TYPE, ScrollScreen::retrieveScreenSize);
        ScreenTypeApi.registerDefaultScreenSize(Utils.SINGLE_SCREEN_TYPE, SingleScreen::retrieveScreenSize);
        ScreenTypeApi.setPrefersSingleScreen(Utils.PAGE_SCREEN_TYPE);
        ScreenTypeApi.setPrefersSingleScreen(Utils.SCROLL_SCREEN_TYPE);
    }

    public static ConfigWrapper getConfigWrapper() {
        return configWrapper;
    }

    public static boolean isConfigKeyPressed(int keyCode, int scanCode, int modifiers) {
        return keyHandler.isKeyPressed(keyCode, scanCode, modifiers);
    }

    public static boolean isModLoaded(String modId) {
        return modLoadedFunction.apply(modId);
    }

    public static boolean tryOpenSpectatorInventory(class_638 world, class_1657 player, class_239 hit, class_1268 hand) {
        if (player.method_7325()) {
            switch (hit.method_17783()) {
                case field_1332: {
                    class_3965 blockHit = (class_3965)hit;
                    class_2680 state = world.method_8320(blockHit.method_17777());
                    class_2248 block = state.method_26204();
                    if (block instanceof OpenableBlockEntityProviderV2) {
                        if (state.method_26174((class_1937)world, player, hand, blockHit) == class_1269.field_5812) {
                            class_310.method_1551().method_1562().method_2883((class_2596)new class_2885(hand, blockHit));
                        }
                        return true;
                    }
                    if (!(block instanceof OpenableInventoryProvider)) break;
                    ScreenOpeningApi.openBlockInventory(blockHit.method_17777());
                    return true;
                }
                case field_1331: {
                    class_1297 entity = ((class_3966)hit).method_17782();
                    if (!(entity instanceof OpenableInventoryProvider)) break;
                    ScreenOpeningApi.openEntityInventory(entity);
                    return true;
                }
            }
        }
        return false;
    }
}

