/*
 * Decompiled with CFR 0.152.
 */
package me.percydan.RandomTitle;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ConfigManager {
    private final Logger LOGGER = LogManager.getLogger((String)"RandomTitle");
    File configFile = new File("title.yml");
    Map<String, Object> config;
    Map<String, Object> defaultConfig;

    public ConfigManager() {
        this.LOGGER.info("RandomTitle by PercyDan https://github.com/PercyDan54/RandomTitle");
        this.defaultConfig = (Map)new Yaml().load(this.getClass().getResourceAsStream("/title.yml"));
        if (!this.configFile.exists()) {
            this.LOGGER.info("Config file not found, creating default");
            this.createDefault();
        }
        try {
            this.config = (Map)new Yaml().load(new FileInputStream(this.configFile));
        }
        catch (Exception e) {
            this.LOGGER.error("Failed to load config!", (Throwable)e);
            this.config = this.defaultConfig;
        }
    }

    public void createDefault() {
        InputStream inputStream = this.getClass().getResourceAsStream("/title.yml");
        try {
            if (!this.configFile.exists()) {
                int len;
                FileOutputStream outputStream = new FileOutputStream("title.yml");
                byte[] b = new byte[1024];
                while ((len = inputStream.read(b)) != -1) {
                    ((OutputStream)outputStream).write(b, 0, len);
                }
                ((OutputStream)outputStream).close();
            }
        }
        catch (Throwable e) {
            this.LOGGER.error("Failed to create default config!", e);
        }
    }

    public <T> T Get(String key) {
        Object value = this.config.get(key);
        if (value == null) {
            return (T)this.defaultConfig.get(key);
        }
        return (T)value;
    }

    private String getTitleFromList() {
        String title = "";
        try {
            List titles = (List)this.Get("title");
            title = (String)titles.get(new Random().nextInt(titles.size()));
        }
        catch (Throwable e) {
            this.LOGGER.error("Failed to get title from config!", e);
        }
        return title;
    }

    private String getTitleFromHitokoto() {
        String title;
        this.LOGGER.info("Getting title from Hitokoto API");
        try {
            String response = EntityUtils.toString((HttpEntity)HttpClients.createDefault().execute((HttpUriRequest)new HttpGet("https://v1.hitokoto.cn/")).getEntity());
            this.LOGGER.info("Hitokoto Response String: " + response);
            JsonObject json = new JsonParser().parse(response).getAsJsonObject();
            String from = json.get("from").getAsString();
            String sentence = json.get("hitokoto").getAsString();
            String type = json.get("type").getAsString();
            title = sentence + "   \u2014\u2014 ";
            switch (type) {
                case "e": {
                    title = title + json.get("creator").getAsString() + " \u539f\u521b";
                    break;
                }
                case "f": {
                    title = title + "\u6765\u81ea\u7f51\u7edc";
                    break;
                }
                default: {
                    title = title + from;
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.LOGGER.error("Failed to get title from API!", e);
            return this.getTitleFromList();
        }
        return title;
    }

    public String getTitle() {
        int mode = (Integer)this.Get("mode");
        switch (mode) {
            case 0: {
                return this.getTitleFromHitokoto();
            }
            case 1: {
                return this.getTitleFromList();
            }
            case 2: {
                boolean use = new Random().nextBoolean();
                if (use) {
                    return this.getTitleFromList();
                }
                return this.getTitleFromHitokoto();
            }
        }
        return this.getTitleFromList();
    }
}

