/*
 * Decompiled with CFR 0.152.
 */
package fireopal.profundis.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fireopal.profundis.Profundis;
import fireopal.profundis.gen.ProfundisCaveBiomes;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Config {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public String CONFIG_VERSION_DO_NOT_TOUCH_PLS = Profundis.VERSION.toString();
    public boolean logWhenLoaded = true;
    public boolean generateFrozenCaves = true;
    public boolean generateMushroomCaves = true;
    public boolean generateMoltenCaves = true;
    public Debug debug = new Debug();

    public static Config init() {
        Config config = null;
        try {
            Path configPath = Paths.get("config/profundis.json", new String[0]);
            if (Files.exists(configPath, new LinkOption[0])) {
                config = (Config)gson.fromJson((Reader)new FileReader(configPath.toFile()), Config.class);
                if (!config.CONFIG_VERSION_DO_NOT_TOUCH_PLS.equals(Profundis.VERSION.toString())) {
                    config.CONFIG_VERSION_DO_NOT_TOUCH_PLS = Profundis.VERSION.toString();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(configPath.toFile()));
                    writer.write(gson.toJson((Object)config));
                    writer.close();
                }
            } else {
                config = new Config();
                Paths.get("", "config").toFile().mkdirs();
                BufferedWriter writer = new BufferedWriter(new FileWriter(configPath.toFile()));
                writer.write(gson.toJson((Object)config));
                writer.close();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return config;
    }

    public static class Debug {
        public boolean enableMultinoiseCommand = false;
        public boolean logPlacements = false;
    }

    public static class Advanced {
        public String comment = "The following values control where the biomes appear. Do not touch unless you're an advanced user!";
        public List<ProfundisCaveBiomes.CaveBiome> caveBiomes = new ArrayList<ProfundisCaveBiomes.CaveBiome>();

        public Advanced() {
            this.caveBiomes.addAll((Collection<ProfundisCaveBiomes.CaveBiome>)ProfundisCaveBiomes.defaultCaveBiomes);
        }
    }
}

