/*
 * Decompiled with CFR 0.152.
 */
package fireopal.profundis.features.features;

import com.mojang.serialization.Codec;
import fireopal.profundis.features.features.config.NetherrackBaseFeatureConfig;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1945;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class NetherrackBaseFeature
extends class_3031<NetherrackBaseFeatureConfig> {
    private final class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public NetherrackBaseFeature(Codec<NetherrackBaseFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<NetherrackBaseFeatureConfig> context) {
        boolean bl;
        NetherrackBaseFeatureConfig config = (NetherrackBaseFeatureConfig)context.method_33656();
        class_2338 origin = context.method_33655();
        Random random = context.method_33654();
        class_5281 world = context.method_33652();
        int count = config.count().method_35008(random);
        int height = 3;
        int y = origin.method_10264();
        int radius = config.radius().method_35008(random);
        int minX = origin.method_10263() - radius;
        int maxX = origin.method_10263() + radius;
        int minZ = origin.method_10260() - radius;
        int maxZ = origin.method_10260() + radius;
        class_2680 topState = config.topState();
        class_2680 underState = config.underState();
        class_6885<class_2248> canPlaceThrough = config.canPlaceThrough();
        boolean sometimesUseUnderAsTop = config.sometimesUseUnderAsTop();
        boolean isContained = config.contained();
        boolean hasPlaced = false;
        for (class_2338 blockPos : class_2338.method_27156((Random)random, (int)count, (int)(origin.method_10263() - radius / 2), (int)y, (int)(origin.method_10260() - radius / 2), (int)(origin.method_10263() + radius / 2), (int)y, (int)(origin.method_10260() + radius / 2))) {
            bl = this.iterateOnce(blockPos, origin, radius, 3, topState, underState, canPlaceThrough, sometimesUseUnderAsTop, world, random, isContained);
            hasPlaced |= bl;
        }
        for (class_2338 blockPos : class_2338.method_27156((Random)random, (int)count, (int)minX, (int)y, (int)minZ, (int)maxX, (int)y, (int)maxZ)) {
            bl = this.iterateOnce(blockPos, origin, radius, 3, topState, underState, canPlaceThrough, sometimesUseUnderAsTop, world, random, isContained);
            hasPlaced |= bl;
        }
        return hasPlaced;
    }

    private boolean iterateOnce(class_2338 pos, class_2338 origin, int radius, int height, class_2680 topState, class_2680 underState, class_6885<class_2248> canPlaceThrough, boolean sometimesUseUnderAsTop, class_5281 world, Random random, boolean isContained) {
        boolean hasPlaced = false;
        if (!pos.method_19771((class_2382)origin, (double)radius)) {
            return false;
        }
        Optional<class_2338> posMatcher = this.adjustWorldPosition(pos, height, world);
        if (posMatcher.isPresent()) {
            hasPlaced = this.generatePillarGoingDown(radius, height, posMatcher.get(), origin, topState, underState, canPlaceThrough, world, isContained);
            for (class_2350 d : this.DIRECTIONS) {
                Optional<class_2338> posMatcher2 = this.adjustWorldPosition(posMatcher.get().method_10093(d), 1 + (int)Math.ceil((float)height / 3.0f), world);
                if (!posMatcher2.isPresent() || !((double)random.nextFloat() < Math.sqrt(posMatcher2.get().method_10262((class_2382)origin) / (double)radius))) continue;
                this.generatePillarGoingDown(radius, 1 + (height + 3) / 3, posMatcher2.get(), origin, sometimesUseUnderAsTop && random.nextBoolean() ? underState : topState, underState, canPlaceThrough, world, isContained);
            }
        }
        return hasPlaced;
    }

    private Optional<class_2338> adjustWorldPosition(class_2338 blockPos, int height, class_5281 world) {
        class_2338.class_2339 pos = blockPos.method_25503();
        if (world.method_22347((class_2338)pos)) {
            for (int i = 0; i < height; ++i) {
                if (world.method_8320((class_2338)pos).method_26225() && world.method_22347(pos.method_10084())) {
                    return Optional.of(pos.method_10062());
                }
                pos.method_10098(class_2350.field_11033);
            }
        } else {
            for (int i = 0; i < height; ++i) {
                if (world.method_8320((class_2338)pos).method_26225() && world.method_22347(pos.method_10084())) {
                    return Optional.of(pos.method_10062());
                }
                pos.method_10098(class_2350.field_11036);
            }
        }
        return Optional.empty();
    }

    private boolean generatePillarGoingDown(int maxRadius, int maxHeight, class_2338 target, class_2338 origin, class_2680 topState, class_2680 underState, class_6885<class_2248> canPlaceThrough, class_5281 world, boolean isContained) {
        double distanceToOrigin = Math.sqrt(target.method_10262((class_2382)origin));
        int height = maxHeight > 1 ? (int)Math.ceil((double)maxHeight * (distanceToOrigin / (double)maxRadius)) : 1;
        for (int i = 0; i < height; ++i) {
            class_2338 pos = target.method_10087(i);
            class_2680 stateAt = world.method_8320(pos);
            boolean bl = false;
            for (class_6880 r : canPlaceThrough) {
                if (!stateAt.method_27852((class_2248)r.comp_349())) continue;
                bl = true;
            }
            if (!bl) break;
            if (world.method_22347(pos.method_10084())) {
                this.attemptPlaceBlock(world, pos, topState, isContained);
                continue;
            }
            this.attemptPlaceBlock(world, pos, underState, isContained);
        }
        return height > 0;
    }

    private boolean attemptPlaceBlock(class_5281 world, class_2338 pos, class_2680 state, boolean contained) {
        if (contained) {
            for (class_2350 d : this.DIRECTIONS) {
                class_2680 over = world.method_8320(pos.method_10093(d));
                if (over.method_26225() || over.method_27852(state.method_26204())) continue;
                return false;
            }
            class_2680 over = world.method_8320(pos.method_10093(class_2350.field_11033));
            if (!over.method_26225() && !over.method_27852(state.method_26204())) {
                return false;
            }
        }
        this.method_13153((class_1945)world, pos, state);
        return true;
    }
}

