/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.fabric;

import ellemes.expandedstorage.common.block.BarrelBlock;
import ellemes.expandedstorage.common.misc.TagReloadListener;
import ellemes.expandedstorage.common.misc.Utils;
import ellemes.expandedstorage.common.registration.Content;
import ellemes.expandedstorage.common.registration.ContentConsumer;
import ellemes.expandedstorage.common.registration.NamedValue;
import ellemes.expandedstorage.thread.ThreadMain;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.slf4j.LoggerFactory;

public final class FabricMain
implements ModInitializer {
    public void onInitialize() {
        boolean isCarrierCompatEnabled;
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if (fabricLoader.isModLoaded("quilt_loader")) {
            LoggerFactory.getLogger((String)"expandedstorage").warn("Please use Expanded Storage for Quilt instead.");
            System.exit(0);
            return;
        }
        try {
            SemanticVersion version = SemanticVersion.parse((String)"1.8.0");
            isCarrierCompatEnabled = fabricLoader.getModContainer("carrier").map(it -> it.getMetadata().getVersion().compareTo((Object)version) > 0).orElse(false);
        }
        catch (VersionParsingException e) {
            throw new IllegalStateException("Author made a typo: ", e);
        }
        class_1761 group = FabricItemGroupBuilder.build((class_2960)Utils.id("tab"), () -> new class_1799((class_1935)class_2378.field_11142.method_10223(Utils.id("netherite_chest"))));
        boolean isClient = fabricLoader.getEnvironmentType() == EnvType.CLIENT;
        TagReloadListener tagReloadListener = new TagReloadListener();
        ThreadMain.constructContent(fabricLoader.isModLoaded("htm"), group, isClient, tagReloadListener, ((ContentConsumer)ThreadMain::registerContent).andThenIf(isCarrierCompatEnabled, ThreadMain::registerCarrierCompat).andThenIf(isClient, ThreadMain::registerClientStuff).andThenIf(isClient, this::registerBarrelRenderLayers));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> tagReloadListener.postDataReload());
    }

    private void registerBarrelRenderLayers(Content content) {
        for (NamedValue<BarrelBlock> block : content.getBarrelBlocks()) {
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)block.getValue(), class_1921.method_23579());
        }
    }
}

