/*
 * Decompiled with CFR 0.152.
 */
package ellemes.expandedstorage.common;

import com.mojang.datafixers.DSL;
import ellemes.expandedstorage.common.block.BarrelBlock;
import ellemes.expandedstorage.common.block.ChestBlock;
import ellemes.expandedstorage.common.block.MiniChestBlock;
import ellemes.expandedstorage.common.block.OpenableBlock;
import ellemes.expandedstorage.common.block.entity.BarrelBlockEntity;
import ellemes.expandedstorage.common.block.entity.ChestBlockEntity;
import ellemes.expandedstorage.common.block.entity.MiniChestBlockEntity;
import ellemes.expandedstorage.common.block.entity.OldChestBlockEntity;
import ellemes.expandedstorage.common.block.entity.extendable.OpenableBlockEntity;
import ellemes.expandedstorage.common.block.misc.DoubleItemAccess;
import ellemes.expandedstorage.common.block.strategies.ItemAccess;
import ellemes.expandedstorage.common.block.strategies.Lockable;
import ellemes.expandedstorage.common.client.MiniChestScreen;
import ellemes.expandedstorage.common.client.TextureCollection;
import ellemes.expandedstorage.common.entity.ChestMinecart;
import ellemes.expandedstorage.common.item.BlockUpgradeBehaviour;
import ellemes.expandedstorage.common.item.ChestMinecartItem;
import ellemes.expandedstorage.common.item.EntityUpgradeBehaviour;
import ellemes.expandedstorage.common.item.MutationMode;
import ellemes.expandedstorage.common.item.MutatorBehaviour;
import ellemes.expandedstorage.common.item.StorageConversionKit;
import ellemes.expandedstorage.common.item.StorageMutator;
import ellemes.expandedstorage.common.misc.Pair;
import ellemes.expandedstorage.common.misc.TagReloadListener;
import ellemes.expandedstorage.common.misc.Tier;
import ellemes.expandedstorage.common.misc.Utils;
import ellemes.expandedstorage.common.registration.Content;
import ellemes.expandedstorage.common.registration.ContentConsumer;
import ellemes.expandedstorage.common.registration.NamedValue;
import ellemes.expandedstorage.common.registration.ObjectConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1047;
import net.minecraft.class_1208;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3708;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import ninjaphenix.expandedstorage.block.AbstractChestBlock;
import ninjaphenix.expandedstorage.block.misc.CursedChestType;
import org.jetbrains.annotations.Nullable;

public final class CommonMain {
    public static final class_2960 BARREL_BLOCK_TYPE = Utils.id("barrel");
    public static final class_2960 CHEST_BLOCK_TYPE = Utils.id("chest");
    public static final class_2960 OLD_CHEST_BLOCK_TYPE = Utils.id("old_chest");
    public static final class_2960 MINI_CHEST_BLOCK_TYPE = Utils.id("mini_chest");
    private static final Map<Predicate<class_2248>, BlockUpgradeBehaviour> BLOCK_UPGRADE_BEHAVIOURS = new HashMap<Predicate<class_2248>, BlockUpgradeBehaviour>();
    private static final Map<Pair<Predicate<class_2248>, MutationMode>, MutatorBehaviour> MUTATOR_BEHAVIOURS = new HashMap<Pair<Predicate<class_2248>, MutationMode>, MutatorBehaviour>();
    private static final Map<Pair<class_2960, class_2960>, OpenableBlock> BLOCKS = new HashMap<Pair<class_2960, class_2960>, OpenableBlock>();
    private static final Map<class_2960, TextureCollection> CHEST_TEXTURES = new HashMap<class_2960, TextureCollection>();
    private static NamedValue<class_2591<ChestBlockEntity>> chestBlockEntityType;
    private static NamedValue<class_2591<OldChestBlockEntity>> oldChestBlockEntityType;
    private static NamedValue<class_2591<BarrelBlockEntity>> barrelBlockEntityType;
    private static NamedValue<class_2591<MiniChestBlockEntity>> miniChestBlockEntityType;
    private static Function<OpenableBlockEntity, ItemAccess> itemAccess;
    private static Supplier<Lockable> lockable;

    public static class_2591<ChestBlockEntity> getChestBlockEntityType() {
        return chestBlockEntityType.getValue();
    }

    public static class_2591<OldChestBlockEntity> getOldChestBlockEntityType() {
        return oldChestBlockEntityType.getValue();
    }

    public static class_2591<BarrelBlockEntity> getBarrelBlockEntityType() {
        return barrelBlockEntityType.getValue();
    }

    public static class_2591<MiniChestBlockEntity> getMiniChestBlockEntityType() {
        return miniChestBlockEntityType.getValue();
    }

    public static class_2960[] getChestTextures(List<class_2960> blocks) {
        class_2960[] textures = new class_2960[blocks.size() * CursedChestType.values().length];
        int index = 0;
        for (class_2960 blockId : blocks) {
            for (CursedChestType type : CursedChestType.values()) {
                textures[index++] = CommonMain.getChestTexture(blockId, type);
            }
        }
        return textures;
    }

    private static boolean upgradeSingleBlockToChest(class_1937 world, class_2680 state, class_2338 pos, class_2960 from, class_2960 to) {
        int inventorySize;
        class_2248 block = state.method_26204();
        boolean isExpandedStorageChest = block instanceof ChestBlock;
        int n = inventorySize = !isExpandedStorageChest ? 27 : CommonMain.getTieredBlock(CHEST_BLOCK_TYPE, ((OpenableBlock)block).getBlockTier()).getSlotCount();
        if (isExpandedStorageChest && ((OpenableBlock)block).getBlockTier() == from || !isExpandedStorageChest && from == Utils.WOOD_TIER_ID) {
            class_2499 items;
            class_1263 inventory;
            boolean verifiedSize;
            class_2586 blockEntity = world.method_8321(pos);
            class_2487 tag = blockEntity.method_38244();
            boolean bl = verifiedSize = blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity).method_5439() == inventorySize;
            if (!verifiedSize && tag.method_10573("Items", 9) && (items = tag.method_10554("Items", 10)).size() <= inventorySize) {
                verifiedSize = true;
            }
            if (verifiedSize) {
                ChestBlock toBlock = (ChestBlock)CommonMain.getTieredBlock(CHEST_BLOCK_TYPE, to);
                class_2371 inventory2 = class_2371.method_10213((int)toBlock.getSlotCount(), (Object)class_1799.field_8037);
                class_1273 code = class_1273.method_5473((class_2487)tag);
                class_1262.method_5429((class_2487)tag, (class_2371)inventory2);
                world.method_8544(pos);
                class_2680 newState = (class_2680)((class_2680)toBlock.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)));
                if (state.method_28498((class_2769)ChestBlock.CURSED_CHEST_TYPE)) {
                    newState = (class_2680)newState.method_11657((class_2769)ChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((CursedChestType)((Object)state.method_11654((class_2769)ChestBlock.CURSED_CHEST_TYPE)))));
                } else if (state.method_28498((class_2769)class_2741.field_12506)) {
                    class_2745 type = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
                    newState = (class_2680)newState.method_11657((class_2769)ChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)(type == class_2745.field_12574 ? CursedChestType.RIGHT : (type == class_2745.field_12571 ? CursedChestType.LEFT : CursedChestType.SINGLE))));
                }
                if (world.method_8501(pos, newState)) {
                    class_2586 newEntity = world.method_8321(pos);
                    class_2487 newTag = newEntity.method_38244();
                    class_1262.method_5426((class_2487)newTag, (class_2371)inventory2);
                    code.method_5474(newTag);
                    newEntity.method_11014(newTag);
                    return true;
                }
                world.method_8438(blockEntity);
            }
        }
        return false;
    }

    private static boolean upgradeSingleBlockToOldChest(class_1937 world, class_2680 state, class_2338 pos, class_2960 from, class_2960 to) {
        if (((OpenableBlock)state.method_26204()).getBlockTier() == from) {
            AbstractChestBlock toBlock = (AbstractChestBlock)CommonMain.getTieredBlock(OLD_CHEST_BLOCK_TYPE, to);
            class_2371 inventory = class_2371.method_10213((int)toBlock.getSlotCount(), (Object)class_1799.field_8037);
            class_2586 blockEntity = world.method_8321(pos);
            class_2487 tag = blockEntity.method_38244();
            class_1273 code = class_1273.method_5473((class_2487)tag);
            class_1262.method_5429((class_2487)tag, (class_2371)inventory);
            world.method_8544(pos);
            class_2680 newState = (class_2680)((class_2680)toBlock.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((CursedChestType)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))));
            if (world.method_8501(pos, newState)) {
                class_2586 newEntity = world.method_8321(pos);
                class_2487 newTag = newEntity.method_38244();
                class_1262.method_5426((class_2487)newTag, (class_2371)inventory);
                code.method_5474(newTag);
                newEntity.method_11014(newTag);
                return true;
            }
            world.method_8438(blockEntity);
        }
        return false;
    }

    private static void defineTierUpgradePath(List<NamedValue<class_1792>> items, boolean wrapTooltipManually, class_1761 group, Tier ... tiers) {
        int numTiers = tiers.length;
        for (int fromIndex = 0; fromIndex < numTiers - 1; ++fromIndex) {
            Tier fromTier = tiers[fromIndex];
            for (int toIndex = fromIndex + 1; toIndex < numTiers; ++toIndex) {
                Tier toTier = tiers[toIndex];
                class_2960 itemId = Utils.id(fromTier.getId().method_12832() + "_to_" + toTier.getId().method_12832() + "_conversion_kit");
                class_1792.class_1793 settings = (class_1792.class_1793)fromTier.getItemSettings().andThen(toTier.getItemSettings()).apply(new class_1792.class_1793().method_7892(group).method_7889(16));
                items.add(new NamedValue<class_1792>(itemId, () -> new StorageConversionKit(settings, fromTier.getId(), toTier.getId(), wrapTooltipManually)));
            }
        }
    }

    public static BlockUpgradeBehaviour getBlockUpgradeBehaviour(class_2248 block) {
        for (Map.Entry<Predicate<class_2248>, BlockUpgradeBehaviour> entry : BLOCK_UPGRADE_BEHAVIOURS.entrySet()) {
            if (!entry.getKey().test(block)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static void defineBlockUpgradeBehaviour(Predicate<class_2248> target, BlockUpgradeBehaviour behaviour) {
        BLOCK_UPGRADE_BEHAVIOURS.put(target, behaviour);
    }

    public static void registerTieredBlock(OpenableBlock block) {
        BLOCKS.putIfAbsent(new Pair<class_2960, class_2960>(block.getBlockType(), block.getBlockTier()), block);
    }

    public static OpenableBlock getTieredBlock(class_2960 blockType, class_2960 tier) {
        return BLOCKS.get(new Pair<class_2960, class_2960>(blockType, tier));
    }

    public static void declareChestTextures(class_2960 block, class_2960 singleTexture, class_2960 leftTexture, class_2960 rightTexture, class_2960 topTexture, class_2960 bottomTexture, class_2960 frontTexture, class_2960 backTexture) {
        if (CHEST_TEXTURES.containsKey(block)) {
            throw new IllegalArgumentException("Tried registering chest textures for \"" + block + "\" which already has textures.");
        }
        TextureCollection collection = new TextureCollection(singleTexture, leftTexture, rightTexture, topTexture, bottomTexture, frontTexture, backTexture);
        CHEST_TEXTURES.put(block, collection);
    }

    public static class_2960 getChestTexture(class_2960 block, CursedChestType chestType) {
        if (CHEST_TEXTURES.containsKey(block)) {
            return CHEST_TEXTURES.get(block).getTexture(chestType);
        }
        return class_1047.method_4539();
    }

    private static void registerMutationBehaviour(Predicate<class_2248> predicate, MutationMode mode, MutatorBehaviour behaviour) {
        MUTATOR_BEHAVIOURS.put(new Pair<Predicate<class_2248>, MutationMode>(predicate, mode), behaviour);
    }

    public static MutatorBehaviour getMutatorBehaviour(class_2248 block, MutationMode mode) {
        for (Map.Entry<Pair<Predicate<class_2248>, MutationMode>, MutatorBehaviour> entry : MUTATOR_BEHAVIOURS.entrySet()) {
            Pair<Predicate<class_2248>, MutationMode> pair = entry.getKey();
            if (pair.getSecond() != mode || !pair.getFirst().test(block)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void constructContent(Function<OpenableBlockEntity, ItemAccess> itemAccess, Supplier<Lockable> lockable, class_1761 group, boolean isClient, TagReloadListener tagReloadListener, ContentConsumer contentRegistrationConsumer, boolean manuallyWrapTooltips, class_6862<class_2248> chestTag, BiFunction<ChestBlock, class_1792.class_1793, class_1747> chestItemMaker, Function<OpenableBlockEntity, ItemAccess> chestAccessMaker, class_6862<class_2248> barrelTag, BiFunction<MiniChestBlock, class_1792.class_1793, class_1747> miniChestItemMaker) {
        CommonMain.itemAccess = itemAccess;
        CommonMain.lockable = lockable;
        Tier woodTier = new Tier(Utils.WOOD_TIER_ID, 27, UnaryOperator.identity(), UnaryOperator.identity());
        Tier ironTier = new Tier(Utils.id("iron"), 54, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier goldTier = new Tier(Utils.id("gold"), 81, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier diamondTier = new Tier(Utils.id("diamond"), 108, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier obsidianTier = new Tier(Utils.id("obsidian"), 108, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier netheriteTier = new Tier(Utils.id("netherite"), 135, class_4970.class_2251::method_29292, class_1792.class_1793::method_24359);
        class_4970.class_2251 woodSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_15996).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 pumpkinSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15954, (class_3620)class_3620.field_15987).method_9632(1.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 bambooSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15946, (class_3620)class_3620.field_16004).method_9632(1.0f).method_9626(class_2498.field_11542);
        class_4970.class_2251 ironSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_16005).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 goldSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15994).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 diamondSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15983).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 obsidianSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15914, (class_3620)class_3620.field_16009).method_9629(50.0f, 1200.0f);
        class_4970.class_2251 netheriteSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_16009).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_22150);
        ArrayList<class_2960> stats = new ArrayList<class_2960>();
        Function<String, class_2960> statMaker = id -> {
            class_2960 statId = Utils.id(id);
            stats.add(statId);
            return statId;
        };
        ArrayList<NamedValue<class_1792>> baseItems = new ArrayList<NamedValue<class_1792>>(16);
        baseItems.add(new NamedValue<class_1792>(Utils.id("storage_mutator"), () -> new StorageMutator(new class_1792.class_1793().method_7889(1).method_7892(group))));
        CommonMain.defineTierUpgradePath(baseItems, manuallyWrapTooltips, group, woodTier, ironTier, goldTier, diamondTier, obsidianTier, netheriteTier);
        ArrayList<NamedValue<ChestBlock>> chestBlocks = new ArrayList<NamedValue<ChestBlock>>(9);
        ArrayList<NamedValue<class_1747>> chestItems = new ArrayList<NamedValue<class_1747>>(9);
        ArrayList<NamedValue<class_1299<ChestMinecart>>> chestMinecartEntityTypes = new ArrayList<NamedValue<class_1299<ChestMinecart>>>(9);
        ArrayList<NamedValue<ChestMinecartItem>> chestMinecartItems = new ArrayList<NamedValue<ChestMinecartItem>>(9);
        class_2960 woodStat = statMaker.apply("open_wood_chest");
        class_2960 pumpkinStat = statMaker.apply("open_pumpkin_chest");
        class_2960 presentStat = statMaker.apply("open_present");
        class_2960 bambooStat = statMaker.apply("open_bamboo_chest");
        class_2960 ironStat = statMaker.apply("open_iron_chest");
        class_2960 goldStat = statMaker.apply("open_gold_chest");
        class_2960 diamondStat = statMaker.apply("open_diamond_chest");
        class_2960 obsidianStat = statMaker.apply("open_obsidian_chest");
        class_2960 netheriteStat = statMaker.apply("open_netherite_chest");
        class_4970.class_2251 presentSettings = class_4970.class_2251.method_26240((class_3614)class_3614.field_15932, state -> {
            CursedChestType type = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
            if (type == CursedChestType.SINGLE) {
                return class_3620.field_16020;
            }
            if (type == CursedChestType.FRONT || type == CursedChestType.BACK) {
                return class_3620.field_16004;
            }
            return class_3620.field_16022;
        }).method_9632(2.5f).method_9626(class_2498.field_11547);
        ObjectConsumer chestMaker = (id, stat, tier, settings) -> {
            NamedValue<ChestBlock> block = new NamedValue<ChestBlock>(id, () -> new ChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), id, tier.getId(), stat, tier.getSlotCount()));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> (class_1747)chestItemMaker.apply((ChestBlock)((Object)((Object)((Object)block.getValue()))), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793().method_7892(group))));
            class_2960 cartId = new class_2960(id.method_12836(), id.method_12832() + "_minecart");
            NamedValue<ChestMinecartItem> cartItem = new NamedValue<ChestMinecartItem>(cartId, () -> new ChestMinecartItem(new class_1792.class_1793().method_7892(group), cartId));
            NamedValue<class_1299> cartEntityType = new NamedValue<class_1299>(cartId, () -> class_1299.class_1300.method_5903((type, level) -> new ChestMinecart(type, level, (class_1792)item.getValue(), (ChestBlock)((Object)((Object)((Object)((Object)block.getValue()))))), (class_1311)class_1311.field_17715).method_17687(0.98f, 0.7f).method_27299(8).method_5905(cartId.method_12832()));
            chestBlocks.add(block);
            chestItems.add(item);
            chestMinecartEntityTypes.add(cartEntityType);
            chestMinecartItems.add(cartItem);
        };
        chestMaker.apply(Utils.id("wood_chest"), woodStat, woodTier, woodSettings);
        chestMaker.apply(Utils.id("pumpkin_chest"), pumpkinStat, woodTier, pumpkinSettings);
        chestMaker.apply(Utils.id("present"), presentStat, woodTier, presentSettings);
        chestMaker.apply(Utils.id("bamboo_chest"), bambooStat, woodTier, bambooSettings);
        chestMaker.apply(Utils.id("iron_chest"), ironStat, ironTier, ironSettings);
        chestMaker.apply(Utils.id("gold_chest"), goldStat, goldTier, goldSettings);
        chestMaker.apply(Utils.id("diamond_chest"), diamondStat, diamondTier, diamondSettings);
        chestMaker.apply(Utils.id("obsidian_chest"), obsidianStat, obsidianTier, obsidianSettings);
        chestMaker.apply(Utils.id("netherite_chest"), netheriteStat, netheriteTier, netheriteSettings);
        if (isClient) {
            chestBlocks.forEach(block -> {
                String blockId = block.getName().method_12832();
                CommonMain.declareChestTextures(block.getName(), Utils.id("entity/" + blockId + "/single"), Utils.id("entity/" + blockId + "/left"), Utils.id("entity/" + blockId + "/right"), Utils.id("entity/" + blockId + "/top"), Utils.id("entity/" + blockId + "/bottom"), Utils.id("entity/" + blockId + "/front"), Utils.id("entity/" + blockId + "/back"));
            });
        }
        chestBlockEntityType = new NamedValue<class_2591>(CHEST_BLOCK_TYPE, () -> class_2591.class_2592.method_20528((pos, state) -> new ChestBlockEntity(CommonMain.getChestBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), chestAccessMaker, lockable), (class_2248[])((class_2248[])chestBlocks.stream().map(NamedValue::getValue).toArray(ChestBlock[]::new))).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)CHEST_BLOCK_TYPE.toString())));
        Predicate<class_2248> isUpgradableChestBlock = block -> block instanceof ChestBlock || block instanceof class_2281 || block.method_9564().method_26164(chestTag);
        CommonMain.defineBlockUpgradeBehaviour(isUpgradableChestBlock, (context, from, to) -> {
            class_1937 world = context.method_8045();
            class_2338 pos = context.method_8037();
            class_2680 state = world.method_8320(pos);
            class_1657 player = context.method_8036();
            class_1799 handStack = context.method_8041();
            if (state.method_26204() instanceof ChestBlock) {
                CursedChestType type = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
                if (AbstractChestBlock.getBlockType(type) == class_4732.class_4733.field_21783) {
                    boolean upgradeSucceeded = CommonMain.upgradeSingleBlockToChest(world, state, pos, from, to);
                    if (upgradeSucceeded) {
                        handStack.method_7934(1);
                    }
                    return upgradeSucceeded;
                }
                if (handStack.method_7947() > 1 || player != null && player.method_7337()) {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(type, facing));
                    class_2680 otherState = world.method_8320(otherPos);
                    boolean firstSucceeded = CommonMain.upgradeSingleBlockToChest(world, state, pos, from, to);
                    boolean secondSucceeded = CommonMain.upgradeSingleBlockToChest(world, otherState, otherPos, from, to);
                    if (firstSucceeded && secondSucceeded) {
                        handStack.method_7934(2);
                    } else if (firstSucceeded || secondSucceeded) {
                        handStack.method_7934(1);
                    }
                    return firstSucceeded || secondSucceeded;
                }
            } else {
                if (class_2281.method_24169((class_2680)state) == class_4732.class_4733.field_21783) {
                    boolean upgradeSucceeded = CommonMain.upgradeSingleBlockToChest(world, state, pos, from, to);
                    if (upgradeSucceeded) {
                        handStack.method_7934(1);
                    }
                    return upgradeSucceeded;
                }
                if (handStack.method_7947() > 1 || player != null && player.method_7337()) {
                    class_2338 otherPos = pos.method_10093(class_2281.method_9758((class_2680)state));
                    class_2680 otherState = world.method_8320(otherPos);
                    boolean firstSucceeded = CommonMain.upgradeSingleBlockToChest(world, state, pos, from, to);
                    boolean secondSucceeded = CommonMain.upgradeSingleBlockToChest(world, otherState, otherPos, from, to);
                    if (firstSucceeded && secondSucceeded) {
                        handStack.method_7934(2);
                    } else if (firstSucceeded || secondSucceeded) {
                        handStack.method_7934(1);
                    }
                    return firstSucceeded || secondSucceeded;
                }
            }
            return false;
        });
        CommonMain.registerMutationBehaviour(b -> b instanceof ChestBlock, MutationMode.SWAP_THEME, (context, world, state, pos, stack) -> {
            List<class_2248> blocks = tagReloadListener.getChestCycleBlocks();
            int index = blocks.indexOf(state.method_26204());
            if (index != -1) {
                class_2248 next = blocks.get((index + 1) % blocks.size());
                CursedChestType chestType = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
                if (chestType != CursedChestType.SINGLE) {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                    class_2680 otherState = world.method_8320(otherPos);
                    world.method_8652(otherPos, (class_2680)((class_2680)((class_2680)next.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)otherState.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)otherState.method_11654((class_2769)class_2741.field_12508)))).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType.getOpposite())), 129);
                }
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)next.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)))).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType)), 129);
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
        ArrayList<NamedValue<AbstractChestBlock>> oldChestBlocks = new ArrayList<NamedValue<AbstractChestBlock>>(6);
        ArrayList<NamedValue<class_1747>> oldChestItems = new ArrayList<NamedValue<class_1747>>(6);
        class_2960 woodStat2 = statMaker.apply("open_old_wood_chest");
        class_2960 ironStat2 = statMaker.apply("open_old_iron_chest");
        class_2960 goldStat2 = statMaker.apply("open_old_gold_chest");
        class_2960 diamondStat2 = statMaker.apply("open_old_diamond_chest");
        class_2960 obsidianStat2 = statMaker.apply("open_old_obsidian_chest");
        class_2960 netheriteStat2 = statMaker.apply("open_old_netherite_chest");
        ObjectConsumer chestMaker2 = (id, stat, tier, settings) -> {
            NamedValue<AbstractChestBlock> block = new NamedValue<AbstractChestBlock>(id, () -> new AbstractChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), id, tier.getId(), stat, tier.getSlotCount()));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> new class_1747((class_2248)block.getValue(), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793().method_7892(group))));
            oldChestBlocks.add(block);
            oldChestItems.add(item);
        };
        chestMaker2.apply(Utils.id("old_wood_chest"), woodStat2, woodTier, woodSettings);
        chestMaker2.apply(Utils.id("old_iron_chest"), ironStat2, ironTier, ironSettings);
        chestMaker2.apply(Utils.id("old_gold_chest"), goldStat2, goldTier, goldSettings);
        chestMaker2.apply(Utils.id("old_diamond_chest"), diamondStat2, diamondTier, diamondSettings);
        chestMaker2.apply(Utils.id("old_obsidian_chest"), obsidianStat2, obsidianTier, obsidianSettings);
        chestMaker2.apply(Utils.id("old_netherite_chest"), netheriteStat2, netheriteTier, netheriteSettings);
        oldChestBlockEntityType = new NamedValue<class_2591>(OLD_CHEST_BLOCK_TYPE, () -> class_2591.class_2592.method_20528((pos, state) -> new OldChestBlockEntity(CommonMain.getOldChestBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), chestAccessMaker, lockable), (class_2248[])((class_2248[])oldChestBlocks.stream().map(NamedValue::getValue).toArray(AbstractChestBlock[]::new))).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)OLD_CHEST_BLOCK_TYPE.toString())));
        Predicate<class_2248> isUpgradableOldChestBlock = block -> block.getClass() == AbstractChestBlock.class;
        CommonMain.defineBlockUpgradeBehaviour(isUpgradableOldChestBlock, (context, from, to) -> {
            class_1937 world = context.method_8045();
            class_2338 pos = context.method_8037();
            class_2680 state = world.method_8320(pos);
            class_1657 player = context.method_8036();
            class_1799 handStack = context.method_8041();
            if (AbstractChestBlock.getBlockType((CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))) == class_4732.class_4733.field_21783) {
                boolean upgradeSucceeded = CommonMain.upgradeSingleBlockToOldChest(world, state, pos, from, to);
                if (upgradeSucceeded) {
                    handStack.method_7934(1);
                }
                return upgradeSucceeded;
            }
            if (handStack.method_7947() > 1 || player != null && player.method_7337()) {
                class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                class_2680 otherState = world.method_8320(otherPos);
                boolean firstSucceeded = CommonMain.upgradeSingleBlockToOldChest(world, state, pos, from, to);
                boolean secondSucceeded = CommonMain.upgradeSingleBlockToOldChest(world, otherState, otherPos, from, to);
                if (firstSucceeded && secondSucceeded) {
                    handStack.method_7934(2);
                } else if (firstSucceeded || secondSucceeded) {
                    handStack.method_7934(1);
                }
                return firstSucceeded || secondSucceeded;
            }
            return false;
        });
        Predicate<class_2248> isChestBlock = b -> b instanceof AbstractChestBlock;
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.MERGE, (context, world, state, pos, stack) -> {
            class_1657 player = context.method_8036();
            if (state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) == CursedChestType.SINGLE) {
                class_2487 tag = stack.method_7948();
                if (tag.method_10545("pos")) {
                    class_2338 otherPos = class_2512.method_10691((class_2487)tag.method_10562("pos"));
                    class_2680 otherState = world.method_8320(otherPos);
                    class_2350 direction = class_2350.method_35832((class_2338)otherPos.method_10059((class_2382)pos));
                    if (direction != null) {
                        if (state.method_26204() == otherState.method_26204()) {
                            if (otherState.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) == CursedChestType.SINGLE) {
                                if (state.method_11654((class_2769)class_2741.field_12481) == otherState.method_11654((class_2769)class_2741.field_12481)) {
                                    if (!world.method_8608()) {
                                        CursedChestType chestType = AbstractChestBlock.getChestType((class_2350)state.method_11654((class_2769)class_2741.field_12481), direction);
                                        world.method_8501(pos, (class_2680)state.method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType)));
                                        tag.method_10551("pos");
                                        player.method_7353((class_2561)Utils.translation("tooltip.expandedstorage.storage_mutator.merge_end", new Object[0]), true);
                                    }
                                    return class_1269.field_5812;
                                }
                                player.method_7353((class_2561)Utils.translation("tooltip.expandedstorage.storage_mutator.merge_wrong_facing", new Object[0]), true);
                            } else {
                                player.method_7353((class_2561)Utils.translation("tooltip.expandedstorage.storage_mutator.merge_already_double_chest", new Object[0]), true);
                            }
                        } else {
                            player.method_7353((class_2561)Utils.translation("tooltip.expandedstorage.storage_mutator.merge_wrong_block", new Object[0]), true);
                        }
                    } else {
                        player.method_7353((class_2561)Utils.translation("tooltip.expandedstorage.storage_mutator.merge_not_adjacent", new Object[0]), true);
                    }
                } else {
                    if (!world.method_8608()) {
                        tag.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)pos));
                        player.method_7353((class_2561)Utils.translation("tooltip.expandedstorage.storage_mutator.merge_start", Utils.ALT_USE), true);
                    }
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5814;
        });
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.SPLIT, (context, world, state, pos, stack) -> {
            if (state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) != CursedChestType.SINGLE) {
                if (!world.method_8608()) {
                    world.method_8501(pos, (class_2680)state.method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)CursedChestType.SINGLE)));
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.ROTATE, (context, world, state, pos, stack) -> {
            if (!world.method_8608()) {
                CursedChestType chestType = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
                if (chestType == CursedChestType.SINGLE) {
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                } else {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                    class_2680 otherState = world.method_8320(otherPos);
                    if (chestType == CursedChestType.TOP || chestType == CursedChestType.BOTTOM) {
                        world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                        world.method_8501(otherPos, (class_2680)otherState.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                    } else {
                        world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153())).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))).getOpposite())));
                        world.method_8501(otherPos, (class_2680)((class_2680)otherState.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153())).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((CursedChestType)((Object)((Object)otherState.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))).getOpposite())));
                    }
                }
            }
            return class_1269.field_5812;
        });
        CommonMain.registerMutationBehaviour(b -> b instanceof ChestBlock, MutationMode.SWAP_THEME, (context, world, state, pos, stack) -> {
            List<class_2248> blocks = tagReloadListener.getChestCycleBlocks();
            int index = blocks.indexOf(state.method_26204());
            if (index != -1) {
                class_2248 next = blocks.get((index + 1) % blocks.size());
                CursedChestType chestType = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
                if (chestType != CursedChestType.SINGLE) {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                    class_2680 otherState = world.method_8320(otherPos);
                    world.method_8652(otherPos, (class_2680)((class_2680)((class_2680)next.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)otherState.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)otherState.method_11654((class_2769)class_2741.field_12508)))).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType.getOpposite())), 129);
                }
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)next.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)))).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType)), 129);
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
        ArrayList<NamedValue<BarrelBlock>> barrelBlocks = new ArrayList<NamedValue<BarrelBlock>>(5);
        ArrayList<NamedValue<class_1747>> barrelItems = new ArrayList<NamedValue<class_1747>>(5);
        ironStat = statMaker.apply("open_iron_barrel");
        goldStat = statMaker.apply("open_gold_barrel");
        diamondStat = statMaker.apply("open_diamond_barrel");
        obsidianStat = statMaker.apply("open_obsidian_barrel");
        netheriteStat = statMaker.apply("open_netherite_barrel");
        class_4970.class_2251 ironBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 goldBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 diamondBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 obsidianBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 netheriteBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_11547);
        ObjectConsumer barrelMaker = (id, stat, tier, settings) -> {
            NamedValue<BarrelBlock> block = new NamedValue<BarrelBlock>(id, () -> new BarrelBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), id, tier.getId(), stat, tier.getSlotCount()));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> new class_1747((class_2248)block.getValue(), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793().method_7892(group))));
            barrelBlocks.add(block);
            barrelItems.add(item);
        };
        barrelMaker.apply(Utils.id("iron_barrel"), ironStat, ironTier, ironBarrelSettings);
        barrelMaker.apply(Utils.id("gold_barrel"), goldStat, goldTier, goldBarrelSettings);
        barrelMaker.apply(Utils.id("diamond_barrel"), diamondStat, diamondTier, diamondBarrelSettings);
        barrelMaker.apply(Utils.id("obsidian_barrel"), obsidianStat, obsidianTier, obsidianBarrelSettings);
        barrelMaker.apply(Utils.id("netherite_barrel"), netheriteStat, netheriteTier, netheriteBarrelSettings);
        barrelBlockEntityType = new NamedValue<class_2591>(BARREL_BLOCK_TYPE, () -> class_2591.class_2592.method_20528((pos, state) -> new BarrelBlockEntity(CommonMain.getBarrelBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), itemAccess, lockable), (class_2248[])((class_2248[])barrelBlocks.stream().map(NamedValue::getValue).toArray(BarrelBlock[]::new))).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)BARREL_BLOCK_TYPE.toString())));
        Predicate<class_2248> isUpgradableBarrelBlock = block -> block instanceof BarrelBlock || block instanceof class_3708 || block.method_9564().method_26164(barrelTag);
        CommonMain.defineBlockUpgradeBehaviour(isUpgradableBarrelBlock, (context, from, to) -> {
            int inventorySize;
            class_2338 pos;
            class_1937 world = context.method_8045();
            class_2680 state = world.method_8320(pos = context.method_8037());
            class_2248 block = state.method_26204();
            boolean isExpandedStorageBarrel = block instanceof BarrelBlock;
            int n = inventorySize = !isExpandedStorageBarrel ? 27 : CommonMain.getTieredBlock(BARREL_BLOCK_TYPE, ((OpenableBlock)block).getBlockTier()).getSlotCount();
            if (isExpandedStorageBarrel && ((OpenableBlock)block).getBlockTier() == from || !isExpandedStorageBarrel && from == Utils.WOOD_TIER_ID) {
                class_2499 items;
                class_1263 inventory;
                boolean verifiedSize;
                class_2586 blockEntity = world.method_8321(pos);
                class_2487 tag = blockEntity.method_38244();
                boolean bl = verifiedSize = blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity).method_5439() == inventorySize;
                if (!verifiedSize && tag.method_10573("Items", 9) && (items = tag.method_10554("Items", 10)).size() <= inventorySize) {
                    verifiedSize = true;
                }
                if (verifiedSize) {
                    OpenableBlock toBlock = CommonMain.getTieredBlock(BARREL_BLOCK_TYPE, to);
                    class_2371 inventory2 = class_2371.method_10213((int)toBlock.getSlotCount(), (Object)class_1799.field_8037);
                    class_1273 code = class_1273.method_5473((class_2487)tag);
                    class_1262.method_5429((class_2487)tag, (class_2371)inventory2);
                    world.method_8544(pos);
                    class_2680 newState = (class_2680)toBlock.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
                    if (world.method_8501(pos, newState)) {
                        class_2586 newEntity = world.method_8321(pos);
                        class_2487 newTag = newEntity.method_38244();
                        class_1262.method_5426((class_2487)newTag, (class_2371)inventory2);
                        code.method_5474(newTag);
                        newEntity.method_11014(newTag);
                        context.method_8041().method_7934(1);
                        return true;
                    }
                    world.method_8438(blockEntity);
                }
            }
            return false;
        });
        CommonMain.registerMutationBehaviour(isUpgradableBarrelBlock, MutationMode.ROTATE, (context, world, state, pos, stack) -> {
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                if (!world.method_8608()) {
                    world.method_8501(pos, (class_2680)state.method_28493((class_2769)class_2741.field_12525));
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
        ArrayList<NamedValue<MiniChestBlock>> miniChestBlocks = new ArrayList<NamedValue<MiniChestBlock>>();
        ArrayList<NamedValue<class_1747>> miniChestItems = new ArrayList<NamedValue<class_1747>>();
        class_2960 woodStat3 = statMaker.apply("open_wood_mini_chest");
        class_2960 pumpkinStat2 = statMaker.apply("open_pumpkin_mini_chest");
        class_2960 redPresentStat = statMaker.apply("open_red_mini_present");
        class_2960 whitePresentStat = statMaker.apply("open_white_mini_present");
        class_2960 candyCanePresentStat = statMaker.apply("open_candy_cane_mini_present");
        class_2960 greenPresentStat = statMaker.apply("open_green_mini_present");
        class_2960 lavenderPresentStat = statMaker.apply("open_lavender_mini_present");
        class_2960 pinkAmethystPresentStat = statMaker.apply("open_pink_amethyst_mini_present");
        class_4970.class_2251 redPresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16020).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 whitePresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16022).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 candyCanePresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16022).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 greenPresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16004).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 lavenderPresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16014).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 pinkAmethystPresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16014).method_9632(2.5f).method_9626(class_2498.field_11547);
        ObjectConsumer chestMaker3 = (id, stat, tier, settings) -> {
            NamedValue<MiniChestBlock> block = new NamedValue<MiniChestBlock>(id, () -> new MiniChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), id, stat));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> (class_1747)miniChestItemMaker.apply((MiniChestBlock)((Object)((Object)((Object)block.getValue()))), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793().method_7892(group))));
            miniChestBlocks.add(block);
            miniChestItems.add(item);
        };
        chestMaker3.apply(Utils.id("vanilla_wood_mini_chest"), woodStat3, woodTier, woodSettings);
        chestMaker3.apply(Utils.id("wood_mini_chest"), woodStat3, woodTier, woodSettings);
        chestMaker3.apply(Utils.id("pumpkin_mini_chest"), pumpkinStat2, woodTier, pumpkinSettings);
        chestMaker3.apply(Utils.id("red_mini_present"), redPresentStat, woodTier, redPresentSettings);
        chestMaker3.apply(Utils.id("white_mini_present"), whitePresentStat, woodTier, whitePresentSettings);
        chestMaker3.apply(Utils.id("candy_cane_mini_present"), candyCanePresentStat, woodTier, candyCanePresentSettings);
        chestMaker3.apply(Utils.id("green_mini_present"), greenPresentStat, woodTier, greenPresentSettings);
        chestMaker3.apply(Utils.id("lavender_mini_present"), lavenderPresentStat, woodTier, lavenderPresentSettings);
        chestMaker3.apply(Utils.id("pink_amethyst_mini_present"), pinkAmethystPresentStat, woodTier, pinkAmethystPresentSettings);
        chestMaker3.apply(Utils.id("vanilla_wood_mini_chest_with_sparrow"), woodStat3, woodTier, woodSettings);
        chestMaker3.apply(Utils.id("wood_mini_chest_with_sparrow"), woodStat3, woodTier, woodSettings);
        chestMaker3.apply(Utils.id("pumpkin_mini_chest_with_sparrow"), pumpkinStat2, woodTier, pumpkinSettings);
        chestMaker3.apply(Utils.id("red_mini_present_with_sparrow"), redPresentStat, woodTier, redPresentSettings);
        chestMaker3.apply(Utils.id("white_mini_present_with_sparrow"), whitePresentStat, woodTier, whitePresentSettings);
        chestMaker3.apply(Utils.id("candy_cane_mini_present_with_sparrow"), candyCanePresentStat, woodTier, candyCanePresentSettings);
        chestMaker3.apply(Utils.id("green_mini_present_with_sparrow"), greenPresentStat, woodTier, greenPresentSettings);
        chestMaker3.apply(Utils.id("lavender_mini_present_with_sparrow"), lavenderPresentStat, woodTier, lavenderPresentSettings);
        chestMaker3.apply(Utils.id("pink_amethyst_mini_present_with_sparrow"), pinkAmethystPresentStat, woodTier, pinkAmethystPresentSettings);
        miniChestBlockEntityType = new NamedValue<class_2591>(MINI_CHEST_BLOCK_TYPE, () -> class_2591.class_2592.method_20528((pos, state) -> new MiniChestBlockEntity(CommonMain.getMiniChestBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), itemAccess, lockable), (class_2248[])((class_2248[])miniChestBlocks.stream().map(NamedValue::getValue).toArray(MiniChestBlock[]::new))).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)MINI_CHEST_BLOCK_TYPE.toString())));
        if (isClient) {
            MiniChestScreen.registerScreenType();
        }
        Predicate<class_2248> isMiniChest = b -> b instanceof MiniChestBlock;
        CommonMain.registerMutationBehaviour(isMiniChest, MutationMode.ROTATE, (context, world, state, pos, stack) -> {
            if (!world.method_8608()) {
                world.method_8501(pos, state.method_26186(class_2470.field_11463));
            }
            return class_1269.field_5812;
        });
        CommonMain.registerMutationBehaviour(isMiniChest, MutationMode.SWAP_THEME, (context, world, state, pos, stack) -> {
            String itemName = stack.method_7964().getString();
            List<class_2248> blocks = itemName.equals("Sunrise") ? tagReloadListener.getMiniChestSecretCycleBlocks() : (itemName.equals("Sparrow") ? tagReloadListener.getMiniChestSecretCycle2Blocks() : tagReloadListener.getMiniChestCycleBlocks());
            int index = blocks.indexOf(state.method_26204());
            if (index != -1) {
                class_2248 next = blocks.get((index + 1) % blocks.size());
                world.method_8501(pos, (class_2680)((class_2680)next.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508))));
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
        contentRegistrationConsumer.accept(new Content(stats, baseItems, chestBlocks, chestItems, chestMinecartEntityTypes, chestMinecartItems, chestBlockEntityType, oldChestBlocks, oldChestItems, oldChestBlockEntityType, barrelBlocks, barrelItems, barrelBlockEntityType, miniChestBlocks, miniChestItems, miniChestBlockEntityType));
    }

    public static <T> void iterateNamedList(List<NamedValue<? extends T>> list, BiConsumer<class_2960, T> consumer) {
        list.forEach(it -> consumer.accept(it.getName(), it.getValue()));
    }

    public static Optional<ItemAccess> getItemAccess(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        if (blockEntity instanceof OldChestBlockEntity) {
            OldChestBlockEntity entity = (OldChestBlockEntity)blockEntity;
            DoubleItemAccess access = entity.getItemAccess();
            CursedChestType type = (CursedChestType)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE));
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            if (access.hasCachedAccess() || type == CursedChestType.SINGLE) {
                return Optional.of(access);
            }
            class_2586 class_25862 = world.method_8321(pos.method_10093(AbstractChestBlock.getDirectionToAttached(type, facing)));
            if (class_25862 instanceof OldChestBlockEntity) {
                DoubleItemAccess second;
                DoubleItemAccess first;
                OldChestBlockEntity otherEntity = (OldChestBlockEntity)class_25862;
                DoubleItemAccess otherAccess = otherEntity.getItemAccess();
                if (otherAccess.hasCachedAccess()) {
                    return Optional.of(otherAccess);
                }
                if (AbstractChestBlock.getBlockType(type) == class_4732.class_4733.field_21784) {
                    first = access;
                    second = otherAccess;
                } else {
                    first = otherAccess;
                    second = access;
                }
                first.setOther(second);
                return Optional.of(first);
            }
        } else if (blockEntity instanceof OpenableBlockEntity) {
            OpenableBlockEntity entity = (OpenableBlockEntity)blockEntity;
            return Optional.of(entity.getItemAccess());
        }
        return Optional.empty();
    }

    public static EntityUpgradeBehaviour getEntityUpgradeBehaviour(class_1297 entity) {
        return null;
    }
}

