// priority: 50

removeRecipe.push(
  "mekanism:processing/osmium/ingot/from_raw_blasting",
  "mekanism:processing/osmium/ingot/from_raw_smelting",
  "mekanism:processing/osmium/raw_storage_blocks/from_raw",
  "mekanism:processing/lead/raw_storage_blocks/from_raw",
  "mekanism:processing/uranium/raw_storage_blocks/from_raw",
  "mekanism:processing/tin/raw_storage_blocks/from_raw",
  "mekanism:processing/refined_glowstone/ingot/from_block",
  "mekanism:processing/refined_glowstone/ingot/from_nuggets",
  "mekanism:storage_blocks/refined_glowstone",
  "mekanism:storage_blocks/fluorite",
  "mekanism:nuggets/refined_glowstone",
  "mekanism:processing/steel/ingot/from_block",
  "mekanism:processing/steel/ingot/from_nuggets",
  "mekanism:processing/steel/ingot/from_dust_blasting",
  "mekanism:processing/steel/ingot/from_dust_smelting",
  "mekanism:storage_blocks/steel",
  "mekanism:nuggets/steel",
  "mekanism:processing/tin/raw/from_raw_block",
  "mekanism:processing/lead/raw/from_raw_block",
  "mekanism:processing/osmium/raw/from_raw_block",
  "mekanism:processing/lead/ingot/from_raw_blasting",
  "mekanism:processing/lead/ingot/from_raw_smelting",
  "mekanism:processing/tin/ingot/from_raw_blasting",
  "mekanism:processing/tin/ingot/from_raw_smelting",
  "mekanism:processing/uranium/raw/from_raw_block",
  "mekanism:processing/tin/storage_blocks/from_ingots",
  "mekanism:processing/uranium/storage_blocks/from_ingots",
  "mekanism:processing/lead/storage_blocks/from_ingots",
  "mekanism:storage_blocks/bronze",
  "mekanism:processing/tin/ingot/from_block",
  "mekanism:processing/uranium/ingot/from_block",
  "mekanism:processing/lead/ingot/from_block",
  "mekanism:processing/bronze/ingot/from_block",
  "mekanism:processing/fluorite/from_block",
  "mekanism:storage_blocks/charcoal",
  "mekanism:storage_blocks/refined_obsidian",
  "mekanism:processing/osmium/storage_blocks/from_ingots",
  "mekanism:processing/refined_obsidian/ingot/from_block",
  "mekanism:processing/osmium/ingot/from_block",
  "mekanism:charcoal",
  "mekanism:processing/lead/nugget/from_ingot",
  "mekanism:processing/tin/nugget/from_ingot",
  "mekanism:processing/uranium/nugget/from_ingot",
  "mekanism:processing/uranium/ingot/from_nuggets",
  "mekanism:processing/osmium/nugget/from_ingot",
  "mekanism:nuggets/bronze",
  "mekanism:processing/lead/ingot/from_nuggets",
  "mekanism:processing/tin/ingot/from_nuggets",
  "mekanism:processing/refined_obsidian/ingot/from_nuggets",
  "mekanism:nuggets/refined_obsidian",
  "mekanism:processing/osmium/ingot/from_nuggets",
  "mekanism:processing/bronze/ingot/from_nuggets",
  "mekanism:processing/bronze/ingot/from_dust_blasting",
  "mekanism:processing/bronze/ingot/from_dust_smelting",
  "mekanism:processing/netherite/ingot_from_dust_blasting"
)

removeOre.push(
  "mekanism:uranium_ore",
  "mekanism:lead_ore",
  "mekanism:tin_ore",
  "mekanism:osmium_ore",
  "mekanism:fluorite_ore",
  "mekanism:deepslate_osmium_ore",
  "mekanism:deepslate_uranium_ore",
  "mekanism:deepslate_tin_ore",
  "mekanism:deepslate_lead_ore",
  "mekanism:deepslate_fluorite_ore"
)

removeItem.push(
  "mekanism:block_raw_lead",
  "mekanism:block_raw_osmium",
  "mekanism:block_raw_tin",
  "mekanism:block_raw_uranium",
  "mekanism:clump_copper",
  "mekanism:clump_gold",
  "mekanism:clump_iron",
  "mekanism:clump_lead",
  "mekanism:clump_osmium",
  "mekanism:clump_tin",
  "mekanism:clump_uranium",
  "mekanism:dirty_dust_copper",
  "mekanism:dirty_dust_gold",
  "mekanism:dirty_dust_iron",
  "mekanism:dirty_dust_lead",
  "mekanism:dirty_dust_osmium",
  "mekanism:dirty_dust_tin",
  "mekanism:dirty_dust_uranium",
  "mekanism:raw_lead",
  "mekanism:raw_osmium",
  "mekanism:raw_tin",
  "mekanism:raw_uranium",
  "mekanism:crystal_iron",
  "mekanism:crystal_gold",
  "mekanism:crystal_osmium",
  "mekanism:crystal_copper",
  "mekanism:crystal_tin",
  "mekanism:crystal_lead",
  "mekanism:crystal_uranium",
  "mekanism:nugget_osmium",
  "mekanism:nugget_tin",
  "mekanism:nugget_lead",
  "mekanism:nugget_uranium",
  "mekanism:ingot_osmium",
  "mekanism:ingot_tin",
  "mekanism:ingot_lead",
  "mekanism:ingot_uranium",
  "mekanism:dust_iron",
  "mekanism:dust_gold",
  "mekanism:dust_copper",
  "mekanism:dust_osmium",
  "mekanism:dust_tin",
  "mekanism:dust_lead",
  "mekanism:dust_uranium",
  "mekanism:shard_iron",
  "mekanism:shard_gold",
  "mekanism:shard_osmium",
  "mekanism:shard_copper",
  "mekanism:shard_tin",
  "mekanism:shard_lead",
  "mekanism:shard_uranium",
  "mekanism:nugget_refined_glowstone",
  "mekanism:block_salt",
  "mekanism:block_fluorite",
  "mekanism:salt",
  "mekanism:block_refined_glowstone",
  "mekanism:ingot_refined_glowstone",
  "mekanism:dust_quartz",
  "mekanism:ingot_steel",
  "mekanism:dust_steel",
  "mekanism:block_steel",
  "mekanism:nugget_steel",
  "mekanism:raw_tin",
  "mekanism:raw_lead",
  "mekanism:raw_osmium",
  "mekanism:dust_coal",
  "mekanism:sawdust",
  "mekanism:block_raw_osmium",
  "mekanism:block_raw_tin",
  "mekanism:block_raw_uranium",
  "mekanism:block_raw_lead",
  "mekanism:block_tin",
  "mekanism:block_uranium",
  "mekanism:block_lead",
  "mekanism:block_bronze",
  "mekanism:block_refined_obsidian",
  "mekanism:block_osmium",
  "mekanism:block_charcoal",
  "mekanism:nugget_bronze",
  "mekanism:nugget_refined_obsidian",
  "mekanism:nuggets/refined_obsidian",
  "mekanism:dust_lapis_lazuli",
  "mekanism:dust_obsidian",
  "mekanism:dust_diamond",
  "mekanism:dust_emerald",
  "mekanism:dust_sulfur",
  "mekanism:dust_bronze",
  "mekanism:dust_refined_obsidian",
  "mekanism:dust_charcoal",
  "mekanism:dust_netherite",
  "mekanism:ingot_bronze",
  "mekanism:ingot_refined_obsidian",
  "mekanism:dust_lithium",
  "mekanism:hydrogen_bucket",
  "mekanism:oxygen_bucket",
  "mekanism:chlorine_bucket",
  "mekanism:sulfuric_acid_bucket",
  "mekanism:steam_bucket"
)

const processingRecipes = [
  ["clump", ["from_ore", "from_raw_block", "from_raw_ore", "from_shard"]],
  ["crystal", ["from_slurry"]],
  ["dirty_dust", ["from_clump"]],
  ["dust", ["from_dirty_dust", "from_ingot", "from_ore", "from_raw_block", "from_raw_ore"]],
  ["ingot", ["from_dust_blasting", "from_dust_smelting"]],
  ["ore", ["deepslate_from_raw", "from_raw"]],
  ["shard", ["from_crystal", "from_ore", "from_raw_block", "from_raw_ore"]],
  ["slurry", ["clean"]],
  ["slurry/dirty", ["from_ore", "from_raw_block", "from_raw_ore"]]
]

/**
 * Tag Suffix, Item Input Amount, Chemical Input Amount, Item Output Amount
 * @type {[string, number, number, number]}
 */
const recipeVariationsInjecting = [
  ["ores/", 1, 1, 4],
  ["crystals/", 1, 1, 1],
  ["storage_blocks/raw_", 1, 2, 24],
  ["raw_materials/", 3, 1, 8]
]

/**
 * Tag Suffix, Item Input Amount, Chemical Input Amount, Item Output Amount
 * @type {[string, number, number, number]}
 */
const recipeVariationsPurifying = [
  ["ores/", 1, 1, 3],
  ["shards/", 1, 1, 1],
  ["storage_blocks/raw_", 1, 2, 18],
  ["raw_materials/", 1, 1, 2]
]

/**
 * Input tag suffix, Output item type
 * @type {[string, string]}
 */
const recipeVariationsCrushing = [
  ["ingots/", "dust"],
  ["clumps/", "dirty_dust"]
]

/**
 * Tag Suffix, Item input amount, Item output amount
 * @type {[string, number, number]}
 */
const recipeVariationsEnriching = [
  ["dirty_dusts/", 1, 1],
  ["ores/", 1, 2],
  ["storage_blocks/raw_", 1, 12],
  ["raw_materials/", 3, 4]
]

/**
 * Tag Suffix, Item input amount, Output item type
 * @type {[string, string]}
 */
const recipeVariationsCombining = [
  ["cobblestones/normal", "stone"],
  ["cobblestones/deepslate", "deepslate"]
]

/**
 * Tag Suffix, Item input amount, Chemical input amount, Output amount
 * @type {[string, number, number, number]}
 */
const recipeVariationsDissolution = [
  ["ores/", 1, 1, 1000],
  ["storage_blocks/raw_", 1, 2, 6000],
  ["raw_materials/", 3, 1, 2000]
]

ServerEvents.recipes((event) => {
  const modRecipesToRemove = ["mekanism", "minecraft"]

  global.resourceOresIngots.forEach((mod) => {
    const modID = mod.modID
    const materials = mod.materials

    materials.forEach((material) => {
      let chemicalPrefix = global.registryPrefix

      if (modRecipesToRemove.includes(modID)) {
        chemicalPrefix = "mekanism"
        processingRecipes.forEach(([type, variants]) => {
          variants.forEach((variant) => {
            event.remove({
              id: `mekanism:processing/${material}/${type}/${variant}`
            })
          })
        })
      }

      // Injecting
      recipeVariationsInjecting.forEach(([suffix, itemInAmt, chemAmt, outAmt]) => {
        addRecipeMekanismInjecting(
          event,
          [`c:${suffix}${material}`, itemInAmt],
          ["mekanism:hydrogen_chloride", chemAmt],
          [`ftbmaterials:${material}_shard`, outAmt],
          `ftb:mekanism/processing/${material}/shard/from_${suffix}`
        )
      })

      // Purifying
      recipeVariationsPurifying.forEach(([suffix, itemInAmt, chemAmt, outAmt]) => {
        addRecipeMekanismPurifying(
          event,
          [`c:${suffix}${material}`, itemInAmt],
          ["mekanism:oxygen", chemAmt],
          [`ftbmaterials:${material}_clump`, outAmt],
          `ftb:mekanism/processing/${material}/clump/from_${suffix}`
        )
      })

      // Crushing
      recipeVariationsCrushing.forEach(([suffix, type]) => {
        addRecipeMekanismCrushing(
          event,
          `c:${suffix}${material}`,
          [`ftbmaterials:${material}_${type}`, 1],
          `ftb:mekanism/processing/${material}/${type}/from_clump`
        )
      })

      // Enriching
      recipeVariationsEnriching.forEach(([suffix, itemInAmt, outAmt]) => {
        const tag = `c:${suffix}${material}`
        addRecipeMekanismEnriching(
          event,
          tag,
          itemInAmt,
          `ftbmaterials:${material}_dust`,
          outAmt,
          `ftb:mekanism/processing/${material}/dust/from_${suffix.split("/")[0]}`
        )
      })

      // Combining
      recipeVariationsCombining.forEach(([extraTag, outputType]) => {
        addRecipeMekanismCombining(
          event,
          [`c:raw_materials/${material}`, 8],
          [`c:${extraTag}`, 1],
          [getOreName(material, outputType), 1],
          `ftb:mekanism/processing/${material}/ore/${outputType}`
        )
      })

      // Crystallizing
      addRecipeMekanismCrystallizing(
        event,
        [`${chemicalPrefix}:clean_${material}`, 200],
        [`ftbmaterials:${material}_crystal`, 1],
        `ftb:mekanism/processing/${material}/crystal/from`
      )

      // Washing
      addRecipeMekanismWashing(
        event,
        ["minecraft:water", 5],
        [`${chemicalPrefix}:dirty_${material}`, 1],
        [`${chemicalPrefix}:clean_${material}`, 1],
        `ftb:mekanism/processing/${material}/slurry/clean`
      )

      // Dissolution
      recipeVariationsDissolution.forEach(([suffix, itemAmt, chemAmt, outAmt]) => {
        addRecipeMekanismDissolution(
          event,
          [`c:${suffix}${material}`, itemAmt],
          ["mekanism:sulfuric_acid", chemAmt],
          [`${chemicalPrefix}:dirty_${material}`, outAmt],
          `ftb:mekanism/processing/${material}/slurry/dirty/from_${suffix}`
        )
      })
    })
  })

  // Loop For Gem Ores
  global.resourcesOresGem.forEach((mod) => {
    mod.materials.forEach((material) => {
      const gemType = material[0]
      const oreTag = `${global.tagPrefix}:ores/${gemType}`
      const outputId = material[2] ?? `${mod.modID}:${gemType}`
      const outputAmount = material[1] ?? 1

      // Ore -> Gem
      addRecipeMekanismCrushing(event, oreTag, [outputId, outputAmount], `ftb:mekanism/crusher/raw_ore/${gemType}`)
    })
  })

  //Salt Crushing
  addRecipeMekanismCrushing(event, "c:gems/salt", ["ftbmaterials:salt_dust", 2], `ftb:mekanism/crusher/gem/salt`)

  addRecipeMekanismCrushing(
    event,
    "c:ingots/electrum",
    ["ftbmaterials:electrum_dust", 1],
    `ftb:mekanism/crusher/ingot/electrum`
  )

  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemical_input: {
        amount: 10,
        tag: "mekanism:gold"
      },
      item_input: {
        count: 1,
        tag: "c:dusts/silver"
      },
      output: {
        count: 2,
        id: "ftbmaterials:electrum_dust"
      },
      per_tick_usage: false
    })
    .id("ftb:mekanism/infusing/electrum")

  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemical_input: {
        amount: 10,
        tag: "mekanism:nickel"
      },
      item_input: {
        count: 1,
        tag: "c:dusts/copper"
      },
      output: {
        count: 2,
        id: "ftbmaterials:constantan_dust"
      },
      per_tick_usage: false
    })
    .id("ftb:mekanism/infusing/nickel")

  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemical_input: {
        amount: 10,
        tag: "mekanism:zinc"
      },
      item_input: {
        count: 1,
        tag: "c:dusts/copper"
      },
      output: {
        count: 2,
        id: "ftbmaterials:brass_dust"
      },
      per_tick_usage: false
    })
    .id("ftb:mekanism/infusing/brass")

  event
    .custom({
      type: "mekanism:metallurgic_infusing",
      chemical_input: {
        amount: 10,
        tag: "mekanism:nickel"
      },
      item_input: {
        count: 2,
        tag: "c:dusts/iron"
      },
      output: {
        count: 3,
        id: "ftbmaterials:invar_dust"
      },
      per_tick_usage: false
    })
    .id("ftb:mekanism/infusing/invar")

  event
    .custom({
      type: "mekanism:chemical_conversion",
      input: {
        count: 1,
        tag: "c:dusts/zinc"
      },
      output: {
        amount: 10,
        id: "ftb:zinc"
      }
    })
    .id("ftb:mekanism/conversion/zinc")

  event
    .custom({
      type: "mekanism:chemical_conversion",
      input: {
        count: 1,
        tag: "c:dusts/nickel"
      },
      output: {
        amount: 10,
        id: "ftb:nickel"
      }
    })
    .id("ftb:mekanism/conversion/nickel")
})
