// priority: 1000000
// Hides Item and Remove all recipes using / making that item

const disabledItems = [
  "twilightforest:charm_of_keeping_1",
  "twilightforest:charm_of_keeping_2",
  "twilightforest:charm_of_keeping_3",
  "metalbarrels:wood_to_crystal",
  "metalbarrels:copper_to_crystal",
  "metalbarrels:iron_to_crystal",
  "metalbarrels:silver_to_crystal",
  "metalbarrels:gold_to_crystal",
  "metalbarrels:silver_to_netherite",
  "metalbarrels:wood_to_netherite",
  "metalbarrels:copper_to_obsidian",
  "metalbarrels:iron_to_diamond",
  "metalbarrels:silver_to_obsidian",
  "metalbarrels:copper_to_netherite",
  "metalbarrels:gold_to_obsidian",
  "metalbarrels:gold_to_netherite",
  "metalbarrels:iron_to_obsidian",
  "metalbarrels:iron_to_netherite",
  "metalbarrels:copper_to_gold",
  "metalbarrels:obsidian_to_netherite",
  "metalbarrels:copper_to_diamond",
  "metalbarrels:diamond_to_netherite",
  "actuallyadditions:coal_generator",
  "actuallyadditions:heat_collector",
  "actuallyadditions:leaf_generator",
  "actuallyadditions:oil_generator",
  "ae2:calculation_processor_press",
  "megacells:accumulation_processor_press",
  "ae2:engineering_processor_press",
  "ae2:inscriber",
  "ae2:name_press",
  "ae2:silicon_press",
  "ars_elemental:glyph_conjure_terrain",
  "ars_nouveau:glyph_redstone_signal",
  "ars_nouveau:ritual_cloudshaping",
  "ars_nouveau:ritual_moonfall",
  "ars_nouveau:ritual_sunrise",
  "artifacts:golden_hook",
  "artifacts:pocket_piston",
  "avaritia:compressed_crafting_table",
  "chicken_roost:chickenstorage",
  "avaritia:double_compressed_crafting_table",
  "avaritia:extreme_crafting_table",
  "avaritia:infinity_chest",
  "extrastorage:raw_neural_processor",
  "bhc:soul_heart_amulet",
  "bhc:soul_heart_canister",
  "bhc:soul_heart_crystal",
  "refinedstorage:raw_basic_processor",
  "refinedstorage:raw_improved_processor",
  "refinedstorage:raw_advanced_processor",
  "chicken_roost:ingot_adamantium",
  "chicken_roost:ingot_chrome",
  "chicken_roost:ingot_signalum",
  "chicken_roost:ingot_titanum",
  "chicken_roost:ingot_tungstensteel",
  "create:windmill_bearing",
  "dimdungeons:block_gilded_portal",
  "dimdungeons:block_key_charger",
  "dimdungeons:block_portal_crown",
  "dimdungeons:block_portal_keyhole",
  "dimdungeons:item_blank_advanced_key",
  "dimdungeons:item_blank_build_key",
  "dimdungeons:item_blank_teleporter_key",
  "dimdungeons:item_homeward_pearl",
  "dimdungeons:item_portal_key",
  "draconicevolution:celestial_manipulator",
  "draconicevolution:rain_sensor",
  "enderio:energetic_photovoltaic_module",
  "enderio:photovoltaic_plate",
  "enderio:pulsating_photovoltaic_module",
  "enderio:staff_of_levity",
  "enderio:stirling_generator",
  "enderio:vibrant_photovoltaic_module",
  "extendedae:ex_inscriber",
  "farmingforblockheads:market",
  "fdbosses:eye_of_chesed",
  "fdbosses:eye_of_malkuth",
  "ftbmaterials:diamond_chunk",
  "ftbmaterials:diamond_cluster",
  "ftbmaterials:emerald_chunk",
  "ftbmaterials:emerald_cluster",
  "ftbmaterials:fluorite_chunk",
  "ftbmaterials:fluorite_cluster",
  "ftbmaterials:lapis_lazuli_chunk",
  "ftbmaterials:lapis_lazuli_cluster",
  "ftbmaterials:quartz_chunk",
  "ftbmaterials:quartz_cluster",
  "ftbmaterials:redstone_chunk",
  "ftbmaterials:redstone_cluster",
  "ftbstuff:acacia_sluice",
  "ftbstuff:acacia_water_strainer",
  "ftbstuff:auto_processing_block",
  "ftbstuff:bamboo_sluice",
  "ftbstuff:bamboo_water_strainer",
  "ftbstuff:birch_sluice",
  "ftbstuff:birch_water_strainer",
  "ftbstuff:black_barrel",
  "ftbstuff:blazing_mesh",
  "ftbstuff:blue_barrel",
  "ftbstuff:blue_magma_block",
  "ftbstuff:cast_iron_block",
  "ftbstuff:cast_iron_gear",
  "ftbstuff:cast_iron_ingot",
  "ftbstuff:cast_iron_nugget",
  "ftbstuff:cherry_sluice",
  "ftbstuff:cherry_water_strainer",
  "ftbstuff:cloth_mesh",
  "ftbstuff:crate",
  "ftbstuff:creative_high_temperature_source",
  "ftbstuff:creative_low_temperature_source",
  "ftbstuff:creative_subzero_temperature_source",
  "ftbstuff:crimson_sluice",
  "ftbstuff:crimson_water_strainer",
  "ftbstuff:crushed_endstone",
  "ftbstuff:crushed_netherrack",
  "ftbstuff:dark_oak_sluice",
  "ftbstuff:dark_oak_water_strainer",
  "ftbstuff:diamond_mesh",
  "ftbstuff:diamond_sluice",
  "ftbstuff:fluid_capsule",
  "ftbstuff:gold_mesh",
  "ftbstuff:golden_barrel",
  "ftbstuff:green_barrel",
  "ftbstuff:iron_mesh",
  "ftbstuff:iron_sluice",
  "ftbstuff:jar",
  "ftbstuff:jungle_sluice",
  "ftbstuff:jungle_water_strainer",
  "ftbstuff:mangrove_sluice",
  "ftbstuff:mangrove_water_strainer",
  "ftbstuff:netherite_sluice",
  "ftbstuff:oak_sluice",
  "ftbstuff:oak_water_strainer",
  "ftbstuff:pale_oak_sluice",
  "ftbstuff:pulsating_crate",
  "ftbstuff:pump",
  "ftbstuff:purple_barrel",
  "ftbstuff:red_barrel",
  "ftbstuff:small_crate",
  "ftbstuff:spruce_sluice",
  "ftbstuff:spruce_water_strainer",
  "ftbstuff:tempered_glass",
  "ftbstuff:tempered_jar",
  "ftbstuff:tube",
  "ftbstuff:warped_sluice",
  "ftbstuff:warped_water_strainer",
  "ftbstuff:water_bowl",
  "ftbstuff:white_barrel",
  "functionalstorage:armory_cabinet",
  "gag:escape_rope",
  "gag:no_solicitors",
  "immersiveengineering:duroplast",
  "immersiveengineering:plate_duroplast",
  "immersiveengineering:windmill_blade",
  "immersiveengineering:windmill_sail",
  "immersiveengineering:windmill",
  "industrialforegoing:pitiful_generator",
  "irons_spellbooks:wayward_compass",
  "irregular_implements:evil_tear",
  "justdirethings:upgrade_orescanner",
  "justdirethings:upgrade_orexray",
  "justdynathings:blazegold_solar_panel",
  "justdynathings:celestigem_solar_panel",
  "justdynathings:celestigem_solar_panel",
  "justdynathings:charged_blazebloom_goo",
  "justdynathings:charged_primogel_goo",
  "justdynathings:charged_shadowpulse_goo",
  "justdynathings:charged_voidshimmer_goo",
  "justdynathings:eclipse_alloy_solar_panel",
  "justdynathings:energized_goo",
  "justdynathings:ferricore_solar_panel",
  "justdynathings:goo_upgrader_t1",
  "justdynathings:goo_upgrader_t2",
  "justdynathings:goo_upgrader_t3",
  "justdynathings:goo_upgrader_t4",
  "justdynathings:reforger",
  "justdynathings:thermo_generator",
  "laserio:logic_chip_raw",
  "magic_coins:crystal_coin",
  "magic_coins:crystal_coin",
  "magic_coins:gold_coin",
  "magic_coins:prosperity_amulet",
  "magic_coins:silver_coin",
  "magic_coins:silver_coin",
  "mekanism:solar_neutron_activator",
  "mekanismgenerators:advanced_solar_generator",
  "mekanismgenerators:solar_generator",
  "mekanismgenerators:solar_panel",
  "mekanismgenerators:wind_generator",
  "minecraft:end_portal_frame",
  "occultism:divination_rod",
  "createaddition:zinc_sheet",
  "oritech:big_solar_panel_block",
  "pipez:infinity_upgrade",
  "powah:furnator_basic",
  "powah:furnator_blazing",
  "powah:furnator_hardened",
  "powah:furnator_niotic",
  "powah:furnator_nitro",
  "powah:furnator_spirited",
  "powah:furnator_starter",
  "powah:lens_of_ender",
  "powah:photoelectric_pane",
  "powah:solar_panel_basic",
  "powah:solar_panel_blazing",
  "powah:solar_panel_hardened",
  "powah:solar_panel_niotic",
  "powah:solar_panel_nitro",
  "powah:solar_panel_spirited",
  "powah:solar_panel_starter",
  "projecte:alchemical_chest",
  "projecte:catalytic_lens",
  "projecte:condenser_mk1",
  "projecte:divining_rod_1",
  "projecte:divining_rod_2",
  "projecte:divining_rod_3",
  "projecte:high_covalence_dust",
  "projecte:hyperkinetic_lens",
  "projecte:low_covalence_dust",
  "projecte:medium_covalence_dust",
  "projecte:relay_mk1",
  "projecte:relay_mk2",
  "projecte:tome",
  "projecte:transmutation_table",
  "projecte:transmutation_tablet",
  "relics:researching_table",
  "reliquified_twilight_forest:invisibility_cloak",
  "rftoolsutility:saturation_module",
  "sophisticatedbackpacks:advanced_alchemy_upgrade",
  "sophisticatedbackpacks:alchemy_upgrade",
  "sophisticatedbackpacks:inception_upgrade",
  "sophisticatedbackpacks:stack_upgrade_omega_tier",
  "sophisticatedstorage:basic_tier_upgrade",
  "sophisticatedstorage:stack_upgrade_tier_4",
  "sophisticatedstorage:stack_upgrade_tier_5",
  "supplementaries:faucet",
  "supplementaries:faucet",
  "twilightforest:magic_map_focus",
  "twilightforest:magic_map",
  "twilightforest:maze_map_focus",
  "twilightforest:maze_map",
  "twilightforest:ore_magnet",
  "twilightforest:ore_map",
  "twilightforest:uncrafting_table",
  "utilitarian:black_soliciting_carpet",
  "utilitarian:black_trapped_soliciting_carpet",
  "utilitarian:blue_soliciting_carpet",
  "utilitarian:blue_trapped_soliciting_carpet",
  "utilitarian:brown_soliciting_carpet",
  "utilitarian:brown_trapped_soliciting_carpet",
  "utilitarian:cursed_grrass",
  "utilitarian:cyan_soliciting_carpet",
  "utilitarian:cyan_trapped_soliciting_carpet",
  "utilitarian:drit",
  "utilitarian:grrass",
  "utilitarian:gray_soliciting_carpet",
  "utilitarian:gray_trapped_soliciting_carpet",
  "utilitarian:green_soliciting_carpet",
  "utilitarian:green_trapped_soliciting_carpet",
  "utilitarian:grrass",
  "utilitarian:light_blue_soliciting_carpet",
  "utilitarian:light_blue_trapped_soliciting_carpet",
  "utilitarian:light_gray_soliciting_carpet",
  "utilitarian:light_gray_trapped_soliciting_carpet",
  "utilitarian:lime_soliciting_carpet",
  "utilitarian:lime_trapped_soliciting_carpet",
  "utilitarian:magenta_soliciting_carpet",
  "utilitarian:magenta_trapped_soliciting_carpet",
  "utilitarian:no_soliciting_banner",
  "utilitarian:orange_soliciting_carpet",
  "utilitarian:orange_trapped_soliciting_carpet",
  "utilitarian:pink_soliciting_carpet",
  "utilitarian:pink_trapped_soliciting_carpet",
  "utilitarian:purple_soliciting_carpet",
  "utilitarian:purple_trapped_soliciting_carpet",
  "utilitarian:red_soliciting_carpet",
  "utilitarian:red_trapped_soliciting_carpet",
  "utilitarian:white_soliciting_carpet",
  "utilitarian:white_trapped_soliciting_carpet",
  "utilitarian:yellow_soliciting_carpet",
  "utilitarian:yellow_trapped_soliciting_carpet",
  "minecraft:suspicious_sand",
  "minecraft:suspicious_gravel",
  "draconicevolution:draconium_chest",
  "avaritia:quartz_singularity",
  "avaritia:emerald_singularity",
  "create_dragons_plus:fluid_hatch",
  "oritech:uranium_crystal",
  "create_shimmer:raw_knightmetal",
];

const refined_storage_block_types = [
  "refinedstorage:controller",
  "refinedstorage:creative_controller",
  "refinedstorage:cable",
  "refinedstorage:importer",
  "refinedstorage:exporter",
  "refinedstorage:constructor",
  "refinedstorage:destructor",
  "refinedstorage:grid",
  "refinedstorage:crafting_grid",
  "refinedstorage:pattern_grid",
  "refinedstorage:detector",
  "refinedstorage:wireless_transmitter",
  "refinedstorage:network_transmitter",
  "refinedstorage:network_receiver",
  "refinedstorage:security_manager",
  "refinedstorage:relay",
  "refinedstorage:disk_interface",
  "refinedstorage:autocrafter",
  "refinedstorage:autocrafter_manager",
  "refinedstorage:autocrafting_monitor",
  "refinedstorage:external_storage",
  "cabletiers:creative_autocrafter",
  "cabletiers:mega_autocrafter",
  "cabletiers:ultra_autocrafter",
  "cabletiers:elite_autocrafter",
  "cabletiers:elite_exporter",
  "cabletiers:elite_importer",
  "cabletiers:elite_constructor",
  "cabletiers:elite_destructor",
  "cabletiers:elite_disk_interface",
  "cabletiers:ultra_exporter",
  "cabletiers:ultra_importer",
  "cabletiers:ultra_constructor",
  "cabletiers:ultra_destructor",
  "cabletiers:ultra_disk_interface",
  "cabletiers:mega_exporter",
  "cabletiers:mega_importer",
  "cabletiers:mega_constructor",
  "cabletiers:mega_destructor",
  "cabletiers:mega_disk_interface",
  "cabletiers:creative_exporter",
  "cabletiers:creative_importer",
  "cabletiers:creative_constructor",
  "cabletiers:creative_destructor",
  "cabletiers:creative_disk_interface",
];

const refined_colors = [
  "yellow",
  "lime",
  "pink",
  "gray",
  "light_gray",
  "cyan",
  "purple",
  "light_blue",
  "blue",
  "brown",
  "green",
  "red",
  "black",
  "white",
  "orange",
  "magenta",
];

ServerEvents.tags("item", (event) => {
  disabledItems.forEach((item) => {
    let stack = Item.of(item).getTags();
    stack.forEach((tag) => {
      event.remove(tag, [item]);
    });
  });
  event.add("c:hidden_from_recipe_viewers", disabledItems);

  //Hidding Refined Storage's Colored Items to Declutter JEI.
  refined_storage_block_types.forEach((block_type) => {
    let modid = block_type.split(":")[0];
    let blockid = block_type.split(":")[1];
    refined_colors.forEach((color) => {
      event.add("c:hidden_from_recipe_viewers", `${modid}:${color}_${blockid}`);
    });
  });
});

ServerEvents.recipes((event) => {
  event.remove({ output: disabledItems });
});

RecipeViewerEvents.removeCategories((event) => {
  event.remove("ftbstuff:jar");
  event.remove("ftbstuff:loot_summary");
  event.remove("ftbstuff:sluice");
  event.remove("ftbstuff:temperature_source");
});
