/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.utils;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Launcher;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static Map<String, String> getStartupArgs() {
        Map<String, String> args = new HashMap<String, String>();
        try {
            Field argumentHandler = Launcher.class.getDeclaredField("argumentHandler");
            argumentHandler.setAccessible(true);
            ArgumentHandler o = (ArgumentHandler)argumentHandler.get(Launcher.INSTANCE);
            String[] buildArgs = o.buildArgumentList();
            args = Utils.parseArgs(buildArgs);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Could not get version argument", (Throwable)e);
        }
        return args;
    }

    public static Map<String, String> parseArgs(String[] argsArray) {
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < argsArray.length; ++i) {
            if (!argsArray[i].startsWith("--")) continue;
            String key = argsArray[i].substring(2);
            String value = "";
            if (i + 1 < argsArray.length && !argsArray[i + 1].startsWith("--")) {
                value = argsArray[i + 1];
                ++i;
            }
            args.put(key, value);
        }
        return args;
    }
}

