/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.mixins;

import dev.ftb.mods.ftbauxilium.ApiManager;
import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.auxilium.ModpackData;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrashReport.class})
public abstract class CrashMixin {
    @Shadow
    public abstract String getFriendlyReport(ReportType var1, List<String> var2);

    @Inject(at={@At(value="HEAD")}, method={"saveToFile(Ljava/nio/file/Path;Lnet/minecraft/ReportType;Ljava/util/List;)Z"})
    private void saveToFile(Path path, ReportType reportType, List<String> list, CallbackInfoReturnable<Boolean> cir) {
        if (path.toString().contains("crash-")) {
            try {
                ApiManager.get().sendCrashReport(this.getFriendlyReport(reportType, list));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"getDetails(Ljava/lang/StringBuilder;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/SystemReport;appendToCrashReportString(Ljava/lang/StringBuilder;)V", ordinal=0, shift=At.Shift.BEFORE)})
    public void addPackData(StringBuilder stringBuilder, CallbackInfo ci) {
        try {
            ModpackData packData = FTBAuxilium.STAT_MANAGER.getPackData();
            stringBuilder.append("--- FTB ---\n");
            stringBuilder.append("Details: \n");
            stringBuilder.append("\tPack: ").append(packData.name).append(" (").append(packData.id).append(")").append("\n");
            stringBuilder.append("\tVersion: ").append(packData.version).append(" (").append(packData.versionId).append(")").append("\n");
            stringBuilder.append("\tLauncher: ").append((Object)packData.launcher).append("\n");
            stringBuilder.append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

