/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.GlUtil;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.repository.Pack;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class SystemStats {
    public String timeZone;
    public String javaVersion;
    public String javaVendor;
    public final long memoryTotal = 0L;
    public final long memoryMax = 0L;
    public long systemRamTotal;
    public long instanceRamAllocated;
    public int cpuCores;
    public String operatingSystemArch;
    public String operatingSystem;
    public String cpu;
    public String gpu;
    public String version;
    public String launchVersion;
    public String clientBrand;
    public double guiScale;
    public int resourcePacks = 0;
    public int refreshRate;
    public boolean vsync;
    public boolean fullscreen;
    public String lang;
    public int packId = -1;
    public int packVersionId = -1;

    public SystemStats() {
        Minecraft minecraft = Minecraft.getInstance();
        SystemInfo systemInfo = new SystemInfo();
        long maxMemory = Runtime.getRuntime().maxMemory();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        CentralProcessor processor = hardware.getProcessor();
        this.javaVersion = System.getProperty("java.version");
        this.javaVendor = System.getProperty("java.vendor");
        this.systemRamTotal = hardware.getMemory().getVirtualMemory().getVirtualMax();
        this.instanceRamAllocated = maxMemory;
        this.cpuCores = processor.getPhysicalProcessorCount();
        this.operatingSystemArch = System.getProperty("os.arch");
        this.operatingSystem = Util.getPlatform().toString();
        this.timeZone = System.getProperty("user.timezone");
        this.cpu = GlUtil.getCpuInfo();
        this.gpu = GlUtil.getRenderer();
        this.guiScale = minecraft.getWindow().getGuiScale();
        for (Pack pack : minecraft.getResourcePackRepository().getSelectedPacks()) {
            if (pack.isRequired() || pack.isRequired()) continue;
            ++this.resourcePacks;
        }
        this.refreshRate = minecraft.getWindow().getRefreshRate();
        this.vsync = (Boolean)minecraft.options.enableVsync().get();
        this.fullscreen = (Boolean)minecraft.options.fullscreen().get();
        this.lang = minecraft.options.languageCode;
        this.version = SharedConstants.getCurrentVersion().getName();
        this.launchVersion = minecraft.getLaunchedVersion();
        this.clientBrand = ClientBrandRetriever.getClientModName();
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("timeZone", (Object)this.timeZone).add("javaVersion", (Object)this.javaVersion).add("javaVendor", (Object)this.javaVendor);
        Objects.requireNonNull(this);
        MoreObjects.ToStringHelper toStringHelper2 = toStringHelper.add("memoryTotal", 0L);
        Objects.requireNonNull(this);
        return toStringHelper2.add("memoryMax", 0L).add("cpuCores", this.cpuCores).add("operatingSystemArch", (Object)this.operatingSystemArch).add("operatingSystem", (Object)this.operatingSystem).add("cpu", (Object)this.cpu).add("gpu", (Object)this.gpu).add("version", (Object)this.version).add("launchVersion", (Object)this.launchVersion).add("clientBrand", (Object)this.clientBrand).add("guiScale", this.guiScale).add("resourcePacks", this.resourcePacks).add("refreshRate", this.refreshRate).add("vsync", this.vsync).add("fullscreen", this.fullscreen).add("lang", (Object)this.lang).toString();
    }
}

