/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.auxilium.AnonymousIdentification;
import dev.ftb.mods.ftbauxilium.auxilium.Launchers;
import dev.ftb.mods.ftbauxilium.auxilium.ModpackData;
import dev.ftb.mods.ftbauxilium.auxilium.SessionCollector;
import dev.ftb.mods.ftbauxilium.tasks.LaunchTask;
import dev.ftb.mods.ftbauxilium.tasks.LevelExitTask;
import dev.ftb.mods.ftbauxilium.tasks.LevelLoadTask;
import dev.ftb.mods.ftbauxilium.utils.Utils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatManager.class);
    private static final AnonymousIdentification IDENTIFIER = new AnonymousIdentification();
    private float loadTimeInSeconds = 0.0f;
    private ModpackData packData;
    private String sessionToken = "";
    private SessionCollector session;
    private Launchers launcher = Launchers.UNKNOWN;

    public static AnonymousIdentification identifier() {
        return IDENTIFIER;
    }

    public void init(IEventBus eventBus) {
        FTBAuxilium.LOGGER.debug("Starting stat system");
        this.packData = new ModpackData();
        eventBus.addListener(this::onClientSetup);
        NeoForge.EVENT_BUS.addListener(this::worldLoaded);
        NeoForge.EVENT_BUS.addListener(this::onLevelExit);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        if (StatManager.identifier().isOptedOut()) {
            return;
        }
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        this.loadTimeInSeconds = (float)uptime / 1000.0f;
        File gameDirectory = Minecraft.getInstance().gameDirectory.getAbsoluteFile();
        Map<String, String> startupArgs = Utils.getStartupArgs();
        this.launcher = Launchers.detectLauncher(gameDirectory.toPath(), startupArgs);
        FTBAuxilium.LOGGER.info("Launcher found: {}", (Object)this.launcher.getName());
        Minecraft.getInstance().execute(() -> FTBAuxilium.runTask(new LaunchTask(this.launcher)));
    }

    public void worldLoaded(ClientPlayerNetworkEvent.LoggingIn event) {
        if (StatManager.identifier().isOptedOut()) {
            return;
        }
        Minecraft.getInstance().execute(() -> FTBAuxilium.runTask(new LevelLoadTask(event.getPlayer())));
    }

    public void onLevelExit(ClientPlayerNetworkEvent.LoggingOut event) {
        if (event.getPlayer() == null || StatManager.identifier().isOptedOut()) {
            return;
        }
        Minecraft.getInstance().execute(() -> FTBAuxilium.runTask(new LevelExitTask()));
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public ModpackData getPackData() {
        return this.packData;
    }

    public float getLoadTimeInSeconds() {
        return this.loadTimeInSeconds;
    }

    public SessionCollector getSession() {
        return this.session;
    }

    public void setSession(SessionCollector session) {
        this.session = session;
    }
}

