/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Launchers {
    FTB(100, "FTB App", ".ftbapp", "version.json"),
    CURSE(90, "Curse", ".curseclient"),
    PRISM(75, "Prism", (version, assetDir) -> assetDir.contains("prismlauncher")),
    POLYMC(80, "PolyMC", (version, assetDir) -> version.contains("polymc")),
    MULTI(75, "MultiMc", (version, assetDir) -> version.contains("multimc")),
    MODRINTH(70, "Modrinth", "profile.json"),
    GD(70, "GDLauncher", "config.json"),
    GD_CARBON(70, "GDLauncher Carbon", "../../gdl_conf.db"),
    ATLAUNCHER(60, "ATLancher", "../../ATLauncher.jar"),
    TLAUNCHER(50, "TLancher", "../../tlauncher_libraries"),
    LUNAR(45, "Lunar", Map.of("minecraft.launcher.brand", "LunarClient")),
    HMCL(10, "HMCL", "hmclversion.cfg"),
    NO_RISK(10, "NoRisk", "NoRiskClient", "NoRiskClientLauncher"),
    X_MINECRAFT(10, "X-Minecraft", "../../../.minecraftx"),
    K_LAUNCHER(10, "KLauncher", "install_profile.json"),
    SK_LAUNCHER(10, "SKLauncher", Map.of("sklauncher.gametype", "EXISTS", "sklauncher.minecraft", "EXISTS", "sklauncher.discordrpc", "EXISTS", "sklauncher.dns", "EXISTS")),
    UNKNOWN(5, "unknown", "");

    private static final Logger LOGGER;
    final String name;
    final String[] possibleIdentifiers;
    final int priority;
    final Map<String, String> systemPropertiesCheck;
    @Nullable
    final BiPredicate<String, String> checker;
    public static final Launchers[] VALUES;

    private Launchers(int priority, String name, String ... possibleIdentifiers) {
        this.name = name;
        this.possibleIdentifiers = possibleIdentifiers;
        this.priority = priority;
        this.checker = null;
        this.systemPropertiesCheck = new HashMap<String, String>();
    }

    private Launchers(@NotNull int priority, String name, BiPredicate<String, String> checker) {
        this.name = name;
        this.possibleIdentifiers = new String[0];
        this.priority = priority;
        this.checker = checker;
        this.systemPropertiesCheck = new HashMap<String, String>();
    }

    private Launchers(int priority, String name, Map<String, String> systemPropertiesCheck) {
        this.name = name;
        this.possibleIdentifiers = new String[0];
        this.priority = priority;
        this.checker = null;
        this.systemPropertiesCheck = systemPropertiesCheck;
    }

    public String getName() {
        return this.name;
    }

    public boolean exists(Path minecraftDir) {
        for (String possiblePath : this.possibleIdentifiers) {
            LOGGER.info("[{}] Checking for launcher identifier at {}", (Object)this, (Object)minecraftDir.resolve(possiblePath));
            if (!Files.exists(minecraftDir.resolve(possiblePath), new LinkOption[0]) && !Files.isDirectory(minecraftDir.resolve(possiblePath), new LinkOption[0])) continue;
            LOGGER.info("Found launcher identifier: {}", (Object)possiblePath);
            return true;
        }
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    public static Launchers detectLauncher(Path gameDirectory, Map<String, String> startupArgs) {
        LOGGER.info("Detecting launcher at {}", (Object)gameDirectory);
        LOGGER.info("Startup args: {}", startupArgs);
        String version = startupArgs.getOrDefault("version", "unknown").toLowerCase();
        String assetsDir = startupArgs.getOrDefault("assetsDir", "").toLowerCase();
        for (Launchers value : VALUES) {
            if (value == UNKNOWN) continue;
            if (!value.systemPropertiesCheck.isEmpty()) {
                boolean found = false;
                for (Map.Entry<String, String> entry : value.systemPropertiesCheck.entrySet()) {
                    LOGGER.info("[{}] Checking for launcher at {}", (Object)entry.getKey(), (Object)entry.getValue());
                    String propValue = System.getProperty(entry.getKey(), "").toLowerCase();
                    if (entry.getValue().equals("EXISTS")) {
                        if (propValue.isEmpty()) continue;
                        found = true;
                        break;
                    }
                    if (!propValue.equals(entry.getValue().toLowerCase())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    return value;
                }
            }
            LOGGER.info("[{}] Checking for launcher at {} via validator", (Object)value.name(), (Object)version);
            if (value.checker != null && value.checker.test(version, assetsDir)) {
                return value;
            }
            LOGGER.info("[{}] Checking for launcher at {} via paths", (Object)value.name(), (Object)version);
            if (value.possibleIdentifiers.length <= 0 || !value.exists(gameDirectory)) continue;
            return value;
        }
        LOGGER.warn("Unable to find launcher, attempted {} known launchers, search within {}", (Object)Launchers.values().length, (Object)version);
        return UNKNOWN;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Launchers.class);
        VALUES = (Launchers[])Arrays.stream(Launchers.values()).sorted(Comparator.comparing(Launchers::getPriority).reversed()).toArray(Launchers[]::new);
    }
}

