/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.tasks.OptTask;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;
import oshi.PlatformEnum;
import oshi.SystemInfo;

public class AnonymousIdentification {
    private static final Path LEGACY_DATA_PATH = Path.of(System.getProperty("user.home") + "/.ftb", new String[0]);
    private static final Path LEGACY_IDENTITY_FILE = LEGACY_DATA_PATH.resolve("mods/ftbauxilium/identity.json");
    private static final Path LEGACY_OPT_OUT_FILE = LEGACY_DATA_PATH.resolve("mods/ftbauxilium/dont-track.flag");
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private final Path identityFile;
    private final Path optOutFlag;
    public UUID identifier;
    private boolean optedOut = false;

    public AnonymousIdentification() {
        Path dataPath = this.getDataPath();
        this.identityFile = dataPath.resolve("identity.json");
        this.optOutFlag = dataPath.resolve("dont-track.flag");
        this.identifier = this.getOrCreate();
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    private UUID getOrCreate() {
        this.attemptMigration();
        try {
            Path rootPath = this.identityFile.getParent();
            if (!Files.exists(rootPath, new LinkOption[0])) {
                Files.createDirectories(rootPath, new FileAttribute[0]);
            }
            if (Files.exists(this.optOutFlag, new LinkOption[0])) {
                this.optedOut = true;
            }
            if (!Files.exists(this.identityFile, new LinkOption[0])) {
                UUID uuid = UUID.randomUUID();
                JsonObject object = new JsonObject();
                object.addProperty("identifier", uuid.toString());
                String jsonObj = new Gson().toJson((JsonElement)object.getAsJsonObject());
                Files.writeString(this.identityFile, (CharSequence)jsonObj, StandardCharsets.UTF_8, new OpenOption[0]);
                return uuid;
            }
            JsonElement identity = JsonParser.parseString((String)Files.readString(this.identityFile));
            if (!identity.isJsonObject() || !identity.getAsJsonObject().has("identifier")) {
                this.tryRemoveCorruptedFile();
                return EMPTY_UUID;
            }
            return UUID.fromString(identity.getAsJsonObject().get("identifier").getAsString());
        }
        catch (IOException e) {
            FTBAuxilium.LOGGER.debug("Failed to read or create identity file", (Throwable)e);
            this.tryRemoveCorruptedFile();
            return EMPTY_UUID;
        }
    }

    public boolean optOut() {
        if (!Files.exists(this.optOutFlag, new LinkOption[0])) {
            try {
                Files.writeString(this.optOutFlag, (CharSequence)"You have been opted out of FTB auxilium. Remove this file if you would like to opt-in to the stats system.", new OpenOption[0]);
            }
            catch (IOException e) {
                return false;
            }
            Minecraft.getInstance().execute(() -> FTBAuxilium.runTask(new OptTask(true)));
            this.optedOut = true;
            return true;
        }
        return true;
    }

    public boolean optIn() {
        if (Files.exists(this.optOutFlag, new LinkOption[0])) {
            try {
                Files.deleteIfExists(this.optOutFlag);
            }
            catch (IOException e) {
                return false;
            }
            this.optedOut = false;
            Minecraft.getInstance().execute(() -> FTBAuxilium.runTask(new OptTask(false)));
            return true;
        }
        return true;
    }

    public boolean isOptedOut() {
        return this.optedOut;
    }

    private void tryRemoveCorruptedFile() {
        try {
            Files.deleteIfExists(this.identityFile);
        }
        catch (IOException e) {
            FTBAuxilium.LOGGER.debug("Failed to delete corrupted identity file", (Throwable)e);
        }
    }

    private void attemptMigration() {
        boolean shouldRemoveRoot = false;
        System.out.println(LEGACY_IDENTITY_FILE);
        System.out.println(LEGACY_OPT_OUT_FILE);
        try {
            Path rootPath;
            if (Files.exists(LEGACY_IDENTITY_FILE, new LinkOption[0])) {
                rootPath = this.identityFile.getParent();
                if (!Files.exists(rootPath, new LinkOption[0])) {
                    Files.createDirectories(rootPath, new FileAttribute[0]);
                }
                Files.move(LEGACY_IDENTITY_FILE, this.identityFile, new CopyOption[0]);
                FTBAuxilium.LOGGER.info("Migration complete.");
                shouldRemoveRoot = true;
            }
            if (Files.exists(LEGACY_OPT_OUT_FILE, new LinkOption[0])) {
                rootPath = this.optOutFlag.getParent();
                if (!Files.exists(rootPath, new LinkOption[0])) {
                    Files.createDirectories(rootPath, new FileAttribute[0]);
                }
                Files.move(LEGACY_OPT_OUT_FILE, this.optOutFlag, new CopyOption[0]);
                FTBAuxilium.LOGGER.info("Migration complete.");
                shouldRemoveRoot = true;
            }
        }
        catch (IOException e2) {
            FTBAuxilium.LOGGER.debug("Failed to migrate legacy identity files", (Throwable)e2);
        }
        if (!shouldRemoveRoot) {
            return;
        }
        try (Stream<Path> files = Files.list(LEGACY_DATA_PATH);){
            long actualFiles = files.filter(e -> !Files.isDirectory(e, new LinkOption[0]) && !e.getFileName().toString().equalsIgnoreCase(".ds_store")).count();
            if (actualFiles == 0L) {
                FileUtils.deleteDirectory((File)LEGACY_DATA_PATH.toFile());
                FTBAuxilium.LOGGER.info("Removed legacy .ftb directory");
            }
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private Path getDataPath() {
        PlatformEnum os = SystemInfo.getCurrentPlatform();
        return switch (os) {
            case PlatformEnum.WINDOWS, PlatformEnum.WINDOWSCE -> Paths.get(System.getenv("APPDATA"), ".ftb", "mods", "ftbauxilium");
            case PlatformEnum.MACOS -> Paths.get(System.getProperty("user.home"), "Library", "Application Support", "ftb", "mods", "ftbauxilium");
            case PlatformEnum.LINUX -> {
                String xdgDataHome = System.getenv("XDG_DATA_HOME");
                if (xdgDataHome != null && !xdgDataHome.isEmpty()) {
                    yield Paths.get(xdgDataHome, "ftb", "mods", "ftbauxilium");
                }
                yield Paths.get(System.getProperty("user.home"), ".local", "share", "ftb", "mods", "ftbauxilium");
            }
            default -> Paths.get(System.getProperty("user.home"), ".ftb", "mods", "ftbauxilium");
        };
    }
}

