/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.auxilium.ModpackData;
import dev.ftb.mods.ftbauxilium.auxilium.SessionCollector;
import dev.ftb.mods.ftbauxilium.auxilium.StatManager;
import dev.ftb.mods.ftbauxilium.auxilium.SystemStats;
import dev.ftb.mods.ftbauxilium.tasks.OptTask;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiManager {
    private static final String BASE_URL = "https://auxilium.ftb.team/";
    private static final String CLIENT_API_VERSION = "1.1.0";
    private static final ApiManager INSTANCE;
    private static final Logger LOGGER;
    private static final HttpClient HTTP_CLIENT;

    private ApiManager() {
    }

    public static ApiManager get() {
        return INSTANCE;
    }

    public boolean systemStarted(SystemStats stats) {
        PostRequest request = new PostRequest("system", stats);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to send system info to the api");
            return false;
        }
        LOGGER.debug("System info successfully posted to the api");
        return true;
    }

    public boolean modpackData(ModpackData data) {
        PostRequest request = new PostRequest("modpack", data);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to send mod pack data");
            return false;
        }
        LOGGER.debug("Mod pack data successfully posted to the api");
        return true;
    }

    @Nullable
    public String startSession() {
        PostRequest request = new PostRequest("session/start");
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful || !response.has("sessionId")) {
            LOGGER.debug("Failed to fetch a valid session");
            return null;
        }
        LOGGER.debug("API Session has been started");
        return response.get("sessionId").getAsString();
    }

    public void endSession(SessionCollector data) {
        PostRequest request = new PostRequest("session/stop", data);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to send session data");
            return;
        }
        LOGGER.debug("API Session has been ended");
    }

    public void sendCrashReport(String report) {
        CrashWrapper crashBody = new CrashWrapper(report);
        if (crashBody.dontPost()) {
            return;
        }
        PostRequest request = new PostRequest("crashes", crashBody);
        request.post();
    }

    public boolean optOut(OptTask.JustPackData packData) {
        PostRequest request = new PostRequest("opt-out", packData);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to opt out");
            return false;
        }
        LOGGER.debug("User was opted out");
        return true;
    }

    public boolean optIn(OptTask.JustPackData packData) {
        PostRequest request = new PostRequest("opt-in", packData);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to opt in");
            return false;
        }
        LOGGER.debug("User was opted in");
        return true;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ApiManager.class);
        HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(60L)).build();
        INSTANCE = new ApiManager();
    }

    public static class PostRequest {
        public String url;
        public Object body;
        public boolean wasSuccessful = false;
        public JsonObject response;

        public PostRequest(String url, @Nullable Object body) {
            this.body = body;
            this.url = url;
        }

        public PostRequest(String url) {
            this(url, null);
        }

        @Nullable
        public JsonObject post() {
            UUID id = StatManager.identifier().getIdentifier();
            try {
                String bodyPayload = this.body != null ? new Gson().toJson(this.body) : "";
                HttpResponse<String> requestResponse = HTTP_CLIENT.send(HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(bodyPayload)).uri(URI.create(ApiManager.BASE_URL + this.url)).header("content-type", "application/json").header("authorization", "Bearer " + String.valueOf(id)).header("user-agent", "FTBAuxilium/%s".formatted(ApiManager.CLIENT_API_VERSION)).build(), HttpResponse.BodyHandlers.ofString());
                if (requestResponse.statusCode() == 404 || requestResponse.statusCode() == 403) {
                    LOGGER.debug("Request rejected from server at {}", (Object)this.url);
                    return null;
                }
                try {
                    String reqBody = requestResponse.body();
                    if (reqBody == null) {
                        LOGGER.debug("Failed to get response body from {}", (Object)this.url);
                        return null;
                    }
                    JsonElement parse = JsonParser.parseString((String)reqBody);
                    this.response = parse.getAsJsonObject();
                    this.wasSuccessful = this.response.has("success") && this.response.get("success").getAsBoolean();
                    LOGGER.debug("Successful post response from {}", (Object)this.url);
                    return this.response;
                }
                catch (JsonParseException exception) {
                    this.wasSuccessful = false;
                    LOGGER.debug("Failed to parse json response from {}", (Object)this.url);
                    return null;
                }
            }
            catch (IOException | InterruptedException e) {
                this.wasSuccessful = false;
                LOGGER.debug("Failed to make request due to", (Throwable)e);
                return null;
            }
        }
    }

    public static class CrashWrapper {
        private static final String MANUAL_CRASH_MARKER = "Manually triggered debug crash";
        private boolean dontPost = false;
        public String crashData;
        public int packId;
        public int packVersion;

        public CrashWrapper(String crashData) {
            this.crashData = this.filterCrashData(crashData);
            ModpackData packData = FTBAuxilium.STAT_MANAGER.getPackData();
            if (packData != null && packData.id != -1 && packData.versionId != -1) {
                this.packId = packData.id;
                this.packVersion = packData.versionId;
            }
        }

        private String filterCrashData(String data) {
            if (data.contains(MANUAL_CRASH_MARKER)) {
                this.dontPost = true;
                return "Crash report not sent: Manually triggered debug crash.";
            }
            String userHome = System.getProperty("user.home");
            data = data.replace(userHome, "[USER_HOME]");
            return data;
        }

        public boolean dontPost() {
            return this.dontPost;
        }
    }
}

