/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type.text;

import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.TextFormatter;

public class StorageFormatter
implements TextFormatter {
    private static boolean SHOW_MEASUREMENTS = false;
    private static final int UNIT = 1024;
    public static StorageFormatter INSTANCE = new StorageFormatter();

    @Override
    public Component apply(Component component) {
        return TextFormatter.processComponent(component, content -> {
            long bytesMax;
            long bytesUsed;
            String[] args = content.split("/");
            if (args.length != 2) {
                return content;
            }
            if (args[0].isEmpty() || args[1].isEmpty()) {
                return content;
            }
            try {
                bytesUsed = Long.parseLong(args[0]);
                bytesMax = Long.parseLong(args[1]);
            }
            catch (NumberFormatException e) {
                return content;
            }
            double percentage = (double)bytesUsed / (double)bytesMax * 100.0;
            if (!SHOW_MEASUREMENTS) {
                return StorageFormatter.formatPercentage(percentage);
            }
            return StorageFormatter.formatBytes(bytesUsed) + " / " + StorageFormatter.formatBytes(bytesMax) + " (" + StorageFormatter.formatPercentage(percentage) + ")";
        });
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        char prefix = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), Character.valueOf(prefix));
    }

    private static String formatPercentage(double percentage) {
        return String.format("%.2f%%", percentage);
    }
}

